-- <?php exit; __halt_compiler(); // Protect the file from being visited via web
-- Orion backup format

DROP TABLE IF EXISTS `wp_79e54b1ec2_commentmeta`;

CREATE TABLE `wp_79e54b1ec2_commentmeta` (
  `meta_id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `comment_id` bigint unsigned NOT NULL DEFAULT '0',
  `meta_key` varchar(255) COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `meta_value` longtext COLLATE utf8mb4_unicode_520_ci,
  PRIMARY KEY (`meta_id`),
  KEY `comment_id` (`comment_id`),
  KEY `meta_key` (`meta_key`(191))
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

-- <?php exit; __halt_compiler(); // Protect the file from being visited via web
-- Orion backup format

DROP TABLE IF EXISTS `wp_79e54b1ec2_comments`;

CREATE TABLE `wp_79e54b1ec2_comments` (
  `comment_ID` bigint unsigned NOT NULL AUTO_INCREMENT,
  `comment_post_ID` bigint unsigned NOT NULL DEFAULT '0',
  `comment_author` tinytext COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `comment_author_email` varchar(100) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `comment_author_url` varchar(200) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `comment_author_IP` varchar(100) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `comment_date` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `comment_date_gmt` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `comment_content` text COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `comment_karma` int NOT NULL DEFAULT '0',
  `comment_approved` varchar(20) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '1',
  `comment_agent` varchar(255) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `comment_type` varchar(20) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT 'comment',
  `comment_parent` bigint unsigned NOT NULL DEFAULT '0',
  `user_id` bigint unsigned NOT NULL DEFAULT '0',
  PRIMARY KEY (`comment_ID`),
  KEY `comment_post_ID` (`comment_post_ID`),
  KEY `comment_approved_date_gmt` (`comment_approved`,`comment_date_gmt`),
  KEY `comment_date_gmt` (`comment_date_gmt`),
  KEY `comment_parent` (`comment_parent`),
  KEY `comment_author_email` (`comment_author_email`(10))
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

-- <?php exit; __halt_compiler(); // Protect the file from being visited via web
-- Orion backup format

DROP TABLE IF EXISTS `wp_79e54b1ec2_e_events`;

CREATE TABLE `wp_79e54b1ec2_e_events` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `event_data` text COLLATE utf8mb4_unicode_520_ci,
  `created_at` datetime NOT NULL,
  PRIMARY KEY (`id`),
  KEY `created_at_index` (`created_at`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

-- <?php exit; __halt_compiler(); // Protect the file from being visited via web
-- Orion backup format

DROP TABLE IF EXISTS `wp_79e54b1ec2_e_submissions`;

CREATE TABLE `wp_79e54b1ec2_e_submissions` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `type` varchar(60) COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `hash_id` varchar(60) COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `main_meta_id` bigint unsigned NOT NULL COMMENT 'Id of main field. to represent the main meta field',
  `post_id` bigint unsigned NOT NULL,
  `referer` varchar(500) COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `referer_title` varchar(300) COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `element_id` varchar(20) COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `form_name` varchar(60) COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `campaign_id` bigint unsigned NOT NULL,
  `user_id` bigint unsigned DEFAULT NULL,
  `user_ip` varchar(46) COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `user_agent` text COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `actions_count` int DEFAULT '0',
  `actions_succeeded_count` int DEFAULT '0',
  `status` varchar(20) COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `is_read` tinyint(1) NOT NULL DEFAULT '0',
  `meta` text COLLATE utf8mb4_unicode_520_ci,
  `created_at_gmt` datetime NOT NULL,
  `updated_at_gmt` datetime NOT NULL,
  `created_at` datetime NOT NULL,
  `updated_at` datetime NOT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `hash_id_unique_index` (`hash_id`),
  KEY `main_meta_id_index` (`main_meta_id`),
  KEY `hash_id_index` (`hash_id`),
  KEY `type_index` (`type`),
  KEY `post_id_index` (`post_id`),
  KEY `element_id_index` (`element_id`),
  KEY `campaign_id_index` (`campaign_id`),
  KEY `user_id_index` (`user_id`),
  KEY `user_ip_index` (`user_ip`),
  KEY `status_index` (`status`),
  KEY `is_read_index` (`is_read`),
  KEY `created_at_gmt_index` (`created_at_gmt`),
  KEY `updated_at_gmt_index` (`updated_at_gmt`),
  KEY `created_at_index` (`created_at`),
  KEY `updated_at_index` (`updated_at`),
  KEY `referer_index` (`referer`(191)),
  KEY `referer_title_index` (`referer_title`(191))
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

-- <?php exit; __halt_compiler(); // Protect the file from being visited via web
-- Orion backup format

DROP TABLE IF EXISTS `wp_79e54b1ec2_e_submissions_actions_log`;

CREATE TABLE `wp_79e54b1ec2_e_submissions_actions_log` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `submission_id` bigint unsigned NOT NULL,
  `action_name` varchar(60) COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `action_label` varchar(60) COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `status` varchar(20) COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `log` text COLLATE utf8mb4_unicode_520_ci,
  `created_at_gmt` datetime NOT NULL,
  `updated_at_gmt` datetime NOT NULL,
  `created_at` datetime NOT NULL,
  `updated_at` datetime NOT NULL,
  PRIMARY KEY (`id`),
  KEY `submission_id_index` (`submission_id`),
  KEY `action_name_index` (`action_name`),
  KEY `status_index` (`status`),
  KEY `created_at_gmt_index` (`created_at_gmt`),
  KEY `updated_at_gmt_index` (`updated_at_gmt`),
  KEY `created_at_index` (`created_at`),
  KEY `updated_at_index` (`updated_at`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

-- <?php exit; __halt_compiler(); // Protect the file from being visited via web
-- Orion backup format

DROP TABLE IF EXISTS `wp_79e54b1ec2_e_submissions_values`;

CREATE TABLE `wp_79e54b1ec2_e_submissions_values` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `submission_id` bigint unsigned NOT NULL DEFAULT '0',
  `key` varchar(60) COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `value` longtext COLLATE utf8mb4_unicode_520_ci,
  PRIMARY KEY (`id`),
  KEY `submission_id_index` (`submission_id`),
  KEY `key_index` (`key`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

-- <?php exit; __halt_compiler(); // Protect the file from being visited via web
-- Orion backup format

DROP TABLE IF EXISTS `wp_79e54b1ec2_links`;

CREATE TABLE `wp_79e54b1ec2_links` (
  `link_id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `link_url` varchar(255) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `link_name` varchar(255) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `link_image` varchar(255) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `link_target` varchar(25) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `link_description` varchar(255) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `link_visible` varchar(20) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT 'Y',
  `link_owner` bigint unsigned NOT NULL DEFAULT '1',
  `link_rating` int NOT NULL DEFAULT '0',
  `link_updated` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `link_rel` varchar(255) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `link_notes` mediumtext COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `link_rss` varchar(255) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  PRIMARY KEY (`link_id`),
  KEY `link_visible` (`link_visible`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

-- <?php exit; __halt_compiler(); // Protect the file from being visited via web
-- Orion backup format

DROP TABLE IF EXISTS `wp_79e54b1ec2_options`;

CREATE TABLE `wp_79e54b1ec2_options` (
  `option_id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `option_name` varchar(191) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `option_value` longtext COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `autoload` varchar(20) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT 'yes',
  PRIMARY KEY (`option_id`),
  UNIQUE KEY `option_name` (`option_name`),
  KEY `autoload` (`autoload`)
) ENGINE=InnoDB AUTO_INCREMENT=45548 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

INSERT INTO `wp_79e54b1ec2_options` VALUES ('1','cron','a:19:{i:1764200541;a:1:{s:28:\"objectcache_metrics_snapshot\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:18:\"every_five_minutes\";s:4:\"args\";a:0:{}s:8:\"interval\";i:300;}}}i:1764202041;a:1:{s:27:\"objectcache_prune_analytics\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:6:\"hourly\";s:4:\"args\";a:0:{}s:8:\"interval\";i:3600;}}}i:1764203772;a:1:{s:34:\"wp_privacy_delete_old_export_files\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:6:\"hourly\";s:4:\"args\";a:0:{}s:8:\"interval\";i:3600;}}}i:1764230905;a:1:{s:21:\"wp_update_user_counts\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:10:\"twicedaily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:43200;}}}i:1764236158;a:1:{s:16:\"wp_version_check\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:10:\"twicedaily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:43200;}}}i:1764237958;a:1:{s:17:\"wp_update_plugins\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:10:\"twicedaily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:43200;}}}i:1764239758;a:1:{s:16:\"wp_update_themes\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:10:\"twicedaily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:43200;}}}i:1764271963;a:1:{s:26:\"pum_daily_scheduled_events\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:5:\"daily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:86400;}}}i:1764274105;a:2:{s:19:\"wp_scheduled_delete\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:5:\"daily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:86400;}}s:25:\"delete_expired_transients\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:5:\"daily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:86400;}}}i:1764274107;a:1:{s:30:\"wp_scheduled_auto_draft_delete\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:5:\"daily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:86400;}}}i:1764275772;a:2:{s:27:\"wpaas_ua_check_record_count\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:5:\"daily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:86400;}}s:32:\"recovery_mode_clean_expired_keys\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:5:\"daily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:86400;}}}i:1764275824;a:1:{s:22:\"mwp_update_public_keys\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:5:\"daily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:86400;}}}i:1764283820;a:1:{s:28:\"elementor/tracker/send_event\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:5:\"daily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:86400;}}}i:1764362224;a:1:{s:31:\"wpaas_smart_update_cleanup_hook\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:16:\"two_days_seconds\";s:4:\"args\";a:0:{}s:8:\"interval\";i:172800;}}}i:1764707772;a:1:{s:30:\"wp_delete_temp_updater_backups\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:6:\"weekly\";s:4:\"args\";a:0:{}s:8:\"interval\";i:604800;}}}i:1764790318;a:1:{s:32:\"popup_maker_license_status_check\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:6:\"weekly\";s:4:\"args\";a:0:{}s:8:\"interval\";i:604800;}}}i:1764790363;a:1:{s:27:\"pum_weekly_scheduled_events\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:6:\"weekly\";s:4:\"args\";a:0:{}s:8:\"interval\";i:604800;}}}i:1764794172;a:1:{s:30:\"wp_site_health_scheduled_check\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:6:\"weekly\";s:4:\"args\";a:0:{}s:8:\"interval\";i:604800;}}}s:7:\"version\";i:2;}','on');
INSERT INTO `wp_79e54b1ec2_options` VALUES ('2','siteurl','https://57r.860.myftpupload.com','on');
INSERT INTO `wp_79e54b1ec2_options` VALUES ('3','home','https://57r.860.myftpupload.com','on');
INSERT INTO `wp_79e54b1ec2_options` VALUES ('4','blogname','','on');
INSERT INTO `wp_79e54b1ec2_options` VALUES ('5','blogdescription','','on');
INSERT INTO `wp_79e54b1ec2_options` VALUES ('6','users_can_register','0','on');
INSERT INTO `wp_79e54b1ec2_options` VALUES ('7','admin_email','ryan@milestonemarketinggroup.com','on');
INSERT INTO `wp_79e54b1ec2_options` VALUES ('8','start_of_week','1','on');
INSERT INTO `wp_79e54b1ec2_options` VALUES ('9','use_balanceTags','0','on');
INSERT INTO `wp_79e54b1ec2_options` VALUES ('10','use_smilies','1','on');
INSERT INTO `wp_79e54b1ec2_options` VALUES ('11','require_name_email','1','on');
INSERT INTO `wp_79e54b1ec2_options` VALUES ('12','comments_notify','1','on');
INSERT INTO `wp_79e54b1ec2_options` VALUES ('13','posts_per_rss','10','on');
INSERT INTO `wp_79e54b1ec2_options` VALUES ('14','rss_use_excerpt','0','on');
INSERT INTO `wp_79e54b1ec2_options` VALUES ('15','mailserver_url','mail.example.com','on');
INSERT INTO `wp_79e54b1ec2_options` VALUES ('16','mailserver_login','login@example.com','on');
INSERT INTO `wp_79e54b1ec2_options` VALUES ('17','mailserver_pass','','on');
INSERT INTO `wp_79e54b1ec2_options` VALUES ('18','mailserver_port','110','on');
INSERT INTO `wp_79e54b1ec2_options` VALUES ('19','default_category','1','on');
INSERT INTO `wp_79e54b1ec2_options` VALUES ('20','default_comment_status','open','on');
INSERT INTO `wp_79e54b1ec2_options` VALUES ('21','default_ping_status','open','on');
INSERT INTO `wp_79e54b1ec2_options` VALUES ('22','default_pingback_flag','1','on');
INSERT INTO `wp_79e54b1ec2_options` VALUES ('23','posts_per_page','10','on');
INSERT INTO `wp_79e54b1ec2_options` VALUES ('24','date_format','F j, Y','on');
INSERT INTO `wp_79e54b1ec2_options` VALUES ('25','time_format','g:i a','on');
INSERT INTO `wp_79e54b1ec2_options` VALUES ('26','links_updated_date_format','F j, Y g:i a','on');
INSERT INTO `wp_79e54b1ec2_options` VALUES ('27','comment_moderation','0','on');
INSERT INTO `wp_79e54b1ec2_options` VALUES ('28','moderation_notify','1','on');
INSERT INTO `wp_79e54b1ec2_options` VALUES ('29','permalink_structure','/%postname%/','on');
INSERT INTO `wp_79e54b1ec2_options` VALUES ('30','rewrite_rules','a:134:{s:11:\"^wp-json/?$\";s:22:\"index.php?rest_route=/\";s:14:\"^wp-json/(.*)?\";s:33:\"index.php?rest_route=/$matches[1]\";s:21:\"^index.php/wp-json/?$\";s:22:\"index.php?rest_route=/\";s:24:\"^index.php/wp-json/(.*)?\";s:33:\"index.php?rest_route=/$matches[1]\";s:17:\"^wp-sitemap\\.xml$\";s:23:\"index.php?sitemap=index\";s:17:\"^wp-sitemap\\.xsl$\";s:36:\"index.php?sitemap-stylesheet=sitemap\";s:23:\"^wp-sitemap-index\\.xsl$\";s:34:\"index.php?sitemap-stylesheet=index\";s:48:\"^wp-sitemap-([a-z]+?)-([a-z\\d_-]+?)-(\\d+?)\\.xml$\";s:75:\"index.php?sitemap=$matches[1]&sitemap-subtype=$matches[2]&paged=$matches[3]\";s:34:\"^wp-sitemap-([a-z]+?)-(\\d+?)\\.xml$\";s:47:\"index.php?sitemap=$matches[1]&paged=$matches[2]\";s:47:\"category/(.+?)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:52:\"index.php?category_name=$matches[1]&feed=$matches[2]\";s:42:\"category/(.+?)/(feed|rdf|rss|rss2|atom)/?$\";s:52:\"index.php?category_name=$matches[1]&feed=$matches[2]\";s:23:\"category/(.+?)/embed/?$\";s:46:\"index.php?category_name=$matches[1]&embed=true\";s:35:\"category/(.+?)/page/?([0-9]{1,})/?$\";s:53:\"index.php?category_name=$matches[1]&paged=$matches[2]\";s:17:\"category/(.+?)/?$\";s:35:\"index.php?category_name=$matches[1]\";s:44:\"tag/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:42:\"index.php?tag=$matches[1]&feed=$matches[2]\";s:39:\"tag/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:42:\"index.php?tag=$matches[1]&feed=$matches[2]\";s:20:\"tag/([^/]+)/embed/?$\";s:36:\"index.php?tag=$matches[1]&embed=true\";s:32:\"tag/([^/]+)/page/?([0-9]{1,})/?$\";s:43:\"index.php?tag=$matches[1]&paged=$matches[2]\";s:14:\"tag/([^/]+)/?$\";s:25:\"index.php?tag=$matches[1]\";s:45:\"type/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:50:\"index.php?post_format=$matches[1]&feed=$matches[2]\";s:40:\"type/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:50:\"index.php?post_format=$matches[1]&feed=$matches[2]\";s:21:\"type/([^/]+)/embed/?$\";s:44:\"index.php?post_format=$matches[1]&embed=true\";s:33:\"type/([^/]+)/page/?([0-9]{1,})/?$\";s:51:\"index.php?post_format=$matches[1]&paged=$matches[2]\";s:15:\"type/([^/]+)/?$\";s:33:\"index.php?post_format=$matches[1]\";s:46:\"e-floating-buttons/[^/]+/attachment/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:56:\"e-floating-buttons/[^/]+/attachment/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:76:\"e-floating-buttons/[^/]+/attachment/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:71:\"e-floating-buttons/[^/]+/attachment/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:71:\"e-floating-buttons/[^/]+/attachment/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:52:\"e-floating-buttons/[^/]+/attachment/([^/]+)/embed/?$\";s:43:\"index.php?attachment=$matches[1]&embed=true\";s:35:\"e-floating-buttons/([^/]+)/embed/?$\";s:51:\"index.php?e-floating-buttons=$matches[1]&embed=true\";s:39:\"e-floating-buttons/([^/]+)/trackback/?$\";s:45:\"index.php?e-floating-buttons=$matches[1]&tb=1\";s:47:\"e-floating-buttons/([^/]+)/page/?([0-9]{1,})/?$\";s:58:\"index.php?e-floating-buttons=$matches[1]&paged=$matches[2]\";s:54:\"e-floating-buttons/([^/]+)/comment-page-([0-9]{1,})/?$\";s:58:\"index.php?e-floating-buttons=$matches[1]&cpage=$matches[2]\";s:43:\"e-floating-buttons/([^/]+)(?:/([0-9]+))?/?$\";s:57:\"index.php?e-floating-buttons=$matches[1]&page=$matches[2]\";s:35:\"e-floating-buttons/[^/]+/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:45:\"e-floating-buttons/[^/]+/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:65:\"e-floating-buttons/[^/]+/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:60:\"e-floating-buttons/[^/]+/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:60:\"e-floating-buttons/[^/]+/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:41:\"e-floating-buttons/[^/]+/([^/]+)/embed/?$\";s:43:\"index.php?attachment=$matches[1]&embed=true\";s:45:\"elementskit-content/.+?/attachment/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:55:\"elementskit-content/.+?/attachment/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:75:\"elementskit-content/.+?/attachment/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:70:\"elementskit-content/.+?/attachment/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:70:\"elementskit-content/.+?/attachment/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:51:\"elementskit-content/.+?/attachment/([^/]+)/embed/?$\";s:43:\"index.php?attachment=$matches[1]&embed=true\";s:34:\"elementskit-content/(.+?)/embed/?$\";s:52:\"index.php?elementskit_content=$matches[1]&embed=true\";s:38:\"elementskit-content/(.+?)/trackback/?$\";s:46:\"index.php?elementskit_content=$matches[1]&tb=1\";s:46:\"elementskit-content/(.+?)/page/?([0-9]{1,})/?$\";s:59:\"index.php?elementskit_content=$matches[1]&paged=$matches[2]\";s:53:\"elementskit-content/(.+?)/comment-page-([0-9]{1,})/?$\";s:59:\"index.php?elementskit_content=$matches[1]&cpage=$matches[2]\";s:42:\"elementskit-content/(.+?)(?:/([0-9]+))?/?$\";s:58:\"index.php?elementskit_content=$matches[1]&page=$matches[2]\";s:38:\"metform-form/.+?/attachment/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:48:\"metform-form/.+?/attachment/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:68:\"metform-form/.+?/attachment/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:63:\"metform-form/.+?/attachment/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:63:\"metform-form/.+?/attachment/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:44:\"metform-form/.+?/attachment/([^/]+)/embed/?$\";s:43:\"index.php?attachment=$matches[1]&embed=true\";s:27:\"metform-form/(.+?)/embed/?$\";s:45:\"index.php?metform-form=$matches[1]&embed=true\";s:31:\"metform-form/(.+?)/trackback/?$\";s:39:\"index.php?metform-form=$matches[1]&tb=1\";s:39:\"metform-form/(.+?)/page/?([0-9]{1,})/?$\";s:52:\"index.php?metform-form=$matches[1]&paged=$matches[2]\";s:46:\"metform-form/(.+?)/comment-page-([0-9]{1,})/?$\";s:52:\"index.php?metform-form=$matches[1]&cpage=$matches[2]\";s:35:\"metform-form/(.+?)(?:/([0-9]+))?/?$\";s:51:\"index.php?metform-form=$matches[1]&page=$matches[2]\";s:12:\"robots\\.txt$\";s:18:\"index.php?robots=1\";s:13:\"favicon\\.ico$\";s:19:\"index.php?favicon=1\";s:12:\"sitemap\\.xml\";s:24:\"index.php??sitemap=index\";s:48:\".*wp-(atom|rdf|rss|rss2|feed|commentsrss2)\\.php$\";s:18:\"index.php?feed=old\";s:20:\".*wp-app\\.php(/.*)?$\";s:19:\"index.php?error=403\";s:18:\".*wp-register.php$\";s:23:\"index.php?register=true\";s:32:\"feed/(feed|rdf|rss|rss2|atom)/?$\";s:27:\"index.php?&feed=$matches[1]\";s:27:\"(feed|rdf|rss|rss2|atom)/?$\";s:27:\"index.php?&feed=$matches[1]\";s:8:\"embed/?$\";s:21:\"index.php?&embed=true\";s:20:\"page/?([0-9]{1,})/?$\";s:28:\"index.php?&paged=$matches[1]\";s:27:\"comment-page-([0-9]{1,})/?$\";s:40:\"index.php?&page_id=364&cpage=$matches[1]\";s:41:\"comments/feed/(feed|rdf|rss|rss2|atom)/?$\";s:42:\"index.php?&feed=$matches[1]&withcomments=1\";s:36:\"comments/(feed|rdf|rss|rss2|atom)/?$\";s:42:\"index.php?&feed=$matches[1]&withcomments=1\";s:17:\"comments/embed/?$\";s:21:\"index.php?&embed=true\";s:44:\"search/(.+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:40:\"index.php?s=$matches[1]&feed=$matches[2]\";s:39:\"search/(.+)/(feed|rdf|rss|rss2|atom)/?$\";s:40:\"index.php?s=$matches[1]&feed=$matches[2]\";s:20:\"search/(.+)/embed/?$\";s:34:\"index.php?s=$matches[1]&embed=true\";s:32:\"search/(.+)/page/?([0-9]{1,})/?$\";s:41:\"index.php?s=$matches[1]&paged=$matches[2]\";s:14:\"search/(.+)/?$\";s:23:\"index.php?s=$matches[1]\";s:47:\"author/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:50:\"index.php?author_name=$matches[1]&feed=$matches[2]\";s:42:\"author/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:50:\"index.php?author_name=$matches[1]&feed=$matches[2]\";s:23:\"author/([^/]+)/embed/?$\";s:44:\"index.php?author_name=$matches[1]&embed=true\";s:35:\"author/([^/]+)/page/?([0-9]{1,})/?$\";s:51:\"index.php?author_name=$matches[1]&paged=$matches[2]\";s:17:\"author/([^/]+)/?$\";s:33:\"index.php?author_name=$matches[1]\";s:69:\"([0-9]{4})/([0-9]{1,2})/([0-9]{1,2})/feed/(feed|rdf|rss|rss2|atom)/?$\";s:80:\"index.php?year=$matches[1]&monthnum=$matches[2]&day=$matches[3]&feed=$matches[4]\";s:64:\"([0-9]{4})/([0-9]{1,2})/([0-9]{1,2})/(feed|rdf|rss|rss2|atom)/?$\";s:80:\"index.php?year=$matches[1]&monthnum=$matches[2]&day=$matches[3]&feed=$matches[4]\";s:45:\"([0-9]{4})/([0-9]{1,2})/([0-9]{1,2})/embed/?$\";s:74:\"index.php?year=$matches[1]&monthnum=$matches[2]&day=$matches[3]&embed=true\";s:57:\"([0-9]{4})/([0-9]{1,2})/([0-9]{1,2})/page/?([0-9]{1,})/?$\";s:81:\"index.php?year=$matches[1]&monthnum=$matches[2]&day=$matches[3]&paged=$matches[4]\";s:39:\"([0-9]{4})/([0-9]{1,2})/([0-9]{1,2})/?$\";s:63:\"index.php?year=$matches[1]&monthnum=$matches[2]&day=$matches[3]\";s:56:\"([0-9]{4})/([0-9]{1,2})/feed/(feed|rdf|rss|rss2|atom)/?$\";s:64:\"index.php?year=$matches[1]&monthnum=$matches[2]&feed=$matches[3]\";s:51:\"([0-9]{4})/([0-9]{1,2})/(feed|rdf|rss|rss2|atom)/?$\";s:64:\"index.php?year=$matches[1]&monthnum=$matches[2]&feed=$matches[3]\";s:32:\"([0-9]{4})/([0-9]{1,2})/embed/?$\";s:58:\"index.php?year=$matches[1]&monthnum=$matches[2]&embed=true\";s:44:\"([0-9]{4})/([0-9]{1,2})/page/?([0-9]{1,})/?$\";s:65:\"index.php?year=$matches[1]&monthnum=$matches[2]&paged=$matches[3]\";s:26:\"([0-9]{4})/([0-9]{1,2})/?$\";s:47:\"index.php?year=$matches[1]&monthnum=$matches[2]\";s:43:\"([0-9]{4})/feed/(feed|rdf|rss|rss2|atom)/?$\";s:43:\"index.php?year=$matches[1]&feed=$matches[2]\";s:38:\"([0-9]{4})/(feed|rdf|rss|rss2|atom)/?$\";s:43:\"index.php?year=$matches[1]&feed=$matches[2]\";s:19:\"([0-9]{4})/embed/?$\";s:37:\"index.php?year=$matches[1]&embed=true\";s:31:\"([0-9]{4})/page/?([0-9]{1,})/?$\";s:44:\"index.php?year=$matches[1]&paged=$matches[2]\";s:13:\"([0-9]{4})/?$\";s:26:\"index.php?year=$matches[1]\";s:27:\".?.+?/attachment/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:37:\".?.+?/attachment/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:57:\".?.+?/attachment/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:52:\".?.+?/attachment/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:52:\".?.+?/attachment/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:33:\".?.+?/attachment/([^/]+)/embed/?$\";s:43:\"index.php?attachment=$matches[1]&embed=true\";s:16:\"(.?.+?)/embed/?$\";s:41:\"index.php?pagename=$matches[1]&embed=true\";s:20:\"(.?.+?)/trackback/?$\";s:35:\"index.php?pagename=$matches[1]&tb=1\";s:40:\"(.?.+?)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:47:\"index.php?pagename=$matches[1]&feed=$matches[2]\";s:35:\"(.?.+?)/(feed|rdf|rss|rss2|atom)/?$\";s:47:\"index.php?pagename=$matches[1]&feed=$matches[2]\";s:28:\"(.?.+?)/page/?([0-9]{1,})/?$\";s:48:\"index.php?pagename=$matches[1]&paged=$matches[2]\";s:35:\"(.?.+?)/comment-page-([0-9]{1,})/?$\";s:48:\"index.php?pagename=$matches[1]&cpage=$matches[2]\";s:24:\"(.?.+?)(?:/([0-9]+))?/?$\";s:47:\"index.php?pagename=$matches[1]&page=$matches[2]\";s:27:\"[^/]+/attachment/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:37:\"[^/]+/attachment/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:57:\"[^/]+/attachment/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:52:\"[^/]+/attachment/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:52:\"[^/]+/attachment/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:33:\"[^/]+/attachment/([^/]+)/embed/?$\";s:43:\"index.php?attachment=$matches[1]&embed=true\";s:16:\"([^/]+)/embed/?$\";s:37:\"index.php?name=$matches[1]&embed=true\";s:20:\"([^/]+)/trackback/?$\";s:31:\"index.php?name=$matches[1]&tb=1\";s:40:\"([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:43:\"index.php?name=$matches[1]&feed=$matches[2]\";s:35:\"([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:43:\"index.php?name=$matches[1]&feed=$matches[2]\";s:28:\"([^/]+)/page/?([0-9]{1,})/?$\";s:44:\"index.php?name=$matches[1]&paged=$matches[2]\";s:35:\"([^/]+)/comment-page-([0-9]{1,})/?$\";s:44:\"index.php?name=$matches[1]&cpage=$matches[2]\";s:24:\"([^/]+)(?:/([0-9]+))?/?$\";s:43:\"index.php?name=$matches[1]&page=$matches[2]\";s:16:\"[^/]+/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:26:\"[^/]+/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:46:\"[^/]+/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:41:\"[^/]+/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:41:\"[^/]+/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:22:\"[^/]+/([^/]+)/embed/?$\";s:43:\"index.php?attachment=$matches[1]&embed=true\";}','on');
INSERT INTO `wp_79e54b1ec2_options` VALUES ('31','hack_file','0','on');
INSERT INTO `wp_79e54b1ec2_options` VALUES ('32','blog_charset','UTF-8','on');
INSERT INTO `wp_79e54b1ec2_options` VALUES ('33','moderation_keys','','off');
INSERT INTO `wp_79e54b1ec2_options` VALUES ('34','active_plugins','a:12:{i:0;s:19:\"akismet/akismet.php\";i:1;s:31:\"elementor-pro/elementor-pro.php\";i:2;s:23:\"elementor/elementor.php\";i:3;s:37:\"elementskit-lite/elementskit-lite.php\";i:4;s:45:\"httpsd2-cache-engine/httpsd2-cache-engine.php\";i:5;s:19:\"metform/metform.php\";i:6;s:27:\"popup-maker/popup-maker.php\";i:7;s:73:\"skyboot-custom-icons-for-elementor/skyboot-custom-icons-for-elementor.php\";i:8;s:43:\"template-kit-import/template-kit-import.php\";i:9;s:23:\"wp-compat/wp-compat.php\";i:10;s:25:\"wp-default/wp-default.php\";i:11;s:61:\"wp-reviews-plugin-for-google/wp-reviews-plugin-for-google.php\";}','on');
INSERT INTO `wp_79e54b1ec2_options` VALUES ('35','category_base','','on');
INSERT INTO `wp_79e54b1ec2_options` VALUES ('36','ping_sites','https://rpc.pingomatic.com/','on');
INSERT INTO `wp_79e54b1ec2_options` VALUES ('37','comment_max_links','2','on');
INSERT INTO `wp_79e54b1ec2_options` VALUES ('38','gmt_offset','0','on');
INSERT INTO `wp_79e54b1ec2_options` VALUES ('39','default_email_category','1','on');
INSERT INTO `wp_79e54b1ec2_options` VALUES ('40','recently_edited','a:5:{i:0;s:72:\"/dom528478/wp-content/themes/hello-elementor/assets/js/hello-frontend.js\";i:1;s:69:\"/dom528478/wp-content/plugins/elementor-pro/assets/js/frontend.min.js\";i:2;s:90:\"/dom528478/wp-content/plugins/elementskit-lite/libs/framework/assets/js/frontend-script.js\";i:3;s:61:\"/dom528478/wp-content/plugins/metform/public/assets/js/htm.js\";i:4;s:49:\"/dom528478/wp-content/plugins/akismet/akismet.php\";}','off');
INSERT INTO `wp_79e54b1ec2_options` VALUES ('41','template','hello-elementor','on');
INSERT INTO `wp_79e54b1ec2_options` VALUES ('42','stylesheet','hello-elementor','on');
INSERT INTO `wp_79e54b1ec2_options` VALUES ('43','comment_registration','0','on');
INSERT INTO `wp_79e54b1ec2_options` VALUES ('44','html_type','text/html','on');
INSERT INTO `wp_79e54b1ec2_options` VALUES ('45','use_trackback','0','on');
INSERT INTO `wp_79e54b1ec2_options` VALUES ('46','default_role','subscriber','on');
INSERT INTO `wp_79e54b1ec2_options` VALUES ('47','db_version','60421','on');
INSERT INTO `wp_79e54b1ec2_options` VALUES ('48','uploads_use_yearmonth_folders','1','on');
INSERT INTO `wp_79e54b1ec2_options` VALUES ('49','upload_path','','on');
INSERT INTO `wp_79e54b1ec2_options` VALUES ('50','blog_public','1','on');
INSERT INTO `wp_79e54b1ec2_options` VALUES ('51','default_link_category','2','on');
INSERT INTO `wp_79e54b1ec2_options` VALUES ('52','show_on_front','page','on');
INSERT INTO `wp_79e54b1ec2_options` VALUES ('53','tag_base','','on');
INSERT INTO `wp_79e54b1ec2_options` VALUES ('54','show_avatars','1','on');
INSERT INTO `wp_79e54b1ec2_options` VALUES ('55','avatar_rating','G','on');
INSERT INTO `wp_79e54b1ec2_options` VALUES ('56','upload_url_path','','on');
INSERT INTO `wp_79e54b1ec2_options` VALUES ('57','thumbnail_size_w','150','on');
INSERT INTO `wp_79e54b1ec2_options` VALUES ('58','thumbnail_size_h','150','on');
INSERT INTO `wp_79e54b1ec2_options` VALUES ('59','thumbnail_crop','1','on');
INSERT INTO `wp_79e54b1ec2_options` VALUES ('60','medium_size_w','300','on');
INSERT INTO `wp_79e54b1ec2_options` VALUES ('61','medium_size_h','300','on');
INSERT INTO `wp_79e54b1ec2_options` VALUES ('62','avatar_default','mystery','on');
INSERT INTO `wp_79e54b1ec2_options` VALUES ('63','large_size_w','1024','on');
INSERT INTO `wp_79e54b1ec2_options` VALUES ('64','large_size_h','1024','on');
INSERT INTO `wp_79e54b1ec2_options` VALUES ('65','image_default_link_type','none','on');
INSERT INTO `wp_79e54b1ec2_options` VALUES ('66','image_default_size','','on');
INSERT INTO `wp_79e54b1ec2_options` VALUES ('67','image_default_align','','on');
INSERT INTO `wp_79e54b1ec2_options` VALUES ('68','close_comments_for_old_posts','1','on');
INSERT INTO `wp_79e54b1ec2_options` VALUES ('69','close_comments_days_old','14','on');
INSERT INTO `wp_79e54b1ec2_options` VALUES ('70','thread_comments','1','on');
INSERT INTO `wp_79e54b1ec2_options` VALUES ('71','thread_comments_depth','5','on');
INSERT INTO `wp_79e54b1ec2_options` VALUES ('72','page_comments','0','on');
INSERT INTO `wp_79e54b1ec2_options` VALUES ('73','comments_per_page','50','on');
INSERT INTO `wp_79e54b1ec2_options` VALUES ('74','default_comments_page','newest','on');
INSERT INTO `wp_79e54b1ec2_options` VALUES ('75','comment_order','asc','on');
INSERT INTO `wp_79e54b1ec2_options` VALUES ('76','sticky_posts','a:0:{}','on');
INSERT INTO `wp_79e54b1ec2_options` VALUES ('80','uninstall_plugins','a:3:{s:58:\"vendor/gdcorp-wordpress/system-plugin-worker/functions.php\";s:13:\"mwp_uninstall\";s:23:\"elementor/elementor.php\";a:2:{i:0;s:21:\"Elementor\\Maintenance\";i:1;s:9:\"uninstall\";}s:27:\"popup-maker/popup-maker.php\";a:2:{i:0;s:11:\"PUM_Install\";i:1;s:16:\"uninstall_plugin\";}}','off');
INSERT INTO `wp_79e54b1ec2_options` VALUES ('81','timezone_string','','on');
INSERT INTO `wp_79e54b1ec2_options` VALUES ('82','page_for_posts','0','on');
INSERT INTO `wp_79e54b1ec2_options` VALUES ('83','page_on_front','364','on');
INSERT INTO `wp_79e54b1ec2_options` VALUES ('84','default_post_format','0','on');
INSERT INTO `wp_79e54b1ec2_options` VALUES ('85','link_manager_enabled','0','on');
INSERT INTO `wp_79e54b1ec2_options` VALUES ('86','finished_splitting_shared_terms','1','on');
INSERT INTO `wp_79e54b1ec2_options` VALUES ('87','site_icon','0','on');
INSERT INTO `wp_79e54b1ec2_options` VALUES ('88','medium_large_size_w','768','on');
INSERT INTO `wp_79e54b1ec2_options` VALUES ('89','medium_large_size_h','0','on');
INSERT INTO `wp_79e54b1ec2_options` VALUES ('90','wp_page_for_privacy_policy','','on');
INSERT INTO `wp_79e54b1ec2_options` VALUES ('91','show_comments_cookies_opt_in','1','on');
INSERT INTO `wp_79e54b1ec2_options` VALUES ('92','admin_email_lifespan','1775421358','on');
INSERT INTO `wp_79e54b1ec2_options` VALUES ('93','disallowed_keys','','off');
INSERT INTO `wp_79e54b1ec2_options` VALUES ('94','comment_previously_approved','1','on');
INSERT INTO `wp_79e54b1ec2_options` VALUES ('95','auto_plugin_theme_update_emails','a:0:{}','off');
INSERT INTO `wp_79e54b1ec2_options` VALUES ('96','auto_update_core_dev','enabled','on');
INSERT INTO `wp_79e54b1ec2_options` VALUES ('97','auto_update_core_minor','enabled','on');
INSERT INTO `wp_79e54b1ec2_options` VALUES ('98','auto_update_core_major','enabled','on');
INSERT INTO `wp_79e54b1ec2_options` VALUES ('99','wp_force_deactivated_plugins','a:0:{}','on');
INSERT INTO `wp_79e54b1ec2_options` VALUES ('100','wp_attachment_pages_enabled','0','on');
INSERT INTO `wp_79e54b1ec2_options` VALUES ('101','initial_db_version','60421','on');
INSERT INTO `wp_79e54b1ec2_options` VALUES ('102','wp_79e54b1ec2_user_roles','a:5:{s:13:\"administrator\";a:2:{s:4:\"name\";s:13:\"Administrator\";s:12:\"capabilities\";a:67:{s:13:\"switch_themes\";b:1;s:11:\"edit_themes\";b:1;s:16:\"activate_plugins\";b:1;s:12:\"edit_plugins\";b:1;s:10:\"edit_users\";b:1;s:10:\"edit_files\";b:1;s:14:\"manage_options\";b:1;s:17:\"moderate_comments\";b:1;s:17:\"manage_categories\";b:1;s:12:\"manage_links\";b:1;s:12:\"upload_files\";b:1;s:6:\"import\";b:1;s:15:\"unfiltered_html\";b:1;s:10:\"edit_posts\";b:1;s:17:\"edit_others_posts\";b:1;s:20:\"edit_published_posts\";b:1;s:13:\"publish_posts\";b:1;s:10:\"edit_pages\";b:1;s:4:\"read\";b:1;s:8:\"level_10\";b:1;s:7:\"level_9\";b:1;s:7:\"level_8\";b:1;s:7:\"level_7\";b:1;s:7:\"level_6\";b:1;s:7:\"level_5\";b:1;s:7:\"level_4\";b:1;s:7:\"level_3\";b:1;s:7:\"level_2\";b:1;s:7:\"level_1\";b:1;s:7:\"level_0\";b:1;s:17:\"edit_others_pages\";b:1;s:20:\"edit_published_pages\";b:1;s:13:\"publish_pages\";b:1;s:12:\"delete_pages\";b:1;s:19:\"delete_others_pages\";b:1;s:22:\"delete_published_pages\";b:1;s:12:\"delete_posts\";b:1;s:19:\"delete_others_posts\";b:1;s:22:\"delete_published_posts\";b:1;s:20:\"delete_private_posts\";b:1;s:18:\"edit_private_posts\";b:1;s:18:\"read_private_posts\";b:1;s:20:\"delete_private_pages\";b:1;s:18:\"edit_private_pages\";b:1;s:18:\"read_private_pages\";b:1;s:12:\"delete_users\";b:1;s:12:\"create_users\";b:1;s:17:\"unfiltered_upload\";b:1;s:14:\"edit_dashboard\";b:1;s:14:\"update_plugins\";b:1;s:14:\"delete_plugins\";b:1;s:15:\"install_plugins\";b:1;s:13:\"update_themes\";b:1;s:14:\"install_themes\";b:1;s:11:\"update_core\";b:1;s:10:\"list_users\";b:1;s:12:\"remove_users\";b:1;s:13:\"promote_users\";b:1;s:18:\"edit_theme_options\";b:1;s:13:\"delete_themes\";b:1;s:6:\"export\";b:1;s:20:\"skyboot_custom_icons\";b:1;s:42:\"elementor_atomic_widgets_access_styles_tab\";b:1;s:45:\"elementor_atomic_widgets_edit_local_css_class\";b:1;s:37:\"elementor_global_classes_update_class\";b:1;s:37:\"elementor_global_classes_remove_class\";b:1;s:36:\"elementor_global_classes_apply_class\";b:1;}}s:6:\"editor\";a:2:{s:4:\"name\";s:6:\"Editor\";s:12:\"capabilities\";a:38:{s:17:\"moderate_comments\";b:1;s:17:\"manage_categories\";b:1;s:12:\"manage_links\";b:1;s:12:\"upload_files\";b:1;s:15:\"unfiltered_html\";b:1;s:10:\"edit_posts\";b:1;s:17:\"edit_others_posts\";b:1;s:20:\"edit_published_posts\";b:1;s:13:\"publish_posts\";b:1;s:10:\"edit_pages\";b:1;s:4:\"read\";b:1;s:7:\"level_7\";b:1;s:7:\"level_6\";b:1;s:7:\"level_5\";b:1;s:7:\"level_4\";b:1;s:7:\"level_3\";b:1;s:7:\"level_2\";b:1;s:7:\"level_1\";b:1;s:7:\"level_0\";b:1;s:17:\"edit_others_pages\";b:1;s:20:\"edit_published_pages\";b:1;s:13:\"publish_pages\";b:1;s:12:\"delete_pages\";b:1;s:19:\"delete_others_pages\";b:1;s:22:\"delete_published_pages\";b:1;s:12:\"delete_posts\";b:1;s:19:\"delete_others_posts\";b:1;s:22:\"delete_published_posts\";b:1;s:20:\"delete_private_posts\";b:1;s:18:\"edit_private_posts\";b:1;s:18:\"read_private_posts\";b:1;s:20:\"delete_private_pages\";b:1;s:18:\"edit_private_pages\";b:1;s:18:\"read_private_pages\";b:1;s:42:\"elementor_atomic_widgets_access_styles_tab\";b:1;s:45:\"elementor_atomic_widgets_edit_local_css_class\";b:1;s:37:\"elementor_global_classes_remove_class\";b:1;s:36:\"elementor_global_classes_apply_class\";b:1;}}s:6:\"author\";a:2:{s:4:\"name\";s:6:\"Author\";s:12:\"capabilities\";a:14:{s:12:\"upload_files\";b:1;s:10:\"edit_posts\";b:1;s:20:\"edit_published_posts\";b:1;s:13:\"publish_posts\";b:1;s:4:\"read\";b:1;s:7:\"level_2\";b:1;s:7:\"level_1\";b:1;s:7:\"level_0\";b:1;s:12:\"delete_posts\";b:1;s:22:\"delete_published_posts\";b:1;s:42:\"elementor_atomic_widgets_access_styles_tab\";b:1;s:45:\"elementor_atomic_widgets_edit_local_css_class\";b:1;s:37:\"elementor_global_classes_remove_class\";b:1;s:36:\"elementor_global_classes_apply_class\";b:1;}}s:11:\"contributor\";a:2:{s:4:\"name\";s:11:\"Contributor\";s:12:\"capabilities\";a:9:{s:10:\"edit_posts\";b:1;s:4:\"read\";b:1;s:7:\"level_1\";b:1;s:7:\"level_0\";b:1;s:12:\"delete_posts\";b:1;s:42:\"elementor_atomic_widgets_access_styles_tab\";b:1;s:45:\"elementor_atomic_widgets_edit_local_css_class\";b:1;s:37:\"elementor_global_classes_remove_class\";b:1;s:36:\"elementor_global_classes_apply_class\";b:1;}}s:10:\"subscriber\";a:2:{s:4:\"name\";s:10:\"Subscriber\";s:12:\"capabilities\";a:2:{s:4:\"read\";b:1;s:7:\"level_0\";b:1;}}}','on');
INSERT INTO `wp_79e54b1ec2_options` VALUES ('103','fresh_site','0','off');
INSERT INTO `wp_79e54b1ec2_options` VALUES ('104','user_count','4','off');
INSERT INTO `wp_79e54b1ec2_options` VALUES ('106','sidebars_widgets','a:2:{s:19:\"wp_inactive_widgets\";a:0:{}s:13:\"array_version\";i:3;}','auto');
INSERT INTO `wp_79e54b1ec2_options` VALUES ('129','wpaas_cache_cnt','a:2:{i:0;i:1763940876;i:1;i:1763940882;}','auto');
INSERT INTO `wp_79e54b1ec2_options` VALUES ('130','gd_system_last_cache_flush','1760731663','auto');
INSERT INTO `wp_79e54b1ec2_options` VALUES ('136','current_theme','Hello Elementor','auto');
INSERT INTO `wp_79e54b1ec2_options` VALUES ('137','theme_switched','','auto');
INSERT INTO `wp_79e54b1ec2_options` VALUES ('141','wpaas_cache_options_cnt','a:1:{i:0;i:1761756488;}','auto');
INSERT INTO `wp_79e54b1ec2_options` VALUES ('145','mwp_auto_updates_status','enabled','auto');
INSERT INTO `wp_79e54b1ec2_options` VALUES ('146','mwp_previous_themes_state','a:4:{i:0;s:2:\"go\";i:1;s:15:\"hello-elementor\";i:2;s:16:\"twentytwentyfive\";i:3;s:16:\"twentytwentyfour\";}','auto');
INSERT INTO `wp_79e54b1ec2_options` VALUES ('147','auto_update_themes','a:4:{i:0;s:2:\"go\";i:1;s:16:\"twentytwentyfive\";i:2;s:16:\"twentytwentyfour\";i:3;s:15:\"hello-elementor\";}','auto');
INSERT INTO `wp_79e54b1ec2_options` VALUES ('148','wpaas_migrate_twentytwentythree','1','auto');
INSERT INTO `wp_79e54b1ec2_options` VALUES ('149','mwp_service_key','21337713-82eb-4711-b085-79b90073538e','on');
INSERT INTO `wp_79e54b1ec2_options` VALUES ('152','mwp_openssl_parameters','a:2:{s:4:\"time\";i:1764199768;s:7:\"working\";b:1;}','on');
INSERT INTO `wp_79e54b1ec2_options` VALUES ('153','gd_system_version','4.213.0','auto');
INSERT INTO `wp_79e54b1ec2_options` VALUES ('154','mwp_disable_comments_migrated','1759869425','off');
INSERT INTO `wp_79e54b1ec2_options` VALUES ('155','mwp_disable_comments_old_post','1','auto');
INSERT INTO `wp_79e54b1ec2_options` VALUES ('156','gdl_site_published','1761606393','auto');
INSERT INTO `wp_79e54b1ec2_options` VALUES ('157','gdl_live_site_dismiss','','auto');
INSERT INTO `wp_79e54b1ec2_options` VALUES ('158','gdl_enabled','1','auto');
INSERT INTO `wp_79e54b1ec2_options` VALUES ('159','mwp_previous_plugins_state','a:11:{i:0;s:19:\"akismet/akismet.php\";i:1;s:23:\"elementor/elementor.php\";i:2;s:31:\"elementor-pro/elementor-pro.php\";i:3;s:37:\"elementskit-lite/elementskit-lite.php\";i:4;s:19:\"metform/metform.php\";i:5;s:27:\"popup-maker/popup-maker.php\";i:6;s:73:\"skyboot-custom-icons-for-elementor/skyboot-custom-icons-for-elementor.php\";i:7;s:43:\"template-kit-import/template-kit-import.php\";i:8;s:61:\"wp-reviews-plugin-for-google/wp-reviews-plugin-for-google.php\";i:9;s:25:\"wp-default/wp-default.php\";i:10;s:23:\"wp-compat/wp-compat.php\";}','auto');
INSERT INTO `wp_79e54b1ec2_options` VALUES ('160','auto_update_plugins','a:13:{i:0;s:19:\"akismet/akismet.php\";i:1;s:23:\"elementor/elementor.php\";i:2;s:43:\"template-kit-import/template-kit-import.php\";i:3;s:43:\"gum-elementor-addon/gum-elementor-addon.php\";i:4;s:19:\"metform/metform.php\";i:5;s:37:\"elementskit-lite/elementskit-lite.php\";i:6;s:31:\"elementor-pro/elementor-pro.php\";i:7;s:73:\"skyboot-custom-icons-for-elementor/skyboot-custom-icons-for-elementor.php\";i:8;s:61:\"wp-reviews-plugin-for-google/wp-reviews-plugin-for-google.php\";i:9;s:27:\"popup-maker/popup-maker.php\";i:10;s:45:\"httpsd2-cache-engine/httpsd2-cache-engine.php\";i:11;s:25:\"wp-default/wp-default.php\";i:12;s:23:\"wp-compat/wp-compat.php\";}','auto');
INSERT INTO `wp_79e54b1ec2_options` VALUES ('161','objectcache_flushlog','a:10:{i:0;a:7:{s:4:\"time\";i:1763940882;s:4:\"user\";i:2;s:4:\"site\";N;s:4:\"cron\";b:0;s:3:\"cli\";b:0;s:6:\"reason\";N;s:5:\"trace\";s:261:\"shutdown_action_hook, do_action(\'shutdown\'), WP_Hook->do_action, WP_Hook->apply_filters, WPaaS\\Cache_V2->ban, WPaaS\\Cache_V2->flush_object_cache, wp_cache_flush, apply_filters(\'pre_objectcache_flush\'), WP_Hook->apply_filters, RedisCachePro\\Plugin->maybeLogFlush\";}i:1;a:7:{s:4:\"time\";i:1763940876;s:4:\"user\";i:2;s:4:\"site\";N;s:4:\"cron\";b:0;s:3:\"cli\";b:0;s:6:\"reason\";N;s:5:\"trace\";s:261:\"shutdown_action_hook, do_action(\'shutdown\'), WP_Hook->do_action, WP_Hook->apply_filters, WPaaS\\Cache_V2->ban, WPaaS\\Cache_V2->flush_object_cache, wp_cache_flush, apply_filters(\'pre_objectcache_flush\'), WP_Hook->apply_filters, RedisCachePro\\Plugin->maybeLogFlush\";}i:2;a:7:{s:4:\"time\";i:1763934193;s:4:\"user\";N;s:4:\"site\";N;s:4:\"cron\";b:1;s:3:\"cli\";b:0;s:6:\"reason\";N;s:5:\"trace\";s:261:\"shutdown_action_hook, do_action(\'shutdown\'), WP_Hook->do_action, WP_Hook->apply_filters, WPaaS\\Cache_V2->ban, WPaaS\\Cache_V2->flush_object_cache, wp_cache_flush, apply_filters(\'pre_objectcache_flush\'), WP_Hook->apply_filters, RedisCachePro\\Plugin->maybeLogFlush\";}i:3;a:7:{s:4:\"time\";i:1763907591;s:4:\"user\";i:2;s:4:\"site\";N;s:4:\"cron\";b:0;s:3:\"cli\";b:0;s:6:\"reason\";N;s:5:\"trace\";s:261:\"shutdown_action_hook, do_action(\'shutdown\'), WP_Hook->do_action, WP_Hook->apply_filters, WPaaS\\Cache_V2->ban, WPaaS\\Cache_V2->flush_object_cache, wp_cache_flush, apply_filters(\'pre_objectcache_flush\'), WP_Hook->apply_filters, RedisCachePro\\Plugin->maybeLogFlush\";}i:4;a:7:{s:4:\"time\";i:1763907585;s:4:\"user\";i:2;s:4:\"site\";N;s:4:\"cron\";b:0;s:3:\"cli\";b:0;s:6:\"reason\";N;s:5:\"trace\";s:261:\"shutdown_action_hook, do_action(\'shutdown\'), WP_Hook->do_action, WP_Hook->apply_filters, WPaaS\\Cache_V2->ban, WPaaS\\Cache_V2->flush_object_cache, wp_cache_flush, apply_filters(\'pre_objectcache_flush\'), WP_Hook->apply_filters, RedisCachePro\\Plugin->maybeLogFlush\";}i:5;a:7:{s:4:\"time\";i:1763907576;s:4:\"user\";i:2;s:4:\"site\";N;s:4:\"cron\";b:0;s:3:\"cli\";b:0;s:6:\"reason\";N;s:5:\"trace\";s:261:\"shutdown_action_hook, do_action(\'shutdown\'), WP_Hook->do_action, WP_Hook->apply_filters, WPaaS\\Cache_V2->ban, WPaaS\\Cache_V2->flush_object_cache, wp_cache_flush, apply_filters(\'pre_objectcache_flush\'), WP_Hook->apply_filters, RedisCachePro\\Plugin->maybeLogFlush\";}i:6;a:7:{s:4:\"time\";i:1763907569;s:4:\"user\";i:2;s:4:\"site\";N;s:4:\"cron\";b:0;s:3:\"cli\";b:0;s:6:\"reason\";N;s:5:\"trace\";s:261:\"shutdown_action_hook, do_action(\'shutdown\'), WP_Hook->do_action, WP_Hook->apply_filters, WPaaS\\Cache_V2->ban, WPaaS\\Cache_V2->flush_object_cache, wp_cache_flush, apply_filters(\'pre_objectcache_flush\'), WP_Hook->apply_filters, RedisCachePro\\Plugin->maybeLogFlush\";}i:7;a:7:{s:4:\"time\";i:1763631478;s:4:\"user\";N;s:4:\"site\";N;s:4:\"cron\";b:1;s:3:\"cli\";b:0;s:6:\"reason\";N;s:5:\"trace\";s:261:\"shutdown_action_hook, do_action(\'shutdown\'), WP_Hook->do_action, WP_Hook->apply_filters, WPaaS\\Cache_V2->ban, WPaaS\\Cache_V2->flush_object_cache, wp_cache_flush, apply_filters(\'pre_objectcache_flush\'), WP_Hook->apply_filters, RedisCachePro\\Plugin->maybeLogFlush\";}i:8;a:7:{s:4:\"time\";i:1763588470;s:4:\"user\";N;s:4:\"site\";N;s:4:\"cron\";b:1;s:3:\"cli\";b:0;s:6:\"reason\";N;s:5:\"trace\";s:261:\"shutdown_action_hook, do_action(\'shutdown\'), WP_Hook->do_action, WP_Hook->apply_filters, WPaaS\\Cache_V2->ban, WPaaS\\Cache_V2->flush_object_cache, wp_cache_flush, apply_filters(\'pre_objectcache_flush\'), WP_Hook->apply_filters, RedisCachePro\\Plugin->maybeLogFlush\";}i:9;a:7:{s:4:\"time\";i:1763415515;s:4:\"user\";N;s:4:\"site\";N;s:4:\"cron\";b:1;s:3:\"cli\";b:0;s:6:\"reason\";N;s:5:\"trace\";s:261:\"shutdown_action_hook, do_action(\'shutdown\'), WP_Hook->do_action, WP_Hook->apply_filters, WPaaS\\Cache_V2->ban, WPaaS\\Cache_V2->flush_object_cache, wp_cache_flush, apply_filters(\'pre_objectcache_flush\'), WP_Hook->apply_filters, RedisCachePro\\Plugin->maybeLogFlush\";}}','off');
INSERT INTO `wp_79e54b1ec2_options` VALUES ('162','wpaas_feature_flag_480ce83d-ba87-407d-bdd6-a39b2230454f','a:3:{s:11:\"account_uid\";s:36:\"480ce83d-ba87-407d-bdd6-a39b2230454f\";s:5:\"flags\";a:17:{i:0;a:2:{s:5:\"title\";s:23:\"admin_storage_notice_gd\";s:5:\"value\";b:1;}i:1;a:2:{s:5:\"title\";s:21:\"smart_plugins_enabled\";s:5:\"value\";b:1;}i:2;a:2:{s:5:\"title\";s:11:\"wpm_enabled\";s:5:\"value\";b:0;}i:3;a:2:{s:5:\"title\";s:13:\"wordpress_mcp\";s:5:\"value\";b:1;}i:4;a:2:{s:5:\"title\";s:11:\"gmv_monitor\";s:5:\"value\";b:1;}i:5;a:2:{s:5:\"title\";s:16:\"2fa_venture_home\";s:5:\"value\";b:1;}i:6;a:2:{s:5:\"title\";s:13:\"wp643_zip_fix\";s:5:\"value\";b:1;}i:7;a:2:{s:5:\"title\";s:31:\"wpex-3590-enhance_publish_guide\";s:5:\"value\";b:1;}i:8;a:2:{s:5:\"title\";s:17:\"fullstory_wpadmin\";s:5:\"value\";b:1;}i:9;a:2:{s:5:\"title\";s:13:\"expert_banner\";s:5:\"value\";b:1;}i:10;a:2:{s:5:\"title\";s:24:\"wp_site_designer_plugins\";s:5:\"value\";b:1;}i:11;a:2:{s:5:\"title\";s:31:\"WPEX2894_domain_attach_wp_admin\";s:5:\"value\";b:1;}i:12;a:2:{s:5:\"title\";s:23:\"persist-autodraft-posts\";s:5:\"value\";b:1;}i:13;a:2:{s:5:\"title\";s:10:\"nps_survey\";s:5:\"value\";b:1;}i:14;a:2:{s:5:\"title\";s:26:\"wpex-3258-post-publish-CTA\";s:5:\"value\";b:1;}i:15;a:2:{s:5:\"title\";s:22:\"cta_interview_wp_admin\";s:5:\"value\";b:1;}i:16;a:2:{s:5:\"title\";s:18:\"traffic_data_admin\";s:5:\"value\";b:1;}}s:9:\"timestamp\";i:1764199170;}','auto');
INSERT INTO `wp_79e54b1ec2_options` VALUES ('163','recovery_keys','a:0:{}','off');
INSERT INTO `wp_79e54b1ec2_options` VALUES ('164','mwp_public_keys_refresh_time','1764189574','on');
INSERT INTO `wp_79e54b1ec2_options` VALUES ('165','mwp_public_keys','a:9:{i:0;a:6:{s:2:\"id\";s:19:\"managewp_1761789902\";s:7:\"service\";s:8:\"managewp\";s:9:\"validFrom\";s:19:\"2025-11-14 01:26:15\";s:7:\"validTo\";s:19:\"2025-12-16 01:26:15\";s:9:\"publicKey\";s:451:\"-----BEGIN PUBLIC KEY-----\nMIIBIjANBgkqhkiG9w0BAQEFAAOCAQ8AMIIBCgKCAQEAzUQxjEpRVlTGcwGacz5e\ndjezM2lOfPCZTNWfGAzgFNNDLgHlt4fmYQuEl8XJ+J9QC2+VBIODQbpq3KedDaR2\nCAFGGsy3SJoxenrqIzkPjsv5574qMUmRrpUyCqGhg4KSSHFT2jxl3kOLG8WHFnh4\nLsgapkaDXj1rLcI/khQ4wcnSH365n1BCg7010CcX1P3mDY6l0FIkgieSW+HWU+sB\ncNG/Izx2jV2dyGbkmXWdFxQF38cNCuqYxzdl/u1RZDYIpFO1EXb7DMAq7z4P8t4+\nWpJZjQqx5nz25Ij11a2Z4j0Oy2nvkA4Nkv6QVOkNQgaeQY1EY4nbiYA4JSy2VT3C\nyQIDAQAB\n-----END PUBLIC KEY-----\n\";s:13:\"useServiceKey\";b:0;}i:1;a:6:{s:2:\"id\";s:23:\"managewp_dev_1761789902\";s:7:\"service\";s:12:\"managewp_dev\";s:9:\"validFrom\";s:19:\"2025-11-14 01:26:15\";s:7:\"validTo\";s:19:\"2025-12-16 01:26:15\";s:9:\"publicKey\";s:451:\"-----BEGIN PUBLIC KEY-----\nMIIBIjANBgkqhkiG9w0BAQEFAAOCAQ8AMIIBCgKCAQEAs/tL9DL3pLM6s0UVhVAk\n5guXrSaEeqmn0A6BWeDbckHNnB1vHyxQAMSVM3Q9V3EeMl1GpJgtWL5g+MkpnuyT\nAJj9T4NJtA14pNJ94DD8cr8MMQZuCMltWxl+WdzMQuwanuxDN7Nj84vp170mNdr3\nq5ZZOxA9AbP9rtQXWEDab2lCtT0Cue7Zrwi5fJv9U9sftSrI7cQcEUZ8mn5NLzGO\nHQoysrWFBm46eEAJC9oijfQD96omgQo4kRjMB/chVUMj0NhbjoT6n/4Cp/yhsccI\n9BTSymLJi6IQ+2wwGvtRSd0Lb3pTFeeYUmQA9ZdowTtNIqDs8Py5pYILQyU0H39r\nfwIDAQAB\n-----END PUBLIC KEY-----\n\";s:13:\"useServiceKey\";b:0;}i:2;a:6:{s:2:\"id\";s:16:\"mwp20_1761789902\";s:7:\"service\";s:5:\"mwp20\";s:9:\"validFrom\";s:19:\"2025-11-14 01:26:15\";s:7:\"validTo\";s:19:\"2025-12-16 01:26:15\";s:9:\"publicKey\";s:451:\"-----BEGIN PUBLIC KEY-----\nMIIBIjANBgkqhkiG9w0BAQEFAAOCAQ8AMIIBCgKCAQEAuWpaO/fjWCcXVUZpVJqv\nMOkPJNYI4G15TuNqNEtlFFf4qvDsJBEAeGi+rK+jPBEutYdd4st6u3djr3lzOwYg\nU7xjAUyQITjWGvXKjip1LtDa/booR1c9gsr0ag9ZpdsQFnxcxChSpS01HDJ67dOZ\nFH2fM4vMEHTMdZN+9V4lbt4LKRDT3OXws+A+iORVKALlehrN5AVvBuw2Taa9UbfD\nxqIOT7AXKY2z9iU8LIgndM9lGfg/CYEDERMxuInSlzlLv9MS0IFokMeIUaubGzFv\nMDU3e2G5fK2cUZ1HV24L3Idq0mV5r07vKxaTQijqGA2QB5O0oEShIsUN3WlJhGoF\nfQIDAQAB\n-----END PUBLIC KEY-----\n\";s:13:\"useServiceKey\";b:1;}i:3;a:6:{s:2:\"id\";s:15:\"wpps_1761397502\";s:7:\"service\";s:4:\"wpps\";s:9:\"validFrom\";s:19:\"2025-11-09 13:05:01\";s:7:\"validTo\";s:19:\"2025-12-11 13:05:01\";s:9:\"publicKey\";s:451:\"-----BEGIN PUBLIC KEY-----\nMIIBIjANBgkqhkiG9w0BAQEFAAOCAQ8AMIIBCgKCAQEA0zOoa8MvMYPPD5ZxvDRU\nBht6+Rkt+ZsqovD67LlPfj7tjja624mfRV9HgtTntVqjmmq+utj8WhPlXWchufuM\nwmlSUas8+FbBT/8Qxo5tQLhVnq2assuERPBHjE9HJZUx52TOvilv8TOHO3SfFl9d\nqQUMsEiDkDjzJfzY5WwrUjMBFS5VzsHXvv8bi7lWAz0exIfCxbqIcFo2SyuYAR8l\nRT3RyWTUVzu+OXNPbMrN+1GRIXUvACl6HirT2qGzTfw293KxCo2kRabpmO5uJE+x\nPZTBxEHoO8fP1L/zCv4vrYKggGt1b/o0KYmXQfPVaLJ47qpWgp4621y3QEklcnUr\nFwIDAQAB\n-----END PUBLIC KEY-----\n\";s:13:\"useServiceKey\";b:1;}i:4;a:6:{s:2:\"id\";s:15:\"wpps_1763989502\";s:7:\"service\";s:4:\"wpps\";s:9:\"validFrom\";s:19:\"2025-12-09 13:05:01\";s:7:\"validTo\";s:19:\"2026-01-10 13:05:01\";s:9:\"publicKey\";s:451:\"-----BEGIN PUBLIC KEY-----\nMIIBIjANBgkqhkiG9w0BAQEFAAOCAQ8AMIIBCgKCAQEAkTfJtX9pYuR+E7j0SF59\nsJyMqc1nwCLJOIw/03qnzd8q6BMlmqVP+8EODMTw2Xsti64PozeQMExvvi4uThah\nJ5Z3I/TTkIJvFhd0+CBam6rrVh0L8EbtB61Y+bIgR37TFHf7QUKsnk8mvwb+COk2\nOuIpCGlNBUbRS219m1xuEiPjz2bNqSySfxE5whrPSMPRhje3uKr3zS/IjbeAkpu7\n1724CMFDqXvS7qmgl+rAQB++eCQRTNvDo8yhbeqOma9FOzCyynZpwIVz6hPRxWR5\nHTYLed+eRK4wmrd9AmJnaKE/9wHlC4P18ROjxqOJpT5waysTXij35KtkfxKju4jG\ngQIDAQAB\n-----END PUBLIC KEY-----\n\";s:13:\"useServiceKey\";b:1;}i:5;a:6:{s:2:\"id\";s:25:\"cookie_service_1762621502\";s:7:\"service\";s:14:\"cookie_service\";s:9:\"validFrom\";s:19:\"2025-11-23 16:27:25\";s:7:\"validTo\";s:19:\"2025-12-25 16:27:25\";s:9:\"publicKey\";s:451:\"-----BEGIN PUBLIC KEY-----\nMIIBIjANBgkqhkiG9w0BAQEFAAOCAQ8AMIIBCgKCAQEAkqOODO2H6lveLuwr68A8\nCEo8uNp7P+BBIL1Qta4PMA84bxUMSrMMVpbYTWo9J3BokVp60n239/UmO73h3uyU\nV12SqTPzA9AH9UuhYCUKfdBkJg6c2L6gCA+L7pftxeY8/NYrG7Jp65Cparfyg+Cb\nMNTJHtPcuYmpVzvMjhpNgJoH6gTGmaqhE07q7wb6uOyR1B0wEGOv+b2kPK1UGLSS\nkkS5f1v1cOXfAwSF+wvlkCEv9nzPBivn5/TZ/1TYbKGyadcLI5mkPV0sMexdIpx3\nM/wM31lrR72woMs27pqnDDb01PG5lBVR2iSJ6/5lZ2DRQdF7U8cn1m47ASmPg2ZU\nxQIDAQAB\n-----END PUBLIC KEY-----\n\";s:13:\"useServiceKey\";b:1;}i:6;a:6:{s:2:\"id\";s:15:\"mwp1_1761487501\";s:7:\"service\";s:4:\"mwp1\";s:9:\"validFrom\";s:19:\"2025-11-10 14:05:01\";s:7:\"validTo\";s:19:\"2025-12-12 14:05:01\";s:9:\"publicKey\";s:451:\"-----BEGIN PUBLIC KEY-----\nMIIBIjANBgkqhkiG9w0BAQEFAAOCAQ8AMIIBCgKCAQEAke/qZT7UcqnTn0OAeQ/2\nuz626AQ5AmAbvjFxGkPJU6s42hfQaucimw4NhBLU09G4o/ciVk6bJ5n/pjzUMgz8\nhVJ5OdQvDcvKcLN8geX5CSuHs9Rqh5oizlyrG3mKDKwL017g7R42/Q26EJ4wVcpY\ntQxYB1OJnYWHRwtJCTcevK8h02a9a2vcs4CrKLJiNeSq6bbX9nlgebeVQIbAWWG6\n80NOanohtXxnEuOMfyMAnUGe0tZ61tneuYK79px6M0JL+ESJBGHgRPB497DEA3ts\nwQRW9YHyb3Hyip/CwfCgjsTpQsibdR4hyO7vSnaBjXFfxTbZF9L59Wibg85u5w8V\nVwIDAQAB\n-----END PUBLIC KEY-----\n\";s:13:\"useServiceKey\";b:1;}i:7;a:6:{s:2:\"id\";s:15:\"mwp1_1764079502\";s:7:\"service\";s:4:\"mwp1\";s:9:\"validFrom\";s:19:\"2025-12-10 14:05:01\";s:7:\"validTo\";s:19:\"2026-01-11 14:05:01\";s:9:\"publicKey\";s:451:\"-----BEGIN PUBLIC KEY-----\nMIIBIjANBgkqhkiG9w0BAQEFAAOCAQ8AMIIBCgKCAQEAyhygc+ewn34bjDBws0os\nLEdQ1tP/Qq2SV6XHju6GW7f6WmeMYfGg2dqYp5kt42uKYeYANubnN/OgHGMwrOGN\nOawII56hYh3bx8FkaoE2PPyM4Yo3k0LRfNDHRrOiF25Llq1wYhWlpF4J0W+66DpI\nwufy1wU2UlG2YYCxCB9kwHbsLaxaEiOvFEFF9DmN2FzsWs1pK185/YuMcHSJT5hz\nor27GyPhfS32/I2d6YDKGV1LY+J4js4nG8c0uuzpcd1iVPAFPDsWiif1B+1+BKQD\nb14DF7OV98viUQ/xDAg1u/irgdS4Ka89+e9fvxo2dqMrbIu/1pInb7uz95kfc0ta\nFwIDAQAB\n-----END PUBLIC KEY-----\n\";s:13:\"useServiceKey\";b:1;}i:8;a:6:{s:2:\"id\";s:20:\"migration_1761746702\";s:7:\"service\";s:9:\"migration\";s:9:\"validFrom\";s:19:\"2025-11-13 13:05:02\";s:7:\"validTo\";s:19:\"2025-12-15 13:05:02\";s:9:\"publicKey\";s:451:\"-----BEGIN PUBLIC KEY-----\nMIIBIjANBgkqhkiG9w0BAQEFAAOCAQ8AMIIBCgKCAQEAxr818JOdRje2MKI/j8RW\nO4/SpsHb+uWJxg1ov5owmmpmksRbcPCSfxJd5uaD6rHmo1d9WB+GdcUbXCb231TG\n0Wl/zhVs+Qcz3woeztNe7HzyIfqCk+HXU4QZmvZimwfvtDqJVoS5Pe/fNzVl3Feg\nuVRiu73QH/QIlmwhXGeha2erfkx32oe706aKH0GCPOaePjvH/ZeV0ldRRIFo4rHL\npGrTEw6mldK8euaR9iOqsR8E9zEnoDOdew1HYbj82a7RSmFOClHIp9tigZ4eV1HM\n7ZJKPDFtG47J4XF7MGgwP67j/MAayUTmHL3QXiuLMWxwuhdAHXGmX+BXcaXva+Cx\niQIDAQAB\n-----END PUBLIC KEY-----\n\";s:13:\"useServiceKey\";b:1;}}','on');
INSERT INTO `wp_79e54b1ec2_options` VALUES ('168','objectcache_license','O:8:\"stdClass\":7:{s:4:\"plan\";s:10:\"L3 Partner\";s:5:\"state\";s:5:\"valid\";s:5:\"token\";s:60:\"208d7b6faa354ae6a640f5b991e595e3a8e328db0a93cad1ac7794ae994a\";s:12:\"organization\";O:8:\"stdClass\":2:{s:4:\"name\";s:16:\"GoDaddy.com, LLC\";s:4:\"slug\";s:14:\"godaddycom-llc\";}s:9:\"stability\";s:5:\"alpha\";s:10:\"last_check\";i:1764163147;s:11:\"valid_as_of\";i:1764163147;}','off');
INSERT INTO `wp_79e54b1ec2_options` VALUES ('171','theme_switched_via_customizer','','auto');
INSERT INTO `wp_79e54b1ec2_options` VALUES ('172','coblocks_site_content_controls_enabled','1','auto');
INSERT INTO `wp_79e54b1ec2_options` VALUES ('173','coblocks_site_design_controls_enabled','1','auto');
INSERT INTO `wp_79e54b1ec2_options` VALUES ('174','coblocks_layout_selector_controls_enabled','1','auto');
INSERT INTO `wp_79e54b1ec2_options` VALUES ('175','gd_seo_vendor','yoast','auto');
INSERT INTO `wp_79e54b1ec2_options` VALUES ('176','wpnux_export_uid','a02339d1-4a15-4a96-af20-9d1416d4d46d','off');
INSERT INTO `wp_79e54b1ec2_options` VALUES ('177','wpnux_export_data','{\"_meta\":{\"content_id\":null,\"country\":\"US\",\"customer_id\":\"9edb6bd0-4557-4bd9-8fa5-39047c62b228\",\"created_at\":\"2025-10-17 20:05:43\",\"delivery_options\":[],\"domain\":\"apc.3ca.myftpupload.com\",\"export_id\":\"a02339d1-4a15-4a96-af20-9d1416d4d46d\",\"features\":[],\"hosting_product\":\"wpaas\",\"hostname\":null,\"is_premium_plan\":false,\"is_private_label\":false,\"is_store\":false,\"language\":\"en_US\",\"payment_gateways\":[],\"persona\":\"partner\",\"postal_code\":null,\"skill\":null,\"style\":\"traditional\",\"template\":\"default\",\"template_type\":\"standard\",\"vertical\":null,\"plugins\":[],\"colors\":[],\"nux_cli_version\":\"2.1.2\",\"wp_cli_version\":\"2.12.0\"},\"content\":{\"options\":{\"WPLANG\":\"en_US\",\"blogname\":\"A WordPress Site\",\"blogdescription\":\"\",\"wp_page_for_privacy_policy\":\"\",\"permalink_structure\":\"\\/%postname%\\/\",\"stylesheet\":\"twentytwentyfour\",\"template\":\"twentytwentyfour\",\"active_plugins\":[],\"auto_update_plugins\":[],\"auto_update_themes\":[\"twentytwentyfour\"],\"coblocks_site_content_controls_enabled\":true,\"coblocks_site_design_controls_enabled\":true,\"coblocks_layout_selector_controls_enabled\":true,\"gd_seo_vendor\":\"yoast\",\"gdl_enabled\":true},\"posts\":[],\"theme_mods\":[]},\"plugins\":[],\"themes\":{\"twentytwentyfour\":\"twentytwentyfour\"}}','off');
INSERT INTO `wp_79e54b1ec2_options` VALUES ('178','wpnux_imported','2025-10-17 20:07:39','off');
INSERT INTO `wp_79e54b1ec2_options` VALUES ('179','wpnux_took_ms','3202','off');
INSERT INTO `wp_79e54b1ec2_options` VALUES ('180','widget_pages','a:1:{s:12:\"_multiwidget\";i:1;}','auto');
INSERT INTO `wp_79e54b1ec2_options` VALUES ('181','widget_calendar','a:1:{s:12:\"_multiwidget\";i:1;}','auto');
INSERT INTO `wp_79e54b1ec2_options` VALUES ('182','widget_archives','a:1:{s:12:\"_multiwidget\";i:1;}','auto');
INSERT INTO `wp_79e54b1ec2_options` VALUES ('183','widget_media_audio','a:1:{s:12:\"_multiwidget\";i:1;}','auto');
INSERT INTO `wp_79e54b1ec2_options` VALUES ('184','widget_media_image','a:1:{s:12:\"_multiwidget\";i:1;}','auto');
INSERT INTO `wp_79e54b1ec2_options` VALUES ('185','widget_media_gallery','a:1:{s:12:\"_multiwidget\";i:1;}','auto');
INSERT INTO `wp_79e54b1ec2_options` VALUES ('186','widget_media_video','a:1:{s:12:\"_multiwidget\";i:1;}','auto');
INSERT INTO `wp_79e54b1ec2_options` VALUES ('187','widget_meta','a:1:{s:12:\"_multiwidget\";i:1;}','auto');
INSERT INTO `wp_79e54b1ec2_options` VALUES ('188','widget_search','a:1:{s:12:\"_multiwidget\";i:1;}','auto');
INSERT INTO `wp_79e54b1ec2_options` VALUES ('189','widget_text','a:1:{s:12:\"_multiwidget\";i:1;}','auto');
INSERT INTO `wp_79e54b1ec2_options` VALUES ('190','widget_categories','a:1:{s:12:\"_multiwidget\";i:1;}','auto');
INSERT INTO `wp_79e54b1ec2_options` VALUES ('191','widget_recent-posts','a:1:{s:12:\"_multiwidget\";i:1;}','auto');
INSERT INTO `wp_79e54b1ec2_options` VALUES ('192','widget_recent-comments','a:1:{s:12:\"_multiwidget\";i:1;}','auto');
INSERT INTO `wp_79e54b1ec2_options` VALUES ('193','widget_rss','a:1:{s:12:\"_multiwidget\";i:1;}','auto');
INSERT INTO `wp_79e54b1ec2_options` VALUES ('194','widget_tag_cloud','a:1:{s:12:\"_multiwidget\";i:1;}','auto');
INSERT INTO `wp_79e54b1ec2_options` VALUES ('195','widget_nav_menu','a:1:{s:12:\"_multiwidget\";i:1;}','auto');
INSERT INTO `wp_79e54b1ec2_options` VALUES ('196','widget_custom_html','a:1:{s:12:\"_multiwidget\";i:1;}','auto');
INSERT INTO `wp_79e54b1ec2_options` VALUES ('197','widget_block','a:1:{s:12:\"_multiwidget\";i:1;}','auto');
INSERT INTO `wp_79e54b1ec2_options` VALUES ('198','widget_akismet_widget','a:1:{s:12:\"_multiwidget\";i:1;}','auto');
INSERT INTO `wp_79e54b1ec2_options` VALUES ('199','wpnux_claimed','1','off');
INSERT INTO `wp_79e54b1ec2_options` VALUES ('200','gd_system_polling_invalidation_id','35tsoYrgLWD7W8vBsbwWQR49LnO','auto');
INSERT INTO `wp_79e54b1ec2_options` VALUES ('202','worker_migration_version','2','yes');
INSERT INTO `wp_79e54b1ec2_options` VALUES ('203','mwp_recovering','','on');
INSERT INTO `wp_79e54b1ec2_options` VALUES ('204','mwp_incremental_update_active','','on');
INSERT INTO `wp_79e54b1ec2_options` VALUES ('205','mwp_core_autoupdate','','on');
INSERT INTO `wp_79e54b1ec2_options` VALUES ('206','mwp_container_parameters','a:0:{}','on');
INSERT INTO `wp_79e54b1ec2_options` VALUES ('207','mwp_container_site_parameters','a:0:{}','on');
INSERT INTO `wp_79e54b1ec2_options` VALUES ('208','_worker_nossl_key','','on');
INSERT INTO `wp_79e54b1ec2_options` VALUES ('209','_worker_public_key','LS0tLS1CRUdJTiBQVUJMSUMgS0VZLS0tLS0KTUlJQklqQU5CZ2txaGtpRzl3MEJBUUVGQUFPQ0FROEFNSUlCQ2dLQ0FRRUFyYm5RbWh6QXhGcE5iMWNPbnE0YwpsNi9iK0cvbjUvREZiOUJNQXJBNmluYmQ1cEFMcG94a1FLTHVpWUNnallTdzgyd01ud0FWWWsxNjNqZER0d2kxCjN1MjZnV3A1Wkd3cGNFNHdrMWJsekRkVkp2Q2c1U0JWR1JjbnR6cE5GYmVabitNODBBZGViN1lLdWNtaEd0VlIKVHVoWlVRWXEyUlNiaFo0dXhuUTdCUituOXdtS2ZJUG12YWNtUm0ydWVFMnNkNG8vTGJFSTRENExEQnZ6S1k1aApWampEekY0QUYrRTNCRTlRTXNBR2M3ekMzai9EUkswSU5qRTdJRWNnTXBKV0N4N1RuQmJtaWVFRlkxTkdWR0wzClZKd2E5Qnp2b1BMcFc5bzc2d1pWanRDNGp1SThUU3lpbVgwZGNHWTdtZ1FxbURCaDNLemtzQXdzcGRyUkN4OE8KclFJREFRQUIKLS0tLS1FTkQgUFVCTElDIEtFWS0tLS0tCg==','on');
INSERT INTO `wp_79e54b1ec2_options` VALUES ('210','mwp_maintenace_mode','a:0:{}','on');
INSERT INTO `wp_79e54b1ec2_options` VALUES ('212','mwp_communication_keys','a:1:{i:21523934;a:2:{s:3:\"key\";s:36:\"75c09bcc-6365-49fa-9b72-f4a3dddf1531\";s:5:\"added\";i:1760731704;}}','on');
INSERT INTO `wp_79e54b1ec2_options` VALUES ('213','mwp_key_last_used_d472b37a-c98a-4435-86ad-f772339fd55b','1760731697','on');
INSERT INTO `wp_79e54b1ec2_options` VALUES ('214','mmb_stats_filter','a:1:{s:7:\"plugins\";a:1:{s:7:\"cleanup\";a:1:{s:9:\"revisions\";a:1:{s:11:\"num_to_keep\";i:5;}}}}','auto');
INSERT INTO `wp_79e54b1ec2_options` VALUES ('217','mwp_new_communication_established','1','on');
INSERT INTO `wp_79e54b1ec2_options` VALUES ('218','mwp_key_last_used_75c09bcc-6365-49fa-9b72-f4a3dddf1531','1760731704','on');
INSERT INTO `wp_79e54b1ec2_options` VALUES ('219','mwp_potential_key','bd6fac64-8da2-495b-9b83-cab58c9ac8fc','on');
INSERT INTO `wp_79e54b1ec2_options` VALUES ('220','mwp_potential_key_time','1764199768','on');
INSERT INTO `wp_79e54b1ec2_options` VALUES ('221','gd_system_first_login','1760731705','off');
INSERT INTO `wp_79e54b1ec2_options` VALUES ('222','gd_system_last_login','1760731705','off');
INSERT INTO `wp_79e54b1ec2_options` VALUES ('223','gdl_pgi_site_info','','auto');
INSERT INTO `wp_79e54b1ec2_options` VALUES ('224','gdl_pgi_site_media','','auto');
INSERT INTO `wp_79e54b1ec2_options` VALUES ('225','gdl_pgi_site_content','1761605427','auto');
INSERT INTO `wp_79e54b1ec2_options` VALUES ('226','gdl_pgi_site_design','','auto');
INSERT INTO `wp_79e54b1ec2_options` VALUES ('227','gdl_pgi_add_domain','','auto');
INSERT INTO `wp_79e54b1ec2_options` VALUES ('228','wpaas_website_content_changed','1763905901','auto');
INSERT INTO `wp_79e54b1ec2_options` VALUES ('229','mwp_pro_connected','pro_sites','auto');
INSERT INTO `wp_79e54b1ec2_options` VALUES ('235','gdl_publish_guide_interacted','1','auto');
INSERT INTO `wp_79e54b1ec2_options` VALUES ('236','gdl_publish_guide_opt_out','','auto');
INSERT INTO `wp_79e54b1ec2_options` VALUES ('268','user_hit_count','a:32:{s:10:\"2025-10-17\";i:2;s:10:\"2025-10-27\";i:19;s:10:\"2025-10-28\";i:234;s:10:\"2025-10-29\";i:189;s:10:\"2025-10-30\";i:86;s:10:\"2025-10-31\";i:4;s:10:\"2025-11-01\";i:3;s:10:\"2025-11-02\";i:3;s:10:\"2025-11-03\";i:17;s:10:\"2025-11-04\";i:3;s:10:\"2025-11-05\";i:4;s:10:\"2025-11-06\";i:5;s:10:\"2025-11-07\";i:9;s:10:\"2025-11-08\";i:3;s:10:\"2025-11-09\";i:4;s:10:\"2025-11-10\";i:6;s:10:\"2025-11-11\";i:8;s:10:\"2025-11-12\";i:9;s:10:\"2025-11-13\";i:8;s:10:\"2025-11-14\";i:7;s:10:\"2025-11-15\";i:4;s:10:\"2025-11-16\";i:4;s:10:\"2025-11-17\";i:9;s:10:\"2025-11-18\";i:7;s:10:\"2025-11-19\";i:3;s:10:\"2025-11-20\";i:9;s:10:\"2025-11-21\";i:5;s:10:\"2025-11-22\";i:5;s:10:\"2025-11-23\";i:24;s:10:\"2025-11-24\";i:10;s:10:\"2025-11-25\";i:6;s:10:\"2025-11-26\";i:4;}','on');
INSERT INTO `wp_79e54b1ec2_options` VALUES ('317','can_compress_scripts','1','on');
INSERT INTO `wp_79e54b1ec2_options` VALUES ('369','finished_updating_comment_type','1','auto');
INSERT INTO `wp_79e54b1ec2_options` VALUES ('540','theme_mods_twentytwentyfour','a:2:{s:18:\"custom_css_post_id\";i:-1;s:16:\"sidebars_widgets\";a:2:{s:4:\"time\";i:1761605394;s:4:\"data\";a:1:{s:19:\"wp_inactive_widgets\";a:0:{}}}}','off');
INSERT INTO `wp_79e54b1ec2_options` VALUES ('1217','theme_mods_hello-elementor','a:3:{i:0;b:0;s:18:\"nav_menu_locations\";a:1:{s:6:\"menu-1\";i:3;}s:18:\"custom_css_post_id\";i:744;}','on');
INSERT INTO `wp_79e54b1ec2_options` VALUES ('1218','hello_theme_version','3.4.5','auto');
INSERT INTO `wp_79e54b1ec2_options` VALUES ('1223','elementor_connect_site_key','d04a65feba0e3c88ba17e70b29f1e38f','auto');
INSERT INTO `wp_79e54b1ec2_options` VALUES ('1224','_hello-elementor_notifications','a:2:{s:7:\"timeout\";i:1764206348;s:5:\"value\";s:7987:\"[{\"id\":\"hello-theme-3.4.5\",\"title\":\"3.4.5 - 2025-10-27\",\"description\":\"\\n            <ul>\\n\\t\\t\\t\\t<li>New: Add theme home to Finder<\\/li>\\n\\t\\t\\t\\t<li>Tweak: Improve banner behavior after clicking on action button<\\/li>\\n\\t\\t\\t\\t<li>Fix: Load styles correctly in Gutenberg pages<\\/li>\\n\\t\\t\\t\\t<li>Fix: Do not change menu name after Elementor activation<\\/li>\\n\\t\\t\\t\\t<li>Fix: Ensure quicklinks works correctly from home page<\\/li>\\n            <\\/ul>\"},{\"id\":\"hello-theme-3.4.4\",\"title\":\"3.4.4 - 2025-06-08\",\"description\":\"\\n            <ul>\\n\\t\\t\\t\\t<li>Tweak: Improve Header\\/Footer edit access from theme Home<\\/li>\\n            <\\/ul>\"},{\"id\":\"hello-theme-3.4.3\",\"title\":\"3.4.3 - 2025-05-26\",\"description\":\"\\n            <ul>\\n\\t\\t\\t\\t<li>Fix: Settings page empty after 3.4.0 in translated sites<\\/li>\\n\\t\\t\\t\\t<li>Fix: PHP 8.4 deprecation notice<\\/li>\\n            <\\/ul>\"},{\"id\":\"hello-theme-3.4.2\",\"title\":\"3.4.2 - 2025-05-19\",\"description\":\"\\n            <ul>\\n\\t\\t\\t\\t<li>Tweak: Set Home links font weight to regular<\\/li>\\n  \\t\\t        <li>Tweak: Dart SASS 3.0.0 - resolve scss deprecated warnings<\\/li>\\n    \\t\\t    <li>Fix: Settings page empty after 3.4.0<\\/li>\\n            <\\/ul>\"},{\"id\":\"hello-theme-3.4.0\",\"title\":\"3.4.0 - 2025-05-05\",\"description\":\"\\n            <ul>\\n                <li>New: Added Theme Home<\\/li>\\n\\t\\t\\t\\t<li>Tweak: Update theme settings page style<\\/li>\\n\\t\\t\\t\\t<li>Tweak: Update tested up to version 6.8<\\/li>\\n            <\\/ul>\"},{\"id\":\"hello-theme-3.3.0\",\"title\":\"3.3.0 - 2025-01-21\",\"description\":\"\\n            <ul>\\n                <li>Tweak: Added changelog link in theme settings<\\/li>\\n\\t\\t\\t\\t<li>Tweak: Updated minimum required Safari version to 15.5<\\/li>\\n  \\t\\t        <li>Tweak: Update autoprefixer to latest versions<\\/li>\\n            <\\/ul>\"},{\"id\":\"hello-theme-3.2.1\",\"title\":\"3.2.1 - 2024-12-16\",\"description\":\"\\n            <ul>\\n                <li>\\n                    Fix: Gutenberg editor expanded disproportionately after adding support for <code>theme.json<\\/code>\\n                    (<a href=\\\"https:\\/\\/github.com\\/elementor\\/hello-theme\\/issues\\/430\\\" target=\\\"_blank\\\">#430<\\/a>)\\n                <\\/li>\\n                <li>Fix: Use CSS logical properties in the theme<\\/li>\\n                <li>Fix: Add ARIA attributes to header nav menu<\\/li>\\n            <\\/ul>\"},{\"id\":\"hello-theme-3.2.0\",\"title\":\"3.2.0 - 2024-12-15\",\"description\":\"\\n            <ul>\\n                <li>Tweak: Convert classic to hybrid theme with block-editor support<\\/li>\\n                <li>Tweak: Added new design options to header\\/footer<\\/li>\\n                <li>Tweak: Update <code>Tested up to 6.7<\\/code><\\/li>\\n                <li>\\n                    Fix: Minify JS files\\n                    (<a href=\\\"https:\\/\\/github.com\\/elementor\\/hello-theme\\/issues\\/419\\\" target=\\\"_blank\\\">#419<\\/a>)\\n                <\\/li>\\n            <\\/ul>\"},{\"id\":\"hello-theme-3.1.1\",\"title\":\"3.1.1 - 2024-07-30\",\"description\":\"\\n            <ul>\\n                <li>Fix: Use consistent <code>&lt;h2&gt;<\\/code> for comments title and comment form<\\/li>\\n            <\\/ul>\"},{\"id\":\"hello-theme-3.1.0\",\"title\":\"3.1.0 - 2024-06-19\",\"description\":\"\\n            <ul>\\n                <li>Tweak: Update <code>Requires PHP 7.4<\\/code><\\/li>\\n                <li>Tweak: Update <code>Tested up to 6.5<\\/code><\\/li>\\n                <li>Tweak: Add the ability to style the brand layout<\\/li>\\n                <li>Tweak: Remove deprecated Elementor code<\\/li>\\n                <li>Tweak: Restore default focus styling inside the theme<\\/li>\\n                <li>Tweak: Add <code>aria-label<\\/code> attribute to various <code>&lt;nav&gt;<\\/code> elements<\\/li>\\n                <li>Tweak: Improve mobile menu keyboard accessibility<\\/li>\\n                <li>Tweak: Semantic mobile menu toggle button<\\/li>\\n                <li>Fix: The header renders redundant <code>&lt;p&gt;<\\/code> when tagline is empty<\\/li>\\n                <li>Fix: Single post renders redundant wrapping <code>&lt;div&gt;<\\/code> when it has no tags<\\/li>\\n                <li>Fix: Remove redundant wrapping <code>&lt;div&gt;<\\/code> from <code>wp_nav_menu()<\\/code> output<\\/li>\\n                <li>Fix: Wrap page <code>&lt;h1&gt;<\\/code> with <code>&lt;div&gt;<\\/code>, not <code>&lt;header&gt;<\\/code><\\/li>\\n                <li>Fix: Use consistent <code>&lt;h3&gt;<\\/code> for comments title and comment form<\\/li>\\n                <li>Fix: Remove heading tags from dynamic header\\/footer<\\/li>\\n                <li>\\n                    Fix: Mobile Menu hamburger is not visible for logged-out users in some cases\\n                    (<a href=\\\"https:\\/\\/github.com\\/elementor\\/hello-theme\\/issues\\/369\\\" target=\\\"_blank\\\">#369<\\/a>)\\n                <\\/li>\\n                <li>Fix: Remove duplicate ID attributes in the header mobile menu<\\/li>\\n                <li>\\n                    Fix: Remove redundant table styles\\n                    (<a href=\\\"https:\\/\\/github.com\\/elementor\\/hello-theme\\/issues\\/311\\\" target=\\\"_blank\\\">#311<\\/a>)\\n                <\\/li>\\n                <li>Fix: Remove redundant space below Site Logo in the header\\/footer<\\/li>\\n                <li>Fix: Remove redundant CSS from dynamic header\\/footer layout<\\/li>\\n                <li>\\n                    Fix: Separate post tags in single post\\n                    (<a href=\\\"https:\\/\\/github.com\\/elementor\\/hello-theme\\/issues\\/304\\\" target=\\\"_blank\\\">#304<\\/a>)\\n                <\\/li>\\n                <li>Fix: Display <code>the_tags()<\\/code> after <code>wp_link_pages()<\\/code><\\/li>\\n                <li>Fix: Remove page break navigation from archives when using <code>&lt;!--nextpage--&gt;<\\/code><\\/li>\\n                <li>Fix: Style posts pagination component layout<\\/li>\\n                <li>Fix: Add RTL support to pagination arrows in archive pages<\\/li>\\n                <li>\\n                    Fix: Update pagination prev\\/next labels and positions\\n                    (<a href=\\\"https:\\/\\/github.com\\/elementor\\/hello-theme\\/issues\\/404\\\" target=\\\"_blank\\\">#404<\\/a>)\\n                <\\/li>\\n                <li>Fix: Check if Elementor is loaded when using dynamic header & footer<\\/li>\\n            <\\/ul>\"},{\"id\":\"hello-theme-3.0.2\",\"title\":\"3.0.2 - 2024-05-28\",\"description\":\"\\n            <ul>\\n                <li>Internal: Version bump release to refresh WordPress repository<\\/li>\\n            <\\/ul>\"},{\"id\":\"hello-theme-3.0.1\",\"title\":\"3.0.1 - 2024-01-24\",\"description\":\"\\n            <ul>\\n                <li>Fix: Harden security for admin notice dismiss button<\\/li>\\n                <li>Fix: Add <code>alt<\\/code> attribute to all the images in the dashboard<\\/li>\\n            <\\/ul>\"},{\"id\":\"hello-theme-3.0.0\",\"title\":\"3.0.0 - 2023-12-26\",\"description\":\"\\n            <ul>\\n                <li>New: Option to disable cross-site header & footer<\\/li>\\n                <li>Tweak: Update <code>Requires PHP 7.3<\\/code><\\/li>\\n                <li>Tweak: Update <code>Tested up to 6.4<\\/code><\\/li>\\n                <li>Tweak: Move cross-site header & footer styles to a separate CSS file<\\/li>\\n                <li>Tweak: Don\'t load <code>header-footer.min.css<\\/code> when disabling header & footer<\\/li>\\n                <li>Tweak: Don\'t load <code>hello-frontend.min.js<\\/code> when disabling header & footer<\\/li>\\n                <li>Tweak: Replace jQuery code with vanilla JS in the frontend<\\/li>\\n                <li>Tweak: Replace jQuery code with vanilla JS in WordPress admin<\\/li>\\n                <li>Tweak: Remove unused JS code from the frontend<\\/li>\\n                <li>Tweak: Remove unused CSS code from the editor<\\/li>\\n                <li>Tweak: Remove unnecessary <code>role<\\/code> attributes from HTML landmark elements<\\/li>\\n                <li>Tweak: Link from Elementor Site Settings to Hello Theme Settings<\\/li>\\n                <li>Fix: Dynamic script version for better caching<\\/li>\\n            <\\/ul>\"}]\";}','off');
INSERT INTO `wp_79e54b1ec2_options` VALUES ('1315','wpaas_plugins_changed','1763940882','auto');
INSERT INTO `wp_79e54b1ec2_options` VALUES ('1316','elementor_active_kit','331','auto');
INSERT INTO `wp_79e54b1ec2_options` VALUES ('1317','elementor_font_display','swap','auto');
INSERT INTO `wp_79e54b1ec2_options` VALUES ('1318','recently_activated','a:0:{}','off');
INSERT INTO `wp_79e54b1ec2_options` VALUES ('1319','elementor_landing_pages_activation','0','auto');
INSERT INTO `wp_79e54b1ec2_options` VALUES ('1320','elementor_checklist','{\"last_opened_timestamp\":null,\"first_closed_checklist_in_editor\":true,\"is_popup_minimized\":false,\"steps\":{\"add_logo\":{\"is_marked_completed\":false,\"is_immutable_completed\":false},\"set_fonts_and_colors\":{\"is_marked_completed\":false,\"is_immutable_completed\":false},\"create_pages\":{\"is_marked_completed\":false,\"is_immutable_completed\":false},\"setup_header\":{\"is_marked_completed\":false,\"is_immutable_completed\":false},\"assign_homepage\":{\"is_marked_completed\":false,\"is_immutable_completed\":false}},\"should_open_in_editor\":false}','auto');
INSERT INTO `wp_79e54b1ec2_options` VALUES ('1321','elementor_version','3.33.1','auto');
INSERT INTO `wp_79e54b1ec2_options` VALUES ('1322','elementor_install_history','a:4:{s:6:\"3.11.2\";i:1761667396;s:6:\"3.32.5\";i:1761605422;s:6:\"3.33.0\";i:1762811197;s:6:\"3.33.1\";i:1763415862;}','auto');
INSERT INTO `wp_79e54b1ec2_options` VALUES ('1323','elementor_events_db_version','1.0.0','off');
INSERT INTO `wp_79e54b1ec2_options` VALUES ('1328','_elementor_installed_time','1761605423','auto');
INSERT INTO `wp_79e54b1ec2_options` VALUES ('1329','elementor_remote_info_feed_data','a:3:{i:0;a:5:{s:5:\"title\";s:76:\"Introducing Elementor 3.32: Transitions, Transform, Size Variables, and More\";s:7:\"excerpt\";s:250:\"Elementor 3.32 is here, accelerating Editor V4 Alpha with transform controls and layered transitions, system-wide Size Variables and streamlined class management. This release empowers you to build more consistent, dynamic, and professional websites.\";s:7:\"created\";i:1759243152;s:5:\"badge\";s:3:\"NEW\";s:3:\"url\";s:138:\"https://elementor.com/blog/elementor-332-v4-transform-transitions/?utm_source=wp-overview-widget&utm_medium=wp-dash&utm_campaign=news-feed\";}i:1;a:5:{s:5:\"title\";s:70:\"Introducing Elementor 3.31: New Editor V4 Variables, Filters, and More\";s:7:\"excerpt\";s:294:\"Elementor 3.31 is here, pushing Editor V4 forward with powerful design system enhancements and modern visual styling tools. From Variables and Filters to smarter editing workflows and semantic markup, this version makes it easier than ever to design beautiful, performant, and accessible sites.\";s:7:\"created\";i:1755094220;s:5:\"badge\";s:3:\"NEW\";s:3:\"url\";s:140:\"https://elementor.com/blog/elementor-331-v4-alpha-variables-filters/?utm_source=wp-overview-widget&utm_medium=wp-dash&utm_campaign=news-feed\";}i:2;a:5:{s:5:\"title\";s:67:\"What Is an MCP? The AI Breakthrough Web Creators Shouldn’t Ignore\";s:7:\"excerpt\";s:143:\"Discover how Model Context Protocol (MCP) is shaping AI-tool interaction and redefining how pro web creators build, manage, and scale websites.\";s:7:\"created\";i:1754310811;s:5:\"badge\";s:0:\"\";s:3:\"url\";s:130:\"https://elementor.com/blog/mcp-explained-for-web-creators/?utm_source=wp-overview-widget&utm_medium=wp-dash&utm_campaign=news-feed\";}}','off');
INSERT INTO `wp_79e54b1ec2_options` VALUES ('1342','gdl_pgi_site_content_nux_reported','1761605426','auto');
INSERT INTO `wp_79e54b1ec2_options` VALUES ('1399','template_kit_import_version','1.0.16','auto');
INSERT INTO `wp_79e54b1ec2_options` VALUES ('1400','template_kit_import_install_time','1761605587','auto');
INSERT INTO `wp_79e54b1ec2_options` VALUES ('1522','elementor_disable_color_schemes','yes','auto');
INSERT INTO `wp_79e54b1ec2_options` VALUES ('1526','elementor_disable_typography_schemes','yes','auto');
INSERT INTO `wp_79e54b1ec2_options` VALUES ('1545','metform__banner_last_check','1764163149','auto');
INSERT INTO `wp_79e54b1ec2_options` VALUES ('1546','metform__banner_data','O:8:\"stdClass\":10:{s:8:\"10021821\";O:8:\"stdClass\":7:{s:2:\"id\";i:10021821;s:5:\"title\";s:32:\"Wpmet Notice BFCM Dashboard 2025\";s:4:\"type\";s:6:\"notice\";s:6:\"screen\";s:9:\"dashboard\";s:5:\"start\";i:1762819200;s:3:\"end\";i:1765324800;s:4:\"data\";O:8:\"stdClass\":9:{s:4:\"type\";s:6:\"notice\";s:11:\"button_link\";s:29:\"https://wpmet.com/wpnoticeh80\";s:11:\"button_text\";s:16:\"Save $3,397 Now!\";s:11:\"notice_body\";s:259:\"<strong style=\"font-size: 24px; padding: 8px 0 5px; color: #; display: block;\">Wpmet’s Black Friday Sale is live<em data-start=\"1852\" data-end=\"1881\">!\r\n</em></strong><strong>\r\nSave up to $3,397 on the All-in-One WordPress Plugin Bundle (80% OFF) </strong>\";s:12:\"notice_image\";s:60:\"https://api.wpmet.com/auth/wp-content/uploads/2024/11/80.png\";s:9:\"blacklist\";s:0:\"\";s:9:\"whitelist\";s:0:\"\";s:9:\"style_css\";s:0:\"\";s:10:\"unique_key\";s:0:\"\";}}s:8:\"10021820\";O:8:\"stdClass\":7:{s:2:\"id\";i:10021820;s:5:\"title\";s:24:\"Wpmet BFCM Own page 2025\";s:4:\"type\";s:6:\"notice\";s:6:\"screen\";s:11:\"plugin_page\";s:5:\"start\";i:1762819200;s:3:\"end\";i:1765324800;s:4:\"data\";O:8:\"stdClass\":9:{s:4:\"type\";s:6:\"notice\";s:11:\"button_link\";s:29:\"https://wpmet.com/wpnoticeh80\";s:11:\"button_text\";s:16:\"Save $3,397 Now!\";s:11:\"notice_body\";s:257:\"<strong style=\"font-size: 24px; padding: 8px 0 5px; color: #; display: block;\">Wpmet’s Black Friday Sale is live<em data-start=\"1852\" data-end=\"1881\">!</em></strong><strong>\r\nSave up to $3,397 on the All-in-One WordPress Plugin Bundle (80% OFF) </strong>\";s:12:\"notice_image\";s:60:\"https://api.wpmet.com/auth/wp-content/uploads/2024/11/80.png\";s:9:\"blacklist\";s:0:\"\";s:9:\"whitelist\";s:0:\"\";s:9:\"style_css\";s:0:\"\";s:10:\"unique_key\";s:0:\"\";}}s:8:\"10020931\";O:8:\"stdClass\":7:{s:2:\"id\";i:10020931;s:5:\"title\";s:29:\"Wpmet Halloween Own page 2025\";s:4:\"type\";s:6:\"notice\";s:6:\"screen\";s:11:\"plugin_page\";s:5:\"start\";i:1760486400;s:3:\"end\";i:1762128000;s:4:\"data\";O:8:\"stdClass\":9:{s:4:\"type\";s:6:\"notice\";s:11:\"button_link\";s:29:\"https://wpmet.com/wpnoticeh78\";s:11:\"button_text\";s:16:\"Save $2,936 Now!\";s:11:\"notice_body\";s:475:\"<h3><strong style=\"font-size: 24px; padding: 8px 0 5px; color: #; display: block;\">Wpmet’s Halloween Sale is live<em data-start=\"1852\" data-end=\"1881\">!</em></strong></h3>\r\n<p style=\"font-size: 16px; margin-left: -2px;\"><strong>Save up to $2,936 on the All-in-One WordPress Plugin Bundle (78% OFF) </strong>Or <strong>enjoy up to 35% OFF</strong> on your favorite single plugins — <em data-start=\"794\" data-end=\"830\">ElementsKit, GutenKit, ShopEngine,</em> and more!!</p>\";s:12:\"notice_image\";s:64:\"https://api.wpmet.com/auth/wp-content/uploads/2025/10/78-Off.jpg\";s:9:\"blacklist\";s:0:\"\";s:9:\"whitelist\";s:0:\"\";s:9:\"style_css\";s:0:\"\";s:10:\"unique_key\";s:0:\"\";}}s:8:\"10020929\";O:8:\"stdClass\":7:{s:2:\"id\";i:10020929;s:5:\"title\";s:30:\"Wpmet Halloween Dashboard 2025\";s:4:\"type\";s:6:\"notice\";s:6:\"screen\";s:9:\"dashboard\";s:5:\"start\";i:1760486400;s:3:\"end\";i:1762128000;s:4:\"data\";O:8:\"stdClass\":9:{s:4:\"type\";s:6:\"notice\";s:11:\"button_link\";s:29:\"https://wpmet.com/wpnoticeh78\";s:11:\"button_text\";s:16:\"Save $2,936 Now!\";s:11:\"notice_body\";s:432:\"<h3><strong style=\"font-size: 24px; padding: 8px 0 5px; color: #; display: block;\">Wpmet’s Halloween Sale is live!</strong></h3>\r\n<p style=\"font-size: 16px; margin-left: -2px;\"><strong>Save up to $2,936 on the All-in-One WordPress Plugin Bundle (78% OFF) </strong>Or <strong>enjoy up to 35% OFF</strong> on your favorite single plugins — <em data-start=\"794\" data-end=\"830\">ElementsKit, GutenKit, ShopEngine,</em> and more!!</p>\";s:12:\"notice_image\";s:64:\"https://api.wpmet.com/auth/wp-content/uploads/2025/10/78-Off.jpg\";s:9:\"blacklist\";s:0:\"\";s:9:\"whitelist\";s:0:\"\";s:9:\"style_css\";s:0:\"\";s:10:\"unique_key\";s:0:\"\";}}s:8:\"10019444\";O:8:\"stdClass\":7:{s:2:\"id\";i:10019444;s:5:\"title\";s:27:\"Wpmet Birthday 2025 ownpage\";s:4:\"type\";s:6:\"notice\";s:6:\"screen\";s:11:\"plugin_page\";s:5:\"start\";i:1753920000;s:3:\"end\";i:1755561600;s:4:\"data\";O:8:\"stdClass\":9:{s:4:\"type\";s:6:\"notice\";s:11:\"button_link\";s:26:\"https://wpmet.com/notice51\";s:11:\"button_text\";s:20:\"Claim Your Discount!\";s:11:\"notice_body\";s:589:\"<h3><strong style=\"color: #; text-transform: sentencecase; font-size: 14px;\"><span style=\"color: #e60073;\">Wpmet Birthday Sale!!</span></strong></h3>\r\n<h3><strong style=\"font-size: 24px; padding: 8px 0 5px; color: #; display: block;\">Save up to $2,986 on Premium WordPress Bundle Plugin!</strong></h3>\r\n<p style=\"font-size: 16px; margin-left: -2px;\"><b>Get up to 30% discounts</b> on each of our PRO Single plugins — ElementsKit, GutenKit, ShopEngine, MetForm, EmailKit, WP Social, PopupKit, WP Ultimate Review — or get them <b>all in super-saver bundles to save 80% instantly!</b></p>\";s:12:\"notice_image\";s:60:\"https://api.wpmet.com/auth/wp-content/uploads/2024/11/80.png\";s:9:\"blacklist\";s:0:\"\";s:9:\"whitelist\";s:0:\"\";s:9:\"style_css\";s:0:\"\";s:10:\"unique_key\";s:0:\"\";}}s:8:\"10018928\";O:8:\"stdClass\":7:{s:2:\"id\";i:10018928;s:5:\"title\";s:29:\"Wpmet Birthday 2025 dashboard\";s:4:\"type\";s:6:\"notice\";s:6:\"screen\";s:9:\"dashboard\";s:5:\"start\";i:1753920000;s:3:\"end\";i:1755561600;s:4:\"data\";O:8:\"stdClass\":9:{s:4:\"type\";s:6:\"notice\";s:11:\"button_link\";s:26:\"https://wpmet.com/notice50\";s:11:\"button_text\";s:20:\"Claim Your Discount!\";s:11:\"notice_body\";s:589:\"<h3><strong style=\"color: #; text-transform: sentencecase; font-size: 14px;\"><span style=\"color: #e60073;\">Wpmet Birthday Sale!!</span></strong></h3>\r\n<h3><strong style=\"font-size: 24px; padding: 8px 0 5px; color: #; display: block;\">Save up to $2,986 on Premium WordPress Bundle Plugin!</strong></h3>\r\n<p style=\"font-size: 16px; margin-left: -2px;\"><b>Get up to 30% discounts</b> on each of our PRO Single plugins — ElementsKit, GutenKit, ShopEngine, MetForm, EmailKit, WP Social, PopupKit, WP Ultimate Review — or get them <b>all in super-saver bundles to save 80% instantly!</b></p>\";s:12:\"notice_image\";s:60:\"https://api.wpmet.com/auth/wp-content/uploads/2024/11/80.png\";s:9:\"blacklist\";s:0:\"\";s:9:\"whitelist\";s:0:\"\";s:9:\"style_css\";s:0:\"\";s:10:\"unique_key\";s:0:\"\";}}s:8:\"10018688\";O:8:\"stdClass\":7:{s:2:\"id\";i:10018688;s:5:\"title\";s:42:\"Wpmet 4th of July Flash Sale 2025 Ownpages\";s:4:\"type\";s:6:\"notice\";s:6:\"screen\";s:11:\"plugin_page\";s:5:\"start\";i:1751328000;s:3:\"end\";i:1752019200;s:4:\"data\";O:8:\"stdClass\":9:{s:4:\"type\";s:6:\"notice\";s:11:\"button_link\";s:26:\"https://wpmet.com/notice35\";s:11:\"button_text\";s:20:\"Claim Your Discount!\";s:11:\"notice_body\";s:585:\"<h3><strong style=\"color: #; text-transform: uppercase; font-size: 14px;\"><span style=\"color: #e60073;\">Happy 4th of July super Sale!!</span></strong></h3>\r\n<h3><strong style=\"font-size: 24px; padding: 8px 0 5px; color: #; display: block;\">Save up to $2,986 on Premium WordPress Bundle Plugin!</strong></h3>\r\n<p style=\"font-size: 16px; margin-left: -2px;\"><b>Get up to 30% discounts</b> on each of our PRO Single plugins — ElementsKit, GutenKit, ShopEngine, MetForm, EmailKit, WP Social, WP Ultimate Review — or get them <b>all in super-saver bundles to save 80% instantly!</b></p>\";s:12:\"notice_image\";s:60:\"https://api.wpmet.com/auth/wp-content/uploads/2024/11/80.png\";s:9:\"blacklist\";s:0:\"\";s:9:\"whitelist\";s:0:\"\";s:9:\"style_css\";s:0:\"\";s:10:\"unique_key\";s:0:\"\";}}s:8:\"10018687\";O:8:\"stdClass\":7:{s:2:\"id\";i:10018687;s:5:\"title\";s:43:\"Wpmet 4th of July Flash Sale 2025 Dashboard\";s:4:\"type\";s:6:\"notice\";s:6:\"screen\";s:9:\"dashboard\";s:5:\"start\";i:1751328000;s:3:\"end\";i:1752019200;s:4:\"data\";O:8:\"stdClass\":9:{s:4:\"type\";s:6:\"notice\";s:11:\"button_link\";s:26:\"https://wpmet.com/notice35\";s:11:\"button_text\";s:20:\"Claim Your Discount!\";s:11:\"notice_body\";s:585:\"<h3><strong style=\"color: #; text-transform: uppercase; font-size: 14px;\"><span style=\"color: #e60073;\">Happy 4th of July super Sale!!</span></strong></h3>\r\n<h3><strong style=\"font-size: 24px; padding: 8px 0 5px; color: #; display: block;\">Save up to $2,986 on Premium WordPress Bundle Plugin!</strong></h3>\r\n<p style=\"font-size: 16px; margin-left: -2px;\"><b>Get up to 30% discounts</b> on each of our PRO Single plugins — ElementsKit, GutenKit, ShopEngine, MetForm, EmailKit, WP Social, WP Ultimate Review — or get them <b>all in super-saver bundles to save 80% instantly!</b></p>\";s:12:\"notice_image\";s:60:\"https://api.wpmet.com/auth/wp-content/uploads/2024/11/80.png\";s:9:\"blacklist\";s:0:\"\";s:9:\"whitelist\";s:0:\"\";s:9:\"style_css\";s:0:\"\";s:10:\"unique_key\";s:0:\"\";}}s:8:\"10018221\";O:8:\"stdClass\":7:{s:2:\"id\";i:10018221;s:5:\"title\";s:43:\"WordPress Birthday Flash Sale 2025 Own Page\";s:4:\"type\";s:6:\"notice\";s:6:\"screen\";s:11:\"plugin_page\";s:5:\"start\";i:1748304000;s:3:\"end\";i:1748649600;s:4:\"data\";O:8:\"stdClass\":9:{s:4:\"type\";s:6:\"notice\";s:11:\"button_link\";s:32:\"www.wpmet.com/banner//wpbirthday\";s:11:\"button_text\";s:29:\"Claim Your Birthday Discount!\";s:11:\"notice_body\";s:590:\"<h3><strong style=\"color: #; text-transform: uppercase; font-size: 14px;\"><span style=\"color: #e60073;\">WordPress Birthday Deals from Wpmet</span></strong></h3>\r\n<h3><strong style=\"font-size: 24px; padding: 8px 0 5px; color: #; display: block;\">Save up to $2,986 on Premium WordPress Bundle Plugin!</strong></h3>\r\n<p style=\"font-size: 16px; margin-left: -2px;\"><b>Get up to 30% discounts</b> on each of our PRO Single plugins — ElementsKit, GutenKit, ShopEngine, MetForm, EmailKit, WP Social, WP Ultimate Review — or get them <b>all in super-saver bundles to save 80% instantly!</b></p>\";s:12:\"notice_image\";s:60:\"https://api.wpmet.com/auth/wp-content/uploads/2024/11/80.png\";s:9:\"blacklist\";s:0:\"\";s:9:\"whitelist\";s:0:\"\";s:9:\"style_css\";s:0:\"\";s:10:\"unique_key\";s:0:\"\";}}s:8:\"10018220\";O:8:\"stdClass\":7:{s:2:\"id\";i:10018220;s:5:\"title\";s:44:\"WordPress Birthday Flash Sale 2025 Dashboard\";s:4:\"type\";s:6:\"notice\";s:6:\"screen\";s:9:\"dashboard\";s:5:\"start\";i:1748304000;s:3:\"end\";i:1748649600;s:4:\"data\";O:8:\"stdClass\":9:{s:4:\"type\";s:6:\"notice\";s:11:\"button_link\";s:32:\"www.wpmet.com/banner//wpbirthday\";s:11:\"button_text\";s:29:\"Claim Your Birthday Discount!\";s:11:\"notice_body\";s:590:\"<h3><strong style=\"color: #; text-transform: uppercase; font-size: 14px;\"><span style=\"color: #e60073;\">WordPress Birthday Deals from Wpmet</span></strong></h3>\r\n<h3><strong style=\"font-size: 24px; padding: 8px 0 5px; color: #; display: block;\">Save up to $2,986 on Premium WordPress Bundle Plugin!</strong></h3>\r\n<p style=\"font-size: 16px; margin-left: -2px;\"><b>Get up to 30% discounts</b> on each of our PRO Single plugins — ElementsKit, GutenKit, ShopEngine, MetForm, EmailKit, WP Social, WP Ultimate Review — or get them <b>all in super-saver bundles to save 80% instantly!</b></p>\";s:12:\"notice_image\";s:60:\"https://api.wpmet.com/auth/wp-content/uploads/2024/11/80.png\";s:9:\"blacklist\";s:0:\"\";s:9:\"whitelist\";s:0:\"\";s:9:\"style_css\";s:0:\"\";s:10:\"unique_key\";s:0:\"\";}}}','auto');
INSERT INTO `wp_79e54b1ec2_options` VALUES ('1547','elementskit-lite__banner_last_check','1764163149','auto');
INSERT INTO `wp_79e54b1ec2_options` VALUES ('1548','elementskit-lite__banner_data','O:8:\"stdClass\":10:{s:8:\"10021821\";O:8:\"stdClass\":7:{s:2:\"id\";i:10021821;s:5:\"title\";s:32:\"Wpmet Notice BFCM Dashboard 2025\";s:4:\"type\";s:6:\"notice\";s:6:\"screen\";s:9:\"dashboard\";s:5:\"start\";i:1762819200;s:3:\"end\";i:1765324800;s:4:\"data\";O:8:\"stdClass\":9:{s:4:\"type\";s:6:\"notice\";s:11:\"button_link\";s:29:\"https://wpmet.com/wpnoticeh80\";s:11:\"button_text\";s:16:\"Save $3,397 Now!\";s:11:\"notice_body\";s:259:\"<strong style=\"font-size: 24px; padding: 8px 0 5px; color: #; display: block;\">Wpmet’s Black Friday Sale is live<em data-start=\"1852\" data-end=\"1881\">!\r\n</em></strong><strong>\r\nSave up to $3,397 on the All-in-One WordPress Plugin Bundle (80% OFF) </strong>\";s:12:\"notice_image\";s:60:\"https://api.wpmet.com/auth/wp-content/uploads/2024/11/80.png\";s:9:\"blacklist\";s:0:\"\";s:9:\"whitelist\";s:0:\"\";s:9:\"style_css\";s:0:\"\";s:10:\"unique_key\";s:0:\"\";}}s:8:\"10021820\";O:8:\"stdClass\":7:{s:2:\"id\";i:10021820;s:5:\"title\";s:24:\"Wpmet BFCM Own page 2025\";s:4:\"type\";s:6:\"notice\";s:6:\"screen\";s:11:\"plugin_page\";s:5:\"start\";i:1762819200;s:3:\"end\";i:1765324800;s:4:\"data\";O:8:\"stdClass\":9:{s:4:\"type\";s:6:\"notice\";s:11:\"button_link\";s:29:\"https://wpmet.com/wpnoticeh80\";s:11:\"button_text\";s:16:\"Save $3,397 Now!\";s:11:\"notice_body\";s:257:\"<strong style=\"font-size: 24px; padding: 8px 0 5px; color: #; display: block;\">Wpmet’s Black Friday Sale is live<em data-start=\"1852\" data-end=\"1881\">!</em></strong><strong>\r\nSave up to $3,397 on the All-in-One WordPress Plugin Bundle (80% OFF) </strong>\";s:12:\"notice_image\";s:60:\"https://api.wpmet.com/auth/wp-content/uploads/2024/11/80.png\";s:9:\"blacklist\";s:0:\"\";s:9:\"whitelist\";s:0:\"\";s:9:\"style_css\";s:0:\"\";s:10:\"unique_key\";s:0:\"\";}}s:8:\"10020931\";O:8:\"stdClass\":7:{s:2:\"id\";i:10020931;s:5:\"title\";s:29:\"Wpmet Halloween Own page 2025\";s:4:\"type\";s:6:\"notice\";s:6:\"screen\";s:11:\"plugin_page\";s:5:\"start\";i:1760486400;s:3:\"end\";i:1762128000;s:4:\"data\";O:8:\"stdClass\":9:{s:4:\"type\";s:6:\"notice\";s:11:\"button_link\";s:29:\"https://wpmet.com/wpnoticeh78\";s:11:\"button_text\";s:16:\"Save $2,936 Now!\";s:11:\"notice_body\";s:475:\"<h3><strong style=\"font-size: 24px; padding: 8px 0 5px; color: #; display: block;\">Wpmet’s Halloween Sale is live<em data-start=\"1852\" data-end=\"1881\">!</em></strong></h3>\r\n<p style=\"font-size: 16px; margin-left: -2px;\"><strong>Save up to $2,936 on the All-in-One WordPress Plugin Bundle (78% OFF) </strong>Or <strong>enjoy up to 35% OFF</strong> on your favorite single plugins — <em data-start=\"794\" data-end=\"830\">ElementsKit, GutenKit, ShopEngine,</em> and more!!</p>\";s:12:\"notice_image\";s:64:\"https://api.wpmet.com/auth/wp-content/uploads/2025/10/78-Off.jpg\";s:9:\"blacklist\";s:0:\"\";s:9:\"whitelist\";s:0:\"\";s:9:\"style_css\";s:0:\"\";s:10:\"unique_key\";s:0:\"\";}}s:8:\"10020929\";O:8:\"stdClass\":7:{s:2:\"id\";i:10020929;s:5:\"title\";s:30:\"Wpmet Halloween Dashboard 2025\";s:4:\"type\";s:6:\"notice\";s:6:\"screen\";s:9:\"dashboard\";s:5:\"start\";i:1760486400;s:3:\"end\";i:1762128000;s:4:\"data\";O:8:\"stdClass\":9:{s:4:\"type\";s:6:\"notice\";s:11:\"button_link\";s:29:\"https://wpmet.com/wpnoticeh78\";s:11:\"button_text\";s:16:\"Save $2,936 Now!\";s:11:\"notice_body\";s:432:\"<h3><strong style=\"font-size: 24px; padding: 8px 0 5px; color: #; display: block;\">Wpmet’s Halloween Sale is live!</strong></h3>\r\n<p style=\"font-size: 16px; margin-left: -2px;\"><strong>Save up to $2,936 on the All-in-One WordPress Plugin Bundle (78% OFF) </strong>Or <strong>enjoy up to 35% OFF</strong> on your favorite single plugins — <em data-start=\"794\" data-end=\"830\">ElementsKit, GutenKit, ShopEngine,</em> and more!!</p>\";s:12:\"notice_image\";s:64:\"https://api.wpmet.com/auth/wp-content/uploads/2025/10/78-Off.jpg\";s:9:\"blacklist\";s:0:\"\";s:9:\"whitelist\";s:0:\"\";s:9:\"style_css\";s:0:\"\";s:10:\"unique_key\";s:0:\"\";}}s:8:\"10019444\";O:8:\"stdClass\":7:{s:2:\"id\";i:10019444;s:5:\"title\";s:27:\"Wpmet Birthday 2025 ownpage\";s:4:\"type\";s:6:\"notice\";s:6:\"screen\";s:11:\"plugin_page\";s:5:\"start\";i:1753920000;s:3:\"end\";i:1755561600;s:4:\"data\";O:8:\"stdClass\":9:{s:4:\"type\";s:6:\"notice\";s:11:\"button_link\";s:26:\"https://wpmet.com/notice51\";s:11:\"button_text\";s:20:\"Claim Your Discount!\";s:11:\"notice_body\";s:589:\"<h3><strong style=\"color: #; text-transform: sentencecase; font-size: 14px;\"><span style=\"color: #e60073;\">Wpmet Birthday Sale!!</span></strong></h3>\r\n<h3><strong style=\"font-size: 24px; padding: 8px 0 5px; color: #; display: block;\">Save up to $2,986 on Premium WordPress Bundle Plugin!</strong></h3>\r\n<p style=\"font-size: 16px; margin-left: -2px;\"><b>Get up to 30% discounts</b> on each of our PRO Single plugins — ElementsKit, GutenKit, ShopEngine, MetForm, EmailKit, WP Social, PopupKit, WP Ultimate Review — or get them <b>all in super-saver bundles to save 80% instantly!</b></p>\";s:12:\"notice_image\";s:60:\"https://api.wpmet.com/auth/wp-content/uploads/2024/11/80.png\";s:9:\"blacklist\";s:0:\"\";s:9:\"whitelist\";s:0:\"\";s:9:\"style_css\";s:0:\"\";s:10:\"unique_key\";s:0:\"\";}}s:8:\"10018928\";O:8:\"stdClass\":7:{s:2:\"id\";i:10018928;s:5:\"title\";s:29:\"Wpmet Birthday 2025 dashboard\";s:4:\"type\";s:6:\"notice\";s:6:\"screen\";s:9:\"dashboard\";s:5:\"start\";i:1753920000;s:3:\"end\";i:1755561600;s:4:\"data\";O:8:\"stdClass\":9:{s:4:\"type\";s:6:\"notice\";s:11:\"button_link\";s:26:\"https://wpmet.com/notice50\";s:11:\"button_text\";s:20:\"Claim Your Discount!\";s:11:\"notice_body\";s:589:\"<h3><strong style=\"color: #; text-transform: sentencecase; font-size: 14px;\"><span style=\"color: #e60073;\">Wpmet Birthday Sale!!</span></strong></h3>\r\n<h3><strong style=\"font-size: 24px; padding: 8px 0 5px; color: #; display: block;\">Save up to $2,986 on Premium WordPress Bundle Plugin!</strong></h3>\r\n<p style=\"font-size: 16px; margin-left: -2px;\"><b>Get up to 30% discounts</b> on each of our PRO Single plugins — ElementsKit, GutenKit, ShopEngine, MetForm, EmailKit, WP Social, PopupKit, WP Ultimate Review — or get them <b>all in super-saver bundles to save 80% instantly!</b></p>\";s:12:\"notice_image\";s:60:\"https://api.wpmet.com/auth/wp-content/uploads/2024/11/80.png\";s:9:\"blacklist\";s:0:\"\";s:9:\"whitelist\";s:0:\"\";s:9:\"style_css\";s:0:\"\";s:10:\"unique_key\";s:0:\"\";}}s:8:\"10018688\";O:8:\"stdClass\":7:{s:2:\"id\";i:10018688;s:5:\"title\";s:42:\"Wpmet 4th of July Flash Sale 2025 Ownpages\";s:4:\"type\";s:6:\"notice\";s:6:\"screen\";s:11:\"plugin_page\";s:5:\"start\";i:1751328000;s:3:\"end\";i:1752019200;s:4:\"data\";O:8:\"stdClass\":9:{s:4:\"type\";s:6:\"notice\";s:11:\"button_link\";s:26:\"https://wpmet.com/notice35\";s:11:\"button_text\";s:20:\"Claim Your Discount!\";s:11:\"notice_body\";s:585:\"<h3><strong style=\"color: #; text-transform: uppercase; font-size: 14px;\"><span style=\"color: #e60073;\">Happy 4th of July super Sale!!</span></strong></h3>\r\n<h3><strong style=\"font-size: 24px; padding: 8px 0 5px; color: #; display: block;\">Save up to $2,986 on Premium WordPress Bundle Plugin!</strong></h3>\r\n<p style=\"font-size: 16px; margin-left: -2px;\"><b>Get up to 30% discounts</b> on each of our PRO Single plugins — ElementsKit, GutenKit, ShopEngine, MetForm, EmailKit, WP Social, WP Ultimate Review — or get them <b>all in super-saver bundles to save 80% instantly!</b></p>\";s:12:\"notice_image\";s:60:\"https://api.wpmet.com/auth/wp-content/uploads/2024/11/80.png\";s:9:\"blacklist\";s:0:\"\";s:9:\"whitelist\";s:0:\"\";s:9:\"style_css\";s:0:\"\";s:10:\"unique_key\";s:0:\"\";}}s:8:\"10018687\";O:8:\"stdClass\":7:{s:2:\"id\";i:10018687;s:5:\"title\";s:43:\"Wpmet 4th of July Flash Sale 2025 Dashboard\";s:4:\"type\";s:6:\"notice\";s:6:\"screen\";s:9:\"dashboard\";s:5:\"start\";i:1751328000;s:3:\"end\";i:1752019200;s:4:\"data\";O:8:\"stdClass\":9:{s:4:\"type\";s:6:\"notice\";s:11:\"button_link\";s:26:\"https://wpmet.com/notice35\";s:11:\"button_text\";s:20:\"Claim Your Discount!\";s:11:\"notice_body\";s:585:\"<h3><strong style=\"color: #; text-transform: uppercase; font-size: 14px;\"><span style=\"color: #e60073;\">Happy 4th of July super Sale!!</span></strong></h3>\r\n<h3><strong style=\"font-size: 24px; padding: 8px 0 5px; color: #; display: block;\">Save up to $2,986 on Premium WordPress Bundle Plugin!</strong></h3>\r\n<p style=\"font-size: 16px; margin-left: -2px;\"><b>Get up to 30% discounts</b> on each of our PRO Single plugins — ElementsKit, GutenKit, ShopEngine, MetForm, EmailKit, WP Social, WP Ultimate Review — or get them <b>all in super-saver bundles to save 80% instantly!</b></p>\";s:12:\"notice_image\";s:60:\"https://api.wpmet.com/auth/wp-content/uploads/2024/11/80.png\";s:9:\"blacklist\";s:0:\"\";s:9:\"whitelist\";s:0:\"\";s:9:\"style_css\";s:0:\"\";s:10:\"unique_key\";s:0:\"\";}}s:8:\"10018221\";O:8:\"stdClass\":7:{s:2:\"id\";i:10018221;s:5:\"title\";s:43:\"WordPress Birthday Flash Sale 2025 Own Page\";s:4:\"type\";s:6:\"notice\";s:6:\"screen\";s:11:\"plugin_page\";s:5:\"start\";i:1748304000;s:3:\"end\";i:1748649600;s:4:\"data\";O:8:\"stdClass\":9:{s:4:\"type\";s:6:\"notice\";s:11:\"button_link\";s:32:\"www.wpmet.com/banner//wpbirthday\";s:11:\"button_text\";s:29:\"Claim Your Birthday Discount!\";s:11:\"notice_body\";s:590:\"<h3><strong style=\"color: #; text-transform: uppercase; font-size: 14px;\"><span style=\"color: #e60073;\">WordPress Birthday Deals from Wpmet</span></strong></h3>\r\n<h3><strong style=\"font-size: 24px; padding: 8px 0 5px; color: #; display: block;\">Save up to $2,986 on Premium WordPress Bundle Plugin!</strong></h3>\r\n<p style=\"font-size: 16px; margin-left: -2px;\"><b>Get up to 30% discounts</b> on each of our PRO Single plugins — ElementsKit, GutenKit, ShopEngine, MetForm, EmailKit, WP Social, WP Ultimate Review — or get them <b>all in super-saver bundles to save 80% instantly!</b></p>\";s:12:\"notice_image\";s:60:\"https://api.wpmet.com/auth/wp-content/uploads/2024/11/80.png\";s:9:\"blacklist\";s:0:\"\";s:9:\"whitelist\";s:0:\"\";s:9:\"style_css\";s:0:\"\";s:10:\"unique_key\";s:0:\"\";}}s:8:\"10018220\";O:8:\"stdClass\":7:{s:2:\"id\";i:10018220;s:5:\"title\";s:44:\"WordPress Birthday Flash Sale 2025 Dashboard\";s:4:\"type\";s:6:\"notice\";s:6:\"screen\";s:9:\"dashboard\";s:5:\"start\";i:1748304000;s:3:\"end\";i:1748649600;s:4:\"data\";O:8:\"stdClass\":9:{s:4:\"type\";s:6:\"notice\";s:11:\"button_link\";s:32:\"www.wpmet.com/banner//wpbirthday\";s:11:\"button_text\";s:29:\"Claim Your Birthday Discount!\";s:11:\"notice_body\";s:590:\"<h3><strong style=\"color: #; text-transform: uppercase; font-size: 14px;\"><span style=\"color: #e60073;\">WordPress Birthday Deals from Wpmet</span></strong></h3>\r\n<h3><strong style=\"font-size: 24px; padding: 8px 0 5px; color: #; display: block;\">Save up to $2,986 on Premium WordPress Bundle Plugin!</strong></h3>\r\n<p style=\"font-size: 16px; margin-left: -2px;\"><b>Get up to 30% discounts</b> on each of our PRO Single plugins — ElementsKit, GutenKit, ShopEngine, MetForm, EmailKit, WP Social, WP Ultimate Review — or get them <b>all in super-saver bundles to save 80% instantly!</b></p>\";s:12:\"notice_image\";s:60:\"https://api.wpmet.com/auth/wp-content/uploads/2024/11/80.png\";s:9:\"blacklist\";s:0:\"\";s:9:\"whitelist\";s:0:\"\";s:9:\"style_css\";s:0:\"\";s:10:\"unique_key\";s:0:\"\";}}}','auto');
INSERT INTO `wp_79e54b1ec2_options` VALUES ('1654','e_editor_counter','38','auto');
INSERT INTO `wp_79e54b1ec2_options` VALUES ('1655','_elementor_free_to_pro_upsell','a:2:{s:7:\"timeout\";i:1761668048;s:5:\"value\";s:723:\"[{\"id\":\"animated_headline\",\"imageSrc\":\"https:\\/\\/assets.elementor.com\\/free-to-pro-upsell\\/v1\\/images\\/animated_headline.jpg\"},{\"id\":\"video_playlist\",\"imageSrc\":\"https:\\/\\/assets.elementor.com\\/free-to-pro-upsell\\/v1\\/images\\/video_playlist.jpg\"},{\"id\":\"cta\",\"imageSrc\":\"https:\\/\\/assets.elementor.com\\/free-to-pro-upsell\\/v1\\/images\\/cta.jpg\"},{\"id\":\"testimonial_widget\",\"imageSrc\":\"https:\\/\\/assets.elementor.com\\/free-to-pro-upsell\\/v1\\/images\\/testimonial_widget.jpg\"},{\"id\":\"image_carousel\",\"imageSrc\":\"https:\\/\\/assets.elementor.com\\/free-to-pro-upsell\\/v1\\/images\\/image_carousel.jpg\"},{\"id\":\"connect-pro-upgrade\",\"imageSrc\":\"https:\\/\\/assets.elementor.com\\/free-to-pro-upsell\\/v1\\/images\\/connect-pro-upgrade.jpg\"}]\";}','off');
INSERT INTO `wp_79e54b1ec2_options` VALUES ('1656','_elementor_notifications_data','a:2:{s:7:\"timeout\";i:1762185285;s:5:\"value\";s:15038:\"[{\"id\":\"transform-3.32\",\"title\":\"Design with depth using Transform\",\"description\":\"Move, scale, rotate, and skew any element with ease. Transform controls add depth, stacked effects, and seamless States for hover, focus, and active micro-interactions.\",\"topic\":\"Editor V4 Alpha\",\"imageSrc\":\"https:\\/\\/assets.elementor.com\\/notifications\\/v1\\/images\\/3.32-transform.png\",\"chipTags\":[\"New Feature\"],\"link\":\"https:\\/\\/go.elementor.com\\/go-pro-notification-3.32-blog\\/\",\"readMoreText\":\"Learn More\"},{\"id\":\"size-variable-3.32\",\"title\":\"Consistency with Size Variables\",\"description\":\"Define reusable values for properties like spacing or typography, then update them once to scale changes instantly across your site.\",\"topic\":\"Elementor Pro 3.32\",\"imageSrc\":\"https:\\/\\/assets.elementor.com\\/notifications\\/v1\\/images\\/3.32-size-variables.png\",\"chipPlan\":\"Pro\",\"chipTags\":[\"New Feature\"],\"link\":\"https:\\/\\/go.elementor.com\\/go-pro-notification-3.32-blog\\/\",\"readMoreText\":\"Learn More\",\"conditions\":[[{\"type\":\"plugin\",\"plugin\":\"elementor-pro\\/elementor-pro.php\"}]]},{\"id\":\"size-variable-3.32\",\"title\":\"Consistency with Size Variables\",\"description\":\"Define reusable values for properties like spacing or typography, then update them once to scale changes instantly across your site.\",\"topic\":\"Elementor Pro 3.32\",\"imageSrc\":\"https:\\/\\/assets.elementor.com\\/notifications\\/v1\\/images\\/3.32-size-variables.png\",\"chipTags\":[\"New Feature\"],\"cta\":\"Upgrade now\",\"ctaLink\":\"https:\\/\\/go.elementor.com\\/go-pro-notification-3.32-size-variable\\/\"},{\"id\":\"transitions-3.32\",\"title\":\"Smooth interactions with Transitions\",\"description\":\"Bring polish to every interaction. Transitions let you animate style changes smoothly between states. In Pro, layer multiple transitions by property for refined, modern micro-animations.\",\"topic\":\"Editor V4 Alpha\",\"imageSrc\":\"https:\\/\\/assets.elementor.com\\/notifications\\/v1\\/images\\/3.32-transition.png\",\"chipTags\":[\"New Feature\"],\"link\":\"https:\\/\\/go.elementor.com\\/go-pro-notification-3.32-blog\\/\",\"readMoreText\":\"Learn More\"},{\"id\":\"variables-3.31\",\"title\":\"Scalable design with Variables\",\"description\":\"Define once, reuse everywhere. Color & Font Variables help you build consistent, scalable design systems that update globally and are perfect for large sites or teams.\",\"topic\":\"Editor V4 Alpha\",\"imageSrc\":\"https:\\/\\/assets.elementor.com\\/notifications\\/v1\\/images\\/3.31-variables.png\",\"chipTags\":[\"New Feature\"],\"link\":\"https:\\/\\/go.elementor.com\\/go-pro-notification-3.31-v4-blog\\/\",\"readMoreText\":\"Learn More\"},{\"id\":\"filters-3.31\",\"title\":\"Visual effects with Filters and Backdrop Filters\",\"description\":\"Apply multiple Filters like blur, brightness, and contrast. Stack, reorder, and preview in real time without writing a line of code.\",\"topic\":\"Editor V4 Alpha\",\"imageSrc\":\"https:\\/\\/assets.elementor.com\\/notifications\\/v1\\/images\\/3.31-filters.png\",\"chipTags\":[\"New Feature\"],\"link\":\"https:\\/\\/go.elementor.com\\/go-pro-notification-3.31-v4-blog\\/\",\"readMoreText\":\"Learn More\"},{\"id\":\"ally-assistant\",\"title\":\"New! Fix accessibility issues with Ally Assistant\",\"description\":\"Scan any page for accessibility issues and fix them in one click. From color contrast to missing alt text, Ally Assistant provides guided steps or AI-powered fixes to make your site more inclusive.\",\"topic\":\"Ally by Elementor\",\"imageSrc\":\"https:\\/\\/assets.elementor.com\\/notifications\\/v1\\/images\\/ally-assistant.png\",\"chipTags\":[\"New Feature\"],\"cta\":\"Scan for free\",\"ctaLink\":\"http:\\/\\/go.elementor.com\\/acc-assistant-launch-whats-new\",\"conditions\":[[{\"type\":\"plugin\",\"operator\":\"!=\",\"plugin\":\"pojo-accessibility\\/pojo-accessibility.php\"}]]},{\"id\":\"classes-3.31\",\"title\":\"Smarter Class Manager tools\",\"description\":\"Quickly locate and manage Global Classes with usage counts, a new locator panel, and full class search. Perfect for scaling and refactoring complex design systems.\",\"topic\":\"Editor V4 Alpha\",\"imageSrc\":\"https:\\/\\/assets.elementor.com\\/notifications\\/v1\\/images\\/3.31-classes.png\",\"chipTags\":[\"New Feature\"],\"link\":\"https:\\/\\/go.elementor.com\\/go-pro-notification-3.31-v4-blog\\/\",\"readMoreText\":\"Learn More\"},{\"id\":\"send-notification-august\",\"title\":\"All Your Assets, One Library\",\"description\":\"Save time and skip the re-uploads - now you can pull images straight from your WordPress Media Library into Send. Faster, simpler, and built for WordPress.\",\"topic\":\"Send: Email & SMS built for WooCommerce\",\"imageSrc\":\"https:\\/\\/assets.elementor.com\\/notifications\\/v1\\/images\\/aug_send.png\",\"chipTags\":[\"Cart abandonment\"],\"cta\":\"Upload Your Assets\",\"ctaLink\":\"https:\\/\\/go.elementor.com\\/ML_WN\",\"conditions\":[[{\"type\":\"plugin\",\"operator\":\"!=\",\"plugin\":\"send-app\\/send-app.php\"}]]},{\"id\":\"attributes-3.31\",\"title\":\"Add semantic HTML with Attributes\",\"description\":\"Add custom HTML attributes like aria-*, data-*, and role to any element. Structure your markup for better accessibility, performance, and compliance.\",\"topic\":\"Elementor Pro 3.31\",\"imageSrc\":\"https:\\/\\/assets.elementor.com\\/notifications\\/v1\\/images\\/3.31-attributes.png\",\"chipPlan\":\"Pro\",\"chipTags\":[\"New Feature\"],\"link\":\"https:\\/\\/go.elementor.com\\/go-pro-notification-3.31-v4-blog\\/\",\"readMoreText\":\"Learn More\",\"conditions\":[[{\"type\":\"plugin\",\"plugin\":\"elementor-pro\\/elementor-pro.php\"}]]},{\"id\":\"attributes-3.31\",\"title\":\"Add semantic HTML with Attributes\",\"description\":\"Add custom HTML attributes like aria-*, data-*, and role to any element. Structure your markup for better accessibility, performance, and compliance.\",\"topic\":\"Elementor Pro 3.31\",\"imageSrc\":\"https:\\/\\/assets.elementor.com\\/notifications\\/v1\\/images\\/3.31-attributes.png\",\"chipTags\":[\"New Feature\"],\"cta\":\"Upgrade now\",\"ctaLink\":\"https:\\/\\/go.elementor.com\\/go-pro-notification-3.31-attributes\\/\"},{\"id\":\"classes-3.30\",\"title\":\"Better class control\",\"description\":\"Get popovers with your class name, breakpoint, state and possible conflicts. Plus, the exact class names you define are now reflected in the code, making debugging and working with external tools easier!\",\"topic\":\"Editor V4 Alpha\",\"imageSrc\":\"https:\\/\\/assets.elementor.com\\/notifications\\/v1\\/images\\/classes-3.30.png\",\"chipTags\":[\"New Feature\"],\"link\":\"https:\\/\\/go.elementor.com\\/go-pro-notification-3.39-v4-blog\\/\",\"readMoreText\":\"Learn More\"},{\"id\":\"cloud-websites-3.30\",\"title\":\"Full Website Templates in the cloud\",\"description\":\"Save and apply entire websites, including multiple pages, styles, site settings, media, and layout configurations - directly from the cloud.\",\"topic\":\"Elementor Pro 3.30\",\"imageSrc\":\"https:\\/\\/assets.elementor.com\\/notifications\\/v1\\/images\\/cloud-3.30.png\",\"chipPlan\":\"Pro\",\"chipTags\":[\"New Feature\"],\"link\":\"https:\\/\\/go.elementor.com\\/go-pro-notification-3.39-v4-blog\\/\",\"readMoreText\":\"Learn More\",\"conditions\":[[{\"type\":\"plugin\",\"plugin\":\"elementor-pro\\/elementor-pro.php\"}]]},{\"id\":\"cloud-websites-3.30\",\"title\":\"Full Website Templates in the cloud\",\"description\":\"Save and apply entire websites, including multiple pages, styles, site settings, media, and layout configurations - directly from the cloud.\",\"topic\":\"Elementor Pro 3.30\",\"imageSrc\":\"https:\\/\\/assets.elementor.com\\/notifications\\/v1\\/images\\/cloud-3.30.png\",\"chipTags\":[\"New Feature\"],\"cta\":\"Upgrade now\",\"ctaLink\":\"https:\\/\\/go.elementor.com\\/go-pro-notification-3.30-cloud-websites\\/\"},{\"id\":\"youtube-3.30\",\"title\":\"YouTube Element\",\"description\":\"The new YouTube Element is purpose-built to support V4 capabilities with faster rendering, better performance, and familiar controls like autoplay, loop, mute, and aspect ratio.\",\"topic\":\"Editor V4 Alpha\",\"imageSrc\":\"https:\\/\\/assets.elementor.com\\/notifications\\/v1\\/images\\/youtube-3.30.png\",\"chipTags\":[\"New Feature\"],\"link\":\"https:\\/\\/go.elementor.com\\/go-pro-notification-3.39-v4-blog\\/\",\"readMoreText\":\"Learn More\"},{\"id\":\"host-google-cloud\",\"title\":\"Deliver fast, secure websites at scale - free migration included!\",\"description\":\"Host your site on Elementor\\u2019s infrastructure - built for speed, security, and scale. Powered by Google Cloud, with free migration and 24\\/7 expert support.\",\"topic\":\"Host\",\"imageSrc\":\"https:\\/\\/assets.elementor.com\\/notifications\\/v1\\/images\\/host-google-cloud.png\",\"chipTags\":[\"Cloud Hosting\"],\"link\":\"https:\\/\\/go.elementor.com\\/elementor-host-google-cloud\",\"readMoreText\":\"Read More\"},{\"id\":\"cloud-templates-3.29\",\"title\":\"Your Templates, available everywhere\",\"description\":\"Store sections, containers, and full pages in the cloud\\u2014making them accessible across all your Pro-connected sites. Style once, reuse anywhere!\",\"topic\":\"Elementor Pro 3.29\",\"imageSrc\":\"https:\\/\\/assets.elementor.com\\/notifications\\/v1\\/images\\/cloud-templates.png\",\"chipPlan\":\"Pro\",\"chipTags\":[\"New Feature\"],\"link\":\"https:\\/\\/go.elementor.com\\/go-pro-notification-3.29-cloud-templates-blog\\/\",\"readMoreText\":\"Learn More\",\"conditions\":[[{\"type\":\"plugin\",\"plugin\":\"elementor-pro\\/elementor-pro.php\"}]]},{\"id\":\"cloud-templates-3.29\",\"title\":\"Your Templates, available everywhere\",\"description\":\"Store sections, containers, and full pages in the cloud\\u2014making them accessible across all your Pro-connected sites. Style once, reuse anywhere!\",\"topic\":\"Elementor Pro 3.29\",\"imageSrc\":\"https:\\/\\/assets.elementor.com\\/notifications\\/v1\\/images\\/cloud-templates.png\",\"chipTags\":[\"New Feature\"],\"cta\":\"Upgrade\",\"ctaLink\":\"https:\\/\\/go.elementor.com\\/go-pro-notification-3.29-cloud-templates\\/\"},{\"id\":\"migration-host\",\"title\":\"Move to Better Cloud Hosting, Painlessly\",\"description\":\"Migrate your Elementor website for free to a home that\\u2019s perfect for it, in minutes, with a combination of\\u2028advanced automation and free expert support\",\"topic\":\"Host\",\"imageSrc\":\"https:\\/\\/assets.elementor.com\\/notifications\\/v1\\/images\\/migration-host.png\",\"chipTags\":[\"Cloud Hosting\"],\"link\":\"https:\\/\\/go.elementor.com\\/hosting-free-migration\",\"readMoreText\":\"Learn More\",\"cta\":\"Migrate for free\",\"ctaLink\":\"https:\\/\\/go.elementor.com\\/hosting-free-migration\"},{\"id\":\"ai-isolate-object\",\"title\":\"Sharper product images, instantly\",\"description\":\"Remove distractions and reframe your shots with the new Isolate Object tool powered by Elementor AI \\u2014 perfect for a polished, uniform Woo storefront.\",\"topic\":\"Elementor AI\",\"imageSrc\":\"https:\\/\\/assets.elementor.com\\/notifications\\/v1\\/images\\/isolate-object-ai.png\",\"chipTags\":[\"New Feature\"],\"link\":\"https:\\/\\/go.elementor.com\\/Isolateobjectblog\",\"readMoreText\":\"Learn More\",\"conditions\":[[{\"type\":\"introduction_meta\",\"meta\":\"ai_get_started\"}]],\"cta\":\"Start Free Trial\",\"ctaLink\":\"https:\\/\\/go.elementor.com\\/Isolateobjectblog\"},{\"id\":\"ai-isolate-object\",\"title\":\"Sharper product images, instantly\",\"description\":\"Remove distractions and reframe your shots with the new Isolate Object tool powered by Elementor AI \\u2014 perfect for a polished, uniform Woo storefront.\",\"topic\":\"Elementor AI\",\"imageSrc\":\"https:\\/\\/assets.elementor.com\\/notifications\\/v1\\/images\\/isolate-object-ai.png\",\"chipTags\":[\"New Feature\"],\"cta\":\"Start Free Trial\",\"link\":\"https:\\/\\/go.elementor.com\\/Isolateobjectblog\",\"readMoreText\":\"Learn More\",\"ctaLink\":\"https:\\/\\/go.elementor.com\\/Isolateobjectblog\"},{\"id\":\"hello-biz-contact\",\"title\":\"New Contact Widget, Visual Layout Presets & more\",\"description\":\"Hello Biz just got an update! Explore the new Contact Widget, Visual Layout Presets, Form Submissions integration, and fresh new kits.\",\"topic\":\"Hello Biz\",\"imageSrc\":\"https:\\/\\/assets.elementor.com\\/notifications\\/v1\\/images\\/hello-biz-contact.png\",\"chipTags\":[\"New Features\"],\"link\":\"https:\\/\\/go.elementor.com\\/hello-biz-updates\",\"readMoreText\":\"Learn More\"},{\"id\":\"ai-site-planner-colors\",\"title\":\"Style Your Wireframe, Speed Up Your Store Build\",\"description\":\"Site Planner now lets you style your wireframe with fonts and colors - instantly visualizing your site\\u2019s look and feel. Plus, it predesigns pages for WooCommerce like Cart and Checkout, so you can dive straight into customizations\",\"topic\":\"Elementor AI\",\"imageSrc\":\"https:\\/\\/assets.elementor.com\\/notifications\\/v1\\/images\\/site-planner-colors.png\",\"chipTags\":[\"New Feature\"],\"link\":\"http:\\/\\/www.elementor.com\\/ai-site-planner\",\"readMoreText\":\"Learn More\"},{\"id\":\"ally-notification\",\"title\":\"Just released! Ally - a new plugin for web accessibility & usability\",\"description\":\"Ally simplifies the complexities of making your website more accessible. With new regulations here and coming, making your website more usable and inclusive is no longer just an option, but a must.\",\"topic\":\"Ally by Elementor\",\"imageSrc\":\"https:\\/\\/assets.elementor.com\\/notifications\\/v1\\/images\\/ally-notification.png\",\"chipTags\":[\"New plugin\"],\"cta\":\"Get it free\",\"ctaLink\":\"https:\\/\\/wordpress.org\\/plugins\\/pojo-accessibility\\/\",\"conditions\":[[{\"type\":\"plugin\",\"operator\":\"!=\",\"plugin\":\"pojo-accessibility\\/pojo-accessibility.php\"}]]},{\"id\":\"ai-site-planner\",\"title\":\"Instant Sitemaps & Wireframes\",\"description\":\"Get your website plan in minutes with AI Site Planner. Describe your desired site and AI will generate a sitemap, brief and wireframe populated with initial content, ready for you to customize.\",\"topic\":\"Elementor AI\",\"imageSrc\":\"https:\\/\\/assets.elementor.com\\/notifications\\/v1\\/images\\/aI-site-planner.png\",\"chipTags\":[\"New Feature\"],\"link\":\"https:\\/\\/go.elementor.com\\/ai-notification-site-planner\\/\",\"readMoreText\":\"Learn More\"},{\"id\":\"image-optimizer-3.19\",\"title\":\"Effortlessly optimize images for a stunning, high-speed website with the Image Optimizer plugin.\",\"description\":\"Image Optimizer perfectly balances between image quality and performance to boost your website.  Resize, compress, and convert images to WebP, for faster loading times and and better user experience.\",\"topic\":\"Image Optimizer Plugin by Elementor\",\"imageSrc\":\"https:\\/\\/assets.elementor.com\\/notifications\\/v1\\/images\\/image-optimizer-3.19.png\",\"chipTags\":[\"New plugin\"],\"cta\":\"Get the Image Optimizer\",\"ctaLink\":\"https:\\/\\/go.elementor.com\\/io-notification-wp-dash-learn-more\\/\",\"conditions\":[[{\"type\":\"plugin\",\"operator\":\"!=\",\"plugin\":\"image-optimization\\/image-optimization.php\"}]]},{\"id\":\"5-star-rating-prompt\",\"title\":\"Love the New Features? Let Us Know with 5 Stars!\",\"description\":\"Help spread the word by telling the world what you love about Elementor.\",\"imageSrc\":\"https:\\/\\/assets.elementor.com\\/notifications\\/v1\\/images\\/5-star-rating-prompt.png\",\"cta\":\"Leave a Review\",\"ctaLink\":\"https:\\/\\/go.elementor.com\\/wp-dash-notification-five-stars\\/\"},{\"id\":\"site-mailer-introducing\",\"title\":\"Introducing Site Mailer\",\"description\":\"Keep your WordPress emails out of the spam folder with improved deliverability and an easy setup\\u2014no need for an SMTP plugin or complicated configurations.\",\"topic\":\"Site Mailer Plugin by Elementor\",\"imageSrc\":\"https:\\/\\/assets.elementor.com\\/notifications\\/v1\\/images\\/Site-mailer.png\",\"chipTags\":[\"New plugin\"],\"cta\":\"Start Free Trial\",\"ctaLink\":\"https:\\/\\/go.elementor.com\\/sm-wp-dash-whatsnew\\/\",\"conditions\":[[{\"type\":\"plugin\",\"operator\":\"!=\",\"plugin\":\"site-mailer\\/site-mailer.php\"}]]}]\";}','off');
INSERT INTO `wp_79e54b1ec2_options` VALUES ('2150','_elementor_element_cache_unique_id','7b792198a757b7fda9181d90389748e0','auto');
INSERT INTO `wp_79e54b1ec2_options` VALUES ('2463','gd_system_first_page_on_front_update','1761606317','off');
INSERT INTO `wp_79e54b1ec2_options` VALUES ('2614','elementskit-lite__stories_last_check','1764163148','auto');
INSERT INTO `wp_79e54b1ec2_options` VALUES ('2617','elementskit-lite__stories_data','O:8:\"stdClass\":10:{s:8:\"10021822\";O:8:\"stdClass\":9:{s:2:\"id\";i:10021822;s:5:\"title\";s:18:\"BFCM GetGenie 2025\";s:11:\"description\";s:0:\"\";s:7:\"plugins\";a:2:{i:0;s:8:\"getgenie\";i:1;s:12:\"getgenie-pro\";}s:4:\"type\";s:6:\"banner\";s:8:\"priority\";s:4:\"high\";s:5:\"start\";i:1762819200;s:3:\"end\";i:1765324800;s:4:\"data\";O:8:\"stdClass\":6:{s:4:\"type\";s:6:\"banner\";s:10:\"story_link\";s:33:\"https://getgenie.ai/geniestoryh50\";s:11:\"story_image\";s:68:\"https://api.wpmet.com/auth/wp-content/uploads/2025/11/GetGenie-1.gif\";s:9:\"blacklist\";s:0:\"\";s:9:\"whitelist\";s:0:\"\";s:9:\"style_css\";s:0:\"\";}}s:8:\"10021818\";O:8:\"stdClass\":9:{s:2:\"id\";i:10021818;s:5:\"title\";s:15:\"Wpmet BFCM 2025\";s:11:\"description\";s:0:\"\";s:7:\"plugins\";a:7:{i:0;s:16:\"elementskit-lite\";i:1;s:8:\"emailkit\";i:2;s:21:\"gutenkit-blocks-addon\";i:3;s:7:\"metform\";i:4;s:10:\"shopengine\";i:5;s:9:\"wp-social\";i:6;s:18:\"wp-ultimate-review\";}s:4:\"type\";s:6:\"banner\";s:8:\"priority\";s:4:\"high\";s:5:\"start\";i:1762819200;s:3:\"end\";i:1765324800;s:4:\"data\";O:8:\"stdClass\":6:{s:4:\"type\";s:6:\"banner\";s:10:\"story_link\";s:28:\"https://wpmet.com/wpstoryh80\";s:11:\"story_image\";s:65:\"https://api.wpmet.com/auth/wp-content/uploads/2025/11/Wpmet-2.gif\";s:9:\"blacklist\";s:0:\"\";s:9:\"whitelist\";s:0:\"\";s:9:\"style_css\";s:0:\"\";}}s:8:\"10020924\";O:8:\"stdClass\":9:{s:2:\"id\";i:10020924;s:5:\"title\";s:23:\"Halloween GetGenie 2025\";s:11:\"description\";s:0:\"\";s:7:\"plugins\";a:2:{i:0;s:8:\"getgenie\";i:1;s:12:\"getgenie-pro\";}s:4:\"type\";s:6:\"banner\";s:8:\"priority\";s:4:\"high\";s:5:\"start\";i:1760486400;s:3:\"end\";i:1762128000;s:4:\"data\";O:8:\"stdClass\":6:{s:4:\"type\";s:6:\"banner\";s:10:\"story_link\";s:33:\"https://getgenie.ai/geniestoryh45\";s:11:\"story_image\";s:66:\"https://api.wpmet.com/auth/wp-content/uploads/2025/10/GetGenie.gif\";s:9:\"blacklist\";s:0:\"\";s:9:\"whitelist\";s:0:\"\";s:9:\"style_css\";s:0:\"\";}}s:8:\"10020922\";O:8:\"stdClass\":9:{s:2:\"id\";i:10020922;s:5:\"title\";s:20:\"Hallowwen Wpmet 2025\";s:11:\"description\";s:0:\"\";s:7:\"plugins\";a:7:{i:0;s:16:\"elementskit-lite\";i:1;s:8:\"emailkit\";i:2;s:21:\"gutenkit-blocks-addon\";i:3;s:7:\"metform\";i:4;s:10:\"shopengine\";i:5;s:9:\"wp-social\";i:6;s:18:\"wp-ultimate-review\";}s:4:\"type\";s:6:\"banner\";s:8:\"priority\";s:4:\"high\";s:5:\"start\";i:1760486400;s:3:\"end\";i:1762128000;s:4:\"data\";O:8:\"stdClass\":6:{s:4:\"type\";s:6:\"banner\";s:10:\"story_link\";s:28:\"https://wpmet.com/wpstoryh78\";s:11:\"story_image\";s:65:\"https://api.wpmet.com/auth/wp-content/uploads/2025/10/Wpmet-1.gif\";s:9:\"blacklist\";s:0:\"\";s:9:\"whitelist\";s:0:\"\";s:9:\"style_css\";s:0:\"\";}}s:8:\"10020276\";O:8:\"stdClass\":9:{s:2:\"id\";i:10020276;s:5:\"title\";s:17:\"GetGenie 30K Deal\";s:11:\"description\";s:0:\"\";s:7:\"plugins\";a:2:{i:0;s:8:\"getgenie\";i:1;s:12:\"getgenie-pro\";}s:4:\"type\";s:6:\"banner\";s:8:\"priority\";s:4:\"high\";s:5:\"start\";i:1757203200;s:3:\"end\";i:1758499200;s:4:\"data\";O:8:\"stdClass\":6:{s:4:\"type\";s:6:\"banner\";s:10:\"story_link\";s:28:\"https://getgenie.ai/30kstory\";s:11:\"story_image\";s:71:\"https://api.wpmet.com/auth/wp-content/uploads/2025/09/Genie-30K-GIF.gif\";s:9:\"blacklist\";s:0:\"\";s:9:\"whitelist\";s:0:\"\";s:9:\"style_css\";s:0:\"\";}}s:8:\"10019442\";O:8:\"stdClass\":9:{s:2:\"id\";i:10019442;s:5:\"title\";s:23:\"Wpmet Birthday 25 Genie\";s:11:\"description\";s:0:\"\";s:7:\"plugins\";a:1:{i:0;s:8:\"getgenie\";}s:4:\"type\";s:6:\"banner\";s:8:\"priority\";s:4:\"high\";s:5:\"start\";i:1753920000;s:3:\"end\";i:1755561600;s:4:\"data\";O:8:\"stdClass\":6:{s:4:\"type\";s:6:\"banner\";s:10:\"story_link\";s:32:\"https://wpmet.com/gbday-story-25\";s:11:\"story_image\";s:63:\"https://api.wpmet.com/auth/wp-content/uploads/2025/07/Genie.gif\";s:9:\"blacklist\";s:0:\"\";s:9:\"whitelist\";s:0:\"\";s:9:\"style_css\";s:0:\"\";}}s:8:\"10019440\";O:8:\"stdClass\":9:{s:2:\"id\";i:10019440;s:5:\"title\";s:19:\"Wpmet Birthday 2025\";s:11:\"description\";s:0:\"\";s:7:\"plugins\";a:6:{i:0;s:8:\"emailkit\";i:1;s:21:\"gutenkit-blocks-addon\";i:2;s:7:\"metform\";i:3;s:10:\"shopengine\";i:4;s:9:\"wp-social\";i:5;s:18:\"wp-ultimate-review\";}s:4:\"type\";s:6:\"banner\";s:8:\"priority\";s:4:\"high\";s:5:\"start\";i:1753920000;s:3:\"end\";i:1755561600;s:4:\"data\";O:8:\"stdClass\":6:{s:4:\"type\";s:6:\"banner\";s:10:\"story_link\";s:31:\"https://wpmet.com/bday-story-25\";s:11:\"story_image\";s:60:\"https://api.wpmet.com/auth/wp-content/uploads/2025/07/WP.gif\";s:9:\"blacklist\";s:0:\"\";s:9:\"whitelist\";s:0:\"\";s:9:\"style_css\";s:0:\"\";}}s:8:\"10018690\";O:8:\"stdClass\":9:{s:2:\"id\";i:10018690;s:5:\"title\";s:36:\"GetGenie 4th of July Flash Sale 2025\";s:11:\"description\";s:0:\"\";s:7:\"plugins\";a:2:{i:0;s:8:\"getgenie\";i:1;s:12:\"getgenie-pro\";}s:4:\"type\";s:6:\"banner\";s:8:\"priority\";s:4:\"high\";s:5:\"start\";i:1751328000;s:3:\"end\";i:1752019200;s:4:\"data\";O:8:\"stdClass\":6:{s:4:\"type\";s:6:\"banner\";s:10:\"story_link\";s:27:\"https://getgenie.ai/story45\";s:11:\"story_image\";s:71:\"https://api.wpmet.com/auth/wp-content/uploads/2025/07/GetGenie__Gif.gif\";s:9:\"blacklist\";s:0:\"\";s:9:\"whitelist\";s:0:\"\";s:9:\"style_css\";s:0:\"\";}}s:8:\"10018685\";O:8:\"stdClass\":9:{s:2:\"id\";i:10018685;s:5:\"title\";s:33:\"Wpmet 4th of July Flash Sale 2025\";s:11:\"description\";s:0:\"\";s:7:\"plugins\";a:7:{i:0;s:16:\"elementskit-lite\";i:1;s:8:\"emailkit\";i:2;s:21:\"gutenkit-blocks-addon\";i:3;s:7:\"metform\";i:4;s:10:\"shopengine\";i:5;s:9:\"wp-social\";i:6;s:18:\"wp-ultimate-review\";}s:4:\"type\";s:6:\"banner\";s:8:\"priority\";s:4:\"high\";s:5:\"start\";i:1751328000;s:3:\"end\";i:1752019200;s:4:\"data\";O:8:\"stdClass\":6:{s:4:\"type\";s:6:\"banner\";s:10:\"story_link\";s:25:\"https://wpmet.com/story35\";s:11:\"story_image\";s:63:\"https://api.wpmet.com/auth/wp-content/uploads/2025/07/WpMet.gif\";s:9:\"blacklist\";s:0:\"\";s:9:\"whitelist\";s:0:\"\";s:9:\"style_css\";s:0:\"\";}}s:8:\"10018273\";O:8:\"stdClass\":9:{s:2:\"id\";i:10018273;s:5:\"title\";s:24:\"WordPress Birthday Deals\";s:11:\"description\";s:0:\"\";s:7:\"plugins\";a:7:{i:0;s:16:\"elementskit-lite\";i:1;s:8:\"emailkit\";i:2;s:21:\"gutenkit-blocks-addon\";i:3;s:7:\"metform\";i:4;s:10:\"shopengine\";i:5;s:9:\"wp-social\";i:6;s:18:\"wp-ultimate-review\";}s:4:\"type\";s:6:\"banner\";s:8:\"priority\";s:4:\"high\";s:5:\"start\";i:1748304000;s:3:\"end\";i:1748649600;s:4:\"data\";O:8:\"stdClass\":6:{s:4:\"type\";s:6:\"banner\";s:10:\"story_link\";s:21:\"www.wpmet.com/wpbdays\";s:11:\"story_image\";s:63:\"https://api.wpmet.com/auth/wp-content/uploads/2025/05/story.gif\";s:9:\"blacklist\";s:0:\"\";s:9:\"whitelist\";s:0:\"\";s:9:\"style_css\";s:0:\"\";}}}','auto');
INSERT INTO `wp_79e54b1ec2_options` VALUES ('2622','elementskit-lite_install_date','2025-10-27 11:06:27','auto');
INSERT INTO `wp_79e54b1ec2_options` VALUES ('2623','metform_install_date','2025-10-27 11:06:27','auto');
INSERT INTO `wp_79e54b1ec2_options` VALUES ('2667','gdl_site_published_nux_reported','1761606397','auto');
INSERT INTO `wp_79e54b1ec2_options` VALUES ('2983','elementor_log','a:39:{s:32:\"8c714fac5f337ed34edbecea3ee69a2d\";O:30:\"Elementor\\Core\\Logger\\Items\\JS\":10:{s:7:\"\0*\0date\";s:19:\"2025-10-27 23:14:21\";s:7:\"\0*\0type\";s:5:\"error\";s:10:\"\0*\0message\";s:107:\"Failed to execute &#039;querySelector&#039; on &#039;Document&#039;: &#039;#&#039; is not a valid selector.\";s:7:\"\0*\0meta\";a:0:{}s:8:\"\0*\0times\";i:10;s:14:\"\0*\0times_dates\";a:10:{i:0;s:19:\"2025-10-27 23:14:21\";i:1;s:19:\"2025-10-27 23:14:21\";i:2;s:19:\"2025-10-27 23:15:34\";i:3;s:19:\"2025-10-27 23:15:34\";i:4;s:19:\"2025-10-27 23:15:59\";i:5;s:19:\"2025-10-27 23:15:59\";i:6;s:19:\"2025-10-28 19:20:14\";i:7;s:19:\"2025-10-28 19:20:14\";i:8;s:19:\"2025-10-29 18:16:47\";i:9;s:19:\"2025-10-29 18:16:47\";}s:7:\"\0*\0args\";a:6:{s:4:\"type\";s:5:\"error\";s:9:\"timestamp\";s:10:\"1761606861\";s:7:\"message\";s:77:\"Failed to execute \'querySelector\' on \'Document\': \'#\' is not a valid selector.\";s:3:\"url\";s:95:\"https://57r.860.myftpupload.com/wp-content/plugins/elementor/assets/js/editor.min.js?ver=3.32.5\";s:4:\"line\";s:1:\"3\";s:6:\"column\";s:6:\"915074\";}s:7:\"\0*\0file\";s:95:\"https://57r.860.myftpupload.com/wp-content/plugins/elementor/assets/js/editor.min.js?ver=3.32.5\";s:7:\"\0*\0line\";s:1:\"3\";s:9:\"\0*\0column\";s:6:\"915074\";}s:32:\"a34a8a450eae4661e9eeaf05eaac2929\";O:30:\"Elementor\\Core\\Logger\\Items\\JS\":10:{s:7:\"\0*\0date\";s:19:\"2025-10-27 23:46:25\";s:7:\"\0*\0type\";s:5:\"error\";s:10:\"\0*\0message\";s:28:\"Data commands: `` not found.\";s:7:\"\0*\0meta\";a:0:{}s:8:\"\0*\0times\";i:1;s:14:\"\0*\0times_dates\";a:1:{i:0;s:19:\"2025-10-27 23:46:25\";}s:7:\"\0*\0args\";a:6:{s:4:\"type\";s:5:\"error\";s:9:\"timestamp\";s:10:\"1761608785\";s:7:\"message\";s:28:\"Data commands: `` not found.\";s:3:\"url\";s:96:\"https://57r.860.myftpupload.com/wp-content/plugins/elementor/assets/js/web-cli.min.js?ver=3.32.5\";s:4:\"line\";s:1:\"3\";s:6:\"column\";s:6:\"145644\";}s:7:\"\0*\0file\";s:96:\"https://57r.860.myftpupload.com/wp-content/plugins/elementor/assets/js/web-cli.min.js?ver=3.32.5\";s:7:\"\0*\0line\";s:1:\"3\";s:9:\"\0*\0column\";s:6:\"145644\";}s:32:\"1350ecfef5ee3ace710e0ae0d5ce7be8\";O:31:\"Elementor\\Core\\Logger\\Items\\PHP\":9:{s:7:\"\0*\0date\";s:19:\"2025-10-28 16:03:19\";s:7:\"\0*\0type\";s:6:\"notice\";s:10:\"\0*\0message\";s:79:\"strpos(): Passing null to parameter #1 ($haystack) of type string is deprecated\";s:7:\"\0*\0meta\";a:1:{s:5:\"trace\";a:1:{i:0;a:3:{s:8:\"function\";s:8:\"shutdown\";s:5:\"class\";s:29:\"Elementor\\Core\\Logger\\Manager\";s:4:\"type\";s:2:\"->\";}}}s:8:\"\0*\0times\";i:18898;s:14:\"\0*\0times_dates\";a:42:{i:0;s:19:\"2025-11-24 23:12:22\";i:1;s:19:\"2025-11-24 23:12:23\";i:2;s:19:\"2025-11-24 23:12:24\";i:3;s:19:\"2025-11-24 23:12:26\";i:4;s:19:\"2025-11-24 23:12:28\";i:5;s:19:\"2025-11-24 23:12:32\";i:6;s:19:\"2025-11-24 23:12:34\";i:7;s:19:\"2025-11-25 06:40:25\";i:8;s:19:\"2025-11-25 06:40:27\";i:9;s:19:\"2025-11-25 06:40:27\";i:10;s:19:\"2025-11-25 06:40:35\";i:11;s:19:\"2025-11-25 08:30:36\";i:12;s:19:\"2025-11-25 09:39:22\";i:13;s:19:\"2025-11-25 10:39:59\";i:14;s:19:\"2025-11-25 10:40:01\";i:15;s:19:\"2025-11-25 10:40:01\";i:16;s:19:\"2025-11-25 10:40:09\";i:17;s:19:\"2025-11-25 19:31:08\";i:18;s:19:\"2025-11-25 19:31:11\";i:19;s:19:\"2025-11-25 19:31:13\";i:20;s:19:\"2025-11-25 19:31:13\";i:21;s:19:\"2025-11-25 19:31:22\";i:22;s:19:\"2025-11-25 21:40:48\";i:23;s:19:\"2025-11-26 07:15:36\";i:24;s:19:\"2025-11-26 09:39:20\";i:25;s:19:\"2025-11-26 10:02:43\";i:26;s:19:\"2025-11-26 13:18:51\";i:27;s:19:\"2025-11-26 13:19:02\";i:28;s:19:\"2025-11-26 13:19:05\";i:29;s:19:\"2025-11-26 13:19:10\";i:30;s:19:\"2025-11-26 13:19:14\";i:31;s:19:\"2025-11-26 13:19:20\";i:32;s:19:\"2025-11-26 14:51:29\";i:33;s:19:\"2025-11-26 15:49:39\";i:34;s:19:\"2025-11-26 15:49:40\";i:35;s:19:\"2025-11-26 15:49:40\";i:36;s:19:\"2025-11-26 15:49:49\";i:37;s:19:\"2025-11-26 20:39:33\";i:38;s:19:\"2025-11-26 20:39:33\";i:39;s:19:\"2025-11-26 20:39:33\";i:40;s:19:\"2025-11-26 20:39:33\";i:41;s:19:\"2025-11-26 21:39:40\";}s:7:\"\0*\0args\";a:5:{s:4:\"type\";s:6:\"notice\";s:7:\"message\";s:79:\"strpos(): Passing null to parameter #1 ($haystack) of type string is deprecated\";s:4:\"file\";s:75:\"/dom528478/wp-content/plugins/elementor-pro/modules/loop-builder/module.php\";s:4:\"line\";i:200;s:5:\"trace\";b:1;}s:7:\"\0*\0file\";s:75:\"/dom528478/wp-content/plugins/elementor-pro/modules/loop-builder/module.php\";s:7:\"\0*\0line\";i:200;}s:32:\"aff770fe403d47651bc3bdb35a6ff2dc\";O:31:\"Elementor\\Core\\Logger\\Items\\PHP\":9:{s:7:\"\0*\0date\";s:19:\"2025-10-28 16:04:54\";s:7:\"\0*\0type\";s:7:\"warning\";s:10:\"\0*\0message\";s:60:\"Undefined array key &quot;body_background_image_tablet&quot;\";s:7:\"\0*\0meta\";a:1:{s:5:\"trace\";a:1:{i:0;a:3:{s:8:\"function\";s:8:\"shutdown\";s:5:\"class\";s:29:\"Elementor\\Core\\Logger\\Manager\";s:4:\"type\";s:2:\"->\";}}}s:8:\"\0*\0times\";i:5;s:14:\"\0*\0times_dates\";a:5:{i:0;s:19:\"2025-10-28 16:04:54\";i:1;s:19:\"2025-10-28 16:39:36\";i:2;s:19:\"2025-10-28 16:46:25\";i:3;s:19:\"2025-10-28 16:53:18\";i:4;s:19:\"2025-10-28 17:04:13\";}s:7:\"\0*\0args\";a:5:{s:4:\"type\";s:7:\"warning\";s:7:\"message\";s:50:\"Undefined array key \"body_background_image_tablet\"\";s:4:\"file\";s:72:\"/dom528478/wp-content/plugins/elementor/includes/base/controls-stack.php\";s:4:\"line\";i:1492;s:5:\"trace\";b:1;}s:7:\"\0*\0file\";s:72:\"/dom528478/wp-content/plugins/elementor/includes/base/controls-stack.php\";s:7:\"\0*\0line\";i:1492;}s:32:\"6c8f3cd672ebb255f7d9a354d23891c5\";O:31:\"Elementor\\Core\\Logger\\Items\\PHP\":9:{s:7:\"\0*\0date\";s:19:\"2025-10-28 16:19:22\";s:7:\"\0*\0type\";s:6:\"notice\";s:10:\"\0*\0message\";s:88:\"version_compare(): Passing null to parameter #2 ($version2) of type string is deprecated\";s:7:\"\0*\0meta\";a:1:{s:5:\"trace\";a:1:{i:0;a:3:{s:8:\"function\";s:8:\"shutdown\";s:5:\"class\";s:29:\"Elementor\\Core\\Logger\\Manager\";s:4:\"type\";s:2:\"->\";}}}s:8:\"\0*\0times\";i:2;s:14:\"\0*\0times_dates\";a:2:{i:0;s:19:\"2025-10-28 16:19:22\";i:1;s:19:\"2025-10-28 16:19:29\";}s:7:\"\0*\0args\";a:5:{s:4:\"type\";s:6:\"notice\";s:7:\"message\";s:88:\"version_compare(): Passing null to parameter #2 ($version2) of type string is deprecated\";s:4:\"file\";s:68:\"/dom528478/wp-content/plugins/elementor/core/experiments/manager.php\";s:4:\"line\";i:129;s:5:\"trace\";b:1;}s:7:\"\0*\0file\";s:68:\"/dom528478/wp-content/plugins/elementor/core/experiments/manager.php\";s:7:\"\0*\0line\";i:129;}s:32:\"1f3f7f521382974dd61eff7a8148ee9e\";O:30:\"Elementor\\Core\\Logger\\Items\\JS\":10:{s:7:\"\0*\0date\";s:19:\"2025-10-28 16:19:22\";s:7:\"\0*\0type\";s:5:\"error\";s:10:\"\0*\0message\";s:38:\"elementorFrontendConfig is not defined\";s:7:\"\0*\0meta\";a:0:{}s:8:\"\0*\0times\";i:2;s:14:\"\0*\0times_dates\";a:2:{i:0;s:19:\"2025-10-28 16:19:22\";i:1;s:19:\"2025-10-28 16:19:29\";}s:7:\"\0*\0args\";a:6:{s:4:\"type\";s:5:\"error\";s:9:\"timestamp\";s:10:\"1761668362\";s:7:\"message\";s:38:\"elementorFrontendConfig is not defined\";s:3:\"url\";s:97:\"https://57r.860.myftpupload.com/wp-content/plugins/elementor/assets/js/frontend.min.js?ver=3.32.5\";s:4:\"line\";s:1:\"2\";s:6:\"column\";s:5:\"26285\";}s:7:\"\0*\0file\";s:97:\"https://57r.860.myftpupload.com/wp-content/plugins/elementor/assets/js/frontend.min.js?ver=3.32.5\";s:7:\"\0*\0line\";s:1:\"2\";s:9:\"\0*\0column\";s:5:\"26285\";}s:32:\"02e08dcc4b7d7756d623c31e522e77b9\";O:31:\"Elementor\\Core\\Logger\\Items\\PHP\":9:{s:7:\"\0*\0date\";s:19:\"2025-10-28 16:28:48\";s:7:\"\0*\0type\";s:6:\"notice\";s:10:\"\0*\0message\";s:75:\"trim(): Passing null to parameter #1 ($string) of type string is deprecated\";s:7:\"\0*\0meta\";a:1:{s:5:\"trace\";a:1:{i:0;a:3:{s:8:\"function\";s:8:\"shutdown\";s:5:\"class\";s:29:\"Elementor\\Core\\Logger\\Manager\";s:4:\"type\";s:2:\"->\";}}}s:8:\"\0*\0times\";i:27;s:14:\"\0*\0times_dates\";a:27:{i:0;s:19:\"2025-10-28 16:28:48\";i:1;s:19:\"2025-10-28 16:28:53\";i:2;s:19:\"2025-10-28 16:38:46\";i:3;s:19:\"2025-10-28 16:41:25\";i:4;s:19:\"2025-10-28 16:42:19\";i:5;s:19:\"2025-10-28 16:43:51\";i:6;s:19:\"2025-10-28 16:50:51\";i:7;s:19:\"2025-10-28 17:05:54\";i:8;s:19:\"2025-10-28 17:06:00\";i:9;s:19:\"2025-10-28 21:37:22\";i:10;s:19:\"2025-10-29 15:52:12\";i:11;s:19:\"2025-10-29 19:34:36\";i:12;s:19:\"2025-10-29 21:37:08\";i:13;s:19:\"2025-10-30 14:29:10\";i:14;s:19:\"2025-10-30 14:29:30\";i:15;s:19:\"2025-11-10 21:41:21\";i:16;s:19:\"2025-11-11 04:42:22\";i:17;s:19:\"2025-11-11 21:37:47\";i:18;s:19:\"2025-11-12 21:39:46\";i:19;s:19:\"2025-11-17 21:38:23\";i:20;s:19:\"2025-11-18 03:58:45\";i:21;s:19:\"2025-11-19 21:41:06\";i:22;s:19:\"2025-11-20 09:37:54\";i:23;s:19:\"2025-11-23 14:57:35\";i:24;s:19:\"2025-11-23 21:42:59\";i:25;s:19:\"2025-11-23 23:32:34\";i:26;s:19:\"2025-11-24 03:14:04\";}s:7:\"\0*\0args\";a:5:{s:4:\"type\";s:6:\"notice\";s:7:\"message\";s:75:\"trim(): Passing null to parameter #1 ($string) of type string is deprecated\";s:4:\"file\";s:73:\"/dom528478/wp-content/plugins/elementor-pro/modules/custom-css/module.php\";s:4:\"line\";i:76;s:5:\"trace\";b:1;}s:7:\"\0*\0file\";s:73:\"/dom528478/wp-content/plugins/elementor-pro/modules/custom-css/module.php\";s:7:\"\0*\0line\";i:76;}s:32:\"8c15c28edff7ca03072a7739cd6cf299\";O:32:\"Elementor\\Core\\Logger\\Items\\Base\":7:{s:7:\"\0*\0date\";s:19:\"2025-10-28 16:35:53\";s:7:\"\0*\0type\";s:4:\"info\";s:10:\"\0*\0message\";s:28:\"Uploading Kit via REST API: \";s:7:\"\0*\0meta\";a:2:{s:6:\"kit_id\";N;s:8:\"referrer\";s:5:\"local\";}s:8:\"\0*\0times\";i:1;s:14:\"\0*\0times_dates\";a:1:{i:0;s:19:\"2025-10-28 16:35:53\";}s:7:\"\0*\0args\";a:3:{s:4:\"meta\";a:2:{s:6:\"kit_id\";N;s:8:\"referrer\";s:5:\"local\";}s:7:\"message\";s:28:\"Uploading Kit via REST API: \";s:4:\"type\";s:4:\"info\";}}s:32:\"d7f32558075242f9f8743be873997d0a\";O:32:\"Elementor\\Core\\Logger\\Items\\Base\":7:{s:7:\"\0*\0date\";s:19:\"2025-10-28 16:36:29\";s:7:\"\0*\0type\";s:4:\"info\";s:10:\"\0*\0message\";s:114:\"Selected import runners via REST API: site-settings, plugins, templates, taxonomies, elementor-content, wp-content\";s:7:\"\0*\0meta\";a:0:{}s:8:\"\0*\0times\";i:1;s:14:\"\0*\0times_dates\";a:1:{i:0;s:19:\"2025-10-28 16:36:29\";}s:7:\"\0*\0args\";a:2:{s:7:\"message\";s:114:\"Selected import runners via REST API: site-settings, plugins, templates, taxonomies, elementor-content, wp-content\";s:4:\"type\";s:4:\"info\";}}s:32:\"9e5f9c8835ab253abb9c4d4a0514ced4\";O:32:\"Elementor\\Core\\Logger\\Items\\Base\":7:{s:7:\"\0*\0date\";s:19:\"2025-10-28 16:36:30\";s:7:\"\0*\0type\";s:4:\"info\";s:10:\"\0*\0message\";s:55:\"Import runner completed via REST API: site-settings ✓\";s:7:\"\0*\0meta\";a:0:{}s:8:\"\0*\0times\";i:1;s:14:\"\0*\0times_dates\";a:1:{i:0;s:19:\"2025-10-28 16:36:30\";}s:7:\"\0*\0args\";a:2:{s:7:\"message\";s:55:\"Import runner completed via REST API: site-settings ✓\";s:4:\"type\";s:4:\"info\";}}s:32:\"f797feb602dfcb1ef2e9b438f9fc3d2c\";O:32:\"Elementor\\Core\\Logger\\Items\\Base\":7:{s:7:\"\0*\0date\";s:19:\"2025-10-28 16:36:32\";s:7:\"\0*\0type\";s:4:\"info\";s:10:\"\0*\0message\";s:49:\"Import runner completed via REST API: plugins ✓\";s:7:\"\0*\0meta\";a:0:{}s:8:\"\0*\0times\";i:1;s:14:\"\0*\0times_dates\";a:1:{i:0;s:19:\"2025-10-28 16:36:32\";}s:7:\"\0*\0args\";a:2:{s:7:\"message\";s:49:\"Import runner completed via REST API: plugins ✓\";s:4:\"type\";s:4:\"info\";}}s:32:\"c8081220400a9106a87756745cf4ce96\";O:31:\"Elementor\\Core\\Logger\\Items\\PHP\":9:{s:7:\"\0*\0date\";s:19:\"2025-10-28 16:36:33\";s:7:\"\0*\0type\";s:7:\"warning\";s:10:\"\0*\0message\";s:40:\"Undefined array key &quot;settings&quot;\";s:7:\"\0*\0meta\";a:1:{s:5:\"trace\";a:5:{i:0;a:5:{s:4:\"file\";s:62:\"/dom528478/wp-content/plugins/elementor/core/base/document.php\";s:4:\"line\";i:1702;s:8:\"function\";s:18:\"rest_error_handler\";s:5:\"class\";s:29:\"Elementor\\Core\\Logger\\Manager\";s:4:\"type\";s:2:\"->\";}i:1;a:5:{s:4:\"file\";s:108:\"/dom528478/wp-content/plugins/elementor/app/modules/import-export-customization/runners/import/templates.php\";s:4:\"line\";i:127;s:8:\"function\";s:6:\"import\";s:5:\"class\";s:28:\"Elementor\\Core\\Base\\Document\";s:4:\"type\";s:2:\"->\";}i:2;a:5:{s:4:\"file\";s:108:\"/dom528478/wp-content/plugins/elementor/app/modules/import-export-customization/runners/import/templates.php\";s:4:\"line\";i:90;s:8:\"function\";s:15:\"import_template\";s:5:\"class\";s:72:\"Elementor\\App\\Modules\\ImportExportCustomization\\Runners\\Import\\Templates\";s:4:\"type\";s:2:\"->\";}i:3;a:5:{s:4:\"file\";s:108:\"/dom528478/wp-content/plugins/elementor/app/modules/import-export-customization/runners/import/templates.php\";s:4:\"line\";i:55;s:8:\"function\";s:24:\"process_templates_import\";s:5:\"class\";s:72:\"Elementor\\App\\Modules\\ImportExportCustomization\\Runners\\Import\\Templates\";s:4:\"type\";s:2:\"->\";}i:4;a:5:{s:4:\"file\";s:108:\"/dom528478/wp-content/plugins/elementor/app/modules/import-export-customization/runners/import/templates.php\";s:4:\"line\";i:35;s:8:\"function\";s:10:\"import_all\";s:5:\"class\";s:72:\"Elementor\\App\\Modules\\ImportExportCustomization\\Runners\\Import\\Templates\";s:4:\"type\";s:2:\"->\";}}}s:8:\"\0*\0times\";i:9;s:14:\"\0*\0times_dates\";a:9:{i:0;s:19:\"2025-10-28 16:36:33\";i:1;s:19:\"2025-10-28 16:36:34\";i:2;s:19:\"2025-10-28 16:36:34\";i:3;s:19:\"2025-10-28 16:36:43\";i:4;s:19:\"2025-10-28 16:36:44\";i:5;s:19:\"2025-10-28 16:36:47\";i:6;s:19:\"2025-10-28 16:36:50\";i:7;s:19:\"2025-10-28 16:36:51\";i:8;s:19:\"2025-10-28 16:36:54\";}s:7:\"\0*\0args\";a:5:{s:4:\"type\";s:7:\"warning\";s:7:\"message\";s:30:\"Undefined array key \"settings\"\";s:4:\"file\";s:62:\"/dom528478/wp-content/plugins/elementor/core/base/document.php\";s:4:\"line\";i:1702;s:5:\"trace\";b:1;}s:7:\"\0*\0file\";s:62:\"/dom528478/wp-content/plugins/elementor/core/base/document.php\";s:7:\"\0*\0line\";i:1702;}s:32:\"8eec5b69d5b84e99328916c32866edd9\";O:31:\"Elementor\\Core\\Logger\\Items\\PHP\":9:{s:7:\"\0*\0date\";s:19:\"2025-10-28 16:36:33\";s:7:\"\0*\0type\";s:7:\"warning\";s:10:\"\0*\0message\";s:41:\"Undefined array key &quot;thumbnail&quot;\";s:7:\"\0*\0meta\";a:1:{s:5:\"trace\";a:5:{i:0;a:5:{s:4:\"file\";s:62:\"/dom528478/wp-content/plugins/elementor/core/base/document.php\";s:4:\"line\";i:1705;s:8:\"function\";s:18:\"rest_error_handler\";s:5:\"class\";s:29:\"Elementor\\Core\\Logger\\Manager\";s:4:\"type\";s:2:\"->\";}i:1;a:5:{s:4:\"file\";s:108:\"/dom528478/wp-content/plugins/elementor/app/modules/import-export-customization/runners/import/templates.php\";s:4:\"line\";i:127;s:8:\"function\";s:6:\"import\";s:5:\"class\";s:28:\"Elementor\\Core\\Base\\Document\";s:4:\"type\";s:2:\"->\";}i:2;a:5:{s:4:\"file\";s:108:\"/dom528478/wp-content/plugins/elementor/app/modules/import-export-customization/runners/import/templates.php\";s:4:\"line\";i:90;s:8:\"function\";s:15:\"import_template\";s:5:\"class\";s:72:\"Elementor\\App\\Modules\\ImportExportCustomization\\Runners\\Import\\Templates\";s:4:\"type\";s:2:\"->\";}i:3;a:5:{s:4:\"file\";s:108:\"/dom528478/wp-content/plugins/elementor/app/modules/import-export-customization/runners/import/templates.php\";s:4:\"line\";i:55;s:8:\"function\";s:24:\"process_templates_import\";s:5:\"class\";s:72:\"Elementor\\App\\Modules\\ImportExportCustomization\\Runners\\Import\\Templates\";s:4:\"type\";s:2:\"->\";}i:4;a:5:{s:4:\"file\";s:108:\"/dom528478/wp-content/plugins/elementor/app/modules/import-export-customization/runners/import/templates.php\";s:4:\"line\";i:35;s:8:\"function\";s:10:\"import_all\";s:5:\"class\";s:72:\"Elementor\\App\\Modules\\ImportExportCustomization\\Runners\\Import\\Templates\";s:4:\"type\";s:2:\"->\";}}}s:8:\"\0*\0times\";i:9;s:14:\"\0*\0times_dates\";a:9:{i:0;s:19:\"2025-10-28 16:36:33\";i:1;s:19:\"2025-10-28 16:36:34\";i:2;s:19:\"2025-10-28 16:36:34\";i:3;s:19:\"2025-10-28 16:36:43\";i:4;s:19:\"2025-10-28 16:36:44\";i:5;s:19:\"2025-10-28 16:36:47\";i:6;s:19:\"2025-10-28 16:36:50\";i:7;s:19:\"2025-10-28 16:36:51\";i:8;s:19:\"2025-10-28 16:36:54\";}s:7:\"\0*\0args\";a:5:{s:4:\"type\";s:7:\"warning\";s:7:\"message\";s:31:\"Undefined array key \"thumbnail\"\";s:4:\"file\";s:62:\"/dom528478/wp-content/plugins/elementor/core/base/document.php\";s:4:\"line\";i:1705;s:5:\"trace\";b:1;}s:7:\"\0*\0file\";s:62:\"/dom528478/wp-content/plugins/elementor/core/base/document.php\";s:7:\"\0*\0line\";i:1705;}s:32:\"61a1c6d353ccfd2ef828867e334b489d\";O:31:\"Elementor\\Core\\Logger\\Items\\PHP\":9:{s:7:\"\0*\0date\";s:19:\"2025-10-28 16:36:47\";s:7:\"\0*\0type\";s:7:\"warning\";s:10:\"\0*\0message\";s:51:\"Trying to access array offset on value of type bool\";s:7:\"\0*\0meta\";a:1:{s:5:\"trace\";a:5:{i:0;a:5:{s:4:\"file\";s:69:\"/dom528478/wp-content/plugins/elementor/includes/base/widget-base.php\";s:4:\"line\";i:224;s:8:\"function\";s:18:\"rest_error_handler\";s:5:\"class\";s:29:\"Elementor\\Core\\Logger\\Manager\";s:4:\"type\";s:2:\"->\";}i:1;a:5:{s:4:\"file\";s:72:\"/dom528478/wp-content/plugins/elementor/includes/base/controls-stack.php\";s:4:\"line\";i:1877;s:8:\"function\";s:17:\"get_pointer_index\";s:5:\"class\";s:21:\"Elementor\\Widget_Base\";s:4:\"type\";s:2:\"->\";}i:2;a:5:{s:4:\"file\";s:73:\"/dom528478/wp-content/plugins/elementor/includes/controls/groups/base.php\";s:4:\"line\";i:130;s:8:\"function\";s:11:\"end_popover\";s:5:\"class\";s:24:\"Elementor\\Controls_Stack\";s:4:\"type\";s:2:\"->\";}i:3;a:5:{s:4:\"file\";s:72:\"/dom528478/wp-content/plugins/elementor/includes/base/controls-stack.php\";s:4:\"line\";i:781;s:8:\"function\";s:12:\"add_controls\";s:5:\"class\";s:28:\"Elementor\\Group_Control_Base\";s:4:\"type\";s:2:\"->\";}i:4;a:5:{s:4:\"file\";s:87:\"/dom528478/wp-content/plugins/elementor-pro/modules/carousel/widgets/media-carousel.php\";s:4:\"line\";i:456;s:8:\"function\";s:17:\"add_group_control\";s:5:\"class\";s:24:\"Elementor\\Controls_Stack\";s:4:\"type\";s:2:\"->\";}}}s:8:\"\0*\0times\";i:3;s:14:\"\0*\0times_dates\";a:3:{i:0;s:19:\"2025-10-28 16:36:47\";i:1;s:19:\"2025-10-28 16:37:02\";i:2;s:19:\"2025-10-28 17:03:32\";}s:7:\"\0*\0args\";a:5:{s:4:\"type\";s:7:\"warning\";s:7:\"message\";s:51:\"Trying to access array offset on value of type bool\";s:4:\"file\";s:69:\"/dom528478/wp-content/plugins/elementor/includes/base/widget-base.php\";s:4:\"line\";i:224;s:5:\"trace\";b:1;}s:7:\"\0*\0file\";s:69:\"/dom528478/wp-content/plugins/elementor/includes/base/widget-base.php\";s:7:\"\0*\0line\";i:224;}s:32:\"550946547ec66e5e906bdcaab302c7a1\";O:31:\"Elementor\\Core\\Logger\\Items\\PHP\":9:{s:7:\"\0*\0date\";s:19:\"2025-10-28 16:36:47\";s:7:\"\0*\0type\";s:7:\"warning\";s:10:\"\0*\0message\";s:22:\"Undefined array key -1\";s:7:\"\0*\0meta\";a:1:{s:5:\"trace\";a:5:{i:0;a:5:{s:4:\"file\";s:72:\"/dom528478/wp-content/plugins/elementor/includes/base/controls-stack.php\";s:4:\"line\";i:696;s:8:\"function\";s:18:\"rest_error_handler\";s:5:\"class\";s:29:\"Elementor\\Core\\Logger\\Manager\";s:4:\"type\";s:2:\"->\";}i:1;a:5:{s:4:\"file\";s:72:\"/dom528478/wp-content/plugins/elementor/includes/base/controls-stack.php\";s:4:\"line\";i:1877;s:8:\"function\";s:15:\"get_control_key\";s:5:\"class\";s:24:\"Elementor\\Controls_Stack\";s:4:\"type\";s:2:\"->\";}i:2;a:5:{s:4:\"file\";s:73:\"/dom528478/wp-content/plugins/elementor/includes/controls/groups/base.php\";s:4:\"line\";i:130;s:8:\"function\";s:11:\"end_popover\";s:5:\"class\";s:24:\"Elementor\\Controls_Stack\";s:4:\"type\";s:2:\"->\";}i:3;a:5:{s:4:\"file\";s:72:\"/dom528478/wp-content/plugins/elementor/includes/base/controls-stack.php\";s:4:\"line\";i:781;s:8:\"function\";s:12:\"add_controls\";s:5:\"class\";s:28:\"Elementor\\Group_Control_Base\";s:4:\"type\";s:2:\"->\";}i:4;a:5:{s:4:\"file\";s:87:\"/dom528478/wp-content/plugins/elementor-pro/modules/carousel/widgets/media-carousel.php\";s:4:\"line\";i:456;s:8:\"function\";s:17:\"add_group_control\";s:5:\"class\";s:24:\"Elementor\\Controls_Stack\";s:4:\"type\";s:2:\"->\";}}}s:8:\"\0*\0times\";i:3;s:14:\"\0*\0times_dates\";a:3:{i:0;s:19:\"2025-10-28 16:36:47\";i:1;s:19:\"2025-10-28 16:37:02\";i:2;s:19:\"2025-10-28 17:03:32\";}s:7:\"\0*\0args\";a:5:{s:4:\"type\";s:7:\"warning\";s:7:\"message\";s:22:\"Undefined array key -1\";s:4:\"file\";s:72:\"/dom528478/wp-content/plugins/elementor/includes/base/controls-stack.php\";s:4:\"line\";i:696;s:5:\"trace\";b:1;}s:7:\"\0*\0file\";s:72:\"/dom528478/wp-content/plugins/elementor/includes/base/controls-stack.php\";s:7:\"\0*\0line\";i:696;}s:32:\"c343181afecad816cab0b6788bde975b\";O:31:\"Elementor\\Core\\Logger\\Items\\PHP\":9:{s:7:\"\0*\0date\";s:19:\"2025-10-28 16:36:54\";s:7:\"\0*\0type\";s:7:\"warning\";s:10:\"\0*\0message\";s:40:\"Undefined array key &quot;settings&quot;\";s:7:\"\0*\0meta\";a:1:{s:5:\"trace\";a:5:{i:0;a:5:{s:4:\"file\";s:62:\"/dom528478/wp-content/plugins/elementor/core/base/document.php\";s:4:\"line\";i:1702;s:8:\"function\";s:18:\"rest_error_handler\";s:5:\"class\";s:29:\"Elementor\\Core\\Logger\\Manager\";s:4:\"type\";s:2:\"->\";}i:1;a:5:{s:4:\"file\";s:94:\"/dom528478/wp-content/plugins/elementor-pro/modules/theme-builder/documents/theme-document.php\";s:4:\"line\";i:236;s:8:\"function\";s:6:\"import\";s:5:\"class\";s:28:\"Elementor\\Core\\Base\\Document\";s:4:\"type\";s:2:\"->\";}i:2;a:5:{s:4:\"file\";s:108:\"/dom528478/wp-content/plugins/elementor/app/modules/import-export-customization/runners/import/templates.php\";s:4:\"line\";i:127;s:8:\"function\";s:6:\"import\";s:5:\"class\";s:58:\"ElementorPro\\Modules\\ThemeBuilder\\Documents\\Theme_Document\";s:4:\"type\";s:2:\"->\";}i:3;a:5:{s:4:\"file\";s:108:\"/dom528478/wp-content/plugins/elementor/app/modules/import-export-customization/runners/import/templates.php\";s:4:\"line\";i:90;s:8:\"function\";s:15:\"import_template\";s:5:\"class\";s:72:\"Elementor\\App\\Modules\\ImportExportCustomization\\Runners\\Import\\Templates\";s:4:\"type\";s:2:\"->\";}i:4;a:5:{s:4:\"file\";s:108:\"/dom528478/wp-content/plugins/elementor/app/modules/import-export-customization/runners/import/templates.php\";s:4:\"line\";i:55;s:8:\"function\";s:24:\"process_templates_import\";s:5:\"class\";s:72:\"Elementor\\App\\Modules\\ImportExportCustomization\\Runners\\Import\\Templates\";s:4:\"type\";s:2:\"->\";}}}s:8:\"\0*\0times\";i:5;s:14:\"\0*\0times_dates\";a:5:{i:0;s:19:\"2025-10-28 16:36:54\";i:1;s:19:\"2025-10-28 16:36:54\";i:2;s:19:\"2025-10-28 16:36:55\";i:3;s:19:\"2025-10-28 16:36:56\";i:4;s:19:\"2025-10-28 16:36:57\";}s:7:\"\0*\0args\";a:5:{s:4:\"type\";s:7:\"warning\";s:7:\"message\";s:30:\"Undefined array key \"settings\"\";s:4:\"file\";s:62:\"/dom528478/wp-content/plugins/elementor/core/base/document.php\";s:4:\"line\";i:1702;s:5:\"trace\";b:1;}s:7:\"\0*\0file\";s:62:\"/dom528478/wp-content/plugins/elementor/core/base/document.php\";s:7:\"\0*\0line\";i:1702;}s:32:\"8649e98242eb28be483153c9e0d4c543\";O:31:\"Elementor\\Core\\Logger\\Items\\PHP\":9:{s:7:\"\0*\0date\";s:19:\"2025-10-28 16:36:54\";s:7:\"\0*\0type\";s:7:\"warning\";s:10:\"\0*\0message\";s:41:\"Undefined array key &quot;thumbnail&quot;\";s:7:\"\0*\0meta\";a:1:{s:5:\"trace\";a:5:{i:0;a:5:{s:4:\"file\";s:62:\"/dom528478/wp-content/plugins/elementor/core/base/document.php\";s:4:\"line\";i:1705;s:8:\"function\";s:18:\"rest_error_handler\";s:5:\"class\";s:29:\"Elementor\\Core\\Logger\\Manager\";s:4:\"type\";s:2:\"->\";}i:1;a:5:{s:4:\"file\";s:94:\"/dom528478/wp-content/plugins/elementor-pro/modules/theme-builder/documents/theme-document.php\";s:4:\"line\";i:236;s:8:\"function\";s:6:\"import\";s:5:\"class\";s:28:\"Elementor\\Core\\Base\\Document\";s:4:\"type\";s:2:\"->\";}i:2;a:5:{s:4:\"file\";s:108:\"/dom528478/wp-content/plugins/elementor/app/modules/import-export-customization/runners/import/templates.php\";s:4:\"line\";i:127;s:8:\"function\";s:6:\"import\";s:5:\"class\";s:58:\"ElementorPro\\Modules\\ThemeBuilder\\Documents\\Theme_Document\";s:4:\"type\";s:2:\"->\";}i:3;a:5:{s:4:\"file\";s:108:\"/dom528478/wp-content/plugins/elementor/app/modules/import-export-customization/runners/import/templates.php\";s:4:\"line\";i:90;s:8:\"function\";s:15:\"import_template\";s:5:\"class\";s:72:\"Elementor\\App\\Modules\\ImportExportCustomization\\Runners\\Import\\Templates\";s:4:\"type\";s:2:\"->\";}i:4;a:5:{s:4:\"file\";s:108:\"/dom528478/wp-content/plugins/elementor/app/modules/import-export-customization/runners/import/templates.php\";s:4:\"line\";i:55;s:8:\"function\";s:24:\"process_templates_import\";s:5:\"class\";s:72:\"Elementor\\App\\Modules\\ImportExportCustomization\\Runners\\Import\\Templates\";s:4:\"type\";s:2:\"->\";}}}s:8:\"\0*\0times\";i:5;s:14:\"\0*\0times_dates\";a:5:{i:0;s:19:\"2025-10-28 16:36:54\";i:1;s:19:\"2025-10-28 16:36:55\";i:2;s:19:\"2025-10-28 16:36:55\";i:3;s:19:\"2025-10-28 16:36:56\";i:4;s:19:\"2025-10-28 16:36:57\";}s:7:\"\0*\0args\";a:5:{s:4:\"type\";s:7:\"warning\";s:7:\"message\";s:31:\"Undefined array key \"thumbnail\"\";s:4:\"file\";s:62:\"/dom528478/wp-content/plugins/elementor/core/base/document.php\";s:4:\"line\";i:1705;s:5:\"trace\";b:1;}s:7:\"\0*\0file\";s:62:\"/dom528478/wp-content/plugins/elementor/core/base/document.php\";s:7:\"\0*\0line\";i:1705;}s:32:\"c5c1836369654e5cfc85b1a7f2dd7383\";O:32:\"Elementor\\Core\\Logger\\Items\\Base\":7:{s:7:\"\0*\0date\";s:19:\"2025-10-28 16:36:57\";s:7:\"\0*\0type\";s:4:\"info\";s:10:\"\0*\0message\";s:51:\"Import runner completed via REST API: templates ✓\";s:7:\"\0*\0meta\";a:0:{}s:8:\"\0*\0times\";i:1;s:14:\"\0*\0times_dates\";a:1:{i:0;s:19:\"2025-10-28 16:36:57\";}s:7:\"\0*\0args\";a:2:{s:7:\"message\";s:51:\"Import runner completed via REST API: templates ✓\";s:4:\"type\";s:4:\"info\";}}s:32:\"1ebc224b3429df8bc51c5b036026ec5e\";O:32:\"Elementor\\Core\\Logger\\Items\\Base\":7:{s:7:\"\0*\0date\";s:19:\"2025-10-28 16:36:59\";s:7:\"\0*\0type\";s:4:\"info\";s:10:\"\0*\0message\";s:52:\"Import runner completed via REST API: taxonomies ✓\";s:7:\"\0*\0meta\";a:0:{}s:8:\"\0*\0times\";i:1;s:14:\"\0*\0times_dates\";a:1:{i:0;s:19:\"2025-10-28 16:36:59\";}s:7:\"\0*\0args\";a:2:{s:7:\"message\";s:52:\"Import runner completed via REST API: taxonomies ✓\";s:4:\"type\";s:4:\"info\";}}s:32:\"45acc44313aab931eed93ad63b342daa\";O:32:\"Elementor\\Core\\Logger\\Items\\Base\":7:{s:7:\"\0*\0date\";s:19:\"2025-10-28 16:36:59\";s:7:\"\0*\0type\";s:4:\"info\";s:10:\"\0*\0message\";s:59:\"Import runner completed via REST API: elementor-content ✓\";s:7:\"\0*\0meta\";a:0:{}s:8:\"\0*\0times\";i:1;s:14:\"\0*\0times_dates\";a:1:{i:0;s:19:\"2025-10-28 16:36:59\";}s:7:\"\0*\0args\";a:2:{s:7:\"message\";s:59:\"Import runner completed via REST API: elementor-content ✓\";s:4:\"type\";s:4:\"info\";}}s:32:\"08eb33142220e1302c568e9676d5f998\";O:31:\"Elementor\\Core\\Logger\\Items\\PHP\":9:{s:7:\"\0*\0date\";s:19:\"2025-10-28 16:40:30\";s:7:\"\0*\0type\";s:7:\"warning\";s:10:\"\0*\0message\";s:56:\"Attempt to read property &quot;post_status&quot; on null\";s:7:\"\0*\0meta\";a:1:{s:5:\"trace\";a:5:{i:0;a:5:{s:4:\"file\";s:62:\"/dom528478/wp-content/plugins/elementor/core/base/document.php\";s:4:\"line\";i:1986;s:8:\"function\";s:18:\"rest_error_handler\";s:5:\"class\";s:29:\"Elementor\\Core\\Logger\\Manager\";s:4:\"type\";s:2:\"->\";}i:1;a:5:{s:4:\"file\";s:67:\"/dom528478/wp-content/plugins/elementor/core/kits/documents/kit.php\";s:4:\"line\";i:145;s:8:\"function\";s:26:\"register_document_controls\";s:5:\"class\";s:28:\"Elementor\\Core\\Base\\Document\";s:4:\"type\";s:2:\"->\";}i:2;a:5:{s:4:\"file\";s:72:\"/dom528478/wp-content/plugins/elementor/includes/base/controls-stack.php\";s:4:\"line\";i:2435;s:8:\"function\";s:17:\"register_controls\";s:5:\"class\";s:33:\"Elementor\\Core\\Kits\\Documents\\Kit\";s:4:\"type\";s:2:\"->\";}i:3;a:5:{s:4:\"file\";s:72:\"/dom528478/wp-content/plugins/elementor/includes/base/controls-stack.php\";s:4:\"line\";i:570;s:8:\"function\";s:13:\"init_controls\";s:5:\"class\";s:24:\"Elementor\\Controls_Stack\";s:4:\"type\";s:2:\"->\";}i:4;a:5:{s:4:\"file\";s:72:\"/dom528478/wp-content/plugins/elementor/includes/base/controls-stack.php\";s:4:\"line\";i:315;s:8:\"function\";s:9:\"get_stack\";s:5:\"class\";s:24:\"Elementor\\Controls_Stack\";s:4:\"type\";s:2:\"->\";}}}s:8:\"\0*\0times\";i:4;s:14:\"\0*\0times_dates\";a:4:{i:0;s:19:\"2025-10-28 16:40:30\";i:1;s:19:\"2025-10-28 16:40:40\";i:2;s:19:\"2025-10-28 16:47:20\";i:3;s:19:\"2025-10-28 16:55:06\";}s:7:\"\0*\0args\";a:5:{s:4:\"type\";s:7:\"warning\";s:7:\"message\";s:46:\"Attempt to read property \"post_status\" on null\";s:4:\"file\";s:62:\"/dom528478/wp-content/plugins/elementor/core/base/document.php\";s:4:\"line\";i:1986;s:5:\"trace\";b:1;}s:7:\"\0*\0file\";s:62:\"/dom528478/wp-content/plugins/elementor/core/base/document.php\";s:7:\"\0*\0line\";i:1986;}s:32:\"1bf9bc0020f98e59000083760fde5dcd\";O:31:\"Elementor\\Core\\Logger\\Items\\PHP\":9:{s:7:\"\0*\0date\";s:19:\"2025-10-28 16:40:30\";s:7:\"\0*\0type\";s:7:\"warning\";s:10:\"\0*\0message\";s:56:\"Attempt to read property &quot;post_status&quot; on null\";s:7:\"\0*\0meta\";a:1:{s:5:\"trace\";a:5:{i:0;a:5:{s:4:\"file\";s:62:\"/dom528478/wp-content/plugins/elementor/core/base/document.php\";s:4:\"line\";i:1995;s:8:\"function\";s:18:\"rest_error_handler\";s:5:\"class\";s:29:\"Elementor\\Core\\Logger\\Manager\";s:4:\"type\";s:2:\"->\";}i:1;a:5:{s:4:\"file\";s:67:\"/dom528478/wp-content/plugins/elementor/core/kits/documents/kit.php\";s:4:\"line\";i:145;s:8:\"function\";s:26:\"register_document_controls\";s:5:\"class\";s:28:\"Elementor\\Core\\Base\\Document\";s:4:\"type\";s:2:\"->\";}i:2;a:5:{s:4:\"file\";s:72:\"/dom528478/wp-content/plugins/elementor/includes/base/controls-stack.php\";s:4:\"line\";i:2435;s:8:\"function\";s:17:\"register_controls\";s:5:\"class\";s:33:\"Elementor\\Core\\Kits\\Documents\\Kit\";s:4:\"type\";s:2:\"->\";}i:3;a:5:{s:4:\"file\";s:72:\"/dom528478/wp-content/plugins/elementor/includes/base/controls-stack.php\";s:4:\"line\";i:570;s:8:\"function\";s:13:\"init_controls\";s:5:\"class\";s:24:\"Elementor\\Controls_Stack\";s:4:\"type\";s:2:\"->\";}i:4;a:5:{s:4:\"file\";s:72:\"/dom528478/wp-content/plugins/elementor/includes/base/controls-stack.php\";s:4:\"line\";i:315;s:8:\"function\";s:9:\"get_stack\";s:5:\"class\";s:24:\"Elementor\\Controls_Stack\";s:4:\"type\";s:2:\"->\";}}}s:8:\"\0*\0times\";i:4;s:14:\"\0*\0times_dates\";a:4:{i:0;s:19:\"2025-10-28 16:40:30\";i:1;s:19:\"2025-10-28 16:40:40\";i:2;s:19:\"2025-10-28 16:47:20\";i:3;s:19:\"2025-10-28 16:55:06\";}s:7:\"\0*\0args\";a:5:{s:4:\"type\";s:7:\"warning\";s:7:\"message\";s:46:\"Attempt to read property \"post_status\" on null\";s:4:\"file\";s:62:\"/dom528478/wp-content/plugins/elementor/core/base/document.php\";s:4:\"line\";i:1995;s:5:\"trace\";b:1;}s:7:\"\0*\0file\";s:62:\"/dom528478/wp-content/plugins/elementor/core/base/document.php\";s:7:\"\0*\0line\";i:1995;}s:32:\"64612033995532ac37c67c6ed4b645fd\";O:31:\"Elementor\\Core\\Logger\\Items\\PHP\":9:{s:7:\"\0*\0date\";s:19:\"2025-10-28 16:41:27\";s:7:\"\0*\0type\";s:7:\"warning\";s:10:\"\0*\0message\";s:56:\"Attempt to read property &quot;post_status&quot; on null\";s:7:\"\0*\0meta\";a:1:{s:5:\"trace\";a:1:{i:0;a:3:{s:8:\"function\";s:8:\"shutdown\";s:5:\"class\";s:29:\"Elementor\\Core\\Logger\\Manager\";s:4:\"type\";s:2:\"->\";}}}s:8:\"\0*\0times\";i:3;s:14:\"\0*\0times_dates\";a:3:{i:0;s:19:\"2025-10-28 16:41:27\";i:1;s:19:\"2025-10-28 16:41:40\";i:2;s:19:\"2025-10-28 17:02:01\";}s:7:\"\0*\0args\";a:5:{s:4:\"type\";s:7:\"warning\";s:7:\"message\";s:46:\"Attempt to read property \"post_status\" on null\";s:4:\"file\";s:62:\"/dom528478/wp-content/plugins/elementor/core/base/document.php\";s:4:\"line\";i:1995;s:5:\"trace\";b:1;}s:7:\"\0*\0file\";s:62:\"/dom528478/wp-content/plugins/elementor/core/base/document.php\";s:7:\"\0*\0line\";i:1995;}s:32:\"20176940ae701dbf14a5ea3ef67073e8\";O:30:\"Elementor\\Core\\Logger\\Items\\JS\":10:{s:7:\"\0*\0date\";s:19:\"2025-10-29 15:38:11\";s:7:\"\0*\0type\";s:5:\"error\";s:10:\"\0*\0message\";s:58:\"Cannot read properties of null (reading &#039;clone&#039;)\";s:7:\"\0*\0meta\";a:0:{}s:8:\"\0*\0times\";i:8386;s:14:\"\0*\0times_dates\";a:42:{i:0;s:19:\"2025-10-29 16:42:13\";i:1;s:19:\"2025-10-29 16:42:14\";i:2;s:19:\"2025-10-29 16:42:14\";i:3;s:19:\"2025-10-29 16:42:15\";i:4;s:19:\"2025-10-29 16:42:15\";i:5;s:19:\"2025-10-29 16:42:15\";i:6;s:19:\"2025-10-29 16:42:15\";i:7;s:19:\"2025-10-29 16:42:18\";i:8;s:19:\"2025-10-29 16:42:18\";i:9;s:19:\"2025-10-29 16:42:41\";i:10;s:19:\"2025-10-29 16:42:41\";i:11;s:19:\"2025-10-29 16:42:44\";i:12;s:19:\"2025-10-29 16:42:44\";i:13;s:19:\"2025-10-29 16:42:44\";i:14;s:19:\"2025-10-29 16:42:44\";i:15;s:19:\"2025-10-29 16:42:44\";i:16;s:19:\"2025-10-29 16:42:44\";i:17;s:19:\"2025-10-29 16:42:44\";i:18;s:19:\"2025-10-29 16:42:44\";i:19;s:19:\"2025-10-29 16:42:44\";i:20;s:19:\"2025-10-29 16:42:45\";i:21;s:19:\"2025-10-29 16:42:45\";i:22;s:19:\"2025-10-29 16:42:45\";i:23;s:19:\"2025-10-29 16:42:45\";i:24;s:19:\"2025-10-29 16:42:45\";i:25;s:19:\"2025-10-29 16:42:45\";i:26;s:19:\"2025-10-29 16:42:45\";i:27;s:19:\"2025-10-29 16:42:45\";i:28;s:19:\"2025-10-29 16:42:45\";i:29;s:19:\"2025-10-29 16:42:45\";i:30;s:19:\"2025-10-29 16:42:45\";i:31;s:19:\"2025-10-29 16:42:45\";i:32;s:19:\"2025-10-29 16:42:45\";i:33;s:19:\"2025-10-29 16:42:45\";i:34;s:19:\"2025-10-29 16:42:46\";i:35;s:19:\"2025-10-29 16:42:46\";i:36;s:19:\"2025-10-29 16:42:46\";i:37;s:19:\"2025-10-29 16:42:46\";i:38;s:19:\"2025-10-29 16:42:46\";i:39;s:19:\"2025-10-29 16:42:46\";i:40;s:19:\"2025-10-29 16:42:46\";i:41;s:19:\"2025-10-29 16:42:46\";}s:7:\"\0*\0args\";a:6:{s:4:\"type\";s:5:\"error\";s:9:\"timestamp\";s:10:\"1761752291\";s:7:\"message\";s:48:\"Cannot read properties of null (reading \'clone\')\";s:3:\"url\";s:100:\"https://57r.860.myftpupload.com/wp-content/plugins/elementor/assets/lib/pickr/pickr.min.js?ver=1.8.2\";s:4:\"line\";s:1:\"2\";s:6:\"column\";s:5:\"14799\";}s:7:\"\0*\0file\";s:100:\"https://57r.860.myftpupload.com/wp-content/plugins/elementor/assets/lib/pickr/pickr.min.js?ver=1.8.2\";s:7:\"\0*\0line\";s:1:\"2\";s:9:\"\0*\0column\";s:5:\"14799\";}s:32:\"0a997826a2fbc91e2cea3d61324d249d\";O:30:\"Elementor\\Core\\Logger\\Items\\JS\":10:{s:7:\"\0*\0date\";s:19:\"2025-10-29 15:38:12\";s:7:\"\0*\0type\";s:5:\"error\";s:10:\"\0*\0message\";s:63:\"Cannot read properties of null (reading &#039;changestop&#039;)\";s:7:\"\0*\0meta\";a:0:{}s:8:\"\0*\0times\";i:171;s:14:\"\0*\0times_dates\";a:42:{i:0;s:19:\"2025-10-29 16:00:12\";i:1;s:19:\"2025-10-29 16:00:16\";i:2;s:19:\"2025-10-29 16:00:42\";i:3;s:19:\"2025-10-29 16:00:46\";i:4;s:19:\"2025-10-29 16:00:49\";i:5;s:19:\"2025-10-29 16:00:49\";i:6;s:19:\"2025-10-29 16:00:50\";i:7;s:19:\"2025-10-29 16:01:00\";i:8;s:19:\"2025-10-29 16:01:16\";i:9;s:19:\"2025-10-29 16:01:18\";i:10;s:19:\"2025-10-29 16:01:56\";i:11;s:19:\"2025-10-29 16:01:56\";i:12;s:19:\"2025-10-29 16:33:51\";i:13;s:19:\"2025-10-29 16:33:55\";i:14;s:19:\"2025-10-29 16:34:07\";i:15;s:19:\"2025-10-29 16:34:08\";i:16;s:19:\"2025-10-29 16:34:18\";i:17;s:19:\"2025-10-29 16:34:21\";i:18;s:19:\"2025-10-29 16:34:24\";i:19;s:19:\"2025-10-29 16:34:26\";i:20;s:19:\"2025-10-29 16:34:36\";i:21;s:19:\"2025-10-29 16:34:40\";i:22;s:19:\"2025-10-29 16:35:21\";i:23;s:19:\"2025-10-29 16:35:21\";i:24;s:19:\"2025-10-29 16:35:24\";i:25;s:19:\"2025-10-29 16:35:31\";i:26;s:19:\"2025-10-29 16:35:37\";i:27;s:19:\"2025-10-29 16:35:42\";i:28;s:19:\"2025-10-29 16:35:43\";i:29;s:19:\"2025-10-29 16:35:56\";i:30;s:19:\"2025-10-29 16:35:57\";i:31;s:19:\"2025-10-29 16:35:58\";i:32;s:19:\"2025-10-29 16:36:07\";i:33;s:19:\"2025-10-29 16:36:08\";i:34;s:19:\"2025-10-29 16:36:14\";i:35;s:19:\"2025-10-29 16:36:17\";i:36;s:19:\"2025-10-29 16:36:20\";i:37;s:19:\"2025-10-29 16:36:33\";i:38;s:19:\"2025-10-29 16:37:30\";i:39;s:19:\"2025-10-29 16:37:37\";i:40;s:19:\"2025-10-29 16:40:44\";i:41;s:19:\"2025-10-29 16:42:47\";}s:7:\"\0*\0args\";a:6:{s:4:\"type\";s:5:\"error\";s:9:\"timestamp\";s:10:\"1761752292\";s:7:\"message\";s:53:\"Cannot read properties of null (reading \'changestop\')\";s:3:\"url\";s:100:\"https://57r.860.myftpupload.com/wp-content/plugins/elementor/assets/lib/pickr/pickr.min.js?ver=1.8.2\";s:4:\"line\";s:1:\"2\";s:6:\"column\";s:5:\"19552\";}s:7:\"\0*\0file\";s:100:\"https://57r.860.myftpupload.com/wp-content/plugins/elementor/assets/lib/pickr/pickr.min.js?ver=1.8.2\";s:7:\"\0*\0line\";s:1:\"2\";s:9:\"\0*\0column\";s:5:\"19552\";}s:32:\"64e4ec41cfa32599812d4898ba68b37c\";O:30:\"Elementor\\Core\\Logger\\Items\\JS\":10:{s:7:\"\0*\0date\";s:19:\"2025-10-29 19:04:48\";s:7:\"\0*\0type\";s:5:\"error\";s:10:\"\0*\0message\";s:69:\"Cannot read properties of undefined (reading &#039;appendChild&#039;)\";s:7:\"\0*\0meta\";a:0:{}s:8:\"\0*\0times\";i:32;s:14:\"\0*\0times_dates\";a:32:{i:0;s:19:\"2025-10-29 19:04:48\";i:1;s:19:\"2025-10-29 19:07:57\";i:2;s:19:\"2025-10-29 19:08:14\";i:3;s:19:\"2025-10-29 19:08:47\";i:4;s:19:\"2025-10-29 19:11:19\";i:5;s:19:\"2025-10-29 19:13:57\";i:6;s:19:\"2025-10-29 19:14:59\";i:7;s:19:\"2025-10-29 19:15:30\";i:8;s:19:\"2025-10-29 19:16:15\";i:9;s:19:\"2025-10-29 19:16:51\";i:10;s:19:\"2025-10-29 19:22:49\";i:11;s:19:\"2025-10-29 19:24:27\";i:12;s:19:\"2025-10-29 19:26:29\";i:13;s:19:\"2025-10-29 21:16:52\";i:14;s:19:\"2025-10-29 21:25:41\";i:15;s:19:\"2025-10-29 21:29:22\";i:16;s:19:\"2025-10-29 21:33:44\";i:17;s:19:\"2025-10-30 14:27:41\";i:18;s:19:\"2025-10-30 14:29:43\";i:19;s:19:\"2025-10-30 14:29:53\";i:20;s:19:\"2025-10-30 14:30:58\";i:21;s:19:\"2025-10-30 14:34:39\";i:22;s:19:\"2025-10-30 14:34:44\";i:23;s:19:\"2025-10-30 14:36:40\";i:24;s:19:\"2025-10-30 14:41:54\";i:25;s:19:\"2025-10-30 14:53:19\";i:26;s:19:\"2025-10-30 14:53:40\";i:27;s:19:\"2025-10-30 14:53:41\";i:28;s:19:\"2025-10-30 14:53:41\";i:29;s:19:\"2025-10-30 14:53:54\";i:30;s:19:\"2025-10-30 15:01:46\";i:31;s:19:\"2025-10-30 15:12:10\";}s:7:\"\0*\0args\";a:6:{s:4:\"type\";s:5:\"error\";s:9:\"timestamp\";s:10:\"1761764688\";s:7:\"message\";s:59:\"Cannot read properties of undefined (reading \'appendChild\')\";s:3:\"url\";s:77:\"https://57r.860.myftpupload.com/wp-includes/js/jquery/jquery.min.js?ver=3.7.1\";s:4:\"line\";s:1:\"2\";s:6:\"column\";s:5:\"50280\";}s:7:\"\0*\0file\";s:77:\"https://57r.860.myftpupload.com/wp-includes/js/jquery/jquery.min.js?ver=3.7.1\";s:7:\"\0*\0line\";s:1:\"2\";s:9:\"\0*\0column\";s:5:\"50280\";}s:32:\"33ffaf96fe0383fbbd6239e458a026fc\";O:31:\"Elementor\\Core\\Logger\\Items\\PHP\":9:{s:7:\"\0*\0date\";s:19:\"2025-10-30 14:29:12\";s:7:\"\0*\0type\";s:5:\"error\";s:10:\"\0*\0message\";s:1418:\"Uncaught WpOrg\\Requests\\Exception\\Http\\Status403: 403 Forbidden in /dom528478/wp-content/plugins/elementor/modules/cloud-library/module.php:190\nStack trace:\n#0 /dom528478/wp-content/plugins/elementor/modules/cloud-library/module.php(53): Elementor\\Modules\\CloudLibrary\\Module-&gt;is_screenshot_proxy_mode(Array)\n#1 /dom528478/wp-content/plugins/elementor/core/base/module.php(86): Elementor\\Modules\\CloudLibrary\\Module-&gt;__construct()\n#2 /dom528478/wp-content/plugins/elementor/core/modules-manager.php(64): Elementor\\Core\\Base\\Module::instance()\n#3 /dom528478/wp-content/plugins/elementor/includes/plugin.php(709): Elementor\\Core\\Modules_Manager-&gt;__construct()\n#4 /dom528478/wp-content/plugins/elementor/includes/plugin.php(627): Elementor\\Plugin-&gt;init_components()\n#5 /dom528478/wp-includes/class-wp-hook.php(324): Elementor\\Plugin-&gt;init(&#039;&#039;)\n#6 /dom528478/wp-includes/class-wp-hook.php(348): WP_Hook-&gt;apply_filters(NULL, Array)\n#7 /dom528478/wp-includes/plugin.php(517): WP_Hook-&gt;do_action(Array)\n#8 /dom528478/wp-settings.php(727): do_action(&#039;init&#039;)\n#9 /dom528478/wp-config.php(52): require_once(&#039;/dom528478/wp-s...&#039;)\n#10 /dom528478/wp-load.php(50): require_once(&#039;/dom528478/wp-c...&#039;)\n#11 /dom528478/wp-blog-header.php(13): require_once(&#039;/dom528478/wp-l...&#039;)\n#12 /dom528478/index.php(17): require(&#039;/dom528478/wp-b...&#039;)\n#13 {main}\n  thrown\";s:7:\"\0*\0meta\";a:1:{s:5:\"trace\";a:1:{i:0;a:3:{s:8:\"function\";s:8:\"shutdown\";s:5:\"class\";s:29:\"Elementor\\Core\\Logger\\Manager\";s:4:\"type\";s:2:\"->\";}}}s:8:\"\0*\0times\";i:10;s:14:\"\0*\0times_dates\";a:10:{i:0;s:19:\"2025-10-30 14:29:12\";i:1;s:19:\"2025-10-30 14:29:12\";i:2;s:19:\"2025-10-30 14:29:13\";i:3;s:19:\"2025-10-30 14:29:13\";i:4;s:19:\"2025-10-30 14:29:13\";i:5;s:19:\"2025-10-30 14:29:35\";i:6;s:19:\"2025-10-30 14:29:35\";i:7;s:19:\"2025-10-30 14:29:35\";i:8;s:19:\"2025-10-30 14:29:35\";i:9;s:19:\"2025-10-30 14:29:36\";}s:7:\"\0*\0args\";a:5:{s:4:\"type\";s:5:\"error\";s:7:\"message\";s:1337:\"Uncaught WpOrg\\Requests\\Exception\\Http\\Status403: 403 Forbidden in /dom528478/wp-content/plugins/elementor/modules/cloud-library/module.php:190\nStack trace:\n#0 /dom528478/wp-content/plugins/elementor/modules/cloud-library/module.php(53): Elementor\\Modules\\CloudLibrary\\Module->is_screenshot_proxy_mode(Array)\n#1 /dom528478/wp-content/plugins/elementor/core/base/module.php(86): Elementor\\Modules\\CloudLibrary\\Module->__construct()\n#2 /dom528478/wp-content/plugins/elementor/core/modules-manager.php(64): Elementor\\Core\\Base\\Module::instance()\n#3 /dom528478/wp-content/plugins/elementor/includes/plugin.php(709): Elementor\\Core\\Modules_Manager->__construct()\n#4 /dom528478/wp-content/plugins/elementor/includes/plugin.php(627): Elementor\\Plugin->init_components()\n#5 /dom528478/wp-includes/class-wp-hook.php(324): Elementor\\Plugin->init(\'\')\n#6 /dom528478/wp-includes/class-wp-hook.php(348): WP_Hook->apply_filters(NULL, Array)\n#7 /dom528478/wp-includes/plugin.php(517): WP_Hook->do_action(Array)\n#8 /dom528478/wp-settings.php(727): do_action(\'init\')\n#9 /dom528478/wp-config.php(52): require_once(\'/dom528478/wp-s...\')\n#10 /dom528478/wp-load.php(50): require_once(\'/dom528478/wp-c...\')\n#11 /dom528478/wp-blog-header.php(13): require_once(\'/dom528478/wp-l...\')\n#12 /dom528478/index.php(17): require(\'/dom528478/wp-b...\')\n#13 {main}\n  thrown\";s:4:\"file\";s:72:\"/dom528478/wp-content/plugins/elementor/modules/cloud-library/module.php\";s:4:\"line\";i:190;s:5:\"trace\";b:1;}s:7:\"\0*\0file\";s:72:\"/dom528478/wp-content/plugins/elementor/modules/cloud-library/module.php\";s:7:\"\0*\0line\";i:190;}s:32:\"ecd1b8fef63dcb07352b72e789ef71e0\";O:30:\"Elementor\\Core\\Logger\\Items\\JS\":10:{s:7:\"\0*\0date\";s:19:\"2025-10-30 14:56:51\";s:7:\"\0*\0type\";s:5:\"error\";s:10:\"\0*\0message\";s:66:\"Cannot read properties of undefined (reading &#039;activate&#039;)\";s:7:\"\0*\0meta\";a:0:{}s:8:\"\0*\0times\";i:1;s:14:\"\0*\0times_dates\";a:1:{i:0;s:19:\"2025-10-30 14:56:51\";}s:7:\"\0*\0args\";a:6:{s:4:\"type\";s:5:\"error\";s:9:\"timestamp\";s:10:\"1761836211\";s:7:\"message\";s:56:\"Cannot read properties of undefined (reading \'activate\')\";s:3:\"url\";s:95:\"https://57r.860.myftpupload.com/wp-content/plugins/elementor/assets/js/editor.min.js?ver=3.32.5\";s:4:\"line\";s:1:\"3\";s:6:\"column\";s:6:\"862475\";}s:7:\"\0*\0file\";s:95:\"https://57r.860.myftpupload.com/wp-content/plugins/elementor/assets/js/editor.min.js?ver=3.32.5\";s:7:\"\0*\0line\";s:1:\"3\";s:9:\"\0*\0column\";s:6:\"862475\";}s:32:\"1efbf93c94375472cce4091a08d9cac1\";O:32:\"Elementor\\Core\\Logger\\Items\\Base\":7:{s:7:\"\0*\0date\";s:19:\"2025-11-10 21:41:19\";s:7:\"\0*\0type\";s:4:\"info\";s:10:\"\0*\0message\";s:47:\"Elementor data updater process has been queued.\";s:7:\"\0*\0meta\";a:3:{s:6:\"plugin\";s:9:\"Elementor\";s:4:\"from\";s:6:\"3.32.5\";s:2:\"to\";s:6:\"3.33.0\";}s:8:\"\0*\0times\";i:1;s:14:\"\0*\0times_dates\";a:1:{i:0;s:19:\"2025-11-10 21:41:19\";}s:7:\"\0*\0args\";a:3:{s:4:\"meta\";a:3:{s:6:\"plugin\";s:9:\"Elementor\";s:4:\"from\";s:6:\"3.32.5\";s:2:\"to\";s:6:\"3.33.0\";}s:7:\"message\";s:47:\"Elementor data updater process has been queued.\";s:4:\"type\";s:4:\"info\";}}s:32:\"ab6e5e571acbc9be8edec31dbf72f4e6\";O:32:\"Elementor\\Core\\Logger\\Items\\Base\":7:{s:7:\"\0*\0date\";s:19:\"2025-11-10 21:46:36\";s:7:\"\0*\0type\";s:4:\"info\";s:10:\"\0*\0message\";s:36:\"elementor::elementor_updater Started\";s:7:\"\0*\0meta\";a:0:{}s:8:\"\0*\0times\";i:1;s:14:\"\0*\0times_dates\";a:1:{i:0;s:19:\"2025-11-10 21:46:36\";}s:7:\"\0*\0args\";a:2:{s:7:\"message\";s:36:\"elementor::elementor_updater Started\";s:4:\"type\";s:4:\"info\";}}s:32:\"d3d9ba5966003fe7bcdb40265b4a4ed0\";O:32:\"Elementor\\Core\\Logger\\Items\\Base\":7:{s:7:\"\0*\0date\";s:19:\"2025-11-10 21:46:36\";s:7:\"\0*\0type\";s:4:\"info\";s:10:\"\0*\0message\";s:44:\"Elementor/Upgrades - _on_each_version Start \";s:7:\"\0*\0meta\";a:0:{}s:8:\"\0*\0times\";i:1;s:14:\"\0*\0times_dates\";a:1:{i:0;s:19:\"2025-11-10 21:46:36\";}s:7:\"\0*\0args\";a:2:{s:7:\"message\";s:44:\"Elementor/Upgrades - _on_each_version Start \";s:4:\"type\";s:4:\"info\";}}s:32:\"c93c15a4c28248937a969a038919c3e5\";O:32:\"Elementor\\Core\\Logger\\Items\\Base\":7:{s:7:\"\0*\0date\";s:19:\"2025-11-10 21:46:36\";s:7:\"\0*\0type\";s:4:\"info\";s:10:\"\0*\0message\";s:46:\"Elementor/Upgrades - _on_each_version Finished\";s:7:\"\0*\0meta\";a:0:{}s:8:\"\0*\0times\";i:1;s:14:\"\0*\0times_dates\";a:1:{i:0;s:19:\"2025-11-10 21:46:36\";}s:7:\"\0*\0args\";a:2:{s:7:\"message\";s:46:\"Elementor/Upgrades - _on_each_version Finished\";s:4:\"type\";s:4:\"info\";}}s:32:\"e8a943a52ad35268eae6cd68b6aa3a63\";O:32:\"Elementor\\Core\\Logger\\Items\\Base\":7:{s:7:\"\0*\0date\";s:19:\"2025-11-10 21:46:37\";s:7:\"\0*\0type\";s:4:\"info\";s:10:\"\0*\0message\";s:50:\"Elementor data updater process has been completed.\";s:7:\"\0*\0meta\";a:3:{s:6:\"plugin\";s:9:\"Elementor\";s:4:\"from\";s:6:\"3.32.5\";s:2:\"to\";s:6:\"3.33.0\";}s:8:\"\0*\0times\";i:1;s:14:\"\0*\0times_dates\";a:1:{i:0;s:19:\"2025-11-10 21:46:37\";}s:7:\"\0*\0args\";a:3:{s:4:\"meta\";a:3:{s:6:\"plugin\";s:9:\"Elementor\";s:4:\"from\";s:6:\"3.32.5\";s:2:\"to\";s:6:\"3.33.0\";}s:7:\"message\";s:50:\"Elementor data updater process has been completed.\";s:4:\"type\";s:4:\"info\";}}s:32:\"b1deca75fd921fab0d5c70126185e727\";O:32:\"Elementor\\Core\\Logger\\Items\\Base\":7:{s:7:\"\0*\0date\";s:19:\"2025-11-17 21:38:19\";s:7:\"\0*\0type\";s:4:\"info\";s:10:\"\0*\0message\";s:47:\"Elementor data updater process has been queued.\";s:7:\"\0*\0meta\";a:3:{s:6:\"plugin\";s:9:\"Elementor\";s:4:\"from\";s:6:\"3.33.0\";s:2:\"to\";s:6:\"3.33.1\";}s:8:\"\0*\0times\";i:1;s:14:\"\0*\0times_dates\";a:1:{i:0;s:19:\"2025-11-17 21:38:19\";}s:7:\"\0*\0args\";a:3:{s:4:\"meta\";a:3:{s:6:\"plugin\";s:9:\"Elementor\";s:4:\"from\";s:6:\"3.33.0\";s:2:\"to\";s:6:\"3.33.1\";}s:7:\"message\";s:47:\"Elementor data updater process has been queued.\";s:4:\"type\";s:4:\"info\";}}s:32:\"c3423b86e160d51bb4e865242ef5744a\";O:32:\"Elementor\\Core\\Logger\\Items\\Base\":7:{s:7:\"\0*\0date\";s:19:\"2025-11-17 21:44:22\";s:7:\"\0*\0type\";s:4:\"info\";s:10:\"\0*\0message\";s:36:\"elementor::elementor_updater Started\";s:7:\"\0*\0meta\";a:0:{}s:8:\"\0*\0times\";i:1;s:14:\"\0*\0times_dates\";a:1:{i:0;s:19:\"2025-11-17 21:44:22\";}s:7:\"\0*\0args\";a:2:{s:7:\"message\";s:36:\"elementor::elementor_updater Started\";s:4:\"type\";s:4:\"info\";}}s:32:\"f72ad9a30901431f265e28f40e31d6dc\";O:32:\"Elementor\\Core\\Logger\\Items\\Base\":7:{s:7:\"\0*\0date\";s:19:\"2025-11-17 21:44:22\";s:7:\"\0*\0type\";s:4:\"info\";s:10:\"\0*\0message\";s:44:\"Elementor/Upgrades - _on_each_version Start \";s:7:\"\0*\0meta\";a:0:{}s:8:\"\0*\0times\";i:1;s:14:\"\0*\0times_dates\";a:1:{i:0;s:19:\"2025-11-17 21:44:22\";}s:7:\"\0*\0args\";a:2:{s:7:\"message\";s:44:\"Elementor/Upgrades - _on_each_version Start \";s:4:\"type\";s:4:\"info\";}}s:32:\"65388d810a0fae925121883a8eed85a1\";O:32:\"Elementor\\Core\\Logger\\Items\\Base\":7:{s:7:\"\0*\0date\";s:19:\"2025-11-17 21:44:22\";s:7:\"\0*\0type\";s:4:\"info\";s:10:\"\0*\0message\";s:46:\"Elementor/Upgrades - _on_each_version Finished\";s:7:\"\0*\0meta\";a:0:{}s:8:\"\0*\0times\";i:1;s:14:\"\0*\0times_dates\";a:1:{i:0;s:19:\"2025-11-17 21:44:22\";}s:7:\"\0*\0args\";a:2:{s:7:\"message\";s:46:\"Elementor/Upgrades - _on_each_version Finished\";s:4:\"type\";s:4:\"info\";}}s:32:\"c500fe9b2f846503eb86453883db1eff\";O:32:\"Elementor\\Core\\Logger\\Items\\Base\":7:{s:7:\"\0*\0date\";s:19:\"2025-11-17 21:44:22\";s:7:\"\0*\0type\";s:4:\"info\";s:10:\"\0*\0message\";s:50:\"Elementor data updater process has been completed.\";s:7:\"\0*\0meta\";a:3:{s:6:\"plugin\";s:9:\"Elementor\";s:4:\"from\";s:6:\"3.33.0\";s:2:\"to\";s:6:\"3.33.1\";}s:8:\"\0*\0times\";i:1;s:14:\"\0*\0times_dates\";a:1:{i:0;s:19:\"2025-11-17 21:44:22\";}s:7:\"\0*\0args\";a:3:{s:4:\"meta\";a:3:{s:6:\"plugin\";s:9:\"Elementor\";s:4:\"from\";s:6:\"3.33.0\";s:2:\"to\";s:6:\"3.33.1\";}s:7:\"message\";s:50:\"Elementor data updater process has been completed.\";s:4:\"type\";s:4:\"info\";}}s:32:\"48aefea582030076d15f43b2ed9c7e4b\";O:32:\"Elementor\\Core\\Logger\\Items\\Base\":7:{s:7:\"\0*\0date\";s:19:\"2025-11-23 21:42:57\";s:7:\"\0*\0type\";s:4:\"info\";s:10:\"\0*\0message\";s:47:\"Elementor data updater process has been queued.\";s:7:\"\0*\0meta\";a:3:{s:6:\"plugin\";s:9:\"Elementor\";s:4:\"from\";s:6:\"3.33.1\";s:2:\"to\";s:6:\"3.33.2\";}s:8:\"\0*\0times\";i:1;s:14:\"\0*\0times_dates\";a:1:{i:0;s:19:\"2025-11-23 21:42:57\";}s:7:\"\0*\0args\";a:3:{s:4:\"meta\";a:3:{s:6:\"plugin\";s:9:\"Elementor\";s:4:\"from\";s:6:\"3.33.1\";s:2:\"to\";s:6:\"3.33.2\";}s:7:\"message\";s:47:\"Elementor data updater process has been queued.\";s:4:\"type\";s:4:\"info\";}}}','off');
INSERT INTO `wp_79e54b1ec2_options` VALUES ('3101','elementskit_options','a:1:{s:17:\"megamenu_settings\";a:2:{s:15:\"menu_location_0\";a:1:{s:10:\"is_enabled\";i:0;}s:15:\"menu_location_3\";a:1:{s:10:\"is_enabled\";i:0;}}}','auto');
INSERT INTO `wp_79e54b1ec2_options` VALUES ('3216','nav_menu_options','a:2:{i:0;b:0;s:8:\"auto_add\";a:0:{}}','off');
INSERT INTO `wp_79e54b1ec2_options` VALUES ('5432','skb_cife_version','1.1.0','auto');
INSERT INTO `wp_79e54b1ec2_options` VALUES ('5451','skb_cife_general','','auto');
INSERT INTO `wp_79e54b1ec2_options` VALUES ('5452','skb_cife_manage_icon','','auto');
INSERT INTO `wp_79e54b1ec2_options` VALUES ('5453','skb_cife_update_info','','auto');
INSERT INTO `wp_79e54b1ec2_options` VALUES ('5481','elementor_pro_license_key','*********','auto');
INSERT INTO `wp_79e54b1ec2_options` VALUES ('5482','_elementor_pro_license_v2_data','a:2:{s:7:\"timeout\";i:1764243591;s:5:\"value\";s:71:\"{\"success\":true,\"license\":\"valid\",\"expires\":\"01.01.2030\",\"features\":[]}\";}','auto');
INSERT INTO `wp_79e54b1ec2_options` VALUES ('5483','elementor_pro_version','3.11.2','auto');
INSERT INTO `wp_79e54b1ec2_options` VALUES ('5484','widget_elementor-library','a:1:{s:12:\"_multiwidget\";i:1;}','auto');
INSERT INTO `wp_79e54b1ec2_options` VALUES ('5488','_elementor_pro_installed_time','1761667396','auto');
INSERT INTO `wp_79e54b1ec2_options` VALUES ('5489','_elementor_pro_api_requests_lock','a:1:{s:11:\"get_version\";i:1763940875;}','auto');
INSERT INTO `wp_79e54b1ec2_options` VALUES ('5491','elementor_submissions_db_version','5','auto');
INSERT INTO `wp_79e54b1ec2_options` VALUES ('5549','elementor_fonts_manager_font_types','a:0:{}','auto');
INSERT INTO `wp_79e54b1ec2_options` VALUES ('5550','elementor_fonts_manager_fonts','a:0:{}','auto');
INSERT INTO `wp_79e54b1ec2_options` VALUES ('5584','elementor_pro_theme_builder_conditions','a:0:{}','auto');
INSERT INTO `wp_79e54b1ec2_options` VALUES ('5675','elementor_custom_icon_sets_config','a:0:{}','auto');
INSERT INTO `wp_79e54b1ec2_options` VALUES ('6309','elementor_library_category_children','a:0:{}','auto');
INSERT INTO `wp_79e54b1ec2_options` VALUES ('6997','elementor_clear_cache','','auto');
INSERT INTO `wp_79e54b1ec2_options` VALUES ('6998','elementor_reset_api_data','','auto');
INSERT INTO `wp_79e54b1ec2_options` VALUES ('7000','elementor_enable_inspector','','auto');
INSERT INTO `wp_79e54b1ec2_options` VALUES ('7001','elementor_replace_url','','auto');
INSERT INTO `wp_79e54b1ec2_options` VALUES ('7002','elementor_rollback','','auto');
INSERT INTO `wp_79e54b1ec2_options` VALUES ('7003','elementor_rollback_pro_separator','','auto');
INSERT INTO `wp_79e54b1ec2_options` VALUES ('7004','elementor_rollback_pro','','auto');
INSERT INTO `wp_79e54b1ec2_options` VALUES ('7005','elementor_beta','no','auto');
INSERT INTO `wp_79e54b1ec2_options` VALUES ('7006','elementor_maintenance_mode_mode','','auto');
INSERT INTO `wp_79e54b1ec2_options` VALUES ('7007','elementor_maintenance_mode_exclude_mode','logged_in','auto');
INSERT INTO `wp_79e54b1ec2_options` VALUES ('7008','elementor_maintenance_mode_exclude_roles','a:0:{}','auto');
INSERT INTO `wp_79e54b1ec2_options` VALUES ('7009','elementor_maintenance_mode_template_id','','auto');
INSERT INTO `wp_79e54b1ec2_options` VALUES ('7254','elementor_import_sessions','a:1:{s:13:\"6900f0e9a0d1d\";a:9:{s:10:\"session_id\";s:13:\"6900f0e9a0d1d\";s:9:\"kit_title\";s:48:\"Voltawork - Template kit for electrical services\";s:8:\"kit_name\";s:48:\"Voltawork - Template kit for electrical services\";s:13:\"kit_thumbnail\";s:0:\"\";s:10:\"kit_source\";s:5:\"local\";s:7:\"user_id\";i:2;s:15:\"start_timestamp\";i:1761669389;s:13:\"end_timestamp\";i:1761669420;s:7:\"runners\";a:2:{s:13:\"site-settings\";a:8:{s:15:\"previous_kit_id\";i:0;s:13:\"active_kit_id\";i:137;s:15:\"imported_kit_id\";i:193;s:15:\"installed_theme\";N;s:15:\"activated_theme\";N;s:21:\"previous_active_theme\";N;s:20:\"previous_experiments\";a:0:{}s:20:\"imported_experiments\";a:0:{}}s:9:\"templates\";a:0:{}}}}','off');
INSERT INTO `wp_79e54b1ec2_options` VALUES ('7258','elementor_previous_kit','137','auto');
INSERT INTO `wp_79e54b1ec2_options` VALUES ('7325','wpaas_dismissed_68be827708e46aba3f8ee7c9060c4fc2','1','auto');
INSERT INTO `wp_79e54b1ec2_options` VALUES ('7377','elementor_experiment-e_opt_in_v4','active','auto');
INSERT INTO `wp_79e54b1ec2_options` VALUES ('7378','elementor_experiment-container','active','auto');
INSERT INTO `wp_79e54b1ec2_options` VALUES ('7379','elementor_experiment-nested-elements','active','auto');
INSERT INTO `wp_79e54b1ec2_options` VALUES ('7380','elementor_experiment-e_atomic_elements','active','auto');
INSERT INTO `wp_79e54b1ec2_options` VALUES ('7381','elementor_experiment-e_classes','active','auto');
INSERT INTO `wp_79e54b1ec2_options` VALUES ('7382','elementor_experiment-e_variables','active','auto');
INSERT INTO `wp_79e54b1ec2_options` VALUES ('7386','elementor_atomic_widgets_db_version','1','auto');
INSERT INTO `wp_79e54b1ec2_options` VALUES ('7387','elementor_global_classes_db_version','1','auto');
INSERT INTO `wp_79e54b1ec2_options` VALUES ('7442','_elementor_home_screen_data','a:2:{s:7:\"timeout\";i:1761673123;s:5:\"value\";s:11286:\"{\"top_with_licences\":[{\"license\":[\"free\"],\"title_small\":\"Hi!\",\"title\":\"Unleash your imagination with Elementor\",\"description\":\"Start building your website with Elementor\'s no code drag & drop editor.\",\"button_create_page_title\":\"Create a Page\",\"button_watch_title\":\"Watch a guide\",\"button_watch_url\":\"https:\\/\\/www.youtube.com\\/watch?v=le72grP_Q6k&t=1s\",\"youtube_embed_id\":\"le72grP_Q6k?si=g2akyWNODL6usu6u\"},{\"license\":[\"pro\"],\"title_small\":\"Hi!\",\"title\":\"Unleash your imagination with Elementor\",\"description\":\"Now you\'ve got all the tools to start creating professional, high-performing websites - and that journey begins by creating your first page.\",\"button_create_page_title\":\"Create a Page\",\"button_watch_title\":\"Watch a guide\",\"button_watch_url\":\"https:\\/\\/www.youtube.com\\/watch?v=QdkDGrS8ZZs\",\"youtube_embed_id\":\"QdkDGrS8ZZs?si=s_VjZCQR6Fh1jgB5\"}],\"get_started\":[{\"license\":[\"free\"],\"header\":{\"title\":\"Jumpstart your web-creation\",\"description\":\"These quick actions will get your site airborne with a customized design.\"},\"repeater\":[{\"title\":\"Site Settings\",\"title_small\":\"Customize\",\"url\":\"\",\"is_relative_url\":false,\"title_small_color\":\"text.tertiary\",\"image\":\"https:\\/\\/assets.elementor.com\\/home-screen\\/v1\\/images\\/site-settings.svg\"},{\"title\":\"Site Logo\",\"title_small\":\"Customize\",\"url\":\"\",\"is_relative_url\":false,\"title_small_color\":\"text.tertiary\",\"tab_id\":\"settings-site-identity\",\"image\":\"https:\\/\\/assets.elementor.com\\/home-screen\\/v1\\/images\\/site-logo.svg\"},{\"title\":\"Global Colors\",\"title_small\":\"Customize\",\"url\":\"\",\"is_relative_url\":false,\"title_small_color\":\"text.tertiary\",\"tab_id\":\"global-colors\",\"image\":\"https:\\/\\/assets.elementor.com\\/home-screen\\/v1\\/images\\/global-colors.svg\"},{\"title\":\"Global Fonts\",\"title_small\":\"Customize\",\"url\":\"\",\"is_relative_url\":false,\"title_small_color\":\"text.tertiary\",\"tab_id\":\"global-typography\",\"image\":\"https:\\/\\/assets.elementor.com\\/home-screen\\/v1\\/images\\/global-fonts.svg\"},{\"title\":\"Theme Builder\",\"title_small\":\"Customize\",\"url\":\"admin.php?page=elementor-app\",\"is_relative_url\":false,\"title_small_color\":\"text.tertiary\",\"image\":\"https:\\/\\/assets.elementor.com\\/home-screen\\/v1\\/images\\/theme-builder.svg\"},{\"title\":\"Popups\",\"title_small\":\"Customize\",\"url\":\"edit.php?post_type=elementor_library&page=popup_templates\",\"is_relative_url\":true,\"title_small_color\":\"text.tertiary\",\"image\":\"https:\\/\\/assets.elementor.com\\/home-screen\\/v1\\/images\\/popups.svg\"},{\"title\":\"Custom Icons\",\"title_small\":\"Customize\",\"url\":\"admin.php?page=elementor_custom_icons\",\"is_relative_url\":false,\"title_small_color\":\"text.tertiary\",\"image\":\"https:\\/\\/assets.elementor.com\\/home-screen\\/v1\\/images\\/custom-icons.svg\"},{\"title\":\"Custom Fonts\",\"title_small\":\"Customize\",\"url\":\"admin.php?page=elementor_custom_fonts\",\"is_relative_url\":true,\"image\":\"https:\\/\\/assets.elementor.com\\/home-screen\\/v1\\/images\\/custom-fonts.svg\",\"title_small_color\":\"text.tertiary\"}]},{\"license\":[\"pro\"],\"header\":{\"title\":\"Jumpstart your web-creation\",\"description\":\"These quick actions will get your site airborne with a customized design.\"},\"repeater\":[{\"title\":\"Site Settings\",\"title_small\":\"Customize\",\"url\":\"\",\"is_relative_url\":false,\"image\":\"https:\\/\\/assets.elementor.com\\/home-screen\\/v1\\/images\\/site-settings.svg\"},{\"title\":\"Site Logo\",\"title_small\":\"Customize\",\"url\":\"\",\"is_relative_url\":false,\"tab_id\":\"settings-site-identity\",\"image\":\"https:\\/\\/assets.elementor.com\\/home-screen\\/v1\\/images\\/site-logo.svg\"},{\"title\":\"Global Colors\",\"title_small\":\"Customize\",\"url\":\"\",\"is_relative_url\":false,\"tab_id\":\"global-colors\",\"image\":\"https:\\/\\/assets.elementor.com\\/home-screen\\/v1\\/images\\/global-colors.svg\"},{\"title\":\"Global Fonts\",\"title_small\":\"Customize\",\"url\":\"\",\"is_relative_url\":false,\"tab_id\":\"global-typography\",\"image\":\"https:\\/\\/assets.elementor.com\\/home-screen\\/v1\\/images\\/global-fonts.svg\"},{\"title\":\"Theme Builder\",\"title_small\":\"Customize\",\"url\":\"admin.php?page=elementor-app\",\"is_relative_url\":false,\"image\":\"https:\\/\\/assets.elementor.com\\/home-screen\\/v1\\/images\\/theme-builder.svg\"},{\"title\":\"Popups\",\"title_small\":\"Customize\",\"url\":\"edit.php?post_type=elementor_library&tabs_group=popup&elementor_library_type=popup\",\"is_relative_url\":true,\"image\":\"https:\\/\\/assets.elementor.com\\/home-screen\\/v1\\/images\\/popups.svg\"},{\"title\":\"Custom Icons\",\"title_small\":\"Customize\",\"url\":\"admin.php?page=elementor_custom_icons\",\"is_relative_url\":false,\"image\":\"https:\\/\\/assets.elementor.com\\/home-screen\\/v1\\/images\\/custom-icons.svg\"},{\"title\":\"Custom Fonts\",\"title_small\":\"Customize\",\"url\":\"admin.php?page=elementor_custom_fonts\",\"is_relative_url\":true,\"image\":\"https:\\/\\/assets.elementor.com\\/home-screen\\/v1\\/images\\/custom-fonts.svg\"}]}],\"add_ons\":{\"header\":{\"title\":\"Expand your design toolkit\",\"description\":\"These plugins, add-ons, and tools, have been selected to streamline your workflow and maximize your creativity.\"},\"repeater\":[{\"file_path\":\"pojo-accessibility\\/pojo-accessibility.php\",\"title\":\"Ally - Web Accessibility. Simplified.\",\"url\":\"\",\"description\":\"Make your website more accessible with powerful tools to detect and fix issues, enhance usability, and create a better experience for all visitors.\",\"button_label\":\"Install\",\"image\":\"https:\\/\\/assets.elementor.com\\/home-screen\\/v1\\/images\\/ally_logo.svg\",\"type\":\"wporg\"},{\"file_path\":\"send-app\\/send-app.php\",\"title\":\"Send \\u2013 Marketing Automation\",\"url\":\"\",\"description\":\"Supercharge your WooCommerce store with Send\\u2014an all-in-one toolkit for emails, popups & more. Built for WordPress. No plugins, no hassle.\",\"button_label\":\"Install\",\"image\":\"https:\\/\\/assets.elementor.com\\/home-screen\\/v1\\/images\\/send-logo.svg\",\"type\":\"wporg\"},{\"file_path\":\"site-mailer\\/site-mailer.php\",\"title\":\"Site Mailer\",\"url\":\"\",\"description\":\"Keep your WordPress emails out of the spam folder with improved deliverability and an easy setup\\u2014no need for an SMTP plugin or complicated configurations.\",\"button_label\":\"Install\",\"image\":\"https:\\/\\/assets.elementor.com\\/home-screen\\/v1\\/images\\/site-mailer.svg\",\"type\":\"wporg\"},{\"file_path\":\"image-optimization\\/image-optimization.php\",\"title\":\"Image Optimizer\",\"url\":\"https:\\/\\/go.elementor.com\\/wp-dash-apps-author-uri-elementor-io\\/\",\"description\":\"Check out this incredibly useful plugin that will compress and optimize your images, giving you leaner, faster websites.\",\"button_label\":\"Install\",\"image\":\"https:\\/\\/assets.elementor.com\\/home-screen\\/v1\\/images\\/image-optimizer.svg\",\"type\":\"wporg\"},{\"title\":\"Elementor AI\",\"url\":\"https:\\/\\/go.elementor.com\\/wp-dash-apps-author-uri-elementor-ai\\/\",\"description\":\"Boost creativity with Elementor AI. Craft & enhance copy, create custom CSS & Code, and generate images to elevate your website.\",\"button_label\":\"Let\'s go\",\"image\":\"https:\\/\\/assets.elementor.com\\/home-screen\\/v1\\/images\\/elementor.svg\",\"type\":\"link\",\"condition\":{\"key\":\"introduction_meta\",\"value\":\"ai_get_started\"}}],\"footer\":{\"label\":\"Explore more add-ons\",\"file_path\":\"wp-admin\\/admin.php?page=elementor-apps\"}},\"sidebar_upgrade\":[{\"license\":[\"free\"],\"show\":\"true\",\"header\":{\"title\":\"Bring your vision to life\",\"description\":\"Get complete design flexibility for your website with Elementor Pro\\u2019s advanced tools and premium features.\",\"image\":\"https:\\/\\/assets.elementor.com\\/home-screen\\/v1\\/images\\/icon-crown.svg\"},\"cta\":{\"label\":\"Upgrade Now\",\"url\":\"https:\\/\\/go.elementor.com\\/go-pro-home-sidebar-upgrade\\/\",\"image\":\"https:\\/\\/assets.elementor.com\\/home-screen\\/v1\\/images\\/icon-crown.svg\"},\"repeater\":[{\"title\":\"Popup Builder\"},{\"title\":\"Custom Code & CSS\"},{\"title\":\"E-commerce Features\"},{\"title\":\"Collaborative Notes\"},{\"title\":\"Form Submission\"},{\"title\":\"Form Integrations\"},{\"title\":\"Custom Attributes\"},{\"title\":\"Role Manager\"}]},{\"license\":[\"pro\"],\"show\":\"false\",\"header\":{\"title\":\"Bring your vision to life\",\"description\":\"Get complete design flexibility for your website with Elementor Pro\\u2019s advanced tools and premium features.\",\"image\":\"https:\\/\\/assets.elementor.com\\/home-screen\\/v1\\/images\\/icon-crown.svg\"},\"cta\":{\"label\":\"Upgrade Now\",\"url\":\"https:\\/\\/go.elementor.com\\/go-pro-home-sidebar-upgrade\\/\",\"image\":\"https:\\/\\/assets.elementor.com\\/home-screen\\/v1\\/images\\/icon-crown.svg\"},\"repeater\":[{\"title\":\"Popup Builder\"},{\"title\":\"Custom Code & CSS\"},{\"title\":\"E-commerce Features\"},{\"title\":\"Collaborative Notes\"},{\"title\":\"Form Submission\"},{\"title\":\"Form Integrations\"},{\"title\":\"Custom Attributes\"},{\"title\":\"Role Manager\"}]}],\"sidebar_promotion_variants\":[{\"license\":[\"essential\"],\"is_enabled\":\"true\",\"type\":\"banner\",\"data\":{\"image\":\"https:\\/\\/assets.elementor.com\\/home-screen\\/v1\\/images\\/essential-upgrade.svg\",\"link\":\"https:\\/\\/go.elementor.com\\/go-pro-advanced-home-sidebar-upgrade\\/\"}},{\"license\":[\"free\"],\"is_enabled\":\"true\",\"type\":\"banner\",\"data\":{\"image\":\"https:\\/\\/assets.elementor.com\\/home-screen\\/v1\\/images\\/upgrade-free.svg\",\"link\":\"https:\\/\\/go.elementor.com\\/go-pro-home-sidebar-upgrade\\/\"}},{\"license\":[\"expired\"],\"is_enabled\":\"true\",\"type\":\"banner\",\"data\":{\"image\":\"https:\\/\\/assets.elementor.com\\/home-screen\\/v1\\/images\\/upgrade-free.svg\",\"link\":\"https:\\/\\/go.elementor.com\\/go-pro-home-sidebar-expired\\/\"}},{\"license\":[\"free\"],\"is_enabled\":\"false\",\"type\":\"default\",\"data\":{\"header\":{\"title\":\"Bring your vision to life\",\"description\":\"Get complete design flexibility for your website with Elementor Pro\\u2019s advanced tools and premium features.\",\"image\":\"https:\\/\\/assets.elementor.com\\/home-screen\\/v1\\/images\\/update-sidebar.svg\"},\"cta\":{\"label\":\"Upgrade Now\",\"url\":\"https:\\/\\/go.elementor.com\\/go-pro-home-sidebar-upgrade\\/\",\"image\":\"https:\\/\\/assets.elementor.com\\/home-screen\\/v1\\/images\\/icon-crown.svg\"},\"repeater\":[{\"title\":\"Popup Builder\"},{\"title\":\"Custom Code & CSS\"},{\"title\":\"E-commerce Features\"},{\"title\":\"Collaborative Notes\"},{\"title\":\"Form Submission\"},{\"title\":\"Form Integrations\"},{\"title\":\"Custom Attributes\"},{\"title\":\"Role Manager\"}]}},{\"license\":[\"pro\"],\"is_enabled\":\"false\",\"type\":\"default\",\"data\":{\"header\":{\"title\":\"Bring your vision to life\",\"description\":\"Get complete design flexibility for your website with Elementor Pro\\u2019s advanced tools and premium features.\",\"image\":\"https:\\/\\/assets.elementor.com\\/home-screen\\/v1\\/images\\/update-sidebar.svg\"},\"cta\":{\"label\":\"Upgrade Now\",\"url\":\"https:\\/\\/go.elementor.com\\/go-pro-home-sidebar-upgrade\\/\",\"image\":\"https:\\/\\/assets.elementor.com\\/home-screen\\/v1\\/images\\/icon-crown.svg\"},\"repeater\":[{\"title\":\"Popup Builder\"},{\"title\":\"Custom Code & CSS\"},{\"title\":\"E-commerce Features\"},{\"title\":\"Collaborative Notes\"},{\"title\":\"Form Submission\"},{\"title\":\"Form Integrations\"},{\"title\":\"Custom Attributes\"},{\"title\":\"Role Manager\"}]}}],\"external_links\":[{\"label\":\"Help Center\",\"image\":\"https:\\/\\/assets.elementor.com\\/home-screen\\/v1\\/images\\/icon-question-mark.svg\",\"url\":\"https:\\/\\/elementor.com\\/help\\/\"},{\"label\":\"Youtube\",\"image\":\"https:\\/\\/assets.elementor.com\\/home-screen\\/v1\\/images\\/icon-youtube.svg\",\"url\":\"https:\\/\\/www.youtube.com\\/@Elementor\"},{\"label\":\"Facebook Community\",\"image\":\"https:\\/\\/assets.elementor.com\\/home-screen\\/v1\\/images\\/icon-community.svg\",\"url\":\"https:\\/\\/www.facebook.com\\/groups\\/Elementors\"},{\"label\":\"Blog\",\"image\":\"https:\\/\\/assets.elementor.com\\/home-screen\\/v1\\/images\\/icon-academic-hat.svg\",\"url\":\"https:\\/\\/elementor.com\\/blog\\/\"}]}\";}','off');
INSERT INTO `wp_79e54b1ec2_options` VALUES ('7521','elementor_atomic_cache_validity-local','a:3:{s:5:\"state\";b:0;s:4:\"meta\";N;s:8:\"children\";a:22:{i:183;a:3:{s:5:\"state\";b:0;s:4:\"meta\";N;s:8:\"children\";a:0:{}}i:237;a:3:{s:5:\"state\";b:0;s:4:\"meta\";N;s:8:\"children\";a:0:{}}i:260;a:3:{s:5:\"state\";b:0;s:4:\"meta\";N;s:8:\"children\";a:0:{}}i:329;a:3:{s:5:\"state\";b:0;s:4:\"meta\";N;s:8:\"children\";a:0:{}}i:331;a:3:{s:5:\"state\";b:0;s:4:\"meta\";N;s:8:\"children\";a:0:{}}i:338;a:3:{s:5:\"state\";b:0;s:4:\"meta\";N;s:8:\"children\";a:0:{}}i:341;a:3:{s:5:\"state\";b:0;s:4:\"meta\";N;s:8:\"children\";a:0:{}}i:344;a:3:{s:5:\"state\";b:0;s:4:\"meta\";N;s:8:\"children\";a:0:{}}i:350;a:3:{s:5:\"state\";b:0;s:4:\"meta\";N;s:8:\"children\";a:0:{}}i:352;a:3:{s:5:\"state\";b:0;s:4:\"meta\";N;s:8:\"children\";a:0:{}}i:355;a:3:{s:5:\"state\";b:0;s:4:\"meta\";N;s:8:\"children\";a:0:{}}i:358;a:3:{s:5:\"state\";b:0;s:4:\"meta\";N;s:8:\"children\";a:0:{}}i:362;a:3:{s:5:\"state\";b:0;s:4:\"meta\";N;s:8:\"children\";a:0:{}}i:364;a:3:{s:5:\"state\";b:1;s:4:\"meta\";N;s:8:\"children\";a:3:{s:7:\"desktop\";a:3:{s:5:\"state\";b:1;s:4:\"meta\";N;s:8:\"children\";a:0:{}}s:6:\"tablet\";a:3:{s:5:\"state\";b:1;s:4:\"meta\";N;s:8:\"children\";a:0:{}}s:6:\"mobile\";a:3:{s:5:\"state\";b:1;s:4:\"meta\";N;s:8:\"children\";a:0:{}}}}i:370;a:3:{s:5:\"state\";b:0;s:4:\"meta\";N;s:8:\"children\";a:0:{}}i:376;a:3:{s:5:\"state\";b:0;s:4:\"meta\";N;s:8:\"children\";a:0:{}}i:224;a:3:{s:5:\"state\";b:0;s:4:\"meta\";N;s:8:\"children\";a:3:{s:7:\"desktop\";a:3:{s:5:\"state\";b:0;s:4:\"meta\";N;s:8:\"children\";a:0:{}}s:6:\"tablet\";a:3:{s:5:\"state\";b:0;s:4:\"meta\";N;s:8:\"children\";a:0:{}}s:6:\"mobile\";a:3:{s:5:\"state\";b:0;s:4:\"meta\";N;s:8:\"children\";a:0:{}}}}i:325;a:3:{s:5:\"state\";b:0;s:4:\"meta\";N;s:8:\"children\";a:0:{}}i:426;a:3:{s:5:\"state\";b:0;s:4:\"meta\";N;s:8:\"children\";a:0:{}}i:605;a:3:{s:5:\"state\";b:0;s:4:\"meta\";N;s:8:\"children\";a:0:{}}i:106;a:3:{s:5:\"state\";b:0;s:4:\"meta\";N;s:8:\"children\";a:0:{}}i:226;a:3:{s:5:\"state\";b:0;s:4:\"meta\";N;s:8:\"children\";a:3:{s:7:\"desktop\";a:3:{s:5:\"state\";b:0;s:4:\"meta\";N;s:8:\"children\";a:0:{}}s:6:\"tablet\";a:3:{s:5:\"state\";b:0;s:4:\"meta\";N;s:8:\"children\";a:0:{}}s:6:\"mobile\";a:3:{s:5:\"state\";b:0;s:4:\"meta\";N;s:8:\"children\";a:0:{}}}}}}','auto');
INSERT INTO `wp_79e54b1ec2_options` VALUES ('7522','elementor_atomic_cache_validity-base','a:3:{s:5:\"state\";b:1;s:4:\"meta\";N;s:8:\"children\";a:3:{s:7:\"desktop\";a:3:{s:5:\"state\";b:1;s:4:\"meta\";N;s:8:\"children\";a:0:{}}s:6:\"tablet\";a:3:{s:5:\"state\";b:1;s:4:\"meta\";N;s:8:\"children\";a:0:{}}s:6:\"mobile\";a:3:{s:5:\"state\";b:1;s:4:\"meta\";N;s:8:\"children\";a:0:{}}}}','auto');
INSERT INTO `wp_79e54b1ec2_options` VALUES ('7523','elementor_atomic_cache_validity-global','a:3:{s:5:\"state\";b:0;s:4:\"meta\";N;s:8:\"children\";a:2:{s:8:\"frontend\";a:3:{s:5:\"state\";b:1;s:4:\"meta\";N;s:8:\"children\";a:3:{s:7:\"desktop\";a:3:{s:5:\"state\";b:1;s:4:\"meta\";N;s:8:\"children\";a:0:{}}s:6:\"tablet\";a:3:{s:5:\"state\";b:1;s:4:\"meta\";N;s:8:\"children\";a:0:{}}s:6:\"mobile\";a:3:{s:5:\"state\";b:1;s:4:\"meta\";N;s:8:\"children\";a:0:{}}}}s:7:\"preview\";a:3:{s:5:\"state\";b:0;s:4:\"meta\";N;s:8:\"children\";a:3:{s:7:\"desktop\";a:3:{s:5:\"state\";b:0;s:4:\"meta\";N;s:8:\"children\";a:0:{}}s:6:\"tablet\";a:3:{s:5:\"state\";b:0;s:4:\"meta\";N;s:8:\"children\";a:0:{}}s:6:\"mobile\";a:3:{s:5:\"state\";b:0;s:4:\"meta\";N;s:8:\"children\";a:0:{}}}}}}','auto');
INSERT INTO `wp_79e54b1ec2_options` VALUES ('8726','wpsec_user_onboarded','completed','auto');
INSERT INTO `wp_79e54b1ec2_options` VALUES ('10942','metform_onboard_options','a:1:{s:8:\"settings\";a:2:{s:8:\"tut_term\";s:11:\"user_agreed\";s:16:\"newsletter_email\";s:0:\"\";}}','auto');
INSERT INTO `wp_79e54b1ec2_options` VALUES ('10943','met_form_onboard_status','onboarded','auto');
INSERT INTO `wp_79e54b1ec2_options` VALUES ('11229','elementor_recreate_kit','','auto');
INSERT INTO `wp_79e54b1ec2_options` VALUES ('11455','elementor_safe_mode','','auto');
INSERT INTO `wp_79e54b1ec2_options` VALUES ('12530','elementor_atomic_styles_fonts-base','a:0:{}','auto');
INSERT INTO `wp_79e54b1ec2_options` VALUES ('12531','elementor_atomic_styles_fonts-global-frontend','a:0:{}','auto');
INSERT INTO `wp_79e54b1ec2_options` VALUES ('12532','elementor_atomic_styles_fonts-local-364','a:0:{}','auto');
INSERT INTO `wp_79e54b1ec2_options` VALUES ('12563','elementor_atomic_styles_fonts-local-224','a:0:{}','auto');
INSERT INTO `wp_79e54b1ec2_options` VALUES ('13389','elementor_atomic_styles_fonts-global-preview','a:0:{}','auto');
INSERT INTO `wp_79e54b1ec2_options` VALUES ('16261','elementor_unfiltered_files_upload','1','auto');
INSERT INTO `wp_79e54b1ec2_options` VALUES ('21545','trustindex-google-active','1','auto');
INSERT INTO `wp_79e54b1ec2_options` VALUES ('21546','trustindex-google-notifications','a:4:{s:23:\"not-using-no-connection\";a:3:{s:9:\"timestamp\";i:1761773383;s:6:\"active\";b:0;s:8:\"do-check\";b:0;}s:7:\"rate-us\";a:2:{s:6:\"active\";b:0;s:9:\"timestamp\";i:1761773383;}s:19:\"not-using-no-widget\";a:2:{s:6:\"active\";b:0;s:9:\"timestamp\";i:1761694221;}s:25:\"review-download-available\";a:2:{s:6:\"active\";b:1;s:8:\"do-check\";b:0;}}','off');
INSERT INTO `wp_79e54b1ec2_options` VALUES ('21548','trustindex-google-version-control','a:3:{s:20:\"update-version-check\";s:6:\"13.2.5\";s:10:\"widget-css\";s:3:\"3.9\";s:11:\"widget-html\";s:3:\"2.6\";}','off');
INSERT INTO `wp_79e54b1ec2_options` VALUES ('21549','trustindex-core-shortcode-inited','13.2.5','off');
INSERT INTO `wp_79e54b1ec2_options` VALUES ('21581','trustindex-google-review-download-request-id','d8896f1144862gec','off');
INSERT INTO `wp_79e54b1ec2_options` VALUES ('21582','trustindex-google-download-timestamp','1762551021','off');
INSERT INTO `wp_79e54b1ec2_options` VALUES ('21583','trustindex-google-review-download-modal','0','off');
INSERT INTO `wp_79e54b1ec2_options` VALUES ('21584','trustindex-google-page-details','a:11:{s:2:\"id\";s:27:\"ChIJU3sv7HNr24gRpPAiSDT4W-c\";s:4:\"name\";s:27:\"\"The GOAT Electric Company\"\";s:10:\"avatar_url\";s:104:\"https://lh4.googleusercontent.com/-HPJy8JneQDo/AAAAAAAAAAI/AAAAAAAAAAA/3RYeca00k7M/s160-c-k-mo/photo.jpg\";s:10:\"review_url\";s:126:\"https://www.google.com/maps/place//data=!4m7!3m6!1s0x88db6b73ec2f7b53:0xe75bf8344822f0a4!8m2!3d26.5935597!4d-81.848716!9m1!1b1\";s:16:\"write_review_url\";s:93:\"https://www.google.com/maps/place//data=!4m3!3m2!1s0x88db6b73ec2f7b53:0xe75bf8344822f0a4!12e1\";s:7:\"address\";s:43:\"10251 Metro Pkwy #122, Fort Myers, FL 33966\";s:13:\"rating_number\";s:2:\"54\";s:14:\"rating_numbers\";a:5:{i:1;i:0;i:2;i:0;i:3;i:0;i:4;i:0;i:5;i:54;}s:19:\"rating_numbers_last\";a:5:{i:1;i:0;i:2;i:0;i:3;i:0;i:4;i:0;i:5;i:11;}s:12:\"rating_score\";s:1:\"5\";s:9:\"timestamp\";i:0;}','off');
INSERT INTO `wp_79e54b1ec2_options` VALUES ('21585','trustindex-google-lang','en','off');
INSERT INTO `wp_79e54b1ec2_options` VALUES ('21622','trustindex-google-style-id','34','off');
INSERT INTO `wp_79e54b1ec2_options` VALUES ('21656','trustindex-google-scss-set','light-background','off');
INSERT INTO `wp_79e54b1ec2_options` VALUES ('21657','trustindex-google-css-content','@charset \"UTF-8\";\n@font-face{font-family:\"Trustindex Poppins\";font-style:italic;font-weight:400;font-display:swap;src:url(\"https://cdn.trustindex.io/assets/fonts/poppins/devanagari-italic.woff2\") format(\"woff2\");unicode-range:U+0900-097F, U+1CD0-1CF9, U+200C-200D, U+20A8, U+20B9, U+20F0, U+25CC, U+A830-A839, U+A8E0-A8FF, U+11B00-11B09}@font-face{font-family:\"Trustindex Poppins\";font-style:italic;font-weight:400;font-display:swap;src:url(\"https://cdn.trustindex.io/assets/fonts/poppins/latin-ext-italic.woff2\") format(\"woff2\");unicode-range:U+0100-02BA, U+02BD-02C5, U+02C7-02CC, U+02CE-02D7, U+02DD-02FF, U+0304, U+0308, U+0329, U+1D00-1DBF, U+1E00-1E9F, U+1EF2-1EFF, U+2020, U+20A0-20AB, U+20AD-20C0, U+2113, U+2C60-2C7F, U+A720-A7FF}@font-face{font-family:\"Trustindex Poppins\";font-style:italic;font-weight:400;font-display:swap;src:url(\"https://cdn.trustindex.io/assets/fonts/poppins/latin-italic.woff2\") format(\"woff2\");unicode-range:U+0000-00FF, U+0131, U+0152-0153, U+02BB-02BC, U+02C6, U+02DA, U+02DC, U+0304, U+0308, U+0329, U+2000-206F, U+20AC, U+2122, U+2191, U+2193, U+2212, U+2215, U+FEFF, U+FFFD}@font-face{font-family:\"Trustindex Poppins\";font-style:italic;font-weight:600;font-display:swap;src:url(\"https://cdn.trustindex.io/assets/fonts/poppins/devanagari-italic-600.woff2\") format(\"woff2\");unicode-range:U+0900-097F, U+1CD0-1CF9, U+200C-200D, U+20A8, U+20B9, U+20F0, U+25CC, U+A830-A839, U+A8E0-A8FF, U+11B00-11B09}@font-face{font-family:\"Trustindex Poppins\";font-style:italic;font-weight:600;font-display:swap;src:url(\"https://cdn.trustindex.io/assets/fonts/poppins/latin-ext-italic-600.woff2\") format(\"woff2\");unicode-range:U+0100-02BA, U+02BD-02C5, U+02C7-02CC, U+02CE-02D7, U+02DD-02FF, U+0304, U+0308, U+0329, U+1D00-1DBF, U+1E00-1E9F, U+1EF2-1EFF, U+2020, U+20A0-20AB, U+20AD-20C0, U+2113, U+2C60-2C7F, U+A720-A7FF}@font-face{font-family:\"Trustindex Poppins\";font-style:italic;font-weight:600;font-display:swap;src:url(\"https://cdn.trustindex.io/assets/fonts/poppins/latin-italic-600.woff2\") format(\"woff2\");unicode-range:U+0000-00FF, U+0131, U+0152-0153, U+02BB-02BC, U+02C6, U+02DA, U+02DC, U+0304, U+0308, U+0329, U+2000-206F, U+20AC, U+2122, U+2191, U+2193, U+2212, U+2215, U+FEFF, U+FFFD}@font-face{font-family:\"Trustindex Poppins\";font-style:normal;font-weight:400;font-display:swap;src:url(\"https://cdn.trustindex.io/assets/fonts/poppins/devanagari.woff2\") format(\"woff2\");unicode-range:U+0900-097F, U+1CD0-1CF9, U+200C-200D, U+20A8, U+20B9, U+20F0, U+25CC, U+A830-A839, U+A8E0-A8FF, U+11B00-11B09}@font-face{font-family:\"Trustindex Poppins\";font-style:normal;font-weight:400;font-display:swap;src:url(\"https://cdn.trustindex.io/assets/fonts/poppins/latin-ext.woff2\") format(\"woff2\");unicode-range:U+0100-02BA, U+02BD-02C5, U+02C7-02CC, U+02CE-02D7, U+02DD-02FF, U+0304, U+0308, U+0329, U+1D00-1DBF, U+1E00-1E9F, U+1EF2-1EFF, U+2020, U+20A0-20AB, U+20AD-20C0, U+2113, U+2C60-2C7F, U+A720-A7FF}@font-face{font-family:\"Trustindex Poppins\";font-style:normal;font-weight:400;font-display:swap;src:url(\"https://cdn.trustindex.io/assets/fonts/poppins/latin.woff2\") format(\"woff2\");unicode-range:U+0000-00FF, U+0131, U+0152-0153, U+02BB-02BC, U+02C6, U+02DA, U+02DC, U+0304, U+0308, U+0329, U+2000-206F, U+20AC, U+2122, U+2191, U+2193, U+2212, U+2215, U+FEFF, U+FFFD}@font-face{font-family:\"Trustindex Poppins\";font-style:normal;font-weight:600;font-display:swap;src:url(\"https://cdn.trustindex.io/assets/fonts/poppins/devanagari-600.woff2\") format(\"woff2\");unicode-range:U+0900-097F, U+1CD0-1CF9, U+200C-200D, U+20A8, U+20B9, U+20F0, U+25CC, U+A830-A839, U+A8E0-A8FF, U+11B00-11B09}@font-face{font-family:\"Trustindex Poppins\";font-style:normal;font-weight:600;font-display:swap;src:url(\"https://cdn.trustindex.io/assets/fonts/poppins/latin-ext-600.woff2\") format(\"woff2\");unicode-range:U+0100-02BA, U+02BD-02C5, U+02C7-02CC, U+02CE-02D7, U+02DD-02FF, U+0304, U+0308, U+0329, U+1D00-1DBF, U+1E00-1E9F, U+1EF2-1EFF, U+2020, U+20A0-20AB, U+20AD-20C0, U+2113, U+2C60-2C7F, U+A720-A7FF}@font-face{font-family:\"Trustindex Poppins\";font-style:normal;font-weight:600;font-display:swap;src:url(\"https://cdn.trustindex.io/assets/fonts/poppins/latin-600.woff2\") format(\"woff2\");unicode-range:U+0000-00FF, U+0131, U+0152-0153, U+02BB-02BC, U+02C6, U+02DA, U+02DC, U+0304, U+0308, U+0329, U+2000-206F, U+20AC, U+2122, U+2191, U+2193, U+2212, U+2215, U+FEFF, U+FFFD}.ti-amp-iframe-body{background:#ffffff}.ti-widget.ti-goog{width:100%;display:block;overflow:hidden;text-align:left;direction:ltr;box-sizing:border-box;font-family:unset}.ti-widget.ti-goog font{pointer-events:none}.ti-widget.ti-goog script{display:none !important}.ti-widget.ti-goog img{box-shadow:unset !important}.ti-widget.ti-goog *,.ti-widget.ti-goog *:after{box-sizing:border-box}.ti-widget.ti-goog *:before,.ti-widget.ti-goog *:after{-webkit-box-ordinal-group:1 !important;content:unset}.ti-widget.ti-goog:before{display:none !important}.ti-widget.ti-goog img{padding:0 !important;margin:0 !important;min-width:initial !important;max-width:initial !important;border:0 !important;border-radius:0 !important}.ti-widget.ti-goog a{text-decoration:underline !important;color:inherit}.ti-widget.ti-goog a.ti-header{text-decoration:none !important}.ti-widget.ti-goog a[href=\"#\"]:not(.ti-show-original-text),.ti-widget.ti-goog a:not([href]):not(.ti-show-original-text){text-decoration:none !important;pointer-events:none}.ti-widget.ti-goog .ti-widget-container,.ti-widget.ti-goog .ti-widget-container *{font-family:\"Trustindex Poppins\";font-size:14px;line-height:1.4em;-webkit-box-sizing:border-box;-moz-box-sizing:border-box;box-sizing:border-box;row-gap:unset !important;column-gap:unset !important}.ti-widget.ti-goog strong,.ti-widget.ti-goog strong *{font-weight:600}.ti-widget.ti-goog .ti-tooltip,.ti-widget.ti-goog .ti-verified-tooltip{color:white !important;background-color:black !important;text-align:left;padding:5px 10px;border-radius:6px;font-size:13px !important;font-weight:400;display:inline-block !important;position:absolute;top:-5px;white-space:nowrap;z-index:3;opacity:0;visibility:hidden;transition:opacity 0.3s ease-in-out;width:max-content;box-shadow:0 4px 12px rgba(0, 0, 0, 0.33);--ti-border-arrow-color: black;margin:unset;bottom:unset;left:unset;right:calc(100% + 10px);margin-right:30px}.ti-widget.ti-goog .ti-tooltip:before,.ti-widget.ti-goog .ti-verified-tooltip:before{width:0;height:0;border-style:solid;content:\"\" !important;position:absolute;top:50%;margin-top:-7px}.ti-widget.ti-goog .ti-tooltip:before,.ti-widget.ti-goog .ti-verified-tooltip:before{left:unset;right:-7px;border-width:7px 0 7px 7px;border-color:transparent transparent transparent var(--ti-border-arrow-color)}.ti-widget.ti-goog .ti-with-tooltip,.ti-widget.ti-goog .ti-verified-review{position:relative;font-size:inherit}.ti-widget.ti-goog .ti-with-tooltip:hover .ti-tooltip,.ti-widget.ti-goog .ti-with-tooltip:hover .ti-verified-tooltip,.ti-widget.ti-goog .ti-verified-review:hover .ti-tooltip,.ti-widget.ti-goog .ti-verified-review:hover .ti-verified-tooltip{opacity:1;margin:0;visibility:visible}.ti-widget.ti-goog .ti-verified-tooltip{margin:unset;right:unset;left:calc(100% + 10px);margin-left:30px}.ti-widget.ti-goog .ti-verified-tooltip:before{right:unset;left:-7px;border-width:7px 7px 7px 0;border-color:transparent var(--ti-border-arrow-color) transparent transparent}.ti-widget.ti-goog .ti-verified-platform .ti-verified-tooltip{width:175px;max-width:250px;white-space:normal;line-height:1.4 !important;top:-10px}.ti-widget.ti-goog .ti-verified-platform .ti-verified-tooltip:before{top:18px}.ti-widget.ti-goog .ti-date .ti-tooltip{margin:unset;top:unset;right:unset;left:calc(50% + 20px);transform:translateX(-50%);margin-bottom:30px;bottom:calc(100% + 10px)}.ti-widget.ti-goog .ti-date .ti-tooltip:before{top:unset;right:unset;margin:unset;left:50%;margin-left:-25px;bottom:-7px;border-width:7px 7px 0 7px;border-color:var(--ti-border-arrow-color) transparent transparent transparent}.ti-widget.ti-goog[data-set-id^=\"dark-\"] .ti-tooltip,.ti-widget.ti-goog[data-set-id^=\"dark-\"] .ti-verified-tooltip,.ti-widget.ti-goog[data-set-id=\"light-contrast\"] .ti-tooltip,.ti-widget.ti-goog[data-set-id=\"light-contrast\"] .ti-verified-tooltip{color:black !important;background-color:white !important;--ti-border-arrow-color: white}.ti-widget.ti-goog .ti-widget-container{display:block;color:#000000;margin-bottom:15px}.ti-widget.ti-goog .ti-widget-container .ti-name{font-weight:600;font-size:15px;overflow:hidden;padding-right:25px;white-space:nowrap;text-overflow:ellipsis;color:#000000}.ti-widget.ti-goog .ti-widget-container .ti-name a{text-decoration:none !important;font-size:inherit}.ti-widget.ti-goog .ti-widget-container .ti-name a:hover{text-decoration:underline !important}.ti-widget.ti-goog .ti-widget-container .ti-date{color:#767676;font-size:13px}.ti-widget.ti-goog .ti-widget-container .ti-date .ti-tooltip{bottom:calc(100% + 8px)}.ti-widget.ti-goog .ti-profile-img{margin:0 15px 0 0 !important}.ti-widget.ti-goog .ti-profile-img img{width:40px !important;height:40px !important;display:block;border-radius:30px !important;object-fit:cover;object-position:top}.ti-widget.ti-goog .ti-profile-img .ti-profile-img-sprite{display:inline-block;float:left;background:white;background-repeat:no-repeat;width:40px;height:40px;border-radius:30px}.ti-widget.ti-goog .ti-profile-details{-webkit-box-flex:1;-ms-flex:1;flex:1;white-space:nowrap;text-overflow:ellipsis;text-align:left;margin:0 !important;display:flex;flex-direction:column;justify-content:center;min-width:0}.ti-widget.ti-goog .ti-stars{margin-top:3px;white-space:nowrap;display:block}.ti-widget.ti-goog .ti-star{width:17px !important;height:17px !important;margin-right:1px !important;vertical-align:unset;display:inline-block !important}.ti-widget.ti-goog img.ti-star{background:none !important}.ti-widget.ti-goog .ti-header,.ti-widget.ti-goog .ti-popup-header{display:-ms-flexbox;display:flex;-ms-flex-wrap:nowrap;flex-wrap:nowrap}.ti-widget.ti-goog .ti-header .ti-name,.ti-widget.ti-goog .ti-popup-header .ti-name{font-size:16px;overflow:visible;text-overflow:initial;white-space:normal;margin-top:0px;margin-top:-3px;padding-right:0px;margin-bottom:5px;color:#000000 !important}.ti-widget.ti-goog .ti-header .ti-star,.ti-widget.ti-goog .ti-popup-header .ti-star{width:20px !important;height:20px !important}.ti-widget.ti-goog .ti-header .ti-star.ti-rating,.ti-widget.ti-goog .ti-popup-header .ti-star.ti-rating{color:#728ec2;font-weight:600;display:inline-block;padding-right:5px;position:relative;font-size:16px;top:-2px}.ti-widget.ti-goog .ti-header .ti-profile-img img,.ti-widget.ti-goog .ti-header .ti-profile-img .ti-profile-img-sprite,.ti-widget.ti-goog .ti-popup-header .ti-profile-img img,.ti-widget.ti-goog .ti-popup-header .ti-profile-img .ti-profile-img-sprite{width:65px !important;height:65px !important;border-radius:4px !important}.ti-widget.ti-goog .ti-header .ti-profile-img img,.ti-widget.ti-goog .ti-popup-header .ti-profile-img img{object-fit:contain}.ti-widget.ti-goog .ti-header .ti-profile-details,.ti-widget.ti-goog .ti-popup-header .ti-profile-details{padding-top:6px}.ti-widget.ti-goog .ti-header .ti-stars,.ti-widget.ti-goog .ti-popup-header .ti-stars{margin-top:2px;line-height:0}.ti-widget.ti-goog .ti-fade-container{grid-row:1;grid-column:1;-ms-flex-wrap:inherit;flex-wrap:inherit;-ms-flex-pack:inherit;justify-content:inherit;flex-direction:inherit;text-align:inherit;display:none;opacity:0;transition:opacity 1s}.ti-widget.ti-goog .ti-fade-container:nth-child(1){display:flex;opacity:1}.ti-widget.ti-goog .ti-header-grid,.ti-widget.ti-goog .ti-footer-grid{display:grid}.ti-widget.ti-goog .ti-footer-filter-text{font-size:15px !important;color:#000000;margin-bottom:0 !important;padding:0 15px;text-align:left;margin:15px 0}.ti-widget.ti-goog .ti-footer-filter-text:empty{margin:0 !important}.ti-widget.ti-goog .ti-disclaimer{visibility:hidden;opacity:0;padding:12px 24px;position:absolute;bottom:100%;width:100%;min-width:220px;max-width:585px;background:white;border:1px solid black;border-radius:6px;box-shadow:0 4px 15px rgba(0, 0, 0, 0.05);font-size:14px;font-weight:normal;margin-bottom:15px;text-align:left;z-index:2147483647;color:#000000 !important;transition:all 0.3s;transition-delay:0.35s;white-space:normal !important;right:unset ;left:50% ;transform:translateX(-50%) }.ti-widget.ti-goog .ti-disclaimer:before,.ti-widget.ti-goog .ti-disclaimer:after{left:0 ;right:0 }.ti-widget.ti-goog .ti-disclaimer a{font-size:inherit}.ti-widget.ti-goog .ti-disclaimer:hover{visibility:visible;opacity:1}.ti-widget.ti-goog:not([data-layout-category*=\"top-rated-badge\"]) .ti-disclaimer:before,.ti-widget.ti-goog:not([data-layout-category*=\"top-rated-badge\"]) .ti-disclaimer:after{position:absolute;content:\"\";bottom:-18px;margin:0 auto;width:0;border-style:solid;border-right:20px solid transparent;border-left:20px solid transparent;border-bottom:20px solid black;border-top:0;transform:rotate(45deg)}.ti-widget.ti-goog:not([data-layout-category*=\"top-rated-badge\"]) .ti-disclaimer:after{bottom:-16px;margin-right:1px;border-bottom-color:white}.ti-widget.ti-goog[data-layout-category*=\"top-rated-badge\"] .ti-disclaimer:after{position:absolute;content:\"\";bottom:-10px;margin:0 auto;width:0;border:10px solid transparent;border-bottom-width:0;border-top-color:#000}.ti-widget.ti-goog[data-layout-category*=\"top-rated-badge\"] .ti-disclaimer.ti-bottom{bottom:unset;margin-bottom:unset;top:100%;margin-top:15px}.ti-widget.ti-goog[data-layout-category*=\"top-rated-badge\"] .ti-disclaimer.ti-bottom:after{bottom:unset;top:-10px;border:10px solid transparent;border-top-width:0;border-bottom-color:#000}.ti-widget.ti-goog .ti-verified-by{display:inline-block}.ti-widget.ti-goog .ti-verified-by .ti-info-icon{display:inline-block;background-size:contain;width:13px;height:13px;position:relative;top:2px;-webkit-mask-image:url(\"https://cdn.trustindex.io/assets/icon/ti-info-light.svg\");mask-image:url(\"https://cdn.trustindex.io/assets/icon/ti-info-light.svg\");-webkit-mask-repeat:no-repeat;mask-repeat:no-repeat;background-color:#000000}.ti-widget.ti-goog .ti-verified-by-row{display:block;text-align:right;margin-bottom:0 !important;font-size:12px;color:#000000;margin:12px 28px}.ti-widget.ti-goog .ti-verified-by-row>.ti-inner{display:inline-block;position:relative;padding:4px 14px;font-size:12px;font-weight:600;border-radius:3px}.ti-widget.ti-goog .ti-verified-by-row .ti-info-icon{-webkit-mask-image:url(\"https://cdn.trustindex.io/assets/icon/ti-info-regular.svg\");mask-image:url(\"https://cdn.trustindex.io/assets/icon/ti-info-regular.svg\")}.ti-widget.ti-goog .ti-verified-by-row .ti-trustindex-icon{display:inline-block;width:15px;height:15px;vertical-align:unset;position:relative;top:2px;background-image:url(\"https://cdn.trustindex.io/assets/platform/Trustindex/icon.svg\");margin-left:4px;margin-right:3px}.ti-widget.ti-goog .ti-verified-by-row .ti-disclaimer{width:320px !important;left:unset ;transform:unset ;right:-7px }.ti-widget.ti-goog .ti-verified-by-row .ti-disclaimer:after,.ti-widget.ti-goog .ti-verified-by-row .ti-disclaimer:before{left:unset ;right:15px }.ti-widget.ti-goog .ti-verified-by-row[data-style=\"1\"]>.ti-inner{background-color:#157351;color:white}.ti-widget.ti-goog .ti-verified-by-row[data-style=\"1\"] .ti-info-icon{background-color:white !important}.ti-widget.ti-goog .ti-verified-by-row[data-style=\"2\"]>.ti-inner{background-color:#D6F3E6;color:black}.ti-widget.ti-goog .ti-verified-by-row[data-style=\"2\"] .ti-info-icon{background-color:black !important}.ti-widget.ti-goog .ti-verified-by:hover+.ti-disclaimer,.ti-widget.ti-goog .ti-verified-by .ti-inner:hover .ti-disclaimer{visibility:visible;transition-delay:0.1ms;opacity:1}.ti-widget.ti-goog .ti-footer-filter-text+.ti-verified-by-row{margin-top:-20px !important}.ti-widget.ti-goog .ti-footer+.ti-verified-by-row{text-align:center}.ti-widget.ti-goog .ti-footer+.ti-verified-by-row .ti-disclaimer{right:unset  !important;left:50%  !important;transform:translateX(-50%)  !important}.ti-widget.ti-goog .ti-footer+.ti-verified-by-row .ti-disclaimer:before,.ti-widget.ti-goog .ti-footer+.ti-verified-by-row .ti-disclaimer:after{left:0  !important;right:0  !important}.ti-widget.ti-goog .ti-footer+.ti-verified-by-row .ti-disclaimer:after{margin-right:auto  !important;right:2px  !important}@media (max-width:479px){.ti-widget.ti-goog .ti-verified-by-row{text-align:center !important}.ti-widget.ti-goog .ti-verified-by-row .ti-disclaimer{right:unset ;left:50% ;transform:translateX(-50%) }.ti-widget.ti-goog .ti-verified-by-row .ti-disclaimer:before,.ti-widget.ti-goog .ti-verified-by-row .ti-disclaimer:after{left:0 ;right:0 }.ti-widget.ti-goog .ti-verified-by-row .ti-disclaimer:after{margin-right:auto ;right:2px }.ti-widget.ti-goog .ti-footer-filter-text+.ti-verified-by-row{margin-top:12px !important}}@media (max-width:479px){.ti-widget.ti-goog .ti-footer-filter-text{text-align:center !important}}@media (min-width:1024px){.ti-widget.ti-goog .ti-footer-filter-text{margin:12px 28px}}.ti-widget.ti-goog .star-lg .ti-star{width:30px !important;height:30px !important}.ti-widget.ti-goog .ti-d-none{display:none !important}.ti-widget.ti-goog .ti-rating-text,.ti-widget.ti-goog .ti-rating-text strong:not(.ti-rating-large),.ti-widget.ti-goog .ti-rating-text strong a,.ti-widget.ti-goog .ti-rating-text strong span,.ti-widget.ti-goog .ti-rating-text span strong,.ti-widget.ti-goog .ti-rating-text span,.ti-widget.ti-goog .ti-footer,.ti-widget.ti-goog .ti-footer strong:not(.ti-rating-large),.ti-widget.ti-goog .ti-footer span,.ti-widget.ti-goog .ti-footer strong a{font-size:15px;color:#000000}.ti-widget.ti-goog .ti-large-logo{display:-ms-flexbox;display:flex;-ms-flex-wrap:wrap;flex-wrap:wrap;margin-bottom:0 !important}.ti-widget.ti-goog .ti-large-logo .ti-v-center{-ms-flex-item-align:center !important;align-self:center !important;text-align:center;-ms-flex-preferred-size:0;flex-basis:0;-ms-flex-positive:1;flex-grow:1;max-width:100%}.ti-widget.ti-goog .ti-large-logo img{margin:auto !important;display:block !important;position:relative;width:150px !important;height:32px !important;object-fit:unset !important}.ti-widget.ti-goog .nowrap{white-space:nowrap;display:inline-block;margin:0 2px}.ti-widget.ti-goog .nowrap:first-of-type{margin-left:0}.ti-widget.ti-goog .nowrap:last-of-type{margin-right:0}.ti-widget.ti-goog .ti-reviews-container-wrapper .ti-inner>.ti-stars,.ti-widget.ti-goog .ti-reviews-container-wrapper .ti-popup-inner>.ti-stars{margin-bottom:11px;margin-top:11px;text-align:left}.ti-widget.ti-goog .ti-reviews-container-wrapper{overflow:hidden;display:-ms-flexbox;display:flex;-ms-flex-wrap:nowrap;flex-wrap:nowrap;margin:0 -8px;padding-top:5px}.ti-disable-animation.ti-widget.ti-goog .ti-reviews-container-wrapper{padding-top:0 !important}@media (min-width:1024px){.ti-widget.ti-goog .ti-reviews-container-wrapper{margin:0 8px !important}}.ti-widget.ti-goog .ti-col-1 .ti-review-item{-ms-flex:0 0 100%;flex:0 0 100%;max-width:100%}.ti-widget.ti-goog .ti-col-2 .ti-review-item{-ms-flex:0 0 50%;flex:0 0 50%;max-width:50%}.ti-widget.ti-goog .ti-col-3 .ti-review-item{-ms-flex:0 0 33.333%;flex:0 0 33.333%;max-width:33.333%}.ti-widget.ti-goog .ti-col-4 .ti-review-item{-ms-flex:0 0 25%;flex:0 0 25%;max-width:25%}.ti-widget.ti-goog .ti-col-5 .ti-review-item{-ms-flex:0 0 20%;flex:0 0 20%;max-width:20%}.ti-widget.ti-goog .ti-col-6 .ti-review-item{-ms-flex:0 0 16.666%;flex:0 0 16.666%;max-width:16.666%}.ti-widget.ti-goog .ti-col-7 .ti-review-item{-ms-flex:0 0 14.286%;flex:0 0 14.286%;max-width:14.286%}.ti-widget.ti-goog .ti-col-8 .ti-review-item{-ms-flex:0 0 12.5%;flex:0 0 12.5%;max-width:12.5%}.ti-widget.ti-goog .ti-col-9 .ti-review-item{-ms-flex:0 0 11.111%;flex:0 0 11.111%;max-width:11.111%}.ti-widget.ti-goog .ti-col-10 .ti-review-item{-ms-flex:0 0 10%;flex:0 0 10%;max-width:10%}.ti-widget.ti-goog .ti-reviews-container{position:relative;display:block;touch-action:pan-y}.ti-widget.ti-goog .ti-read-more{display:block;padding:8px 0 0;text-align:left;position:relative}.ti-widget.ti-goog .ti-read-more span{display:inline-block;font-weight:400;white-space:nowrap;font-size:13.5px;color:#000000;opacity:0.5;text-decoration:none !important;transition:color 300ms ease-out;cursor:pointer}.ti-widget.ti-goog .ti-read-more span:hover{opacity:1;text-decoration:underline !important}.ti-widget.ti-goog .ti-read-more:after{content:\"\";position:absolute;right:0;top:calc(50% + 3px);transform:translateY(-50%);width:25px;height:25px;-webkit-mask-size:contain;mask-size:contain;-webkit-mask-position:center;mask-position:center;-webkit-mask-repeat:no-repeat;mask-repeat:no-repeat;mask-image:url(https://cdn.trustindex.io/assets/icon/ti-quote.svg);-webkit-mask-image:url(https://cdn.trustindex.io/assets/icon/ti-quote.svg);background:#d9d9d9;display:none}.ti-widget.ti-goog .ti-review-item{padding:0 8px;transition:transform 300ms ease-out}.ti-widget.ti-goog .ti-review-item .ti-inner{border-radius:4px}.ti-widget.ti-goog .ti-review-item>.ti-inner{border-style:solid !important;border-color:#f4f4f4 !important;border-radius:12px !important;padding:20px !important;margin:0 !important;display:block;position:relative;background-color:#f4f4f4;background-image:none}.ti-widget.ti-goog .ti-review-item .ti-polarity-icon{position:relative;text-indent:3px;display:inline-block;width:15px !important;height:15px !important;vertical-align:unset}.ti-widget.ti-goog .ti-review-item .ti-recommendation{display:inline-block;height:15px;line-height:15px}.ti-widget.ti-goog .ti-review-item .ti-recommendation .ti-recommendation-icon{position:relative;margin:0 5px !important;margin-bottom:-3px !important;text-indent:3px;display:inline-block;width:15px !important;height:15px !important;vertical-align:unset}.ti-widget.ti-goog .ti-review-item .ti-recommendation .ti-recommendation-icon:first-child{margin-left:0 !important}.ti-widget.ti-goog .ti-review-item .ti-recommendation .ti-recommendation-title{font-weight:600;font-size:13px !important;opacity:0.8;position:relative;top:-1px}.ti-widget.ti-goog .ti-review-item .ti-recommendation+.ti-dummy-stars{display:none}.ti-widget.ti-goog .ti-review-item .ti-stars{height:17px;line-height:17px}.ti-widget.ti-goog .ti-review-item .ti-review-image{width:80px;height:80px;border-radius:12px;margin-left:12px;margin-bottom:4px;margin-top:2px;position:relative;cursor:pointer;overflow:hidden}.ti-widget.ti-goog .ti-review-item .ti-review-image img{position:absolute;object-fit:cover;width:100% !important;height:100% !important;max-width:100% !important;max-height:100% !important;border-radius:inherit !important;left:0;top:0;transition:all 0.3s ease-in-out;pointer-events:none}.ti-widget.ti-goog .ti-review-item .ti-review-image .ti-more-image-count{position:absolute;width:100%;height:100%;left:0;top:0;display:flex;align-items:center;justify-content:center;color:white;background-color:rgba(0, 0, 0, 0.4);font-size:18px;border-radius:inherit;opacity:0;pointer-events:none;transition:all 0.2s ease-in-out;font-weight:600;transform:scale(0.85);z-index:2}.ti-widget.ti-goog .ti-review-item .ti-review-image:hover img{transform:scale(1.1)}.ti-widget.ti-goog .ti-review-item .ti-review-image:hover.ti-has-more-image .ti-more-image-count{opacity:1;transform:scale(1)}.ti-widget.ti-goog .ti-review-item .ti-review-image-container{display:flex;flex-wrap:nowrap;margin:0 -4px;margin-top:15px;max-height:100px;transition:all 500ms ease-in-out}.ti-widget.ti-goog .ti-review-item .ti-review-image-container .ti-review-image{float:unset !important;margin:0 !important;width:25%;height:unset;flex:0 0 auto;padding:0 4px}.ti-widget.ti-goog .ti-review-item .ti-review-image-container .ti-review-image .ti-review-image-inner{display:block;position:relative;width:100%;height:0;padding-bottom:100%;border-radius:inherit;overflow:hidden;pointer-events:none}.ti-widget.ti-goog .ti-review-item .ti-review-image-container .ti-review-image.ti-has-more-image .ti-more-image-count{opacity:1;transform:scale(1)}.ti-widget.ti-goog .ti-review-item.ti-hidden-review .ti-review-image-container{max-height:0;margin-top:0;transition-delay:500ms}.ti-widget.ti-goog .ti-review-content{-webkit-box-orient:vertical;line-height:21.75px;height:87px;font-size:15px;text-align:left;transition:height 0.5s;font-style:normal;display:-webkit-box;-webkit-line-clamp:4;overflow:hidden !important;padding-right:0}.ti-widget.ti-goog .ti-review-content .ti-review-image{float:right}.ti-widget.ti-goog .ti-review-content.ti-empty-text .ti-review-image{float:unset !important;margin:unset !important;display:inline-block !important}.ti-text-align-right.ti-widget.ti-goog .ti-review-content .ti-review-image{float:left;margin-left:unset;margin-right:12px}.ti-ios-fallback.ti-widget.ti-goog .ti-review-content{display:block}.ti-widget.ti-goog .ti-review-content .ti-show-original-text{font-size:inherit !important}.ti-review-text-mode-scroll.ti-widget.ti-goog .ti-review-content{-webkit-line-clamp:inherit;overflow:auto !important;overflow-x:hidden !important;padding-right:10px}.ti-text-align-right.ti-widget.ti-goog .ti-review-content{text-align:right !important}.ti-text-align-center.ti-widget.ti-goog .ti-review-content{text-align:center !important}.ti-text-align-justify.ti-widget.ti-goog .ti-review-content{text-align:justify !important}.ti-widget.ti-goog .ti-review-content .ti-stars{margin-bottom:5px}.ti-widget.ti-goog .ti-review-content strong{font-size:inherit;color:inherit;font-weight:normal !important}.ti-widget.ti-goog .ti-review-content .ti-reply-by-owner-title{font-weight:600 !important}.ti-widget.ti-goog .ti-review-content .ti-reply-by-owner-title:before{content:\"↪ \"}.ti-widget.ti-goog .ti-review-header{display:-ms-flexbox;display:flex;-ms-flex-wrap:nowrap;flex-wrap:nowrap;position:relative}.ti-widget.ti-goog .ti-highlight{padding:1px 2px;margin:0;box-decoration-break:clone;-webkit-box-decoration-break:clone;border-radius:1px;-webkit-border-radius:1px;-moz-border-radius:1px;background-color:transparent !important;background-image:linear-gradient(#fbe049, #fbe049);background-size:100% 19px;background-position:bottom;background-repeat:no-repeat;color:#000 !important;font-size:inherit !important}@media (min-width:480px){.ti-widget.ti-goog .ti-review-item:hover{-webkit-transform:translate(0, -5px);-ms-transform:translate(0, -5px);transform:translate(0, -5px)}}.ti-widget.ti-goog .ti-ai-summary-item{color:#000000}.ti-widget.ti-goog .ti-ai-summary-item .ti-review-content{-webkit-line-clamp:5;margin-top:16.25px;height:110.75px !important}.ti-widget.ti-goog .ti-ai-summary-item .ti-review-content .ti-summary-list{margin-bottom:0;padding-left:0;list-style:none;font-size:inherit;pointer-events:none}.ti-widget.ti-goog .ti-ai-summary-item .ti-review-content .ti-summary-list li{list-style:inherit;margin-bottom:0;padding-left:20px;position:relative;font-size:inherit}.ti-widget.ti-goog .ti-ai-summary-item .ti-review-content .ti-summary-list li:last-child{margin-bottom:0}.ti-widget.ti-goog .ti-ai-summary-item .ti-review-content .ti-summary-list li:before{display:block;content:\"\";width:10px;height:5px;border-left:solid 2px #000000;border-bottom:solid 2px #000000;transform:rotate(-45deg);position:absolute;left:0;top:7.5px}.ti-widget.ti-goog .ti-ai-summary-item .ti-profile-img{margin-right:13px !important}.ti-widget.ti-goog .ti-ai-summary-item .ti-profile-img img:not(.ti-ai-profile-img){display:inline-block;vertical-align:middle;border:2px solid #f4f4f4}.ti-widget.ti-goog .ti-ai-summary-item .ti-profile-img img:not(.ti-ai-profile-img):not(:first-child){margin-left:-12px !important}.ti-widget.ti-goog .ti-ai-summary-item .ti-profile-details .ti-name{padding-right:0}.ti-widget.ti-goog .ti-ai-summary-item>.ti-inner{background-color:#f4f4f4 !important;background-image:none}.ti-widget.ti-goog .ti-ai-summary-item .ti-profile-img img:not(.ti-ai-profile-img){border-color:#f4f4f4}.ti-widget.ti-goog .ti-ai-summary-item .ti-name,.ti-widget.ti-goog .ti-ai-summary-item .ti-date,.ti-widget.ti-goog .ti-ai-summary-item .ti-read-more span{color:#000000}.ti-widget.ti-goog .ti-ten-rating-score{display:inline-block;font-weight:600;font-size:15px;color:#000000;margin-left:7px;height:100%;line-height:17px;vertical-align:top}.ti-widget.ti-goog .ti-platform-icon{width:20px !important;height:20px !important;position:absolute;top:0;right:0}.ti-widget.ti-goog.ti-custom-stars [class*=\"source-\"] .ti-star.e,.ti-widget.ti-goog.ti-custom-stars [class*=\"source-\"] .ti-star.f{background-image:none}.ti-widget.ti-goog.ti-custom-stars .ti-star{-webkit-mask-size:contain;mask-size:contain;-webkit-mask-position:center;mask-position:center;-webkit-mask-repeat:no-repeat;mask-repeat:no-repeat;mask-image:url(https://cdn.trustindex.io/assets/platform/Trustindex/star/s.svg);-webkit-mask-image:url(https://cdn.trustindex.io/assets/platform/Trustindex/star/s.svg)}.ti-widget.ti-goog.ti-custom-stars .ti-star:not(.e):not(.h){background:#f6bb06}.ti-widget.ti-goog.ti-custom-stars .ti-star.h{background:#f6bb06;background:-webkit-linear-gradient(90deg, #f6bb06 50%, #cccccc 50%) !important;background:linear-gradient(90deg, #f6bb06 50%, #cccccc 50%) !important}.ti-widget.ti-goog.ti-custom-stars .ti-star.e{background:#ccc !important}.ti-widget.ti-goog[data-language=\"ar\"] .ti-name,.ti-widget.ti-goog[data-language=\"ar\"] .ti-date,.ti-widget.ti-goog[data-language=\"ar\"] .ti-profile-details .ti-text,.ti-widget.ti-goog[data-language=\"ar\"] .ti-review-content,.ti-widget.ti-goog[data-language=\"ar\"] .ti-review-text,.ti-widget.ti-goog[data-language=\"ar\"] .ti-read-more,.ti-widget.ti-goog[data-language=\"ar\"] .ti-footer,.ti-widget.ti-goog[data-language=\"ar\"] .ti-rating-text,.ti-widget.ti-goog[data-language=\"ar\"] .ti-footer-filter-text,.ti-widget.ti-goog[data-language=\"ar\"] .ti-header-write-btn,.ti-widget.ti-goog[data-language=\"ar\"] .ti-widget-header .ti-tab-item[data-source=\"all\"] .ti-item-label,.ti-widget.ti-goog[data-language=\"ar\"] .ti-header-rating-text,.ti-widget.ti-goog[data-language=\"ar\"] .ti-rating-name,.ti-widget.ti-goog[data-language=\"ar\"] .ti-header .ti-text,.ti-widget.ti-goog[data-language=\"ar\"] .ti-load-more-reviews-button,.ti-widget.ti-goog[data-language=\"he\"] .ti-name,.ti-widget.ti-goog[data-language=\"he\"] .ti-date,.ti-widget.ti-goog[data-language=\"he\"] .ti-profile-details .ti-text,.ti-widget.ti-goog[data-language=\"he\"] .ti-review-content,.ti-widget.ti-goog[data-language=\"he\"] .ti-review-text,.ti-widget.ti-goog[data-language=\"he\"] .ti-read-more,.ti-widget.ti-goog[data-language=\"he\"] .ti-footer,.ti-widget.ti-goog[data-language=\"he\"] .ti-rating-text,.ti-widget.ti-goog[data-language=\"he\"] .ti-footer-filter-text,.ti-widget.ti-goog[data-language=\"he\"] .ti-header-write-btn,.ti-widget.ti-goog[data-language=\"he\"] .ti-widget-header .ti-tab-item[data-source=\"all\"] .ti-item-label,.ti-widget.ti-goog[data-language=\"he\"] .ti-header-rating-text,.ti-widget.ti-goog[data-language=\"he\"] .ti-rating-name,.ti-widget.ti-goog[data-language=\"he\"] .ti-header .ti-text,.ti-widget.ti-goog[data-language=\"he\"] .ti-load-more-reviews-button,.ti-widget.ti-goog[data-language=\"fa\"] .ti-name,.ti-widget.ti-goog[data-language=\"fa\"] .ti-date,.ti-widget.ti-goog[data-language=\"fa\"] .ti-profile-details .ti-text,.ti-widget.ti-goog[data-language=\"fa\"] .ti-review-content,.ti-widget.ti-goog[data-language=\"fa\"] .ti-review-text,.ti-widget.ti-goog[data-language=\"fa\"] .ti-read-more,.ti-widget.ti-goog[data-language=\"fa\"] .ti-footer,.ti-widget.ti-goog[data-language=\"fa\"] .ti-rating-text,.ti-widget.ti-goog[data-language=\"fa\"] .ti-footer-filter-text,.ti-widget.ti-goog[data-language=\"fa\"] .ti-header-write-btn,.ti-widget.ti-goog[data-language=\"fa\"] .ti-widget-header .ti-tab-item[data-source=\"all\"] .ti-item-label,.ti-widget.ti-goog[data-language=\"fa\"] .ti-header-rating-text,.ti-widget.ti-goog[data-language=\"fa\"] .ti-rating-name,.ti-widget.ti-goog[data-language=\"fa\"] .ti-header .ti-text,.ti-widget.ti-goog[data-language=\"fa\"] .ti-load-more-reviews-button{direction:rtl}.ti-widget.ti-goog[data-language=\"ar\"] .ti-stars,.ti-widget.ti-goog[data-language=\"ar\"] .ti-footer .ti-row,.ti-widget.ti-goog[data-language=\"he\"] .ti-stars,.ti-widget.ti-goog[data-language=\"he\"] .ti-footer .ti-row,.ti-widget.ti-goog[data-language=\"fa\"] .ti-stars,.ti-widget.ti-goog[data-language=\"fa\"] .ti-footer .ti-row{direction:ltr}.ti-widget.ti-goog[data-language=\"ar\"] .ti-date .ti-tooltip,.ti-widget.ti-goog[data-language=\"he\"] .ti-date .ti-tooltip,.ti-widget.ti-goog[data-language=\"fa\"] .ti-date .ti-tooltip{right:unset}.ti-widget.ti-goog .ti-verified-review{display:inline-block;background:url(\"https://cdn.trustindex.io/assets/icon/ti-verified.svg\");background-size:contain;width:15px;height:15px;margin:0 !important;margin-left:7px !important;position:relative;z-index:2}.ti-widget.ti-goog .ti-verified-review:only-child{margin-left:0 !important}.ti-widget.ti-goog .ti-verified-review.ti-color-green{background:url(\"https://cdn.trustindex.io/assets/icon/ti-verified-green.svg\")}.ti-widget.ti-goog .ti-verified-review.ti-color-black{background:url(\"https://cdn.trustindex.io/assets/icon/ti-verified-black.svg\")}.ti-widget.ti-goog .ti-recommendation+.ti-verified-review{top:2px}.ti-widget.ti-goog .ti-ten-rating-score+.ti-verified-review{top:-1px}.ti-widget.ti-goog.ti-disable-nav .ti-controls{display:none !important}.ti-widget.ti-goog.ti-disable-nav .ti-footer-filter-text{margin:15px 0}.ti-widget.ti-goog.ti-disable-nav .ti-widget-header{margin-left:13px !important;margin-right:13px !important}.ti-widget.ti-goog.ti-disable-nav .ti-reviews-container-wrapper{margin:0 !important}.ti-widget.ti-goog.ti-review-text-mode-scroll .ti-read-more,.ti-widget.ti-goog.ti-review-text-mode-truncated .ti-read-more{display:none !important}.ti-widget.ti-goog.ti-disable-font .ti-widget-container,.ti-widget.ti-goog.ti-disable-font .ti-widget-container *,.ti-widget.ti-goog.ti-disable-font .ti-enable-widget{font-family:inherit !important}.ti-widget.ti-goog.ti-disable-animation .ti-review-item:hover,.ti-widget.ti-goog.ti-disable-animation .ti-header:hover,.ti-widget.ti-goog.ti-disable-animation .ti-footer:hover{-webkit-transform:none !important;-ms-transform:none !important;transform:none !important}.ti-widget.ti-goog.ti-disable-animation .ti-widget-container{margin-top:5px}.ti-widget.ti-goog.ti-text-align-right .ti-reviews-container-wrapper .ti-inner>.ti-stars,.ti-widget.ti-goog.ti-text-align-right .ti-reviews-container-wrapper .ti-popup-inner>.ti-stars,.ti-widget.ti-goog.ti-text-align-right .ti-reviews-container-wrapper .ti-read-more{text-align:right !important}.ti-widget.ti-goog.ti-text-align-center .ti-reviews-container-wrapper .ti-inner>.ti-stars,.ti-widget.ti-goog.ti-text-align-center .ti-reviews-container-wrapper .ti-popup-inner>.ti-stars,.ti-widget.ti-goog.ti-text-align-center .ti-reviews-container-wrapper .ti-read-more{text-align:center !important}.ti-widget.ti-goog.ti-text-align-justify .ti-reviews-container-wrapper .ti-inner>.ti-stars,.ti-widget.ti-goog.ti-text-align-justify .ti-reviews-container-wrapper .ti-popup-inner>.ti-stars,.ti-widget.ti-goog.ti-text-align-justify .ti-reviews-container-wrapper .ti-read-more{text-align:justify !important}.ti-widget.ti-goog.ti-text-align-right .ti-review-header{flex-direction:row-reverse}.ti-widget.ti-goog.ti-text-align-right .ti-review-header .ti-platform-icon{right:unset;left:0}.ti-widget.ti-goog.ti-text-align-right .ti-review-header .ti-profile-img{margin:0 0 0 15px !important}.ti-widget.ti-goog.ti-text-align-right .ti-review-header .ti-profile-details{text-align:right}.ti-widget.ti-goog.ti-text-align-right .ti-review-header .ti-profile-details .ti-name{padding-right:0;padding-left:25px}.ti-widget.ti-goog.ti-show-rating-text .ti-rating-text,.ti-widget.ti-goog.ti-show-rating-text .ti-rating-text strong:not(.ti-rating-large),.ti-widget.ti-goog.ti-show-rating-text .ti-rating-text strong a,.ti-widget.ti-goog.ti-show-rating-text .ti-rating-text strong span,.ti-widget.ti-goog.ti-show-rating-text .ti-rating-text span strong,.ti-widget.ti-goog.ti-show-rating-text .ti-rating-text span,.ti-widget.ti-goog.ti-show-rating-text .ti-footer,.ti-widget.ti-goog.ti-show-rating-text .ti-footer strong:not(.ti-rating-large),.ti-widget.ti-goog.ti-show-rating-text .ti-footer span,.ti-widget.ti-goog.ti-show-rating-text .ti-footer strong a{font-size:14px !important}.ti-widget.ti-goog.ti-text-align-right .ti-verified-tooltip,.ti-widget.ti-goog.ti-content-align-right .ti-verified-tooltip{margin:unset;bottom:unset;left:unset;right:calc(100% + 10px);margin-right:30px}.ti-widget.ti-goog.ti-text-align-right .ti-verified-tooltip:before,.ti-widget.ti-goog.ti-content-align-right .ti-verified-tooltip:before{left:unset;right:-7px;border-width:7px 0 7px 7px;border-color:transparent transparent transparent var(--ti-border-arrow-color)}.ti-widget.ti-goog.ti-text-align-right .ti-platform-icon .ti-tooltip,.ti-widget.ti-goog.ti-content-align-left .ti-platform-icon .ti-tooltip{margin:unset;right:unset;left:calc(100% + 10px);margin-left:30px}.ti-widget.ti-goog.ti-text-align-right .ti-platform-icon .ti-tooltip:before,.ti-widget.ti-goog.ti-content-align-left .ti-platform-icon .ti-tooltip:before{right:unset;left:-7px;border-width:7px 7px 7px 0;border-color:transparent var(--ti-border-arrow-color) transparent transparent}.ti-widget.ti-goog ::-webkit-scrollbar{width:4px;border-radius:3px}.ti-widget.ti-goog ::-webkit-scrollbar-track{background:rgba(85, 85, 85, 0.1)}.ti-widget.ti-goog ::-webkit-scrollbar-thumb{background:rgba(85, 85, 85, 0.6)}.ti-widget.ti-goog ::-webkit-scrollbar-thumb:hover{background:#555}.ti-enable-widget{display:none !important}.ti-widget .source-Trustpilot .ti-large-logo,.ti-lightbox .source-Trustpilot .ti-large-logo{display:none !important}.ti-widget .source-Trustpilot.ti-tab-item:before,.ti-widget .source-Trustpilot.ti-write-btn-dropdown-item:before,.ti-widget .source-Trustpilot .ti-review-header:after,.ti-widget .source-Trustpilot .ti-inner:after,.ti-widget .source-Trustpilot .ti-review-content:after,.ti-widget .source-Trustpilot .ti-platform-icon:after,.ti-widget .source-Trustpilot .ti-icon,.ti-widget .source-Trustpilot .ti-platform,.ti-widget .source-Trustpilot .ti-inner .col-left,.ti-widget .source-Trustpilot .ti-enable-widget:before,.ti-widget .source-Trustpilot .ti-platform-icon,.ti-lightbox .source-Trustpilot.ti-tab-item:before,.ti-lightbox .source-Trustpilot.ti-write-btn-dropdown-item:before,.ti-lightbox .source-Trustpilot .ti-review-header:after,.ti-lightbox .source-Trustpilot .ti-inner:after,.ti-lightbox .source-Trustpilot .ti-review-content:after,.ti-lightbox .source-Trustpilot .ti-platform-icon:after,.ti-lightbox .source-Trustpilot .ti-icon,.ti-lightbox .source-Trustpilot .ti-platform,.ti-lightbox .source-Trustpilot .ti-inner .col-left,.ti-lightbox .source-Trustpilot .ti-enable-widget:before,.ti-lightbox .source-Trustpilot .ti-platform-icon{display:none !important}.ti-widget .source-Trustpilot .ti-enable-widget,.ti-lightbox .source-Trustpilot .ti-enable-widget{padding-left:8px !important}.ti-widget .source-Trustpilot .ti-enable-widget:before,.ti-lightbox .source-Trustpilot .ti-enable-widget:before{display:none !important}.ti-widget .source-Trustpilot.disable-widget,.ti-lightbox .source-Trustpilot.disable-widget{top:4px !important;right:4px !important}.ti-widget .source-Trustpilot.ti-header .ti-stars,.ti-lightbox .source-Trustpilot.ti-header .ti-stars{margin-top:0 !important}.ti-widget .ti-widget-header .ti-tab-item[data-source=\"Trustpilot\"] .ti-platform-icon,.ti-lightbox .ti-widget-header .ti-tab-item[data-source=\"Trustpilot\"] .ti-platform-icon{display:none !important}.ti-widget .ti-widget-header .ti-tab-item[data-source=\"Trustpilot\"] .ti-item-label,.ti-lightbox .ti-widget-header .ti-tab-item[data-source=\"Trustpilot\"] .ti-item-label{margin-right:0 !important}.ti-widget .ti-enable-widget .ti-platform-icon[alt=\"Trustpilot\"],.ti-widget .source-all .ti-platform-icon[alt=\"Trustpilot\"],.ti-widget .source-Trustindex .ti-platform-icon[alt=\"Trustpilot\"],.ti-lightbox .ti-enable-widget .ti-platform-icon[alt=\"Trustpilot\"],.ti-lightbox .source-all .ti-platform-icon[alt=\"Trustpilot\"],.ti-lightbox .source-Trustindex .ti-platform-icon[alt=\"Trustpilot\"]{display:none !important}.ti-widget .source-Amazon.ti-tab-item:before,.ti-widget .source-Amazon.ti-write-btn-dropdown-item:before,.ti-widget .source-Amazon .ti-review-header:after,.ti-widget .source-Amazon .ti-inner:after,.ti-widget .source-Amazon .ti-review-content:after,.ti-widget .source-Amazon .ti-platform-icon:after,.ti-widget .source-Amazon .ti-icon,.ti-widget .source-Amazon .ti-platform,.ti-widget .source-Amazon .ti-inner .col-left,.ti-widget .source-Amazon .ti-enable-widget:before,.ti-widget .source-Amazon .ti-platform-icon,.ti-lightbox .source-Amazon.ti-tab-item:before,.ti-lightbox .source-Amazon.ti-write-btn-dropdown-item:before,.ti-lightbox .source-Amazon .ti-review-header:after,.ti-lightbox .source-Amazon .ti-inner:after,.ti-lightbox .source-Amazon .ti-review-content:after,.ti-lightbox .source-Amazon .ti-platform-icon:after,.ti-lightbox .source-Amazon .ti-icon,.ti-lightbox .source-Amazon .ti-platform,.ti-lightbox .source-Amazon .ti-inner .col-left,.ti-lightbox .source-Amazon .ti-enable-widget:before,.ti-lightbox .source-Amazon .ti-platform-icon{display:none !important}.ti-widget .source-Amazon .ti-enable-widget,.ti-lightbox .source-Amazon .ti-enable-widget{padding-left:8px !important}.ti-widget .source-Amazon .ti-enable-widget:before,.ti-lightbox .source-Amazon .ti-enable-widget:before{display:none !important}.ti-widget .source-Amazon.disable-widget,.ti-lightbox .source-Amazon.disable-widget{top:4px !important;right:4px !important}.ti-widget .source-Amazon.ti-header .ti-stars,.ti-lightbox .source-Amazon.ti-header .ti-stars{margin-top:0 !important}.ti-widget .ti-widget-header .ti-tab-item[data-source=\"Amazon\"] .ti-platform-icon,.ti-lightbox .ti-widget-header .ti-tab-item[data-source=\"Amazon\"] .ti-platform-icon{display:none !important}.ti-widget .ti-widget-header .ti-tab-item[data-source=\"Amazon\"] .ti-item-label,.ti-lightbox .ti-widget-header .ti-tab-item[data-source=\"Amazon\"] .ti-item-label{margin-right:0 !important}.ti-widget .ti-enable-widget .ti-platform-icon[alt=\"Amazon\"],.ti-widget .source-all .ti-platform-icon[alt=\"Amazon\"],.ti-widget .source-Trustindex .ti-platform-icon[alt=\"Amazon\"],.ti-lightbox .ti-enable-widget .ti-platform-icon[alt=\"Amazon\"],.ti-lightbox .source-all .ti-platform-icon[alt=\"Amazon\"],.ti-lightbox .source-Trustindex .ti-platform-icon[alt=\"Amazon\"]{display:none !important}.ti-widget .source-Reco.ti-tab-item:before,.ti-widget .source-Reco.ti-write-btn-dropdown-item:before,.ti-widget .source-Reco .ti-review-header:after,.ti-widget .source-Reco .ti-inner:after,.ti-widget .source-Reco .ti-review-content:after,.ti-widget .source-Reco .ti-platform-icon:after,.ti-widget .source-Reco .ti-icon,.ti-widget .source-Reco .ti-platform,.ti-widget .source-Reco .ti-inner .col-left,.ti-widget .source-Reco .ti-enable-widget:before,.ti-widget .source-Reco .ti-platform-icon,.ti-lightbox .source-Reco.ti-tab-item:before,.ti-lightbox .source-Reco.ti-write-btn-dropdown-item:before,.ti-lightbox .source-Reco .ti-review-header:after,.ti-lightbox .source-Reco .ti-inner:after,.ti-lightbox .source-Reco .ti-review-content:after,.ti-lightbox .source-Reco .ti-platform-icon:after,.ti-lightbox .source-Reco .ti-icon,.ti-lightbox .source-Reco .ti-platform,.ti-lightbox .source-Reco .ti-inner .col-left,.ti-lightbox .source-Reco .ti-enable-widget:before,.ti-lightbox .source-Reco .ti-platform-icon{display:none !important}.ti-widget .source-Reco .ti-enable-widget,.ti-lightbox .source-Reco .ti-enable-widget{padding-left:8px !important}.ti-widget .source-Reco .ti-enable-widget:before,.ti-lightbox .source-Reco .ti-enable-widget:before{display:none !important}.ti-widget .source-Reco.disable-widget,.ti-lightbox .source-Reco.disable-widget{top:4px !important;right:4px !important}.ti-widget .source-Reco.ti-header .ti-stars,.ti-lightbox .source-Reco.ti-header .ti-stars{margin-top:0 !important}.ti-widget .ti-widget-header .ti-tab-item[data-source=\"Reco\"] .ti-platform-icon,.ti-lightbox .ti-widget-header .ti-tab-item[data-source=\"Reco\"] .ti-platform-icon{display:none !important}.ti-widget .ti-widget-header .ti-tab-item[data-source=\"Reco\"] .ti-item-label,.ti-lightbox .ti-widget-header .ti-tab-item[data-source=\"Reco\"] .ti-item-label{margin-right:0 !important}.ti-widget .ti-enable-widget .ti-platform-icon[alt=\"Reco\"],.ti-widget .source-all .ti-platform-icon[alt=\"Reco\"],.ti-widget .source-Trustindex .ti-platform-icon[alt=\"Reco\"],.ti-lightbox .ti-enable-widget .ti-platform-icon[alt=\"Reco\"],.ti-lightbox .source-all .ti-platform-icon[alt=\"Reco\"],.ti-lightbox .source-Trustindex .ti-platform-icon[alt=\"Reco\"]{display:none !important}.ti-widget.ti-goog{overflow:visible !important}.ti-widget.ti-goog .ti-review-item>.ti-inner,.ti-widget.ti-goog .ti-load-more-reviews-container .ti-load-more-reviews-button{border-top-width:0px !important;border-bottom-width:0px !important;border-left-width:0px !important;border-right-width:0px !important;background-color:#f4f4f4 !important;backdrop-filter:blur(0px)}.ti-image-loading,.ti-review-item .ti-review-image{background-image:url(\"https://cdn.trustindex.io/assets/img/loading_dots.gif\");background-repeat:no-repeat;background-position:50% 50%;background-size:50px}.ti-image-loading.ti-image-loading img,.ti-review-item .ti-review-image.ti-image-loading img{opacity:0 !important}.ti-widget-lightbox{text-align:left !important;z-index:2147483645;height:100%;position:fixed;left:0;right:0;bottom:0;top:0;max-width:100%;width:100%;transition:all 300ms ease-out;background-color:rgba(0, 0, 0, 0.6);display:flex;color:#333;align-items:center !important;justify-content:center;flex-wrap:wrap;user-select:none;opacity:0;box-sizing:content-box}.ti-widget-lightbox *{box-sizing:inherit}.ti-widget-lightbox img{padding:0 !important;margin:0 !important;min-width:initial !important;max-width:initial !important}.ti-widget-lightbox .ti-widget-lightbox-inner{max-height:calc(100vh - 160px);height:100%;max-width:1200px;width:95%}@media (max-width:1160px){.ti-widget-lightbox .ti-widget-lightbox-inner{max-height:100%;height:100%;width:100%}}.ti-widget-lightbox.ti-widget-lightbox-appeared{opacity:1}.ti-widget-lightbox .ti-widget-lightbox-close{position:absolute;top:15px;right:15px;width:40px;height:40px;z-index:1;border-radius:50px;cursor:pointer;display:flex;justify-content:center;align-items:center}@media (max-width:1160px) and (orientation:landscape){.ti-widget-lightbox .ti-widget-lightbox-close{right:315px}}@media (max-width:1160px){.ti-widget-lightbox .ti-widget-lightbox-close{background-color:rgba(0, 0, 0, 0.5)}}.ti-widget-lightbox .ti-widget-lightbox-close:active,.ti-widget-lightbox .ti-widget-lightbox-close:hover{background-color:rgba(255, 255, 255, 0.2)}.ti-widget-lightbox .ti-widget-lightbox-close:before,.ti-widget-lightbox .ti-widget-lightbox-close:after{width:60%;height:3px;background-color:#fff;position:absolute;content:\"\";transform:rotate(45deg)}.ti-widget-lightbox .ti-widget-lightbox-close:after{transform:rotate(-45deg)}.ti-widget-lightbox .ti-widget-card,.ti-widget-lightbox .ti-widget-lightbox-review-container{overflow:hidden;border-radius:4px;height:100%;border:none;position:relative}@media (max-width:1160px){.ti-widget-lightbox .ti-widget-card,.ti-widget-lightbox .ti-widget-lightbox-review-container{border-radius:0}}.ti-widget-lightbox .ti-card-body,.ti-widget-lightbox .ti-review-item{background-color:#fff;position:relative;height:400px;flex-direction:row;border-radius:12px;display:flex;flex-direction:row;justify-content:flex-start;color:#000000;height:100%}@media (max-width:1160px){.ti-widget-lightbox .ti-card-body,.ti-widget-lightbox .ti-review-item{border-radius:0}}@media (max-width:767px) and (orientation:portrait){.ti-widget-lightbox .ti-card-body,.ti-widget-lightbox .ti-review-item{flex-direction:column;width:100%;height:100%;border-radius:0}}.ti-widget-lightbox .ti-card-body .ti-card-media,.ti-widget-lightbox .ti-review-item .ti-card-media{flex:1 1 auto;align-items:center;display:flex;height:100%;justify-content:center;width:100%;position:relative;background-color:#000000;overflow:hidden;padding-bottom:0px;border-top-left-radius:12px;border-bottom-left-radius:12px}@media (max-width:767px) and (orientation:portrait){.ti-widget-lightbox .ti-card-body .ti-card-media,.ti-widget-lightbox .ti-review-item .ti-card-media{flex:0 0 60%;width:100%;border-radius:0}}.ti-widget-lightbox .ti-card-body .ti-card-media img,.ti-widget-lightbox .ti-review-item .ti-card-media img{width:100% !important;height:100% !important;max-width:100% !important;max-height:100% !important;object-fit:contain;position:absolute;display:block;border-radius:inherit !important;opacity:1;transition:opacity 300ms ease-in-out}.ti-widget-lightbox .ti-card-body .ti-card-media .ti-nav-arrow,.ti-widget-lightbox .ti-review-item .ti-card-media .ti-nav-arrow{max-width:100%;margin-left:0px;left:inherit;top:50%;margin-top:-10px;visibility:visible;opacity:1}.ti-widget-lightbox .ti-card-body .ti-review-content,.ti-widget-lightbox .ti-review-item .ti-review-content{flex:0 0 auto;height:100%;width:300px;overflow:hidden;padding:0px;display:flex;flex-direction:column;font-size:15px;color:#000000}@media (max-width:767px) and (orientation:portrait){.ti-widget-lightbox .ti-card-body .ti-review-content,.ti-widget-lightbox .ti-review-item .ti-review-content{flex:0 0 40%;width:100%}}.ti-widget-lightbox .ti-card-body .ti-review-header,.ti-widget-lightbox .ti-review-item .ti-review-header{position:relative;z-index:unset;padding:20px;display:flex;align-items:center;color:#000}.ti-widget-lightbox .ti-card-body .ti-review-header .ti-platform-icon,.ti-widget-lightbox .ti-review-item .ti-review-header .ti-platform-icon{width:20px !important;height:20px !important;position:absolute;right:16px;top:16px}.ti-widget-lightbox .ti-card-body .ti-review-header .ti-profile-img,.ti-widget-lightbox .ti-review-item .ti-review-header .ti-profile-img{margin:0;margin-right:10px}.ti-widget-lightbox .ti-card-body .ti-review-header .ti-profile-img img,.ti-widget-lightbox .ti-review-item .ti-review-header .ti-profile-img img{width:40px !important;height:40px !important;display:block;border-radius:30px !important;object-fit:cover;object-position:top}.ti-widget-lightbox .ti-card-body .ti-review-header .ti-profile-img .ti-profile-img-sprite,.ti-widget-lightbox .ti-review-item .ti-review-header .ti-profile-img .ti-profile-img-sprite{display:inline-block;float:left;background:white;background-repeat:no-repeat;width:40px;height:40px;border-radius:30px}.ti-widget-lightbox .ti-card-body .ti-review-header .ti-profile-details,.ti-widget-lightbox .ti-review-item .ti-review-header .ti-profile-details{-webkit-box-flex:1;-ms-flex:1;flex:1;white-space:nowrap;text-overflow:ellipsis;text-align:left;margin:0;display:flex;flex-direction:column;justify-content:center}.ti-widget-lightbox .ti-card-body .ti-review-header .ti-profile-details .ti-name,.ti-widget-lightbox .ti-review-item .ti-review-header .ti-profile-details .ti-name{font-weight:600;font-size:inherit;overflow:hidden;padding-right:25px;white-space:nowrap;text-overflow:ellipsis;color:#000000;margin-bottom:2px}.ti-widget-lightbox .ti-card-body .ti-review-header .ti-profile-details .ti-date,.ti-widget-lightbox .ti-review-item .ti-review-header .ti-profile-details .ti-date{color:#888;font-size:12px}.ti-widget-lightbox .ti-card-body .ti-stars,.ti-widget-lightbox .ti-review-item .ti-stars{margin:0 20px;white-space:nowrap;display:block;line-height:0}.ti-widget-lightbox .ti-card-body .ti-stars .ti-star,.ti-widget-lightbox .ti-review-item .ti-stars .ti-star{width:17px !important;height:17px !important;display:inline-block;margin-right:1px !important;background-size:contain;background-repeat:no-repeat;vertical-align:unset}.ti-widget-lightbox .ti-card-body .ti-stars .ti-star:before,.ti-widget-lightbox .ti-card-body .ti-stars .ti-star:after,.ti-widget-lightbox .ti-review-item .ti-stars .ti-star:before,.ti-widget-lightbox .ti-review-item .ti-stars .ti-star:after{content:none !important}.ti-widget-lightbox .ti-card-body .ti-stars .ti-ten-rating-score,.ti-widget-lightbox .ti-review-item .ti-stars .ti-ten-rating-score{display:inline-block;font-weight:600;font-size:15px;color:#000000;margin-left:7px;height:100%;line-height:17px;vertical-align:top}.ti-widget-lightbox .ti-card-body .ti-stars .ti-verified-review .ti-verified-tooltip,.ti-widget-lightbox .ti-review-item .ti-stars .ti-verified-review .ti-verified-tooltip{max-width:150px !important}.ti-widget-lightbox .ti-card-body .ti-review-text,.ti-widget-lightbox .ti-review-item .ti-review-text{flex:0 1 100%;font-size:inherit;padding:20px;padding-top:0;margin-top:10px;display:block;overflow-x:hidden;overflow:auto;color:#000000}.ti-widget-lightbox .ti-nav-arrow{position:absolute;height:0px;top:50%;z-index:2;display:flex;flex-wrap:wrap;flex:0 0 100%;width:100%;transition:all 0.2s ease-in-out}.ti-widget-lightbox .ti-nav-arrow .ti-arrow-prev,.ti-widget-lightbox .ti-nav-arrow .ti-arrow-next{display:flex;align-items:center;border-radius:50%;background-color:rgba(255, 255, 255, 0.7);box-shadow:0px 0px 10px 0px rgba(0, 0, 0, 0.1);width:40px;height:40px;cursor:pointer}.ti-widget-lightbox .ti-nav-arrow .ti-arrow-prev:hover,.ti-widget-lightbox .ti-nav-arrow .ti-arrow-next:hover{background-color:white}.ti-widget-lightbox .ti-nav-arrow .ti-arrow-prev:active,.ti-widget-lightbox .ti-nav-arrow .ti-arrow-next:active{transform:scale(0.95);background-color:white}.ti-widget-lightbox .ti-nav-arrow .ti-arrow-prev:before,.ti-widget-lightbox .ti-nav-arrow .ti-arrow-next:before{width:25%;height:25%;display:block;content:\"\";transform-origin:center center;margin:auto;position:relative;border-top:solid 3px #000;border-left:solid 3px #000;box-sizing:content-box}.ti-widget-lightbox .ti-nav-arrow .ti-arrow-next{margin-left:auto;margin-right:15px}.ti-widget-lightbox .ti-nav-arrow .ti-arrow-next:before{transform:rotate(135deg);left:-5%}.ti-widget-lightbox .ti-nav-arrow .ti-arrow-prev{margin-left:15px}.ti-widget-lightbox .ti-nav-arrow .ti-arrow-prev:before{transform:rotate(-45deg);left:5%}.ti-widget-lightbox.ti-long-scroll .ti-widget-lightbox-inner{max-height:unset;max-width:unset;width:100%;touch-action:pan-x pan-y}.ti-widget-lightbox.ti-long-scroll .ti-widget-lightbox-review-container{display:block;overflow-y:scroll;overscroll-behavior:contain;scrollbar-width:none;-ms-overflow-style:none;position:relative;height:100%}.ti-widget-lightbox.ti-long-scroll .ti-widget-lightbox-review-container::-webkit-scrollbar{display:none}.ti-widget-lightbox.ti-long-scroll .ti-widget-lightbox-review-container .ti-widget-lightbox-review-container-inner{display:block;max-width:520px;margin:0 auto;padding:16px}.ti-widget-lightbox.ti-long-scroll .ti-review-item{display:block;height:unset;width:100%;margin-bottom:16px;border-radius:12px !important;scroll-margin-top:12px}.ti-widget-lightbox.ti-long-scroll .ti-review-item:last-child{margin-bottom:0}.ti-widget-lightbox.ti-long-scroll .ti-review-item .ti-review-header{padding-bottom:10px}.ti-widget-lightbox.ti-long-scroll .ti-review-item .ti-review-header .ti-platform-icon{right:20px;top:20px}.ti-widget-lightbox.ti-long-scroll .ti-review-item .ti-review-header .ti-name{margin-bottom:0 !important}.ti-widget-lightbox.ti-long-scroll .ti-review-item .ti-card-media{display:block;border-radius:0;height:unset;margin-top:20px;margin-bottom:10px;position:relative}.ti-widget-lightbox.ti-long-scroll .ti-review-item .ti-card-media .ti-card-media-images{display:flex;width:100%;flex-wrap:nowrap;overflow:hidden}.ti-widget-lightbox.ti-long-scroll .ti-review-item .ti-card-media .ti-card-media-image{width:100%;flex:0 0 auto;position:relative}.ti-widget-lightbox.ti-long-scroll .ti-review-item .ti-card-media .ti-card-media-image img{width:unset !important;height:unset !important;position:unset;margin:0 auto !important}.ti-widget-lightbox.ti-long-scroll .ti-review-item .ti-card-media .ti-hidden{display:none}.ti-widget-lightbox.ti-long-scroll .ti-review-item .ti-card-media .ti-card-media-thumbnails{display:block;width:calc(100% - 30px);padding:15px;overflow-x:scroll;scrollbar-width:none;-ms-overflow-style:none;position:absolute;left:0;bottom:0;background:rgba(0, 0, 0, 0.5)}.ti-widget-lightbox.ti-long-scroll .ti-review-item .ti-card-media .ti-card-media-thumbnails::-webkit-scrollbar{display:none}.ti-widget-lightbox.ti-long-scroll .ti-review-item .ti-card-media .ti-card-media-thumbnails .ti-card-media-thumbnails-inner{display:flex;justify-content:center;margin:0 -5px}.ti-widget-lightbox.ti-long-scroll .ti-review-item .ti-card-media .ti-card-media-thumbnails .ti-card-media-thumbnail{display:inline-block;width:50px;height:50px;border-radius:6px;margin:0 5px;position:relative;cursor:pointer}.ti-widget-lightbox.ti-long-scroll .ti-review-item .ti-card-media .ti-card-media-thumbnails .ti-card-media-thumbnail img{max-width:unset !important;max-height:unset !important;width:100% !important;height:100% !important;object-fit:cover;opacity:0.5;pointer-events:none}.ti-widget-lightbox.ti-long-scroll .ti-review-item .ti-card-media .ti-card-media-thumbnails .ti-card-media-thumbnail:hover img{opacity:1}.ti-widget-lightbox.ti-long-scroll .ti-review-item .ti-card-media .ti-card-media-thumbnails .ti-card-media-thumbnail.ti-active{pointer-events:none}.ti-widget-lightbox.ti-long-scroll .ti-review-item .ti-card-media .ti-card-media-thumbnails .ti-card-media-thumbnail.ti-active img{opacity:1}@media (max-width:767px){.ti-widget-lightbox.ti-long-scroll .ti-review-item .ti-card-media .ti-arrow-next,.ti-widget-lightbox.ti-long-scroll .ti-review-item .ti-card-media .ti-arrow-prev{display:none}}.ti-widget-lightbox.ti-long-scroll .ti-review-item .ti-review-text{margin-top:0;padding-top:10px}.ti-widget-lightbox.ti-long-scroll .ti-widget-lightbox-mobile-close-bottom-swipe{position:fixed;bottom:20px;left:0;right:0;margin:0 auto;z-index:1;display:none;width:0;height:0}.ti-widget-lightbox.ti-long-scroll .ti-widget-lightbox-mobile-close-bottom-swipe span{position:absolute;top:50%;left:50%;transform:translate(-50%, -50%) translateY(var(--scale)) rotate(45deg);display:inline-flex;width:15px;height:15px;background-color:transparent;border-radius:0px;justify-content:center;align-items:center;transform-origin:center;border-top:solid 2px #ffffff;border-left:solid 2px #ffffff}.ti-widget-lightbox.ti-long-scroll .ti-widget-lightbox-mobile-close-bottom{position:fixed;bottom:20px;margin:0 auto;padding:6px 16px;padding-right:38px;background-color:rgba(0, 0, 0, 0.4);color:white;z-index:888;border-radius:50px;cursor:pointer;display:none;font-size:16px;box-shadow:2px 10px 20px 0px rgba(0, 0, 0, 0.29);backdrop-filter:blur(7px)}.ti-widget-lightbox.ti-long-scroll .ti-widget-lightbox-mobile-close-bottom:focus,.ti-widget-lightbox.ti-long-scroll .ti-widget-lightbox-mobile-close-bottom:active{background-color:rgba(0, 0, 0, 0.6);box-shadow:2px 5px 10px 0px rgba(0, 0, 0, 0.29)}.ti-widget-lightbox.ti-long-scroll .ti-widget-lightbox-mobile-close-bottom span{display:inline-block;position:absolute;top:calc(50% - 1px);transform:translateY(-50%);right:14px;width:16px;height:16px;pointer-events:none}.ti-widget-lightbox.ti-long-scroll .ti-widget-lightbox-mobile-close-bottom span:before,.ti-widget-lightbox.ti-long-scroll .ti-widget-lightbox-mobile-close-bottom span:after{width:100%;height:2px;background-color:#fff;position:absolute;top:50%;content:\"\";transform:rotate(45deg)}.ti-widget-lightbox.ti-long-scroll .ti-widget-lightbox-mobile-close-bottom span:after{transform:rotate(-45deg)}@media (max-width:767px) and (orientation:portrait){.ti-widget-lightbox.ti-long-scroll .ti-widget-lightbox-close{display:none}.ti-widget-lightbox.ti-long-scroll .ti-widget-lightbox-mobile-close-bottom{display:inline-block}.ti-widget-lightbox.ti-long-scroll .ti-widget-lightbox-inner{backdrop-filter:unset}}.ti-widget-lightbox .ti-verified-review{display:inline-block;background:url(\"https://cdn.trustindex.io/assets/icon/ti-verified.svg\");background-size:contain;width:15px;height:15px;margin:0 !important;margin-left:7px !important;position:relative;z-index:2}.ti-widget-lightbox .ti-verified-review:only-child{margin-left:0 !important}.ti-widget-lightbox .ti-verified-review.ti-color-green{background:url(\"https://cdn.trustindex.io/assets/icon/ti-verified-green.svg\")}.ti-widget-lightbox .ti-verified-review.ti-color-black{background:url(\"https://cdn.trustindex.io/assets/icon/ti-verified-black.svg\")}.ti-widget-lightbox .ti-recommendation+.ti-verified-review{top:2px}.ti-widget-lightbox .ti-ten-rating-score+.ti-verified-review{top:-1px}.ti-widget-lightbox .ti-tooltip,.ti-widget-lightbox .ti-verified-tooltip{color:white !important;background-color:black !important;text-align:left;padding:5px 10px;border-radius:6px;font-size:13px !important;font-weight:400;display:inline-block !important;position:absolute;top:-5px;white-space:nowrap;z-index:3;opacity:0;visibility:hidden;transition:opacity 0.3s ease-in-out;width:max-content;box-shadow:0 4px 12px rgba(0, 0, 0, 0.33);--ti-border-arrow-color: black;margin:unset;bottom:unset;left:unset;right:calc(100% + 10px);margin-right:30px}.ti-widget-lightbox .ti-tooltip:before,.ti-widget-lightbox .ti-verified-tooltip:before{width:0;height:0;border-style:solid;content:\"\" !important;position:absolute;top:50%;margin-top:-7px}.ti-widget-lightbox .ti-tooltip:before,.ti-widget-lightbox .ti-verified-tooltip:before{left:unset;right:-7px;border-width:7px 0 7px 7px;border-color:transparent transparent transparent var(--ti-border-arrow-color)}.ti-widget-lightbox .ti-with-tooltip,.ti-widget-lightbox .ti-verified-review{position:relative;font-size:inherit}.ti-widget-lightbox .ti-with-tooltip:hover .ti-tooltip,.ti-widget-lightbox .ti-with-tooltip:hover .ti-verified-tooltip,.ti-widget-lightbox .ti-verified-review:hover .ti-tooltip,.ti-widget-lightbox .ti-verified-review:hover .ti-verified-tooltip{opacity:1;margin:0;visibility:visible}.ti-widget-lightbox .ti-verified-tooltip{margin:unset;right:unset;left:calc(100% + 10px);margin-left:30px}.ti-widget-lightbox .ti-verified-tooltip:before{right:unset;left:-7px;border-width:7px 7px 7px 0;border-color:transparent var(--ti-border-arrow-color) transparent transparent}.ti-widget-lightbox .ti-verified-platform .ti-verified-tooltip{width:175px;max-width:250px;white-space:normal;line-height:1.4 !important;top:-10px}.ti-widget-lightbox .ti-verified-platform .ti-verified-tooltip:before{top:18px}.ti-widget-lightbox .ti-date .ti-tooltip{margin:unset;top:unset;right:unset;left:calc(50% + 20px);transform:translateX(-50%);margin-bottom:30px;bottom:calc(100% + 10px)}.ti-widget-lightbox .ti-date .ti-tooltip:before{top:unset;right:unset;margin:unset;left:50%;margin-left:-25px;bottom:-7px;border-width:7px 7px 0 7px;border-color:var(--ti-border-arrow-color) transparent transparent transparent}.ti-widget-lightbox[data-set-id^=\"dark-\"] .ti-tooltip,.ti-widget-lightbox[data-set-id^=\"dark-\"] .ti-verified-tooltip,.ti-widget-lightbox[data-set-id=\"light-contrast\"] .ti-tooltip,.ti-widget-lightbox[data-set-id=\"light-contrast\"] .ti-verified-tooltip{color:black !important;background-color:white !important;--ti-border-arrow-color: white}.ti-widget-lightbox[data-layout-id=\'34\'][data-set-id=\'light-background\'].ti-custom-stars [class*=\"source-\"] .ti-star.e,.ti-widget-lightbox[data-layout-id=\'34\'][data-set-id=\'light-background\'].ti-custom-stars [class*=\"source-\"] .ti-star.f{background-image:none}.ti-widget-lightbox[data-layout-id=\'34\'][data-set-id=\'light-background\'].ti-custom-stars .ti-star{-webkit-mask-size:contain;mask-size:contain;-webkit-mask-position:center;mask-position:center;-webkit-mask-repeat:no-repeat;mask-repeat:no-repeat;mask-image:url(https://cdn.trustindex.io/assets/platform/Trustindex/star/s.svg);-webkit-mask-image:url(https://cdn.trustindex.io/assets/platform/Trustindex/star/s.svg)}.ti-widget-lightbox[data-layout-id=\'34\'][data-set-id=\'light-background\'].ti-custom-stars .ti-star:not(.e):not(.h){background:#f6bb06}.ti-widget-lightbox[data-layout-id=\'34\'][data-set-id=\'light-background\'].ti-custom-stars .ti-star.h{background:#f6bb06;background:-webkit-linear-gradient(90deg, #f6bb06 50%, #cccccc 50%) !important;background:linear-gradient(90deg, #f6bb06 50%, #cccccc 50%) !important}.ti-widget-lightbox[data-layout-id=\'34\'][data-set-id=\'light-background\'].ti-custom-stars .ti-star.e{background:#ccc !important}.ti-widget-lightbox[data-layout-id=\'34\'][data-set-id=\'light-background\'] .ti-ai-summary-item{color:#000000}.ti-widget-lightbox[data-layout-id=\'34\'][data-set-id=\'light-background\'] .ti-ai-summary-item .ti-review-content{-webkit-line-clamp:5;margin-top:16.25px;height:110.75px !important}.ti-widget-lightbox[data-layout-id=\'34\'][data-set-id=\'light-background\'] .ti-ai-summary-item .ti-review-content .ti-summary-list{margin-bottom:0;padding-left:0;list-style:none;font-size:inherit;pointer-events:none}.ti-widget-lightbox[data-layout-id=\'34\'][data-set-id=\'light-background\'] .ti-ai-summary-item .ti-review-content .ti-summary-list li{list-style:inherit;margin-bottom:0;padding-left:20px;position:relative;font-size:inherit}.ti-widget-lightbox[data-layout-id=\'34\'][data-set-id=\'light-background\'] .ti-ai-summary-item .ti-review-content .ti-summary-list li:last-child{margin-bottom:0}.ti-widget-lightbox[data-layout-id=\'34\'][data-set-id=\'light-background\'] .ti-ai-summary-item .ti-review-content .ti-summary-list li:before{display:block;content:\"\";width:10px;height:5px;border-left:solid 2px #000000;border-bottom:solid 2px #000000;transform:rotate(-45deg);position:absolute;left:0;top:7.5px}.ti-widget-lightbox[data-layout-id=\'34\'][data-set-id=\'light-background\'] .ti-ai-summary-item .ti-profile-img{margin-right:13px !important}.ti-widget-lightbox[data-layout-id=\'34\'][data-set-id=\'light-background\'] .ti-ai-summary-item .ti-profile-img img:not(.ti-ai-profile-img){display:inline-block;vertical-align:middle;border:2px solid #f4f4f4}.ti-widget-lightbox[data-layout-id=\'34\'][data-set-id=\'light-background\'] .ti-ai-summary-item .ti-profile-img img:not(.ti-ai-profile-img):not(:first-child){margin-left:-12px !important}.ti-widget-lightbox[data-layout-id=\'34\'][data-set-id=\'light-background\'] .ti-ai-summary-item .ti-profile-details .ti-name{padding-right:0}.ti-widget-lightbox[data-layout-id=\'34\'][data-set-id=\'light-background\'] .ti-ai-summary-item>.ti-inner{background-color:#f4f4f4 !important;background-image:none}.ti-widget-lightbox[data-layout-id=\'34\'][data-set-id=\'light-background\'] .ti-ai-summary-item .ti-profile-img img:not(.ti-ai-profile-img){border-color:#f4f4f4}.ti-widget-lightbox[data-layout-id=\'34\'][data-set-id=\'light-background\'] .ti-ai-summary-item .ti-name,.ti-widget-lightbox[data-layout-id=\'34\'][data-set-id=\'light-background\'] .ti-ai-summary-item .ti-date,.ti-widget-lightbox[data-layout-id=\'34\'][data-set-id=\'light-background\'] .ti-ai-summary-item .ti-read-more span{color:#000000}.ti-widget-lightbox[data-layout-id=\'34\'][data-set-id=\'light-background\'] .ti-ai-summary-item .ti-lightbox-review-header{padding-bottom:0 !important}.ti-widget-lightbox[data-layout-id=\'34\'][data-set-id=\'light-background\'] .ti-ai-summary-item .ti-review-content{margin:unset;-webkit-line-clamp:unset;width:unset !important;height:unset !important}.ti-widget.ti-goog{overflow:visible !important}.ti-widget.ti-goog .ti-review-content{height:87px !important}.ti-widget.ti-goog .ti-reviews-container-wrapper{padding-bottom:1px;margin-top:-5px !important}.ti-disable-animation.ti-widget.ti-goog .ti-reviews-container-wrapper{margin-top:-5px !important}.ti-widget.ti-goog .ti-widget-container{margin-bottom:0px}.ti-widget.ti-goog .ti-header{text-align:center;margin-bottom:22px}.ti-widget.ti-goog .ti-header:not(.ti-header-grid){display:block}.ti-widget.ti-goog .ti-header .ti-rating-text strong.ti-rating{font-size:24px !important;display:block;margin-bottom:4px}.ti-widget.ti-goog .ti-header .ti-rating-text .nowrap{margin-bottom:3px}.ti-widget.ti-goog .ti-header .ti-large-logo{margin-top:8px}.ti-widget.ti-goog .ti-header .ti-large-logo img{max-width:120px !important;top:0px}.ti-widget.ti-goog .ti-header .ti-stars{margin-top:0;margin-bottom:5px}.ti-widget.ti-goog .ti-fade-container:nth-child(1){display:block}.ti-widget.ti-goog .ti-fade-container[style*=\"display: flex\"]{display:block !important}.ti-widget.ti-goog .ti-footer-filter-text{text-align:center}.ti-widget.ti-goog .ti-controls{display:none;margin-top:-12px;width:100%;position:absolute;height:0px;z-index:1;top:50%}.ti-widget.ti-goog .ti-controls .ti-next,.ti-widget.ti-goog .ti-controls .ti-prev{position:absolute;width:30px;height:30px;display:block;opacity:1;transition:all 200ms ease-out;background-color:#ffffff;outline-style:solid;outline-width:2px;outline-color:#F4F4F4;border-radius:15px}.ti-widget.ti-goog .ti-controls .ti-next:before,.ti-widget.ti-goog .ti-controls .ti-prev:before{transition:all 200ms ease-out;content:\"\";display:block;position:absolute;border-style:solid;border-width:0;border-bottom-width:2px;border-left-width:2px;border-color:#575757;width:10px;height:10px;top:50%;left:50%}.ti-widget.ti-goog .ti-controls .ti-next:hover,.ti-widget.ti-goog .ti-controls .ti-prev:hover{cursor:pointer;background-color:#4d4d4d !important;outline-color:#424242 !important;box-shadow:0px 5px 25px 0px rgba(0, 0, 0, 0.05)}.ti-widget.ti-goog .ti-controls .ti-next:hover:before,.ti-widget.ti-goog .ti-controls .ti-prev:hover:before{border-color:#fff !important}.ti-widget.ti-goog .ti-controls .ti-next{right:1px}.ti-widget.ti-goog .ti-controls .ti-next:before{transform:translate(-70%, -50%) rotate(-135deg)}.ti-widget.ti-goog .ti-controls .ti-prev{left:1px}.ti-widget.ti-goog .ti-controls .ti-prev:before{transform:translate(-30%, -50%) rotate(45deg)}@media (min-width:1024px){.ti-widget.ti-goog .ti-controls{display:block}}@media (max-width:479px){.ti-widget.ti-goog .ti-controls{top:calc(50% - 19px)}}.ti-widget.ti-goog .ti-controls-line{display:none;margin:20px auto;width:150px;height:3px;border-radius:3px;background:rgba(87, 87, 87, 0.35);position:relative;overflow:hidden}.ti-widget.ti-goog .ti-controls-line .dot{position:absolute;left:0;top:0;display:inline-block;width:25px;padding-left:4px;padding-right:4px;height:100%;border-radius:3px;background:#575757;transition:width 0.2s, left 0.2s}@media (max-width:479px){.ti-widget.ti-goog .ti-controls-line{display:block !important}}.ti-clickable-link{cursor:pointer}','off');
INSERT INTO `wp_79e54b1ec2_options` VALUES ('21658','trustindex-google-verified-by-trustindex','1','off');
INSERT INTO `wp_79e54b1ec2_options` VALUES ('21684','trustindex-google-widget-setted-up','1','off');
INSERT INTO `wp_79e54b1ec2_options` VALUES ('32580','popmake_settings','a:2:{s:26:\"disable_popup_category_tag\";i:1;s:16:\"default_theme_id\";i:897;}','auto');
INSERT INTO `wp_79e54b1ec2_options` VALUES ('32581','popup_maker_version_info','a:4:{s:7:\"version\";s:6:\"1.21.5\";s:13:\"upgraded_from\";s:5:\"0.0.0\";s:15:\"initial_version\";s:6:\"1.21.5\";s:12:\"installed_on\";s:19:\"2025-10-29 19:31:55\";}','auto');
INSERT INTO `wp_79e54b1ec2_options` VALUES ('32582','pum_gutenberg_legacy_choice','new_user','auto');
INSERT INTO `wp_79e54b1ec2_options` VALUES ('32583','pum_block_editor_migration_handled','1','auto');
INSERT INTO `wp_79e54b1ec2_options` VALUES ('32584','pum_files_writeable','1','auto');
INSERT INTO `wp_79e54b1ec2_options` VALUES ('32585','_pum_writeable_notice_dismissed','1','auto');
INSERT INTO `wp_79e54b1ec2_options` VALUES ('32586','pum_db_ver','8','auto');
INSERT INTO `wp_79e54b1ec2_options` VALUES ('32587','_pum_installed_themes','a:7:{i:0;s:8:\"lightbox\";i:1;s:15:\"enterprise-blue\";i:2;s:9:\"hello-box\";i:3;s:12:\"cutting-edge\";i:4;s:13:\"framed-border\";i:5;s:12:\"floating-bar\";i:6;s:12:\"content-only\";}','auto');
INSERT INTO `wp_79e54b1ec2_options` VALUES ('32588','popup_maker_data_versioning','a:7:{s:8:\"pum_ctas\";i:1;s:6:\"popups\";i:3;s:12:\"popup_themes\";i:3;s:8:\"settings\";i:2;s:11:\"plugin_meta\";i:1;s:9:\"user_meta\";i:1;s:5:\"popup\";i:0;}','auto');
INSERT INTO `wp_79e54b1ec2_options` VALUES ('32589','pum_example_popups_installed','1','on');
INSERT INTO `wp_79e54b1ec2_options` VALUES ('32590','pum_completed_upgrades','a:1:{i:0;s:16:\"core-v1_8-themes\";}','auto');
INSERT INTO `wp_79e54b1ec2_options` VALUES ('32594','pum_reviews_installed_on','2025-10-29 19:31:57','auto');
INSERT INTO `wp_79e54b1ec2_options` VALUES ('32595','_pum_installed','1','auto');
INSERT INTO `wp_79e54b1ec2_options` VALUES ('32621','pum-has-cached-css','1761766783','auto');
INSERT INTO `wp_79e54b1ec2_options` VALUES ('32783','pum-has-cached-js','1761766787','auto');
INSERT INTO `wp_79e54b1ec2_options` VALUES ('32784','pum_all_theme_close_text_cache','a:8:{i:903;s:2:\"×\";i:904;s:2:\"×\";i:897;s:5:\"CLOSE\";i:898;s:7:\"&times;\";i:899;s:2:\"×\";i:900;s:2:\"×\";i:901;s:2:\"×\";i:902;s:2:\"×\";}','auto');
INSERT INTO `wp_79e54b1ec2_options` VALUES ('33085','pum_total_open_count','11','auto');
INSERT INTO `wp_79e54b1ec2_options` VALUES ('33086','pum_overall_conversion_rate','0','auto');
INSERT INTO `wp_79e54b1ec2_options` VALUES ('33467','pum_privacy_cookie_list','a:2:{s:7:\"cookies\";a:1:{s:7:\"pum-905\";a:3:{s:5:\"label\";s:56:\"Cookie used to prevent popup from displaying repeatedly.\";s:4:\"name\";s:7:\"pum-905\";s:4:\"time\";s:7:\"1 month\";}}s:9:\"timestamp\";i:1763584944;}','auto');
INSERT INTO `wp_79e54b1ec2_options` VALUES ('36877','trustindex-google-cdn-version-control','a:5:{s:8:\"feed-css\";s:3:\"1.2\";s:10:\"widget-css\";s:3:\"3.9\";s:11:\"widget-html\";s:3:\"2.6\";s:12:\"widget-proxy\";s:3:\"1.0\";s:13:\"last-saved-at\";i:1763631472;}','off');
INSERT INTO `wp_79e54b1ec2_options` VALUES ('39635','elementor_atomic_styles_fonts-local-226','a:0:{}','auto');
INSERT INTO `wp_79e54b1ec2_options` VALUES ('44443','mwp_key_last_used_21523934','1763658055','on');
INSERT INTO `wp_79e54b1ec2_options` VALUES ('45354','trustindex-google-review-content','<div class=\" ti-widget \" data-layout-id=\"34\" data-layout-category=\"slider\" data-set-id=\"\" data-pid=\"\" data-language=\"en\" data-close-locale=\"Close\" data-review-target-width=\"300\" data-css-version=\"2\" data-review-text-mode=\"readmore\" data-reply-by-locale=\"Owner\'s reply\" data-only-rating-locale=\"This user only left a rating.\" data-pager-autoplay-timeout=\"6\" > <div class=\"ti-widget-container ti-col-3\"> <div class=\"ti-header ti-header-grid source-%platform%\"> <div class=\"ti-fade-container\"> <div class=\"ti-rating-text\"> <strong class=\"ti-rating ti-rating-large\"> RATING_TEXT </strong> </div> <span class=\"ti-stars star-lg\"><!-- STARS-CONTENT --></span> <div class=\"ti-rating-text\"> <span class=\"nowrap\">Based on <strong>RATING_NUMBER reviews</strong></span> </div> <div class=\"ti-large-logo\"> <div class=\"ti-v-center\"> <img class=\"ti-logo-fb\" src=\"https://cdn.trustindex.io/assets/platform/%platform%/logo.svg\" loading=\"lazy\" alt=\"%platform%\" width=\"150\" height=\"25\" /> </div> </div> </div> </div> <div class=\"ti-reviews-container\"> <div class=\"ti-controls\"> <div class=\"ti-next\" aria-label=\"Next review\" role=\"button\"></div> <div class=\"ti-prev\" aria-label=\"Previous review\" role=\"button\"></div> </div> <div class=\"ti-reviews-container-wrapper\"> <!-- R-LIST --> <div class=\"ti-review-item source-%platform% ti-image-layout-thumbnail\" data-id=\"cfcd208495d565ef66e7dff9f98764da\" > <div class=\"ti-inner\"> <div class=\"ti-review-header\"> <div class=\"ti-platform-icon ti-with-tooltip\"> <span class=\"ti-tooltip\">Posted on </span> <img src=\"https://cdn.trustindex.io/assets/platform/%platform%/icon.svg\" alt=\"\" width=\"20\" height=\"20\" loading=\"lazy\" /> </div> <div class=\"ti-profile-img\"> <img src=\"%reviewer_photo%\" srcset=\"%reviewer_photo% 2x\" alt=\"%reviewer_name% profile picture\" loading=\"lazy\" /> </div> <div class=\"ti-profile-details\"> <div class=\"ti-name\"> %reviewer_name% </div> <div class=\"ti-date\">%created_at%</div> </div> </div> <span class=\"ti-stars\"><!-- STARS-CONTENT --></span> <div class=\"ti-review-text-container ti-review-content\"><!-- R-CONTENT -->%text%<!-- R-CONTENT --></div> <span class=\"ti-read-more\" data-container=\".ti-review-content\" data-collapse-text=\"Hide\" data-open-text=\"Read more\" ></span> </div> </div> <!-- R-LIST --> </div> <div class=\"ti-controls-line\"> <div class=\"dot\"></div> </div> </div> <div class=\"ti-footer-filter-text\"><!-- FOOTER FILTER TEXT --></div> <!-- VERIFIED BY TRUSTINDEX START <div class=\"ti-verified-by ti-verified-by-row\" data-style=\"1\"> <div class=\"ti-inner\"> Verified by Trustindex <span class=\"ti-info-icon\"></span> <div class=\"ti-disclaimer\">Trustindex verified badge is the Universal Symbol of Trust. Only the greatest companies can get the verified badge who has a review score above 4.5, based on customer reviews over the past 12 months. <a href=\"https://www.trustindex.io/?a=sys&c=verified-badge&url=/the-trustindex-verified-badge/\" target=\"_blank\">Read more</a></div> </div> </div> VERIFIED BY TRUSTINDEX END --> </div> </div> ','off');
INSERT INTO `wp_79e54b1ec2_options` VALUES ('45496','elementor_1_elementor_updater_batch_42b1a7265ad1339d2d643f8145ac','a:1:{i:0;a:1:{s:8:\"callback\";a:2:{i:0;s:31:\"Elementor\\Core\\Upgrade\\Upgrades\";i:1;s:16:\"_on_each_version\";}}}','off');
INSERT INTO `wp_79e54b1ec2_options` VALUES ('45507','_site_transient_timeout_gd_system_disallowed_plugins','1763944472','off');
INSERT INTO `wp_79e54b1ec2_options` VALUES ('45508','_site_transient_gd_system_disallowed_plugins','a:103:{i:0;a:6:{s:8:\"pluginId\";i:1;s:13:\"threatLevelId\";i:1;s:4:\"name\";s:7:\"adminer\";s:14:\"minimumVersion\";s:3:\"0.0\";s:14:\"maximumVersion\";s:8:\"999999.0\";s:11:\"description\";s:18:\"Remove Immediately\";}i:1;a:6:{s:8:\"pluginId\";i:4;s:13:\"threatLevelId\";i:1;s:4:\"name\";s:15:\"backupwordpress\";s:14:\"minimumVersion\";s:3:\"0.0\";s:14:\"maximumVersion\";s:3:\"3.2\";s:11:\"description\";s:18:\"Remove Immediately\";}i:2;a:6:{s:8:\"pluginId\";i:5;s:13:\"threatLevelId\";i:1;s:4:\"name\";s:8:\"backwpup\";s:14:\"minimumVersion\";s:3:\"0.0\";s:14:\"maximumVersion\";s:3:\"3.1\";s:11:\"description\";s:18:\"Remove Immediately\";}i:3;a:6:{s:8:\"pluginId\";i:6;s:13:\"threatLevelId\";i:1;s:4:\"name\";s:19:\"broken-link-checker\";s:14:\"minimumVersion\";s:3:\"0.0\";s:14:\"maximumVersion\";s:8:\"999999.0\";s:11:\"description\";s:18:\"Remove Immediately\";}i:4;a:6:{s:8:\"pluginId\";i:7;s:13:\"threatLevelId\";i:1;s:4:\"name\";s:24:\"contextual-related-posts\";s:14:\"minimumVersion\";s:3:\"0.0\";s:14:\"maximumVersion\";s:8:\"999999.0\";s:11:\"description\";s:18:\"Remove Immediately\";}i:5;a:6:{s:8:\"pluginId\";i:9;s:13:\"threatLevelId\";i:1;s:4:\"name\";s:21:\"ezpz-one-click-backup\";s:14:\"minimumVersion\";s:3:\"0.0\";s:14:\"maximumVersion\";s:8:\"999999.0\";s:11:\"description\";s:18:\"Remove Immediately\";}i:6;a:6:{s:8:\"pluginId\";i:11;s:13:\"threatLevelId\";i:1;s:4:\"name\";s:17:\"fuzzy-seo-booster\";s:14:\"minimumVersion\";s:3:\"0.0\";s:14:\"maximumVersion\";s:8:\"999999.0\";s:11:\"description\";s:18:\"Remove Immediately\";}i:7;a:6:{s:8:\"pluginId\";i:12;s:13:\"threatLevelId\";i:1;s:4:\"name\";s:24:\"google-sitemap-generator\";s:14:\"minimumVersion\";s:3:\"0.0\";s:14:\"maximumVersion\";s:3:\"3.9\";s:11:\"description\";s:18:\"Remove Immediately\";}i:8;a:6:{s:8:\"pluginId\";i:13;s:13:\"threatLevelId\";i:1;s:4:\"name\";s:42:\"google-xml-sitemaps-with-multisite-support\";s:14:\"minimumVersion\";s:3:\"0.0\";s:14:\"maximumVersion\";s:8:\"999999.0\";s:11:\"description\";s:18:\"Remove Immediately\";}i:9;a:6:{s:8:\"pluginId\";i:17;s:13:\"threatLevelId\";i:1;s:4:\"name\";s:11:\"jr-referrer\";s:14:\"minimumVersion\";s:3:\"0.0\";s:14:\"maximumVersion\";s:8:\"999999.0\";s:11:\"description\";s:18:\"Remove Immediately\";}i:10;a:6:{s:8:\"pluginId\";i:22;s:13:\"threatLevelId\";i:1;s:4:\"name\";s:19:\"portable-phpmyadmin\";s:14:\"minimumVersion\";s:3:\"0.0\";s:14:\"maximumVersion\";s:8:\"999999.0\";s:11:\"description\";s:18:\"Remove Immediately\";}i:11;a:6:{s:8:\"pluginId\";i:23;s:13:\"threatLevelId\";i:1;s:4:\"name\";s:11:\"quick-cache\";s:14:\"minimumVersion\";s:3:\"0.0\";s:14:\"maximumVersion\";s:8:\"999999.0\";s:11:\"description\";s:18:\"Remove Immediately\";}i:12;a:6:{s:8:\"pluginId\";i:24;s:13:\"threatLevelId\";i:1;s:4:\"name\";s:8:\"seo-alrp\";s:14:\"minimumVersion\";s:3:\"0.0\";s:14:\"maximumVersion\";s:8:\"999999.0\";s:11:\"description\";s:18:\"Remove Immediately\";}i:13;a:6:{s:8:\"pluginId\";i:25;s:13:\"threatLevelId\";i:1;s:4:\"name\";s:13:\"similar-posts\";s:14:\"minimumVersion\";s:3:\"0.0\";s:14:\"maximumVersion\";s:8:\"999999.0\";s:11:\"description\";s:18:\"Remove Immediately\";}i:14;a:6:{s:8:\"pluginId\";i:28;s:13:\"threatLevelId\";i:1;s:4:\"name\";s:19:\"the-codetree-backup\";s:14:\"minimumVersion\";s:3:\"0.0\";s:14:\"maximumVersion\";s:8:\"999999.0\";s:11:\"description\";s:18:\"Remove Immediately\";}i:15;a:6:{s:8:\"pluginId\";i:29;s:13:\"threatLevelId\";i:1;s:4:\"name\";s:9:\"toolspack\";s:14:\"minimumVersion\";s:3:\"0.0\";s:14:\"maximumVersion\";s:8:\"999999.0\";s:11:\"description\";s:18:\"Remove Immediately\";}i:16;a:6:{s:8:\"pluginId\";i:31;s:13:\"threatLevelId\";i:1;s:4:\"name\";s:14:\"w3-total-cache\";s:14:\"minimumVersion\";s:3:\"0.0\";s:14:\"maximumVersion\";s:8:\"999999.0\";s:11:\"description\";s:18:\"Remove Immediately\";}i:17;a:6:{s:8:\"pluginId\";i:32;s:13:\"threatLevelId\";i:1;s:4:\"name\";s:26:\"wordpress-gzip-compression\";s:14:\"minimumVersion\";s:3:\"0.0\";s:14:\"maximumVersion\";s:8:\"999999.0\";s:11:\"description\";s:18:\"Remove Immediately\";}i:18;a:6:{s:8:\"pluginId\";i:33;s:13:\"threatLevelId\";i:1;s:4:\"name\";s:8:\"wp-cache\";s:14:\"minimumVersion\";s:3:\"0.0\";s:14:\"maximumVersion\";s:8:\"999999.0\";s:11:\"description\";s:18:\"Remove Immediately\";}i:19;a:6:{s:8:\"pluginId\";i:37;s:13:\"threatLevelId\";i:1;s:4:\"name\";s:18:\"wp-engine-snapshot\";s:14:\"minimumVersion\";s:3:\"0.0\";s:14:\"maximumVersion\";s:8:\"999999.0\";s:11:\"description\";s:18:\"Remove Immediately\";}i:20;a:6:{s:8:\"pluginId\";i:38;s:13:\"threatLevelId\";i:1;s:4:\"name\";s:13:\"wp-file-cache\";s:14:\"minimumVersion\";s:3:\"0.0\";s:14:\"maximumVersion\";s:8:\"999999.0\";s:11:\"description\";s:18:\"Remove Immediately\";}i:21;a:6:{s:8:\"pluginId\";i:41;s:13:\"threatLevelId\";i:1;s:4:\"name\";s:13:\"wp-phpmyadmin\";s:14:\"minimumVersion\";s:3:\"0.0\";s:14:\"maximumVersion\";s:8:\"999999.0\";s:11:\"description\";s:18:\"Remove Immediately\";}i:22;a:6:{s:8:\"pluginId\";i:42;s:13:\"threatLevelId\";i:1;s:4:\"name\";s:12:\"wp-postviews\";s:14:\"minimumVersion\";s:3:\"0.0\";s:14:\"maximumVersion\";s:8:\"999999.0\";s:11:\"description\";s:18:\"Remove Immediately\";}i:23;a:6:{s:8:\"pluginId\";i:43;s:13:\"threatLevelId\";i:1;s:4:\"name\";s:11:\"wp-slimstat\";s:14:\"minimumVersion\";s:3:\"0.0\";s:14:\"maximumVersion\";s:8:\"999999.0\";s:11:\"description\";s:18:\"Remove Immediately\";}i:24;a:6:{s:8:\"pluginId\";i:44;s:13:\"threatLevelId\";i:1;s:4:\"name\";s:14:\"wp-super-cache\";s:14:\"minimumVersion\";s:3:\"0.0\";s:14:\"maximumVersion\";s:8:\"999999.0\";s:11:\"description\";s:18:\"Remove Immediately\";}i:25;a:6:{s:8:\"pluginId\";i:45;s:13:\"threatLevelId\";i:1;s:4:\"name\";s:14:\"wponlinebackup\";s:14:\"minimumVersion\";s:3:\"0.0\";s:14:\"maximumVersion\";s:8:\"999999.0\";s:11:\"description\";s:18:\"Remove Immediately\";}i:26;a:6:{s:8:\"pluginId\";i:46;s:13:\"threatLevelId\";i:1;s:4:\"name\";s:33:\"yet-another-featured-posts-plugin\";s:14:\"minimumVersion\";s:3:\"0.0\";s:14:\"maximumVersion\";s:8:\"999999.0\";s:11:\"description\";s:18:\"Remove Immediately\";}i:27;a:6:{s:8:\"pluginId\";i:47;s:13:\"threatLevelId\";i:1;s:4:\"name\";s:32:\"yet-another-related-posts-plugin\";s:14:\"minimumVersion\";s:3:\"0.0\";s:14:\"maximumVersion\";s:6:\"5.30.5\";s:11:\"description\";s:18:\"Remove Immediately\";}i:28;a:6:{s:8:\"pluginId\";i:48;s:13:\"threatLevelId\";i:1;s:4:\"name\";s:12:\"sgcachepress\";s:14:\"minimumVersion\";s:3:\"0.0\";s:14:\"maximumVersion\";s:8:\"999999.0\";s:11:\"description\";s:18:\"Remove Immediately\";}i:29;a:6:{s:8:\"pluginId\";i:49;s:13:\"threatLevelId\";i:1;s:4:\"name\";s:9:\"synthesis\";s:14:\"minimumVersion\";s:3:\"0.0\";s:14:\"maximumVersion\";s:8:\"999999.0\";s:11:\"description\";s:18:\"Remove Immediately\";}i:30;a:6:{s:8:\"pluginId\";i:50;s:13:\"threatLevelId\";i:1;s:4:\"name\";s:15:\"wpengine-common\";s:14:\"minimumVersion\";s:3:\"0.0\";s:14:\"maximumVersion\";s:8:\"999999.0\";s:11:\"description\";s:18:\"Remove Immediately\";}i:31;a:6:{s:8:\"pluginId\";i:51;s:13:\"threatLevelId\";i:1;s:4:\"name\";s:16:\"6scan-protection\";s:14:\"minimumVersion\";s:3:\"0.0\";s:14:\"maximumVersion\";s:8:\"999999.0\";s:11:\"description\";s:18:\"Remove Immediately\";}i:32;a:6:{s:8:\"pluginId\";i:52;s:13:\"threatLevelId\";i:1;s:4:\"name\";s:12:\"6scan-backup\";s:14:\"minimumVersion\";s:3:\"0.0\";s:14:\"maximumVersion\";s:8:\"999999.0\";s:11:\"description\";s:18:\"Remove Immediately\";}i:33;a:6:{s:8:\"pluginId\";i:53;s:13:\"threatLevelId\";i:1;s:4:\"name\";s:9:\"statpress\";s:14:\"minimumVersion\";s:3:\"0.0\";s:14:\"maximumVersion\";s:8:\"999999.0\";s:11:\"description\";s:18:\"Remove Immediately\";}i:34;a:6:{s:8:\"pluginId\";i:54;s:13:\"threatLevelId\";i:1;s:4:\"name\";s:13:\"wp-fast-cache\";s:14:\"minimumVersion\";s:3:\"0.0\";s:14:\"maximumVersion\";s:8:\"999999.0\";s:11:\"description\";s:18:\"Remove Immediately\";}i:35;a:6:{s:8:\"pluginId\";i:55;s:13:\"threatLevelId\";i:1;s:4:\"name\";s:16:\"wp-fastest-cache\";s:14:\"minimumVersion\";s:3:\"0.0\";s:14:\"maximumVersion\";s:8:\"999999.0\";s:11:\"description\";s:18:\"Remove Immediately\";}i:36;a:6:{s:8:\"pluginId\";i:56;s:13:\"threatLevelId\";i:1;s:4:\"name\";s:11:\"wp-cachecom\";s:14:\"minimumVersion\";s:3:\"0.0\";s:14:\"maximumVersion\";s:8:\"999999.0\";s:11:\"description\";s:18:\"Remove Immediately\";}i:37;a:6:{s:8:\"pluginId\";i:57;s:13:\"threatLevelId\";i:1;s:4:\"name\";s:11:\"referrer-wp\";s:14:\"minimumVersion\";s:3:\"0.0\";s:14:\"maximumVersion\";s:8:\"999999.0\";s:11:\"description\";s:18:\"Remove Immediately\";}i:38;a:6:{s:8:\"pluginId\";i:58;s:13:\"threatLevelId\";i:1;s:4:\"name\";s:30:\"adsense-click-fraud-monitoring\";s:14:\"minimumVersion\";s:3:\"0.0\";s:14:\"maximumVersion\";s:8:\"999999.0\";s:11:\"description\";s:18:\"Remove Immediately\";}i:39;a:6:{s:8:\"pluginId\";i:59;s:13:\"threatLevelId\";i:1;s:4:\"name\";s:21:\"wordpress-beta-tester\";s:14:\"minimumVersion\";s:3:\"0.0\";s:14:\"maximumVersion\";s:8:\"999999.0\";s:11:\"description\";s:18:\"Remove Immediately\";}i:40;a:6:{s:8:\"pluginId\";i:60;s:13:\"threatLevelId\";i:1;s:4:\"name\";s:15:\"wp-copysafe-web\";s:14:\"minimumVersion\";s:3:\"0.0\";s:14:\"maximumVersion\";s:8:\"999999.0\";s:11:\"description\";s:18:\"Remove Immediately\";}i:41;a:6:{s:8:\"pluginId\";i:61;s:13:\"threatLevelId\";i:1;s:4:\"name\";s:15:\"wp-copysafe-pdf\";s:14:\"minimumVersion\";s:3:\"0.0\";s:14:\"maximumVersion\";s:8:\"999999.0\";s:11:\"description\";s:18:\"Remove Immediately\";}i:42;a:6:{s:8:\"pluginId\";i:62;s:13:\"threatLevelId\";i:1;s:4:\"name\";s:18:\"wysija-newsletters\";s:14:\"minimumVersion\";s:3:\"0.0\";s:14:\"maximumVersion\";s:5:\"2.6.7\";s:11:\"description\";s:18:\"Remove Immediately\";}i:43;a:6:{s:8:\"pluginId\";i:63;s:13:\"threatLevelId\";i:1;s:4:\"name\";s:7:\"wptouch\";s:14:\"minimumVersion\";s:3:\"0.0\";s:14:\"maximumVersion\";s:5:\"3.4.2\";s:11:\"description\";s:18:\"Remove Immediately\";}i:44;a:6:{s:8:\"pluginId\";i:64;s:13:\"threatLevelId\";i:1;s:4:\"name\";s:20:\"custom-contact-forms\";s:14:\"minimumVersion\";s:3:\"0.0\";s:14:\"maximumVersion\";s:7:\"5.1.0.3\";s:11:\"description\";s:18:\"Remove Immediately\";}i:45;a:6:{s:8:\"pluginId\";i:65;s:13:\"threatLevelId\";i:1;s:4:\"name\";s:23:\"wordpress-popular-posts\";s:14:\"minimumVersion\";s:3:\"0.0\";s:14:\"maximumVersion\";s:12:\"3.1.99999999\";s:11:\"description\";s:18:\"Remove Immediately\";}i:46;a:6:{s:8:\"pluginId\";i:66;s:13:\"threatLevelId\";i:1;s:4:\"name\";s:10:\"iwp-client\";s:14:\"minimumVersion\";s:3:\"0.0\";s:14:\"maximumVersion\";s:5:\"1.3.7\";s:11:\"description\";s:18:\"Remove Immediately\";}i:47;a:6:{s:8:\"pluginId\";i:67;s:13:\"threatLevelId\";i:1;s:4:\"name\";s:9:\"pagelines\";s:14:\"minimumVersion\";s:3:\"0.0\";s:14:\"maximumVersion\";s:5:\"1.4.5\";s:11:\"description\";s:18:\"Remove Immediately\";}i:48;a:6:{s:8:\"pluginId\";i:68;s:13:\"threatLevelId\";i:1;s:4:\"name\";s:8:\"platform\";s:14:\"minimumVersion\";s:3:\"0.0\";s:14:\"maximumVersion\";s:5:\"1.4.3\";s:11:\"description\";s:18:\"Remove Immediately\";}i:49;a:6:{s:8:\"pluginId\";i:69;s:13:\"threatLevelId\";i:1;s:4:\"name\";s:24:\"wp-ultimate-csv-importer\";s:14:\"minimumVersion\";s:3:\"0.0\";s:14:\"maximumVersion\";s:6:\"3.6.74\";s:11:\"description\";s:18:\"Remove Immediately\";}i:50;a:6:{s:8:\"pluginId\";i:70;s:13:\"threatLevelId\";i:1;s:4:\"name\";s:22:\"fancybox-for-wordpress\";s:14:\"minimumVersion\";s:3:\"0.0\";s:14:\"maximumVersion\";s:5:\"3.0.3\";s:11:\"description\";s:18:\"Remove Immediately\";}i:51;a:6:{s:8:\"pluginId\";i:71;s:13:\"threatLevelId\";i:1;s:4:\"name\";s:13:\"wordpress-seo\";s:14:\"minimumVersion\";s:3:\"0.0\";s:14:\"maximumVersion\";s:7:\"1.7.3.3\";s:11:\"description\";s:18:\"Remove Immediately\";}i:52;a:6:{s:8:\"pluginId\";i:74;s:13:\"threatLevelId\";i:1;s:4:\"name\";s:11:\"tdwordcount\";s:14:\"minimumVersion\";s:3:\"0.0\";s:14:\"maximumVersion\";s:8:\"999999.0\";s:11:\"description\";s:18:\"Remove Immediately\";}i:53;a:6:{s:8:\"pluginId\";i:76;s:13:\"threatLevelId\";i:1;s:4:\"name\";s:19:\"all-in-one-seo-pack\";s:14:\"minimumVersion\";s:3:\"0.0\";s:14:\"maximumVersion\";s:5:\"2.2.6\";s:11:\"description\";s:18:\"Remove Immediately\";}i:54;a:6:{s:8:\"pluginId\";i:77;s:13:\"threatLevelId\";i:1;s:4:\"name\";s:23:\"all-in-one-wp-migration\";s:14:\"minimumVersion\";s:3:\"0.0\";s:14:\"maximumVersion\";s:5:\"3.2.1\";s:11:\"description\";s:18:\"Remove Immediately\";}i:55;a:6:{s:8:\"pluginId\";i:78;s:13:\"threatLevelId\";i:1;s:4:\"name\";s:28:\"aspose-cloud-ebook-generator\";s:14:\"minimumVersion\";s:3:\"0.0\";s:14:\"maximumVersion\";s:3:\"1.0\";s:11:\"description\";s:18:\"Remove Immediately\";}i:56;a:6:{s:8:\"pluginId\";i:79;s:13:\"threatLevelId\";i:1;s:4:\"name\";s:19:\"aspose-doc-exporter\";s:14:\"minimumVersion\";s:3:\"0.0\";s:14:\"maximumVersion\";s:3:\"1.0\";s:11:\"description\";s:18:\"Remove Immediately\";}i:57;a:6:{s:8:\"pluginId\";i:80;s:13:\"threatLevelId\";i:1;s:4:\"name\";s:16:\"easy-coming-soon\";s:14:\"minimumVersion\";s:3:\"0.0\";s:14:\"maximumVersion\";s:5:\"1.6.2\";s:11:\"description\";s:18:\"Remove Immediately\";}i:58;a:6:{s:8:\"pluginId\";i:81;s:13:\"threatLevelId\";i:1;s:4:\"name\";s:31:\"favicon-by-realfavicongenerator\";s:14:\"minimumVersion\";s:3:\"0.0\";s:14:\"maximumVersion\";s:6:\"1.2.12\";s:11:\"description\";s:18:\"Remove Immediately\";}i:59;a:6:{s:8:\"pluginId\";i:82;s:13:\"threatLevelId\";i:1;s:4:\"name\";s:13:\"photo-gallery\";s:14:\"minimumVersion\";s:3:\"0.0\";s:14:\"maximumVersion\";s:6:\"1.2.14\";s:11:\"description\";s:18:\"Remove Immediately\";}i:60;a:6:{s:8:\"pluginId\";i:83;s:13:\"threatLevelId\";i:1;s:4:\"name\";s:30:\"google-analytics-for-wordpress\";s:14:\"minimumVersion\";s:3:\"0.0\";s:14:\"maximumVersion\";s:5:\"5.3.2\";s:11:\"description\";s:18:\"Remove Immediately\";}i:61;a:6:{s:8:\"pluginId\";i:84;s:13:\"threatLevelId\";i:1;s:4:\"name\";s:19:\"inboundio-marketing\";s:14:\"minimumVersion\";s:3:\"0.0\";s:14:\"maximumVersion\";s:3:\"2.0\";s:11:\"description\";s:18:\"Remove Immediately\";}i:62;a:6:{s:8:\"pluginId\";i:85;s:13:\"threatLevelId\";i:1;s:4:\"name\";s:5:\"leads\";s:14:\"minimumVersion\";s:3:\"0.0\";s:14:\"maximumVersion\";s:5:\"1.6.2\";s:11:\"description\";s:18:\"Remove Immediately\";}i:63;a:6:{s:8:\"pluginId\";i:86;s:13:\"threatLevelId\";i:1;s:4:\"name\";s:9:\"liveforms\";s:14:\"minimumVersion\";s:3:\"0.0\";s:14:\"maximumVersion\";s:5:\"3.0.1\";s:11:\"description\";s:18:\"Remove Immediately\";}i:64;a:6:{s:8:\"pluginId\";i:87;s:13:\"threatLevelId\";i:1;s:4:\"name\";s:7:\"miwoftp\";s:14:\"minimumVersion\";s:3:\"0.0\";s:14:\"maximumVersion\";s:5:\"1.0.4\";s:11:\"description\";s:18:\"Remove Immediately\";}i:65;a:6:{s:8:\"pluginId\";i:88;s:13:\"threatLevelId\";i:1;s:4:\"name\";s:11:\"mp3-jplayer\";s:14:\"minimumVersion\";s:3:\"0.0\";s:14:\"maximumVersion\";s:5:\"2.3.1\";s:11:\"description\";s:18:\"Remove Immediately\";}i:66;a:6:{s:8:\"pluginId\";i:89;s:13:\"threatLevelId\";i:1;s:4:\"name\";s:10:\"newsletter\";s:14:\"minimumVersion\";s:3:\"0.0\";s:14:\"maximumVersion\";s:5:\"3.7.1\";s:11:\"description\";s:18:\"Remove Immediately\";}i:67;a:6:{s:8:\"pluginId\";i:90;s:13:\"threatLevelId\";i:1;s:4:\"name\";s:15:\"nextgen-gallery\";s:14:\"minimumVersion\";s:3:\"0.0\";s:14:\"maximumVersion\";s:6:\"3.2.10\";s:11:\"description\";s:18:\"Remove Immediately\";}i:68;a:6:{s:8:\"pluginId\";i:91;s:13:\"threatLevelId\";i:1;s:4:\"name\";s:18:\"php-event-calendar\";s:14:\"minimumVersion\";s:3:\"0.0\";s:14:\"maximumVersion\";s:3:\"1.5\";s:11:\"description\";s:18:\"Remove Immediately\";}i:69;a:6:{s:8:\"pluginId\";i:92;s:13:\"threatLevelId\";i:1;s:4:\"name\";s:11:\"pluscaptcha\";s:14:\"minimumVersion\";s:3:\"0.0\";s:14:\"maximumVersion\";s:6:\"2.0.14\";s:11:\"description\";s:18:\"Remove Immediately\";}i:70;a:6:{s:8:\"pluginId\";i:93;s:13:\"threatLevelId\";i:1;s:4:\"name\";s:4:\"pods\";s:14:\"minimumVersion\";s:3:\"0.0\";s:14:\"maximumVersion\";s:7:\"2.5.1.1\";s:11:\"description\";s:18:\"Remove Immediately\";}i:71;a:6:{s:8:\"pluginId\";i:94;s:13:\"threatLevelId\";i:1;s:4:\"name\";s:44:\"ptengine-real-time-web-analytics-and-heatmap\";s:14:\"minimumVersion\";s:3:\"0.0\";s:14:\"maximumVersion\";s:5:\"1.0.1\";s:11:\"description\";s:18:\"Remove Immediately\";}i:72;a:6:{s:8:\"pluginId\";i:95;s:13:\"threatLevelId\";i:1;s:4:\"name\";s:15:\"ultimate-member\";s:14:\"minimumVersion\";s:3:\"0.0\";s:14:\"maximumVersion\";s:5:\"1.1.4\";s:11:\"description\";s:18:\"Remove Immediately\";}i:73;a:6:{s:8:\"pluginId\";i:96;s:13:\"threatLevelId\";i:1;s:4:\"name\";s:25:\"work-the-flow-file-upload\";s:14:\"minimumVersion\";s:3:\"0.0\";s:14:\"maximumVersion\";s:5:\"2.5.3\";s:11:\"description\";s:18:\"Remove Immediately\";}i:74;a:6:{s:8:\"pluginId\";i:97;s:13:\"threatLevelId\";i:1;s:4:\"name\";s:13:\"wp-all-import\";s:14:\"minimumVersion\";s:3:\"0.0\";s:14:\"maximumVersion\";s:5:\"3.2.5\";s:11:\"description\";s:18:\"Remove Immediately\";}i:75;a:6:{s:8:\"pluginId\";i:98;s:13:\"threatLevelId\";i:1;s:4:\"name\";s:29:\"wp-business-intelligence-lite\";s:14:\"minimumVersion\";s:3:\"0.0\";s:14:\"maximumVersion\";s:5:\"1.6.1\";s:11:\"description\";s:18:\"Remove Immediately\";}i:76;a:6:{s:8:\"pluginId\";i:99;s:13:\"threatLevelId\";i:1;s:4:\"name\";s:12:\"gravityforms\";s:14:\"minimumVersion\";s:3:\"0.0\";s:14:\"maximumVersion\";s:6:\"1.8.20\";s:11:\"description\";s:18:\"Remove Immediately\";}i:77;a:6:{s:8:\"pluginId\";i:100;s:13:\"threatLevelId\";i:1;s:4:\"name\";s:7:\"updraft\";s:14:\"minimumVersion\";s:3:\"0.0\";s:14:\"maximumVersion\";s:8:\"999999.0\";s:11:\"description\";s:18:\"Remove Immediately\";}i:78;a:6:{s:8:\"pluginId\";i:101;s:13:\"threatLevelId\";i:1;s:4:\"name\";s:14:\"wp-power-stats\";s:14:\"minimumVersion\";s:3:\"0.0\";s:14:\"maximumVersion\";s:8:\"999999.0\";s:11:\"description\";s:18:\"Remove Immediately\";}i:79;a:6:{s:8:\"pluginId\";i:102;s:13:\"threatLevelId\";i:1;s:4:\"name\";s:16:\"schram-kljsdfjkl\";s:14:\"minimumVersion\";s:3:\"1.1\";s:14:\"maximumVersion\";s:6:\"93.3.3\";s:11:\"description\";s:18:\"Remove Immediately\";}i:80;a:6:{s:8:\"pluginId\";i:103;s:13:\"threatLevelId\";i:1;s:4:\"name\";s:11:\"ninja-forms\";s:14:\"minimumVersion\";s:6:\"2.9.36\";s:14:\"maximumVersion\";s:6:\"2.9.42\";s:11:\"description\";s:18:\"Remove Immediately\";}i:81;a:6:{s:8:\"pluginId\";i:104;s:13:\"threatLevelId\";i:1;s:4:\"name\";s:33:\"woocommerce-smart-coupons-asdfghj\";s:14:\"minimumVersion\";s:3:\"0.0\";s:14:\"maximumVersion\";s:4:\"0.01\";s:11:\"description\";s:18:\"Remove Immediately\";}i:82;a:6:{s:8:\"pluginId\";i:105;s:13:\"threatLevelId\";i:1;s:4:\"name\";s:13:\"sg-cachepress\";s:14:\"minimumVersion\";s:3:\"0.0\";s:14:\"maximumVersion\";s:8:\"999999.0\";s:11:\"description\";s:18:\"Remove Immediately\";}i:83;a:6:{s:8:\"pluginId\";i:106;s:13:\"threatLevelId\";i:1;s:4:\"name\";s:6:\"wpclef\";s:14:\"minimumVersion\";s:3:\"0.0\";s:14:\"maximumVersion\";s:8:\"999999.0\";s:11:\"description\";s:18:\"Remove Immediately\";}i:84;a:6:{s:8:\"pluginId\";i:107;s:13:\"threatLevelId\";i:1;s:4:\"name\";s:2:\"p3\";s:14:\"minimumVersion\";s:3:\"0.0\";s:14:\"maximumVersion\";s:8:\"999999.0\";s:11:\"description\";s:18:\"Remove Immediately\";}i:85;a:6:{s:8:\"pluginId\";i:108;s:13:\"threatLevelId\";i:1;s:4:\"name\";s:20:\"wp-live-chat-support\";s:14:\"minimumVersion\";s:3:\"0.0\";s:14:\"maximumVersion\";s:6:\"8.0.32\";s:11:\"description\";s:18:\"Remove Immediately\";}i:86;a:6:{s:8:\"pluginId\";i:109;s:13:\"threatLevelId\";i:1;s:4:\"name\";s:11:\"slick-popup\";s:14:\"minimumVersion\";s:1:\"0\";s:14:\"maximumVersion\";s:5:\"1.7.1\";s:11:\"description\";s:18:\"Remove Immediately\";}i:87;a:6:{s:8:\"pluginId\";i:110;s:13:\"threatLevelId\";i:1;s:4:\"name\";s:18:\"wp-database-backup\";s:14:\"minimumVersion\";s:1:\"0\";s:14:\"maximumVersion\";s:3:\"5.2\";s:11:\"description\";s:18:\"Remove Immediately\";}i:88;a:6:{s:8:\"pluginId\";i:111;s:13:\"threatLevelId\";i:1;s:4:\"name\";s:26:\"real-time-find-and-replace\";s:14:\"minimumVersion\";s:1:\"0\";s:14:\"maximumVersion\";s:3:\"3.9\";s:11:\"description\";s:18:\"Remove Immediately\";}i:89;a:6:{s:8:\"pluginId\";i:112;s:13:\"threatLevelId\";i:1;s:4:\"name\";s:10:\"learnpress\";s:14:\"minimumVersion\";s:1:\"0\";s:14:\"maximumVersion\";s:7:\"3.2.6.7\";s:11:\"description\";s:18:\"Remove Immediately\";}i:90;a:6:{s:8:\"pluginId\";i:113;s:13:\"threatLevelId\";i:1;s:4:\"name\";s:9:\"lifterlms\";s:14:\"minimumVersion\";s:1:\"0\";s:14:\"maximumVersion\";s:7:\"3.37.14\";s:11:\"description\";s:18:\"Remove Immediately\";}i:91;a:6:{s:8:\"pluginId\";i:114;s:13:\"threatLevelId\";i:1;s:4:\"name\";s:8:\"sfwd-lms\";s:14:\"minimumVersion\";s:1:\"0\";s:14:\"maximumVersion\";s:5:\"3.1.5\";s:11:\"description\";s:18:\"Remove Immediately\";}i:92;a:6:{s:8:\"pluginId\";i:115;s:13:\"threatLevelId\";i:1;s:4:\"name\";s:12:\"optinmonster\";s:14:\"minimumVersion\";s:3:\"0.0\";s:14:\"maximumVersion\";s:5:\"2.6.2\";s:11:\"description\";s:18:\"Remove Immediately\";}i:93;a:6:{s:8:\"pluginId\";i:116;s:13:\"threatLevelId\";i:1;s:4:\"name\";s:11:\"updraftplus\";s:14:\"minimumVersion\";s:3:\"0.0\";s:14:\"maximumVersion\";s:6:\"1.23.2\";s:11:\"description\";s:18:\"Remove Immediately\";}i:94;a:6:{s:8:\"pluginId\";i:118;s:13:\"threatLevelId\";i:1;s:4:\"name\";s:16:\"download-manager\";s:14:\"minimumVersion\";s:3:\"0.0\";s:14:\"maximumVersion\";s:6:\"3.2.50\";s:11:\"description\";s:18:\"Remove Immediately\";}i:95;a:6:{s:8:\"pluginId\";i:119;s:13:\"threatLevelId\";i:1;s:4:\"name\";s:7:\"evalphp\";s:14:\"minimumVersion\";s:3:\"0.0\";s:14:\"maximumVersion\";s:8:\"999999.0\";s:11:\"description\";s:18:\"Remove Immediately\";}i:96;a:6:{s:8:\"pluginId\";i:120;s:13:\"threatLevelId\";i:1;s:4:\"name\";s:8:\"wp-reset\";s:14:\"minimumVersion\";s:3:\"0.0\";s:14:\"maximumVersion\";s:8:\"999999.0\";s:11:\"description\";s:18:\"Remove Immediately\";}i:97;a:6:{s:8:\"pluginId\";i:121;s:13:\"threatLevelId\";i:1;s:4:\"name\";s:17:\"advanced-wp-reset\";s:14:\"minimumVersion\";s:3:\"0.0\";s:14:\"maximumVersion\";s:8:\"999999.0\";s:11:\"description\";s:18:\"Remove Immediately\";}i:98;a:6:{s:8:\"pluginId\";i:122;s:13:\"threatLevelId\";i:1;s:4:\"name\";s:24:\"web-application-firewall\";s:14:\"minimumVersion\";s:3:\"0.0\";s:14:\"maximumVersion\";s:8:\"999999.0\";s:11:\"description\";s:18:\"Remove Immediately\";}i:99;a:6:{s:8:\"pluginId\";i:123;s:13:\"threatLevelId\";i:1;s:4:\"name\";s:29:\"miniorange-malware-protection\";s:14:\"minimumVersion\";s:3:\"0.0\";s:14:\"maximumVersion\";s:8:\"999999.0\";s:11:\"description\";s:18:\"Remove Immediately\";}i:100;a:6:{s:8:\"pluginId\";i:124;s:13:\"threatLevelId\";i:1;s:4:\"name\";s:17:\"email-subscribers\";s:14:\"minimumVersion\";s:3:\"0.0\";s:14:\"maximumVersion\";s:6:\"5.7.14\";s:11:\"description\";s:18:\"Remove Immediately\";}i:101;a:6:{s:8:\"pluginId\";i:126;s:13:\"threatLevelId\";i:1;s:4:\"name\";s:13:\"leadconnector\";s:14:\"minimumVersion\";s:3:\"0.0\";s:14:\"maximumVersion\";s:5:\"3.0.1\";s:11:\"description\";s:18:\"Remove Immediately\";}i:102;a:6:{s:8:\"pluginId\";i:133;s:13:\"threatLevelId\";i:1;s:4:\"name\";s:7:\"test123\";s:14:\"minimumVersion\";s:1:\"0\";s:14:\"maximumVersion\";s:1:\"1\";s:11:\"description\";s:18:\"Remove Immediately\";}}','off');
INSERT INTO `wp_79e54b1ec2_options` VALUES ('45512','elementor_pro_remote_info_api_data_3.11.2','a:2:{s:7:\"timeout\";i:1763984076;s:5:\"value\";s:248164:\"{\"stable_version\":\"3.33.1\",\"last_updated\":\"2025-11-11 12:11:42\",\"sections\":\"a:2:{s:11:\\\"description\\\";s:161:\\\"Elementor Pro adds new features to the Elementor Page Builder plugin. Control your conversions, your user engagement, your entire website, from one page builder.\\\";s:9:\\\"changelog\\\";s:233609:\\\"<h2>Elementor Pro - by Elementor.com<\\/h2>\\n<h4>3.33.1 - 2025-11-11<\\/h4>\\n<ul>\\n<li>Fix: Styles not loading correctly in Custom Fonts and Custom Icons admin screens (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/33396\\\">#33396<\\/a>)<\\/li>\\n<\\/ul>\\n<h4>3.33.0 - 2025-11-10<\\/h4>\\n<ul>\\n<li>New: Introducing Custom CSS for element-level styling with full isolation and responsive control - Editor V4<\\/li>\\n<li>New: Introducing media save to cloud in Website Templates, enabling users to store media assets directly in the cloud for easier access and management.<\\/li>\\n<li>Tweak: Added support for Post Excerpt dynamic tag - Editor V4<\\/li>\\n<li>Tweak: Added support for Internal URL dynamic tag - Editor V4<\\/li>\\n<li>Tweak: Added support for Post Terms dynamic tag - Editor V4<\\/li>\\n<li>Tweak: Added support for Shortcode dynamic tag - Editor V4<\\/li>\\n<li>Tweak: Added support for Popup dynamic tag - Editor V4<\\/li>\\n<li>Tweak: Added support for Off-Canvas dynamic tag - Editor V4<\\/li>\\n<li>Tweak: Added support for Lightbox dynamic tag - Editor V4<\\/li>\\n<li>Tweak: Added support for Add To Cart dynamic tag - Editor V4<\\/li>\\n<li>Tweak: Added support for ACF URL dynamic tag - Editor V4<\\/li>\\n<li>Tweak: Added support for Archive Title dynamic tag - Editor V4<\\/li>\\n<li>Tweak: Added support for the Email Contact URL dynamic tag - Editor V4<\\/li>\\n<li>Tweak: Added support for reduced-motion preferences in Flip Box widget<\\/li>\\n<li>Tweak: Updated minimum supported versions for Chrome, Firefox, and Safari<\\/li>\\n<li>Tweak: Updated Notes button location in the Editor Top Bar<\\/li>\\n<\\/ul>\\n<h4>3.32.3 - 2025-10-21<\\/h4>\\n<ul>\\n<li>Fix: Website Template fails to apply when Custom Code or Custom Icons are included<\\/li>\\n<\\/ul>\\n<h4>3.32.2 - 2025-09-29<\\/h4>\\n<ul>\\n<li>Fix: Exported taxonomies are not displayed correctly on the summary page in Website Templates export<\\/li>\\n<li>Fix: Certain taxonomies are not exported as expected in Website Templates export<\\/li>\\n<\\/ul>\\n<h4>3.32.1 - 2025-09-16<\\/h4>\\n<ul>\\n<li>Fix: Theme Builder fails to load when containers are disabled<\\/li>\\n<li>Fix: Popup and single product templates not imported or exported as expected<\\/li>\\n<\\/ul>\\n<h4>3.32.0 - 2025-09-15<\\/h4>\\n<ul>\\n<li>New: Introducing Size Variables to store and reuse numeric values across spacing, typography, layout, and borders - Editor V4<\\/li>\\n<li>New: Introducing granular Transitions with property-level control for advanced micro-animations - Editor V4<\\/li>\\n<li>New: Added granular content selection for Website Templates import and export, including pages, menus, post types, and taxonomies<\\/li>\\n<li>Tweak: Enhanced accessibility of background images in Slides widget with proper aria attributes (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/23543\\\">#23543<\\/a>, <a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/31063\\\">#31063<\\/a>)<\\/li>\\n<li>Tweak: Added REST API support for the Custom Code feature<\\/li>\\n<li>Tweak: Moved Background control from Content tab to Style tab in Flip Box widget<\\/li>\\n<li>Tweak: Removed SVG icons from the accessibility tree in Share Buttons widget<\\/li>\\n<li>Tweak: Removed dropdown indicator icons from the accessibility tree in WordPress Menu widget<\\/li>\\n<li>Fix: PHP 8.4 deprecation notices when running with <code>WP_DEBUG<\\/code> enabled<\\/li>\\n<li>Fix: Reduced-motion preferences are not applied to Animated Headline widget<\\/li>\\n<li>Fix: Reduced-motion preferences are not applied in Motion Effects<\\/li>\\n<li>Fix: Added required PHP and WordPress versions to the plugin header<\\/li>\\n<\\/ul>\\n<h4>3.31.3 - 2025-09-08<\\/h4>\\n<ul>\\n<li>Security Fix: Improved code security enforcement in WordPress Menu widget<\\/li>\\n<\\/ul>\\n<h4>3.31.2 - 2025-08-10<\\/h4>\\n<ul>\\n<li>Tweak: Improved release version functionality<\\/li>\\n<\\/ul>\\n<h4>3.31.1 - 2025-08-06<\\/h4>\\n<ul>\\n<li>Tweak: Updated <code>form-data<\\/code> package version<\\/li>\\n<\\/ul>\\n<h4>3.31.0 - 2025-08-05<\\/h4>\\n<ul>\\n<li>New: Introducing Attributes - add custom HTML attributes to elements for advanced control - Editor V4<\\/li>\\n<li>Tweak: Optimized Custom Code styles by removing redundant RTL file<\\/li>\\n<li>Tweak: Improved performance by loading ribbon styles only when used in Call to Action and Price Table widgets<\\/li>\\n<li>Tweak: Improved semantic markup structure for header and footer documents<\\/li>\\n<li>Tweak: Reorganized design controls in Animated Headline widget<\\/li>\\n<li>Tweak: Reorganized design controls in Blockquote widget<\\/li>\\n<li>Tweak: Reorganized design controls in Countdown widget<\\/li>\\n<li>Tweak: Replaced SASS mixins and functions with native CSS logical properties<\\/li>\\n<li>Fix: Empty headers are rendered in Table of Contents widget (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/28167\\\">#28167<\\/a>)<\\/li>\\n<li>Fix: <code>TypeError<\\/code> bug in Menu widget<\\/li>\\n<\\/ul>\\n<h4>3.30.1 - 2025-07-22<\\/h4>\\n<ul>\\n<li>Security Fix: Improved content sanitization in multiple widgets<\\/li>\\n<li>Fix: UI issue in Hotspot widget when Optimized Markup experiment is enabled<\\/li>\\n<li>Fix: Taxonomy filter not working in the Editor when Optimized Markup experiment is enabled<\\/li>\\n<\\/ul>\\n<h4>3.30.0 - 2025-07-01<\\/h4>\\n<ul>\\n<li>New: Introduced Full Website Templates in the Cloud - export, manage, and reuse full site kits across all your websites from one place<\\/li>\\n<li>Tweak: Activated &quot;Optimized Markup&quot; feature on new sites<\\/li>\\n<li>Tweak: Activated &quot;Menu&quot; feature on new sites<\\/li>\\n<li>Tweak: Improved error handling for Theme Builder display conditions<\\/li>\\n<li>Tweak: Added styling controls to Post Excerpt widget<\\/li>\\n<li>Tweak: Improved accessibility with <code>role<\\/code> and <code>aria-label<\\/code> attributes Post Navigation widget<\\/li>\\n<li>Tweak: Added <code>aria-label<\\/code> in Form widget<\\/li>\\n<li>Tweak: Added <code>aria-label<\\/code> in Login widget<\\/li>\\n<li>Tweak: Arranged content as lists in Portfolio and Posts widgets<\\/li>\\n<li>Tweak: Added Box Shadow and Text Shadow controls in Countdown widget<\\/li>\\n<li>Tweak: Moved image resolution control to content tab in Price List widget<\\/li>\\n<li>Tweak: Renamed and reorganized style sections in Price List widget<\\/li>\\n<li>Tweak: Added conditional logic to controls in Price Table widget<\\/li>\\n<li>Tweak: Grouped layout controls under list section in Price List widget<\\/li>\\n<li>Tweak: Updated minimum required WordPress version to 6.6<\\/li>\\n<li>Fix: Inline font icons support doesn\'t work in Post Navigation widget (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/24367\\\">#24367<\\/a>, <a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/18343\\\">#18343<\\/a>)<\\/li>\\n<li>Fix: Page Title condition doesn\'t work on child pages in Widget Display Conditions<\\/li>\\n<li>Fix: Editor users with &quot;Access to edit content only&quot; are able to delete elements<\\/li>\\n<li>Fix: Links are not crawlable in Video Playlist widget<\\/li>\\n<li>Fix: Uses hardcoded admin fonts in Video Playlist widget<\\/li>\\n<li>Fix: Editor freezes when the Form widget is used with a high PHP upload size limit<\\/li>\\n<li>Fix: Errors occur when Debug mode is enabled in Slides widget<\\/li>\\n<li>Fix: Plugin dependency not enforced in Elementor Pro<\\/li>\\n<li>Fix: Console shows deprecation warning in Global Widgets<\\/li>\\n<\\/ul>\\n<h4>3.29.2 - 2025-06-04<\\/h4>\\n<ul>\\n<li>Tweak: Added selectors to Menu widget for compatibility with Optimized Markup experiment<\\/li>\\n<\\/ul>\\n<h4>3.29.1 - 2025-05-28<\\/h4>\\n<ul>\\n<li>Security Fix: Improved code security enforcement in Animated Headline widget<\\/li>\\n<li>Security Fix: Improved code security enforcement in Price Table widget<\\/li>\\n<\\/ul>\\n<h4>3.29.0 - 2025-05-19<\\/h4>\\n<ul>\\n<li>New: Introduced Cloud Templates - save, manage, and reuse your templates across all your sites from a single cloud library<\\/li>\\n<li>Tweak: Improved accessibility with <code>role<\\/code> attributes in Share Buttons widget<\\/li>\\n<li>Tweak: Improved accessibility by grouping content with <code>role=region<\\/code> in the Video Playlist widget<\\/li>\\n<li>Fix: Focus color is not applied correctly for accessibility in WordPress Menu widget (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/24239\\\">#24239<\\/a>)<\\/li>\\n<li>Fix: Common scripts loaded late when using the Theme Builder<\\/li>\\n<\\/ul>\\n<h4>3.28.4 - 2025-05-05<\\/h4>\\n<ul>\\n<li>Fix: Empty results appeared on the frontend when using the Taxonomy Filter with the \'Avoid Duplicates\' option in Loop Grid widget<\\/li>\\n<li>Fix: Errors occur when Debug mode is enabled and the Optimized Markup experiment is active<\\/li>\\n<\\/ul>\\n<h4>3.28.3 - 2025-04-16<\\/h4>\\n<ul>\\n<li>Tweak: Improved sidebar navigation flow on the Elementor Home screen<\\/li>\\n<\\/ul>\\n<h4>3.28.2 - 2025-03-30<\\/h4>\\n<ul>\\n<li>Fix: Default Elementor animation shown for logged-out users when using an &quot;External URL&quot; source in Lottie widget<\\/li>\\n<\\/ul>\\n<h4>3.28.1 - 2025-03-23<\\/h4>\\n<ul>\\n<li>Security Fix: Improved code security enforcement in Animated Headline and Form widgets<\\/li>\\n<\\/ul>\\n<h4>3.28.0 - 2025-03-17<\\/h4>\\n<ul>\\n<li>Tweak: Ensured File Upload field styles are overridden by global styles in Form widget (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/11651\\\">#11651<\\/a>, <a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/17223\\\">#17223<\\/a>)<\\/li>\\n<li>Tweak: Updated Scroll Snap description to clarify incompatibility with animations and motion effects<\\/li>\\n<li>Tweak: Prevented special characters from being encoded in the email subject field in Form widget<\\/li>\\n<li>Tweak: Loaded module styles within the module instead of registering them in <code>plugin.php<\\/code><\\/li>\\n<li>Tweak: Updated minimum required WordPress version to 6.5<\\/li>\\n<li>Tweak: Improved keyboard accessibility for menus in Editor Top Bar<\\/li>\\n<li>Tweak: Made the edit button accessible in the Template widget<\\/li>\\n<li>Tweak: Optimized Form widget performance by caching field assets <code>using get_style_depends()<\\/code> and <code>get_script_depends()<\\/code> methods<\\/li>\\n<li>Tweak: Added Text Shadow control in Testimonial Carousel, Call to Action and Animated Headline widgets<\\/li>\\n<li>Fix: Button icon alignment breaks when Inline Font Icons feature is activated (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/16077\\\">#16077<\\/a>, <a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/16511\\\">#16511<\\/a>, <a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/17692\\\">#17692<\\/a>, <a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/17922\\\">#17922<\\/a>, <a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/19253\\\">#19253<\\/a>, <a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/19370\\\">#19370<\\/a>, <a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/21236\\\">#21236<\\/a>, <a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/21844\\\">#21844<\\/a>, <a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/28080\\\">#28080<\\/a>)<\\/li>\\n<li>Fix: Dropdown caret color did not follow menu item color when Inline Font Icons feature is activated (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/17500\\\">#17500<\\/a>, <a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/18466\\\">#18466<\\/a>, <a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/21664\\\">#21664<\\/a>, <a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/24929\\\">#24929<\\/a>, <a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/28064\\\">#28064<\\/a>)<\\/li>\\n<li>Fix: Page doesn\'t scroll up when a coupon error notice appears in Checkout widget<\\/li>\\n<\\/ul>\\n<h4>3.27.7 - 2025-03-13<\\/h4>\\n<ul>\\n<li>Security Fix: Improved code security enforcement in Lottie widget<\\/li>\\n<\\/ul>\\n<h4>3.27.6 - 2025-03-10<\\/h4>\\n<ul>\\n<li>Security Fix: Improved code security enforcement in Template Condition<\\/li>\\n<\\/ul>\\n<h4>3.27.5 - 2025-03-03<\\/h4>\\n<ul>\\n<li>Fix: The <code>wp_trigger_error<\\/code> function causes the site to crash instead of triggering a warning when used with ACF text<\\/li>\\n<\\/ul>\\n<h4>3.27.4 - 2025-02-16<\\/h4>\\n<ul>\\n<li>Security Fix: Improved code security enforcement in Screenshots module<\\/li>\\n<li>Security Fix: Improved code security enforcement in Query control<\\/li>\\n<li>Fix: ACF <code>true_false<\\/code> field causing a fatal error when used as a dynamic tag with third-party plugins (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/30170\\\">#30170<\\/a>)<\\/li>\\n<\\/ul>\\n<h4>3.27.3 - 2025-02-06<\\/h4>\\n<ul>\\n<li>Security Fix: Improved code security enforcement in Stripe Button widget<\\/li>\\n<\\/ul>\\n<h4>3.27.2 - 2025-02-03<\\/h4>\\n<ul>\\n<li>Fix: Value type configuration issue causing errors when using ACF<\\/li>\\n<li>Fix: Hide content on responsive breakpoint option is not working on WordPress Menu widget when Optimized Markup experiment is activated<\\/li>\\n<\\/ul>\\n<h4>3.27.1 - 2025-01-27<\\/h4>\\n<ul>\\n<li>Tweak: Increased the number of items allowed in Dynamic Tags options in Display Conditions for Elements<\\/li>\\n<li>Security Fix: Improved code security enforcement in Global widget<\\/li>\\n<li>Security Fix: Improved code security enforcement in Lottie widget<\\/li>\\n<li>Security Fix: Improved code security enforcement in Admin settings<\\/li>\\n<li>Fix: Accessible navigation in popups caused unintended scrolling of the page when triggered (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/29175\\\">#29175<\\/a>)<\\/li>\\n<li>Fix: Empty custom fields are missing in the Dynamic Tags options in Display Conditions for Elements<\\/li>\\n<\\/ul>\\n<h4>3.27.0 - 2025-01-20<\\/h4>\\n<ul>\\n<li>Tweak: Removed the <code>elementor-widget-container<\\/code> div from the Menu, Loop, Table of Contents, Form, and Hotspot widgets as part of the Optimized Markup experiment to improve HTML structure<\\/li>\\n<li>Tweak: Reduced DOM size by optimizing the submit button markup in Search widget<\\/li>\\n<li>Tweak: Moved style loading to the head instead of the footer to improve CLS<\\/li>\\n<li>Tweak: Enabled conditional loading of Swiper.js based on widget dependencies to reduce unnecessary assets and improve page load times<\\/li>\\n<li>Tweak: Standardized navigation elements like arrows and bullets across all carousel and slider widgets for improved accessibility<\\/li>\\n<li>Tweak: Improved accessibility when the submit button has only an icon and no text in Search widget<\\/li>\\n<li>Tweak: Removed <code>load_plugin_textdomain()<\\/code> function from Elementor Pro<\\/li>\\n<\\/ul>\\n<h4>3.26.3 - 2025-01-07<\\/h4>\\n<ul>\\n<li>Security Fix: Improved code security enforcement in Search widget<\\/li>\\n<li>Fix: Height issues cause slideshow thumbnails to display incorrectly in Media Carousel (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/29663\\\">#29663<\\/a>)<\\/li>\\n<\\/ul>\\n<h4>3.26.2 - 2024-12-22<\\/h4>\\n<ul>\\n<li>Fix: Menu items are not clickable in various scenarios in Menu widget (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/29191\\\">#29191<\\/a>)<\\/li>\\n<\\/ul>\\n<h4>3.26.1 - 2024-12-17<\\/h4>\\n<ul>\\n<li>Fix: Restore deprecated <code>Plugin::enqueue_styles()<\\/code> function to avoid errors with 3rd party plugins<\\/li>\\n<\\/ul>\\n<h4>3.26.0 - 2024-12-16<\\/h4>\\n<ul>\\n<li>New: Introducing dynamic content support for Off-canvas in Loop Grid widget templates - enabling seamless display of additional content dynamically (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/29049\\\">#29049<\\/a>, <a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/28935\\\">#28935<\\/a>, <a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/7106\\\">#7106<\\/a>)<\\/li>\\n<li>New: AdBlock Detection trigger for Popups - display targeted popups for visitors using ad blockers<\\/li>\\n<li>New: Added Reload Page link action for Dynamic Tags<\\/li>\\n<li>Tweak: Added &quot;Space Between Dots&quot; control to Carousel widgets (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/2526\\\">#2526<\\/a>, <a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/3277\\\">#3277<\\/a>, <a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/21697\\\">#21697<\\/a>)<\\/li>\\n<li>Tweak: Replaced hidden <code>elementor-screen-only<\\/code> div with <code>aria-label<\\/code> attributes<\\/li>\\n<li>Tweak: Removed <code>elementor-widget-container<\\/code> div from Elementor widgets as part of the Optimized Markup experiment<\\/li>\\n<li>Tweak: Optimize popup styling by loading it only when necessary<\\/li>\\n<li>Tweak: Updated Gap between slides control to support only PX units in Carousel widget<\\/li>\\n<li>Tweak: Removed the dependency between the Tabs handler and the Menu handler<\\/li>\\n<li>Tweak: Added the ability to set <code>aria-label<\\/code> in Carousel widgets<\\/li>\\n<li>Tweak: Added <code>aria-roledescription=carousel<\\/code> to carousel wrapper<\\/li>\\n<li>Tweak: Added <code>aria-roledescription=slide<\\/code> to slide wrapper<\\/li>\\n<li>Tweak: Optimized carousel widgets markup as part of the Optimized Markup experiment<\\/li>\\n<li>Tweak: Updated minimum required Safari version to 15.5<\\/li>\\n<li>Tweak: Facebook widgets are no longer supported on mobile due to Facebook functionality changes<\\/li>\\n<li>Fix: Motion Effects sticky feature is not working when Scroll Snap is enabled<\\/li>\\n<li>Fix: Custom Image Resolution option is not working in Gallery widget<\\/li>\\n<li>Fix: \'Reading Settings\' unexpectedly reduces the number of posts displayed when using the Archive with Pagination setting<\\/li>\\n<li>Fix: Step Form does not scroll to the top when the first field is not an input field in Form widget<\\/li>\\n<li>Fix: Display Condition feature is available without an active Elementor license in Floating Elements<\\/li>\\n<li>Fix: Background options of Flip Box in Loop Grid widget are not working when images are added using ACF Dynamic Tags<\\/li>\\n<li>Fix: Dropdown icon in the Select field of the Form widget is cut off when the Inline Font Icons feature is activated<\\/li>\\n<li>Fix: Incompatibility between Form widget and WPML when using Nested Elements<\\/li>\\n<li>Fix: Performance issues when changing the title name in the Menu widget<\\/li>\\n<li>Fix: Warnings appear when Element Caching is set to Inactive in Carousel widgets<\\/li>\\n<li>Fix: Swiper styling missing from Lightbox inside Gallery widgets<\\/li>\\n<\\/ul>\\n<h4>3.25.5 - 2024-12-10<\\/h4>\\n<ul>\\n<li>Security Fix: Improved code security enforcement in Form widget<\\/li>\\n<li>Fix: Accessible navigation in popups caused unintended scrolling of the page when triggered (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/29175\\\">#29175<\\/a>)<\\/li>\\n<li>Fix: Popup overlay shown for non-logged users even when disabled<\\/li>\\n<\\/ul>\\n<h4>3.25.4 - 2024-11-20<\\/h4>\\n<ul>\\n<li>Tweak: Improved Global Widget loading method to enhance performance<\\/li>\\n<\\/ul>\\n<h4>3.25.3 - 2024-11-13<\\/h4>\\n<ul>\\n<li>Fix: Nested Elements are activated even when the Container experiment is inactive<\\/li>\\n<\\/ul>\\n<h4>3.25.2 - 2024-11-03<\\/h4>\\n<ul>\\n<li>Fix: Styling issues affecting popup layout when using a Dynamic Tag to open the popup<\\/li>\\n<li>Fix: Image captions are not displaying for non-logged-in users in Media Carousel widget<\\/li>\\n<li>Fix: Custom Add to Cart widget with Quantity enabled causes critical error (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/29159\\\">#29159<\\/a>)<\\/li>\\n<\\/ul>\\n<h4>3.25.1 - 2024-10-31<\\/h4>\\n<ul>\\n<li>Fix: Multiple Custom Add to Cart widgets on the same page are adding the same product<\\/li>\\n<\\/ul>\\n<h4>3.25.0 - 2024-10-28<\\/h4>\\n<ul>\\n<li>Tweak: Added pagination functionality to the Live Results in Search widget<\\/li>\\n<li>Tweak: Added Anchor Offset control to allow precise positioning when scrolling to anchor links on the page<\\/li>\\n<li>Tweak: Load motion effects styles only when they are in use<\\/li>\\n<li>Tweak: Load sticky styles only when they are in use<\\/li>\\n<li>Tweak: Load popup styles only when they are in use<\\/li>\\n<li>Tweak: Load theme builder styles only when they are in use<\\/li>\\n<li>Tweak: Load transition styles for Call to Action and Gallery widgets only when they are in use<\\/li>\\n<li>Tweak: Load styles for Form widgets separately to enhance performance<\\/li>\\n<li>Tweak: Load styles for WooCommerce widgets separately to enhance performance<\\/li>\\n<li>Tweak: Load styles for Theme Elements widgets separately to enhance performance<\\/li>\\n<li>Tweak: Load styles for Carousel widgets separately to enhance performance<\\/li>\\n<li>Tweak: Load styles for Pricing widgets separately to enhance performance<\\/li>\\n<li>Tweak: Load styles for Floating Elements separately to enhance performance<\\/li>\\n<li>Tweak: Load styles for Link in Bio widgets separately to enhance performance<\\/li>\\n<li>Tweak: Load minified CSS in the Loop Builder\'s Call to Action button in the Editor<\\/li>\\n<li>Tweak: Removed &quot;Payments&quot; module styles<\\/li>\\n<li>Tweak: Removed <code>elementor-button-wrapper<\\/code> div from Payapl widget as part of the Optimized Markup experiment<\\/li>\\n<li>Tweak: Removed <code>elementor-button-wrapper<\\/code> div from Stripe widget as part of the Optimized Markup experiment<\\/li>\\n<li>Tweak: Merged &quot;Form Submissions&quot; feature into the version and moved it to the Advanced tab<\\/li>\\n<li>Tweak: Merged &quot;Display Conditions&quot; into the version<\\/li>\\n<li>Fix: Missing translation string for the empty message in the Table of Contents widget (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/27580\\\">#27580<\\/a>)<\\/li>\\n<li>Fix: Local Storage and Session Storage were being used even when popups were not in use (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/7151\\\">#7151<\\/a>)<\\/li>\\n<li>Fix: Masonry layout is not working when pagination is set to &quot;Load More&quot; or &quot;Infinite Scroll&quot; in Loop Grid widget (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/23684\\\">#23684<\\/a>)<\\/li>\\n<li>Fix: Extra gap between widgets on the frontend when using Off-canvas widget (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/27706\\\">#27706<\\/a>)<\\/li>\\n<li>Fix: Pagination and custom queries did not work when the Posts Widget was saved as a Global Widget or used via shortcode<\\/li>\\n<li>Fix: Lightbox videos are missing controls and displayed at the wrong size in Media Carousel widget<\\/li>\\n<li>Fix: Pagination options with Individual Pagination not working as expected in Posts and Loop Grid widgets<\\/li>\\n<li>Fix: Justified or Masonry layouts for the Pro Gallery would not display images on the frontend when inserted via nested tabs<\\/li>\\n<li>Fix: Error issue in the Loop Grid widget when used in theme parts with the Taxonomy Filter<\\/li>\\n<li>Fix: Removed the focus ring after clicking to open the Off Canvas inside the Editor<\\/li>\\n<li>Fix: Background gradient colors from the dynamic color tag values are not rendering on the frontend<\\/li>\\n<li>Fix: Excessive database requests generated by the Loop Grid widget<\\/li>\\n<li>Fix: Colors from Dynamic Tags were not rendered on the frontend<\\/li>\\n<li>Fix: Display issue in the Menu widget caused by the \'Native Intersection Observer API<\\/li>\\n<li>Fix: Dropdown area not working in certain scenarios in Menu widget<\\/li>\\n<li>Fix: Content Width control inside the Mega Menu is displaying an empty value<\\/li>\\n<\\/ul>\\n<h4>3.24.4 - 2024-10-09<\\/h4>\\n<ul>\\n<li>Security Fix: Improved code security enforcement in Media Carousel widget<\\/li>\\n<\\/ul>\\n<h4>3.24.3 - 2024-10-01<\\/h4>\\n<ul>\\n<li>Fix: Floating Elements template not loading when Single Page template is set with All Singular condition<\\/li>\\n<li>Fix: Form field styles not loading properly in various scenarios<\\/li>\\n<\\/ul>\\n<h4>3.24.2 - 2024-09-18<\\/h4>\\n<ul>\\n<li>Fix: Icons not displaying when Inline SVG Icons experiment is active in Link In Bio widgets and Floating Elements<\\/li>\\n<\\/ul>\\n<h4>3.24.1 - 2024-09-12<\\/h4>\\n<ul>\\n<li>Fix: Widget styles not loading correctly on front causing alignment inconsistencies (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/28676\\\">#28676<\\/a>)<\\/li>\\n<\\/ul>\\n<h4>3.24.0 - 2024-09-10<\\/h4>\\n<ul>\\n<li>New: Introducing support for Variable Fonts - allowing for more dynamic and flexible text styling (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/6703\\\">#6703<\\/a>, <a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/11333\\\">#11333<\\/a>, <a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/19277\\\">#19277<\\/a>, <a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/25485\\\">#25485<\\/a>)<\\/li>\\n<li>Tweak: Added \'Structure\' indication for widgets with Display Conditions applied (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/28027\\\">#28027<\\/a>)<\\/li>\\n<li>Tweak: Added a new option for setting the live search results width (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/28280\\\">#28280<\\/a>)<\\/li>\\n<li>Tweak: Improved Honeypot field functionality in Form widget (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/28480\\\">#28480<\\/a>)<\\/li>\\n<li>Tweak: Added options to \'Copy\', \'Paste\', and \'Clear\' Display Conditions in Context Menu<\\/li>\\n<li>Tweak: Improved performance of the Menu widget when using Dynamic Tags in the URL field<\\/li>\\n<li>Tweak: Improved performance when using Dynamic Tags in Nested Elements<\\/li>\\n<li>Tweak: Added the option for users to disable Akismet for specific Elementor forms<\\/li>\\n<li>Tweak: Adjusted URL structure when presenting the Search Archive page in Search widget<\\/li>\\n<li>Tweak: Added the \'Create Template\' button in Search widget<\\/li>\\n<li>Tweak: Added an option to enable the \'Loader\' animation while live results are loading in Search widget<\\/li>\\n<li>Tweak: Load share buttons compatibility styles only when they are in use<\\/li>\\n<li>Tweak: Load dialog styles only when they are in use<\\/li>\\n<li>Tweak: Load global widget styles only during Editor preview<\\/li>\\n<li>Tweak: Conditionally load widget styles only when the widgets are used<\\/li>\\n<li>Tweak: Load styles for CTA hover animations only when they are in use<\\/li>\\n<li>Tweak: Load notes styles only when the WordPress Toolbar is displayed<\\/li>\\n<li>Tweak: Split <code>animations.min.css<\\/code> into multiple CSS files and load them conditionally<\\/li>\\n<li>Tweak: Promoted Display Conditions feature to Stable status<\\/li>\\n<li>Tweak: Merged Taxonomy Filter feature into the version<\\/li>\\n<li>Tweak: Merged Search feature into the version<\\/li>\\n<li>Tweak: Added a note to \'Current Query\' explaining the impact of WordPress settings on pagination within Archives<\\/li>\\n<li>Tweak: Added the ability to set <code>aria-label<\\/code> for the Off-Canvas widget<\\/li>\\n<li>Fix: Manual Selection option is not excluding sticky posts in Posts and Loop Grid widgets (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/18689\\\">#18689<\\/a>, <a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/23331\\\">#23331<\\/a>, <a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/28179\\\">#28179<\\/a>)<\\/li>\\n<li>Fix: Template ID does not change according to the imported Loop Item (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/21404\\\">#21404<\\/a>, <a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/22202\\\">#22202<\\/a>)<\\/li>\\n<li>Fix: \'Editing Mode\' for the Off-canvas was not functioning correctly in certain scenarios<\\/li>\\n<li>Fix: Added definition to <code>clear_custom_image_sizes<\\/code> hook to prevent edge case issues<\\/li>\\n<li>Fix: Flickering issue with search result buttons when closing results using the keyboard escape key in Search widget<\\/li>\\n<li>Fix: Theme Style settings for buttons were overriding the text styling in Search widget<\\/li>\\n<li>Fix: Nesting menu inside another menu causes functionality issues in Menu widget<\\/li>\\n<li>Fix: Error when using array as custom fields value in Dynamic Tags<\\/li>\\n<\\/ul>\\n<h4>3.23.3 - 2024-08-05<\\/h4>\\n<ul>\\n<li>Fix: Dropdown area not working in certain scenarios in Menu widget (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/28194\\\">#28194<\\/a>)<\\/li>\\n<\\/ul>\\n<h4>3.23.2 - 2024-07-29<\\/h4>\\n<ul>\\n<li>Fix: Horizontal scroll bar appearing on the page when using Menu widget (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/28087\\\">#28087<\\/a>)<\\/li>\\n<li>Fix: Dropdown area disappearing in certain scenarios in Menu widget<\\/li>\\n<\\/ul>\\n<h4>3.23.1 - 2024-07-23<\\/h4>\\n<ul>\\n<li>Security Fix: Improved code security enforcement in link URL<\\/li>\\n<\\/ul>\\n<h4>3.23.0 - 2024-07-15<\\/h4>\\n<ul>\\n<li>New: Search Widget with Live Results - Display live search results as visitors type into the search box, enhancing user experience and engagement (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/27664\\\">#27664<\\/a>, <a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/24931\\\">#24931<\\/a>, <a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/21459\\\">#21459<\\/a>)<\\/li>\\n<li>Tweak: Renamed <code>width<\\/code> to <code>Min width<\\/code> and added <code>Max width<\\/code> control to Hotspot tooltips (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/18930\\\">#18930<\\/a>)<\\/li>\\n<li>Tweak: Applied a logical DOM order to the Mega Menu widget to improve accessibility<\\/li>\\n<li>Tweak: Added the ability to set <code>aria-label<\\/code> for WordPress Menu widget<\\/li>\\n<li>Tweak: Added the ability to set <code>aria-label<\\/code> for Menu widget<\\/li>\\n<li>Tweak: Added a bottom option to the Image Position control in Call to Action widget<\\/li>\\n<li>Fix: Missing version string in included CSS query string when Improved CSS Loading is enabled (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/21879\\\">#21879<\\/a>, <a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/23821\\\">#23821<\\/a>)<\\/li>\\n<li>Fix: Form submission icon message does not display correctly when Inline Font Icons feature is activated<\\/li>\\n<li>Fix: Save and Close button position issues in the conditions screen in Theme Builder.<\\/li>\\n<li>Fix: Focus appears on the first element when using the mouse to open Off-Canvas <\\/li>\\n<li>Fix: Links to Elementor Settings are broken in various locations<\\/li>\\n<li>Fix: Conditions field not showing all relevant conditions in Theme Builder<\\/li>\\n<li>Fix: Off-Canvas flickering in sticky containers with exit animations triggered by sticky effects<\\/li>\\n<\\/ul>\\n<h4>3.22.1 - 2024-06-24<\\/h4>\\n<ul>\\n<li>Fix: Styling of Global widgets not loading when Element Caching experiment is activated (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/27704\\\">#27704<\\/a>)<\\/li>\\n<\\/ul>\\n<h4>3.22.0 - 2024-06-16<\\/h4>\\n<ul>\\n<li>New: Introducing Off-Canvas widget - create engaging and creative layers triggered by a link (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/6225\\\">#6225<\\/a>, <a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/21769\\\">#21769<\\/a>, <a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/25770\\\">#25770<\\/a>)<\\/li>\\n<li>Tweak: Added option to remove \'User IP\' and \'User Agent\' from the form submissions metadata (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/14285\\\">#14285<\\/a>)<\\/li>\\n<li>Tweak: Replaced <code>waypoints.js<\\/code> library with the native Intersection Observer API<\\/li>\\n<li>Tweak: Extended Alignment and Position capabilities in Form widget<\\/li>\\n<li>Tweak: Moved icon View control to style tab in Flip Box widget<\\/li>\\n<li>Tweak: Moved icon View control to style tab in Call to Action widget<\\/li>\\n<li>Tweak: Optimized Form widget to eliminate unnecessary markup when the button icon is empty<\\/li>\\n<li>Tweak: Optimized Posts widget to eliminate unnecessary markup when Load More button text is empty<\\/li>\\n<li>Tweak: Remove <code>placeholder<\\/code> arguments from URL controls<\\/li>\\n<li>Tweak: Implemented CSS logical properties to Icon Position in Form, Posts and Menu Cart widgets<\\/li>\\n<li>Tweak: Activated Display Conditions feature for existing sites<\\/li>\\n<li>Tweak: Activated Taxonomy Filter feature for existing sites<\\/li>\\n<li>Tweak: Added functionality to delay the running of the ready triggers on inner elements<\\/li>\\n<li>Fix: Icons are now part of the link in the Menu Widget (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/24298\\\">#24298<\\/a>, <a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/25112\\\">#25112<\\/a>)<\\/li>\\n<li>Fix: <code>all: unset<\\/code> assigned to buttons cause focus issues (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/24322\\\">#24322<\\/a>, <a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/25448\\\">#25448<\\/a>)<\\/li>\\n<li>Fix: Menu cart SVG icon disappears on front when Optimized Control Loading experiment is activated (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/27342\\\">#27342<\\/a>)<\\/li>\\n<li>Fix: Elementor Pro auto-updates are not working on multisite networks (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/12615\\\">#12615<\\/a>)<\\/li>\\n<li>Fix: PHP error appears in the editor when using Loop Grid in an archive template<\\/li>\\n<li>Fix: UI glitch on Icon Position control in Paypal and Stripe Buttons widgets<\\/li>\\n<li>Fix: Icon Position control RTL issue in Hotspot widget<\\/li>\\n<li>Fix: Manual Selection &quot;Include By&quot; Query doesn\'t work with product categories<\\/li>\\n<\\/ul>\\n<h4>3.21.3 - 2024-05-20<\\/h4>\\n<ul>\\n<li>Security Fix: Improved code security enforcement in Loop Grid widget<\\/li>\\n<li>Fix: License expired affects the Display Conditions functionality in the front end<\\/li>\\n<\\/ul>\\n<h4>3.21.2 - 2024-04-30<\\/h4>\\n<ul>\\n<li>Fix: Special characters are not displayed correctly when using the Excerpt widget in Loop template (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/25860\\\">#25860<\\/a>)<\\/li>\\n<\\/ul>\\n<h4>3.21.1 - 2024-04-24<\\/h4>\\n<ul>\\n<li>Fix: Excerpt Length setting doesn\'t function correctly for languages with non-English characters in Post Excerpt widget<\\/li>\\n<\\/ul>\\n<h4>3.21.0 - 2024-04-15<\\/h4>\\n<ul>\\n<li>New: Introducing Loop Taxonomy Query - Enabling the display of post and product categories and tags within Loop Grid and Loop Carousel widgets (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/21372\\\">#21372<\\/a>)<\\/li>\\n<li>Tweak: Optimized Hotspot widget to prevent rendering when no image is provided<\\/li>\\n<li>Tweak: Optimized Blockquote widget to eliminate unnecessary markup when devoid of content<\\/li>\\n<li>Tweak: Optimized Template widget to eliminate unnecessary markup when no template is selected<\\/li>\\n<li>Tweak: Optimized Code Highlight widget to eliminate unnecessary markup when there is no content<\\/li>\\n<li>Tweak: Implemented CSS logical properties in Elementor<\\/li>\\n<li>Tweak: Implemented accessibility improvements in Portfolio widget<\\/li>\\n<li>Tweak: Implemented accessibility improvements of Author Avatar image alt text in Post Info widget (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/25440\\\">#25440<\\/a>)<\\/li>\\n<li>Tweak: Notes feature merged to version<\\/li>\\n<li>Tweak: Implemented accessibility improvements of Profile Picture alt text in Author widget<\\/li>\\n<li>Fix: Display issue on hover state in WooCommerce Menu Cart widget<\\/li>\\n<\\/ul>\\n<h4>3.20.3 - 2024-04-10<\\/h4>\\n<ul>\\n<li>Fix: Compatibility issue between the My Account widget and other third-party plugins (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/20986\\\">#20986<\\/a>)<\\/li>\\n<\\/ul>\\n<h4>3.20.2 - 2024-03-26<\\/h4>\\n<ul>\\n<li>Security Fix: Improved code security enforcement in Media Carousel widget<\\/li>\\n<li>Security Fix: Improved code security enforcement in Form widget<\\/li>\\n<li>Security Fix: Improved code security enforcement in Post Navigation widget<\\/li>\\n<li>Security Fix: Improved code security enforcement in Gallery widget<\\/li>\\n<li>Security Fix: Improved code security enforcement in Video Playlist widget<\\/li>\\n<\\/ul>\\n<h4>3.20.1 - 2024-03-20<\\/h4>\\n<ul>\\n<li>Fix: Strengthened code integrity in deprecated Woo Single Element widget<\\/li>\\n<li>Fix: PHP error notice appears when using Loop Grid with the Taxonomy Filter widgets<\\/li>\\n<\\/ul>\\n<h4>3.20.0 - 2024-03-11<\\/h4>\\n<ul>\\n<li>Tweak: Implemented OR logic in the Display Conditions feature<\\/li>\\n<li>Tweak: Added X and Threads social networks to Share Buttons widget (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/25299\\\">#25299<\\/a>)<\\/li>\\n<li>Tweak: Added Archive Title dynamic tag rule in Display Conditions feature<\\/li>\\n<li>Tweak: Added Featured Image Title dynamic tag rule in Display Conditions feature<\\/li>\\n<li>Tweak: Added Featured Image Alt dynamic tag rule in Display Conditions feature<\\/li>\\n<li>Tweak: Added Featured Image Caption dynamic tag rule in Display Conditions feature<\\/li>\\n<li>Tweak: Added Author Bio dynamic tag rule in Display Conditions feature<\\/li>\\n<li>Tweak: Added Author Email dynamic tag rule in Display Conditions feature<\\/li>\\n<li>Tweak: Added Author Website dynamic tag rule in Display Conditions feature<\\/li>\\n<li>Tweak: Added Page Title rule in Display Conditions feature<\\/li>\\n<li>Tweak: Added Post Title rule in Display Conditions feature<\\/li>\\n<li>Tweak: Added Featured Image rule in Display Conditions feature<\\/li>\\n<li>Tweak: Added Comments Number rule in Display Conditions feature<\\/li>\\n<li>Tweak: Added Archive Author rule in Display Conditions feature<\\/li>\\n<li>Tweak: Added support for WordPress Custom Fields in Display Conditions feature<\\/li>\\n<li>Tweak: Implemented accessibility improvements in Menu widget (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/23875\\\">#23875<\\/a>)<\\/li>\\n<li>Tweak: Implemented accessibility improvements in Login widget<\\/li>\\n<li>Tweak: Added additional style controls in the Table of Contents widget<\\/li>\\n<li>Tweak: Added Transition Duration option in Blockquote widget (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/21295\\\">#21295<\\/a>)<\\/li>\\n<li>Tweak: Added Transition Duration to button in Flip Box widget<\\/li>\\n<li>Tweak: Added Transition Duration to button in Author Box widget<\\/li>\\n<li>Tweak: Added Transition Duration to List in Table of Contents widget<\\/li>\\n<li>Tweak: Added Transition Duration to button in Login widget<\\/li>\\n<li>Tweak: Added Transition Duration in Post Navigation widget<\\/li>\\n<li>Tweak: Added Transition Duration Show More in Video Playlist widget<\\/li>\\n<li>Tweak: Added Transition Duration to button in Form widget<\\/li>\\n<li>Tweak: Removed separator-none argument from all Editor controls<\\/li>\\n<li>Tweak: Add <code>&lt;time&gt;<\\/code> wrapper for Date and Time items in Post Info widget<\\/li>\\n<li>Tweak: Page Transitions feature merged to version<\\/li>\\n<li>Tweak: Scroll Snap feature merged to version<\\/li>\\n<li>Tweak: Promoted Display Conditions feature to Beta status and activated for new sites<\\/li>\\n<li>Tweak: Promoted Taxonomy Filter feature to beta status and activated for new sites<\\/li>\\n<li>Fix: Page Transitions feature and Load Font Awesome 4 Support cause a console error (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/18885\\\">#18885<\\/a>, <a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/19334\\\">#19334<\\/a>, <a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/21082\\\">#21082<\\/a>)<\\/li>\\n<li>Fix: Added better output escaping in Taxonomy Filter widget<\\/li>\\n<\\/ul>\\n<h4>3.19.3 - 2024-02-26<\\/h4>\\n<ul>\\n<li>Tweak: Improved Loop CSS loading structure in Loop Grid item<\\/li>\\n<li>Security Fix: Addressed security weaknesses in Dynamic Tags<\\/li>\\n<\\/ul>\\n<h4>3.19.2 - 2024-02-07<\\/h4>\\n<ul>\\n<li>Fix: Export data inconsistencies when using form actions in Form widget<\\/li>\\n<\\/ul>\\n<h4>3.19.1 - 2024-02-05<\\/h4>\\n<ul>\\n<li>Fix: Enqueuing non-existing Loop Template CSS file in Loop Item template (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/24959\\\">#24959<\\/a>)<\\/li>\\n<li>Fix: Improved code security enforcement in Countdown widget<\\/li>\\n<\\/ul>\\n<h4>3.19.0 - 2024-01-29<\\/h4>\\n<ul>\\n<li>New: Introducing Display Conditions for Elements - allowing users to customize content visibility based on specified criteria (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/4246\\\">#4246<\\/a>, <a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/21152\\\">#21152<\\/a>)<\\/li>\\n<li>New: Implemented Akismet Integration for enhanced spam protection and security in Form widget (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/11401\\\">#11401<\\/a>)<\\/li>\\n<li>New: Introducing Permissions functionality to Element Manager - providing users with enhanced control over access and management capabilities<\\/li>\\n<li>Tweak: Added styling option for dropdown indicator in Menu widget (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/21907\\\">#21907<\\/a>)<\\/li>\\n<li>Tweak: Added additional size units and custom units in all elements<\\/li>\\n<li>Tweak: Implemented CSS logical properties in WordPress Menu widget<\\/li>\\n<li>Tweak: Implemented CSS logical properties in Reviews widget<\\/li>\\n<li>Tweak: Implemented CSS logical properties in Countdown widget<\\/li>\\n<li>Tweak: Implemented CSS logical properties in Elementor Editor<\\/li>\\n<li>Tweak: Updated <code>jquery.smartmenus.js<\\/code> version from 1.1.1 to 1.2.0<\\/li>\\n<li>Fix: Dynamic Background Image does not load on the first Loop Item in a Loop Grid (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/21489\\\">#21489<\\/a>, <a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/22368\\\">#22368<\\/a>, <a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/23085\\\">#23085<\\/a>)<\\/li>\\n<li>Fix: History panel deprecation notices in console log<\\/li>\\n<li>Fix: Second Pro rollback installed the latest version instead of the specifically selected older version<\\/li>\\n<li>Fix: Incorrect position of the dropdown content when applying entrance animation in Menu Widget<\\/li>\\n<li>Fix: UX issues when using in-place editing in Menu widget<\\/li>\\n<li>Fix: Pagination with page reload is not working when used with the Taxonomy filter and Loop Grid widget in Archive template<\\/li>\\n<\\/ul>\\n<h4>3.18.2 - 2023-12-20<\\/h4>\\n<ul>\\n<li>Fix: Modified controls sanitization to enforce better security policies in Price List widget<\\/li>\\n<li>Fix: Error messages related to loop filter appear on front when using PHP 8.X and <code>WP_DEBUG<\\/code> is true<\\/li>\\n<\\/ul>\\n<h4>3.18.1 - 2023-12-06<\\/h4>\\n<ul>\\n<li>Fix: No results appeared when reloading the page with deep link and de-selecting terms in Taxonomy Filter widget<\\/li>\\n<li>Fix: No results appeared when filtering the Uncategorized category in Filter Taxonomy widget<\\/li>\\n<li>Fix: Notes still available when the Notes feature is deactivated<\\/li>\\n<\\/ul>\\n<h4>3.18.0 - 2023-12-04<\\/h4>\\n<ul>\\n<li>Tweak: Added the ability to upload files as attachments to emails in the File Upload field in Form widget (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/4868\\\">#4868<\\/a>)<\\/li>\\n<li>Tweak: Introduced the capability to design and edit the empty state in the Loop Grid widget (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/24261\\\">#24261<\\/a>)<\\/li>\\n<li>Tweak: Implemented the option to close the menu content area with a click anywhere on the screen in Menu widget (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/22686\\\">#22686<\\/a>)<\\/li>\\n<li>Tweak: Improve scrolling behavior inside the content area when there is not enough space in Menu widget (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/22712\\\">#22712<\\/a>)<\\/li>\\n<li>Tweak: Expanded breakpoint options in Menu widget (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/22488\\\">#22488<\\/a>)<\\/li>\\n<li>Tweak: Added Logical Combination control in Taxonomy Filter widget<\\/li>\\n<li>Tweak: Added additional units to Horizontal and Vertical padding for Dropdown in WordPress Menu widget<\\/li>\\n<li>Tweak: Hide navigation arrows when there is only one slide in Loop Carousel and Carousel widgets<\\/li>\\n<li>Tweak: Added various HTML Tag controls in Video Playlist widget<\\/li>\\n<li>Tweak: Added responsive control to navigation size in Slides, Reviews, Media Carousel and Testimonial Carousel widgets<\\/li>\\n<li>Tweak: Added semantic <code>&lt;search&gt;<\\/code> wrapper in Search Form widget<\\/li>\\n<li>Tweak: Added semantic <code>&lt;search&gt;<\\/code> wrapper in Taxonomy Filter widget<\\/li>\\n<li>Tweak: Added Multiple Selection control in Taxonomy Filter widget<\\/li>\\n<li>Fix: Deprecated notice when using ${var} in strings instead of {$var} with PHP 8.2 (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/23927\\\">#23927<\\/a>)<\\/li>\\n<li>Fix: Dropdown indicator position issue in Menu widget (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/23947\\\">#23947<\\/a>)<\\/li>\\n<li>Fix: Dynamic Tags are not available when choosing \'self-hosted\' source in Video widget<\\/li>\\n<li>Fix: Telephone field placeholder is aligned to the left in RTL websites in Form widget<\\/li>\\n<\\/ul>\\n<h4>3.17.1 - 2023-11-01<\\/h4>\\n<ul>\\n<li>Fix: Modified controls sanitization to enforce better security policies in Code Highlight, Form, Lottie, Price List, and Video Playlist widgets<\\/li>\\n<\\/ul>\\n<h4>3.17.0 - 2023-10-25<\\/h4>\\n<ul>\\n<li>Tweak: Added AJAX pagination option or seamless page navigation between content in Loop Grid widget (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/1284\\\">#1284<\\/a>)<\\/li>\\n<li>Tweak: Introduced Individual Pagination option when multiple Post widgets are on the same page, providing enhanced control over pagination<\\/li>\\n<li>Tweak: Introduced Individual Pagination option when multiple Loop Grid widgets are on the same page, providing enhanced control over pagination<\\/li>\\n<li>Tweak: Added a None option to the breakpoint options in Menu widget<\\/li>\\n<li>Tweak: Added a horizontal scrolling option in Menu widget<\\/li>\\n<li>Tweak: Upgraded minimum required PHP version to 7.3<\\/li>\\n<li>Tweak: Improved accessibility when minimize button is disabled in Table of Content widget<\\/li>\\n<li>Fix: Table of Content widget without icons displays <code>undefined<\\/code> error (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/17523\\\">#17523<\\/a>, <a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/17768\\\">#17768<\\/a>, <a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/18463\\\">#18463<\\/a>)<\\/li>\\n<li>Fix: Hover behavior issues on menu items in Menu widget (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/23430\\\">#23430<\\/a>, <a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/22431\\\">#22431<\\/a>)<\\/li>\\n<li>Fix: Links inside Loop Carousel are not working on initial load in Menu widget (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/23705\\\">#23705<\\/a>)<\\/li>\\n<li>Fix: Popups accessible navigation adds outlines to the wrong first focusable element<\\/li>\\n<li>Fix: Dropdown area aligned to the left side of the screen if contains Tabs widget in Menu widget<\\/li>\\n<li>Fix: Content horizontal position not aligning correctly when used with carousel widgets in Menu widget<\\/li>\\n<li>Fix: Accessibility errors in PageSpeed Insights in Table of Contents widget<\\/li>\\n<\\/ul>\\n<h4>3.16.2 - 2023-09-20<\\/h4>\\n<ul>\\n<li>Fix: Fit to Content dropdown position calculation is incorrect in Menu widget (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/23808\\\">#23808<\\/a>)<\\/li>\\n<li>Fix: Reverted hide navigation arrows when there is only one slide in the Loop or Nested carousel (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/23804\\\">#23804<\\/a>)<\\/li>\\n<\\/ul>\\n<h4>3.16.1 - 2023-09-14<\\/h4>\\n<ul>\\n<li>Fix: Dynamic tag for ACF image field is not working as expected (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/23757\\\">#23757<\\/a>)<\\/li>\\n<li>Fix: Sticky functionality affects padding values in Container (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/23758\\\">#23758<\\/a>)<\\/li>\\n<li>Fix: HTML list issues for padding and margin in Menu widget<\\/li>\\n<\\/ul>\\n<h4>3.16.0 - 2023-09-12<\\/h4>\\n<ul>\\n<li>Tweak: Implemented accessibility improvements in Menu widget (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/23607\\\">#23607<\\/a>, <a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/22554\\\">#22554<\\/a>)<\\/li>\\n<li>Fix: \'Fallback: Recent Posts\' option malfunctions in the Query control (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/21436\\\">#21436<\\/a>, <a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/23259\\\">#23259<\\/a>)<\\/li>\\n<li>Tweak: Hide navigation arrows when there is only one slide in the Loop or Nested carousel (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/22056\\\">#22056<\\/a>)<\\/li>\\n<li>Tweak: Used appropriate image <code>alt<\\/code> in Testimonial Carousel widget (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/17680\\\">#17680<\\/a>)<\\/li>\\n<li>Tweak: Optimized Scroll Snap functionality when using Container widget<\\/li>\\n<li>Tweak: Enhanced Elementor Role Manager functionality when using Containers<\\/li>\\n<li>Tweak: Added Notes feature to the Editor Top Bar<\\/li>\\n<li>Tweak: Replace CSS <code>float<\\/code> with other layouts in the Editor<\\/li>\\n<li>Tweak: Upgraded HTML Structure for the Menu widget<\\/li>\\n<li>Tweak: Implemented CSS logical properties in Carousel and Menu widgets<\\/li>\\n<li>Tweak: Added keyboard accessibility to a link in Posts widget<\\/li>\\n<li>Tweak: Loop Builder feature merged to version<\\/li>\\n<li>Fix: Addressed inconsistency in hover effect durations between icon, dropdown indicator colors, and text colors in the Menu widget (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/22376\\\">#22376<\\/a>)<\\/li>\\n<li>Fix: Slides break if the parent container is set to HTML A tag in Loop Carousel and Carousel widgets (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/22678\\\">#22678<\\/a>)<\\/li>\\n<li>Fix: The icon size setting is not affecting uploaded SVG icons in the Menu widget (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/22372\\\">#22372<\\/a>)<\\/li>\\n<li>Fix: Taxonomy filter does not work with slug in foreign characters (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/23315\\\">#23315<\\/a>)<\\/li>\\n<li>Fix: Improved code security enforcement in Dynamic Tags<\\/li>\\n<li>Fix: Sticky container incorrectly adjusts its width when transitioning from a smaller breakpoint to a larger one within the Editor<\\/li>\\n<\\/ul>\\n<h4>3.15.1 - 2023-08-09<\\/h4>\\n<ul>\\n<li>Fix: Improved code security enforcement in Table of Contents widget<\\/li>\\n<\\/ul>\\n<h4>3.15.0 - 2023-07-31<\\/h4>\\n<ul>\\n<li>New: Introducing Taxonomy Filter widget - Empower visitors to seamlessly filter listings in Loop Grids based on taxonomies (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/3140\\\">#3140<\\/a>)<\\/li>\\n<li>Tweak: Added an &quot;Offset Sides&quot; functionality in Carousel and Loop Carousel widgets (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/21114\\\">#21114<\\/a>)<\\/li>\\n<li>Tweak: Modified the size of the Publish button in the Editor Top Bar feature (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/22472\\\">#22472<\\/a>)<\\/li>\\n<li>Tweak: Improved Ajax permissions functionality for better security enforcement<\\/li>\\n<li>Tweak: Added option for pagination custom position in Carousel and Loop Carousel widgets<\\/li>\\n<li>Tweak: Added option for navigation custom position in Carousel and Loop Carousel widgets<\\/li>\\n<li>Tweak: Added additional styling options for navigation in Carousel and Loop Carousel widgets<\\/li>\\n<li>Tweak: Added labels to shortcode column in WordPress admin<\\/li>\\n<li>Tweak: Unified the appearance of <code>stretch<\\/code> and <code>center<\\/code> buttons in Menu widget<\\/li>\\n<li>Tweak: Unified the appearance of <code>stretch<\\/code> and <code>center<\\/code> buttons in My Account widget<\\/li>\\n<li>Tweak: Improved panel UI in Video Playlist widget<\\/li>\\n<li>Tweak: Implemented CSS logical properties in Elementor Editor<\\/li>\\n<li>Tweak: Added &quot;Title HTML Tag&quot; and &quot;Description HTML Tag&quot; in Price List widget<\\/li>\\n<li>Tweak: Added &quot;Title HTML Tag&quot; and &quot;Description HTML Tag&quot; in Slides widget<\\/li>\\n<li>Tweak: Added &quot;Title HTML Tag&quot; and &quot;Description HTML Tag&quot; in Flip Box widget<\\/li>\\n<li>Tweak: Added &quot;Description HTML Tag&quot; in Call To Action widget<\\/li>\\n<li>Security Fix: Improved code security enforcement in Share Buttons widget<\\/li>\\n<li>Security Fix: Improved code security enforcement in Form widget<\\/li>\\n<li>Fix: WooCommerce Status page failed to recognize Elementor WooCommerce widgets<\\/li>\\n<li>Fix: Pagination does not work inside single templates when using Posts and Loop Grid widgets<\\/li>\\n<li>Fix: Incorrect saving of WooCommerce page settings in Elementor site settings under certain scenarios<\\/li>\\n<\\/ul>\\n<h4>3.14.1 - 2023-06-26<\\/h4>\\n<ul>\\n<li>Tweak: Improved navigation on touch devices in Carousel widget (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/22827\\\">#22827<\\/a>)<\\/li>\\n<li>Fix: Missing navigation arrows on lightbox in Gallery widget (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/22870\\\">#22870<\\/a>)<\\/li>\\n<\\/ul>\\n<h4>3.14.0 - 2023-06-19<\\/h4>\\n<ul>\\n<li>New: Introducing Carousel widget - Infinite design possibilities, and nesting capabilities (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/2587\\\">#2587<\\/a>, <a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/219\\\">#219<\\/a>)<\\/li>\\n<li>Tweak: Added Static Item Position functionality to Alternate template in Loop Grid widget<\\/li>\\n<li>Tweak: Added visual indication of Page Parts<\\/li>\\n<li>Tweak: Added dividers option between menu items in Menu widget<\\/li>\\n<li>Tweak: Changed the HTML structure of Pagination and Navigation in Loop Carousel and Nested Carousel widgets<\\/li>\\n<li>Tweak: Added shop page in WooCommerce Pages section in Site Settings<\\/li>\\n<li>Tweak: Added Text Shadow, Box Shadow and Padding control to button in Call to Action widget<\\/li>\\n<li>Tweak: Added Lazy Load support for images in Video Playlist widget<\\/li>\\n<li>Tweak: Added <code>alt<\\/code> attribute to images in Video Playlist widget<\\/li>\\n<li>Tweak: Replaced select control with choose control for Flip Direction control in Flip Box widget<\\/li>\\n<li>Tweak: Added keyboard accessibility to Carousel and Loop Carousel widgets<\\/li>\\n<li>Tweak: Use <code>media_types<\\/code> array in Media controls<\\/li>\\n<li>Fix: Lightbox is still enabled after disabling it in the Site Settings in Gallery widget (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/11193\\\">#11193<\\/a>, <a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/19871\\\">#19871<\\/a>)<\\/li>\\n<li>Fix: Responsive settings for templates don\'t work as expected when Additional Custom Breakpoints feature is active (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/16819\\\">#16819<\\/a>, <a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/19394\\\">#19394<\\/a>)<\\/li>\\n<li>Fix: Inner containers are not presented as expected in Menu widget (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/21813\\\">#21813<\\/a>)<\\/li>\\n<li>Fix: Popup width does not support percentages (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/22413\\\">#22413<\\/a>)<\\/li>\\n<li>Fix: PHP 8.x throws errors when using WooCommerce Ajax response (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/22199\\\">#22199<\\/a>)<\\/li>\\n<li>Fix: Mini cart template appears as empty in various scenarios in Menu Cart widget (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/22789\\\">#22789<\\/a>)<\\/li>\\n<li>Fix: Order by Price doesn\'t work for the Latest products or Manual Selection in Products widget<\\/li>\\n<li>Fix: Dropdown indicator icon is not vertically aligned to the text when using icon in Menu Widget<\\/li>\\n<li>Fix: Mixed content warning in the console for Video Playlist widget<\\/li>\\n<li>Fix: Preview settings are not presented as expected after first save in Loop Template<\\/li>\\n<li>Fix: Not-crawlable link error in Video Playlist widget<\\/li>\\n<li>Fix: Lightbox is still enabled after disabling it in the Site Settings in Logo widget<\\/li>\\n<li>Fix: Focus state issue on page load when using Table of Content widget<\\/li>\\n<\\/ul>\\n<h4>3.13.2 - 2023-05-22<\\/h4>\\n<ul>\\n<li>Fix: Hover settings not working as expected on Touch-Enabled devices in Menu widget (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/22258\\\">#22258<\\/a>)<\\/li>\\n<\\/ul>\\n<h4>3.13.1 - 2023-05-11<\\/h4>\\n<ul>\\n<li>Security Fix: Addressed security weaknesses in access management related functions<\\/li>\\n<li>Fix: Excerpt content pulled from post content is showing with HTML tags in Loop Grid widget (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/22367\\\">#22367<\\/a>)<\\/li>\\n<\\/ul>\\n<h4>3.13.0 - 2023-05-08<\\/h4>\\n<ul>\\n<li>Tweak: Provided an option to assign excerpt automatically from post content in Post Excerpt dynamic tag (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/20256\\\">#20256<\\/a>, <a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/21715\\\">#21715<\\/a>)<\\/li>\\n<li>Tweak: Added Display Conditions functionality in Editor Top bar (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/21675\\\">#21675<\\/a>, <a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/22050\\\">#22050<\\/a>)<\\/li>\\n<li>Tweak: Removed <code>elementor_page_id<\\/code> from request URLs in the WC AJAX calls (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/18675\\\">#18675<\\/a>)<\\/li>\\n<li>Tweak: Added icons to menu items in Mega Menu widget (<a href=\\\"https:\\/\\/github.com\\/orgs\\/elementor\\/discussions\\/21602\\\">#21602<\\/a>)<\\/li>\\n<li>Tweak: Added keyboard accessibility to Toggle Button in WordPress Menu widget (<a href=\\\"https:\\/\\/github.com\\/orgs\\/elementor\\/discussions\\/2348\\\">#2348<\\/a>)<\\/li>\\n<li>Tweak: Added \'Active item state\' to top-level menu items for anchor links in the Menu widget<\\/li>\\n<li>Tweak: Added keyboard accessibility to navigation arrows in Loop Carousel widget<\\/li>\\n<li>Tweak: Added keyboard accessibility to navigation arrows in Slides widget<\\/li>\\n<li>Tweak: Added keyboard accessibility to navigation arrows in Media, Testimonial and Reviews Carousel widgets<\\/li>\\n<li>Tweak: Added keyboard accessibility to Table of Content widget<\\/li>\\n<li>Tweak: Added keyboard accessibility to Search Form widget<\\/li>\\n<li>Tweak: Added accessibility to images in Slides widget<\\/li>\\n<li>Tweak: Added accessibility to images in Call To Action widget<\\/li>\\n<li>Tweak: Added accessibility to images in Media Carousel widget<\\/li>\\n<li>Tweak: Added accessibility to images in Gallery widget<\\/li>\\n<li>Tweak: Added Lazy Load support for avatar image in Post Info widget<\\/li>\\n<li>Tweak: Added Lazy Load support to various Elementor Editor and Admin images<\\/li>\\n<li>Tweak: Added Lazy Load support for author image in Author Box widget<\\/li>\\n<li>Tweak: Added Lazy Load support for images in Price List widget<\\/li>\\n<li>Fix: Content width is affected by the widget\'s width when Content Width is set to Fit to Content in Menu widget (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/21842\\\">#21842<\\/a>)<\\/li>\\n<li>Fix: Empty value on Rows field causes an error in Products widget (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/21451\\\">#21451<\\/a>)<\\/li>\\n<\\/ul>\\n<h4>3.12.2 - 2023-04-09<\\/h4>\\n<ul>\\n<li>Fix: Mini cart template appears as empty in various WordPress themes (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/21836\\\">#21836<\\/a>)<\\/li>\\n<\\/ul>\\n<h4>3.12.1 - 2023-04-02<\\/h4>\\n<ul>\\n<li>Fix: Default background colors are presented as transparent in Popup (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/21824\\\">#21824<\\/a>)<\\/li>\\n<li>Fix: Reverted the tweak of Form Submissions feature merged to the version (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/21821\\\">#21821<\\/a>)<\\/li>\\n<li>Fix: Dropdown area is not closing when hovering outside of the content area in Menu widget<\\/li>\\n<\\/ul>\\n<h4>3.12.0 - 2023-03-29<\\/h4>\\n<ul>\\n<li>New: Introducing the Mega Menu with the new Menu widget - empowers you to achieve a much higher level of menu design, customization, and creativity<\\/li>\\n<li>New: Diversify your design with a Loop Alternate template - apply another template within your Loop Grid for design creativity<\\/li>\\n<li>New: Kickstart your workflow with predesigned Loop container-based templates<\\/li>\\n<li>Tweak: Added custom icon controls to various locations in Menu Cart widget (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/13678\\\">#13678<\\/a>, <a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/17941\\\">#17941<\\/a>, <a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/19295\\\">#19295<\\/a>)<\\/li>\\n<li>Tweak: Added a spacing control between navigation and slides in the Loop Carousel<\\/li>\\n<li>Tweak: Added responsive control to the \'Gap between slides\' control in the Loop Carousel<\\/li>\\n<li>Tweak: Added Custom CSS section in Loop Item template<\\/li>\\n<li>Tweak: Added an Article class metadata in Loop Item template<\\/li>\\n<li>Tweak: Added Lazy Load support for background images in CTA widget when using the Lazy Load Background Images experiment<\\/li>\\n<li>Tweak: Added Lazy Load support for background images in Flipbox widget when using the Lazy Load Background Images experiment<\\/li>\\n<li>Tweak: Added additional size units and custom units in all elements<\\/li>\\n<li>Tweak: Changed Nav Menu widget name to WordPress Menu widget<\\/li>\\n<li>Tweak: Added &quot;Form Validation&quot; control to Form widget<\\/li>\\n<li>Tweak: Updated custom messages in the Form widget<\\/li>\\n<li>Tweak: Improved accessibility in various elements in Gallery widget<\\/li>\\n<li>Tweak: Form Submissions feature merged to version<\\/li>\\n<li>Tweak: Loop feature promoted to Stable status<\\/li>\\n<li>Tweak: Page Transitions feature promoted to Stable status<\\/li>\\n<li>Tweak: Improved accessibility in filter bar in Gallery widget<\\/li>\\n<li>Tweak: Remove unused <code>aspect-ratio-*<\\/code> CSS classes<\\/li>\\n<li>Fix: Not all active breakpoints appear under &quot;Advanced Rules&quot; in popup publish settings (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/17020\\\">#17020<\\/a>)<\\/li>\\n<li>Fix: Dynamic background image and video is not working with ACF in Loop Grid widget<\\/li>\\n<\\/ul>\\n<h4>3.11.7 - 2023-03-22<\\/h4>\\n<ul>\\n<li>Tweak: Improved code security enforcement in WooCommerce components<\\/li>\\n<\\/ul>\\n<h4>3.11.6 - 2023-03-14<\\/h4>\\n<ul>\\n<li>Tweak: Improved code security enforcement in Author Box and Countdown widgets<\\/li>\\n<\\/ul>\\n<h4>3.11.5 - 2023-03-12<\\/h4>\\n<ul>\\n<li>Fix: Hamburger Menu Toggle not showing if breakpoint is set to Tablet Extra in Nav Menu widget (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/21003\\\">#21003<\\/a>)<\\/li>\\n<\\/ul>\\n<h4>3.11.4 - 2023-03-07<\\/h4>\\n<ul>\\n<li>Tweak: Prevented SVG file upload for better security enforcement in Forms widget<\\/li>\\n<\\/ul>\\n<h4>3.11.3 - 2023-02-26<\\/h4>\\n<ul>\\n<li>Fix: Error message appears when submitting a form placed below Loop Grid and Loop Carousel widgets (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/21432\\\">#21432<\\/a>)<\\/li>\\n<li>Fix: PHP 8.x compatibility issues in various places<\\/li>\\n<\\/ul>\\n<h4>3.11.2 - 2023-02-22<\\/h4>\\n<ul>\\n<li>Fix: Save &amp; Back handle becomes inaccessible in various scenarios cases in Loop Carousel widget (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/21316\\\">#21316<\\/a>)<\\/li>\\n<li>Fix: Can\'t edit page when using \'Content Tabs\' and \'Section\' options in Video Playlist widget<\\/li>\\n<\\/ul>\\n<h4>3.11.1 - 2023-02-15<\\/h4>\\n<ul>\\n<li>Fix: Featured Image dynamic tag is not working in Background images (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/21313\\\">#21313<\\/a>)<\\/li>\\n<li>Fix: Time zone is not correct in Countdown widget (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/17485\\\">#17485<\\/a>)<\\/li>\\n<li>Fix: File upload field is not working in Form widget (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/21341\\\">#21341<\\/a>)<\\/li>\\n<li>Fix: Post Image Attachments dynamic tag is not working in various widgets (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/21314\\\">#21314<\\/a>)<\\/li>\\n<\\/ul>\\n<h4>3.11.0 - 2023-02-13<\\/h4>\\n<ul>\\n<li>New: Introducing Loop Carousel widget - Create powerful &amp; repeating loop templates and populate each one with dynamic content (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/219\\\">#219<\\/a>)<\\/li>\\n<li>New: Added Date and Time Range option to Advanced Rules in Popup<\\/li>\\n<li>Tweak: Improved accessibility when opening and closing a popup (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/9788\\\">#9788<\\/a>)<\\/li>\\n<li>Tweak: Improved accessibility of full-screen mode in Search Form widget (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/19907\\\">#19907<\\/a>)<\\/li>\\n<li>Tweak: Added keyboard accessibility support to Flip Box widget (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/5861\\\">#5861<\\/a>)<\\/li>\\n<li>Tweak: Add <code>aria-label<\\/code> to read more link in Posts widget (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/13784\\\">#13784<\\/a>)<\\/li>\\n<li>Tweak: Use <code>aspect-ratio<\\/code> property instead of CSS trick in Media Carousel widget<\\/li>\\n<li>Tweak: Updated translation string in Stripe widget<\\/li>\\n<li>Fix: Masonry and Columns controls are not working as expected with responsive in Posts and Loop Grid widgets (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/20670\\\">#20670<\\/a>)<\\/li>\\n<li>Fix: Invalid attributes names in Nav Menu widget (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/17400\\\">#17400<\\/a>)<\\/li>\\n<li>Fix: Post Image Attachments dynamic tag is not working as expected in various widgets<\\/li>\\n<li>Fix: Form fields order is not presented correctly when exported to CSV in Form Submissions<\\/li>\\n<li>Fix: Dynamic background image and video are not working with ACF in Loop Grid widget<\\/li>\\n<\\/ul>\\n<h4>3.10.3 - 2023-01-29<\\/h4>\\n<ul>\\n<li>Tweak: Added introduction video to loop item information modal in Theme Builder<\\/li>\\n<li>Fix: PHP 8.x throws errors and notices in some cases (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/21087\\\">#21087<\\/a>)<\\/li>\\n<li>Fix: Infinite Scroll and Load on click pagination are not working as expected in Archive template<\\/li>\\n<li>Fix: Show row even when values do not exist in Form Submissions<\\/li>\\n<\\/ul>\\n<h4>3.10.2 - 2023-01-17<\\/h4>\\n<ul>\\n<li>Fix: Updated compatibility tag for Elementor v3.10<\\/li>\\n<\\/ul>\\n<h4>3.10.1 - 2023-01-09<\\/h4>\\n<p>Fix: Preview Could not be loaded error message appears on pages containing the Loop Grid in a header or footer templates<\\/p>\\n<h4>3.10.0 - 2023-01-09<\\/h4>\\n<ul>\\n<li>New: Added new dynamic tag for due date in Countdown widget (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/7737\\\">#7737<\\/a>)<\\/li>\\n<li>Tweak: Added <code>modified<\\/code> and <code>comment_count<\\/code> to Order By in posts query control (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/11159\\\">#11159<\\/a>)<\\/li>\\n<li>Tweak: Replaced <code>footer<\\/code> tag in Blockquote and Comments widgets for better semantics<\\/li>\\n<li>Fix: Compatibility issue in Imagify Media Library filters due to <code>_elementor_is_screenshot<\\/code> meta filter (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/19988\\\">#19988<\\/a>)<\\/li>\\n<li>Fix: Hotspot Widget label icon height issues when Inline Font Icons experiment is active<\\/li>\\n<li>Fix: Editing glitch when using two loop grid widgets on the same page with the same loop item template<\\/li>\\n<li>Fix: Equal height is not working when using sections in Loop Grid widget<\\/li>\\n<li>Fix: Large amount of menu items are not appearing correctly on a mobile device in Nav Menu widget<\\/li>\\n<li>Fix: Featured Image does not change dynamically when using infinite\\/click pagination in Loop Grid widget<\\/li>\\n<li>Fix: Removed action call of non-existent <code>display_empty_cart_template()<\\/code> method in Cart widget<\\/li>\\n<\\/ul>\\n<h4>3.9.2 - 2022-12-21<\\/h4>\\n<ul>\\n<li>Fix: JS events do not trigger in Popups (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/20708\\\">#20708<\\/a>)<\\/li>\\n<li>Fix: PHP Errors appear when not using the toggle menu in Nav Menu widget (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/18636\\\">#18636<\\/a>)<\\/li>\\n<li>Fix: Popups\' backgrounds disappear when using Lazy Load Background Images experiment<\\/li>\\n<\\/ul>\\n<h4>3.9.1 - 2022-12-14<\\/h4>\\n<ul>\\n<li>Fix: WooCommerce Product Gallery dynamic tag is not working in Basic Gallery, Gallery and Image Carousel widgets (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/20678\\\">#20678<\\/a>)<\\/li>\\n<li>Fix: Hide Empty option is not working in Menu Cart widget<\\/li>\\n<li>Fix: The Stripe Button widget doesn\'t work in Templates<\\/li>\\n<\\/ul>\\n<h4>3.9.0 - 2022-12-06<\\/h4>\\n<ul>\\n<li>New: Added support for WooCommerce to Loop Builder (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/20020\\\">#20020<\\/a>)<\\/li>\\n<li>Tweak: Added more options to \'Show up to X times\' advanced rule in Popups (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/8187\\\">#8187<\\/a>)<\\/li>\\n<li>Tweak: Allow saving and reloading a page while editing in-place loop item template (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/19882\\\">#19882<\\/a>)<\\/li>\\n<li>Tweak: Added <code>$location param<\\/code> to <code>elementor\\/theme\\/get_location_templates\\/template_id<\\/code> hook (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/18453\\\">#18453<\\/a>)<\\/li>\\n<li>Tweak: Removed redundant labels from group controls (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/11666\\\">#11666<\\/a>)<\\/li>\\n<li>Tweak: Added support to use sections and columns as the layout structure of a Loop item template<\\/li>\\n<li>Tweak: Disabled movement when a repeater item is in focus in edit mode<\\/li>\\n<li>Tweak: Upgrade the autoprefixer package to better minify CSS files<\\/li>\\n<li>Tweak: Removed duplicate SQL queries on every page for better performance<\\/li>\\n<li>Tweak: Improved License validation mechanism to avoid limitations<\\/li>\\n<li>Tweak: Added more units options to Border Width control in various elements<\\/li>\\n<li>Tweak: Added <code>em<\\/code> units to Border Radius control in various elements<\\/li>\\n<li>Tweak: Added \'Equal height\' functionality to Loop Grid widget<\\/li>\\n<li>Fix: Issue with Related Products widget and WooCommerce Pixel Manager plugin (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/16934\\\">#16934<\\/a>)<\\/li>\\n<li>Fix: My Account widget gets hidden when using a single page template with post content (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/19627\\\">#19627<\\/a>)<\\/li>\\n<li>Fix: Cart is not updated when cache enabled in Menu Cart widget (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/19312\\\">#19312<\\/a>)<\\/li>\\n<li>Fix: Entrance animations are not working as expected with Infinite Loop and Load on CLick pagination in Loop Grid widget (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/20293\\\">#20293<\\/a>)<\\/li>\\n<li>Fix: Loading page issues in Form Submissions screen (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/19973\\\">#19973<\\/a>)<\\/li>\\n<li>Fix: Recently Edited date and time not working as expected in Elementor Overview plugin in WordPress dashboard (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/17966\\\">#17966<\\/a>)<\\/li>\\n<li>Fix: Recurring license mismatch error message when using translators plugins<\\/li>\\n<li>Fix: Submenu items triggers page transition instead of opening in Nav Menu widget<\\/li>\\n<li>Fix: Query values of Posts widget are not imported correctly when importing a Kit<\\/li>\\n<li>Fix: Loop items are exceeding the widget boundaries in Loop Grid widget<\\/li>\\n<li>Fix: Order by option is not working as expected when choosing Upsells, Cross-Sells and Related Products query in Products widget<\\/li>\\n<li>Fix: Various widgets disappear in certain scenarios when choosing direction Row or Column in Container<\\/li>\\n<\\/ul>\\n<h4>3.8.2 - 2022-11-20<\\/h4>\\n<ul>\\n<li>Fix: Z-index issues when applying sticky to Container<\\/li>\\n<li>Fix: Error message appears on front with Editor and Shop Manager roles when using the Loop Builder widget<\\/li>\\n<\\/ul>\\n<h4>3.8.1 - 2022-11-06<\\/h4>\\n<ul>\\n<li>Fix: Sticky inner section is not staying in the column when applying sticky option in Sections (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/20203\\\">#20203<\\/a>)<\\/li>\\n<li>Fix: Post Title widget located in a loop item template disappears when enabling the hide title option inside page settings (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/20207\\\">#20207<\\/a>, <a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/20255\\\">#20255<\\/a>)<\\/li>\\n<li>Fix: ACF Dynamic data not rendering correctly in various scenarios (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/20235\\\">#20235<\\/a>, <a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/20258\\\">#20258<\\/a>, <a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/20277\\\">#20277<\\/a>)<\\/li>\\n<li>Fix: Z-index issues when applying sticky to Container (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/20227\\\">#20227<\\/a>)<\\/li>\\n<\\/ul>\\n<h4>3.8.0 - 2022-10-30<\\/h4>\\n<ul>\\n<li>New: Introducing Loop Builder as a beta status experiment - Create powerful &amp; repeating loop templates and populate each one with dynamic content and design flexibility (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/4440\\\">#4440<\\/a>)<\\/li>\\n<li>Tweak: Add <code>wp_body_open()<\\/code> to header in Header template (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/11562\\\">#11562<\\/a>, <a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/15828\\\">#15828<\\/a>, <a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/13089\\\">#13089<\\/a>)<\\/li>\\n<li>Tweak: Added support border-radius option to the Code Highlight widget (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/14316\\\">#14316<\\/a>)<\\/li>\\n<li>Tweak: Import\\/Export CLI and UI mechanisms were merged into a unified service<\\/li>\\n<li>Tweak: User with no permission to Notes cannot be mentioned in a note<\\/li>\\n<li>Tweak: User with no permission to view a post cannot be mentioned in a note<\\/li>\\n<li>Tweak: Notes was added to the right click context-menu<\\/li>\\n<li>Tweak: Notes panel can be resizable<\\/li>\\n<li>Tweak: Notes panel can be dragged outside of the canvas in responsive mode in the editor<\\/li>\\n<li>Tweak: Updated form validation messages translation strings in Form widget<\\/li>\\n<li>Tweak: Updated translators comments<\\/li>\\n<li>Tweak: Theme Builder logo and Title should be clickable<\\/li>\\n<li>Tweak: Reduced API requests and DB calls on non-write setup<\\/li>\\n<li>Tweak: Added media queries to the Table of Contents widget<\\/li>\\n<li>Fix: Sticky option is not working as expected in various scenarios in Container (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/18357\\\">#18357<\\/a>, <a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/19540\\\">#19540<\\/a>, <a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/19618\\\">#19618<\\/a>, <a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/19777\\\">#19777<\\/a>, <a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/19827\\\">#19827<\\/a>)<\\/li>\\n<li>Fix: Mixed Content errors on HTTPS in Video Playlist Widget (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/18895\\\">#18895<\\/a>, <a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/18945\\\">#18945<\\/a>)<\\/li>\\n<li>Fix: Note\'s timestamp is being updated according to the last activity in Notes (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/19123\\\">#19123<\\/a>)<\\/li>\\n<li>Fix: Accessibility attribute <code>role=navigation<\\/code> is redundant in Nav Menu widget (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/17582\\\">#17582<\\/a>)<\\/li>\\n<li>Fix: Accessibility attribute <code>role=navigation<\\/code> is redundant in pagination in Posts widget<\\/li>\\n<li>Fix: Share buttons is accessible with keyboard but not clickable<\\/li>\\n<li>Fix: Sub-items icons style is missing in preview with Inline Font Icons experiment in Nav Menu widget<\\/li>\\n<li>Fix: Quotes are appearing as HTML when editing a note in Notes<\\/li>\\n<li>Fix: Label\'s Icon height increases when Inline Font Icons experiment is active in Hotspot Widget<\\/li>\\n<li>Fix: Sub conditions of templates are not overridden when importing a Kit<\\/li>\\n<li>Fix: X\\/Y Anchor Point controls were not visible for Scale and Rotate effects<\\/li>\\n<li>Fix: PHP warning notice appears in some situations when using motion effects<\\/li>\\n<\\/ul>\\n<h4>3.7.7 - 2022-09-20<\\/h4>\\n<ul>\\n<li>Fix: Default Flex Grow affects the layout when the container is set to direction Column in various widgets<\\/li>\\n<\\/ul>\\n<h4>3.7.6 - 2022-09-14<\\/h4>\\n<ul>\\n<li>Fix: Submissions menu item appears at the bottom of Elementor section in WordPress dashboard<\\/li>\\n<\\/ul>\\n<h4>3.7.5 - 2022-08-31<\\/h4>\\n<ul>\\n<li>Fix: Error message appears on front if WooCommerce is activated (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/19553\\\">#19553<\\/a>)<\\/li>\\n<\\/ul>\\n<h4>3.7.4 - 2022-08-29<\\/h4>\\n<ul>\\n<li>Tweak: PHP 5.6 Is deprecated<\\/li>\\n<li>Fix: Triangle icon is not being displayed in the Select field when Inline Font Icons Experiment is active in Form widget (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/18598\\\">#18598<\\/a>, <a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/19495\\\">#19495<\\/a>)<\\/li>\\n<li>Fix: The page jumps or flickers to the video playlist on page reload in Video Playlist Widget<\\/li>\\n<\\/ul>\\n<h4>3.7.3 - 2022-07-31<\\/h4>\\n<ul>\\n<li>Tweak: Improved license mechanism for correct validation<\\/li>\\n<li>Fix: Sticky option causes unexpected results when using the Container (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/18357\\\">#18357<\\/a>)<\\/li>\\n<li>Fix: Price list, Portfolio, Flip Box and Gallery widgets disappear when the direction is set to column in Container (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/18880\\\">#18880<\\/a>)<\\/li>\\n<li>Fix: Quotes character is showing up as <code>&amp;quot;<\\/code> when editing a note in Notes<\\/li>\\n<\\/ul>\\n<h4>3.7.2 - 2022-06-15<\\/h4>\\n<ul>\\n<li>Tweak: Applied optimized file handling in various modules<\\/li>\\n<li>Fix: Related posts query options are missing in Posts widget (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/18633\\\">#18633<\\/a>, <a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/18641\\\">#18641<\\/a>)<\\/li>\\n<li>Fix: Menu Cart Icon is not being displayed on all browsers when Inline Font Icons Experiment is active (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/17705\\\">#17705<\\/a>)<\\/li>\\n<li>Fix: Gallery widget is not working as expected in Container element (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/18408\\\">#18408<\\/a>)<\\/li>\\n<li>Fix: Flip box is not visible when the direction is set to Row in Container element (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/18413\\\">#18413<\\/a>)<\\/li>\\n<li>Fix: Portfolio widget is not visible when dragged into &quot;Row&quot; direction Container element (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/17653\\\">#17653<\\/a>)<\\/li>\\n<li>Fix: Menu cart is open automatically in Cart widget (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/18629\\\">#18629<\\/a>)<\\/li>\\n<li>Fix: PHP error is being shown the license is expired in License screen<\\/li>\\n<\\/ul>\\n<h4>3.7.1 - 2022-05-16<\\/h4>\\n<ul>\\n<li>Fix: Notes icon appears as an empty square in admin top bar for users with permissions lower than Editor<\\/li>\\n<li>Fix: Notes experiment causes a PHP fatal error on some cases<\\/li>\\n<li>Fix: UI glitches in Notes feature<\\/li>\\n<\\/ul>\\n<h4>3.7.0 - 2022-05-10<\\/h4>\\n<ul>\\n<li>New: Introducing Notes - Work collaboratively directly within Elementor<\\/li>\\n<li>New: Stripe Button widget - Collect Stripe payments directly from your site (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/14748\\\">#14748<\\/a>)<\\/li>\\n<li>New: Meet WooCommerce Add to Cart dynamic tag - add products to cart from every widget (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/10607\\\">#10607<\\/a>, <a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/11801\\\">#11801<\\/a>)<\\/li>\\n<li>New: Added WooCommerce Product Content dynamic tag (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/16367\\\">#16367<\\/a>)<\\/li>\\n<li>Tweak: Added Related, Upsells and Cross-Sells query sources to Products widget (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/8071\\\">#8071<\\/a>)<\\/li>\\n<li>Tweak: Added custom icon control to Nav Menu widget (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/18007\\\">#18007<\\/a>, <a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/14357\\\">#14357<\\/a>, <a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/13151\\\">#13151<\\/a>, <a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/11361\\\">#11361<\\/a>)<\\/li>\\n<li>Tweak: Added an option to minimize on Desktop device in Table of Contents widget (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/9933\\\">#9933<\\/a>)<\\/li>\\n<li>Tweak: Added dynamic tag controls to Share Buttons widget (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/10729\\\">#10729<\\/a>)<\\/li>\\n<li>Tweak: Added dynamic tag controls to Media Carousel widget (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/10314\\\">#10314<\\/a>)<\\/li>\\n<li>Tweak: Added dynamic tag controls to Form widget (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/6327\\\">#6327<\\/a>, <a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/6691\\\">#6691<\\/a>, <a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/11774\\\">#11774<\\/a>, <a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/9051\\\">#9051<\\/a>)<\\/li>\\n<li>Tweak: Added dynamic tag controls to Posts widget (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/6327\\\">#6327<\\/a>)<\\/li>\\n<li>Tweak: Added dynamic tag controls to Slides widget (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/5760\\\">#5760<\\/a>, <a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/9774\\\">#9774<\\/a>)<\\/li>\\n<li>Tweak: Added align button to bottom option in various Product widgets (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/10263\\\">#10263<\\/a>)<\\/li>\\n<li>Tweak: Added align button to bottom control in Posts and Archive Posts widgets<\\/li>\\n<li>Tweak: Added the ability to hide and show the coupon section in WooCommerce Cart widget<\\/li>\\n<li>Tweak: Added the ability to hide and show the coupon section in WooCommerce Checkout widget<\\/li>\\n<li>Tweak: Added alignment option to various buttons in WooCommerce Cart widget<\\/li>\\n<li>Tweak: Added alignment option to various buttons in WooCommerce Checkout widget<\\/li>\\n<li>Tweak: Added percentage unit to padding control in Additional Information customize section in WooCommerce Checkout widget<\\/li>\\n<li>Tweak: Added quick link to create new theme parts directly from the Finder<\\/li>\\n<li>Tweak: Added the option to add a custom template to Dashboard screen in My Account widget<\\/li>\\n<li>Tweak: Added spacing control to view cart button in various product widgets<\\/li>\\n<li>Tweak: Added the option to add a custom template to empty cart state in Cart widget<\\/li>\\n<li>Tweak: Adjusted the layout of the Payment Methods screen in the My Account widget<\\/li>\\n<li>Tweak: Added lazy load option to Media Carousel, Reviews and Testimonial Carousel widgets<\\/li>\\n<li>Tweak: Added Site Identity quick link to Logo widget<\\/li>\\n<li>Tweak: Added Site Identity quick link to Site Title widget<\\/li>\\n<li>Tweak: Created an attribute that allows disabling page transition for specific links<\\/li>\\n<li>Tweak: Added dynamic tag controls to Gallery widget<\\/li>\\n<li>Tweak: Added dynamic tag controls to Countdown widget<\\/li>\\n<li>Tweak: Added dynamic tag controls to Portfolio widget<\\/li>\\n<li>Tweak: Added dynamic tag controls to Price Table widget<\\/li>\\n<li>Tweak: Added dynamic tag controls to Login widget<\\/li>\\n<li>Tweak: Added dynamic tag controls to Blockquote widget<\\/li>\\n<li>Tweak: Added dynamic tag controls to Facebook Comments widget<\\/li>\\n<li>Tweak: Added dynamic tag controls to Post Navigation widget<\\/li>\\n<li>Tweak: Added dynamic tag controls to Search Form widget<\\/li>\\n<li>Tweak: Added dynamic tag controls to Author Box widget<\\/li>\\n<li>Tweak: Added dynamic tag controls to Post info widget<\\/li>\\n<li>Tweak: Added dynamic tag controls to Archive Posts widget<\\/li>\\n<li>Tweak: Added dynamic tag controls to Product Meta widget<\\/li>\\n<li>Tweak: Added dynamic tag controls to Archive Products widget<\\/li>\\n<li>Tweak: Added dynamic tag controls to Sitemap widget<\\/li>\\n<li>Tweak: Added dynamic tag controls to Reviews widget<\\/li>\\n<li>Tweak: Added dynamic tag controls to Code Highlight widget<\\/li>\\n<li>Tweak: Added dynamic tag controls to PayPal Button widget<\\/li>\\n<li>Tweak: Added dynamic tag controls to WooCommerce Checkout widget<\\/li>\\n<li>Tweak: Added missing PHP documentation to hooks<\\/li>\\n<li>Fix: Scrolling glitches on mobile devices when Sticky Effect is enabled (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/17767\\\">#17767<\\/a>, <a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/18330\\\">#18330<\\/a>)<\\/li>\\n<li>Fix: Only 1st honypot field is validated when using multiple honeypot fields in Forms widget (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/18136\\\">#18136<\\/a>)<\\/li>\\n<li>Fix: Checkout button background color is not working as expected in Cart widget (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/18289\\\">#18289<\\/a>)<\\/li>\\n<li>Fix: Button labels are not accessible for screen readers in Share buttons widget (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/8615\\\">#8615<\\/a>)<\\/li>\\n<li>Fix: Downloads titles controls are not working in responsive in WooCommerce Purchase Summary widget<\\/li>\\n<li>Fix: Excerpt length is not working as expected in Posts and Archive Posts widgets<\\/li>\\n<li>Fix: Titles &amp; Totals weight is not working in WooCommerce Checkout widget<\\/li>\\n<li>Fix: Product image is not appearing on Single Product Page on template load<\\/li>\\n<li>Fix: Additional Information title not editable in some scenarios in WooCommerce Checkout widget<\\/li>\\n<li>Fix: Cart is not updating automatically on mobile in Cart widget<\\/li>\\n<li>Fix: UI Glitch in Masonry control in Portfolio widget<\\/li>\\n<li>Fix: Custom breakpoints experiment didn\'t work on Single post and page templates<\\/li>\\n<li>Fix: Testimonial carousel &amp; Reviews widgets disregards the <code>alt<\\/code> attribute<\\/li>\\n<li>Fix: Playlist widget deeplink didn\'t send user directly to the widget in the page<\\/li>\\n<li>Fix: Masonry option causes the images to disappear in the Editor in Posts widget<\\/li>\\n<li>Fix: Scrollbar appears after clicking on the dropdown toggle in Nav Menu widget<\\/li>\\n<li>Fix: Custom icons disappear on frontend if the pack name contains numbers<\\/li>\\n<li>Fix: Custom Font disappears if the name contains only numbers<\\/li>\\n<li>Fix: <code>end-section()<\\/code> is missing from Progress Tracker and Facebook Embed widgets<\\/li>\\n<li>Tweak: Added a filter for conditions cache query in Theme Builder<\\/li>\\n<li>Fix: Customizations lost on Ajax refresh in WooCommerce Cart widget<\\/li>\\n<li>Fix: Hello theme Header and Footer experiment is not working when WooCommerce plugin is active<\\/li>\\n<li>Fix: Color controls are not working as expected in Checkout widget<\\/li>\\n<li>Fix: Color controls are not working as expected in My Account widget<\\/li>\\n<li>Fix: Empty state widget preview in the editor is disappearing in various widgets<\\/li>\\n<li>Fix: Cart is not updating automatically on mobile in WooCommerce Cart widget<\\/li>\\n<li>Deprecated: See all deprecations to this version in our <a href=\\\"https:\\/\\/developers.elementor.com\\/v3-7-planned-deprecations\\/\\\">Developers Deprecations Post<\\/a><\\/li>\\n<\\/ul>\\n<h4>3.6.5 - 2022-04-12<\\/h4>\\n<ul>\\n<li>Fix: Compatibility issues for several widgets in iOS 14 and macOS 13 devices (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/18090\\\">#18090<\\/a>, <a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/15910\\\">#15910<\\/a>)<\\/li>\\n<li>Fix: Button Alignment doesn\'t work in Custom Add To Cart widget (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/17810\\\">#17810<\\/a>)<\\/li>\\n<li>Fix: PHP warning is thrown in some cases in PayPal button widget<\\/li>\\n<li>Fix: PHP 8.1 throws errors and notices in some cases<\\/li>\\n<li>Fix: PHP notice was thrown when Kit Import process initiated without display conditions<\\/li>\\n<li>Fix: Create Account button always opens on the Sign Up screen even if the user has an account in Onboarding process<\\/li>\\n<\\/ul>\\n<h4>3.6.4 - 2022-03-15<\\/h4>\\n<ul>\\n<li>Tweak: Kit import dynamic reference support for templates and dynamic tags<\\/li>\\n<li>Tweak: Updated tested up to version tag to <code>3.6.0<\\/code><\\/li>\\n<li>Fix: Sticky caused scrolling issues after clicking an element that expands the page height (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/17821\\\">#17821<\\/a>, <a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/17839\\\">#17839<\\/a>, <a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/18069\\\">#18069<\\/a>)<\\/li>\\n<li>Fix: When saving Global widget JS error is being thrown and editor fails to load (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/17954\\\">#17954<\\/a>)<\\/li>\\n<li>Fix: Motion effects are missing from Background section under Style tab in Container element (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/18063\\\">#18063<\\/a>)<\\/li>\\n<li>Fix: Imported Kit doesn\'t appear in the theme builder after successful import in some cases<\\/li>\\n<li>Fix: Added future Pro support to fix the Cart icon that shifted aside in Menu cart widget<\\/li>\\n<\\/ul>\\n<h4>3.6.3 - 2022-02-28<\\/h4>\\n<ul>\\n<li>Fix: Custom Code display conditions modal is not working (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/17865\\\">#17865<\\/a>, <a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/17942\\\">#17942<\\/a>, <a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/17994\\\">#17994<\\/a>)<\\/li>\\n<li>Fix: Share buttons are not accessible for keyboard navigation (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/8615\\\">#8615<\\/a>)<\\/li>\\n<\\/ul>\\n<h4>3.6.2 - 2022-02-14<\\/h4>\\n<ul>\\n<li>Fix: Auto updates mechanism is not working as expected (this version might be also installed automatically)<\\/li>\\n<\\/ul>\\n<h4>3.6.1 - 2022-02-09<\\/h4>\\n<ul>\\n<li>Tweak: Allow connecting via generic source for future feature support<\\/li>\\n<li>Fix: Custom Code doesn\'t work when WooCommerce is active (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/17675\\\">#17675<\\/a>)<\\/li>\\n<li>Fix: Content animation didn\'t work when Improved asset loading experiment is active Slides widget (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/17055\\\">#17055<\\/a>)<\\/li>\\n<li>Fix: PHP warning appears some times when trying to force-check for available updates<\\/li>\\n<li>Fix: Page transitions are being triggered when not needed<\\/li>\\n<li>Fix: Text alignment on Tablet responsive device affects base device in Testimonial Carousel widget<\\/li>\\n<li>Fix: Harden Submissions feature to prevent potential security issues<\\/li>\\n<li>Fix: Page Transitions Icon option Preloader doesn\'t work on frontend<\\/li>\\n<\\/ul>\\n<h4>3.6.0 - 2022-01-31<\\/h4>\\n<ul>\\n<li>New: WooCommerce Purchase Summary widget - Fully customize the content and style of your order summary page (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/5756\\\">#5756<\\/a>, <a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/15862\\\">#15862<\\/a>)<\\/li>\\n<li>New: WooCommerce Notices styling on Site Settings - Customize the appearance of WooCommerce notices (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/14570\\\">#14570<\\/a>, <a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/15896\\\">#15896<\\/a>)<\\/li>\\n<li>New: WooCommerce Notices widget - Set the position of WooCommerce notices on your shop pages (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/8124\\\">#8124<\\/a>)<\\/li>\\n<li>Experiment: Page Transitions - Customize the page loading experience, and increase brand recognition (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/10576\\\">#10576<\\/a>)<\\/li>\\n<li>Tweak: Added WooCommerce &amp; Theme Elements widgets to Improved CSS Loading experiment to save up 126KB per page load (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/17412\\\">#17412<\\/a>, <a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/17337\\\">#17337<\\/a>)<\\/li>\\n<li>Tweak: Added new layout options in WooCommerce Add To Cart and WooCommerce Custom Add To Cart widgets (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/5437\\\">#5437<\\/a>, <a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/10617\\\">#10617<\\/a>)<\\/li>\\n<li>Tweak: Added Stroke functionality for typography control in various widgets (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/11158\\\">#11158<\\/a>)<\\/li>\\n<li>Tweak: Removed <code>elementor-section-wrap<\\/code> by adding it to the Optimized DOM Output experiment (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/16950\\\">#16950<\\/a>)<\\/li>\\n<li>Tweak: Added style controls for variations in WooCommerce Menu Cart widget<\\/li>\\n<li>Tweak: Added color control to navigation dots in Media Carousel, Reviews, and Slides widgets<\\/li>\\n<li>Tweak: Disabled Vimeo autoplay on edit mode when getting video data in Video Playlist widget<\\/li>\\n<li>Tweak: Added notice about Facebook\'s new EU consent policy in Facebook Button, Facebook Comments, Facebook Embed, and Facebook Page widgets<\\/li>\\n<li>Tweak: Refactor string translation calls to use native WP translation methods<\\/li>\\n<li>Tweak: Convert <code>home_url<\\/code> license API call to <code>get_site_url<\\/code> for better compatibility<\\/li>\\n<li>Tweak: Promoted Default to New Theme Builder and Scroll Snap experiments to Stable status in Experiments screen<\\/li>\\n<li>Tweak: Scroll Snap experiment set to active by default for all websites in Experiments screen<\\/li>\\n<li>Tweak: Scrolling Effects in Header and Section backgrounds are not working as expected when effects are relative to the entire page<\\/li>\\n<li>Tweak: Added &quot;Auto Updates&quot; capability to Pro versions<\\/li>\\n<li>Tweak: Removed sequenced animation hover effect option from Classic skin in Call to Action widget<\\/li>\\n<li>Tweak: Added &quot;Excerpt Length&quot; control in Post Excerpt widget<\\/li>\\n<li>Tweak: Deleted deprecated methods from Query Control module<\\/li>\\n<li>Tweak: Adjusted Inline-CSS Experiment to work with Additional Custom Breakpoints experiment<\\/li>\\n<li>Fix: Automatically open cart functionality didn\'t work in product page in WooCommerce Menu Cart widget (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/5921\\\">#5921<\\/a>, <a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/16276\\\">#16276<\\/a>,<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/16879\\\">#16879<\\/a>)<\\/li>\\n<li>Fix: Buttons are not visible when there are too many products in the cart in WooCommerce Menu Cart widget (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/16221\\\">#16221<\\/a>, <a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/17283\\\">#17283<\\/a>,<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/16333\\\">#16333<\\/a>,<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/13005\\\">#13005<\\/a>)<\\/li>\\n<li>Fix: Mini cart modal z-index is too low in WooCommerce Menu Cart widget (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/16333\\\">#16333<\\/a>)<\\/li>\\n<li>Fix: Side cart buttons are not visible at first glance on mobile in WooCommerce Menu Cart widget (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/16221\\\">#16221<\\/a>)<\\/li>\\n<li>Fix: Read More field recognizes inline HTML elements as plain text in Posts and Archive Posts widget (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/16985\\\">#16985<\\/a>)<\\/li>\\n<li>Fix: Load More functionality caused JS error console in Posts widget (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/17036\\\">#17036<\\/a>)<\\/li>\\n<li>Fix: Autoplay is not working as expected when the lazy load is active in Video Playlist widget (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/15304\\\">#15304<\\/a>, <a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/16274\\\">#16274<\\/a>)<\\/li>\\n<li>Fix: Right navigation area wasn\'t 100% clickable in Post Navigation widget (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/14252\\\">#14252<\\/a>)<\\/li>\\n<li>Fix: Posts duplicate when there are two Posts widgets inside a page using pagination functionality (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/17056\\\">#17056<\\/a>)<\\/li>\\n<li>Fix: Global widget changes are not reflected on frontend (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/16820\\\">#16820<\\/a>)<\\/li>\\n<li>Fix: JS Error console message when using the Load More functionality and Post Per Page option in Posts widget<\\/li>\\n<li>Fix: Heading styling is not being loaded when Inline CSS experiment is active in Post and Page Title widgets<\\/li>\\n<li>Fix: Sticky offset not working as expected when changing device mode on the browser<\\/li>\\n<li>Fix: Scroll Snap functionality wasn\'t applied on Templates and Archives<\\/li>\\n<li>Fix: Toggle icon color didn\'t work on hover state when Inline Font Icons experiment is activated in Nav Menu widget<\\/li>\\n<li>Fix: Variations style controls are not working as expected in WooCommerce Add to Cart widget<\\/li>\\n<li>Fix: Display conditions module is not working as expected when using the new Theme Builder UI<\\/li>\\n<li>Fix: Edit header handles <code>z-index<\\/code> issues in Header document<\\/li>\\n<li>Fix: Panel icons UI glitch in Call To Action widget<\\/li>\\n<li>Fix: WordPress 5.9 <code>WP_User_query<\\/code> <code>who<\\/code> argument deprecation adjustments<\\/li>\\n<\\/ul>\\n<h4>3.5.2 - 2021-11-28<\\/h4>\\n<ul>\\n<li>Tweak: Adjusted license mechanism to support trial period<\\/li>\\n<li>Fix: Updates made to Global Widgets do not reflect accordingly to linked widgets (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/16815\\\">#16815<\\/a>)<\\/li>\\n<li>Fix: Hamburger toggle button doesn\'t change to \\u201cclose\\u201d when menu is collapsed in Nav Menu widget when Inline Font Awesome experiment is active<\\/li>\\n<li>Fix: Global Widget cannot be unlinked<\\/li>\\n<\\/ul>\\n<h4>3.5.1 - 2021-11-10<\\/h4>\\n<ul>\\n<li>Fix: Inline HTML elements appear as plain text in Animated Headline widget (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/16816\\\">#16816<\\/a>)<\\/li>\\n<li>Fix: Dropdown items inherited values from Main Menu space between control in Nav Menu widget (<a href=\\\"(https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/16815)\\\">#16815<\\/a><\\/li>\\n<li>Fix: Order Summary titles style controls not applying on various devices in Cart widget<\\/li>\\n<li>Fix: Panel &quot;Need Help&quot; link is not correct in WooCommerce section in Site Settings<\\/li>\\n<\\/ul>\\n<h4>3.5.0 - 2021-11-01<\\/h4>\\n<ul>\\n<li>New: WooCommerce Checkout widget - Fully customize the content and style of your checkout page (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/15282\\\">#15282<\\/a>, <a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/15990\\\">#15990<\\/a>, <a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/11014\\\">#11014<\\/a>, <a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/13218\\\">#13218<\\/a>, <a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/5383\\\">#5383<\\/a>)<\\/li>\\n<li>New: WooCommerce Cart widget - Style your cart page the way you want with design flexibility (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/15282\\\">#15282<\\/a>, <a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/11014\\\">#11014<\\/a>, <a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/13218\\\">#13218<\\/a>, <a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/5383\\\">#5383<\\/a>)<\\/li>\\n<li>New: WooCommerce My Account widget - Create a custom design for your my account pages (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/11014\\\">#11014<\\/a>, <a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/5383\\\">#5383<\\/a>)<\\/li>\\n<li>New: Progress Tracker widget - Motivate your customers to keep reading your site content (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/16576\\\">#16576<\\/a>)<\\/li>\\n<li>New: Meet WooCommerce Site Settings - Set your store pages within Elementor<\\/li>\\n<li>Experiment: Scroll Snap - Set the scene of every scroll (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/10752\\\">#10752<\\/a>)<\\/li>\\n<li>Tweak: Changed infrastructure to prevent rendering bugs in Global Widget (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/16354\\\">#16354<\\/a>)<\\/li>\\n<li>Tweak: Added the option to open submission in a new tab in Form Submissions (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/14967\\\">#14967<\\/a>)<\\/li>\\n<li>Tweak: Added various responsive controls in Posts widget (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/1851\\\">#1851<\\/a>)<\\/li>\\n<li>Tweak: Split Title and Price styling controls in Price List widget (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/7688\\\">#7688<\\/a>)<\\/li>\\n<li>Tweak: Added various responsive capabilities to controls in Posts Archive widget<\\/li>\\n<li>Tweak: Adjusted Motion Effects module to support future feature<\\/li>\\n<li>Tweak: Changed admin notice content when Pro installed without Core installed<\\/li>\\n<li>Tweak: Cleanup in <code>wp_options<\\/code> table<\\/li>\\n<li>Tweak: Changed Connect logic in Elementor top bar to simplify the connect process<\\/li>\\n<li>Tweak: Marked new Theme Builder as an Experiment and set to default for new sites<\\/li>\\n<li>Tweak: Enforced better security policies in various widgets and modules<\\/li>\\n<li>Tweak: Added load more button functionality to the Posts Archive widget<\\/li>\\n<li>Tweak: Renamed Elementor\'s responsive SCSS variables<\\/li>\\n<li>Tweak: Added dividers to horizontal layout in Nav Menu widget<\\/li>\\n<li>Tweak: Removed Google+ social network from Share Buttons widget<\\/li>\\n<li>Tweak: Convert usage of old Responsive class to use the new Breakpoints Manager<\\/li>\\n<li>Fix: jQuery in Heading doesn\'t work for not logged in users in Custom Code (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/14515\\\">#14515<\\/a>, <a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/14266\\\">#14266<\\/a>)<\\/li>\\n<li>Fix: Menu animation causing page horizontal scroll in Nav Menu widget (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/15184\\\">#15184<\\/a>)<\\/li>\\n<li>Fix: Wrong function call in Table of Content &amp; Post Excerpt widgets (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/16547\\\">#16547<\\/a>)<\\/li>\\n<li>Fix: Slides to Scroll control can\'t be set to Default if Widescreen mode has a value in Testimonial Carousel widget<\\/li>\\n<li>Fix: Sticky offset not working properly when changing device mode<\\/li>\\n<li>Fix: UTF character issues when exporting CSV file in Form Submissions<\\/li>\\n<li>Fix: Load More functionality doesn\'t work when the Posts widget placed inside an Archive template<\\/li>\\n<li>Fix: UI glitches and editing issues in Video Playlist widget<\\/li>\\n<\\/ul>\\n<h4>3.4.2 - 2021-10-12<\\/h4>\\n<ul>\\n<li>Fix: Icons color style conflicts when Font-Awesome Inline experiment is active in Share Buttons widget (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/16435\\\">#16435<\\/a>)<\\/li>\\n<li>Fix: Mini Cart hides page content when closed in Menu Cart widget (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/16305\\\">#16305<\\/a>)<\\/li>\\n<li>Fix: UI glitches in the Editor edit mode when inserting Post Content widget and Font-Awesome Inline experiment is active in Single Post template (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/16358\\\">#16358<\\/a>)<\\/li>\\n<li>Fix: Slides per view controls disappeared from multiple breakpoints in Testimonial Carousel<\\/li>\\n<li>Fix: Product variations UI glitch in Menu Cart widget<\\/li>\\n<li>Fix: Buttons UI glitch on Safari browser in Menu Cart widget<\\/li>\\n<\\/ul>\\n<h4>3.4.1 - 2021-09-01<\\/h4>\\n<ul>\\n<li>Fix: Sticky functionality is not working if the Additional Custom Breakpoints experiment is active (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/16186\\\">#16186<\\/a>)<\\/li>\\n<li>Fix: Slideshow skin UI glitch in Media Carousel widget<\\/li>\\n<li>Fix: Product price typography weight control is not working as expected in Menu Cart widget<\\/li>\\n<\\/ul>\\n<h4>3.4.0 - 2021-09-01<\\/h4>\\n<ul>\\n<li>Tweak: Added new Mini Cart layout type in Menu Cart widget (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/11312\\\">#11312<\\/a>)<\\/li>\\n<li>Tweak: Added styling options for Cart, Products, and Cart buttons in Menu Cart widget (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/14952\\\">#14952<\\/a>)<\\/li>\\n<li>Tweak: Added the ability to open cart automatically when an item is added in Menu Cart widget (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/14119\\\">#14119<\\/a>)<\\/li>\\n<li>Tweak: Added the ability to remove an item from cart without reloading the page with an AJAX request (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/9531\\\">#9531<\\/a>, <a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/10875\\\">#10875<\\/a>, <a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/11309\\\">#11309<\\/a>)<\\/li>\\n<li>Tweak: Added Load More AJAX functionality to Posts widget (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/12126\\\">#12126<\\/a>, <a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/1284\\\">#1284<\\/a>, <a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/14557\\\">#14557<\\/a>)<\\/li>\\n<li>Tweak: Added Vimeo support to the Video Playlist widget (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/15319\\\">#15319<\\/a>)<\\/li>\\n<li>Tweak: Improved asset loading performance by serving lighter JS files (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/8572\\\">#8572<\\/a>)<\\/li>\\n<li>Tweak: Added query string to the URL only after the first video is played in Video Playlist widget (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/15348\\\">#15348<\\/a>)<\\/li>\\n<li>Tweak: Added various layout options with more responsive controls and cart structure options in Menu Cart widget<\\/li>\\n<li>Tweak: Added the option to open the menu cart by click or hover in Menu Cart widget<\\/li>\\n<li>Tweak: Added the ability to choose a specific product to draw data from in WooCommerce Dynamic tags<\\/li>\\n<li>Tweak: Removed auto-scroll to the widget location when arriving from external URL in Video Playlist widget<\\/li>\\n<li>Tweak: Removed the Video Playlist widget from the Experiments list<\\/li>\\n<li>Tweak: Added descriptive error messages for MailChimp action after submit and on form submit in Forms widget<\\/li>\\n<li>Tweak: Added tooltip trigger None and Hover for link in Hotspot widget<\\/li>\\n<li>Tweak: Added responsive controls to Offset and Effects Offset in Sticky options<\\/li>\\n<li>Tweak: Added responsive control to Alignment in Testimonial Carousel widget<\\/li>\\n<li>Tweak: Adjusted Motion Effects module to support future feature<\\/li>\\n<li>Tweak: Added future compatibility to support better loading of <code>eicons<\\/code> font<\\/li>\\n<li>Tweak: Changed Rename Part title and button color in Theme Builder<\\/li>\\n<li>Fix: Products don\'t appear on the cart while editing in Menu Cart widget (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/15451\\\">#15451<\\/a>)<\\/li>\\n<li>Fix: Videos always start muted in the Video Playlist widget (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/15292\\\">#15292<\\/a>)<\\/li>\\n<li>Fix: Unnecessary spacing if submenu indicator is set to None in Nav Menu widget (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/15365\\\">#15365<\\/a>)<\\/li>\\n<li>Fix: MailChimp double opt-in feature doesn\'t work in Forms widget<\\/li>\\n<li>Fix: Fetching MailChimp groups field blocks the loading of the rest of the fields in the Form widget<\\/li>\\n<li>Fix: Missing field IDs causes forms not to be sent in Forms widget<\\/li>\\n<li>Fix: Full Content Skin is not working properly when inserted twice on the same page in Posts widget<\\/li>\\n<li>Fix: Avoid Duplicates option doesn\'t exclude manual selections in Posts widget<\\/li>\\n<li>Fix: Submenu indicator alignment issue in Nav menu widget<\\/li>\\n<li>Fix: Query control deprecated message appears when debug mode is defined<\\/li>\\n<li>Fix: Tweet Button icon incorrect color and size when the icon is rendered as SVG in Blockquote widget<\\/li>\\n<li>Fix: Video icon size is not changing on Active state in Video Playlist widget<\\/li>\\n<li>Fix: Header icon color is not working in Table Of Content widget<\\/li>\\n<li>Fix: Icons style glitches when Font Awesome Inline experiment is active in Video Playlist widget<\\/li>\\n<li>Fix: Bullet markers are not visible on preview mode when Font Awesome Inline experiment is active in Table of Content widget<\\/li>\\n<li>Fix: UI Glitch when Font-Awesome Inline experiment is active in Price Table widget<\\/li>\\n<li>Fix: Submenu Indicator appears larger when Font Awesome Inline experiment is active in Nav Menu widget<\\/li>\\n<li>Fix: Part name is deleted when clicking on the &quot;Change&quot; Button without changing the name in Theme Builder<\\/li>\\n<li>Fix: Redundant pagination queries in the Editor<\\/li>\\n<li>Deprecated: Remove all usages of <code>ElementorUtils::get_create_new_post_url()<\\/code><\\/li>\\n<li>Deprecated: See all deprecations to this version in our <a href=\\\"https:\\/\\/developers.elementor.com\\/v3-4-planned-deprecations\\/\\\">Developers Deprecations Post<\\/a><\\/li>\\n<\\/ul>\\n<h4>3.3.8 - 2021-08-23<\\/h4>\\n<ul>\\n<li>Fix: Products grid width issue when adjusting columns and rows in Products widget (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/16001\\\">#16001<\\/a>)<\\/li>\\n<li>Fix: Font Awesome Inline experiment causes icons glitch in Price Table widget (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/16045\\\">#16045<\\/a>)<\\/li>\\n<li>Fix: reCAPTCHA v3 <code>z-index<\\/code> is lower than the Section\'s background color<\\/li>\\n<li>Fix: Style missing when Font Awesome inline experiment is active in Post Info widget<\\/li>\\n<li>Fix: Font Awesome icons were not loaded in Post Info widget<\\/li>\\n<li>Fix: Zero character can\'t be used as a placeholder in Number field in Form widget<\\/li>\\n<li>Fix: Carousels are not working properly in the Editor when Additional Custom Breakpoints experiment is active<\\/li>\\n<\\/ul>\\n<h4>3.3.7 - 2021-08-15<\\/h4>\\n<ul>\\n<li>Tweak: Added support for Additional Custom Breakpoints in Nav Menu widget<\\/li>\\n<li>Tweak: Added support for Additional Custom breakpoints in Motion Effects<\\/li>\\n<li>Fix: Columns didn\'t respond to changes in Gallery widget if Additional Custom Breakpoints Experiment is active<\\/li>\\n<\\/ul>\\n<h4>3.3.6 - 2021-08-10<\\/h4>\\n<ul>\\n<li>Tweak: Added support for future feature in Nav Menu widget<\\/li>\\n<li>Fix: WooCommerce responsive grid styles are not being reflected in Product Related widget (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/15857\\\">#15857<\\/a>)<\\/li>\\n<li>Fix: WooCommerce responsive grid styles are not being reflected in Upsells widget (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/15857\\\">#15857<\\/a>)<\\/li>\\n<li>Fix: WooCommerce responsive grid styles are not being reflected in Product Categories widget (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/15857\\\">#15857<\\/a>)<\\/li>\\n<\\/ul>\\n<h4>3.3.5 - 2021-08-01<\\/h4>\\n<ul>\\n<li>Fix: Responsive layout glitches in Products and Products Archive widgets (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/15773\\\">#15773<\\/a>)<\\/li>\\n<li>Fix: reCAPTCHA V3 integration conflict with required fields validation in Forms widget<\\/li>\\n<\\/ul>\\n<h4>3.3.4 - 2021-07-21<\\/h4>\\n<ul>\\n<li>Fix: Grid layout glitch in WooCommerce Products Archive widget (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/15718\\\">#15718<\\/a>)<\\/li>\\n<\\/ul>\\n<h4>3.3.3 - 2021-07-20<\\/h4>\\n<ul>\\n<li>Tweak: Added a descriptive message in Collect Submissions action after submit<\\/li>\\n<li>Tweak: Added future compatibility for Additional Custom Breakpoints for Pro widgets<\\/li>\\n<li>Fix: Some widget style breaks when Improved CSS Loading Experiment is active in certain cases (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/15632\\\">#15632<\\/a>, <a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/15683\\\">#15683<\\/a>, <a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/15660\\\">#15660<\\/a>)<\\/li>\\n<li>Fix: Translation update keep appearing as available after install (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/14297\\\">#14297<\\/a>)<\\/li>\\n<li>Fix: Wrong default icon color when using Font Awesome icons as inline SVG in Call to Action widget<\\/li>\\n<\\/ul>\\n<h4>3.3.2 - 2021-07-13<\\/h4>\\n<ul>\\n<li>Tweak: Updated plugin description<\\/li>\\n<li>Fix: MailChimp tags in form widget replaced existing tags (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/11111\\\">#11111<\\/a>)<\\/li>\\n<li>Fix: Clicking videos from the items list in edit mode doesn\\u2019t initiate videos properly<\\/li>\\n<li>Fix: User unauthorized message when activated but not connected in Kit Library<\\/li>\\n<li>Fix: Carousel widgets did not support additional custom breakpoint responsive values<\\/li>\\n<li>Fix: Tab border is overridden by the Section background color in Video Playlist widget<\\/li>\\n<li>Fix: Widgets style breaks when Improved CSS Load experiment is active in a Single Page template and Post Content widget<\\/li>\\n<\\/ul>\\n<h4>3.3.1 - 2021-06-20<\\/h4>\\n<ul>\\n<li>Tweak: Added support for more Theme Builder display conditions in Export \\/ Import experiment<\\/li>\\n<li>Tweak: Adjusted License page heading structure for future feature<\\/li>\\n<li>Tweak: Adjusted Font Awesome icon for allowing support for future feature<\\/li>\\n<li>Fix: <code>frontend.min.js<\\/code> file size increased in Elementor Pro 3.3.0 (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/15278\\\">#15278<\\/a>)<\\/li>\\n<li>Fix: Prevent conditions from being reset when object cache is enabled in site (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/13299\\\">#13299<\\/a>)<\\/li>\\n<li>Fix: Custom Code publish modal responsiveness issues (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/14519\\\">#14519<\\/a>)<\\/li>\\n<li>Fix: Populating fields with options programmatically doesn\'t appear in Submissions screen (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/10671\\\">#10671<\\/a>)<\\/li>\\n<li>Fix: Large images are not shown on the Image Carousel widget when set via Toolset dynamic tag<\\/li>\\n<li>Fix: Enable inline editing to the inner content tabs in Video Playlist widget<\\/li>\\n<li>Fix: Clicking on the video list doesn\'t play videos properly in Video Playlist widget<\\/li>\\n<li>Fix: Hide Play Icon control when Image overlay is toggled off in Video Playlist widget<\\/li>\\n<li>Fix: Removed extra space below the player when viewing from mobile view in Video Playlist widget<\\/li>\\n<li>Fix: Import button is not working properly in Theme Builder interface<\\/li>\\n<li>Fix: Preview Dynamic Content as control is not updating preview and throws an error in Popup Builder<\\/li>\\n<\\/ul>\\n<h4>3.3.0 - 2021-06-08<\\/h4>\\n<ul>\\n<li>New: Video Playlist widget - Add Engaging Video Content to Your Website (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/11859\\\">#11859<\\/a>, <a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/7803\\\">#7803<\\/a>)<\\/li>\\n<li>New: Hotspot widget - Create Interactive Images With Contextually Relevant Information (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/7282\\\">#7282<\\/a>, <a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/2768\\\">#2768<\\/a>)<\\/li>\\n<li>Tweak: Accessibility improvements for sub-menus in Nav Menu widget (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/13859\\\">#13859<\\/a>, <a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/13810\\\">#13810<\\/a>)<\\/li>\\n<li>Tweak: MailChimp action after submit can now add new tags to existing subscribers in Forms widget (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/11111\\\">#11111<\\/a>)<\\/li>\\n<li>Tweak: Added <code>elementor_pro\\/forms\\/record\\/actions_before<\\/code> to filter the record before it sent to Actions After Submit in Forms widget (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/14261\\\">#14261<\\/a>)<\\/li>\\n<li>Tweak: Yoast SEO breadcrumbs widget can be used in Elementor without the need of enabling them in Yoast setting<\\/li>\\n<li>Tweak: Added future support for widgets CSS conditional loading (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/10329\\\">#10329<\\/a>, <a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/14229\\\">#14229<\\/a>)<\\/li>\\n<li>Tweak: Added future support for Sticky JS library conditional loading<\\/li>\\n<li>Tweak: Added future support for Import \\/ Export experiment<\\/li>\\n<li>Tweak: Preparations and fixes for Import Export Experiment in Pro version<\\/li>\\n<li>Tweak: Added gradient button capabilities to Login widget buttons<\\/li>\\n<li>Tweak: Added gradient button capabilities to Slides widget button<\\/li>\\n<li>Tweak: Added gradient button capabilities to Price Table widget button<\\/li>\\n<li>Tweak: Added gradient button capabilities to Flip Box widget button<\\/li>\\n<li>Tweak: Added Code Highlight widget Developers Documentation<\\/li>\\n<li>Tweak: Adjusted Submissions page for future updates<\\/li>\\n<li>Tweak: Added <code>em<\\/code> and <code>%<\\/code> units for padding control in Carousel widgets<\\/li>\\n<li>Tweak: Shorten currency name to currency symbol in PayPal button widget<\\/li>\\n<li>Fix: Custom Fonts URLs should be replaced when replace URL is triggered (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/7376\\\">#7376<\\/a>, <a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/10382\\\">#10382<\\/a>)<\\/li>\\n<li>Fix: The currency symbol size changed in the Price Table widget if enabling sale (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/13519\\\">#13519<\\/a>)<\\/li>\\n<li>Fix: Nav Menu widget is not loading Font Awesome submenu icons (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/9907\\\">#9907<\\/a>)<\\/li>\\n<li>Fix: Hamburger toggle is not working in Nav menu widget<\\/li>\\n<li>Fix: Activation bug for IDN domains<\\/li>\\n<li>Fix: Conditions modal responsive glitches in Custom Code<\\/li>\\n<li>Fix: Duplicated strings in Custom Code module<\\/li>\\n<li>Fix: Enable resize option for code input field in Custom Code<\\/li>\\n<li>Fix: \\u201cSave &amp; Close \\u201cbutton in Custom Code\'s Conditions modal was not visible on small screen sizes<\\/li>\\n<li>Fix: Removing a column from a section in the navigator resulted in an empty section<\\/li>\\n<li>Fix: Recommend option is cut If the layout is not &quot;Standard&quot; in the Facebook Button widget<\\/li>\\n<li>Fix: Video item does not play without adding an image in Media Carousel widget<\\/li>\\n<li>Fix: <code>search-plus<\\/code> icon missing from panel in Media Carousel widget<\\/li>\\n<li>Fix: UI hover state glitch in Media Carousel widget<\\/li>\\n<li>Fix: PHP notice was thrown when trying to import a kit without overrideConditions parameter in Kit Import flow<\\/li>\\n<li>Fix: Templates conditions not imported if there are no conflicts in Import Export Experiment<\\/li>\\n<li>Fix: Non english values are not encoded properly on Submissions export<\\/li>\\n<li>Fix: Theme Builder import is not working properly<\\/li>\\n<li>Fix: UI glitch when no global widgets were found in Editor Panel<\\/li>\\n<li>Deprecated: See all deprecations to this version in our <a href=\\\"https:\\/\\/developers.elementor.com\\/v3-3-planned-deprecations\\/\\\">Developers Deprecations Post<\\/a><\\/li>\\n<\\/ul>\\n<h4>3.2.2 - 2021-05-05<\\/h4>\\n<ul>\\n<li>Tweak: Added support for Expert tier templates in Templates Library<\\/li>\\n<li>Tweak: Updated compatibility tag to support Elementor v3.2.x<\\/li>\\n<li>Tweak: Added compatibility for future Library improvements<\\/li>\\n<li>Fix: Toolset image dynamic field is not working with Gallery widget<\\/li>\\n<\\/ul>\\n<h4>3.2.1 - 2021-03-21<\\/h4>\\n<ul>\\n<li>Tweak: Added strings context in PayPal button and Price Table widgets<\\/li>\\n<li>Tweak: Added support for future Import \\/ Export Kit feature<\\/li>\\n<li>Fix: Submissions with over than 191 characters weren\'t indexed properly<\\/li>\\n<\\/ul>\\n<h4>3.2.0 - 2021-03-14<\\/h4>\\n<ul>\\n<li>New: PayPal Button widget - Collect PayPal payments directly from your site<\\/li>\\n<li>Experiment: Submissions - Save all of your form submissions in one place (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/1686\\\">#1686<\\/a>)<\\/li>\\n<li>Tweak: Added Stay In Column option to Inner Section element (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/7956\\\">#7956<\\/a>)<\\/li>\\n<li>Tweak: Adjusted \'Max Height\' control range in Table of Contents widget<\\/li>\\n<li>Tweak: Changed descriptive text in Create Custom Code screen<\\/li>\\n<li>Tweak: Added support for dynamic capabilities in Code Highlight widget<\\/li>\\n<li>Tweak: Added support for future load on demand for <code>share-link<\\/code> library<\\/li>\\n<li>Tweak: Added support for future load on demand for <code>dialog<\\/code> library in Popup<\\/li>\\n<li>Tweak: Allow overwriting the assets URL when using a mirror domain<\\/li>\\n<li>Fix: Animation was triggered multiple times when accessing the viewport in certain cases in Animated Headline widget (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/13951\\\">#13951<\\/a>)<\\/li>\\n<li>Fix: Location is not being updated after a Custom Code snippet is published (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/13971\\\">#13971<\\/a>)<\\/li>\\n<li>Fix: Custom Fonts CSS files were not updated after regenerating CSS files<\\/li>\\n<li>Fix: Conditions modal is not responsive in Custom Code<\\/li>\\n<li>Fix: Empty order buttons are displayed in Custom Fonts screen<\\/li>\\n<li>Fix: Typo in \'Reply To\' Email action after submit placeholder in Forms widget<\\/li>\\n<li>Fix: Unnecessary Save Draft button in Custom Code<\\/li>\\n<li>Fix: RTL glitches in Custom Code<\\/li>\\n<li>Fix: Sanitized options in the editor to enforce better security policies<\\/li>\\n<li>Deprecated: See all deprecations to this version in our (<a href=\\\"https:\\/\\/developers.elementor.com\\/v3-2-planned-deprecations\\/\\\">Developers Deprecations Post<\\/a>)<\\/li>\\n<\\/ul>\\n<h4>3.1.1 - 2021-02-23<\\/h4>\\n<ul>\\n<li>Tweak: Adjusted \'Max Height\' control range in Table of Contents widget<\\/li>\\n<li>Fix: Popup event handler is undefined (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/11475]\\\">#11475<\\/a>, <a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/10690\\\">#10690<\\/a>)<\\/li>\\n<li>Fix: Conditions modal is not responsive in Custom Code<\\/li>\\n<li>Fix: RTL glitches in Code Highlight widget<\\/li>\\n<li>Fix: Minor UI glitches in Code Highlight widget<\\/li>\\n<li>Fix: Users can\'t get Pro Developer Edition version updates<\\/li>\\n<\\/ul>\\n<h4>3.1.0 - 2021-02-13<\\/h4>\\n<ul>\\n<li>New: Introducing Custom Code - Add custom code snippets to your site, including <code>head<\\/code>, <code>body<\\/code> start and <code>body<\\/code> end<\\/li>\\n<li>New: Meet Code Highlight widget - showcase any syntax with highlighted UI (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/5815\\\">#5815<\\/a>)<\\/li>\\n<li>Experiment: Improved Pro widgets performance by loading JS and Swiper assets conditionally in frontend (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/8572\\\">#8572<\\/a>, <a href=\\\"https:\\/\\/developers.elementor.com\\/experiment-optimized-asset-loading\\/\\\">Developer Documentation<\\/a>)<\\/li>\\n<li>Tweak: Added Compatibility Tag support in Elementor Pro (<a href=\\\"https:\\/\\/developers.elementor.com\\/compatibility-tag\\/\\\">Developer Documentation<\\/a>)<\\/li>\\n<li>Tweak: Added Dynamic capabilities to Rotating Text animation in Animated Headline widget (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/4625\\\">#4625<\\/a>, <a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/8569\\\">#8569<\\/a>)<\\/li>\\n<li>Tweak: Added an option to set Selected color for Typing effect in Animated Headline widget (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/5403\\\">#5403<\\/a>, <a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/7826\\\">#7826<\\/a>)<\\/li>\\n<li>Tweak: Added animation Loop option for Animated Headline (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/9749\\\">#9749<\\/a>, <a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/2457\\\">#2457<\\/a>)<\\/li>\\n<li>Tweak: Added timing options for Animated Headline widget (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/4392\\\">#4392<\\/a>)<\\/li>\\n<li>Tweak: Added dynamic capabilities for Testimonial Carousel widget (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/8569\\\">#8569<\\/a>)<\\/li>\\n<li>Tweak: Added dynamic capabilities for Price Table widget (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/4242\\\">#4242<\\/a>, <a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/8569\\\">#8569<\\/a>)<\\/li>\\n<li>Tweak: Added Word Wrap control to Code Highlight widget (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/13577\\\">#13577<\\/a>)<\\/li>\\n<li>Tweak: Upgraded Font Awesome Pro library to v5.15.1<\\/li>\\n<li>Tweak: Improved method of loading field mapping repeater in Form widget (<a href=\\\"https:\\/\\/developers.elementor.com\\/how-to-add-a-repeater-control-to-elementor-add-on\\/\\\">Developer Documentation<\\/a>)<\\/li>\\n<li>Tweak: Added &quot;Show on Browsers&quot; Popup Advanced Rule<\\/li>\\n<li>Tweak: Added real-time JS handling to prevent redundant renders in Slides widget and all Carousel widgets<\\/li>\\n<li>Tweak: Import scroll utility from core and remove it from Pro<\\/li>\\n<li>Tweak: Added alignment options for Post Excerpt widget (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/9757\\\">#9757<\\/a>)<\\/li>\\n<li>Tweak: Changed alignment control to work with selectors in Share Buttons<\\/li>\\n<li>Tweak: Upgraded to Webpack 5, Grunt-Webpack 4 and TerserPlugin instead of UglifyJsPlugin<\\/li>\\n<li>Fix: Steps Divider is not vertically aligned in Multi Step Form widget (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/12569\\\">#12569<\\/a>)<\\/li>\\n<li>Fix: Slides are playing in an infinite loop mode even when the option is disabled in Slides Widget (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/6726\\\">#6726<\\/a>)<\\/li>\\n<li>Fix: Redundant spacing is added to Share Buttons widget<\\/li>\\n<li>Fix: Step buttons text is not updated without a page reload in Forms widget<\\/li>\\n<li>Fix: Overflow issue in certain animations in Animated Headline widget<\\/li>\\n<li>Fix: When dragging a new Testimonial Carousel there is a console error thrown<\\/li>\\n<li>Fix: Step Buttons are cut in mobile view in Multi Step Form<\\/li>\\n<li>Fix: Submit and Step buttons size differences when using Twenty Twenty theme<\\/li>\\n<li>Fix: Duplicate button Text Color control in Slides widget<\\/li>\\n<li>Fix: JS error is thrown when editing and saving global widgets<\\/li>\\n<li>Fix: <code>get_version<\\/code> API function may fail with Redis \\/ DB cache<\\/li>\\n<li>Fix: Multiple license check requests are created in certain cases<\\/li>\\n<li>Deprecated: Deprecate methods prefixed with an underscore and replace them with unprefixed methods<\\/li>\\n<li>Deprecated: See all deprecations to this version in our <a href=\\\"https:\\/\\/developers.elementor.com\\/v3-1-planned-deprecations\\/\\\">Developers Deprecations Post<\\/a><\\/li>\\n<\\/ul>\\n<h4>3.0.10 - 2021-01-20<\\/h4>\\n<ul>\\n<li>Tweak: Added Editing Handles string translation compatibility with Elementor v3.1.0<\\/li>\\n<\\/ul>\\n<h4>3.0.9 - 2020-12-29<\\/h4>\\n<ul>\\n<li>Tweak: Added compatibility to support Elementor 3.1.0<\\/li>\\n<li>Fix: Wrong phrasing of Import template success message in Theme Builder<\\/li>\\n<li>Fix: Border color glitch in Theme Builder<\\/li>\\n<\\/ul>\\n<h4>3.0.8 - 2020-11-26<\\/h4>\\n<ul>\\n<li>Fix: Navigation arrows UI glitch in Media Carousel widget (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/13172\\\">#13172<\\/a>)<\\/li>\\n<\\/ul>\\n<h4>3.0.7 - 2020-11-25<\\/h4>\\n<ul>\\n<li>Fix: Console Error when dragging  Testimonials Carousel widget<\\/li>\\n<li>Fix: Arrows of Testimonial and Reviews Carousel widgets navigate to the wrong direction in RTL websites<\\/li>\\n<li>Fix: Removed the conditional loading of Webpack<\\/li>\\n<li>Fix: Fatal error is thrown after deleting an associated custom taxonomy when Posts widget with Cards skin has a badge<\\/li>\\n<li>Fix: Upload JSON files only when the user allowed to prevent security issues<\\/li>\\n<li>Fix: Gallery not displayed in Theme Builder templates preview<\\/li>\\n<\\/ul>\\n<h4>3.0.6 - 2020-11-04<\\/h4>\\n<ul>\\n<li>Tweak: Updated the embedded post in Facebook Embed widget<\\/li>\\n<li>Fix: Minor UI glitches in Theme Builder\'s conditions screen footer<\\/li>\\n<li>Fix: Template type changes into Single Page after conditions change in Theme Builder<\\/li>\\n<li>Fix: Redundant Custom Caption option in Site Logo widget<\\/li>\\n<li>Fix: Removed unused code in Drip integration<\\/li>\\n<li>Fix: Removed Weibo and WeChat social networks due to website and links inactivity from Share Buttons widget<\\/li>\\n<li>Fix: Removed redundant code from Portfolio and Post Navigation widgets<\\/li>\\n<\\/ul>\\n<h4>3.0.5 - 2020-09-23<\\/h4>\\n<ul>\\n<li>Fix: If the default page layout is set to &quot;Canvas&quot; Headers and Footers cannot be edited<\\/li>\\n<li>Fix: Product Image Dynamic Tag throws an error when no image is set<\\/li>\\n<li>Fix: Missing Single document placeholder in Theme Builder<\\/li>\\n<li>Fix: Document editing handles inherit the <code>font-family<\\/code> from 3rd party source<\\/li>\\n<li>Fix: Can\'t add linebreaks to Textarea input when used as Multi Step Form<\\/li>\\n<li>Fix: Incorrect width in Facebook Page widget<\\/li>\\n<li>Fix: Added compatibility to allow the use of \'get_create_url\' in Theme Builder<\\/li>\\n<\\/ul>\\n<h4>3.0.4 - 2020-09-09<\\/h4>\\n<ul>\\n<li>Fix: Autogenerated screenshots appear in WP Media Library modal (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/12304\\\">#12304<\\/a>)<\\/li>\\n<li>Fix: Make sure Elementor Posts widget Pagination doesn\'t interfere with 3rd party plugins (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/12126\\\">#12126<\\/a>, <a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/12127\\\">#12127<\\/a>)<\\/li>\\n<li>Fix: Shrinking conditions indicator in Theme Builder<\\/li>\\n<li>Fix: Column can\'t be dragged and dropped if it populates a Global widget<\\/li>\\n<li>Fix: Styles are missing from Single templates in some edge cases<\\/li>\\n<\\/ul>\\n<h4>3.0.3 - 2020-09-02<\\/h4>\\n<ul>\\n<li>Fix: Pagination doesn\'t work in WordPress 5.5 (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/12126\\\">#12126<\\/a>, <a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/12127\\\">#12127<\\/a>)<\\/li>\\n<li>Fix: Change delete template action to &quot;Move to Trash&quot; in the new Theme Builder view<\\/li>\\n<\\/ul>\\n<h4>3.0.2 - 2020-08-31<\\/h4>\\n<ul>\\n<li>Tweak: Replaced WordPress &quot;Learn More&quot; links with dynamic links for better control over time (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/12312\\\">#12312<\\/a>)<\\/li>\\n<li>Tweak: UI tweaks to the Conditions screen In the new Theme Builder<\\/li>\\n<li>Fix: Motion Effects not working when assigned to a column and throws JS error when DOM optimization is disabled (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/12299\\\">#12299<\\/a>, <a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/12275\\\">#12275<\\/a>)<\\/li>\\n<li>Fix: Multiple Galleries display all the images in the Lightbox slideshow (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/11809\\\">#11809<\\/a>)<\\/li>\\n<li>Fix: Old Theme Builder is being opened when accessing through the Finder<\\/li>\\n<li>Fix: Mixed templates import glitch in Theme Builder<\\/li>\\n<li>Fix: Card icon sizes in Theme Builder<\\/li>\\n<li>Fix: Preview button leads to <code>render_mode<\\/code> instead of preview when importing a template from the new Theme Builder<\\/li>\\n<\\/ul>\\n<h4>3.0.1 - 2020-08-26<\\/h4>\\n<ul>\\n<li>Tweak: Keep previous Theme Builder when accessing from the WP Dashboard for legacy support<\\/li>\\n<li>Tweak: Updated video tutorials in Theme Builder<\\/li>\\n<li>Tweak: Don\'t show auto-screenshots in the Media Library (Props <a href=\\\"https:\\/\\/github.com\\/black-eye\\\">@black-eye<\\/a>)<\\/li>\\n<li>Fix: Repeater items throws <code>childView<\\/code> is undefined message in Forms widget (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/12239\\\">#12239<\\/a>, <a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/12221\\\">#12221<\\/a>)<\\/li>\\n<li>Fix: Misspelling of the word &quot;occurred&quot; in Form widget default error message (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/12137\\\">#12137<\\/a>)<\\/li>\\n<li>Fix: Facebook comments not showing up (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/12157\\\">#12157<\\/a>)<\\/li>\\n<li>Fix: Check for conflicts in Theme Builder doesn\'t work properly<\\/li>\\n<li>Fix: Minor UI fixes in Theme Builder<\\/li>\\n<li>Fix: Dark mode glitches in Theme Builder<\\/li>\\n<li>Fix: Global Site Part toaster appears when you publish a Popup<\\/li>\\n<li>Fix: Site Parts aren\'t in the correct order in Theme Builder<\\/li>\\n<li>Fix: Date field caused forms to get corrupted in Forms widget<\\/li>\\n<li>Fix: Theme Builder application page is forbidden<\\/li>\\n<\\/ul>\\n<h4>3.0.0 - 2020-08-23<\\/h4>\\n<ul>\\n<li>New: Introducing the new and improved Theme Builder<\\/li>\\n<li>Tweak: Removed <code>.elementor-inner<\\/code> and <code>.elementor-column-wrap<\\/code> from DOM output to improve performance (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/7351\\\">#7351<\\/a>, <a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/7817\\\">#7817<\\/a>, <a href=\\\"https:\\/\\/developers.elementor.com\\/dom-improvements-ahead-html-wrappers-removal-from-v3-0\\/\\\">Developers Blog Post<\\/a>)<\\/li>\\n<li>Tweak: Added contextual anchors ID support to Table of Contents widgets (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/10052\\\">#10052<\\/a>)<\\/li>\\n<li>Tweak: Added WeChat and Weibo social networks to Share Buttons widget (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/11554\\\">#11554<\\/a>)<\\/li>\\n<li>Tweak: Added Dynamic capabilities for Redirect after Login\\/Logout in Login widget (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/11343\\\">#11343<\\/a>)<\\/li>\\n<li>Tweak: Added Blend Mode and CSS Filters controls to adjust the Background Overlay in Flipbox widget (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/11653\\\">#11653<\\/a>)<\\/li>\\n<li>Tweak: Added responsive capabilities to Toggle Button styling in Nav Menu widget (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/8269\\\">#8269<\\/a>)<\\/li>\\n<li>Tweak: Added responsive Text Alignment control in Call to Action widget (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/11968\\\">#11968<\\/a>)<\\/li>\\n<li>Tweak: Added dynamic content to Ribbon element in Call to Action widget (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/10364\\\">#10364<\\/a>)<\\/li>\\n<li>Tweak: Converted uses of Color and Typography Schemes to Global Colors and Fonts<\\/li>\\n<li>Tweak: Separated Title and Description control fields labels in Call to Action widget<\\/li>\\n<li>Tweak: Removed unnecessary style in WC Product with variations<\\/li>\\n<li>Tweak: Converted Portfolio, Posts and Share Buttons widgets to use CSS Variable-based Elementor Grid (<a href=\\\"https:\\/\\/developers.elementor.com\\/elementor-dropping-support-ie\\/\\\">Developers Blog Post<\\/a>)<\\/li>\\n<li>Tweak: Added Date Modified option to Posts widget metadata<\\/li>\\n<li>Fix: PHP 7.4 compatibility to Media Carousel widget (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/11355\\\">#11355<\\/a>)<\\/li>\\n<li>Fix: Divider alignment issue in Post Info widget (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/11628\\\">#11628<\\/a>)<\\/li>\\n<li>Fix: Color doesn\\u2019t change in Products Archive Description widget<\\/li>\\n<li>Fix: WC Product variations layout breaks when using Variation Swatches plugin<\\/li>\\n<li>Fix: WC Product variations layout issue<\\/li>\\n<li>Fix: WC Product variations mobile zoom-in glitch<\\/li>\\n<li>Fix: Can\'t edit a Popup after accessing Theme Style<\\/li>\\n<li>Fix: Twitter icon missing in Blockquote widget<\\/li>\\n<li>Fix: Removed redundant default text color from Share Buttons minimal skin<\\/li>\\n<li>Fix: UI glitch in Display Conditions modal<\\/li>\\n<li>Fix: Insert template button UI glitch in Templates Library<\\/li>\\n<li>Fix: Added sanitization to post titles in WordPress dashboard for better security<\\/li>\\n<li>Fix: Show when arriving from search engines rule doesn\'t work in Popup<\\/li>\\n<li>Fix: Child categories are shown with a different parent category in Query control<\\/li>\\n<li>Deprecated: See all deprecations to this version in our <a href=\\\"https:\\/\\/developers.elementor.com\\/v3-0-planned-deprecations\\/\\\">Developers Deprecations Post<\\/a><\\/li>\\n<\\/ul>\\n<h4>2.10.3 - 2020-06-29<\\/h4>\\n<ul>\\n<li>Fix: Form not being submitted when using &quot;Progress Bar&quot; and &quot;None&quot; view types in Multi Step Form (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/11596\\\">#11596<\\/a>, <a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/11610\\\">#11610<\\/a>)<\\/li>\\n<li>Fix: Missing &quot;for&quot; attribute in Password field label in Login widget (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/8646\\\">#8646<\\/a>)<\\/li>\\n<\\/ul>\\n<h4>2.10.2 - 2020-06-16<\\/h4>\\n<ul>\\n<li>Fix: Run step events only when in Multi Step Form mode (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/11644\\\">#11644<\\/a>)<\\/li>\\n<\\/ul>\\n<h4>2.10.1 - 2020-06-16<\\/h4>\\n<ul>\\n<li>Tweak: Improved License validation mechanism to avoid limitations<\\/li>\\n<li>Tweak: Changed control labels and ordering in Price Table, Lottie and Form widgets<\\/li>\\n<li>Fix: Popup close button vertical position glitch (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/10921\\\">#10921<\\/a>)<\\/li>\\n<li>Fix: Radio field placement glitch when in Multi Step mode in Form widget<\\/li>\\n<li>Fix: Clicking <code>Enter<\\/code> key submits the form in Multi Step Form<\\/li>\\n<li>Fix: Hardened sanitization in Custom Attributes to avoid security issues<\\/li>\\n<\\/ul>\\n<h4>2.10.0 - 2020-06-07<\\/h4>\\n<ul>\\n<li>New: Introducing Multi-Step Forms - Breakdown long forms into simple steps (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/5975\\\">#5975<\\/a>, <a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/3911\\\">#3911<\\/a>)<\\/li>\\n<li>New: Introducing Lottie widget - easily add Lottie animations to your site, no coding needed (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/11026\\\">#11026<\\/a>)<\\/li>\\n<li>Tweak: Added spacing option to Posts widget pagination (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/5682\\\">#5682<\\/a>)<\\/li>\\n<li>Tweak: Changed texts and logic for administrator plugin renewal notices<\\/li>\\n<li>Tweak: Added new Scroll Util for improved scrolling handling<\\/li>\\n<li>Tweak: Improved Motion Effects animation performance<\\/li>\\n<\\/ul>\\n<h4>2.9.5 - 2020-05-24<\\/h4>\\n<ul>\\n<li>Fix: Added sanitization to Custom Attributes control to avoid security issue<\\/li>\\n<\\/ul>\\n<h4>2.9.4 - 2020-05-07<\\/h4>\\n<ul>\\n<li>Fix: Hardened user role that is allowed to upload icon sets and unzip only allowed files in Custom Icons to prevent security vulnerability<\\/li>\\n<\\/ul>\\n<h4>2.9.3 - 2020-04-19<\\/h4>\\n<ul>\\n<li>Fix: Form shortcode IDs are not wrapped in double-quotes (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/11023\\\">#11023<\\/a>, <a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/10932\\\">#10932<\\/a>, <a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/10967\\\">#10967<\\/a>, <a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/11000\\\">#11000<\\/a>, <a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/11049\\\">#11049<\\/a>)<\\/li>\\n<li>Fix: Escaped Form records metadata to prevent security vulnerability<\\/li>\\n<li>Fix: Closing &quot;Save Changes&quot; document confirmation modal causes Panel infinite loading<\\/li>\\n<li>Fix: Ken Burns effect not working when there is only one slide in Slides widget<\\/li>\\n<li>Fix: Document handles UI glitch<\\/li>\\n<\\/ul>\\n<h4>2.9.2 - 2020-03-25<\\/h4>\\n<ul>\\n<li>Tweak: Added compatibility with WordPress v5.4 (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/10745\\\">#10745<\\/a>)<\\/li>\\n<li>Fix: Image ratio number is displayed under the Archive Posts widget (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/10874\\\">#10874<\\/a>)<\\/li>\\n<li>Fix: Theme Style Link color setting overrides the Table of Content list style<\\/li>\\n<li>Fix: PHP notice when using dynamic user info <code>id<\\/code><\\/li>\\n<li>Fix: Navigation arrows direction is crossed on first drag in Slides Widget<\\/li>\\n<li>Fix: &quot;No headings were found on this page&quot; message was not displayed in the frontend in Table of Contents widget<\\/li>\\n<li>Fix: Container includes Popup tags by default in Table of Contents widget<\\/li>\\n<li>Fix: Twitter icon display issue when Font Awesome 4 support is disabled in Blockquote widget<\\/li>\\n<li>Fix: ACF Dynamic tag not working in Form widget Redirect action<\\/li>\\n<\\/ul>\\n<h4>2.9.1 - 2020-03-16<\\/h4>\\n<ul>\\n<li>Fix: Can\'t access Elementor Editor when there is Page Title widget in the page<\\/li>\\n<li>Fix: Applying styling to Post Content widget affects the Page and Post editing handles<\\/li>\\n<\\/ul>\\n<h4>2.9.0 - 2020-03-15<\\/h4>\\n<ul>\\n<li>New: Introducing Full Site Editing: Design header, footer, and content all in one place! (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/4985\\\">#4985<\\/a>)<\\/li>\\n<li>New: Added Global Custom CSS for Your Entire Site in Theme Style (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/3345\\\">#3345<\\/a>)<\\/li>\\n<li>New: Added Dynamic Colors tag (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/6485\\\">#6485<\\/a>)<\\/li>\\n<li>Tweak: Added option to set the Site Part HTML Wrapper Tags (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/9293\\\">#9293<\\/a>)<\\/li>\\n<li>Tweak: Added Link Attributes support to Pro widgets (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/5716\\\">#5716<\\/a>, <a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/3642\\\">#3642<\\/a>, <a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/9225\\\">#9225<\\/a>, <a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/9079\\\">#9079<\\/a>)<\\/li>\\n<li>Tweak: Added Theme Style support in Theme Builder parts (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/10564\\\">#10564<\\/a>)<\\/li>\\n<li>Tweak: Avoid creating empty Custom Font<\\/li>\\n<li>Tweak: Added <code>aria-expanded<\\/code> attribute to Menu Cart widget<\\/li>\\n<li>Tweak: Moved Link Actions module to Core plugin<\\/li>\\n<li>Tweak: Changed the name of \\u201cTypeKit Web Fonts by Adobe\\u201d to \\u201cAdobe Fonts\\u201d<\\/li>\\n<li>Tweak: Removed redundant display conditions from Blockquote, Flipbox, Price Table, and Search Form widgets<\\/li>\\n<li>Tweak: Pro widgets are not draggable unless Elementor license has been activated<\\/li>\\n<li>Tweak: Remove redundant <code>label_block<\\/code> parameters from several controls<\\/li>\\n<li>Tweak: Converted controls selectors to CSS variables in Gallery widget<\\/li>\\n<li>Tweak: Replaced Stumbleupon with Mix in Reviews widget recommended icons (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/10099\\\">#10099<\\/a>)<\\/li>\\n<li>Tweak: Added Mix to the Share Buttons network list (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/10099\\\">#10099<\\/a>)<\\/li>\\n<li>Tweak: Added &quot;Open in new tab&quot; option to Posts widget (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/7924\\\">#7924<\\/a>)<\\/li>\\n<li>Tweak: Upgraded Font Awesome Pro library to v5.12.0<\\/li>\\n<li>Tweak: Added new Lightbox compatibility for Gallery and Media Carousel widgets<\\/li>\\n<li>Tweak: Expose external API for Swiper instances<\\/li>\\n<li>Tweak: Added compatibility to JS API in Theme Builder, Popups, Form widget and Global widget<\\/li>\\n<li>Tweak: Replaced nerd icons with new Elementor emojis<\\/li>\\n<li>Tweak: Added specific <code>color<\\/code> attribute to header title in Table of Contents widget<\\/li>\\n<li>Fix: Line break issues in Animated Headline widget (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/10585\\\">#10585<\\/a>)<\\/li>\\n<li>Fix: Theme Style Link color overrides the Table of Content list style<\\/li>\\n<li>Fix: Active state glitches when using Table of contents widget with Sticky mode<\\/li>\\n<li>Fix: &quot;Graphic Element&quot; section appears as empty in case of unmarked Graphic Element in Call to Action widget<\\/li>\\n<li>Fix: Page Title widget render glitches in the Editor<\\/li>\\n<li>Fix: Image ratio parameter visible in some edge cases in Posts widget<\\/li>\\n<li>Fix: Image missing when sharing to Pinterest using Share Buttons widget<\\/li>\\n<li>Fix: Theme Style Link color setting override the list style in Table of Contents widget<\\/li>\\n<li>Deprecated: See all deprecations to this version in our <a href=\\\"https:\\/\\/developers.elementor.com\\/v2-9-0-planned-deprecations\\/\\\">Developers Deprecations Post<\\/a><\\/li>\\n<\\/ul>\\n<h4>2.8.5 - 2020-03-08<\\/h4>\\n<ul>\\n<li>Tweak: Added new Swiper parameter to all Pro carousels to allow 3rd party integration<\\/li>\\n<li>Fix: Missing closing bracket in Animated Headline widget<\\/li>\\n<li>Fix: Share buttons widgets show Font Awesome 4 icons on first drag in Editor<\\/li>\\n<\\/ul>\\n<h4>2.8.4 - 2020-02-16<\\/h4>\\n<ul>\\n<li>Tweak: Added Lightbox Title &amp; Description support to Gallery widget<\\/li>\\n<li>Tweak: Added RTL support for Slides widget<\\/li>\\n<li>Tweak: Display Lightbox images in Full size in Gallery widget<\\/li>\\n<li>Fix: Template with Slides widget not working properly when placed inside Tabs, Accordion and Toggle widget<\\/li>\\n<li>Fix: Dropdown menu lost styling after Elementor Pro v2.8 upgrade in Nav Menu widget<\\/li>\\n<li>Fix: Indent doesn\'t work on RTL websites in Table of Contents widget<\\/li>\\n<li>Fix: Query Control throws <code>Undefined index: q<\\/code> error<\\/li>\\n<li>Fix: Typography control not affecting dropdown menu in Nav Menu widget<\\/li>\\n<li>Fix: Discord forms integration fails to send submissions in some server configurations<\\/li>\\n<li>Fix: Rotating headlines don\'t align center in Animated Headline widget<\\/li>\\n<li>Fix: Custom secondary color displayed when not needed in Share buttons widget<\\/li>\\n<li>Fix: Motion Effects of certain objects are not functioning properly on Safari browser<\\/li>\\n<li>Fix: Missing eye icon in Single template footer preview button<\\/li>\\n<\\/ul>\\n<h4>2.8.3 - 2020-01-01<\\/h4>\\n<ul>\\n<li>Tweak: Updated Table of Contents widget panel location<\\/li>\\n<li>Fix: ACF URL Dynamic field throws <code>undefined index<\\/code> PHP notice (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/9929\\\">#9929<\\/a>)<\\/li>\\n<li>Fix: Gallery lightbox pagination shows images from all tabs<\\/li>\\n<li>Fix: &quot;Reply To&quot; option not working in Form widget &quot;Email 2&quot; Action<\\/li>\\n<li>Fix: ACF Dynamic tag not working in Form widget Redirect action<\\/li>\\n<li>Fix: Underline option not working in Table of Contents widget Normal state<\\/li>\\n<li>Fix: Query Control <code>Undefined index: autocomplete<\\/code> notice in some cases<\\/li>\\n<li>Fix: Missing display condition to Read More Spacing control in Posts widget<\\/li>\\n<\\/ul>\\n<h4>2.8.2 - 2019-12-19<\\/h4>\\n<ul>\\n<li>Tweak: Improved scroll-spy and collapsing functionality in Table of Contents widget<\\/li>\\n<li>Fix: &quot;No products were found&quot; message not being displayed in an empty Products Archive<\\/li>\\n<li>Fix: Redundant <code>&lt;br&gt;<\\/code> tags in Single theme template (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/9927\\\">#9927<\\/a>, <a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/9928\\\">#9928<\\/a>)<\\/li>\\n<li>Fix: Draft Popup shows up in Dynamic tag dropdown<\\/li>\\n<\\/ul>\\n<h4>2.8.1 - 2019-12-18<\\/h4>\\n<ul>\\n<li>Fix: Share Buttons widget not working (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/9920\\\">#9920<\\/a>)<\\/li>\\n<li>Fix: Redundant <code>&lt;p&gt;<\\/code> tags added to Single Template posts<\\/li>\\n<\\/ul>\\n<h4>2.8.0 - 2019-12-18<\\/h4>\\n<ul>\\n<li>New: Table of Contents Widget (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/5171\\\">#5171<\\/a>)<\\/li>\\n<li>New: Added Font Awesome Pro Duotone font family support (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/9578\\\">#9578<\\/a>)<\\/li>\\n<li>Tweak: Added Lazy Load option to Gallery widget (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/9763\\\">#9763<\\/a>)<\\/li>\\n<li>Tweak: Added Random order option to Gallery widget (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/9269\\\">#9269<\\/a>)<\\/li>\\n<li>Tweak: Updated Font Awesome Pro to v5.11.2 (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/9578\\\">#9578<\\/a>)<\\/li>\\n<li>Tweak: Added preselect support for multiple default select values in Forms Widget (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/9324\\\">#9324<\\/a>)<\\/li>\\n<li>Tweak: Avoid duplicate queries for Custom Icons (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/9579\\\">#9579<\\/a>)<\\/li>\\n<li>Tweak: Major performance improvements to Gallery widget<\\/li>\\n<li>Tweak: Avoid non-existing images in Gallery widget<\\/li>\\n<li>Tweak: Added <code>tabindex<\\/code>, <code>aria-expanded<\\/code>, <code>aria-hidden<\\/code> and <code>role=\\\"navigation\\\"<\\/code> accessibility attributes to Nav Menu widget<\\/li>\\n<li>Tweak: Changed button HTML tag from <code>button<\\/code> to <code>span<\\/code> in Call to Action and Flip Box widgets for better W3C compliance and accessibility<\\/li>\\n<li>Tweak: Removed Google+ from default networks in Share Buttons widget<\\/li>\\n<li>Tweak: Added compatibility for Library Connect<\\/li>\\n<li>Tweak: Added i18n to Toolset date dynamic tag<\\/li>\\n<li>Tweak: Added external link support to Gallery widget<\\/li>\\n<li>Tweak: Changed the link external attributes implementation to use <code>add_link_attributes()<\\/code> in Gallery widget<\\/li>\\n<li>Tweak: Updated references to the new Schemes system location<\\/li>\\n<li>Tweak: Avoid running Gallery handler when the gallery is empty<\\/li>\\n<li>Tweak: UI Tweaks in Editor Panel<\\/li>\\n<li>Tweak: Added responsive capabilities to Pointer Width control in Nav Menu widget<\\/li>\\n<li>Tweak: Added mobile support for responsive controls in Nav Menu widget<\\/li>\\n<li>Tweak: Refactor <code>register_controls()<\\/code> method in Posts widget skin trait<\\/li>\\n<li>Fix: ACF URL &quot;undefined Index&quot; notice (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/7646\\\">#7646<\\/a>)<\\/li>\\n<li>Fix: WooCommerce Mini-Cart widget causes fatal error in edge cases (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/9304\\\">#9304<\\/a>)<\\/li>\\n<li>Fix: <code>PHP Notice: Undefined index<\\/code> display for Author query (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/9864\\\">#9864<\\/a>)<\\/li>\\n<li>Fix: Added compatibility for Button widget placed inside Swiper carousel (<a href=\\\"https:\\/\\/wordpress.org\\/support\\/topic\\/broken-buttons-since-elementor-2-8\\/\\\">Topic<\\/a>)<\\/li>\\n<li>Fix: Avoid empty spaces in Post info widget<\\/li>\\n<li>Tweak: Always show &quot;Custom label&quot; control in Login widget<\\/li>\\n<li>Fix: Nav Menu item typography selector in Nav Menu widget<\\/li>\\n<li>Fix: Facebook Like Button widget causes flickering<\\/li>\\n<li>Fix: WooCommerce mini-cart behaviour when using <code>plain<\\/code> permalinks format<\\/li>\\n<li>Fix: Avoid running Popup triggers when set without conditions<\\/li>\\n<li>Fix: Removed &quot;Date&quot; query from Products widget<\\/li>\\n<li>Fix: Slides widget when used as a Shortcode and is hidden<\\/li>\\n<li>Fix: Custom URL being accessed on swipe in Media Carousel<\\/li>\\n<li>Fix: Media Carousel widget Cube effect glitch<\\/li>\\n<li>Fix: Lightbox shows images from multiple Gallery widgets in the same page<\\/li>\\n<li>Fix: Image <code>alt<\\/code> Text not displayed on overlay in Gallery widget<\\/li>\\n<li>Fix: Gallery widget not visible in Posts widget Full Content skin<\\/li>\\n<li>Fix: WooCommerce mini-cart remove unnecessary hooks registration when WooCommerce integration set to <code>Disable<\\/code><\\/li>\\n<li>Fix: Slides widget button wrapping breaks in mobile view<\\/li>\\n<li>Fix: Dynamic capabilities with the Reviews widget<\\/li>\\n<li>Fix: Disabling autoplay doesn\'t work in Slides widget<\\/li>\\n<li>Fix: Posts widget Full Content skin not working on Single template<\\/li>\\n<li>Fix: Autocomplete not working for &quot;By Author&quot; condition in Display Conditions screen<\\/li>\\n<li>Fix: Posts widget alignment issue<\\/li>\\n<li>Fix: Product Variations Clear button not working in edge cases<\\/li>\\n<li>Fix: Styling issues in Form widget submit button<\\/li>\\n<\\/ul>\\n<h4>2.7.3 - 2019-10-28<\\/h4>\\n<ul>\\n<li>Tweak: Added RTL support to Galleries widget (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/9213\\\">#9213<\\/a>)<\\/li>\\n<li>Tweak: Added Custom Icons compatibility for WordPress 5.3<\\/li>\\n<li>Fix: Missing template function declaration causes fatal error in WC mini-cart widget<\\/li>\\n<li>Fix: Pause on hover doesn\'t work in Carousel widgets<\\/li>\\n<li>Fix: Link-actions conflict with <code>?action=<\\/code> parameter in the URL<\\/li>\\n<li>Fix: Lightbox navigation not working in Gallery widget Single mode<\\/li>\\n<li>Fix: Ken burns effect not working on the 1st slide if Infinite Loop option is turned off in Carousel widgets<\\/li>\\n<li>Fix: Popup Advanced Rules detects internal links as external if current URL starts with <code>www<\\/code><\\/li>\\n<\\/ul>\\n<h4>2.7.2 - 2019-10-06<\\/h4>\\n<ul>\\n<li>Fix: Slide Overlay not working when applying Ken burns effect in Slides widget (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/9209\\\">#9209<\\/a>)<\\/li>\\n<li>Fix: Content width glitch in Slides widget (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/9180\\\">#9180<\\/a>)<\\/li>\\n<li>Fix: Horizontal Alignment not working when applying custom style per slide in Slides widget (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/9180\\\">#9180<\\/a>)<\\/li>\\n<li>Fix: Missing semicolon in Custom Fonts <code>font-display<\\/code> CSS<\\/li>\\n<\\/ul>\\n<h4>2.7.1 - 2019-09-26<\\/h4>\\n<ul>\\n<li>Fix: Background Overlay layer is over the slide content in Slides widget (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/9180\\\">#9180<\\/a>)<\\/li>\\n<li>Fix: Duplicate images under &quot;All&quot; filter in Multiple Gallery<\\/li>\\n<\\/ul>\\n<h4>2.7.0 - 2019-09-24<\\/h4>\\n<ul>\\n<li>New: Enhanced Galleries widget (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/1898\\\">#1898<\\/a>, <a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/3103\\\">#3103<\\/a>, <a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/4279\\\">#4279<\\/a>, <a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/7631\\\">#7631<\\/a>)<\\/li>\\n<li>New: Dynamic Number (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/5952\\\">#5952<\\/a>)<\\/li>\\n<li>New: Full content skin for Posts and Archive-posts widgets (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/4617\\\">#4617<\\/a>)<\\/li>\\n<li>Tweak: Added dynamic number capability to Price List, Price Table, Counter, Star Rating, Progress Bar widgets<\\/li>\\n<li>Tweak: Added tags support to forms Mailchimp action (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/5418\\\">#5418<\\/a>)<\\/li>\\n<li>Tweak: User Profile Picture Dynamic Tag (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/7947\\\">#7947<\\/a>, <a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/8740\\\">#8740<\\/a>)<\\/li>\\n<li>Tweak: Added <code>font-display<\\/code> support to custom fonts (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/5993\\\">#5993<\\/a>, <a href=\\\"https:\\/\\/developers.elementor.com\\/elementor-pro-2-7-custom-fonts-font-display-support\\/\\\">Developers Blog Post<\\/a>)<\\/li>\\n<li>Tweak: Added Text Shadow control to Slides widget (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/8800\\\">#8800<\\/a>)<\\/li>\\n<li>Tweak: Added Re-subscribe support to MailerLite (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/8799\\\">#8799<\\/a>)<\\/li>\\n<li>Tweak: Added Dynamic capabilities to Facebook Embed widget (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/9030\\\">#9030<\\/a>)<\\/li>\\n<li>Tweak: Use <code>swiper.js<\\/code> instead of <code>slick.js<\\/code> in Slides widget (<a href=\\\"https:\\/\\/developers.elementor.com\\/elementor-2-7-moving-sliders-from-slick-to-swiper\\/\\\">Developers Blog Post<\\/a>)<\\/li>\\n<li>Tweak: Added <code>elementor_pro\\/search_form\\/before_input<\\/code> action hook to Search Form widget (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/5598\\\">#5598<\\/a>)<\\/li>\\n<li>Tweak: Added <code>elementor_pro\\/search_form\\/after_input<\\/code> action hook to Search Form widget (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/5598\\\">#5598<\\/a>)<\\/li>\\n<li>Tweak: Added dynamic support for Custom field key (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/7789\\\">#7789<\\/a>)<\\/li>\\n<li>Tweak: Increased expired license notice bar frequency<\\/li>\\n<li>Tweak: Changed the icon name of Slides widget<\\/li>\\n<li>Tweak: Added designated Finder\'s Icons for Custom icons &amp; Custom fonts<\\/li>\\n<li>Tweak: Use Ken Burns Effect as an external module<\\/li>\\n<li>Tweak: Remove Fontello conflicting CSS on import to Custom Icons sets<\\/li>\\n<li>Tweak: Editor Panel UI tweaks<\\/li>\\n<li>Tweak: Added DOM events on Popup show\\/hide (<a href=\\\"https:\\/\\/developers.elementor.com\\/elementor-pro-2-7-popup-events\\/\\\">Developers Blog Post<\\/a>)<\\/li>\\n<li>Tweak: Added option to change the variations field width in Add to Cart widget<\\/li>\\n<li>Tweak: Use select control instead of select2 in Menu Cart widget<\\/li>\\n<li>Tweak: Added conditions to the tabs instead of to each control in Share Buttons widget<\\/li>\\n<li>Tweak: Added Typography controls to HTML field in Forms widget<\\/li>\\n<li>Tweak: Allow edit selected Font file in Custom Font<\\/li>\\n<li>Tweak: Changed reCAPTCHA v3 error message<\\/li>\\n<li>Tweak: Remove the &quot;Save as Global&quot; option on Global widget context menu<\\/li>\\n<li>Fix: Corrected selector for <code>removeControlSpinner()<\\/code> (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/8790\\\">#8790<\\/a>)<\\/li>\\n<li>Fix: Slides widget navigation icons misplacement (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/8533\\\">#8533<\\/a>)<\\/li>\\n<li>Fix: Horizontal Scrollbar when Slider widget is set to Full Width (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/8527\\\">#8527<\\/a>)<\\/li>\\n<li>Fix: Inconsistent behavior when &quot;Infinite Loop&quot; enabled with &quot;Autoplay&quot; in Slides widget (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/6726\\\">#6726<\\/a>)<\\/li>\\n<li>Fix: Ken Burns effect on Chrome transition glitches (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/1671\\\">#1671<\\/a>)<\\/li>\\n<li>Fix: Nothing found message shows up inside the columns set in Posts Archive widget (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/7347\\\">#7347<\\/a>)<\\/li>\\n<li>Fix: Responsive UI glitch in Popup Conditions modal tabs<\\/li>\\n<li>Fix: Removed unnecessary divider in Call to Action widget<\\/li>\\n<li>Fix: Custom Add To Cart * button style (size, position and background color) when <code>quantity<\\/code> is enabled.<\\/li>\\n<li>Fix: Add support for Document\\/PageBase in Theme Builder (Core &gt;=2.7.0)<\\/li>\\n<li>Fix: Ampersand character breaks email link in Share Buttons widget<\\/li>\\n<li>Fix: Correct custom font attachment <code>mime-type<\\/code> to show uploaded Custom Fonts<\\/li>\\n<li>Fix: Mini-Cart not refreshing in Menu Cart widget<\\/li>\\n<li>Fix: Cart drawer not working when WC Subscriptions plugin is activated<\\/li>\\n<li>Fix:  Querying CPT with custom taxonomies does not show the taxonomies before saving<\\/li>\\n<li>Fix: Double rendering on change caused console error in Theme Builder\'s conditions screen<\\/li>\\n<li>Fix: Translations and Strings in Share Buttons widget<\\/li>\\n<li>Fix: Avoid using offset if the source is Manual selection in Query Control<\\/li>\\n<li>Fix: Form being submitted although reCAPTCHA v3 validation failed in Forms widget<\\/li>\\n<\\/ul>\\n<h4>2.6.5 - 2019-08-26<\\/h4>\\n<ul>\\n<li>Tweak: Added compatibility for the upcoming release of Elementor v2.7<\\/li>\\n<li>Fix: Button style not working when <code>quantity<\\/code> is enabled in Custom Add To Cart widget<\\/li>\\n<li>Fix: Updated minified JS file fixed WhatsApp base URL in Share Buttons widget<\\/li>\\n<\\/ul>\\n<h4>2.6.4 - 2019-08-21<\\/h4>\\n<ul>\\n<li>Tweak: Added compatibility for the upcoming release of Elementor v2.7<\\/li>\\n<li>Fix: Changed WhatsApp base URL in Share Buttons widget for cross-device compatibility<\\/li>\\n<li>Fix: Random slides order after several clicks on pagination in Testimonial Carousel widget<\\/li>\\n<\\/ul>\\n<h4>2.6.3 - 2019-08-18<\\/h4>\\n<ul>\\n<li>Fix: Core version rollback to <code>&gt;2.6.0<\\/code> causes a fatal error<\\/li>\\n<li>Fix: Duplicate images when slideshow skin is selected in Media Carousel lightbox<\\/li>\\n<li>Fix: Default bottom margin added to reCAPTCHA V3 badge<\\/li>\\n<li>Fix: Input glitch in reCAPTCHA V3 threshold settings<\\/li>\\n<\\/ul>\\n<h4>2.6.2 - 2019-07-30<\\/h4>\\n<ul>\\n<li>Tweak: Better accessibility support in Search Form widget<\\/li>\\n<li>Fix: UI glitched in Popup publish screen (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/8616\\\">#8616<\\/a>)<\\/li>\\n<li>Fix: &quot;Child of Term&quot; and &quot;Any child of term&quot; conditions (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/8695\\\">#8695<\\/a>)<\\/li>\\n<li>Fix: Restored <code>library_widget_templates<\\/code> action hook for 3rd party compatibility (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/8687\\\">#8687<\\/a>)<\\/li>\\n<li>Fix: Twitter Icon missing in Blockquote widget<\\/li>\\n<li>Fix: Form reCAPTCHA v3 badge position not working<\\/li>\\n<li>Fix: Renewal notice bar appears in wrong situations<\\/li>\\n<li>Fix: Draft Icon Set loads empty Icon Library<\\/li>\\n<\\/ul>\\n<h4>2.6.1 - 2019-07-24<\\/h4>\\n<ul>\\n<li>Fix: Query Control autocomplete not retrieving results (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/8672\\\">#8672<\\/a>, <a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/8661\\\">#8661<\\/a>)<\\/li>\\n<li>Fix: Price Table features section not working (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/8660\\\">#8660<\\/a>)<\\/li>\\n<\\/ul>\\n<h4>2.6.0 - 2019-07-23<\\/h4>\\n<ul>\\n<li>New: Introducing Custom Icon sets - including Fontello, IcoMoon and Fontastic support (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/110\\\">#110<\\/a>)<\\/li>\\n<li>New: Added Font Awesome 5 Pro integration including 5,300+ icons (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/4430\\\">#4430<\\/a>)<\\/li>\\n<li>New: Added reCAPTCHA v3 integration to Form widget (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/8213\\\">#8213<\\/a>, <a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/6039\\\">#6039<\\/a>, <a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/7165\\\">#7165<\\/a>)<\\/li>\\n<li>Tweak: Added Exit Animation for Popups (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/7063\\\">#7063<\\/a>)<\\/li>\\n<li>Tweak: Added ACF Dynamic tag support for archive pages (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/5147\\\">#5147<\\/a>)<\\/li>\\n<li>Tweak: Added Navigator Indicators for Custom CSS &amp; Motion Effects (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/2180\\\">#2180<\\/a>)<\\/li>\\n<li>Tweak: Added Dynamic capabilities for Form Redirect action (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/7552\\\">#7552<\\/a>)<\\/li>\\n<li>Tweak: Added Logged In Message styling options for Login widget (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/7928\\\">#7928<\\/a>)<\\/li>\\n<li>Tweak: Added <code>none<\\/code> breakpoint option to Nav Menu widget (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/7916\\\">#7916<\\/a>)<\\/li>\\n<li>Tweak: Added option to place Post Terms dynamic tag without links (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/8366\\\">#8366<\\/a>)<\\/li>\\n<li>Tweak: Added <code>elementor\\/query\\/query_results<\\/code> hook to Query Control to allow full control over results (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/7912\\\">#7912<\\/a>)<\\/li>\\n<li>Tweak: Allow choosing Heading HTML tag in Price Table widget (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/8090\\\">#8090<\\/a>)<\\/li>\\n<li>Tweak: Show popup on dynamic click even when <code>Avoid Multiple Popups<\\/code> option is selected (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/8189\\\">#8189<\\/a>)<\\/li>\\n<li>Tweak: Added condition option to all of archive child pages (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/8256\\\">#8256<\\/a>)<\\/li>\\n<li>Tweak: Added <code>Effects Relative To<\\/code> control to Scrolling Effects<\\/li>\\n<li>Tweak: Allow shortcodes in HTML Form field<\\/li>\\n<li>Tweak: Removed donReach integration from Share Buttons widget due to service inconsistent stability<\\/li>\\n<li>Tweak: Changed MailChimp <code>List<\\/code> label to <code>Audience<\\/code><\\/li>\\n<li>Tweak: Improved Entrance and Exit animation behavior in Popup<\\/li>\\n<li>Tweak: Added <code>Deprecated Notice<\\/code> control to <code>Archive Products<\\/code> and <code>Woo Products<\\/code> widgets<\\/li>\\n<li>Tweak: Added default dynamic title for archives in Theme Builder<\\/li>\\n<li>Tweak: Added condition to show <code>Centered Slides<\\/code> control in Media Carousel widget<\\/li>\\n<li>Tweak: Added notice bar in the Editor when the license is expired or not activated<\\/li>\\n<li>Tweak: Replaced <code>select<\\/code> control with <code>choose<\\/code> control in Price List widget<\\/li>\\n<li>Tweak: Removed Font Awesome 4 dependencies from the Editor<\\/li>\\n<li>Tweak: Minor styling tweaks in the Popup publish modal<\\/li>\\n<li>Tweak: Hide ordering form in Products widget on front page<\\/li>\\n<li>Tweak: Removed page title markup when \'Hide Title\' is active<\\/li>\\n<li>Tweak: Added style controls for HTML field in Form widget<\\/li>\\n<li>Fix: Form widget Date picker makes the Popup builder disappear (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/7240\\\">#7240<\\/a>)<\\/li>\\n<li>Fix: Sticky element stop point stops working on viewport resize (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/7884\\\">#7884<\\/a>)<\\/li>\\n<li>Fix: Copy-Paste style not pasting the Pointer option in Nav Menu widget (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/8497\\\">#8497<\\/a>)<\\/li>\\n<li>Fix: Missing Print icon in Share Buttons (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/8506\\\">#8506<\\/a>)<\\/li>\\n<li>Fix: UI style glitch in Blockquote widget when viewing from iPad<\\/li>\\n<li>Deprecated: <code>DB::save_editor()<\\/code> - Remove usage of this method (<a href=\\\"https:\\/\\/developers.elementor.com\\/v2-6-0-planned-deprecations\\/\\\">Deprecation Post<\\/a>)<\\/li>\\n<li>Deprecated: <code>DB::get_plain_editor()<\\/code> - Remove usage of this method (<a href=\\\"https:\\/\\/developers.elementor.com\\/v2-6-0-planned-deprecations\\/\\\">Deprecation Post<\\/a>)<\\/li>\\n<\\/ul>\\n<h4>2.5.14 - 2019-07-14<\\/h4>\\n<ul>\\n<li>Fix: Better WC Related Product grid support to various themes (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/8555\\\">#8555<\\/a>)<\\/li>\\n<\\/ul>\\n<h4>2.5.13 - 2019-07-11<\\/h4>\\n<ul>\\n<li>Fix: Better WC grid support to various themes<\\/li>\\n<\\/ul>\\n<h4>2.5.12 - 2019-07-10<\\/h4>\\n<ul>\\n<li>Fix: Grid for WooCommerce Archive Product widget<\\/li>\\n<li>Fix: Remove redundant <code>whitespace<\\/code> CSS property causes style glitch in iPad<\\/li>\\n<li>Tweak: Added more compatibility for Elementor v2.6<\\/li>\\n<\\/ul>\\n<h4>2.5.11 - 2019-07-02<\\/h4>\\n<ul>\\n<li>Fix: Close icon missing from Nav Menu widget (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/8460\\\">#8460<\\/a>)<\\/li>\\n<li>Fix: Elementor Pro v2.5.10 shows PHP notice regarding notice bar (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/8461\\\">#8461<\\/a>)<\\/li>\\n<li>Fix: Fatal error when deleting used Pods fields (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/8396\\\">#8396<\\/a>)<\\/li>\\n<li>Fix: Missing dropdown icon in conditions screen<\\/li>\\n<\\/ul>\\n<h4>2.5.10 - 2019-05-28<\\/h4>\\n<ul>\\n<li>Tweak: Added compatibility for the upcoming release of Elementor v2.6<\\/li>\\n<li>Tweak: Error caused by empty Rows &amp; Columns values in Products widget (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/8261\\\">#8261<\\/a>)<\\/li>\\n<li>Fix: Do not unset <code>product<\\/code> CPT if it\'s not from WooCommerce (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/8160\\\">#8160<\\/a>)<\\/li>\\n<li>Fix: Column Spacing not working in WooCommerce Archive Products widget (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/8285\\\">#8285<\\/a>)<\\/li>\\n<li>Fix: Title styling not working in Products Categories widget<\\/li>\\n<li>Fix: Empty value in Dynamic Pods Gallery dropdown using Safari browser<\\/li>\\n<li>Fix: WooCommerce archives included in &quot;All Archives&quot; condition<\\/li>\\n<\\/ul>\\n<h4>2.5.9 - 2019-05-28<\\/h4>\\n<ul>\\n<li>Tweak: Removed <code>auto-confirm<\\/code> control from MailPoet to support new version of MailPoet<\\/li>\\n<li>Fix: Multiple Custom Fonts not rendered in the editor<\\/li>\\n<li>Fix: Products <code>sale<\\/code> query - handle exclude by manual selection.<\\/li>\\n<li>Fix: Product Categories grid row &amp; column style<\\/li>\\n<li>Fix: Form integration AJAX cache override<\\/li>\\n<li>Fix: Removed redundant CSS on Canvas &amp; Header-Footer page templates<\\/li>\\n<\\/ul>\\n<h4>2.5.8 - 2019-05-06<\\/h4>\\n<ul>\\n<li>Fix: Popup entrance animation not working in frontend<\\/li>\\n<li>Fix: Popup Exit Intent trigger activated multiple times<\\/li>\\n<\\/ul>\\n<h4>2.5.7 - 2019-05-05<\\/h4>\\n<ul>\\n<li>Fix: Embedded video keeps playing after a Popup is closed (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/7875\\\">#7875<\\/a>)<\\/li>\\n<li>Fix: Maximum call stack size exceeded error in Safari (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/7824\\\">#7824<\\/a>)<\\/li>\\n<li>Fix: Entrance animations not appearing on Popup reopen (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/7395\\\">#7395<\\/a>)<\\/li>\\n<li>Fix: WC variations select style glitch in several themes (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/8008\\\">#8008<\\/a>)<\\/li>\\n<li>Fix: Theme Builder taxonomy conditions not retrieving proper results in edge cases<\\/li>\\n<\\/ul>\\n<h4>2.5.6 - 2019-04-29<\\/h4>\\n<ul>\\n<li>Tweak: Removed <code>Shortcode<\\/code> dynamic from Image, Gallery and Media control<\\/li>\\n<li>Fix: Popup not inheriting entrance animation in responsive mode (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/7809\\\">#7809<\\/a>)<\\/li>\\n<li>Fix: Terms autocomplete retrieves wrong results in Query Control<\\/li>\\n<li>Fix: Query Control Related by author glitches in edge cases<\\/li>\\n<li>Fix: Query Control using terms for Products widget<\\/li>\\n<li>Fix: Posts cards style glitch in small screens<\\/li>\\n<li>Fix: Display conditions delete icon missing in small screens<\\/li>\\n<li>Fix: Avoid rendering Menu Cart widget in WordPress native editor<\\/li>\\n<\\/ul>\\n<h4>2.5.5 - 2019-04-08<\\/h4>\\n<ul>\\n<li>Tweak: Allow text selection inside a Popup<\\/li>\\n<li>Fix: Added backwards compatibility for <code>tax_query<\\/code> in Query Control (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/7751\\\">#7751<\\/a>)<\\/li>\\n<li>Fix: Missing arguments for <code>widget_title<\\/code> filter (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/7745\\\">#7745<\\/a>)<\\/li>\\n<\\/ul>\\n<h4>2.5.4 - 2019-04-03<\\/h4>\\n<ul>\\n<li>Fix: Move Query from using <code>term_id<\\/code> to <code>term_taxonomy_id<\\/code> (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/7653\\\">#7653<\\/a>)<\\/li>\\n<li>Fix: Offset manipulation hook removal in Query control<\\/li>\\n<li>Fix: Missing form field <code>ID<\\/code> in some edge cases (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/7711\\\">#7711<\\/a>, <a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/7660\\\">#7660<\\/a>)<\\/li>\\n<\\/ul>\\n<h4>2.5.3 - 2019-03-31<\\/h4>\\n<ul>\\n<li>Tweak: Updated Google Calendar dynamic tag URL (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/7673\\\">#7673<\\/a>)<\\/li>\\n<li>Fix: Missing form field names (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/7651\\\">#7651<\\/a>)<\\/li>\\n<li>Fix: PHP 5.4 backward compatibility in Query Control (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/7633\\\">#7633<\\/a>)<\\/li>\\n<li>Fix: <code>products_deprecated<\\/code> Query Control module compatibility (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/7654\\\">#7654<\\/a>)<\\/li>\\n<li>Fix: Changed query method from <code>term_id<\\/code> to <code>term_taxonomy_id<\\/code> (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/7653\\\">#7653<\\/a>)<\\/li>\\n<\\/ul>\\n<h4>2.5.2 - 2019-03-27<\\/h4>\\n<ul>\\n<li>Fix: Overwrite parent widget type in Global Widget (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/7632\\\">#7632<\\/a>)<\\/li>\\n<li>Fix: Avoid Duplicates option not working in Query Control (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/7635\\\">#7635<\\/a>)<\\/li>\\n<li>Fix: Manual Selection option not working in Query Control (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/7634\\\">#7634<\\/a>)<\\/li>\\n<li>Fix: Incorrect condition caused handlers issues inside popup<\\/li>\\n<\\/ul>\\n<h4>2.5.1 - 2019-03-26<\\/h4>\\n<ul>\\n<li>Fix: Query Control invalid call to deprecated action (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/7619\\\">#7619<\\/a>)<\\/li>\\n<li>Tweak: Renamed action hook from <code>elementor_pro\\/{$widget_name}\\/query\\/{$query_id}<\\/code> to <code>elementor\\/query\\/{$query_id}<\\/code><\\/li>\\n<li>Tweak: Renamed filter hook from <code>elementor_pro\\/query_control\\/get_query_args\\/current_query<\\/code> to <code>elementor\\/query\\/get_query_args\\/current_query<\\/code><\\/li>\\n<\\/ul>\\n<h4>2.5.0 - 2019-03-26<\\/h4>\\n<ul>\\n<li>New: Introducing Motion Effects including Scrolling &amp; Mouse effects (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/72\\\">#72<\\/a>)<\\/li>\\n<li>New: Introducing Related Posts for Query Control (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/7306\\\">#7306<\\/a>, <a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/7490\\\">#7490<\\/a>)<\\/li>\\n<li>New: Introducing Date query for Query Control<\\/li>\\n<li>New: Introducing Sticky Posts support for Query Control (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/2501\\\">#2501<\\/a>)<\\/li>\\n<li>Tweak: Added option to open a Popup by a custom selector (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/6871\\\">#6871<\\/a>, <a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/6876\\\">#6876<\\/a>, <a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/7258\\\">#7258<\\/a>)<\\/li>\\n<li>Tweak: Option to count when Popup is closed in &quot;Show up to X times&quot; Advanced Rule<\\/li>\\n<li>Tweak: Added full border radius control options inside Popup<\\/li>\\n<li>Tweak: Changed exit intent icon in Popups<\\/li>\\n<li>Tweak: Show only one popup in its own preview<\\/li>\\n<li>Tweak: Added responsive support to Popup entrance animation control<\\/li>\\n<li>Tweak: Conditions - Singular <code>All Pages<\\/code> string changed to <code>Pages<\\/code><\\/li>\\n<li>Tweak: Added form field shortcode support for Drip tags (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/7000\\\">#7000<\\/a>)<\\/li>\\n<li>Tweak: Added dynamic capabilities to Price List widget (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/7258\\\">#7258<\\/a>)<\\/li>\\n<li>Tweak: Added Dynamic capabilities to Custom Attributes (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/6779\\\">#6779<\\/a>)<\\/li>\\n<li>Tweak: Added dynamic capabilities to Flip Box widget (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/6986\\\">#6986<\\/a>)<\\/li>\\n<li>Tweak: Decrease <code>z-index<\\/code> for Nav Menu (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/6869\\\">#6869<\\/a>)<\\/li>\\n<li>Tweak: Changed &quot;Scrolling Effects&quot; section label to &quot;Motion Effects&quot;<\\/li>\\n<li>Tweak: Use filter <code>get_meta_viewport<\\/code> for header templates (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/7043\\\">#7043<\\/a>)<\\/li>\\n<li>Tweak: use filterable <code>Util::get_public_post_types()<\\/code> in Theme Builder (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/7172\\\">#7172<\\/a>)<\\/li>\\n<li>Tweak: Added Cloudflare rocket-loader support (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/7443\\\">#7443<\\/a>)<\\/li>\\n<li>Tweak: Added responsive support to WC Products Columns &amp; Rows Gap controls (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/6913\\\">#6913<\\/a>)<\\/li>\\n<li>Tweak: WC Menu cart &quot;View Cart&quot; &amp; &quot;Checkout&quot; buttons styling<\\/li>\\n<li>Fix: Custom ID reset to default when dragging repeater<\\/li>\\n<li>Fix: Conflict between archive-products widget and WC customizer<\\/li>\\n<li>Fix: Add to Cart widget <code>spacing<\\/code> and <code>space-between<\\/code><\\/li>\\n<li>Fix: Library view when creating a new Header or Footer<\\/li>\\n<li>Fix: Post types labels missing on Add New Template modal<\\/li>\\n<\\/ul>\\n<h4>2.4.8 - 2019-03-11<\\/h4>\\n<ul>\\n<li>Fix: Missing query section in Products widget<\\/li>\\n<li>Fix: Missing Taxonomy controls in Products widget in edge cases<\\/li>\\n<\\/ul>\\n<h4>2.4.7 - 2019-03-06<\\/h4>\\n<ul>\\n<li>Fix: Compatibility Global Widget with Elementor v2.5.0+<\\/li>\\n<\\/ul>\\n<h4>2.4.6 - 2019-03-04<\\/h4>\\n<ul>\\n<li>Fix: Pods gallery dynamic when empty (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/7127\\\">#7127<\\/a>)<\\/li>\\n<li>Fix: Duplicate call for conditions screen issue<\\/li>\\n<li>Fix: Compatibility with Elementor v2.5.0<\\/li>\\n<\\/ul>\\n<h4>2.4.5 - 2019-02-18<\\/h4>\\n<ul>\\n<li>Fix: Image size issue in Testimonial Carousel (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/7058\\\">#7058<\\/a>)<\\/li>\\n<li>Fix: MailChimp groups not saved in a form integration (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/7083\\\">#7083<\\/a>)<\\/li>\\n<li>Fix: Show popup preview only on it\'s own preview<\\/li>\\n<li>Fix: Elementor dashboard templates URL corrupted links in edge cases<\\/li>\\n<\\/ul>\\n<h4>2.4.4 - 2019-02-11<\\/h4>\\n<ul>\\n<li>Tweak: Added ACF Date Time Picker field support (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/6690\\\">#6690<\\/a>)<\\/li>\\n<li>Tweak: Changed the term of <code>All Posts<\\/code> condition to <code>Posts<\\/code><\\/li>\\n<li>Fix: Added <code>&lt;IfModule&gt;<\\/code> to avoid 500 error when <code>mod-headers<\\/code> is missing (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/7034\\\">#7034<\\/a>)<\\/li>\\n<li>Fix: Include post CSS deletion in Global Widget update (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/6856\\\">#6856<\\/a>)<\\/li>\\n<li>Fix: <code>Textarea<\\/code> default value in Forms Widget (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/6934\\\">#6934<\\/a>)<\\/li>\\n<li>Fix: MailPoet latest version caused fatal error (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/6996\\\">#6996<\\/a>)<\\/li>\\n<li>Fix: Fatal Error caused by calling MailPoet deleted method<\\/li>\\n<li>Notice: MailPoet <code>Auto Confirm<\\/code> option will now default to &quot;On&quot;<\\/li>\\n<\\/ul>\\n<h4>2.4.3 - 2019-01-30<\\/h4>\\n<ul>\\n<li>Fix: Custom Add to Cart widget responsive alignment settings<\\/li>\\n<li>Fix: Links in Post Info widget<\\/li>\\n<li>Fix: WooCommerce <code>View Cart<\\/code> string translate<\\/li>\\n<li>Fix: Wrapper classes for header\\/footer templates (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/6884\\\">#6884<\\/a>)<\\/li>\\n<\\/ul>\\n<h4>2.4.2 - 2019-01-25<\\/h4>\\n<ul>\\n<li>Tweak: Added pixel units to Close Button position control in Popups<\\/li>\\n<li>Fix: Exclude error in WC Products widget<\\/li>\\n<\\/ul>\\n<h4>2.4.1 - 2019-01-24<\\/h4>\\n<ul>\\n<li>Tweak: Added CSS classes control to Popup (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/6826\\\">#6826<\\/a>)<\\/li>\\n<li>Tweak: Added responsive image size to Testimonial Carousel widget<\\/li>\\n<li>Fix: PHP warning when Toolset Date dynamic is empty (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/6842\\\">#6842<\\/a>)<\\/li>\\n<li>Fix: Support of exclude-ids in WC Products widget<\\/li>\\n<li>Fix: Popup close button not clickable<\\/li>\\n<li>Fix: Alignment justify issue of Add to Cart widget (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/6749\\\">#6749<\\/a>)<\\/li>\\n<li>Fix: Bad anchors breaks the page JS<\\/li>\\n<li>Fix: Popup overlay shown when turned off<\\/li>\\n<\\/ul>\\n<h4>2.4.0 - 2019-01-21<\\/h4>\\n<ul>\\n<li>New: Introducing Popup Builder (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/628\\\">#628<\\/a>)<\\/li>\\n<li>New: Added <code>Popup<\\/code> Dynamic Tag<\\/li>\\n<li>New: Added <code>Popup<\\/code> forms action after submit<\\/li>\\n<li>New: Added User Info dynamic tag (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/6322\\\">#6322<\\/a>)<\\/li>\\n<li>Tweak: Added dynamic capabilities for &quot;Nothing Found&quot; message<\\/li>\\n<li>Tweak: Added <code>elementor_pro\\/theme_builder\\/archive\\/escape_nothing_found_message<\\/code> Filter to avoid HTML escaping in &quot;Nothing Found&quot; message (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/6053\\\">#6053<\\/a>)<\\/li>\\n<li>Tweak: Added <code>add_doc_to_location<\\/code> method to Allow insertion of a document to a location<\\/li>\\n<li>Fix: <code>z-index<\\/code> issue with CTA widget (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/6486\\\">#6486<\\/a>)<\\/li>\\n<li>Fix: Hide the Post Content widget and show it only in a Single document<\\/li>\\n<li>Fix: <code>selector<\\/code> replacement in Custom CSS<\\/li>\\n<li>Fix: Apply <code>the_content<\\/code> on the real content only<\\/li>\\n<li>Fix: CSS for WC products selector (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/6559\\\">#6559<\\/a>)<\\/li>\\n<li>Fix: Odnoklassniki share URL (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/6638\\\">#6638<\\/a>)<\\/li>\\n<li>Fix: Custom link new tab in Post Info widget (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/5766\\\">#5766<\\/a>)<\\/li>\\n<li>Fix: <code>nofollow<\\/code> link in Flip Box &amp; CTA widgets<\\/li>\\n<li>Fix: Post Terms in Post Info widget<\\/li>\\n<li>Fix: Added screen reader to some icons &amp; buttons for better accessibility (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/5386\\\">#5386<\\/a>)<\\/li>\\n<li>Fix: Accessibility labels in Reviews widget (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/6630\\\">#6630<\\/a>)<\\/li>\\n<li>Fix: Link to cart page not working when WooCommerce Subscriptions is active<\\/li>\\n<li>Fix: MailChimp Selected list not showing on reloading in Form widget<\\/li>\\n<li>Fix: Sub-menu arrow position in Nav Menu widget<\\/li>\\n<li>Fix: Conflict with WP Security Audit Log plugin (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/6648\\\">#6648<\\/a>)<\\/li>\\n<\\/ul>\\n<h4>2.3.1 - 2018-12-19<\\/h4>\\n<ul>\\n<li>Fix: Template widget search functionality (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/6473\\\">#6473<\\/a>)<\\/li>\\n<li>Fix: Apply <code>the_content<\\/code> filter to post content in theme builder<\\/li>\\n<\\/ul>\\n<h4>2.3.0 - 2018-12-17<\\/h4>\\n<ul>\\n<li>New: Introducing Discord Integration for Forms (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/4218\\\">#4218<\\/a>)<\\/li>\\n<li>New: Introducing Slack Integration for Forms<\\/li>\\n<li>New: Introducing MailerLite Integration for Forms (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/4462\\\">#4462<\\/a>)<\\/li>\\n<li>New: Activate Elementor Pro plugin by connecting to Elementor account<\\/li>\\n<li>Tweak: Added <code>elementor_pro\\/utils\\/get_public_post_types<\\/code> filter hook (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/5900\\\">#5900<\\/a>)<\\/li>\\n<li>Tweak: Added <code>loop_start<\\/code> &amp; <code>the_content<\\/code> hooks for Post Content (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/6173\\\">#6173<\\/a>)<\\/li>\\n<li>Tweak: Removed Custom Attributes from Page Settings<\\/li>\\n<li>Tweak: Always add the Custom CSS control to the Advanced tab<\\/li>\\n<li>Fix: In sub Term condition false positive in edge cases<\\/li>\\n<li>Fix: ToolSet Dynamic Image fallback<\\/li>\\n<li>Fix: Style glitch with the dropdown color in Nav Menu widget<\\/li>\\n<li>Fix: Style glitch in the Conditions screen in Safari browser<\\/li>\\n<li>Fix: Ribbon in the CTA widget obscures drop down menu (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/6080\\\">#6080<\\/a>)<\\/li>\\n<li>Fix: The color of label won\'t change color in Widget login<\\/li>\\n<\\/ul>\\n<h4>2.2.5 - 2018-12-11<\\/h4>\\n<ul>\\n<li>New: Add Style Tab &amp; Custom CSS for Header &amp; Footer Templates.<\\/li>\\n<li>Tweak: Added a better identifier for subpages (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/6362\\\">#6362<\\/a>)<\\/li>\\n<li>Tweak: Removed Custom Attributes from page settings<\\/li>\\n<li>Fix: Yahoo event URL date issue (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/6354\\\">#6354<\\/a>)<\\/li>\\n<li>Fix: Allow timezone settings in Google event URL (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/6354\\\">#6354<\\/a>)<\\/li>\\n<li>Fix: Avoid <code>z-index<\\/code> changes by <code>nanocss<\\/code> in build process<\\/li>\\n<li>Fix: Added missing WC upsells products CSS<\\/li>\\n<li>Fix: Nav Menu dropdown losing color on hover<\\/li>\\n<li>Fix: WC Product Add-ons CSS compatibility<\\/li>\\n<\\/ul>\\n<h4>2.2.4 - 2018-12-04<\\/h4>\\n<ul>\\n<li>Fix: Global widget not saving changes (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/6340\\\">#6340<\\/a>)<\\/li>\\n<li>Fix: Dynamic tags support in Blockquote widget (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/6334\\\">#6334<\\/a>)<\\/li>\\n<li>Fix: Forms Redirect URL action when using form field values with spaces<\\/li>\\n<\\/ul>\\n<h4>2.2.3 - 2018-11-29<\\/h4>\\n<ul>\\n<li>Fix: Missing &quot;Edit Template&quot; in Template widget (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/6271\\\">#6271<\\/a>)<\\/li>\\n<li>Fix: Follow menu anchors with UTF8 characters in Nav Menu<\\/li>\\n<li>Fix: Show only supported templates in Template widget<\\/li>\\n<li>Fix: Revert conflicting fix for a default order for WC archive<\\/li>\\n<\\/ul>\\n<h4>2.2.2 - 2018-11-28<\\/h4>\\n<ul>\\n<li>Fix: Lightbox dynamic tag crashes the editor<\\/li>\\n<\\/ul>\\n<h4>2.2.1 - 2018-11-28<\\/h4>\\n<ul>\\n<li>New: Added <code>ACF File<\\/code> Dynamic tag to support text controls.<\\/li>\\n<li>Tweak: Added option to hide item count bubble when cart is empty in Menu Cart widget (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/6223\\\">#6223<\\/a>)<\\/li>\\n<li>Tweak: Added Actions group for Lightbox and Contact URL tags<\\/li>\\n<li>Tweak: Added filter <code>elementor_pro\\/dynamic_tags\\/shortcode\\/should_escape<\\/code> to avoid escaping in Shortcode dynamic tag<\\/li>\\n<li>Tweak: MailPoet3 integration allow Subscriber to to subscribe to multiple lists<\\/li>\\n<li>Tweak: Added front-end max file size validation for upload fields<\\/li>\\n<li>Tweak: Added <code>by-author<\\/code> per Post-Type condition for theme builder<\\/li>\\n<li>Fix: Template widget panel not showing the selected template (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/6271\\\">#6271<\\/a>)<\\/li>\\n<li>Fix: Conflict between ACF with Safari browser on Select option in Dynamic tag<\\/li>\\n<li>Fix: Add post classes only for the Single template<\\/li>\\n<li>Fix: Set document type as not editable for unsupported document like Global widget<\\/li>\\n<li>Fix: Avoid duplicate query for current WC product query<\\/li>\\n<li>Fix: Product Archive showing oldest products instead of latest<\\/li>\\n<li>Fix: CSS reset in Posts widget using cards skin<\\/li>\\n<\\/ul>\\n<h4>2.2.0 - 2018-11-19<\\/h4>\\n<ul>\\n<li>New: Introducing Custom Attributes (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/290\\\">#290<\\/a>, <a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/3990\\\">#3990<\\/a>)<\\/li>\\n<li>New: Added evergreen option for Countdown widget (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/4459\\\">#4459<\\/a>)<\\/li>\\n<li>New: Added expire actions option for Countdown widget (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/5242\\\">#5242<\\/a>)<\\/li>\\n<li>New: Introducing Reviews widget (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/3854\\\">#3854<\\/a>)<\\/li>\\n<li>New: Introducing Sitemap widget (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/5594\\\">#5594<\\/a>)<\\/li>\\n<li>New: Added Request Parameter dynamic tag (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/4934\\\">#4934<\\/a>)<\\/li>\\n<li>New: Added Shortcode dynamic tag<\\/li>\\n<li>New: Added Image and Video Lightbox dynamic tag<\\/li>\\n<li>New: Added Contact URL dynamic tag<\\/li>\\n<li>New: Added Featured Image Data dynamic tag<\\/li>\\n<li>New: Added default value to each field in the Form widget (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/4268\\\">#4268<\\/a>)<\\/li>\\n<li>New: Added &quot;Any Child Of&quot; condition to template conditions (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/5321\\\">#5321<\\/a>)<\\/li>\\n<li>New: Added &quot;In Child&quot; condition to template conditions (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/5587\\\">#5587<\\/a>)<\\/li>\\n<li>Tweak: Added Form Redirect URL with form values (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/2564\\\">#2564<\\/a>)<\\/li>\\n<li>Tweak: Added default post classes to template wrapper (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/5959\\\">#5959<\\/a>)<\\/li>\\n<li>Tweak: Better labels for terms in Query control (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/6092\\\">#6092<\\/a>)<\\/li>\\n<li>Tweak: Renamed &quot;Child Of&quot; templates condition to &quot;Direct Child Of&quot;<\\/li>\\n<li>Tweak: Added <code>elementor\\/theme\\/get_location_templates\\/condition_sub_id<\\/code> filter hook to allow template condition translations<\\/li>\\n<li>Tweak: Load the Template Library widget via Ajax for better performance<\\/li>\\n<li>Tweak: Added 404 page title for Page Title dynamic tag<\\/li>\\n<li>Fix: Menu Cart Toggle has # URL link (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/6141\\\">#6141<\\/a>)<\\/li>\\n<li>Fix: Alignment issue in Nav Menu widget (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/5790\\\">#5790<\\/a>)<\\/li>\\n<li>Fix: Avoid potential security risk in forms<\\/li>\\n<li>Fix: Template By Author condition conflicts with 404 page<\\/li>\\n<li>Fix: Restored WC Product Content widget in Single Product template<\\/li>\\n<li>Fix: Theme Builder Preview URLs for date archives and 404 pages<\\/li>\\n<li>Fix: Highlight active menu anchor items only when scrolled into view<\\/li>\\n<li>Fix: Carousel Pagination Progress style to support new Swiper version<\\/li>\\n<\\/ul>\\n<h4>2.1.13 - 2018-11-12<\\/h4>\\n<ul>\\n<li>Tweak: Added compatibility for new brand Finder in v2.3.0<\\/li>\\n<li>Fix: Settings conflict when there are multiple carousels in the page<\\/li>\\n<\\/ul>\\n<h4>2.1.12 - 2018-11-05<\\/h4>\\n<ul>\\n<li>Tweak: Added compatibility for the upcoming release of Elementor v2.3<\\/li>\\n<li>Tweak: Better performance for Template Library widget<\\/li>\\n<li>Fix: Fatal error if a taxonomy used in a dynamic field is removed (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/6029\\\">#6029<\\/a>)<\\/li>\\n<li>Fix: Date Time dynamic tag now respect site language (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/6001\\\">#6001<\\/a>)<\\/li>\\n<li>Fix: Custom CSS printed twice in the front-end<\\/li>\\n<li>Fix: ACF Image field PHP warning (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/6051\\\">#6051<\\/a>)<\\/li>\\n<\\/ul>\\n<h4>2.1.11 - 2018-10-22<\\/h4>\\n<ul>\\n<li>New: Added ACF local fields compatibility<\\/li>\\n<li>Tweak: Re-brand TypeKit by Adobe Fonts integration<\\/li>\\n<li>Fix: Exclude <code>is_embed<\\/code> from Singular condition (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/5915\\\">#5915<\\/a>)<\\/li>\\n<li>Fix: Avoid conflict with Ad Blockers and Share Buttons<\\/li>\\n<li>Fix: Current date time dynamic tag now shows local time<\\/li>\\n<li>Fix: Avoid conflict with 3rd party plugins that filter the permalink<\\/li>\\n<li>Fix: Avoid PHP warning when no groups are selected for MailChimp integration<\\/li>\\n<li>Fix: Avoid PHP warning if checkbox field is empty for ACF<\\/li>\\n<li>Fix: Respect password protected for a WC single product template<\\/li>\\n<li>Fix: Respect <code>order<\\/code> settings for WC archive also without pagination<\\/li>\\n<\\/ul>\\n<h4>2.1.10 - 2018-10-09<\\/h4>\\n<ul>\\n<li>Tweak: Added responsive alignment control for Share Buttons widget (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/5821\\\">#5821<\\/a>)<\\/li>\\n<li>Tweak: Added link control to Animated Headline widget<\\/li>\\n<li>Fix: Mobile nav menu jump on RTL (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/5711\\\">#5711<\\/a>)<\\/li>\\n<li>Fix: Responsive alignment control in Add to Cart widget (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/5830\\\">#5830<\\/a>)<\\/li>\\n<li>Fix: Added IE compatibility for Animated Headline widget<\\/li>\\n<li>Fix: Post Content widget is now shown only on <code>Single<\\/code> templates<\\/li>\\n<li>Fix: Query Control Pagination with offset<\\/li>\\n<\\/ul>\\n<h4>2.1.9 - 2018-09-17<\\/h4>\\n<ul>\\n<li>Tweak: Added Centered Slides option for Slideshow carousel<\\/li>\\n<li>Fix: Allow only public CPT for Manual Selection in Query Control (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/5091\\\">#5091<\\/a>)<\\/li>\\n<li>Fix: ACF Gallery option support (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/5344\\\">#5344<\\/a>)<\\/li>\\n<li>Fix: Page scrolling on resize when sticky is active (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/5740\\\">#5740<\\/a>)<\\/li>\\n<li>Fix: Edit custom name for Global Widget in the Navigator (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/5689\\\">#5689<\\/a>)<\\/li>\\n<li>Fix: Coverflow transition effect in Carousel<\\/li>\\n<li>Fix: Weird mobile behavior with Cube effect in Carousel<\\/li>\\n<li>Fix: Show the first thumbnail in the Slideshow carousel correctly<\\/li>\\n<\\/ul>\\n<h4>2.1.8 - 2018-09-12<\\/h4>\\n<ul>\\n<li>Tweak: Added styling options for WC Additional Information widget<\\/li>\\n<li>Tweak: Added styling options for \'View Cart\' link in Products widget<\\/li>\\n<li>Fix: 3rd party plugin support for WC single product template (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/5338\\\">#5338<\\/a>)<\\/li>\\n<li>Fix: Layout of Related Product widget with WC native style<\\/li>\\n<\\/ul>\\n<h4>2.1.7 - 2018-09-03<\\/h4>\\n<ul>\\n<li>New: WC Archive Description widget<\\/li>\\n<li>Tweak: Added blend mode to Slides widget background overlay (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/5555\\\">#5555<\\/a>)<\\/li>\\n<li>Tweak: Added \'Current Subcategories\' option to Product Categories widget<\\/li>\\n<li>Fix: Added default vertical alignment in Author Box widget (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/5589\\\">#5589<\\/a>)<\\/li>\\n<li>Tweak: Added more blend mode options for CTA widget<\\/li>\\n<li>Tweak: Improved plugin updater method based on WordPress version<\\/li>\\n<li>Fix: Improved IE compatibility for Posts and Portfolio widgets<\\/li>\\n<li>Fix: Added default gap for products pagination<\\/li>\\n<li>Fix: Post thumbnail flickering in Safari browser<\\/li>\\n<li>Fix: Close mobile nav menu on click only in full-width mode<\\/li>\\n<li>Fix: Added trailing slash to pagination links in Posts widget<\\/li>\\n<\\/ul>\\n<h4>2.1.6 - 2018-08-28<\\/h4>\\n<ul>\\n<li>New: WC Product Category Image widget and Dynamic tag (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/5117\\\">#5117<\\/a>)<\\/li>\\n<li>Tweak: Allow HTML in Excerpt widget (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/5491\\\">#5491<\\/a>)<\\/li>\\n<li>Tweak: Added compatibility for the upcoming release of Elementor v2.2<\\/li>\\n<li>Tweak: Deprecated Follow option in the Facebook Button widget<\\/li>\\n<li>Fix: Posts widget grid in Safari &amp; IE11 (Depended on Elementor v2.2)<\\/li>\\n<li>Fix: Posts widget CSS when using cards skin in masonry mode<\\/li>\\n<li>Fix: ACF Image &amp; ACF URL option support (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/5344\\\">#5344<\\/a>)<\\/li>\\n<li>Fix: WC product gallery links in RTL<\\/li>\\n<li>Fix: Dynamic tags in Call To Action widget<\\/li>\\n<\\/ul>\\n<h4>2.1.5 - 2018-08-21<\\/h4>\\n<ul>\\n<li>Tweak: Added compatibility for the upcoming release of Elementor v2.2<\\/li>\\n<li>Fix: Posts Widget layout theme compatibility<\\/li>\\n<li>Fix: Added compatibility for WooCommerce native style<\\/li>\\n<\\/ul>\\n<h4>2.1.4 - 2018-08-19<\\/h4>\\n<ul>\\n<li>Fix: Layout issue compatibility with themes caused by v2.1 (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/5442\\\">#5442<\\/a>)<\\/li>\\n<li>Fix: Dynamic setting in Pricing Table widget (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/5460\\\">#5460<\\/a>)<\\/li>\\n<li>Fix: Hide Target URL control if is not necessary in Blockquote widget<\\/li>\\n<li>Fix: Selector specificity for WooCommerce Products widget<\\/li>\\n<li>Fix: WooCommerce conflicts in the editor in edge cases<\\/li>\\n<\\/ul>\\n<h4>2.1.3 - 2018-08-15<\\/h4>\\n<ul>\\n<li>Fix: Thumbnails in the Posts widget jumping (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/5350\\\">#5350<\\/a>)<\\/li>\\n<li>Fix: Responsive grid in the Share Buttons widget (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/5375\\\">#5375<\\/a>)<\\/li>\\n<li>Fix: Added missing <code>setup_postdata<\\/code> for Product Data Tabs widget<\\/li>\\n<li>Fix: Rollback to older version of Flip Box widget to resolve 3D depth issue (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/5399\\\">#5399<\\/a>)<\\/li>\\n<li>Fix: Allowed types in the Upload File field are now case-insensitive (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/5254\\\">#5254<\\/a>)<\\/li>\\n<li>Fix: Carousel behavior when using a single slide<\\/li>\\n<\\/ul>\\n<h4>2.1.2 - 2018-08-12<\\/h4>\\n<ul>\\n<li>Fix: Error when ACF Pro is not installed (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/5367\\\">#5367<\\/a>)<\\/li>\\n<li>Fix: Edge cases in Inspector where document is a boolean<\\/li>\\n<li>Fix: Edge cases for incorrect file fields in PODS<\\/li>\\n<\\/ul>\\n<h4>2.1.1 - 2018-08-09<\\/h4>\\n<ul>\\n<li>Fix: Highlighted text in Animated Headline widget (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/5345\\\">#5345<\\/a>)<\\/li>\\n<li>Fix: Flip Box effect issues<\\/li>\\n<li>Fix: ACF Options page fields support (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/5329\\\">#5329<\\/a>)<\\/li>\\n<li>Fix: Import Pro templates in edge cases<\\/li>\\n<\\/ul>\\n<h4>2.1.0 - 2018-08-07<\\/h4>\\n<ul>\\n<li>New: Introducing WooCommerce Builder (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/1690\\\">#1690<\\/a>)<\\/li>\\n<li>New: Introducing 12 new dynamic tags &amp; widgets for WooCommerce: Gallery, Image, Price, Rating, Description, Breadcrumbs, Data Tabs, Stock, Related, Upsell, Title &amp; Archive<\\/li>\\n<li>New: Introducing Cart Menu widget (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/4220\\\">#4220<\\/a>, <a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/4600\\\">#4600<\\/a>)<\\/li>\\n<li>New: Added integration with Toolset (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/2949\\\">#2949<\\/a>)<\\/li>\\n<li>New: Added integration with Pods (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/4129\\\">#4129<\\/a>)<\\/li>\\n<li>New: Added stick to bottom in scrolling effects (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/4799\\\">#4799<\\/a>)<\\/li>\\n<li>New: Added Scrolling Effect to Widgets under advanced tab<\\/li>\\n<li>New: Introducing Internal URL Dynamic Tag<\\/li>\\n<li>Tweak: Added a Last Updated Date in the Post Info widget (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/4597\\\">#4597<\\/a>)<\\/li>\\n<li>Tweak: Added Redirect after Logout option for Login widget (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/4447\\\">#4447<\\/a>)<\\/li>\\n<li>Tweak: Avoid repeating posts when using more than one in the Posts widget (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/1878\\\">#1878<\\/a>)<\\/li>\\n<li>Tweak: Add Custom Query hook for Query control (<a href=\\\"https:\\/\\/developers.elementor.com\\/custom-query-filter\\/\\\">More Info<\\/a>) (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/1748\\\">#1748<\\/a>)<\\/li>\\n<li>Tweak: Added form-message style (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/1180\\\">#1180<\\/a>)<\\/li>\\n<li>Tweak: Added dynamic tag for button on the Price Table widget (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/4242\\\">#4242<\\/a>)<\\/li>\\n<li>Tweak: Added dynamic tag for Call to action widget (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/4767\\\">#4767<\\/a>)<\\/li>\\n<li>Tweak: Added Dynamic Tags support for Google Map field (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/4602\\\">#4602<\\/a>)<\\/li>\\n<li>Tweak: Added an support for <code>label|value<\\/code> in options field (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/4594\\\">#4594<\\/a>)<\\/li>\\n<li>Tweak: Added <code>by-author<\\/code> condition for theme builder (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/4681\\\">#4681<\\/a>)<\\/li>\\n<li>Tweak: Added Activate\\/Deactivate license key via WP-CLI command (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/4149\\\">#4149<\\/a>)<\\/li>\\n<li>Tweak: Added <code>is_scroll<\\/code> trigger to scrolling effect (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/4340\\\">#4340<\\/a>)<\\/li>\\n<li>Tweak: Added In Same Term support for Post Navigation widget (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/4177\\\">#4177<\\/a>)<\\/li>\\n<li>Tweak: Added responsive control for Slides To Scroll control in all carousel widgets (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/3697\\\">#3697<\\/a>)<\\/li>\\n<li>Tweak: Added style options for Posts widget (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/1335\\\">#1335<\\/a>)<\\/li>\\n<li>Tweak: Added button CSS ID for Forms widget<\\/li>\\n<li>Tweak: Added pixel units to Post-Info divider height control<\\/li>\\n<li>Tweak: Rewrite sticky library to handle with stretch section, auto scroller &amp; more bugs<\\/li>\\n<li>Tweak: Re-organize the panel categories per document type<\\/li>\\n<li>Tweak: Added ACF support for <code>options-page<\\/code> fields<\\/li>\\n<li>Tweak: Added dynamic tag for Animated headlines<\\/li>\\n<li>Tweak: Added dynamic tag for BlockQuote widget<\\/li>\\n<li>Fix: Elementor Full Width template in GeneratePress theme (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/4817\\\">#4817<\\/a>)<\\/li>\\n<li>Fix: Checkbox fields can accidentally be set to required (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/4324\\\">#4324<\\/a>)<\\/li>\\n<li>Fix: Initial slide in Carousel widget<\\/li>\\n<li>Fix: Stay on current slide while editing in Carousel widget<\\/li>\\n<li>Fix: Default slides per device in Carousel widget<\\/li>\\n<li>Deprecated: Woo Products, Woo Elements &amp; Single elements widgets<\\/li>\\n<\\/ul>\\n<h4>2.0.18 - 2018-07-27<\\/h4>\\n<ul>\\n<li>Fix: Global widget error on saving page<\\/li>\\n<\\/ul>\\n<h4>2.0.17 - 2018-07-26<\\/h4>\\n<ul>\\n<li>Fix: Sub menu indicator direction in Nav Menu widget<\\/li>\\n<li>Fix: Change the title and icon for Global Widget when is moving<\\/li>\\n<li>Fix: CSS wrapper selector for Page Document<\\/li>\\n<\\/ul>\\n<h4>2.0.16 - 2018-07-16<\\/h4>\\n<ul>\\n<li>Tweak: CSS Filter Control module is now included in Elementor<\\/li>\\n<li>Fix: Border gap in Portfolio widget when item gap set as <code>0<\\/code> (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/5077\\\">#5077<\\/a>)<\\/li>\\n<li>Fix: Restore current query after get Global Widget data<\\/li>\\n<li>Fix: Add action item in History on unlink Global widget<\\/li>\\n<\\/ul>\\n<h4>2.0.15 - 2018-07-10<\\/h4>\\n<ul>\\n<li>Fix: Dropdown menu items collapsing when activated (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/4996\\\">#4996<\\/a>)<\\/li>\\n<li>Fix: GMT offset in Countdown widget (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/4997\\\">#4997<\\/a>)<\\/li>\\n<\\/ul>\\n<h4>2.0.14 - 2018-07-08<\\/h4>\\n<ul>\\n<li>Tweak: Added set method to form record for developers (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/4983\\\">#4983<\\/a>)<\\/li>\\n<li>Fix: Autoplay option for Carousels<\\/li>\\n<li>Fix: Close mobile menu on item click in the Nav Menu widget<\\/li>\\n<\\/ul>\\n<h4>2.0.13 - 2018-07-03<\\/h4>\\n<ul>\\n<li>Tweak: Added compatibility for Elementor v2.1<\\/li>\\n<\\/ul>\\n<h4>2.0.12 - 2018-07-02<\\/h4>\\n<ul>\\n<li>Fix: Global widget PHP notices<\\/li>\\n<li>Fix: Slides widget active slide lost focus when clicking Editor tabs<\\/li>\\n<li>Fix: Form select field send all selected values on multiple selection<\\/li>\\n<li>Fix: Validate time field only if it\'s not empty<\\/li>\\n<li>Fix: ConvertKit API not saving name field<\\/li>\\n<\\/ul>\\n<h4>2.0.11 - 2018-06-12<\\/h4>\\n<ul>\\n<li>Fix: Theme Builder <code>author<\\/code> archive condition (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/4593\\\">#4593<\\/a>)<\\/li>\\n<li>Fix: Respect password protected posts in Post Content widget<\\/li>\\n<li>Fix: Custom Fonts redirect to post edit screen in edge cases.<\\/li>\\n<\\/ul>\\n<h4>2.0.10 - 2018-06-05<\\/h4>\\n<ul>\\n<li>Tweak: Added <code>elementor\\/theme\\/get_location_templates\\/template_id<\\/code> filter hook for multi-language plugins<\\/li>\\n<li>Fix: Dynamic Post Terms missing taxonomies if the taxonomy is registered to more then one post types (#4386)<\\/li>\\n<li>Fix: Fields shortcode missing after removing a field in Form widget<\\/li>\\n<li>Deprecated: <code>get_theme_templates_by_location<\\/code> is replaced by <code>get_location_templates<\\/code><\\/li>\\n<\\/ul>\\n<h4>2.0.9 - 2018-05-28<\\/h4>\\n<ul>\\n<li>Fix: Compatibility for PHP version 5.4<\\/li>\\n<\\/ul>\\n<h4>2.0.8 - 2018-05-28<\\/h4>\\n<ul>\\n<li>Tweak: Added Active state for Nav Menu dropdown<\\/li>\\n<li>Tweak: Added style for &quot;Nothing Found&quot; Message for Archive Posts widget<\\/li>\\n<li>Tweak: Removed caption control in Site Logo widget<\\/li>\\n<li>Tweak: Added option to position currency symbol before\\/after In Price Table widget<\\/li>\\n<li>Fix: Query control manual selection does not show more than 10 items (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/4479\\\">#4479<\\/a>)<\\/li>\\n<li>Fix: Styling glitch with terms list in Post Info widget (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/4342\\\">#4342<\\/a>)<\\/li>\\n<li>Fix: Sub terms missing in Query control in edge cases (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/4527\\\">#4527<\\/a>)<\\/li>\\n<li>Fix: Avoid rendering a template if it\'s not published<\\/li>\\n<li>Fix: 404 Page style not working<\\/li>\\n<li>Fix: Price Table button with hover animation not working in editor<\\/li>\\n<li>Fix: Styling conflict in Call to Action widget<\\/li>\\n<li>Fix: Global Widget tab translation<\\/li>\\n<li>Fix: Adding parent wrapper class to Site Title widget<\\/li>\\n<\\/ul>\\n<h4>2.0.7 - 2018-05-16<\\/h4>\\n<ul>\\n<li>Fix: Content not found on section when single is set to &quot;All Singular&quot;<\\/li>\\n<li>Fix: Open 404 template library for 404 page<\\/li>\\n<li>Tweak: Added CSS prefix for dev files<\\/li>\\n<li>Tweak: Removed product post type from display conditions<\\/li>\\n<\\/ul>\\n<h4>2.0.6 - 2018-05-15<\\/h4>\\n<ul>\\n<li>Tweak: Set type on create new single template<\\/li>\\n<li>Tweak: Always show the conditions dialog in the Draft status<\\/li>\\n<li>Tweak: Added document type <code>widget<\\/code><\\/li>\\n<li>Tweak: Added Post Custom Field tag to URL category<\\/li>\\n<li>Fix: When ACF Field Groups are Empty (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/4428\\\">#4428<\\/a>)<\\/li>\\n<li>Fix: Links inside carousel in edge cases<\\/li>\\n<li>Fix: Responsive issue in My Templates area<\\/li>\\n<li>Fix: Image alignment for post content with text alignment<\\/li>\\n<li>Fix: Post Content widget when preview post is missing<\\/li>\\n<li>Fix: Global Widget tab translation<\\/li>\\n<li>Fix: Style settings for Post \\/ Archive Title widgets<\\/li>\\n<\\/ul>\\n<h4>2.0.5 - 2018-05-08<\\/h4>\\n<ul>\\n<li>Fix: Creating a CPT with name like document-type breaks the editor (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/4203\\\">#4203<\\/a>)<\\/li>\\n<li>Fix: Added support for new version of reCAPTCHA<\\/li>\\n<li>Fix: Added fallback for controls after <code>post_status<\\/code><\\/li>\\n<li>Fix: Required field in forms widget<\\/li>\\n<li>Fix: Media Carousel in the Coverflow skin<\\/li>\\n<li>Fix: 404 Page show wrong template in edge cases<\\/li>\\n<li>Fix: Save the default menu in the Nav Menu widget<\\/li>\\n<\\/ul>\\n<h4>2.0.4 - 2018-05-02<\\/h4>\\n<ul>\\n<li>Tweak: Added parent\'s class for extended widgets<\\/li>\\n<li>Tweak: Set entire-site as default to avoid conflict with save without conditions<\\/li>\\n<li>Tweak: Initialize global model when it\'s needed<\\/li>\\n<li>Tweak: Removed some duplicate strings<\\/li>\\n<li>Tweak: Query control now includes empty terms<\\/li>\\n<li>Tweak: Design polish for conditions dialog<\\/li>\\n<li>Tweak: Decreasing <code>minimumInputLength<\\/code> to 1 of select2<\\/li>\\n<li>Fix: Editor not loading for single templates in edge cases<\\/li>\\n<li>Fix: Select2 in Safari takes it\'s time to get the original select width (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/4310\\\">#4310<\\/a>)<\\/li>\\n<li>Fix: Slides per view not working for some effects<\\/li>\\n<li>Fix: New slides not showing in the editor<\\/li>\\n<li>Fix: Editor for section without a defined location, defaults to content area<\\/li>\\n<\\/ul>\\n<h4>2.0.3 - 2018-04-24<\\/h4>\\n<ul>\\n<li>Tweak: Optimize CSS for Post Info widget (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/4214\\\">#4214<\\/a>, <a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/4216\\\">#4216<\\/a>, <a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/4225\\\">#4225<\\/a>)<\\/li>\\n<li>Fix: Double render on frontend view in core locations<\\/li>\\n<li>Fix: Masonry not working in edge cases<\\/li>\\n<li>Fix: Added default setting for Author Info tag<\\/li>\\n<\\/ul>\\n<h4>2.0.2 - 2018-04-18<\\/h4>\\n<ul>\\n<li>Fix: Regenerate conditions to include all templates<\\/li>\\n<\\/ul>\\n<h4>2.0.1 - 2018-04-17<\\/h4>\\n<ul>\\n<li>Tweak: Added div wrapper for Nothing Found massage (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/4136\\\">#4136<\\/a>)<\\/li>\\n<li>Tweak: Show empty categories in Query Control &amp; Display Conditions (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/4127\\\">#4127<\\/a>)<\\/li>\\n<li>Tweak: Added Divider control for Post Info widget<\\/li>\\n<li>Fix: Update admin links in Yoast Breadcrumbs widget<\\/li>\\n<li>Fix: Sticky element conflict with clearfix CSS<\\/li>\\n<li>Fix: Compatibility for PHP version 5.4.32 &amp; 5.5.16 and below<\\/li>\\n<li>Fix: Avoid running <code>wp_head<\\/code> hooks twice<\\/li>\\n<\\/ul>\\n<h4>2.0.0 - 2018-04-16<\\/h4>\\n<ul>\\n<li>New: Introducing Theme Builder - <a href=\\\"https:\\/\\/elementor.com\\/introducing-theme-builder\\/\\\">Release Post<\\/a> (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/417\\\">#417<\\/a>)<\\/li>\\n<li>New: Introducing Locations API to inject custom location templates<\\/li>\\n<li>New: Introducing Display Conditions for all dynamic templates<\\/li>\\n<li>New: Introducing Dynamic Tag feature - a new way to add dynamic content to your design<\\/li>\\n<li>New: Introducing Role manager to allow &quot;Content Only mode&quot; (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/483\\\">#483<\\/a>, <a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/653\\\">#653<\\/a>, <a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/885\\\">#885<\\/a>)<\\/li>\\n<li>New: Introducing 9 new dynamic widgets: Archive Posts, Archive Title, Post Content, Post Info, Post Title, Post Excerpt, Featured Image, Site Logo &amp; Site Name (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/543\\\">#543<\\/a>)<\\/li>\\n<li>New: Introducing Developers area with guides and API documentation - <a href=\\\"https:\\/\\/elementor.com\\/introducing-elementor-developer-api\\/\\\">Release Post<\\/a> (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/451\\\">#451<\\/a>)<\\/li>\\n<li>New: Introducing <a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor-hello-theme\\\">Elementor Hello Theme<\\/a> - A demonstration theme for developers<\\/li>\\n<li>New: Added new type of templates: Header, Footer, Single and Archive (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/2761\\\">#2761<\\/a>, <a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/2623\\\">#2623<\\/a>, <a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/2109\\\">#2109<\\/a>, <a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/2061\\\">#2061<\\/a>, <a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/2439\\\">#2439<\\/a>)<\\/li>\\n<li>New: Design 404 page with Single template (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/1558\\\">#1558<\\/a>)<\\/li>\\n<li>New: Design Search Results with Archive template (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/3196\\\">#3196<\\/a>, <a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/2590\\\">#2590<\\/a>)<\\/li>\\n<li>New: Added Scrolling Effect for sections including <em>Sticky Element<\\/em> per device (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/2412\\\">#2412<\\/a>)<\\/li>\\n<li>New: Integration with Custom Fields (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/2054\\\">#2054<\\/a>)<\\/li>\\n<li>New: Partial support for Toolset integration (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/2949\\\">#2949<\\/a>)<\\/li>\\n<li>New: Partial support for Pods integration (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/2169\\\">#2169<\\/a>)<\\/li>\\n<li>New: Partial support for ACF integration (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/2041\\\">#2041<\\/a>, <a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/2059\\\">#2059<\\/a>)<\\/li>\\n<li>Tweak: Add custom fields support for ActiveCampaign (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/3531\\\">#3531<\\/a>)<\\/li>\\n<li>Tweak: Allow brackets in Forms Tel field<\\/li>\\n<li>Tweak: Added currency format control for Price Table widget<\\/li>\\n<li>Tweak: Reduced API request for some servers<\\/li>\\n<li>Fix: Dropdown <code>border-radius<\\/code> in Nav Menu widget<\\/li>\\n<li>Fix: Price List widget layout breaks in edge cases<\\/li>\\n<li>Note: This version requires Elementor v2.0.6<\\/li>\\n<\\/ul>\\n<h4>1.15.6 - 2018-03-28<\\/h4>\\n<ul>\\n<li>Fix: Removed duplicate Custom CSS section (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/3938\\\">#3938<\\/a>)<\\/li>\\n<li>Fix: <code>box-shadow<\\/code> issue with cards skin (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/3940\\\">#3940<\\/a>)<\\/li>\\n<\\/ul>\\n<h4>1.15.5 - 2018-03-27<\\/h4>\\n<ul>\\n<li>Fix: Added global widget compatibility for Elementor v2.0<\\/li>\\n<li>Fix: Reduced API request for some servers<\\/li>\\n<\\/ul>\\n<h4>1.15.4 - 2018-03-26<\\/h4>\\n<ul>\\n<li>Tweak: Allow brackets in phone field<\\/li>\\n<li>Tweak: Added compatibility with Yoast 7.0.+<\\/li>\\n<li>Tweak: Added compatibility for the future release of Elementor v2.0<\\/li>\\n<li>Fix: Support for multiple carousel setting in editor<\\/li>\\n<li>Fix: <code>on_export<\\/code> issue in forms widget (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/3890\\\">#3890<\\/a>)<\\/li>\\n<\\/ul>\\n<h4>1.15.3 - 2018-03-07<\\/h4>\\n<ul>\\n<li>Tweak: Added unique class to field group div (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/3595\\\">#3595<\\/a>)<\\/li>\\n<li>Fix: Screen Options missing when Pro is active (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/3622\\\">#3622<\\/a>)<\\/li>\\n<li>Fix: Allow label styling even when <code>show labels<\\/code> is set hide (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/3544\\\">#3544<\\/a>)<\\/li>\\n<li>Fix: Typography control not working in edge cases<\\/li>\\n<li>Fix: Safari compatibility for Search widget<\\/li>\\n<\\/ul>\\n<h4>1.15.2 - 2018-02-27<\\/h4>\\n<ul>\\n<li>Fix: Only add support mine-type if needed (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/3543\\\">#3543<\\/a>)<\\/li>\\n<li>Fix: Better support for Old Typekit kits<\\/li>\\n<\\/ul>\\n<h4>1.15.1 - 2018-02-21<\\/h4>\\n<ul>\\n<li>Tweak: Custom font title placeholder is not <code>enter font family<\\/code><\\/li>\\n<li>Tweak: Custom font title set as required<\\/li>\\n<li>Fix: Custom font, <code>font-face<\\/code> enqueued only once if used in global (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/3513\\\">#3513<\\/a>)<\\/li>\\n<li>Fix: Added workaround for upload validation which relies on a PHP extension (fileinfo) with inconsistent reporting behavior.<\\/li>\\n<\\/ul>\\n<h4>1.15.0 - 2018-02-19<\\/h4>\\n<ul>\\n<li>New: Added custom fonts manager for self hosted fonts (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/852\\\">#852<\\/a>)<\\/li>\\n<li>New: Integration with Adobe TypeKit fonts (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/631\\\">#631<\\/a>)<\\/li>\\n<li>Tweak: Clear menu from Nav Menu widget on template export<\\/li>\\n<li>Tweak: Allow zero for GetResponse integration as <code>day of cycle<\\/code><\\/li>\\n<\\/ul>\\n<h4>1.14.2 - 2018-02-13<\\/h4>\\n<ul>\\n<li>Fix: Global widget content that got affected by previous update<\\/li>\\n<\\/ul>\\n<h4>1.14.1 - 2018-02-13<\\/h4>\\n<ul>\\n<li>Tweak: Added <code>none<\\/code> option to content animation in CTA widget<\\/li>\\n<li>Tweak: Added <code>form_id<\\/code> to ActiveCampaign integration (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/3422\\\">#3422<\\/a>)<\\/li>\\n<li>Fix: Page crashed when Global widget not found.<\\/li>\\n<\\/ul>\\n<h4>1.14.0 - 2018-02-12<\\/h4>\\n<ul>\\n<li>New: Added Call to Action widget<\\/li>\\n<li>Tweak: MailPoet pull field mapping from MailPoet instead of hardcoded<\\/li>\\n<li>Tweak: Added compatibility for the future release of Elementor v2.0<\\/li>\\n<li>Fix: Allow zero (0) to be accepted as a field value<\\/li>\\n<li>Fix: Login form when custom login URL is set<\\/li>\\n<li>Fix: Added Day of cycle control to GetResponse integration<\\/li>\\n<\\/ul>\\n<h4>1.13.2 - 2018-01-23<\\/h4>\\n<ul>\\n<li>Tweak: Added placeholder to Password field<\\/li>\\n<li>Tweak: Removed <code>subscriber_already_exists_message<\\/code> control to prevent potential data leakage<\\/li>\\n<li>Fix: MailPoet Subscriber Already Exists error validation against translated string directly from MailPoet<\\/li>\\n<li>Fix: Changed <code>imagesLoaded()<\\/code> to Vanilla JS to avoid compatibility issues with some themes<\\/li>\\n<li>Fix: Only validate Tel field if not empty<\\/li>\\n<li>Fix: Stop slider while editing<\\/li>\\n<\\/ul>\\n<h4>1.13.1 - 2018-01-16<\\/h4>\\n<ul>\\n<li>Fix: Added compatibility with old PHP versions<\\/li>\\n<\\/ul>\\n<h4>1.13.0 - 2018-01-16<\\/h4>\\n<ul>\\n<li>New: Added File Upload field for Forms widget (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/1482\\\">#1482<\\/a>, <a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/2974\\\">#2974<\\/a>)<\\/li>\\n<li>New: Added Acceptance field for Forms widget (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/1693\\\">#1693<\\/a>, <a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/2974\\\">#2974<\\/a>)<\\/li>\\n<li>New: Added Date field for Forms widget (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/1868\\\">#1868<\\/a>)<\\/li>\\n<li>New: Added Time field for Forms widget<\\/li>\\n<li>New: Added Password field for Forms widget (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/2164\\\">#2164<\\/a>)<\\/li>\\n<li>New: Added HTML field for Forms widget (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/1500\\\">#1500<\\/a>)<\\/li>\\n<li>Tweak: Added characters validation for Tel field<\\/li>\\n<li>Tweak: Added min &amp; max validation for Number field<\\/li>\\n<li>Tweak: Added multiple selection for Select field<\\/li>\\n<li>Tweak: Added donReach integration for Share Buttons widget<\\/li>\\n<\\/ul>\\n<h4>1.12.3 - 2018-01-09<\\/h4>\\n<ul>\\n<li>Fix: Render element plain content instead of parsed content when not needed in global widget<\\/li>\\n<li>Fix: Apply <code>url-encoding<\\/code> to &quot;Tweet&quot; button text in Blockquote widget to prevent unexpected corruption of the tweet text<\\/li>\\n<li>Fix: Removed My Account link from dashboard widget<\\/li>\\n<\\/ul>\\n<h4>1.12.2 - 2018-01-03<\\/h4>\\n<ul>\\n<li>Tweak: Added animation none for Nav Menu widget (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/2964\\\">#2964<\\/a>)<\\/li>\\n<li>Fix: Active license button style<\\/li>\\n<\\/ul>\\n<h4>1.12.1 - 2018-01-02<\\/h4>\\n<ul>\\n<li>Tweak: Removed theme-element widgets from plain content<\\/li>\\n<li>Tweak: Set all theme-element widgets to extend same widget Base<\\/li>\\n<li>Tweak: Removed credit URL in forms meta data<\\/li>\\n<li>Tweak: Added compatibility for the future release of Elementor v1.9<\\/li>\\n<li>Fix: Validate Get response Error as real error<\\/li>\\n<li>Fix: Removed responsive height control from Facebook Page widget<\\/li>\\n<\\/ul>\\n<h4>1.12.0 - 2017-12-20<\\/h4>\\n<ul>\\n<li>New: Added Drip integration to Forms<\\/li>\\n<li>New: Added ActiveCampaign integration to Forms<\\/li>\\n<li>New: Added ConverKit integration to Forms<\\/li>\\n<li>New: Added GetResponse integration to Forms<\\/li>\\n<li>New: Added form <code>id<\\/code>, <code>name<\\/code> attributes to handle integration with auto collectors like HubSpot<\\/li>\\n<li>New: Added Global API key for MailChimp to improve the workflow<\\/li>\\n<li>Tweak: Better error handling and message display for Forms<\\/li>\\n<li>Fix: PHP notice Undefined variable <code>$cc_header<\\/code> (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/2934\\\">#2934<\\/a>)<\\/li>\\n<\\/ul>\\n<h4>1.11.0 - 2017-12-11<\\/h4>\\n<ul>\\n<li>New: Added a native Comments widget (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/543\\\">#543<\\/a>)<\\/li>\\n<li>New: Added an Author Box widget<\\/li>\\n<li>New: Added a Post Navigation widget<\\/li>\\n<li>New: Added a Yoast Breadcrumbs widget (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/2749\\\">#2749<\\/a>)<\\/li>\\n<li>Tweak: Added a close button to search widget under Full Screen skin (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/2762\\\">#2762<\\/a>)<\\/li>\\n<li>Fix: Allow currency symbol to appear even if price isn\'t numeric<\\/li>\\n<li>Fix: Edge cases when the nav menu is empty in a stretched section<\\/li>\\n<li>Fix: Added fallback when you remove the <code>space-between<\\/code> on Swiper carousel<\\/li>\\n<\\/ul>\\n<h4>1.10.2 - 2017-12-03<\\/h4>\\n<ul>\\n<li>Fix: Missing save widget icon (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/2878\\\">#2878<\\/a>)<\\/li>\\n<li>Fix: Global widgets not saving edits (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/2874\\\">#2874<\\/a>)<\\/li>\\n<li>Fix: Removed <code>white-space: nowrap;<\\/code> property from vertical menu in Nav Menu widget (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/2815\\\">#2815<\\/a>)<\\/li>\\n<\\/ul>\\n<h4>1.10.1 - 2017-11-30<\\/h4>\\n<ul>\\n<li>Tweak: Added default value for search form<\\/li>\\n<li>Tweak: Order template list A-Z in the library widget<\\/li>\\n<li>Tweak: get_users\\/authors query is now done using AJAX only, for better performance in Query Control (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/2865\\\">#2865<\\/a>)<\\/li>\\n<li>Fix: When adding <code>.00<\\/code> it is not displayed on the front<\\/li>\\n<li>Fix: Make sure space between is numeric for carousel control<\\/li>\\n<li>Fix: Added space for radio &amp; checkbox fields in form widget<\\/li>\\n<\\/ul>\\n<h4>1.10.0 - 2017-11-15<\\/h4>\\n<ul>\\n<li>New: Added native Search form widget (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/2576\\\">#2576<\\/a>)<\\/li>\\n<li>Tweak: Added Slides To Scroll &amp; Loop controls to Media Carousel and Testimonials widgets<\\/li>\\n<li>Tweak: Added Inline editing to Blockquote widget<\\/li>\\n<li>Fix: Animated Headline color bug (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/2516\\\">#2516<\\/a>)<\\/li>\\n<li>Fix: Animated Headline with Rotating skin<\\/li>\\n<li>Fix: RTL fix for Animated Headline widget in \'typing\' and \'clip\' animations<\\/li>\\n<li>Fix: Empty menu cause jQuery to crash in Menu widget (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/2662\\\">#2662<\\/a>)<\\/li>\\n<li>Fix: Custom CSS gone after reloading the editor<\\/li>\\n<\\/ul>\\n<h4>1.9.5 - 2017-10-27<\\/h4>\\n<ul>\\n<li>Fix: Broken Global widget with JS (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/2639\\\">#2639<\\/a>)<\\/li>\\n<\\/ul>\\n<h4>1.9.4 - 2017-10-24<\\/h4>\\n<ul>\\n<li>Tweak: Improved UI for notices and license page<\\/li>\\n<li>Fix: Update system conflict with other EDD plugins<\\/li>\\n<li>Fix: WooCommerce frontend hooks on Elementor editor (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/2577\\\">#2577<\\/a>)<\\/li>\\n<li>Fix: Removed default border left in Nav Menu dropdown CSS (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/2496\\\">#2496<\\/a>)<\\/li>\\n<li>Fix: Increased submenu max-width (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/2558\\\">#2558<\\/a>)<\\/li>\\n<li>Fix: Save global templates without their defaults<\\/li>\\n<li>Fix: Horizontal scrolling issue with posts grid<\\/li>\\n<\\/ul>\\n<h4>1.9.3 - 2017-10-03<\\/h4>\\n<ul>\\n<li>Fix: Condition slide style that got affected by previous update<\\/li>\\n<\\/ul>\\n<h4>1.9.2 - 2017-10-02<\\/h4>\\n<ul>\\n<li>New: Added integration with MailPoet 3 for Forms actions<\\/li>\\n<li>Fix: Removed height control from Testimonial carousel in mobile editing mode<\\/li>\\n<li>Fix: Removed bottom padding when there\'s no pagination in Testimonial carousel<\\/li>\\n<li>Fix: Added condition for slides style section in skin bubble mode<\\/li>\\n<li>Fix: Slides per view control for mobile editing in Testimonial carousel<\\/li>\\n<li>Fix: Navigation Arrows icons matched with common Elementor Navigation Arrows<\\/li>\\n<\\/ul>\\n<h4>1.9.1 - 2017-09-28<\\/h4>\\n<ul>\\n<li>Fix: Slides per view for slideshow carousel<\\/li>\\n<li>Fix: Final polish for the new Testimonial Carousel widget<\\/li>\\n<li>Fix: Don\'t play video if slide type is not video<\\/li>\\n<li>Fix: Removed slides style section condition (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/2497\\\">#2497<\\/a>)<\\/li>\\n<li>Fix: Set cursor as pointer for slideshow thumbnails<\\/li>\\n<\\/ul>\\n<h4>1.9.0 - 2017-09-26<\\/h4>\\n<ul>\\n<li>New: Added Media Carousel widget (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/216\\\">#216<\\/a>, <a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/347\\\">#347<\\/a>, <a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/2209\\\">#2209<\\/a>)<\\/li>\\n<li>New: Added Testimonial Carousel widget (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/715\\\">#715<\\/a>)<\\/li>\\n<\\/ul>\\n<h4>1.8.3 - 2017-09-24<\\/h4>\\n<ul>\\n<li>Fix: Added compatibility for WordPress 4.8.2 &amp; 4.7.6<\\/li>\\n<li>Fix: Remove slashes from Form sent data<\\/li>\\n<\\/ul>\\n<h4>1.8.2 - 2017-09-19<\\/h4>\\n<ul>\\n<li>Tweak: Added target URL for the tweet message in Blockquote widget<\\/li>\\n<li>Tweak: Render the slide height before the slider is finished loading<\\/li>\\n<li>Fix: Space between words for Animated Headline widget<\\/li>\\n<li>Fix: RTL compatibility for Animated Headline widget<\\/li>\\n<li>Fix: Italic font style for Animated Headline widget<\\/li>\\n<li>Fix: Excluded Menu widget from the WP Editor text rendering<\\/li>\\n<\\/ul>\\n<h4>1.8.1 - 2017-09-18<\\/h4>\\n<ul>\\n<li>Fix: WCAG Compatible &quot;required&quot; field attribute for W3C validation (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/2391\\\">#2391<\\/a>)<\\/li>\\n<li>Fix: Print the main menu only when is necessary in Menu widget<\\/li>\\n<li>Fix: Use CSS media query instead of JS to hide items in Menu widget to avoid flickering on page load (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/2381\\\">#2381<\\/a>)<\\/li>\\n<\\/ul>\\n<h4>1.8.0 - 2017-09-12<\\/h4>\\n<ul>\\n<li>New: Added Nav Menu widget (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/1406\\\">#1406<\\/a>)<\\/li>\\n<li>Fix: Field ID for checkbox control in Form widget (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/2279\\\">#2279<\\/a>)<\\/li>\\n<li>Fix: Style for Blockquote widget included<\\/li>\\n<\\/ul>\\n<h4>1.7.2 - 2017-09-07<\\/h4>\\n<ul>\\n<li>Tweak: Loading Facebook SDK via JS for better compatibility with caching plugins<\\/li>\\n<li>Fix: Responsive Embed Facebook post widget for Safari iOS (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/2340\\\">#2340<\\/a>)<\\/li>\\n<\\/ul>\\n<h4>1.7.1 - 2017-09-05<\\/h4>\\n<ul>\\n<li>Fix: Facebook SDK version<\\/li>\\n<\\/ul>\\n<h4>1.7.0 - 2017-09-05<\\/h4>\\n<ul>\\n<li>New: Added Facebook Button widget for Like, Recommend, Share and Follow<\\/li>\\n<li>New: Added Facebook Embed widget for Post, Video and Comment<\\/li>\\n<li>New: Added Facebook Comments widget<\\/li>\\n<li>New: Added Facebook Page widget (Previously known as Like Box)<\\/li>\\n<li>New: Added Blockquote widget with Tweet button<\\/li>\\n<li>Tweak: Added Facebook SDK integration for all Facebook widgets<\\/li>\\n<li>Fix: Animated headline rotating with long words<\\/li>\\n<\\/ul>\\n<h4>1.6.1 - 2017-08-28<\\/h4>\\n<ul>\\n<li>Fix: Animated Headline marker gets in front of neighboring spans even when &quot;Bring to Front&quot; is not set<\\/li>\\n<li>Fix: Stroke animation in Animated Headline for MS Edge browser<\\/li>\\n<li>Fix: Animated headline with more than 1-word per rotation<\\/li>\\n<li>Fix: Animated Headline in two lines<\\/li>\\n<li>Fix: Some errors in Global widget<\\/li>\\n<\\/ul>\\n<h4>1.6.0 - 2017-08-22<\\/h4>\\n<ul>\\n<li>New: Added Animated Headline widget<\\/li>\\n<li>New: Added Hidden field for Forms widget (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/2038\\\">#2038<\\/a>)<\\/li>\\n<li>Tweak: Added notice to update Elementor to v1.6.5 or higher<\\/li>\\n<li>Fix: CSS Animations names no longer minified, in order to prevent unexpected conflicts<\\/li>\\n<\\/ul>\\n<h4>1.5.9 - 2017-08-16<\\/h4>\\n<ul>\\n<li>Tweak: Added compatibility for the future release of Elementor v1.7<\\/li>\\n<li>Fix: Portfolio compatibility for GeneratePress theme<\\/li>\\n<li>Fix: Portfolio filter compatibility for RTL<\\/li>\\n<li>Fix: Pagination apply for all posts widget in the page<\\/li>\\n<li>Fix: Global form widget with MailChimp integration not saving<\\/li>\\n<\\/ul>\\n<h4>1.5.8 - 2017-07-25<\\/h4>\\n<ul>\\n<li>Tweak: Added compatibility for the future release of Elementor v1.6<\\/li>\\n<li>Fix: Improved backward compatibility for query control rename<\\/li>\\n<\\/ul>\\n<h4>1.5.7 - 2017-07-24<\\/h4>\\n<ul>\\n<li>Tweak: Moved JS render of reCAPTCHA to a separate file<\\/li>\\n<li>Tweak: Display the label in the reCAPTCHA field for better experience<\\/li>\\n<li>Tweak: Rename <code>panel-posts-control<\\/code> to <code>query-control<\\/code> and added fallback support<\\/li>\\n<li>Tweak: Added compatibility for the future release of Elementor with history feature<\\/li>\\n<li>Fix: reCAPTCHA preview on the editor<\\/li>\\n<li>Fix: Manual selection (query control) has stopped working after saving (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/2000\\\">#2000<\\/a>)<\\/li>\\n<li>Fix: Added condition for icon size control in Share Buttons widget<\\/li>\\n<\\/ul>\\n<h4>1.5.6 - 2017-07-12<\\/h4>\\n<ul>\\n<li>Fix: Query Control correction for taxonomies (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/1963\\\">#1963<\\/a>)<\\/li>\\n<li>Fix: Custom CSS override scheme color in the editor<\\/li>\\n<li>Fix: Added order by Menu Order for Query Control in WC widget<\\/li>\\n<li>Fix: Glitch with Flip Box background overlay<\\/li>\\n<\\/ul>\\n<h4>1.5.5 - 2017-07-03<\\/h4>\\n<ul>\\n<li>Tweak: Moved reCAPTCHA render to handler &amp; load only if a form is exist<\\/li>\\n<li>Fix: MailChimp integration: Default number of items returned by API increased to 999<\\/li>\\n<li>Fix: MailChimp integration: Refresh the groups list if API is changed<\\/li>\\n<li>Fix: Sorted items in filter bar by A-Z<\\/li>\\n<li>Fix: Editor glitch with Elementor v1.5 (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/1927\\\">#1927<\\/a>)<\\/li>\\n<\\/ul>\\n<h4>1.5.4 - 2017-06-22<\\/h4>\\n<ul>\\n<li>Tweak: Improved compatibility for Elementor v1.5<\\/li>\\n<li>Fix: URL default for Add To Cart widget<\\/li>\\n<li>Fix: Allowed <code>date<\\/code> and <code>birthday<\\/code> fields as text for MailChimp integration<\\/li>\\n<\\/ul>\\n<h4>1.5.3 - 2017-06-19<\\/h4>\\n<ul>\\n<li>Tweak: Make flip-box height responsive control<\\/li>\\n<li>Fix: Facebook share count now gets retrieved by Elementor (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/1829\\\">#1829<\\/a>)<\\/li>\\n<li>Fix: Global form widget with MailChimp integration not saving<\\/li>\\n<\\/ul>\\n<h4>1.5.2 - 2017-06-13<\\/h4>\\n<ul>\\n<li>Fix: Custom CSS panel location compatibility for the old versions<\\/li>\\n<\\/ul>\\n<h4>1.5.1 - 2017-06-12<\\/h4>\\n<ul>\\n<li>Fix: MailChimp update existing user registration<\\/li>\\n<li>Fix: Global widget with JS in the editor mode<\\/li>\\n<li>Fix: Label section condition in Login widget<\\/li>\\n<li>Fix: Changes to unlinked global widget do not appear in the editor<\\/li>\\n<\\/ul>\\n<h4>1.5.0 - 2017-05-23<\\/h4>\\n<ul>\\n<li>New: Added Cards, a new skin for Posts widget<\\/li>\\n<li>New: Added Exclude option to post query control group<\\/li>\\n<li>Tweak: Added <code>post_class()<\\/code> for each post in the loop<\\/li>\\n<li>Tweak: Added <code>.elementor-posts-masonry<\\/code> class when Masonry layout is enabled<\\/li>\\n<li>Tweak: Added compatibility for the next release of Elementor v1.5.0<\\/li>\\n<li>Tweak: CSS <code>autoprefixer<\\/code> now supports last 5 versions of browsers<\\/li>\\n<li>Tweak: Added <code>imageLoaded<\\/code> library for Posts &amp; Portfolio widgets<\\/li>\\n<\\/ul>\\n<h4>1.4.4 - 2017-05-18<\\/h4>\\n<ul>\\n<li>Fix: Force Mailchimp API to return all lists and not just 10 (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/1683\\\">#1683<\\/a>)<\\/li>\\n<li>Fix: Added <code>.elementor-form<\\/code> class to Login form to fix style glitch<\\/li>\\n<\\/ul>\\n<h4>1.4.3 - 2017-05-14<\\/h4>\\n<ul>\\n<li>Tweak: Added Redirect After Login option to Login widget<\\/li>\\n<li>Tweak: Stay in the current page after logout in Login widget<\\/li>\\n<li>Tweak: Preparation for Elementor settings tabs in future version<\\/li>\\n<li>Fix: Pinterest in Share Buttons widget now sharing the URL alone<\\/li>\\n<li>Fix: Bug with <code>active<\\/code> class in portfolio filter item<\\/li>\\n<li>Fix: Higher specific list-style-type <code>none<\\/code> for filter items to override some theme style<\\/li>\\n<\\/ul>\\n<h4>1.4.2 - 2017-05-06<\\/h4>\\n<ul>\\n<li>Fix: Temporary patch for form field shortcode in some servers<\\/li>\\n<\\/ul>\\n<h4>1.4.1 - 2017-05-03<\\/h4>\\n<ul>\\n<li>Fix: Bug with custom success message in form widget<\\/li>\\n<li>Fix: Bug with meta data in email action<\\/li>\\n<\\/ul>\\n<h4>1.4.0 - 2017-05-03<\\/h4>\\n<ul>\\n<li>New: Forms: integration with MailChimp<\\/li>\\n<li>New: Forms: integration with MailPoet<\\/li>\\n<li>New: Forms: Added Email 2 action for email confirmation<\\/li>\\n<li>New: Forms: Added shortcodes for fields<\\/li>\\n<li>New: Forms: Added custom ID for fields<\\/li>\\n<li>New: Forms: Added option to edit email HTML template (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/1180\\\">#1180<\\/a>)<\\/li>\\n<li>New: Added Login widget<\\/li>\\n<li>Tweak: Move <code>send_html<\\/code> control to <code>email_content_type<\\/code><\\/li>\\n<li>Fix: Email still sent even if validation failed in form widget<\\/li>\\n<\\/ul>\\n<h4>1.3.2 - 2017-05-01<\\/h4>\\n<ul>\\n<li>New: Added action <code>elementor_pro\\/init<\\/code> for better integration with Elementor Pro<\\/li>\\n<li>Fix: Posts without featured image in Posts widget (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/1234\\\">#1234<\\/a>, <a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/1382\\\">#1382<\\/a>)<\\/li>\\n<li>Fix: reCAPTCHA &amp; Honeypot fields with new method<\\/li>\\n<li>Fix: Added border width control in Share Buttons to avoid a glitch on Chrome browser<\\/li>\\n<li>Fix: Border radius glitch on hover in Share Buttons<\\/li>\\n<\\/ul>\\n<h4>1.3.1 - 2017-04-25<\\/h4>\\n<ul>\\n<li>Fix: Conflict update with revision history module<\\/li>\\n<\\/ul>\\n<h4>1.3.0 - 2017-04-25<\\/h4>\\n<ul>\\n<li>New: Added Share Buttons widget (<a href=\\\"https:\\/\\/wordpress.org\\/support\\/topic\\/social-sharing-buttons-is-it-possible\\/\\\">Topic<\\/a>)<\\/li>\\n<li>New: Added Custom CSS for Page Settings<\\/li>\\n<li>New: Added Masonry layout for Portfolio widget<\\/li>\\n<li>New: Added Cc &amp; Bcc options to email action (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/1181\\\">#1181<\\/a>)<\\/li>\\n<li>New: Introduced <code>ElementorProModulesFormsClassesAction_Base<\\/code> class for better 3rd party integration for forms<\\/li>\\n<li>Tweak: Debugger module now also shows errors from Pro<\\/li>\\n<li>Tweak: Added options for Elementor Library<\\/li>\\n<li>Tweak: New base posts module for optimized performance<\\/li>\\n<li>Tweak: Adjusting Posts \\/ Portfolio to the new structure<\\/li>\\n<li>Fix: Export for posts \\/ portfolio<\\/li>\\n<li>Fix: Duplicate repeater field with switcher control (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/1442\\\">#1442<\\/a>)<\\/li>\\n<li>Fix: Post per Page in the query control<\\/li>\\n<li>Fix: Metadata does not come through on form emails (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/1566\\\">#1566<\\/a>)<\\/li>\\n<\\/ul>\\n<h4>1.2.6 - 2017-04-19<\\/h4>\\n<ul>\\n<li>Fix: Added compatibility with WooCommerce 3.0 - Products &amp; Add to Cart widgets<\\/li>\\n<\\/ul>\\n<h4>1.2.5 - 2017-04-18<\\/h4>\\n<ul>\\n<li>Fix: Offset query for posts widgets (Posts, Portfolio and Products)<\\/li>\\n<\\/ul>\\n<h4>1.2.4 - 2017-03-21<\\/h4>\\n<ul>\\n<li>Tweak: Added Indian Rupee sign to Price Table widget<\\/li>\\n<li>Fix: Portfolio grid for IE11<\\/li>\\n<li>Fix: Link target blank in Price List widget<\\/li>\\n<li>Fix: Active item for filter bar in Portfolio widget<\\/li>\\n<\\/ul>\\n<h4>1.2.3 - 2017-03-06<\\/h4>\\n<ul>\\n<li>Tweak: Fully compatible with Elementor v1.3.0<\\/li>\\n<li>Tweak: Added trigger for after form submission in Forms widget<\\/li>\\n<li>Tweak: Changed handle name in reCAPTCHA field to avoid conflict with other contact forms<\\/li>\\n<li>Fix: Portfolio filter syntax in Non-Latin languages<\\/li>\\n<li>Fix: Added <code>no-repeat<\\/code> property for slide with <code>background-size:contain<\\/code><\\/li>\\n<li>Fix: Condition control &amp; Import value in Posts widgets<\\/li>\\n<li>Fix: Offset and Pagination in WordPress (<a href=\\\"https:\\/\\/codex.wordpress.org\\/Making_Custom_Queries_using_Offset_and_Pagination\\\">More Info<\\/a>)<\\/li>\\n<li>Fix: Submit handler bubbling for custom events in Forms widget<\\/li>\\n<\\/ul>\\n<h4>1.2.2 - 2017-02-23<\\/h4>\\n<ul>\\n<li>Tweak: Change name from Side A\\/B to Front and Back in Flip Box widget<\\/li>\\n<li>Fix: Error when saving third party widgets in the global widget<\\/li>\\n<li>Fix: Image position &quot;none&quot; remains visible in editor preview (Posts)<\\/li>\\n<li>Fix: Hide the pagination when there are no links<\\/li>\\n<\\/ul>\\n<h4>1.2.1 - 2017-02-21<\\/h4>\\n<ul>\\n<li>Fix: Firefox Flip Box 3D compatibility<\\/li>\\n<\\/ul>\\n<h4>1.2.0 - 2017-02-21<\\/h4>\\n<ul>\\n<li>New: Added Flip Box widget<\\/li>\\n<li>New: Added Ken Burns effect for slides<\\/li>\\n<li>New: Added Masonry layout for Posts widget<\\/li>\\n<li>New: Added Pagination option for Posts widget<\\/li>\\n<li>Tweak: Added background size contain to slides<\\/li>\\n<li>Tweak: Improve Query control by preload items<\\/li>\\n<li>Fix: Text color for Checkbox and Radio fields<\\/li>\\n<\\/ul>\\n<h4>1.1.2 - 2017-02-05<\\/h4>\\n<ul>\\n<li>Tweak: Added <code>aria-required<\\/code> for better accessibility in forms widget<\\/li>\\n<li>Fix: Conflict Call to <code>undefined<\\/code> method in Posts &amp; Portfolio widgets (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/1271\\\">#1271<\\/a>, <a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/1266\\\">#1266<\\/a>)<\\/li>\\n<li>Fix: Submit button HTML after error sending<\\/li>\\n<li>Fix: Success message for <code>skip_email<\\/code> function<\\/li>\\n<li>Notice: Elementor 1.2.0 or later now required<\\/li>\\n<\\/ul>\\n<h4>1.1.1 - 2017-01-24<\\/h4>\\n<ul>\\n<li>Fix: Can\'t save global widgets when <code>WP_DEBUG<\\/code> is <code>true<\\/code><\\/li>\\n<li>Fix: Undefined variable in WC widgets<\\/li>\\n<li>Fix: Removed duplicate strings<\\/li>\\n<\\/ul>\\n<h4>1.1.0 - 2017-01-24<\\/h4>\\n<ul>\\n<li>New: Price Table widget (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/102\\\">#102<\\/a>)<\\/li>\\n<li>New: WooCommerce Add to Cart widget<\\/li>\\n<li>New: WooCommerce Categories widget<\\/li>\\n<li>New: WooCommerce Elements widget<\\/li>\\n<li>New: Honeypot field for Forms widgets<\\/li>\\n<li>Tweak: Added inline options for taxonomies &amp; authors if is less than 15 items<\\/li>\\n<li>Tweak: Added Required Mark for fields in Forms widget<\\/li>\\n<li>Fix: CSS selectors priority in Slides widget<\\/li>\\n<li>Fix: CSS bug in Price List widget<\\/li>\\n<li>Fix: Update all Post CSS files that includes specific Global Widget<\\/li>\\n<\\/ul>\\n<h4>1.0.9 - 2017-01-18<\\/h4>\\n<ul>\\n<li>Fix: Auto complete bug in query controls<\\/li>\\n<li>Fix: Render template with escaping slashes<\\/li>\\n<li>Fix: Reply-to field in Forms widget<\\/li>\\n<\\/ul>\\n<h4>1.0.8 - 2017-01-11<\\/h4>\\n<ul>\\n<li>Tweak: Code adjustments for Elementor API<\\/li>\\n<li>Fix: Removed go pro link from plugins page in admin<\\/li>\\n<\\/ul>\\n<h4>1.0.7 - 2017-01-05<\\/h4>\\n<ul>\\n<li>Tweak: Added filter by featured \\/ sale for WC Products widget<\\/li>\\n<li>Tweak: Added author control in Portfolio widget<\\/li>\\n<li>Tweak: Code adjustments for Elementor API<\\/li>\\n<li>Fix: Added support for empty image ratio<\\/li>\\n<li>Fix: Avoid nesting a sidebar within a template that will appear in the sidebar itself<\\/li>\\n<\\/ul>\\n<h4>1.0.6 - 2017-01-01<\\/h4>\\n<ul>\\n<li>Tweak: Added Auto-updates for local translation files<\\/li>\\n<li>Fix: Custom CSS for Global widgets<\\/li>\\n<li>Fix: Remove <code>nonce<\\/code> field (Fix some cache plugins)<\\/li>\\n<\\/ul>\\n<h4>1.0.5 - 2016-12-27<\\/h4>\\n<ul>\\n<li>Fix: Slide element bug fix - \'Link apply on\' logic<\\/li>\\n<li>Fix: Removed unique wrapper for Custom CSS in order to allow media queries (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/1086\\\">#1086<\\/a>)<\\/li>\\n<\\/ul>\\n<h4>1.0.4 - 2016-12-21<\\/h4>\\n<ul>\\n<li>Tweak: Mobile Editing for fields in the form widget<\\/li>\\n<li>Tweak: Mobile Editing for posts<\\/li>\\n<li>Tweak: Allow send form as HTML<\\/li>\\n<li>Tweak: Improved auto upgrades for Multisite installation<\\/li>\\n<li>Tweak: Improve editor rendering experience for Portfolio widget<\\/li>\\n<li>Fix: Posts widget check if image exist<\\/li>\\n<li>Fix: Changed the clone method for global widget (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/1042\\\">#1042<\\/a>)<\\/li>\\n<li>Fix: Bug slides in RTL (removed direction control)<\\/li>\\n<li>Fix: Slides with no height jumps when changing slides<\\/li>\\n<\\/ul>\\n<h4>1.0.3 - 2016-12-13<\\/h4>\\n<ul>\\n<li>Fix: Added escape placeholder for HTML Entities in form widget<\\/li>\\n<li>Fix: Countdown widget RTL bug<\\/li>\\n<li>Fix: Remove redundant #elementor selector for control style<\\/li>\\n<li>Fix: Added prefixing with \'0\' for one digit number in Countdown widget<\\/li>\\n<\\/ul>\\n<h4>1.0.2 - 2016-12-12<\\/h4>\\n<ul>\\n<li>Fix: Page layout collapses when inserting reCAPTCHA field in Form<\\/li>\\n<\\/ul>\\n<h4>1.0.1 - 2016-12-12<\\/h4>\\n<ul>\\n<li>Fix: WordPress widgets disappear from Editor when Elementor Pro active<\\/li>\\n<\\/ul>\\n<h4>1.0.0 - 2016-12-12<\\/h4>\\n<ul>\\n<li>Initial release<\\/li>\\n<\\/ul>\\\";}\",\"new_version\":\"3.33.1\",\"name\":\"Elementor Pro\",\"slug\":\"elementor-pro\",\"url\":\"https:\\/\\/elementor.com\\/pro\\/changelog\\/\",\"homepage\":\"https:\\/\\/elementor.com\\/pro\\/\",\"requires\":\"5.0\",\"tested\":\"6.8.3\",\"elementor_requires\":\"3.0.1\",\"package\":\"\",\"download_link\":\"\",\"banners\":{\"2x\":\"https:\\/\\/ps.w.org\\/elementor\\/assets\\/banner-1544x500.png?rev=1475479\",\"1x\":\"https:\\/\\/ps.w.org\\/elementor\\/assets\\/banner-772x250.png?rev=1475479\"},\"icons\":{\"svg\":\"https:\\/\\/storage.googleapis.com\\/web-public-files\\/Web%20Assets\\/icons\\/icon.svg\"},\"canary_deployment\":{\"plugin_info\":{\"new_version\":\"3.7.0\",\"name\":\"Elementor Pro\",\"slug\":\"elementor-pro\",\"url\":\"https:\\/\\/elementor.com\\/pro\\/changelog\\/\",\"homepage\":\"https:\\/\\/elementor.com\\/pro\\/\",\"requires\":\"5.0\",\"tested\":\"6.8.3\",\"elementor_requires\":\"3.0.1\",\"package\":\"\",\"download_link\":\"\",\"banners\":{\"2x\":\"https:\\/\\/ps.w.org\\/elementor\\/assets\\/banner-1544x500.png?rev=1475479\",\"1x\":\"https:\\/\\/ps.w.org\\/elementor\\/assets\\/banner-772x250.png?rev=1475479\"},\"icons\":{\"svg\":\"https:\\/\\/storage.googleapis.com\\/web-public-files\\/Web%20Assets\\/icons\\/icon.svg\"}},\"conditions\":[[{\"type\":\"language\",\"languages\":[\"he_IL\",\"nl_NL\",\"en_GB\",\"en_NZ\",\"en_ZA\",\"en_AU\",\"en_CA\",\"sv_SE\",\"da_DK\",\"fr_FR\",\"nl_NL\",\"nb_NO\",\"de_AT\",\"fi\",\"it_IT\",\"nn_NO\",\"de_CH\",\"en_GB\",\"is_IS\",\"ga\",\"fr_BE\",\"nl_BE\",\"ast\",\"lb_LU\",\"es_ES\",\"pt_PT\",\"mlt\"],\"operator\":\"in\"}]]},\"cloud\":false}\";}','off');
INSERT INTO `wp_79e54b1ec2_options` VALUES ('45516','_pre_user_id','O:8:\"WP_Error\":3:{s:6:\"errors\";a:1:{s:16:\"empty_user_login\";a:1:{i:0;s:46:\"Cannot create a user with an empty login name.\";}}s:10:\"error_data\";a:0:{}s:18:\"\0*\0additional_data\";a:0:{}}','auto');
-- <?php exit; __halt_compiler(); // Protect the file from being visited via web
-- Orion backup format

DROP TABLE IF EXISTS `wp_79e54b1ec2_postmeta`;

CREATE TABLE `wp_79e54b1ec2_postmeta` (
  `meta_id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `post_id` bigint unsigned NOT NULL DEFAULT '0',
  `meta_key` varchar(255) COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `meta_value` longtext COLLATE utf8mb4_unicode_520_ci,
  PRIMARY KEY (`meta_id`),
  KEY `post_id` (`post_id`),
  KEY `meta_key` (`meta_key`(191))
) ENGINE=InnoDB AUTO_INCREMENT=8972 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

INSERT INTO `wp_79e54b1ec2_postmeta` VALUES ('2','3','_wp_page_template','default');
INSERT INTO `wp_79e54b1ec2_postmeta` VALUES ('3','7','_elementor_edit_mode','builder');
INSERT INTO `wp_79e54b1ec2_postmeta` VALUES ('4','7','_elementor_template_type','kit');
INSERT INTO `wp_79e54b1ec2_postmeta` VALUES ('13','11','_elementor_edit_mode','builder');
INSERT INTO `wp_79e54b1ec2_postmeta` VALUES ('14','11','_elementor_template_type','kit');
INSERT INTO `wp_79e54b1ec2_postmeta` VALUES ('15','11','_elementor_version','3.32.5');
INSERT INTO `wp_79e54b1ec2_postmeta` VALUES ('16','12','_elementor_edit_mode','builder');
INSERT INTO `wp_79e54b1ec2_postmeta` VALUES ('17','12','_elementor_template_type','section');
INSERT INTO `wp_79e54b1ec2_postmeta` VALUES ('18','12','_elementor_version','3.32.5');
INSERT INTO `wp_79e54b1ec2_postmeta` VALUES ('19','11','_wp_page_template','default');
INSERT INTO `wp_79e54b1ec2_postmeta` VALUES ('20','11','_elementor_page_settings','a:27:{s:32:\"colors_enable_styleguide_preview\";s:3:\"yes\";s:13:\"system_colors\";a:4:{i:0;a:3:{s:3:\"_id\";s:7:\"primary\";s:5:\"title\";s:7:\"Primary\";s:5:\"color\";s:7:\"#282C31\";}i:1;a:3:{s:3:\"_id\";s:9:\"secondary\";s:5:\"title\";s:9:\"Secondary\";s:5:\"color\";s:7:\"#ECEEA3\";}i:2;a:3:{s:3:\"_id\";s:4:\"text\";s:5:\"title\";s:4:\"Text\";s:5:\"color\";s:7:\"#7A7A7A\";}i:3;a:3:{s:3:\"_id\";s:6:\"accent\";s:5:\"title\";s:6:\"Accent\";s:5:\"color\";s:7:\"#FF6A00\";}}s:13:\"custom_colors\";a:2:{i:0;a:3:{s:3:\"_id\";s:7:\"4e8747b\";s:5:\"title\";s:10:\"Background\";s:5:\"color\";s:7:\"#F5F5F5\";}i:1;a:3:{s:3:\"_id\";s:7:\"5ee12b7\";s:5:\"title\";s:13:\"Background #2\";s:5:\"color\";s:7:\"#ECEEA5\";}}s:17:\"system_typography\";a:4:{i:0;a:13:{s:3:\"_id\";s:7:\"primary\";s:5:\"title\";s:10:\"H1 Heading\";s:21:\"typography_typography\";s:6:\"custom\";s:22:\"typography_font_family\";s:7:\"Manrope\";s:22:\"typography_font_weight\";s:3:\"600\";s:20:\"typography_font_size\";a:3:{s:4:\"unit\";s:2:\"px\";s:4:\"size\";i:65;s:5:\"sizes\";a:0:{}}s:25:\"typography_text_transform\";s:4:\"none\";s:21:\"typography_font_style\";s:6:\"normal\";s:26:\"typography_text_decoration\";s:4:\"none\";s:22:\"typography_line_height\";a:3:{s:4:\"unit\";s:2:\"em\";s:4:\"size\";d:1.4;s:5:\"sizes\";a:0:{}}s:27:\"typography_font_size_tablet\";a:3:{s:4:\"unit\";s:2:\"px\";s:4:\"size\";i:55;s:5:\"sizes\";a:0:{}}s:27:\"typography_font_size_mobile\";a:3:{s:4:\"unit\";s:2:\"px\";s:4:\"size\";i:42;s:5:\"sizes\";a:0:{}}s:25:\"typography_letter_spacing\";a:3:{s:4:\"unit\";s:2:\"px\";s:4:\"size\";i:0;s:5:\"sizes\";a:0:{}}}i:1;a:13:{s:3:\"_id\";s:9:\"secondary\";s:5:\"title\";s:10:\"H2 Heading\";s:21:\"typography_typography\";s:6:\"custom\";s:22:\"typography_font_family\";s:7:\"Manrope\";s:22:\"typography_font_weight\";s:3:\"600\";s:20:\"typography_font_size\";a:3:{s:4:\"unit\";s:2:\"px\";s:4:\"size\";i:50;s:5:\"sizes\";a:0:{}}s:25:\"typography_text_transform\";s:4:\"none\";s:21:\"typography_font_style\";s:6:\"normal\";s:26:\"typography_text_decoration\";s:4:\"none\";s:22:\"typography_line_height\";a:3:{s:4:\"unit\";s:2:\"em\";s:4:\"size\";d:1.4;s:5:\"sizes\";a:0:{}}s:27:\"typography_font_size_tablet\";a:3:{s:4:\"unit\";s:2:\"px\";s:4:\"size\";i:42;s:5:\"sizes\";a:0:{}}s:27:\"typography_font_size_mobile\";a:3:{s:4:\"unit\";s:2:\"px\";s:4:\"size\";i:37;s:5:\"sizes\";a:0:{}}s:25:\"typography_letter_spacing\";a:3:{s:4:\"unit\";s:2:\"px\";s:4:\"size\";i:0;s:5:\"sizes\";a:0:{}}}i:2;a:13:{s:3:\"_id\";s:4:\"text\";s:5:\"title\";s:4:\"Text\";s:21:\"typography_typography\";s:6:\"custom\";s:22:\"typography_font_family\";s:7:\"Manrope\";s:22:\"typography_font_weight\";s:3:\"500\";s:20:\"typography_font_size\";a:3:{s:4:\"unit\";s:2:\"px\";s:4:\"size\";i:15;s:5:\"sizes\";a:0:{}}s:25:\"typography_text_transform\";s:4:\"none\";s:21:\"typography_font_style\";s:6:\"normal\";s:26:\"typography_text_decoration\";s:4:\"none\";s:22:\"typography_line_height\";a:3:{s:4:\"unit\";s:2:\"em\";s:4:\"size\";d:1.8;s:5:\"sizes\";a:0:{}}s:27:\"typography_font_size_tablet\";a:3:{s:4:\"unit\";s:2:\"px\";s:4:\"size\";i:14;s:5:\"sizes\";a:0:{}}s:27:\"typography_font_size_mobile\";a:3:{s:4:\"unit\";s:2:\"px\";s:4:\"size\";i:14;s:5:\"sizes\";a:0:{}}s:25:\"typography_letter_spacing\";a:3:{s:4:\"unit\";s:2:\"px\";s:4:\"size\";i:0;s:5:\"sizes\";a:0:{}}}i:3;a:12:{s:3:\"_id\";s:6:\"accent\";s:5:\"title\";s:6:\"Button\";s:21:\"typography_typography\";s:6:\"custom\";s:22:\"typography_font_family\";s:7:\"Manrope\";s:22:\"typography_font_weight\";s:3:\"600\";s:20:\"typography_font_size\";a:3:{s:4:\"unit\";s:2:\"px\";s:4:\"size\";i:13;s:5:\"sizes\";a:0:{}}s:25:\"typography_text_transform\";s:4:\"none\";s:21:\"typography_font_style\";s:6:\"normal\";s:26:\"typography_text_decoration\";s:4:\"none\";s:27:\"typography_font_size_tablet\";a:3:{s:4:\"unit\";s:2:\"px\";s:4:\"size\";i:12;s:5:\"sizes\";a:0:{}}s:27:\"typography_font_size_mobile\";a:3:{s:4:\"unit\";s:2:\"px\";s:4:\"size\";i:12;s:5:\"sizes\";a:0:{}}s:25:\"typography_letter_spacing\";a:3:{s:4:\"unit\";s:2:\"px\";s:4:\"size\";i:0;s:5:\"sizes\";a:0:{}}}}s:17:\"custom_typography\";a:7:{i:0;a:13:{s:21:\"typography_typography\";s:6:\"custom\";s:22:\"typography_font_family\";s:7:\"Manrope\";s:20:\"typography_font_size\";a:3:{s:4:\"unit\";s:2:\"px\";s:4:\"size\";i:32;s:5:\"sizes\";a:0:{}}s:27:\"typography_font_size_tablet\";a:3:{s:4:\"unit\";s:2:\"px\";s:4:\"size\";i:30;s:5:\"sizes\";a:0:{}}s:27:\"typography_font_size_mobile\";a:3:{s:4:\"unit\";s:2:\"px\";s:4:\"size\";i:28;s:5:\"sizes\";a:0:{}}s:22:\"typography_font_weight\";s:3:\"600\";s:25:\"typography_text_transform\";s:4:\"none\";s:21:\"typography_font_style\";s:6:\"normal\";s:26:\"typography_text_decoration\";s:4:\"none\";s:22:\"typography_line_height\";a:3:{s:4:\"unit\";s:2:\"em\";s:4:\"size\";d:1.4;s:5:\"sizes\";a:0:{}}s:25:\"typography_letter_spacing\";a:3:{s:4:\"unit\";s:2:\"px\";s:4:\"size\";i:0;s:5:\"sizes\";a:0:{}}s:3:\"_id\";s:7:\"9a7b7f5\";s:5:\"title\";s:10:\"H3 Heading\";}i:1;a:13:{s:21:\"typography_typography\";s:6:\"custom\";s:22:\"typography_font_family\";s:7:\"Manrope\";s:20:\"typography_font_size\";a:3:{s:4:\"unit\";s:2:\"px\";s:4:\"size\";i:26;s:5:\"sizes\";a:0:{}}s:27:\"typography_font_size_tablet\";a:3:{s:4:\"unit\";s:2:\"px\";s:4:\"size\";i:24;s:5:\"sizes\";a:0:{}}s:27:\"typography_font_size_mobile\";a:3:{s:4:\"unit\";s:2:\"px\";s:4:\"size\";i:22;s:5:\"sizes\";a:0:{}}s:22:\"typography_font_weight\";s:3:\"600\";s:25:\"typography_text_transform\";s:4:\"none\";s:21:\"typography_font_style\";s:6:\"normal\";s:26:\"typography_text_decoration\";s:4:\"none\";s:22:\"typography_line_height\";a:3:{s:4:\"unit\";s:2:\"em\";s:4:\"size\";d:1.4;s:5:\"sizes\";a:0:{}}s:25:\"typography_letter_spacing\";a:3:{s:4:\"unit\";s:2:\"px\";s:4:\"size\";i:0;s:5:\"sizes\";a:0:{}}s:3:\"_id\";s:7:\"553bab4\";s:5:\"title\";s:10:\"H4 Heading\";}i:2;a:15:{s:21:\"typography_typography\";s:6:\"custom\";s:22:\"typography_font_family\";s:7:\"Manrope\";s:20:\"typography_font_size\";a:3:{s:4:\"unit\";s:2:\"px\";s:4:\"size\";i:23;s:5:\"sizes\";a:0:{}}s:27:\"typography_font_size_tablet\";a:3:{s:4:\"unit\";s:2:\"px\";s:4:\"size\";i:21;s:5:\"sizes\";a:0:{}}s:27:\"typography_font_size_mobile\";a:3:{s:4:\"unit\";s:2:\"px\";s:4:\"size\";i:20;s:5:\"sizes\";a:0:{}}s:22:\"typography_font_weight\";s:3:\"600\";s:25:\"typography_text_transform\";s:4:\"none\";s:21:\"typography_font_style\";s:6:\"normal\";s:26:\"typography_text_decoration\";s:4:\"none\";s:22:\"typography_line_height\";a:3:{s:4:\"unit\";s:2:\"em\";s:4:\"size\";d:1.5;s:5:\"sizes\";a:0:{}}s:29:\"typography_line_height_tablet\";a:3:{s:4:\"unit\";s:2:\"px\";s:4:\"size\";s:0:\"\";s:5:\"sizes\";a:0:{}}s:29:\"typography_line_height_mobile\";a:3:{s:4:\"unit\";s:2:\"px\";s:4:\"size\";s:0:\"\";s:5:\"sizes\";a:0:{}}s:25:\"typography_letter_spacing\";a:3:{s:4:\"unit\";s:2:\"px\";s:4:\"size\";i:0;s:5:\"sizes\";a:0:{}}s:3:\"_id\";s:7:\"dd834d5\";s:5:\"title\";s:10:\"H5 Heading\";}i:3;a:13:{s:21:\"typography_typography\";s:6:\"custom\";s:22:\"typography_font_family\";s:7:\"Manrope\";s:20:\"typography_font_size\";a:3:{s:4:\"unit\";s:2:\"px\";s:4:\"size\";i:19;s:5:\"sizes\";a:0:{}}s:27:\"typography_font_size_tablet\";a:3:{s:4:\"unit\";s:2:\"px\";s:4:\"size\";i:18;s:5:\"sizes\";a:0:{}}s:27:\"typography_font_size_mobile\";a:3:{s:4:\"unit\";s:2:\"px\";s:4:\"size\";i:17;s:5:\"sizes\";a:0:{}}s:22:\"typography_font_weight\";s:3:\"600\";s:25:\"typography_text_transform\";s:4:\"none\";s:21:\"typography_font_style\";s:6:\"normal\";s:26:\"typography_text_decoration\";s:4:\"none\";s:22:\"typography_line_height\";a:3:{s:4:\"unit\";s:2:\"em\";s:4:\"size\";d:1.6;s:5:\"sizes\";a:0:{}}s:25:\"typography_letter_spacing\";a:3:{s:4:\"unit\";s:2:\"px\";s:4:\"size\";i:0;s:5:\"sizes\";a:0:{}}s:3:\"_id\";s:7:\"95d9cf0\";s:5:\"title\";s:10:\"H6 Heading\";}i:4;a:12:{s:21:\"typography_typography\";s:6:\"custom\";s:22:\"typography_font_family\";s:7:\"Manrope\";s:20:\"typography_font_size\";a:3:{s:4:\"unit\";s:2:\"px\";s:4:\"size\";i:12;s:5:\"sizes\";a:0:{}}s:27:\"typography_font_size_tablet\";a:3:{s:4:\"unit\";s:2:\"px\";s:4:\"size\";i:11;s:5:\"sizes\";a:0:{}}s:27:\"typography_font_size_mobile\";a:3:{s:4:\"unit\";s:2:\"px\";s:4:\"size\";i:10;s:5:\"sizes\";a:0:{}}s:22:\"typography_font_weight\";s:3:\"700\";s:25:\"typography_text_transform\";s:9:\"uppercase\";s:21:\"typography_font_style\";s:6:\"normal\";s:26:\"typography_text_decoration\";s:4:\"none\";s:25:\"typography_letter_spacing\";a:3:{s:4:\"unit\";s:2:\"px\";s:4:\"size\";i:2;s:5:\"sizes\";a:0:{}}s:3:\"_id\";s:7:\"df05d6e\";s:5:\"title\";s:11:\"Accent Text\";}i:5;a:10:{s:21:\"typography_typography\";s:6:\"custom\";s:22:\"typography_font_family\";s:7:\"Manrope\";s:20:\"typography_font_size\";a:3:{s:4:\"unit\";s:2:\"px\";s:4:\"size\";i:14;s:5:\"sizes\";a:0:{}}s:22:\"typography_font_weight\";s:3:\"600\";s:25:\"typography_text_transform\";s:4:\"none\";s:21:\"typography_font_style\";s:6:\"normal\";s:26:\"typography_text_decoration\";s:4:\"none\";s:3:\"_id\";s:7:\"f4096ca\";s:5:\"title\";s:16:\"Header Menu Item\";s:25:\"typography_letter_spacing\";a:3:{s:4:\"unit\";s:2:\"px\";s:4:\"size\";i:0;s:5:\"sizes\";a:0:{}}}i:6;a:10:{s:21:\"typography_typography\";s:6:\"custom\";s:22:\"typography_font_family\";s:7:\"Manrope\";s:20:\"typography_font_size\";a:3:{s:4:\"unit\";s:2:\"px\";s:4:\"size\";i:14;s:5:\"sizes\";a:0:{}}s:22:\"typography_font_weight\";s:3:\"500\";s:25:\"typography_text_transform\";s:4:\"none\";s:21:\"typography_font_style\";s:6:\"normal\";s:26:\"typography_text_decoration\";s:4:\"none\";s:3:\"_id\";s:7:\"c350ccf\";s:5:\"title\";s:19:\"Header Submenu Item\";s:25:\"typography_letter_spacing\";a:3:{s:4:\"unit\";s:2:\"px\";s:4:\"size\";i:0;s:5:\"sizes\";a:0:{}}}}s:21:\"default_generic_fonts\";s:10:\"Sans-serif\";s:19:\"page_title_selector\";s:14:\"h1.entry-title\";s:27:\"hello_footer_copyright_text\";s:19:\"All rights reserved\";s:15:\"activeItemIndex\";i:1;s:11:\"viewport_md\";i:768;s:11:\"viewport_lg\";i:1025;s:26:\"body_background_background\";s:7:\"classic\";s:21:\"body_background_color\";s:7:\"#F5F5F5\";s:25:\"mobile_browser_background\";s:7:\"#F5F5F5\";s:36:\"typography_enable_styleguide_preview\";s:3:\"yes\";s:20:\"button_border_radius\";a:6:{s:4:\"unit\";s:2:\"px\";s:3:\"top\";s:2:\"30\";s:5:\"right\";s:2:\"30\";s:6:\"bottom\";s:2:\"30\";s:4:\"left\";s:2:\"30\";s:8:\"isLinked\";b:1;}s:29:\"button_hover_background_color\";s:7:\"#E6BE42\";s:26:\"button_hover_border_radius\";a:6:{s:4:\"unit\";s:2:\"px\";s:3:\"top\";s:2:\"30\";s:5:\"right\";s:2:\"30\";s:6:\"bottom\";s:2:\"30\";s:4:\"left\";s:2:\"30\";s:8:\"isLinked\";b:1;}s:14:\"button_padding\";a:6:{s:4:\"unit\";s:2:\"px\";s:3:\"top\";s:2:\"14\";s:5:\"right\";s:2:\"30\";s:6:\"bottom\";s:2:\"14\";s:4:\"left\";s:2:\"30\";s:8:\"isLinked\";b:0;}s:27:\"form_field_background_color\";s:9:\"#02010100\";s:24:\"form_field_border_border\";s:5:\"solid\";s:23:\"form_field_border_width\";a:6:{s:4:\"unit\";s:2:\"px\";s:3:\"top\";s:1:\"1\";s:5:\"right\";s:1:\"1\";s:6:\"bottom\";s:1:\"1\";s:4:\"left\";s:1:\"1\";s:8:\"isLinked\";b:1;}s:23:\"form_field_border_color\";s:9:\"#282C3130\";s:24:\"form_field_border_radius\";a:6:{s:4:\"unit\";s:2:\"px\";s:3:\"top\";s:2:\"30\";s:5:\"right\";s:2:\"30\";s:6:\"bottom\";s:2:\"30\";s:4:\"left\";s:2:\"30\";s:8:\"isLinked\";b:1;}s:30:\"form_field_focus_border_border\";s:5:\"solid\";s:29:\"form_field_focus_border_color\";s:9:\"#282C3150\";s:11:\"__globals__\";a:24:{s:17:\"button_text_color\";s:25:\"globals/colors?id=primary\";s:23:\"button_background_color\";s:24:\"globals/colors?id=accent\";s:23:\"button_hover_text_color\";s:25:\"globals/colors?id=primary\";s:28:\"button_typography_typography\";s:28:\"globals/typography?id=accent\";s:10:\"body_color\";s:22:\"globals/colors?id=text\";s:26:\"body_typography_typography\";s:26:\"globals/typography?id=text\";s:17:\"link_normal_color\";s:22:\"globals/colors?id=text\";s:16:\"link_hover_color\";s:25:\"globals/colors?id=primary\";s:8:\"h1_color\";s:25:\"globals/colors?id=primary\";s:24:\"h1_typography_typography\";s:29:\"globals/typography?id=primary\";s:8:\"h2_color\";s:25:\"globals/colors?id=primary\";s:24:\"h2_typography_typography\";s:31:\"globals/typography?id=secondary\";s:8:\"h3_color\";s:25:\"globals/colors?id=primary\";s:24:\"h3_typography_typography\";s:29:\"globals/typography?id=9a7b7f5\";s:8:\"h4_color\";s:25:\"globals/colors?id=primary\";s:24:\"h4_typography_typography\";s:29:\"globals/typography?id=553bab4\";s:8:\"h5_color\";s:25:\"globals/colors?id=primary\";s:24:\"h5_typography_typography\";s:29:\"globals/typography?id=dd834d5\";s:8:\"h6_color\";s:25:\"globals/colors?id=primary\";s:24:\"h6_typography_typography\";s:29:\"globals/typography?id=95d9cf0\";s:16:\"form_label_color\";s:25:\"globals/colors?id=primary\";s:32:\"form_label_typography_typography\";s:28:\"globals/typography?id=accent\";s:32:\"form_field_typography_typography\";s:26:\"globals/typography?id=text\";s:21:\"form_field_text_color\";s:22:\"globals/colors?id=text\";}}');
INSERT INTO `wp_79e54b1ec2_postmeta` VALUES ('21','11','_elementor_data','[]');
INSERT INTO `wp_79e54b1ec2_postmeta` VALUES ('22','13','_elementor_edit_mode','builder');
INSERT INTO `wp_79e54b1ec2_postmeta` VALUES ('23','13','_elementor_template_type','section');
INSERT INTO `wp_79e54b1ec2_postmeta` VALUES ('24','13','_elementor_version','3.32.5');
INSERT INTO `wp_79e54b1ec2_postmeta` VALUES ('25','13','_wp_page_template','default');
INSERT INTO `wp_79e54b1ec2_postmeta` VALUES ('26','13','_elementor_page_settings','a:27:{s:32:\"colors_enable_styleguide_preview\";s:3:\"yes\";s:13:\"system_colors\";a:4:{i:0;a:3:{s:3:\"_id\";s:7:\"primary\";s:5:\"title\";s:7:\"Primary\";s:5:\"color\";s:7:\"#282C31\";}i:1;a:3:{s:3:\"_id\";s:9:\"secondary\";s:5:\"title\";s:9:\"Secondary\";s:5:\"color\";s:7:\"#F3F1E6\";}i:2;a:3:{s:3:\"_id\";s:4:\"text\";s:5:\"title\";s:4:\"Text\";s:5:\"color\";s:7:\"#7A7A7A\";}i:3;a:3:{s:3:\"_id\";s:6:\"accent\";s:5:\"title\";s:6:\"Accent\";s:5:\"color\";s:7:\"#F2CA4B\";}}s:13:\"custom_colors\";a:2:{i:0;a:3:{s:3:\"_id\";s:7:\"4e8747b\";s:5:\"title\";s:10:\"Background\";s:5:\"color\";s:7:\"#F5F5F5\";}i:1;a:3:{s:3:\"_id\";s:7:\"5ee12b7\";s:5:\"title\";s:13:\"Background #2\";s:5:\"color\";s:7:\"#F0EEEA\";}}s:17:\"system_typography\";a:4:{i:0;a:13:{s:3:\"_id\";s:7:\"primary\";s:5:\"title\";s:10:\"H1 Heading\";s:21:\"typography_typography\";s:6:\"custom\";s:22:\"typography_font_family\";s:7:\"Manrope\";s:22:\"typography_font_weight\";s:3:\"600\";s:20:\"typography_font_size\";a:3:{s:4:\"unit\";s:2:\"px\";s:4:\"size\";i:65;s:5:\"sizes\";a:0:{}}s:25:\"typography_text_transform\";s:4:\"none\";s:21:\"typography_font_style\";s:6:\"normal\";s:26:\"typography_text_decoration\";s:4:\"none\";s:22:\"typography_line_height\";a:3:{s:4:\"unit\";s:2:\"em\";s:4:\"size\";d:1.4;s:5:\"sizes\";a:0:{}}s:27:\"typography_font_size_tablet\";a:3:{s:4:\"unit\";s:2:\"px\";s:4:\"size\";i:55;s:5:\"sizes\";a:0:{}}s:27:\"typography_font_size_mobile\";a:3:{s:4:\"unit\";s:2:\"px\";s:4:\"size\";i:42;s:5:\"sizes\";a:0:{}}s:25:\"typography_letter_spacing\";a:3:{s:4:\"unit\";s:2:\"px\";s:4:\"size\";i:0;s:5:\"sizes\";a:0:{}}}i:1;a:13:{s:3:\"_id\";s:9:\"secondary\";s:5:\"title\";s:10:\"H2 Heading\";s:21:\"typography_typography\";s:6:\"custom\";s:22:\"typography_font_family\";s:7:\"Manrope\";s:22:\"typography_font_weight\";s:3:\"600\";s:20:\"typography_font_size\";a:3:{s:4:\"unit\";s:2:\"px\";s:4:\"size\";i:50;s:5:\"sizes\";a:0:{}}s:25:\"typography_text_transform\";s:4:\"none\";s:21:\"typography_font_style\";s:6:\"normal\";s:26:\"typography_text_decoration\";s:4:\"none\";s:22:\"typography_line_height\";a:3:{s:4:\"unit\";s:2:\"em\";s:4:\"size\";d:1.4;s:5:\"sizes\";a:0:{}}s:27:\"typography_font_size_tablet\";a:3:{s:4:\"unit\";s:2:\"px\";s:4:\"size\";i:42;s:5:\"sizes\";a:0:{}}s:27:\"typography_font_size_mobile\";a:3:{s:4:\"unit\";s:2:\"px\";s:4:\"size\";i:37;s:5:\"sizes\";a:0:{}}s:25:\"typography_letter_spacing\";a:3:{s:4:\"unit\";s:2:\"px\";s:4:\"size\";i:0;s:5:\"sizes\";a:0:{}}}i:2;a:13:{s:3:\"_id\";s:4:\"text\";s:5:\"title\";s:4:\"Text\";s:21:\"typography_typography\";s:6:\"custom\";s:22:\"typography_font_family\";s:7:\"Manrope\";s:22:\"typography_font_weight\";s:3:\"500\";s:20:\"typography_font_size\";a:3:{s:4:\"unit\";s:2:\"px\";s:4:\"size\";i:15;s:5:\"sizes\";a:0:{}}s:25:\"typography_text_transform\";s:4:\"none\";s:21:\"typography_font_style\";s:6:\"normal\";s:26:\"typography_text_decoration\";s:4:\"none\";s:22:\"typography_line_height\";a:3:{s:4:\"unit\";s:2:\"em\";s:4:\"size\";d:1.8;s:5:\"sizes\";a:0:{}}s:27:\"typography_font_size_tablet\";a:3:{s:4:\"unit\";s:2:\"px\";s:4:\"size\";i:14;s:5:\"sizes\";a:0:{}}s:27:\"typography_font_size_mobile\";a:3:{s:4:\"unit\";s:2:\"px\";s:4:\"size\";i:14;s:5:\"sizes\";a:0:{}}s:25:\"typography_letter_spacing\";a:3:{s:4:\"unit\";s:2:\"px\";s:4:\"size\";i:0;s:5:\"sizes\";a:0:{}}}i:3;a:12:{s:3:\"_id\";s:6:\"accent\";s:5:\"title\";s:6:\"Button\";s:21:\"typography_typography\";s:6:\"custom\";s:22:\"typography_font_family\";s:7:\"Manrope\";s:22:\"typography_font_weight\";s:3:\"600\";s:20:\"typography_font_size\";a:3:{s:4:\"unit\";s:2:\"px\";s:4:\"size\";i:13;s:5:\"sizes\";a:0:{}}s:25:\"typography_text_transform\";s:4:\"none\";s:21:\"typography_font_style\";s:6:\"normal\";s:26:\"typography_text_decoration\";s:4:\"none\";s:27:\"typography_font_size_tablet\";a:3:{s:4:\"unit\";s:2:\"px\";s:4:\"size\";i:12;s:5:\"sizes\";a:0:{}}s:27:\"typography_font_size_mobile\";a:3:{s:4:\"unit\";s:2:\"px\";s:4:\"size\";i:12;s:5:\"sizes\";a:0:{}}s:25:\"typography_letter_spacing\";a:3:{s:4:\"unit\";s:2:\"px\";s:4:\"size\";i:0;s:5:\"sizes\";a:0:{}}}}s:17:\"custom_typography\";a:7:{i:0;a:13:{s:21:\"typography_typography\";s:6:\"custom\";s:22:\"typography_font_family\";s:7:\"Manrope\";s:20:\"typography_font_size\";a:3:{s:4:\"unit\";s:2:\"px\";s:4:\"size\";i:32;s:5:\"sizes\";a:0:{}}s:27:\"typography_font_size_tablet\";a:3:{s:4:\"unit\";s:2:\"px\";s:4:\"size\";i:30;s:5:\"sizes\";a:0:{}}s:27:\"typography_font_size_mobile\";a:3:{s:4:\"unit\";s:2:\"px\";s:4:\"size\";i:28;s:5:\"sizes\";a:0:{}}s:22:\"typography_font_weight\";s:3:\"600\";s:25:\"typography_text_transform\";s:4:\"none\";s:21:\"typography_font_style\";s:6:\"normal\";s:26:\"typography_text_decoration\";s:4:\"none\";s:22:\"typography_line_height\";a:3:{s:4:\"unit\";s:2:\"em\";s:4:\"size\";d:1.4;s:5:\"sizes\";a:0:{}}s:25:\"typography_letter_spacing\";a:3:{s:4:\"unit\";s:2:\"px\";s:4:\"size\";i:0;s:5:\"sizes\";a:0:{}}s:3:\"_id\";s:7:\"9a7b7f5\";s:5:\"title\";s:10:\"H3 Heading\";}i:1;a:13:{s:21:\"typography_typography\";s:6:\"custom\";s:22:\"typography_font_family\";s:7:\"Manrope\";s:20:\"typography_font_size\";a:3:{s:4:\"unit\";s:2:\"px\";s:4:\"size\";i:26;s:5:\"sizes\";a:0:{}}s:27:\"typography_font_size_tablet\";a:3:{s:4:\"unit\";s:2:\"px\";s:4:\"size\";i:24;s:5:\"sizes\";a:0:{}}s:27:\"typography_font_size_mobile\";a:3:{s:4:\"unit\";s:2:\"px\";s:4:\"size\";i:22;s:5:\"sizes\";a:0:{}}s:22:\"typography_font_weight\";s:3:\"600\";s:25:\"typography_text_transform\";s:4:\"none\";s:21:\"typography_font_style\";s:6:\"normal\";s:26:\"typography_text_decoration\";s:4:\"none\";s:22:\"typography_line_height\";a:3:{s:4:\"unit\";s:2:\"em\";s:4:\"size\";d:1.4;s:5:\"sizes\";a:0:{}}s:25:\"typography_letter_spacing\";a:3:{s:4:\"unit\";s:2:\"px\";s:4:\"size\";i:0;s:5:\"sizes\";a:0:{}}s:3:\"_id\";s:7:\"553bab4\";s:5:\"title\";s:10:\"H4 Heading\";}i:2;a:15:{s:21:\"typography_typography\";s:6:\"custom\";s:22:\"typography_font_family\";s:7:\"Manrope\";s:20:\"typography_font_size\";a:3:{s:4:\"unit\";s:2:\"px\";s:4:\"size\";i:23;s:5:\"sizes\";a:0:{}}s:27:\"typography_font_size_tablet\";a:3:{s:4:\"unit\";s:2:\"px\";s:4:\"size\";i:21;s:5:\"sizes\";a:0:{}}s:27:\"typography_font_size_mobile\";a:3:{s:4:\"unit\";s:2:\"px\";s:4:\"size\";i:20;s:5:\"sizes\";a:0:{}}s:22:\"typography_font_weight\";s:3:\"600\";s:25:\"typography_text_transform\";s:4:\"none\";s:21:\"typography_font_style\";s:6:\"normal\";s:26:\"typography_text_decoration\";s:4:\"none\";s:22:\"typography_line_height\";a:3:{s:4:\"unit\";s:2:\"em\";s:4:\"size\";d:1.5;s:5:\"sizes\";a:0:{}}s:29:\"typography_line_height_tablet\";a:3:{s:4:\"unit\";s:2:\"px\";s:4:\"size\";s:0:\"\";s:5:\"sizes\";a:0:{}}s:29:\"typography_line_height_mobile\";a:3:{s:4:\"unit\";s:2:\"px\";s:4:\"size\";s:0:\"\";s:5:\"sizes\";a:0:{}}s:25:\"typography_letter_spacing\";a:3:{s:4:\"unit\";s:2:\"px\";s:4:\"size\";i:0;s:5:\"sizes\";a:0:{}}s:3:\"_id\";s:7:\"dd834d5\";s:5:\"title\";s:10:\"H5 Heading\";}i:3;a:13:{s:21:\"typography_typography\";s:6:\"custom\";s:22:\"typography_font_family\";s:7:\"Manrope\";s:20:\"typography_font_size\";a:3:{s:4:\"unit\";s:2:\"px\";s:4:\"size\";i:19;s:5:\"sizes\";a:0:{}}s:27:\"typography_font_size_tablet\";a:3:{s:4:\"unit\";s:2:\"px\";s:4:\"size\";i:18;s:5:\"sizes\";a:0:{}}s:27:\"typography_font_size_mobile\";a:3:{s:4:\"unit\";s:2:\"px\";s:4:\"size\";i:17;s:5:\"sizes\";a:0:{}}s:22:\"typography_font_weight\";s:3:\"600\";s:25:\"typography_text_transform\";s:4:\"none\";s:21:\"typography_font_style\";s:6:\"normal\";s:26:\"typography_text_decoration\";s:4:\"none\";s:22:\"typography_line_height\";a:3:{s:4:\"unit\";s:2:\"em\";s:4:\"size\";d:1.6;s:5:\"sizes\";a:0:{}}s:25:\"typography_letter_spacing\";a:3:{s:4:\"unit\";s:2:\"px\";s:4:\"size\";i:0;s:5:\"sizes\";a:0:{}}s:3:\"_id\";s:7:\"95d9cf0\";s:5:\"title\";s:10:\"H6 Heading\";}i:4;a:12:{s:21:\"typography_typography\";s:6:\"custom\";s:22:\"typography_font_family\";s:7:\"Manrope\";s:20:\"typography_font_size\";a:3:{s:4:\"unit\";s:2:\"px\";s:4:\"size\";i:12;s:5:\"sizes\";a:0:{}}s:27:\"typography_font_size_tablet\";a:3:{s:4:\"unit\";s:2:\"px\";s:4:\"size\";i:11;s:5:\"sizes\";a:0:{}}s:27:\"typography_font_size_mobile\";a:3:{s:4:\"unit\";s:2:\"px\";s:4:\"size\";i:10;s:5:\"sizes\";a:0:{}}s:22:\"typography_font_weight\";s:3:\"700\";s:25:\"typography_text_transform\";s:9:\"uppercase\";s:21:\"typography_font_style\";s:6:\"normal\";s:26:\"typography_text_decoration\";s:4:\"none\";s:25:\"typography_letter_spacing\";a:3:{s:4:\"unit\";s:2:\"px\";s:4:\"size\";i:2;s:5:\"sizes\";a:0:{}}s:3:\"_id\";s:7:\"df05d6e\";s:5:\"title\";s:11:\"Accent Text\";}i:5;a:10:{s:21:\"typography_typography\";s:6:\"custom\";s:22:\"typography_font_family\";s:7:\"Manrope\";s:20:\"typography_font_size\";a:3:{s:4:\"unit\";s:2:\"px\";s:4:\"size\";i:14;s:5:\"sizes\";a:0:{}}s:22:\"typography_font_weight\";s:3:\"600\";s:25:\"typography_text_transform\";s:4:\"none\";s:21:\"typography_font_style\";s:6:\"normal\";s:26:\"typography_text_decoration\";s:4:\"none\";s:3:\"_id\";s:7:\"f4096ca\";s:5:\"title\";s:16:\"Header Menu Item\";s:25:\"typography_letter_spacing\";a:3:{s:4:\"unit\";s:2:\"px\";s:4:\"size\";i:0;s:5:\"sizes\";a:0:{}}}i:6;a:10:{s:21:\"typography_typography\";s:6:\"custom\";s:22:\"typography_font_family\";s:7:\"Manrope\";s:20:\"typography_font_size\";a:3:{s:4:\"unit\";s:2:\"px\";s:4:\"size\";i:14;s:5:\"sizes\";a:0:{}}s:22:\"typography_font_weight\";s:3:\"500\";s:25:\"typography_text_transform\";s:4:\"none\";s:21:\"typography_font_style\";s:6:\"normal\";s:26:\"typography_text_decoration\";s:4:\"none\";s:3:\"_id\";s:7:\"c350ccf\";s:5:\"title\";s:19:\"Header Submenu Item\";s:25:\"typography_letter_spacing\";a:3:{s:4:\"unit\";s:2:\"px\";s:4:\"size\";i:0;s:5:\"sizes\";a:0:{}}}}s:21:\"default_generic_fonts\";s:10:\"Sans-serif\";s:19:\"page_title_selector\";s:14:\"h1.entry-title\";s:27:\"hello_footer_copyright_text\";s:19:\"All rights reserved\";s:15:\"activeItemIndex\";i:1;s:11:\"viewport_md\";i:768;s:11:\"viewport_lg\";i:1025;s:26:\"body_background_background\";s:7:\"classic\";s:21:\"body_background_color\";s:7:\"#F5F5F5\";s:25:\"mobile_browser_background\";s:7:\"#F5F5F5\";s:36:\"typography_enable_styleguide_preview\";s:3:\"yes\";s:20:\"button_border_radius\";a:6:{s:4:\"unit\";s:2:\"px\";s:3:\"top\";s:2:\"30\";s:5:\"right\";s:2:\"30\";s:6:\"bottom\";s:2:\"30\";s:4:\"left\";s:2:\"30\";s:8:\"isLinked\";b:1;}s:29:\"button_hover_background_color\";s:7:\"#E6BE42\";s:26:\"button_hover_border_radius\";a:6:{s:4:\"unit\";s:2:\"px\";s:3:\"top\";s:2:\"30\";s:5:\"right\";s:2:\"30\";s:6:\"bottom\";s:2:\"30\";s:4:\"left\";s:2:\"30\";s:8:\"isLinked\";b:1;}s:14:\"button_padding\";a:6:{s:4:\"unit\";s:2:\"px\";s:3:\"top\";s:2:\"14\";s:5:\"right\";s:2:\"30\";s:6:\"bottom\";s:2:\"14\";s:4:\"left\";s:2:\"30\";s:8:\"isLinked\";b:0;}s:27:\"form_field_background_color\";s:9:\"#02010100\";s:24:\"form_field_border_border\";s:5:\"solid\";s:23:\"form_field_border_width\";a:6:{s:4:\"unit\";s:2:\"px\";s:3:\"top\";s:1:\"1\";s:5:\"right\";s:1:\"1\";s:6:\"bottom\";s:1:\"1\";s:4:\"left\";s:1:\"1\";s:8:\"isLinked\";b:1;}s:23:\"form_field_border_color\";s:9:\"#282C3130\";s:24:\"form_field_border_radius\";a:6:{s:4:\"unit\";s:2:\"px\";s:3:\"top\";s:2:\"30\";s:5:\"right\";s:2:\"30\";s:6:\"bottom\";s:2:\"30\";s:4:\"left\";s:2:\"30\";s:8:\"isLinked\";b:1;}s:30:\"form_field_focus_border_border\";s:5:\"solid\";s:29:\"form_field_focus_border_color\";s:9:\"#282C3150\";s:11:\"__globals__\";a:24:{s:17:\"button_text_color\";s:25:\"globals/colors?id=primary\";s:23:\"button_background_color\";s:24:\"globals/colors?id=accent\";s:23:\"button_hover_text_color\";s:25:\"globals/colors?id=primary\";s:28:\"button_typography_typography\";s:28:\"globals/typography?id=accent\";s:10:\"body_color\";s:22:\"globals/colors?id=text\";s:26:\"body_typography_typography\";s:26:\"globals/typography?id=text\";s:17:\"link_normal_color\";s:22:\"globals/colors?id=text\";s:16:\"link_hover_color\";s:25:\"globals/colors?id=primary\";s:8:\"h1_color\";s:25:\"globals/colors?id=primary\";s:24:\"h1_typography_typography\";s:29:\"globals/typography?id=primary\";s:8:\"h2_color\";s:25:\"globals/colors?id=primary\";s:24:\"h2_typography_typography\";s:31:\"globals/typography?id=secondary\";s:8:\"h3_color\";s:25:\"globals/colors?id=primary\";s:24:\"h3_typography_typography\";s:29:\"globals/typography?id=9a7b7f5\";s:8:\"h4_color\";s:25:\"globals/colors?id=primary\";s:24:\"h4_typography_typography\";s:29:\"globals/typography?id=553bab4\";s:8:\"h5_color\";s:25:\"globals/colors?id=primary\";s:24:\"h5_typography_typography\";s:29:\"globals/typography?id=dd834d5\";s:8:\"h6_color\";s:25:\"globals/colors?id=primary\";s:24:\"h6_typography_typography\";s:29:\"globals/typography?id=95d9cf0\";s:16:\"form_label_color\";s:25:\"globals/colors?id=primary\";s:32:\"form_label_typography_typography\";s:28:\"globals/typography?id=accent\";s:32:\"form_field_typography_typography\";s:26:\"globals/typography?id=text\";s:21:\"form_field_text_color\";s:22:\"globals/colors?id=text\";}}');
INSERT INTO `wp_79e54b1ec2_postmeta` VALUES ('27','13','_elementor_data','[]');
INSERT INTO `wp_79e54b1ec2_postmeta` VALUES ('29','11','envato_tk_source_kit','10');
INSERT INTO `wp_79e54b1ec2_postmeta` VALUES ('30','11','envato_tk_source_index','0');
INSERT INTO `wp_79e54b1ec2_postmeta` VALUES ('31','14','_elementor_edit_mode','builder');
INSERT INTO `wp_79e54b1ec2_postmeta` VALUES ('32','14','_elementor_template_type','kit');
INSERT INTO `wp_79e54b1ec2_postmeta` VALUES ('33','14','_elementor_version','3.32.5');
INSERT INTO `wp_79e54b1ec2_postmeta` VALUES ('34','14','_wp_page_template','default');
INSERT INTO `wp_79e54b1ec2_postmeta` VALUES ('35','14','_elementor_page_settings','a:27:{s:32:\"colors_enable_styleguide_preview\";s:3:\"yes\";s:13:\"system_colors\";a:4:{i:0;a:3:{s:3:\"_id\";s:7:\"primary\";s:5:\"title\";s:7:\"Primary\";s:5:\"color\";s:7:\"#282C31\";}i:1;a:3:{s:3:\"_id\";s:9:\"secondary\";s:5:\"title\";s:9:\"Secondary\";s:5:\"color\";s:7:\"#F3F1E6\";}i:2;a:3:{s:3:\"_id\";s:4:\"text\";s:5:\"title\";s:4:\"Text\";s:5:\"color\";s:7:\"#7A7A7A\";}i:3;a:3:{s:3:\"_id\";s:6:\"accent\";s:5:\"title\";s:6:\"Accent\";s:5:\"color\";s:7:\"#F2CA4B\";}}s:13:\"custom_colors\";a:2:{i:0;a:3:{s:3:\"_id\";s:7:\"4e8747b\";s:5:\"title\";s:10:\"Background\";s:5:\"color\";s:7:\"#F5F5F5\";}i:1;a:3:{s:3:\"_id\";s:7:\"5ee12b7\";s:5:\"title\";s:13:\"Background #2\";s:5:\"color\";s:7:\"#F0EEEA\";}}s:17:\"system_typography\";a:4:{i:0;a:13:{s:3:\"_id\";s:7:\"primary\";s:5:\"title\";s:10:\"H1 Heading\";s:21:\"typography_typography\";s:6:\"custom\";s:22:\"typography_font_family\";s:7:\"Manrope\";s:22:\"typography_font_weight\";s:3:\"600\";s:20:\"typography_font_size\";a:3:{s:4:\"unit\";s:2:\"px\";s:4:\"size\";i:65;s:5:\"sizes\";a:0:{}}s:25:\"typography_text_transform\";s:4:\"none\";s:21:\"typography_font_style\";s:6:\"normal\";s:26:\"typography_text_decoration\";s:4:\"none\";s:22:\"typography_line_height\";a:3:{s:4:\"unit\";s:2:\"em\";s:4:\"size\";d:1.4;s:5:\"sizes\";a:0:{}}s:27:\"typography_font_size_tablet\";a:3:{s:4:\"unit\";s:2:\"px\";s:4:\"size\";i:55;s:5:\"sizes\";a:0:{}}s:27:\"typography_font_size_mobile\";a:3:{s:4:\"unit\";s:2:\"px\";s:4:\"size\";i:42;s:5:\"sizes\";a:0:{}}s:25:\"typography_letter_spacing\";a:3:{s:4:\"unit\";s:2:\"px\";s:4:\"size\";i:0;s:5:\"sizes\";a:0:{}}}i:1;a:13:{s:3:\"_id\";s:9:\"secondary\";s:5:\"title\";s:10:\"H2 Heading\";s:21:\"typography_typography\";s:6:\"custom\";s:22:\"typography_font_family\";s:7:\"Manrope\";s:22:\"typography_font_weight\";s:3:\"600\";s:20:\"typography_font_size\";a:3:{s:4:\"unit\";s:2:\"px\";s:4:\"size\";i:50;s:5:\"sizes\";a:0:{}}s:25:\"typography_text_transform\";s:4:\"none\";s:21:\"typography_font_style\";s:6:\"normal\";s:26:\"typography_text_decoration\";s:4:\"none\";s:22:\"typography_line_height\";a:3:{s:4:\"unit\";s:2:\"em\";s:4:\"size\";d:1.4;s:5:\"sizes\";a:0:{}}s:27:\"typography_font_size_tablet\";a:3:{s:4:\"unit\";s:2:\"px\";s:4:\"size\";i:42;s:5:\"sizes\";a:0:{}}s:27:\"typography_font_size_mobile\";a:3:{s:4:\"unit\";s:2:\"px\";s:4:\"size\";i:37;s:5:\"sizes\";a:0:{}}s:25:\"typography_letter_spacing\";a:3:{s:4:\"unit\";s:2:\"px\";s:4:\"size\";i:0;s:5:\"sizes\";a:0:{}}}i:2;a:13:{s:3:\"_id\";s:4:\"text\";s:5:\"title\";s:4:\"Text\";s:21:\"typography_typography\";s:6:\"custom\";s:22:\"typography_font_family\";s:7:\"Manrope\";s:22:\"typography_font_weight\";s:3:\"500\";s:20:\"typography_font_size\";a:3:{s:4:\"unit\";s:2:\"px\";s:4:\"size\";i:15;s:5:\"sizes\";a:0:{}}s:25:\"typography_text_transform\";s:4:\"none\";s:21:\"typography_font_style\";s:6:\"normal\";s:26:\"typography_text_decoration\";s:4:\"none\";s:22:\"typography_line_height\";a:3:{s:4:\"unit\";s:2:\"em\";s:4:\"size\";d:1.8;s:5:\"sizes\";a:0:{}}s:27:\"typography_font_size_tablet\";a:3:{s:4:\"unit\";s:2:\"px\";s:4:\"size\";i:14;s:5:\"sizes\";a:0:{}}s:27:\"typography_font_size_mobile\";a:3:{s:4:\"unit\";s:2:\"px\";s:4:\"size\";i:14;s:5:\"sizes\";a:0:{}}s:25:\"typography_letter_spacing\";a:3:{s:4:\"unit\";s:2:\"px\";s:4:\"size\";i:0;s:5:\"sizes\";a:0:{}}}i:3;a:12:{s:3:\"_id\";s:6:\"accent\";s:5:\"title\";s:6:\"Button\";s:21:\"typography_typography\";s:6:\"custom\";s:22:\"typography_font_family\";s:7:\"Manrope\";s:22:\"typography_font_weight\";s:3:\"600\";s:20:\"typography_font_size\";a:3:{s:4:\"unit\";s:2:\"px\";s:4:\"size\";i:13;s:5:\"sizes\";a:0:{}}s:25:\"typography_text_transform\";s:4:\"none\";s:21:\"typography_font_style\";s:6:\"normal\";s:26:\"typography_text_decoration\";s:4:\"none\";s:27:\"typography_font_size_tablet\";a:3:{s:4:\"unit\";s:2:\"px\";s:4:\"size\";i:12;s:5:\"sizes\";a:0:{}}s:27:\"typography_font_size_mobile\";a:3:{s:4:\"unit\";s:2:\"px\";s:4:\"size\";i:12;s:5:\"sizes\";a:0:{}}s:25:\"typography_letter_spacing\";a:3:{s:4:\"unit\";s:2:\"px\";s:4:\"size\";i:0;s:5:\"sizes\";a:0:{}}}}s:17:\"custom_typography\";a:7:{i:0;a:13:{s:21:\"typography_typography\";s:6:\"custom\";s:22:\"typography_font_family\";s:7:\"Manrope\";s:20:\"typography_font_size\";a:3:{s:4:\"unit\";s:2:\"px\";s:4:\"size\";i:32;s:5:\"sizes\";a:0:{}}s:27:\"typography_font_size_tablet\";a:3:{s:4:\"unit\";s:2:\"px\";s:4:\"size\";i:30;s:5:\"sizes\";a:0:{}}s:27:\"typography_font_size_mobile\";a:3:{s:4:\"unit\";s:2:\"px\";s:4:\"size\";i:28;s:5:\"sizes\";a:0:{}}s:22:\"typography_font_weight\";s:3:\"600\";s:25:\"typography_text_transform\";s:4:\"none\";s:21:\"typography_font_style\";s:6:\"normal\";s:26:\"typography_text_decoration\";s:4:\"none\";s:22:\"typography_line_height\";a:3:{s:4:\"unit\";s:2:\"em\";s:4:\"size\";d:1.4;s:5:\"sizes\";a:0:{}}s:25:\"typography_letter_spacing\";a:3:{s:4:\"unit\";s:2:\"px\";s:4:\"size\";i:0;s:5:\"sizes\";a:0:{}}s:3:\"_id\";s:7:\"9a7b7f5\";s:5:\"title\";s:10:\"H3 Heading\";}i:1;a:13:{s:21:\"typography_typography\";s:6:\"custom\";s:22:\"typography_font_family\";s:7:\"Manrope\";s:20:\"typography_font_size\";a:3:{s:4:\"unit\";s:2:\"px\";s:4:\"size\";i:26;s:5:\"sizes\";a:0:{}}s:27:\"typography_font_size_tablet\";a:3:{s:4:\"unit\";s:2:\"px\";s:4:\"size\";i:24;s:5:\"sizes\";a:0:{}}s:27:\"typography_font_size_mobile\";a:3:{s:4:\"unit\";s:2:\"px\";s:4:\"size\";i:22;s:5:\"sizes\";a:0:{}}s:22:\"typography_font_weight\";s:3:\"600\";s:25:\"typography_text_transform\";s:4:\"none\";s:21:\"typography_font_style\";s:6:\"normal\";s:26:\"typography_text_decoration\";s:4:\"none\";s:22:\"typography_line_height\";a:3:{s:4:\"unit\";s:2:\"em\";s:4:\"size\";d:1.4;s:5:\"sizes\";a:0:{}}s:25:\"typography_letter_spacing\";a:3:{s:4:\"unit\";s:2:\"px\";s:4:\"size\";i:0;s:5:\"sizes\";a:0:{}}s:3:\"_id\";s:7:\"553bab4\";s:5:\"title\";s:10:\"H4 Heading\";}i:2;a:15:{s:21:\"typography_typography\";s:6:\"custom\";s:22:\"typography_font_family\";s:7:\"Manrope\";s:20:\"typography_font_size\";a:3:{s:4:\"unit\";s:2:\"px\";s:4:\"size\";i:23;s:5:\"sizes\";a:0:{}}s:27:\"typography_font_size_tablet\";a:3:{s:4:\"unit\";s:2:\"px\";s:4:\"size\";i:21;s:5:\"sizes\";a:0:{}}s:27:\"typography_font_size_mobile\";a:3:{s:4:\"unit\";s:2:\"px\";s:4:\"size\";i:20;s:5:\"sizes\";a:0:{}}s:22:\"typography_font_weight\";s:3:\"600\";s:25:\"typography_text_transform\";s:4:\"none\";s:21:\"typography_font_style\";s:6:\"normal\";s:26:\"typography_text_decoration\";s:4:\"none\";s:22:\"typography_line_height\";a:3:{s:4:\"unit\";s:2:\"em\";s:4:\"size\";d:1.5;s:5:\"sizes\";a:0:{}}s:29:\"typography_line_height_tablet\";a:3:{s:4:\"unit\";s:2:\"px\";s:4:\"size\";s:0:\"\";s:5:\"sizes\";a:0:{}}s:29:\"typography_line_height_mobile\";a:3:{s:4:\"unit\";s:2:\"px\";s:4:\"size\";s:0:\"\";s:5:\"sizes\";a:0:{}}s:25:\"typography_letter_spacing\";a:3:{s:4:\"unit\";s:2:\"px\";s:4:\"size\";i:0;s:5:\"sizes\";a:0:{}}s:3:\"_id\";s:7:\"dd834d5\";s:5:\"title\";s:10:\"H5 Heading\";}i:3;a:13:{s:21:\"typography_typography\";s:6:\"custom\";s:22:\"typography_font_family\";s:7:\"Manrope\";s:20:\"typography_font_size\";a:3:{s:4:\"unit\";s:2:\"px\";s:4:\"size\";i:19;s:5:\"sizes\";a:0:{}}s:27:\"typography_font_size_tablet\";a:3:{s:4:\"unit\";s:2:\"px\";s:4:\"size\";i:18;s:5:\"sizes\";a:0:{}}s:27:\"typography_font_size_mobile\";a:3:{s:4:\"unit\";s:2:\"px\";s:4:\"size\";i:17;s:5:\"sizes\";a:0:{}}s:22:\"typography_font_weight\";s:3:\"600\";s:25:\"typography_text_transform\";s:4:\"none\";s:21:\"typography_font_style\";s:6:\"normal\";s:26:\"typography_text_decoration\";s:4:\"none\";s:22:\"typography_line_height\";a:3:{s:4:\"unit\";s:2:\"em\";s:4:\"size\";d:1.6;s:5:\"sizes\";a:0:{}}s:25:\"typography_letter_spacing\";a:3:{s:4:\"unit\";s:2:\"px\";s:4:\"size\";i:0;s:5:\"sizes\";a:0:{}}s:3:\"_id\";s:7:\"95d9cf0\";s:5:\"title\";s:10:\"H6 Heading\";}i:4;a:12:{s:21:\"typography_typography\";s:6:\"custom\";s:22:\"typography_font_family\";s:7:\"Manrope\";s:20:\"typography_font_size\";a:3:{s:4:\"unit\";s:2:\"px\";s:4:\"size\";i:12;s:5:\"sizes\";a:0:{}}s:27:\"typography_font_size_tablet\";a:3:{s:4:\"unit\";s:2:\"px\";s:4:\"size\";i:11;s:5:\"sizes\";a:0:{}}s:27:\"typography_font_size_mobile\";a:3:{s:4:\"unit\";s:2:\"px\";s:4:\"size\";i:10;s:5:\"sizes\";a:0:{}}s:22:\"typography_font_weight\";s:3:\"700\";s:25:\"typography_text_transform\";s:9:\"uppercase\";s:21:\"typography_font_style\";s:6:\"normal\";s:26:\"typography_text_decoration\";s:4:\"none\";s:25:\"typography_letter_spacing\";a:3:{s:4:\"unit\";s:2:\"px\";s:4:\"size\";i:2;s:5:\"sizes\";a:0:{}}s:3:\"_id\";s:7:\"df05d6e\";s:5:\"title\";s:11:\"Accent Text\";}i:5;a:10:{s:21:\"typography_typography\";s:6:\"custom\";s:22:\"typography_font_family\";s:7:\"Manrope\";s:20:\"typography_font_size\";a:3:{s:4:\"unit\";s:2:\"px\";s:4:\"size\";i:14;s:5:\"sizes\";a:0:{}}s:22:\"typography_font_weight\";s:3:\"600\";s:25:\"typography_text_transform\";s:4:\"none\";s:21:\"typography_font_style\";s:6:\"normal\";s:26:\"typography_text_decoration\";s:4:\"none\";s:3:\"_id\";s:7:\"f4096ca\";s:5:\"title\";s:16:\"Header Menu Item\";s:25:\"typography_letter_spacing\";a:3:{s:4:\"unit\";s:2:\"px\";s:4:\"size\";i:0;s:5:\"sizes\";a:0:{}}}i:6;a:10:{s:21:\"typography_typography\";s:6:\"custom\";s:22:\"typography_font_family\";s:7:\"Manrope\";s:20:\"typography_font_size\";a:3:{s:4:\"unit\";s:2:\"px\";s:4:\"size\";i:14;s:5:\"sizes\";a:0:{}}s:22:\"typography_font_weight\";s:3:\"500\";s:25:\"typography_text_transform\";s:4:\"none\";s:21:\"typography_font_style\";s:6:\"normal\";s:26:\"typography_text_decoration\";s:4:\"none\";s:3:\"_id\";s:7:\"c350ccf\";s:5:\"title\";s:19:\"Header Submenu Item\";s:25:\"typography_letter_spacing\";a:3:{s:4:\"unit\";s:2:\"px\";s:4:\"size\";i:0;s:5:\"sizes\";a:0:{}}}}s:21:\"default_generic_fonts\";s:10:\"Sans-serif\";s:19:\"page_title_selector\";s:14:\"h1.entry-title\";s:27:\"hello_footer_copyright_text\";s:19:\"All rights reserved\";s:15:\"activeItemIndex\";i:1;s:11:\"viewport_md\";i:768;s:11:\"viewport_lg\";i:1025;s:26:\"body_background_background\";s:7:\"classic\";s:21:\"body_background_color\";s:7:\"#F5F5F5\";s:25:\"mobile_browser_background\";s:7:\"#F5F5F5\";s:36:\"typography_enable_styleguide_preview\";s:3:\"yes\";s:20:\"button_border_radius\";a:6:{s:4:\"unit\";s:2:\"px\";s:3:\"top\";s:2:\"30\";s:5:\"right\";s:2:\"30\";s:6:\"bottom\";s:2:\"30\";s:4:\"left\";s:2:\"30\";s:8:\"isLinked\";b:1;}s:29:\"button_hover_background_color\";s:7:\"#E6BE42\";s:26:\"button_hover_border_radius\";a:6:{s:4:\"unit\";s:2:\"px\";s:3:\"top\";s:2:\"30\";s:5:\"right\";s:2:\"30\";s:6:\"bottom\";s:2:\"30\";s:4:\"left\";s:2:\"30\";s:8:\"isLinked\";b:1;}s:14:\"button_padding\";a:6:{s:4:\"unit\";s:2:\"px\";s:3:\"top\";s:2:\"14\";s:5:\"right\";s:2:\"30\";s:6:\"bottom\";s:2:\"14\";s:4:\"left\";s:2:\"30\";s:8:\"isLinked\";b:0;}s:27:\"form_field_background_color\";s:9:\"#02010100\";s:24:\"form_field_border_border\";s:5:\"solid\";s:23:\"form_field_border_width\";a:6:{s:4:\"unit\";s:2:\"px\";s:3:\"top\";s:1:\"1\";s:5:\"right\";s:1:\"1\";s:6:\"bottom\";s:1:\"1\";s:4:\"left\";s:1:\"1\";s:8:\"isLinked\";b:1;}s:23:\"form_field_border_color\";s:9:\"#282C3130\";s:24:\"form_field_border_radius\";a:6:{s:4:\"unit\";s:2:\"px\";s:3:\"top\";s:2:\"30\";s:5:\"right\";s:2:\"30\";s:6:\"bottom\";s:2:\"30\";s:4:\"left\";s:2:\"30\";s:8:\"isLinked\";b:1;}s:30:\"form_field_focus_border_border\";s:5:\"solid\";s:29:\"form_field_focus_border_color\";s:9:\"#282C3150\";s:11:\"__globals__\";a:24:{s:17:\"button_text_color\";s:25:\"globals/colors?id=primary\";s:23:\"button_background_color\";s:24:\"globals/colors?id=accent\";s:23:\"button_hover_text_color\";s:25:\"globals/colors?id=primary\";s:28:\"button_typography_typography\";s:28:\"globals/typography?id=accent\";s:10:\"body_color\";s:22:\"globals/colors?id=text\";s:26:\"body_typography_typography\";s:26:\"globals/typography?id=text\";s:17:\"link_normal_color\";s:22:\"globals/colors?id=text\";s:16:\"link_hover_color\";s:25:\"globals/colors?id=primary\";s:8:\"h1_color\";s:25:\"globals/colors?id=primary\";s:24:\"h1_typography_typography\";s:29:\"globals/typography?id=primary\";s:8:\"h2_color\";s:25:\"globals/colors?id=primary\";s:24:\"h2_typography_typography\";s:31:\"globals/typography?id=secondary\";s:8:\"h3_color\";s:25:\"globals/colors?id=primary\";s:24:\"h3_typography_typography\";s:29:\"globals/typography?id=9a7b7f5\";s:8:\"h4_color\";s:25:\"globals/colors?id=primary\";s:24:\"h4_typography_typography\";s:29:\"globals/typography?id=553bab4\";s:8:\"h5_color\";s:25:\"globals/colors?id=primary\";s:24:\"h5_typography_typography\";s:29:\"globals/typography?id=dd834d5\";s:8:\"h6_color\";s:25:\"globals/colors?id=primary\";s:24:\"h6_typography_typography\";s:29:\"globals/typography?id=95d9cf0\";s:16:\"form_label_color\";s:25:\"globals/colors?id=primary\";s:32:\"form_label_typography_typography\";s:28:\"globals/typography?id=accent\";s:32:\"form_field_typography_typography\";s:26:\"globals/typography?id=text\";s:21:\"form_field_text_color\";s:22:\"globals/colors?id=text\";}}');
INSERT INTO `wp_79e54b1ec2_postmeta` VALUES ('36','14','_elementor_data','[]');
INSERT INTO `wp_79e54b1ec2_postmeta` VALUES ('43','18','_wp_attached_file','2025/10/young-electrician-on-white-background-holds-a-cab3-GTULEDG.png');
INSERT INTO `wp_79e54b1ec2_postmeta` VALUES ('44','18','_wp_attachment_metadata','a:6:{s:5:\"width\";i:946;s:6:\"height\";i:1100;s:4:\"file\";s:70:\"2025/10/young-electrician-on-white-background-holds-a-cab3-GTULEDG.png\";s:8:\"filesize\";i:238386;s:5:\"sizes\";a:4:{s:6:\"medium\";a:5:{s:4:\"file\";s:70:\"young-electrician-on-white-background-holds-a-cab3-GTULEDG-258x300.png\";s:5:\"width\";i:258;s:6:\"height\";i:300;s:9:\"mime-type\";s:9:\"image/png\";s:8:\"filesize\";i:27617;}s:5:\"large\";a:5:{s:4:\"file\";s:71:\"young-electrician-on-white-background-holds-a-cab3-GTULEDG-881x1024.png\";s:5:\"width\";i:881;s:6:\"height\";i:1024;s:9:\"mime-type\";s:9:\"image/png\";s:8:\"filesize\";i:231961;}s:9:\"thumbnail\";a:5:{s:4:\"file\";s:70:\"young-electrician-on-white-background-holds-a-cab3-GTULEDG-150x150.png\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:9:\"image/png\";s:8:\"filesize\";i:10907;}s:12:\"medium_large\";a:5:{s:4:\"file\";s:70:\"young-electrician-on-white-background-holds-a-cab3-GTULEDG-768x893.png\";s:5:\"width\";i:768;s:6:\"height\";i:893;s:9:\"mime-type\";s:9:\"image/png\";s:8:\"filesize\";i:180167;}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}');
INSERT INTO `wp_79e54b1ec2_postmeta` VALUES ('45','18','_elementor_source_image_hash','04f01f8e248c8487a50682a662d245566ed4125b');
INSERT INTO `wp_79e54b1ec2_postmeta` VALUES ('46','19','_wp_attached_file','2025/10/handsome-electrician-checking-electrical-box-with-7AR2Q5N-e1712033663689.jpg');
INSERT INTO `wp_79e54b1ec2_postmeta` VALUES ('47','19','_wp_attachment_metadata','a:6:{s:5:\"width\";i:2100;s:6:\"height\";i:1400;s:4:\"file\";s:84:\"2025/10/handsome-electrician-checking-electrical-box-with-7AR2Q5N-e1712033663689.jpg\";s:8:\"filesize\";i:362359;s:5:\"sizes\";a:6:{s:6:\"medium\";a:5:{s:4:\"file\";s:84:\"handsome-electrician-checking-electrical-box-with-7AR2Q5N-e1712033663689-300x200.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:200;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:15904;}s:5:\"large\";a:5:{s:4:\"file\";s:85:\"handsome-electrician-checking-electrical-box-with-7AR2Q5N-e1712033663689-1024x683.jpg\";s:5:\"width\";i:1024;s:6:\"height\";i:683;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:115438;}s:9:\"thumbnail\";a:5:{s:4:\"file\";s:84:\"handsome-electrician-checking-electrical-box-with-7AR2Q5N-e1712033663689-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:7999;}s:12:\"medium_large\";a:5:{s:4:\"file\";s:84:\"handsome-electrician-checking-electrical-box-with-7AR2Q5N-e1712033663689-768x512.jpg\";s:5:\"width\";i:768;s:6:\"height\";i:512;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:72473;}s:9:\"1536x1536\";a:5:{s:4:\"file\";s:86:\"handsome-electrician-checking-electrical-box-with-7AR2Q5N-e1712033663689-1536x1024.jpg\";s:5:\"width\";i:1536;s:6:\"height\";i:1024;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:216663;}s:9:\"2048x2048\";a:5:{s:4:\"file\";s:86:\"handsome-electrician-checking-electrical-box-with-7AR2Q5N-e1712033663689-2048x1365.jpg\";s:5:\"width\";i:2048;s:6:\"height\";i:1365;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:337876;}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}');
INSERT INTO `wp_79e54b1ec2_postmeta` VALUES ('48','19','_elementor_source_image_hash','b794a3408763de0ede85c594120f6b4e61bbc46b');
INSERT INTO `wp_79e54b1ec2_postmeta` VALUES ('49','20','_wp_attached_file','2025/10/logo_Asset-4.png');
INSERT INTO `wp_79e54b1ec2_postmeta` VALUES ('50','20','_wp_attachment_metadata','a:6:{s:5:\"width\";i:754;s:6:\"height\";i:1201;s:4:\"file\";s:24:\"2025/10/logo_Asset-4.png\";s:8:\"filesize\";i:27861;s:5:\"sizes\";a:3:{s:6:\"medium\";a:5:{s:4:\"file\";s:24:\"logo_Asset-4-188x300.png\";s:5:\"width\";i:188;s:6:\"height\";i:300;s:9:\"mime-type\";s:9:\"image/png\";s:8:\"filesize\";i:4160;}s:5:\"large\";a:5:{s:4:\"file\";s:25:\"logo_Asset-4-643x1024.png\";s:5:\"width\";i:643;s:6:\"height\";i:1024;s:9:\"mime-type\";s:9:\"image/png\";s:8:\"filesize\";i:17593;}s:9:\"thumbnail\";a:5:{s:4:\"file\";s:24:\"logo_Asset-4-150x150.png\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:9:\"image/png\";s:8:\"filesize\";i:2524;}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}');
INSERT INTO `wp_79e54b1ec2_postmeta` VALUES ('51','20','_elementor_source_image_hash','013041ec3c60453c7989286bf300b33f023f8140');
INSERT INTO `wp_79e54b1ec2_postmeta` VALUES ('52','21','_wp_attached_file','2025/10/side-view-of-electrician-checking-electrical-box-w-LBPF6XT.jpg');
INSERT INTO `wp_79e54b1ec2_postmeta` VALUES ('53','21','_wp_attachment_metadata','a:6:{s:5:\"width\";i:2100;s:6:\"height\";i:1400;s:4:\"file\";s:70:\"2025/10/side-view-of-electrician-checking-electrical-box-w-LBPF6XT.jpg\";s:8:\"filesize\";i:238157;s:5:\"sizes\";a:6:{s:6:\"medium\";a:5:{s:4:\"file\";s:70:\"side-view-of-electrician-checking-electrical-box-w-LBPF6XT-300x200.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:200;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:35488;}s:5:\"large\";a:5:{s:4:\"file\";s:71:\"side-view-of-electrician-checking-electrical-box-w-LBPF6XT-1024x683.jpg\";s:5:\"width\";i:1024;s:6:\"height\";i:683;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:131298;}s:9:\"thumbnail\";a:5:{s:4:\"file\";s:70:\"side-view-of-electrician-checking-electrical-box-w-LBPF6XT-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:26923;}s:12:\"medium_large\";a:5:{s:4:\"file\";s:70:\"side-view-of-electrician-checking-electrical-box-w-LBPF6XT-768x512.jpg\";s:5:\"width\";i:768;s:6:\"height\";i:512;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:90825;}s:9:\"1536x1536\";a:5:{s:4:\"file\";s:72:\"side-view-of-electrician-checking-electrical-box-w-LBPF6XT-1536x1024.jpg\";s:5:\"width\";i:1536;s:6:\"height\";i:1024;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:226123;}s:9:\"2048x2048\";a:5:{s:4:\"file\";s:72:\"side-view-of-electrician-checking-electrical-box-w-LBPF6XT-2048x1365.jpg\";s:5:\"width\";i:2048;s:6:\"height\";i:1365;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:336761;}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:3:\"4.5\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:10:\"NIKON D810\";s:7:\"caption\";s:75:\"side view of electrician checking electrical box with multimetr in corridor\";s:17:\"created_timestamp\";s:10:\"1537371753\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:2:\"50\";s:3:\"iso\";s:3:\"160\";s:13:\"shutter_speed\";s:5:\"0.005\";s:5:\"title\";s:63:\"side view of electrician checking electrical box with multimetr\";s:11:\"orientation\";s:1:\"1\";s:8:\"keywords\";a:1:{i:0;s:64:\"adult,bearded,caucasian,checking,circuit box,corridor,electric,e\";}}}');
INSERT INTO `wp_79e54b1ec2_postmeta` VALUES ('54','21','_elementor_source_image_hash','2b13a53bfcdb3a6eba393d2500770e5e782c6704');
INSERT INTO `wp_79e54b1ec2_postmeta` VALUES ('55','22','_wp_attached_file','2025/10/side-view-young-man-is-working-with-internet-equi-SKJLVBT.jpg');
INSERT INTO `wp_79e54b1ec2_postmeta` VALUES ('56','22','_wp_attachment_metadata','a:6:{s:5:\"width\";i:2100;s:6:\"height\";i:1400;s:4:\"file\";s:69:\"2025/10/side-view-young-man-is-working-with-internet-equi-SKJLVBT.jpg\";s:8:\"filesize\";i:249624;s:5:\"sizes\";a:6:{s:6:\"medium\";a:5:{s:4:\"file\";s:69:\"side-view-young-man-is-working-with-internet-equi-SKJLVBT-300x200.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:200;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:37463;}s:5:\"large\";a:5:{s:4:\"file\";s:70:\"side-view-young-man-is-working-with-internet-equi-SKJLVBT-1024x683.jpg\";s:5:\"width\";i:1024;s:6:\"height\";i:683;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:151069;}s:9:\"thumbnail\";a:5:{s:4:\"file\";s:69:\"side-view-young-man-is-working-with-internet-equi-SKJLVBT-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:27299;}s:12:\"medium_large\";a:5:{s:4:\"file\";s:69:\"side-view-young-man-is-working-with-internet-equi-SKJLVBT-768x512.jpg\";s:5:\"width\";i:768;s:6:\"height\";i:512;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:102616;}s:9:\"1536x1536\";a:5:{s:4:\"file\";s:71:\"side-view-young-man-is-working-with-internet-equi-SKJLVBT-1536x1024.jpg\";s:5:\"width\";i:1536;s:6:\"height\";i:1024;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:263458;}s:9:\"2048x2048\";a:5:{s:4:\"file\";s:71:\"side-view-young-man-is-working-with-internet-equi-SKJLVBT-2048x1365.jpg\";s:5:\"width\";i:2048;s:6:\"height\";i:1365;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:392936;}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:3:\"2.8\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:11:\"NIKON Z 7_2\";s:7:\"caption\";s:81:\"Side view. Young man is working with internet equipment and wires in server room.\";s:17:\"created_timestamp\";s:10:\"1701346928\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:2:\"70\";s:3:\"iso\";s:4:\"2500\";s:13:\"shutter_speed\";s:5:\"0.005\";s:5:\"title\";s:80:\"Side view. Young man is working with internet equipment and wires in server room\";s:11:\"orientation\";s:1:\"1\";s:8:\"keywords\";a:50:{i:0;s:6:\"server\";i:1;s:4:\"room\";i:2;s:8:\"internet\";i:3;s:3:\"man\";i:4;s:4:\"side\";i:5;s:4:\"view\";i:6;s:5:\"young\";i:7;s:7:\"working\";i:8;s:12:\"professional\";i:9;s:5:\"wires\";i:10;s:4:\"male\";i:11;s:5:\"cable\";i:12;s:7:\"uniform\";i:13;s:10:\"technology\";i:14;s:8:\"computer\";i:15;s:7:\"digital\";i:16;s:4:\"data\";i:17;s:7:\"network\";i:18;s:8:\"security\";i:19;s:7:\"science\";i:20;s:3:\"web\";i:21;s:3:\"one\";i:22;s:6:\"person\";i:23;s:8:\"industry\";i:24;s:7:\"support\";i:25;s:3:\"job\";i:26;s:8:\"engineer\";i:27;s:8:\"hardware\";i:28;s:7:\"manager\";i:29;s:7:\"service\";i:30;s:7:\"storage\";i:31;s:10:\"connection\";i:32;s:6:\"system\";i:33;s:9:\"equipment\";i:34;s:10:\"occupation\";i:35;s:8:\"electric\";i:36;s:6:\"router\";i:37;s:11:\"information\";i:38;s:8:\"ethernet\";i:39;s:3:\"lan\";i:40;s:8:\"solution\";i:41;s:4:\"rack\";i:42;s:13:\"administrator\";i:43;s:10:\"technician\";i:44;s:7:\"cabinet\";i:45;s:9:\"caucasian\";i:46;s:6:\"center\";i:47;s:6:\"fixing\";i:48;s:7:\"indoors\";i:49;s:12:\"installation\";}}}');
INSERT INTO `wp_79e54b1ec2_postmeta` VALUES ('57','22','_elementor_source_image_hash','6dda77b8415ce4296f9aa7b2cbb600902a0f0b20');
INSERT INTO `wp_79e54b1ec2_postmeta` VALUES ('58','23','_wp_attached_file','2025/10/icon1.png');
INSERT INTO `wp_79e54b1ec2_postmeta` VALUES ('59','23','_wp_attachment_metadata','a:6:{s:5:\"width\";i:1000;s:6:\"height\";i:1001;s:4:\"file\";s:17:\"2025/10/icon1.png\";s:8:\"filesize\";i:18591;s:5:\"sizes\";a:3:{s:6:\"medium\";a:5:{s:4:\"file\";s:17:\"icon1-300x300.png\";s:5:\"width\";i:300;s:6:\"height\";i:300;s:9:\"mime-type\";s:9:\"image/png\";s:8:\"filesize\";i:2662;}s:9:\"thumbnail\";a:5:{s:4:\"file\";s:17:\"icon1-150x150.png\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:9:\"image/png\";s:8:\"filesize\";i:1483;}s:12:\"medium_large\";a:5:{s:4:\"file\";s:17:\"icon1-768x769.png\";s:5:\"width\";i:768;s:6:\"height\";i:769;s:9:\"mime-type\";s:9:\"image/png\";s:8:\"filesize\";i:7720;}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}');
INSERT INTO `wp_79e54b1ec2_postmeta` VALUES ('60','23','_elementor_source_image_hash','880d66356d38d4e6148f799cffe8b899250ae058');
INSERT INTO `wp_79e54b1ec2_postmeta` VALUES ('61','24','_wp_attached_file','2025/10/professional-electrician-worker-with-screwdriver-i-XJ88KKL.jpg');
INSERT INTO `wp_79e54b1ec2_postmeta` VALUES ('62','24','_wp_attachment_metadata','a:6:{s:5:\"width\";i:2100;s:6:\"height\";i:1400;s:4:\"file\";s:70:\"2025/10/professional-electrician-worker-with-screwdriver-i-XJ88KKL.jpg\";s:8:\"filesize\";i:149303;s:5:\"sizes\";a:6:{s:6:\"medium\";a:5:{s:4:\"file\";s:70:\"professional-electrician-worker-with-screwdriver-i-XJ88KKL-300x200.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:200;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:28670;}s:5:\"large\";a:5:{s:4:\"file\";s:71:\"professional-electrician-worker-with-screwdriver-i-XJ88KKL-1024x683.jpg\";s:5:\"width\";i:1024;s:6:\"height\";i:683;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:83520;}s:9:\"thumbnail\";a:5:{s:4:\"file\";s:70:\"professional-electrician-worker-with-screwdriver-i-XJ88KKL-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:23375;}s:12:\"medium_large\";a:5:{s:4:\"file\";s:70:\"professional-electrician-worker-with-screwdriver-i-XJ88KKL-768x512.jpg\";s:5:\"width\";i:768;s:6:\"height\";i:512;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:59554;}s:9:\"1536x1536\";a:5:{s:4:\"file\";s:72:\"professional-electrician-worker-with-screwdriver-i-XJ88KKL-1536x1024.jpg\";s:5:\"width\";i:1536;s:6:\"height\";i:1024;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:144125;}s:9:\"2048x2048\";a:5:{s:4:\"file\";s:72:\"professional-electrician-worker-with-screwdriver-i-XJ88KKL-2048x1365.jpg\";s:5:\"width\";i:2048;s:6:\"height\";i:1365;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:219018;}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"2\";s:6:\"credit\";s:17:\"yaroslav astakhov\";s:6:\"camera\";s:11:\"Canon EOS R\";s:7:\"caption\";s:96:\"Professional electrician worker in uniform with screwdriver is repairing power socket in kitchen\";s:17:\"created_timestamp\";s:10:\"1668687540\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:2:\"29\";s:3:\"iso\";s:3:\"320\";s:13:\"shutter_speed\";s:6:\"0.0125\";s:5:\"title\";s:85:\"Professional electrician worker with screwdriver is repairing power socket in kitchen\";s:11:\"orientation\";s:1:\"1\";s:8:\"keywords\";a:50:{i:0;s:4:\"home\";i:1;s:6:\"socket\";i:2;s:11:\"electrician\";i:3;s:8:\"handyman\";i:4;s:4:\"male\";i:5;s:3:\"man\";i:6;s:5:\"house\";i:7;s:6:\"repair\";i:8;s:4:\"tool\";i:9;s:12:\"construction\";i:10;s:10:\"electrical\";i:11;s:11:\"maintenance\";i:12;s:6:\"worker\";i:13;s:11:\"electricity\";i:14;s:7:\"service\";i:15;s:6:\"person\";i:16;s:10:\"installing\";i:17;s:3:\"job\";i:18;s:5:\"power\";i:19;s:12:\"professional\";i:20;s:4:\"work\";i:21;s:9:\"repairman\";i:22;s:7:\"builder\";i:23;s:9:\"caucasian\";i:24;s:10:\"occupation\";i:25;s:8:\"electric\";i:26;s:12:\"installation\";i:27;s:4:\"plug\";i:28;s:11:\"screwdriver\";i:29;s:10:\"technician\";i:30;s:9:\"equipment\";i:31;s:3:\"fix\";i:32;s:6:\"fixing\";i:33;s:4:\"wall\";i:34;s:7:\"indoors\";i:35;s:6:\"people\";i:36;s:6:\"switch\";i:37;s:7:\"workman\";i:38;s:6:\"outlet\";i:39;s:10:\"profession\";i:40;s:11:\"improvement\";i:41;s:6:\"manual\";i:42;s:7:\"working\";i:43;s:8:\"building\";i:44;s:6:\"gloves\";i:45;s:7:\"install\";i:46;s:7:\"uniform\";i:47;s:5:\"white\";i:48;s:5:\"adult\";i:49;s:5:\"cable\";}}}');
INSERT INTO `wp_79e54b1ec2_postmeta` VALUES ('63','24','_elementor_source_image_hash','a17cced5f46407a42b9cae6d362f0302bd06c471');
INSERT INTO `wp_79e54b1ec2_postmeta` VALUES ('64','25','_wp_attached_file','2025/10/icon2.png');
INSERT INTO `wp_79e54b1ec2_postmeta` VALUES ('65','25','_wp_attachment_metadata','a:6:{s:5:\"width\";i:1000;s:6:\"height\";i:1001;s:4:\"file\";s:17:\"2025/10/icon2.png\";s:8:\"filesize\";i:19103;s:5:\"sizes\";a:3:{s:6:\"medium\";a:5:{s:4:\"file\";s:17:\"icon2-300x300.png\";s:5:\"width\";i:300;s:6:\"height\";i:300;s:9:\"mime-type\";s:9:\"image/png\";s:8:\"filesize\";i:2969;}s:9:\"thumbnail\";a:5:{s:4:\"file\";s:17:\"icon2-150x150.png\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:9:\"image/png\";s:8:\"filesize\";i:1633;}s:12:\"medium_large\";a:5:{s:4:\"file\";s:17:\"icon2-768x769.png\";s:5:\"width\";i:768;s:6:\"height\";i:769;s:9:\"mime-type\";s:9:\"image/png\";s:8:\"filesize\";i:8694;}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}');
INSERT INTO `wp_79e54b1ec2_postmeta` VALUES ('66','25','_elementor_source_image_hash','40562d1d3e8c6f0252dcc2175ab3f184b79ca544');
INSERT INTO `wp_79e54b1ec2_postmeta` VALUES ('67','26','_wp_attached_file','2025/10/electrician-working-on-the-electrical-installation-MQEQHZE.jpg');
INSERT INTO `wp_79e54b1ec2_postmeta` VALUES ('68','26','_wp_attachment_metadata','a:6:{s:5:\"width\";i:2100;s:6:\"height\";i:1400;s:4:\"file\";s:70:\"2025/10/electrician-working-on-the-electrical-installation-MQEQHZE.jpg\";s:8:\"filesize\";i:133616;s:5:\"sizes\";a:6:{s:6:\"medium\";a:5:{s:4:\"file\";s:70:\"electrician-working-on-the-electrical-installation-MQEQHZE-300x200.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:200;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:35098;}s:5:\"large\";a:5:{s:4:\"file\";s:71:\"electrician-working-on-the-electrical-installation-MQEQHZE-1024x683.jpg\";s:5:\"width\";i:1024;s:6:\"height\";i:683;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:82433;}s:9:\"thumbnail\";a:5:{s:4:\"file\";s:70:\"electrician-working-on-the-electrical-installation-MQEQHZE-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:31405;}s:12:\"medium_large\";a:5:{s:4:\"file\";s:70:\"electrician-working-on-the-electrical-installation-MQEQHZE-768x512.jpg\";s:5:\"width\";i:768;s:6:\"height\";i:512;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:61215;}s:9:\"1536x1536\";a:5:{s:4:\"file\";s:72:\"electrician-working-on-the-electrical-installation-MQEQHZE-1536x1024.jpg\";s:5:\"width\";i:1536;s:6:\"height\";i:1024;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:134102;}s:9:\"2048x2048\";a:5:{s:4:\"file\";s:72:\"electrician-working-on-the-electrical-installation-MQEQHZE-2048x1365.jpg\";s:5:\"width\";i:2048;s:6:\"height\";i:1365;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:194926;}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:3:\"3.2\";s:6:\"credit\";s:14:\"David Pereiras\";s:6:\"camera\";s:21:\"Canon EOS 5D Mark III\";s:7:\"caption\";s:109:\"Unrecognizable male electrician wrapping cable with electrical tape on the electrical installation of a house\";s:17:\"created_timestamp\";s:10:\"1583073094\";s:9:\"copyright\";s:22:\"© 2020 David Pereiras\";s:12:\"focal_length\";s:2:\"35\";s:3:\"iso\";s:3:\"250\";s:13:\"shutter_speed\";s:7:\"0.00625\";s:5:\"title\";s:61:\"Electrician working on the electrical installation of a house\";s:11:\"orientation\";s:1:\"1\";s:8:\"keywords\";a:49:{i:0;s:11:\"electrician\";i:1;s:14:\"unrecognizable\";i:2;s:21:\"electrical technician\";i:3;s:10:\"connecting\";i:4;s:8:\"wrapping\";i:5;s:15:\"electrical tape\";i:6;s:10:\"protecting\";i:7;s:15:\"insulating tape\";i:8;s:14:\"electric cable\";i:9;s:6:\"danger\";i:10;s:8:\"scissors\";i:11;s:8:\"switches\";i:12;s:12:\"installation\";i:13;s:8:\"top view\";i:14;s:13:\"electric wire\";i:15;s:23:\"electrical installation\";i:16;s:8:\"applying\";i:17;s:10:\"connection\";i:18;s:12:\"construction\";i:19;s:7:\"laborer\";i:20;s:5:\"power\";i:21;s:5:\"cable\";i:22;s:3:\"fix\";i:23;s:8:\"electric\";i:24;s:11:\"electricity\";i:25;s:6:\"worker\";i:26;s:6:\"wiring\";i:27;s:4:\"home\";i:28;s:9:\"caucasian\";i:29;s:10:\"installing\";i:30;s:10:\"occupation\";i:31;s:12:\"professional\";i:32;s:6:\"person\";i:33;s:14:\"do it yourself\";i:34;s:4:\"wire\";i:35;s:5:\"house\";i:36;s:7:\"fitting\";i:37;s:3:\"one\";i:38;s:6:\"people\";i:39;s:9:\"installer\";i:40;s:4:\"work\";i:41;s:4:\"plug\";i:42;s:8:\"overhead\";i:43;s:6:\"aerial\";i:44;s:8:\"crouched\";i:45;s:3:\"man\";i:46;s:4:\"male\";i:47;s:10:\"copy space\";i:48;s:10:\"horizontal\";}}}');
INSERT INTO `wp_79e54b1ec2_postmeta` VALUES ('69','26','_elementor_source_image_hash','7ef4f77d7292ab98887ad8e44cc9ebf28e05d6d7');
INSERT INTO `wp_79e54b1ec2_postmeta` VALUES ('70','27','_wp_attached_file','2025/10/icon3.png');
INSERT INTO `wp_79e54b1ec2_postmeta` VALUES ('71','27','_wp_attachment_metadata','a:6:{s:5:\"width\";i:1001;s:6:\"height\";i:1001;s:4:\"file\";s:17:\"2025/10/icon3.png\";s:8:\"filesize\";i:22227;s:5:\"sizes\";a:3:{s:6:\"medium\";a:5:{s:4:\"file\";s:17:\"icon3-300x300.png\";s:5:\"width\";i:300;s:6:\"height\";i:300;s:9:\"mime-type\";s:9:\"image/png\";s:8:\"filesize\";i:3484;}s:9:\"thumbnail\";a:5:{s:4:\"file\";s:17:\"icon3-150x150.png\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:9:\"image/png\";s:8:\"filesize\";i:1833;}s:12:\"medium_large\";a:5:{s:4:\"file\";s:17:\"icon3-768x768.png\";s:5:\"width\";i:768;s:6:\"height\";i:768;s:9:\"mime-type\";s:9:\"image/png\";s:8:\"filesize\";i:10436;}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}');
INSERT INTO `wp_79e54b1ec2_postmeta` VALUES ('72','27','_elementor_source_image_hash','c4970684b789c6f744ccfee7462d92f806520da0');
INSERT INTO `wp_79e54b1ec2_postmeta` VALUES ('73','28','_wp_attached_file','2025/10/electrician-worker-at-work-on-an-electrical-panel-FAFZ5P3.jpg');
INSERT INTO `wp_79e54b1ec2_postmeta` VALUES ('74','28','_wp_attachment_metadata','a:6:{s:5:\"width\";i:2100;s:6:\"height\";i:1400;s:4:\"file\";s:69:\"2025/10/electrician-worker-at-work-on-an-electrical-panel-FAFZ5P3.jpg\";s:8:\"filesize\";i:202994;s:5:\"sizes\";a:6:{s:6:\"medium\";a:5:{s:4:\"file\";s:69:\"electrician-worker-at-work-on-an-electrical-panel-FAFZ5P3-300x200.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:200;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:26515;}s:5:\"large\";a:5:{s:4:\"file\";s:70:\"electrician-worker-at-work-on-an-electrical-panel-FAFZ5P3-1024x683.jpg\";s:5:\"width\";i:1024;s:6:\"height\";i:683;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:93619;}s:9:\"thumbnail\";a:5:{s:4:\"file\";s:69:\"electrician-worker-at-work-on-an-electrical-panel-FAFZ5P3-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:21543;}s:12:\"medium_large\";a:5:{s:4:\"file\";s:69:\"electrician-worker-at-work-on-an-electrical-panel-FAFZ5P3-768x512.jpg\";s:5:\"width\";i:768;s:6:\"height\";i:512;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:61034;}s:9:\"1536x1536\";a:5:{s:4:\"file\";s:71:\"electrician-worker-at-work-on-an-electrical-panel-FAFZ5P3-1536x1024.jpg\";s:5:\"width\";i:1536;s:6:\"height\";i:1024;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:184073;}s:9:\"2048x2048\";a:5:{s:4:\"file\";s:71:\"electrician-worker-at-work-on-an-electrical-panel-FAFZ5P3-2048x1365.jpg\";s:5:\"width\";i:2048;s:6:\"height\";i:1365;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:297959;}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:50:\"Electrician worker at work on an electrical panel.\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:49:\"Electrician worker at work on an electrical panel\";s:11:\"orientation\";s:1:\"1\";s:8:\"keywords\";a:50:{i:0;s:10:\"background\";i:1;s:4:\"hand\";i:2;s:6:\"person\";i:3;s:5:\"house\";i:4;s:3:\"man\";i:5;s:10:\"technology\";i:6;s:12:\"construction\";i:7;s:11:\"electrician\";i:8;s:8:\"electric\";i:9;s:6:\"worker\";i:10;s:10:\"technician\";i:11;s:11:\"switchboard\";i:12;s:11:\"electricity\";i:13;s:8:\"industry\";i:14;s:9:\"equipment\";i:15;s:8:\"engineer\";i:16;s:4:\"work\";i:17;s:10:\"electrical\";i:18;s:5:\"power\";i:19;s:12:\"professional\";i:20;s:5:\"cable\";i:21;s:10:\"protection\";i:22;s:10:\"occupation\";i:23;s:12:\"installation\";i:24;s:11:\"maintenance\";i:25;s:10:\"installing\";i:26;s:6:\"energy\";i:27;s:6:\"switch\";i:28;s:5:\"panel\";i:29;s:7:\"circuit\";i:30;s:7:\"cabinet\";i:31;s:3:\"fix\";i:32;s:6:\"repair\";i:33;s:8:\"checking\";i:34;s:5:\"adult\";i:35;s:10:\"enterprise\";i:36;s:10:\"industrial\";i:37;s:10:\"electronic\";i:38;s:4:\"fuse\";i:39;s:11:\"screwdriver\";i:40;s:8:\"handsome\";i:41;s:4:\"wire\";i:42;s:10:\"inspecting\";i:43;s:14:\"electric panel\";i:44;s:9:\"caucasian\";i:45;s:7:\"builder\";i:46;s:4:\"male\";i:47;s:10:\"fuse board\";i:48;s:3:\"job\";i:49;s:7:\"breaker\";}}}');
INSERT INTO `wp_79e54b1ec2_postmeta` VALUES ('75','28','_elementor_source_image_hash','1ae6178897743ea84766a19d38274b4ccfebfea0');
INSERT INTO `wp_79e54b1ec2_postmeta` VALUES ('76','29','_wp_attached_file','2025/10/icon4.png');
INSERT INTO `wp_79e54b1ec2_postmeta` VALUES ('77','29','_wp_attachment_metadata','a:6:{s:5:\"width\";i:1000;s:6:\"height\";i:1001;s:4:\"file\";s:17:\"2025/10/icon4.png\";s:8:\"filesize\";i:14932;s:5:\"sizes\";a:3:{s:6:\"medium\";a:5:{s:4:\"file\";s:17:\"icon4-300x300.png\";s:5:\"width\";i:300;s:6:\"height\";i:300;s:9:\"mime-type\";s:9:\"image/png\";s:8:\"filesize\";i:2224;}s:9:\"thumbnail\";a:5:{s:4:\"file\";s:17:\"icon4-150x150.png\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:9:\"image/png\";s:8:\"filesize\";i:1929;}s:12:\"medium_large\";a:5:{s:4:\"file\";s:17:\"icon4-768x769.png\";s:5:\"width\";i:768;s:6:\"height\";i:769;s:9:\"mime-type\";s:9:\"image/png\";s:8:\"filesize\";i:5986;}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}');
INSERT INTO `wp_79e54b1ec2_postmeta` VALUES ('78','29','_elementor_source_image_hash','2afddee45000520c809345f0405c84f17fe890a7');
INSERT INTO `wp_79e54b1ec2_postmeta` VALUES ('79','30','_wp_attached_file','2025/10/technician-engineer-holding-robot-controller-check-XFCE4M4.jpg');
INSERT INTO `wp_79e54b1ec2_postmeta` VALUES ('80','30','_wp_attachment_metadata','a:6:{s:5:\"width\";i:1800;s:6:\"height\";i:1200;s:4:\"file\";s:70:\"2025/10/technician-engineer-holding-robot-controller-check-XFCE4M4.jpg\";s:8:\"filesize\";i:252024;s:5:\"sizes\";a:5:{s:6:\"medium\";a:5:{s:4:\"file\";s:70:\"technician-engineer-holding-robot-controller-check-XFCE4M4-300x200.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:200;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:50443;}s:5:\"large\";a:5:{s:4:\"file\";s:71:\"technician-engineer-holding-robot-controller-check-XFCE4M4-1024x683.jpg\";s:5:\"width\";i:1024;s:6:\"height\";i:683;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:165500;}s:9:\"thumbnail\";a:5:{s:4:\"file\";s:70:\"technician-engineer-holding-robot-controller-check-XFCE4M4-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:39821;}s:12:\"medium_large\";a:5:{s:4:\"file\";s:70:\"technician-engineer-holding-robot-controller-check-XFCE4M4-768x512.jpg\";s:5:\"width\";i:768;s:6:\"height\";i:512;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:116909;}s:9:\"1536x1536\";a:5:{s:4:\"file\";s:72:\"technician-engineer-holding-robot-controller-check-XFCE4M4-1536x1024.jpg\";s:5:\"width\";i:1536;s:6:\"height\";i:1024;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:278187;}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:3:\"1.8\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:9:\"NIKON Z 9\";s:7:\"caption\";s:166:\"Technician engineer holding robot controller checking and repairing automatic robotic machine at industrial factory, Worker working with robotic arm system in factory\";s:17:\"created_timestamp\";s:10:\"1673231880\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:2:\"50\";s:3:\"iso\";s:4:\"1800\";s:13:\"shutter_speed\";s:8:\"0.003125\";s:5:\"title\";s:79:\"Technician engineer holding robot controller checking automatic robotic machine\";s:11:\"orientation\";s:1:\"1\";s:8:\"keywords\";a:50:{i:0;s:8:\"engineer\";i:1;s:8:\"industry\";i:2;s:10:\"technology\";i:3;s:7:\"factory\";i:4;s:10:\"production\";i:5;s:10:\"technician\";i:6;s:7:\"manager\";i:7;s:7:\"machine\";i:8;s:12:\"construction\";i:9;s:11:\"engineering\";i:10;s:4:\"work\";i:11;s:11:\"development\";i:12;s:9:\"warehouse\";i:13;s:8:\"facility\";i:14;s:6:\"safety\";i:15;s:7:\"process\";i:16;s:11:\"manufacture\";i:17;s:6:\"system\";i:18;s:12:\"service team\";i:19;s:15:\"welding process\";i:20;s:13:\"smart factory\";i:21;s:12:\"supply chain\";i:22;s:9:\"metalwork\";i:23;s:6:\"modern\";i:24;s:8:\"business\";i:25;s:9:\"machinery\";i:26;s:8:\"computer\";i:27;s:6:\"people\";i:28;s:8:\"software\";i:29;s:7:\"monitor\";i:30;s:8:\"teamwork\";i:31;s:11:\"electronics\";i:32;s:10:\"mechanical\";i:33;s:11:\"maintenance\";i:34;s:9:\"operation\";i:35;s:9:\"automated\";i:36;s:10:\"innovation\";i:37;s:9:\"equipment\";i:38;s:13:\"manufacturing\";i:39;s:10:\"discussion\";i:40;s:7:\"control\";i:41;s:10:\"automation\";i:42;s:5:\"metal\";i:43;s:11:\"controlling\";i:44;s:12:\"professional\";i:45;s:19:\"industrial engineer\";i:46;s:6:\"worker\";i:47;s:5:\"plant\";i:48;s:6:\"engine\";i:49;s:7:\"hardhat\";}}}');
INSERT INTO `wp_79e54b1ec2_postmeta` VALUES ('81','30','_elementor_source_image_hash','15042ff4ef8d8c003b97e7c38986667a1243a53d');
INSERT INTO `wp_79e54b1ec2_postmeta` VALUES ('82','31','_wp_attached_file','2025/10/icon5.png');
INSERT INTO `wp_79e54b1ec2_postmeta` VALUES ('83','31','_wp_attachment_metadata','a:6:{s:5:\"width\";i:1000;s:6:\"height\";i:1001;s:4:\"file\";s:17:\"2025/10/icon5.png\";s:8:\"filesize\";i:29211;s:5:\"sizes\";a:3:{s:6:\"medium\";a:5:{s:4:\"file\";s:17:\"icon5-300x300.png\";s:5:\"width\";i:300;s:6:\"height\";i:300;s:9:\"mime-type\";s:9:\"image/png\";s:8:\"filesize\";i:4150;}s:9:\"thumbnail\";a:5:{s:4:\"file\";s:17:\"icon5-150x150.png\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:9:\"image/png\";s:8:\"filesize\";i:2128;}s:12:\"medium_large\";a:5:{s:4:\"file\";s:17:\"icon5-768x769.png\";s:5:\"width\";i:768;s:6:\"height\";i:769;s:9:\"mime-type\";s:9:\"image/png\";s:8:\"filesize\";i:12142;}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}');
INSERT INTO `wp_79e54b1ec2_postmeta` VALUES ('84','31','_elementor_source_image_hash','0d13a4c31285bad97e37f90e92520d88e947fc68');
INSERT INTO `wp_79e54b1ec2_postmeta` VALUES ('85','32','_wp_attached_file','2025/10/close-up-of-an-engineer-repairing-an-electrical-sy-SWKE5HU.jpg');
INSERT INTO `wp_79e54b1ec2_postmeta` VALUES ('86','32','_wp_attachment_metadata','a:6:{s:5:\"width\";i:1800;s:6:\"height\";i:1200;s:4:\"file\";s:70:\"2025/10/close-up-of-an-engineer-repairing-an-electrical-sy-SWKE5HU.jpg\";s:8:\"filesize\";i:244337;s:5:\"sizes\";a:5:{s:6:\"medium\";a:5:{s:4:\"file\";s:70:\"close-up-of-an-engineer-repairing-an-electrical-sy-SWKE5HU-300x200.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:200;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:47493;}s:5:\"large\";a:5:{s:4:\"file\";s:71:\"close-up-of-an-engineer-repairing-an-electrical-sy-SWKE5HU-1024x683.jpg\";s:5:\"width\";i:1024;s:6:\"height\";i:683;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:155081;}s:9:\"thumbnail\";a:5:{s:4:\"file\";s:70:\"close-up-of-an-engineer-repairing-an-electrical-sy-SWKE5HU-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:38984;}s:12:\"medium_large\";a:5:{s:4:\"file\";s:70:\"close-up-of-an-engineer-repairing-an-electrical-sy-SWKE5HU-768x512.jpg\";s:5:\"width\";i:768;s:6:\"height\";i:512;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:108479;}s:9:\"1536x1536\";a:5:{s:4:\"file\";s:72:\"close-up-of-an-engineer-repairing-an-electrical-sy-SWKE5HU-1536x1024.jpg\";s:5:\"width\";i:1536;s:6:\"height\";i:1024;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:263688;}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:3:\"2.8\";s:6:\"credit\";s:10:\"Unai Huizi\";s:6:\"camera\";s:8:\"ILCE-7M4\";s:7:\"caption\";s:88:\"Close-up of an engineer repairing an electrical system panel using a measurement machine\";s:17:\"created_timestamp\";s:10:\"1702905103\";s:9:\"copyright\";s:20:\"unaihuiziphotography\";s:12:\"focal_length\";s:2:\"24\";s:3:\"iso\";s:4:\"1000\";s:13:\"shutter_speed\";s:5:\"0.008\";s:5:\"title\";s:60:\"Close-up of an engineer repairing an electrical system panel\";s:11:\"orientation\";s:1:\"1\";s:8:\"keywords\";a:50:{i:0;s:8:\"close-up\";i:1;s:8:\"engineer\";i:2;s:9:\"repairing\";i:3;s:10:\"electrical\";i:4;s:6:\"system\";i:5;s:5:\"panel\";i:6;s:11:\"measurement\";i:7;s:7:\"machine\";i:8;s:11:\"maintenance\";i:9;s:10:\"technician\";i:10;s:9:\"diagnosis\";i:11;s:9:\"precision\";i:12;s:5:\"tools\";i:13;s:9:\"expertise\";i:14;s:9:\"equipment\";i:15;s:6:\"people\";i:16;s:10:\"technology\";i:17;s:3:\"cnc\";i:18;s:7:\"uniform\";i:19;s:6:\"fabric\";i:20;s:7:\"service\";i:21;s:23:\"artificial intelligence\";i:22;s:12:\"machine part\";i:23;s:22:\"mechanical engineering\";i:24;s:10:\"occupation\";i:25;s:9:\"work tool\";i:26;s:7:\"factory\";i:27;s:8:\"teamwork\";i:28;s:10:\"efficiency\";i:29;s:6:\"safety\";i:30;s:24:\"manufacturing occupation\";i:31;s:23:\"manufacturing machinery\";i:32;s:15:\"production line\";i:33;s:12:\"control room\";i:34;s:9:\"examining\";i:35;s:11:\"development\";i:36;s:10:\"protection\";i:37;s:28:\"computer-aided manufacturing\";i:38;s:10:\"installing\";i:39;s:20:\"system configuration\";i:40;s:8:\"mechanic\";i:41;s:11:\"improvement\";i:42;s:13:\"manufacturing\";i:43;s:19:\"unit of measurement\";i:44;s:9:\"operating\";i:45;s:13:\"manual worker\";i:46;s:7:\"control\";i:47;s:18:\"maintenance worker\";i:48;s:10:\"innovation\";i:49;s:13:\"control panel\";}}}');
INSERT INTO `wp_79e54b1ec2_postmeta` VALUES ('87','32','_elementor_source_image_hash','50cd272ceccf3154317bf965c728078f83658eb3');
INSERT INTO `wp_79e54b1ec2_postmeta` VALUES ('88','33','_wp_attached_file','2025/10/icon6.png');
INSERT INTO `wp_79e54b1ec2_postmeta` VALUES ('89','33','_wp_attachment_metadata','a:6:{s:5:\"width\";i:1001;s:6:\"height\";i:1001;s:4:\"file\";s:17:\"2025/10/icon6.png\";s:8:\"filesize\";i:16240;s:5:\"sizes\";a:3:{s:6:\"medium\";a:5:{s:4:\"file\";s:17:\"icon6-300x300.png\";s:5:\"width\";i:300;s:6:\"height\";i:300;s:9:\"mime-type\";s:9:\"image/png\";s:8:\"filesize\";i:2317;}s:9:\"thumbnail\";a:5:{s:4:\"file\";s:17:\"icon6-150x150.png\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:9:\"image/png\";s:8:\"filesize\";i:2025;}s:12:\"medium_large\";a:5:{s:4:\"file\";s:17:\"icon6-768x768.png\";s:5:\"width\";i:768;s:6:\"height\";i:768;s:9:\"mime-type\";s:9:\"image/png\";s:8:\"filesize\";i:6326;}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}');
INSERT INTO `wp_79e54b1ec2_postmeta` VALUES ('90','33','_elementor_source_image_hash','da8676f56faa3e3cd95c54c2af17c65034fe9605');
INSERT INTO `wp_79e54b1ec2_postmeta` VALUES ('91','34','_wp_attached_file','2025/10/a-group-of-construction-workers-are-standing-aroun-VLHZ2D5.jpg');
INSERT INTO `wp_79e54b1ec2_postmeta` VALUES ('92','34','_wp_attachment_metadata','a:6:{s:5:\"width\";i:2100;s:6:\"height\";i:1400;s:4:\"file\";s:70:\"2025/10/a-group-of-construction-workers-are-standing-aroun-VLHZ2D5.jpg\";s:8:\"filesize\";i:174496;s:5:\"sizes\";a:6:{s:6:\"medium\";a:5:{s:4:\"file\";s:70:\"a-group-of-construction-workers-are-standing-aroun-VLHZ2D5-300x200.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:200;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:34252;}s:5:\"large\";a:5:{s:4:\"file\";s:71:\"a-group-of-construction-workers-are-standing-aroun-VLHZ2D5-1024x683.jpg\";s:5:\"width\";i:1024;s:6:\"height\";i:683;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:99382;}s:9:\"thumbnail\";a:5:{s:4:\"file\";s:70:\"a-group-of-construction-workers-are-standing-aroun-VLHZ2D5-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:28709;}s:12:\"medium_large\";a:5:{s:4:\"file\";s:70:\"a-group-of-construction-workers-are-standing-aroun-VLHZ2D5-768x512.jpg\";s:5:\"width\";i:768;s:6:\"height\";i:512;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:71433;}s:9:\"1536x1536\";a:5:{s:4:\"file\";s:72:\"a-group-of-construction-workers-are-standing-aroun-VLHZ2D5-1536x1024.jpg\";s:5:\"width\";i:1536;s:6:\"height\";i:1024;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:165577;}s:9:\"2048x2048\";a:5:{s:4:\"file\";s:72:\"a-group-of-construction-workers-are-standing-aroun-VLHZ2D5-2048x1365.jpg\";s:5:\"width\";i:2048;s:6:\"height\";i:1365;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:243068;}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"4\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:9:\"ILCE-7RM3\";s:7:\"caption\";s:177:\"A group of construction workers are standing around a solar panel. One of the workers is holding a clipboard and another is holding a tablet. The workers are wearing safety gear\";s:17:\"created_timestamp\";s:10:\"1681202989\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:2:\"70\";s:3:\"iso\";s:3:\"100\";s:13:\"shutter_speed\";s:6:\"0.0025\";s:5:\"title\";s:65:\"A group of construction workers are standing around a solar panel\";s:11:\"orientation\";s:1:\"1\";s:8:\"keywords\";a:50:{i:0;s:8:\"engineer\";i:1;s:8:\"business\";i:2;s:12:\"construction\";i:3;s:10:\"technology\";i:4;s:8:\"outdoors\";i:5;s:9:\"equipment\";i:6;s:6:\"safety\";i:7;s:12:\"professional\";i:8;s:5:\"power\";i:9;s:10:\"technician\";i:10;s:6:\"person\";i:11;s:9:\"expertise\";i:12;s:3:\"men\";i:13;s:11:\"electricity\";i:14;s:6:\"energy\";i:15;s:10:\"industrial\";i:16;s:7:\"project\";i:17;s:7:\"meeting\";i:18;s:4:\"site\";i:19;s:5:\"solar\";i:20;s:10:\"occupation\";i:21;s:6:\"manual\";i:22;s:8:\"teamwork\";i:23;s:5:\"plant\";i:24;s:9:\"architect\";i:25;s:6:\"worker\";i:26;s:8:\"building\";i:27;s:6:\"helmet\";i:28;s:11:\"maintenance\";i:29;s:5:\"sunny\";i:30;s:5:\"green\";i:31;s:5:\"check\";i:32;s:4:\"male\";i:33;s:9:\"inspector\";i:34;s:11:\"electrician\";i:35;s:10:\"multimeter\";i:36;s:7:\"voltage\";i:37;s:11:\"measurement\";i:38;s:4:\"tool\";i:39;s:4:\"team\";i:40;s:10:\"instrument\";i:41;s:7:\"working\";i:42;s:9:\"blueprint\";i:43;s:12:\"architecture\";i:44;s:7:\"builder\";i:45;s:6:\"repair\";i:46;s:13:\"environmental\";i:47;s:7:\"foreman\";i:48;s:7:\"factory\";i:49;s:5:\"group\";}}}');
INSERT INTO `wp_79e54b1ec2_postmeta` VALUES ('93','34','_elementor_source_image_hash','52deb92df9e676c204017f53384b61f05a4431ae');
INSERT INTO `wp_79e54b1ec2_postmeta` VALUES ('94','35','_wp_attached_file','2025/10/photovoltaic-panel-engineer-with-energy-measureme-6B6GLMY.jpg');
INSERT INTO `wp_79e54b1ec2_postmeta` VALUES ('95','35','_wp_attachment_metadata','a:6:{s:5:\"width\";i:2100;s:6:\"height\";i:1400;s:4:\"file\";s:69:\"2025/10/photovoltaic-panel-engineer-with-energy-measureme-6B6GLMY.jpg\";s:8:\"filesize\";i:182492;s:5:\"sizes\";a:6:{s:6:\"medium\";a:5:{s:4:\"file\";s:69:\"photovoltaic-panel-engineer-with-energy-measureme-6B6GLMY-300x200.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:200;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:27842;}s:5:\"large\";a:5:{s:4:\"file\";s:70:\"photovoltaic-panel-engineer-with-energy-measureme-6B6GLMY-1024x683.jpg\";s:5:\"width\";i:1024;s:6:\"height\";i:683;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:101330;}s:9:\"thumbnail\";a:5:{s:4:\"file\";s:69:\"photovoltaic-panel-engineer-with-energy-measureme-6B6GLMY-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:20510;}s:12:\"medium_large\";a:5:{s:4:\"file\";s:69:\"photovoltaic-panel-engineer-with-energy-measureme-6B6GLMY-768x512.jpg\";s:5:\"width\";i:768;s:6:\"height\";i:512;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:70380;}s:9:\"1536x1536\";a:5:{s:4:\"file\";s:71:\"photovoltaic-panel-engineer-with-energy-measureme-6B6GLMY-1536x1024.jpg\";s:5:\"width\";i:1536;s:6:\"height\";i:1024;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:172494;}s:9:\"2048x2048\";a:5:{s:4:\"file\";s:71:\"photovoltaic-panel-engineer-with-energy-measureme-6B6GLMY-2048x1365.jpg\";s:5:\"width\";i:2048;s:6:\"height\";i:1365;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:256426;}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:16:\"Chuanchai Pundej\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:186:\"Engineer hand is installing and checking an operation of sun and cleanliness of photovoltaic solar panels, Engineer with energy measurement tool photovoltaic modules for renewable energy\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:16:\"CHUANCHAI PUNDEJ\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:89:\"photovoltaic panel, Engineer with energy measurement tool photovoltaic modules for energy\";s:11:\"orientation\";s:1:\"1\";s:8:\"keywords\";a:50:{i:0;s:11:\"solar plant\";i:1;s:12:\"power supply\";i:2;s:21:\"sustainable resources\";i:3;s:18:\"photovoltaic cells\";i:4;s:13:\"power station\";i:5;s:6:\"sunset\";i:6;s:12:\"solar panels\";i:7;s:9:\"installer\";i:8;s:16:\"renewable energy\";i:9;s:11:\"solar panel\";i:10;s:10:\"ecological\";i:11;s:10:\"installing\";i:12;s:11:\"engineering\";i:13;s:7:\"station\";i:14;s:11:\"electrician\";i:15;s:5:\"plant\";i:16;s:12:\"construction\";i:17;s:7:\"service\";i:18;s:12:\"solar energy\";i:19;s:3:\"eco\";i:20;s:10:\"technology\";i:21;s:5:\"power\";i:22;s:11:\"electricity\";i:23;s:5:\"panel\";i:24;s:12:\"installation\";i:25;s:6:\"energy\";i:26;s:8:\"engineer\";i:27;s:12:\"photovoltaic\";i:28;s:5:\"solar\";i:29;s:11:\"environment\";i:30;s:11:\"alternative\";i:31;s:4:\"cell\";i:32;s:8:\"industry\";i:33;s:8:\"electric\";i:34;s:7:\"ecology\";i:35;s:3:\"sun\";i:36;s:10:\"technician\";i:37;s:9:\"renewable\";i:38;s:6:\"system\";i:39;s:6:\"worker\";i:40;s:13:\"environmental\";i:41;s:10:\"innovation\";i:42;s:10:\"electrical\";i:43;s:3:\"sky\";i:44;s:11:\"maintenance\";i:45;s:8:\"business\";i:46;s:4:\"roof\";i:47;s:5:\"green\";i:48;s:7:\"rooftop\";i:49;s:8:\"sunlight\";}}}');
INSERT INTO `wp_79e54b1ec2_postmeta` VALUES ('96','35','_elementor_source_image_hash','9e6f30b650273a17aa31307d5b7650ec59695287');
INSERT INTO `wp_79e54b1ec2_postmeta` VALUES ('97','36','_wp_attached_file','2025/10/two-engineers-collaborating-on-project-design-on-s-5XBDVHY.jpg');
INSERT INTO `wp_79e54b1ec2_postmeta` VALUES ('98','36','_wp_attachment_metadata','a:6:{s:5:\"width\";i:2100;s:6:\"height\";i:1400;s:4:\"file\";s:70:\"2025/10/two-engineers-collaborating-on-project-design-on-s-5XBDVHY.jpg\";s:8:\"filesize\";i:193576;s:5:\"sizes\";a:6:{s:6:\"medium\";a:5:{s:4:\"file\";s:70:\"two-engineers-collaborating-on-project-design-on-s-5XBDVHY-300x200.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:200;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:39162;}s:5:\"large\";a:5:{s:4:\"file\";s:71:\"two-engineers-collaborating-on-project-design-on-s-5XBDVHY-1024x683.jpg\";s:5:\"width\";i:1024;s:6:\"height\";i:683;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:110339;}s:9:\"thumbnail\";a:5:{s:4:\"file\";s:70:\"two-engineers-collaborating-on-project-design-on-s-5XBDVHY-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:32869;}s:12:\"medium_large\";a:5:{s:4:\"file\";s:70:\"two-engineers-collaborating-on-project-design-on-s-5XBDVHY-768x512.jpg\";s:5:\"width\";i:768;s:6:\"height\";i:512;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:80122;}s:9:\"1536x1536\";a:5:{s:4:\"file\";s:72:\"two-engineers-collaborating-on-project-design-on-s-5XBDVHY-1536x1024.jpg\";s:5:\"width\";i:1536;s:6:\"height\";i:1024;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:182415;}s:9:\"2048x2048\";a:5:{s:4:\"file\";s:72:\"two-engineers-collaborating-on-project-design-on-s-5XBDVHY-2048x1365.jpg\";s:5:\"width\";i:2048;s:6:\"height\";i:1365;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:266366;}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"4\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:11:\"Canon EOS R\";s:7:\"caption\";s:53:\"Two engineers collaborating on project design on site\";s:17:\"created_timestamp\";s:10:\"1614382265\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:2:\"35\";s:3:\"iso\";s:3:\"100\";s:13:\"shutter_speed\";s:5:\"0.004\";s:5:\"title\";s:53:\"Two engineers collaborating on project design on site\";s:11:\"orientation\";s:1:\"1\";s:8:\"keywords\";a:1:{i:0;s:64:\"engineer, asian, business, construction, teamwork, civil, discus\";}}}');
INSERT INTO `wp_79e54b1ec2_postmeta` VALUES ('99','36','_elementor_source_image_hash','2faf2e165518b4507b40d9b8a6f6bd4b5ad0fd85');
INSERT INTO `wp_79e54b1ec2_postmeta` VALUES ('100','37','_wp_attached_file','2025/10/engineers-shaking-hands-against-high-voltage-tower-D7R7JUN.jpg');
INSERT INTO `wp_79e54b1ec2_postmeta` VALUES ('101','37','_wp_attachment_metadata','a:6:{s:5:\"width\";i:2100;s:6:\"height\";i:1400;s:4:\"file\";s:70:\"2025/10/engineers-shaking-hands-against-high-voltage-tower-D7R7JUN.jpg\";s:8:\"filesize\";i:237294;s:5:\"sizes\";a:6:{s:6:\"medium\";a:5:{s:4:\"file\";s:70:\"engineers-shaking-hands-against-high-voltage-tower-D7R7JUN-300x200.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:200;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:29346;}s:5:\"large\";a:5:{s:4:\"file\";s:71:\"engineers-shaking-hands-against-high-voltage-tower-D7R7JUN-1024x683.jpg\";s:5:\"width\";i:1024;s:6:\"height\";i:683;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:109555;}s:9:\"thumbnail\";a:5:{s:4:\"file\";s:70:\"engineers-shaking-hands-against-high-voltage-tower-D7R7JUN-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:21320;}s:12:\"medium_large\";a:5:{s:4:\"file\";s:70:\"engineers-shaking-hands-against-high-voltage-tower-D7R7JUN-768x512.jpg\";s:5:\"width\";i:768;s:6:\"height\";i:512;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:73243;}s:9:\"1536x1536\";a:5:{s:4:\"file\";s:72:\"engineers-shaking-hands-against-high-voltage-tower-D7R7JUN-1536x1024.jpg\";s:5:\"width\";i:1536;s:6:\"height\";i:1024;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:203052;}s:9:\"2048x2048\";a:5:{s:4:\"file\";s:72:\"engineers-shaking-hands-against-high-voltage-tower-D7R7JUN-2048x1365.jpg\";s:5:\"width\";i:2048;s:6:\"height\";i:1365;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:315511;}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:131:\"Low angle side view of crop anonymous male engineers shaking hands while standing against modern electric high voltage construction\";s:17:\"created_timestamp\";s:10:\"1603370992\";s:9:\"copyright\";s:14:\"MUSUC ALEXANDR\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:50:\"Engineers shaking hands against high voltage tower\";s:11:\"orientation\";s:1:\"1\";s:8:\"keywords\";a:50:{i:0;s:9:\"anonymous\";i:1;s:4:\"blur\";i:2;s:9:\"colleague\";i:3;s:12:\"construction\";i:4;s:10:\"contractor\";i:5;s:8:\"coworker\";i:6;s:4:\"crop\";i:7;s:11:\"development\";i:8;s:8:\"electric\";i:9;s:11:\"electrician\";i:10;s:6:\"energy\";i:11;s:8:\"engineer\";i:12;s:11:\"engineering\";i:13;s:8:\"faceless\";i:14;s:8:\"facility\";i:15;s:7:\"foreman\";i:16;s:10:\"from below\";i:17;s:7:\"gesture\";i:18;s:8:\"greeting\";i:19;s:4:\"hand\";i:20;s:9:\"handshake\";i:21;s:10:\"industrial\";i:22;s:8:\"industry\";i:23;s:9:\"inspector\";i:24;s:3:\"job\";i:25;s:9:\"low angle\";i:26;s:11:\"maintenance\";i:27;s:4:\"male\";i:28;s:3:\"men\";i:29;s:10:\"occupation\";i:30;s:8:\"outdoors\";i:31;s:7:\"partner\";i:32;s:4:\"pole\";i:33;s:5:\"power\";i:34;s:10:\"profession\";i:35;s:12:\"professional\";i:36;s:15:\"selective focus\";i:37;s:5:\"shake\";i:38;s:9:\"side view\";i:39;s:7:\"success\";i:40;s:6:\"supply\";i:41;s:10:\"technician\";i:42;s:10:\"technology\";i:43;s:8:\"together\";i:44;s:5:\"tower\";i:45;s:14:\"unrecognizable\";i:46;s:7:\"voltage\";i:47;s:4:\"work\";i:48;s:6:\"worker\";i:49;s:7:\"workman\";}}}');
INSERT INTO `wp_79e54b1ec2_postmeta` VALUES ('102','37','_elementor_source_image_hash','5babaf77e41eec47a12f1dfd2fad554e89728e85');
INSERT INTO `wp_79e54b1ec2_postmeta` VALUES ('103','38','_wp_attached_file','2025/10/african-american-technician-with-digital-tablet-po-LB2L2HB.jpg');
INSERT INTO `wp_79e54b1ec2_postmeta` VALUES ('104','38','_wp_attachment_metadata','a:6:{s:5:\"width\";i:2100;s:6:\"height\";i:1400;s:4:\"file\";s:70:\"2025/10/african-american-technician-with-digital-tablet-po-LB2L2HB.jpg\";s:8:\"filesize\";i:208472;s:5:\"sizes\";a:6:{s:6:\"medium\";a:5:{s:4:\"file\";s:70:\"african-american-technician-with-digital-tablet-po-LB2L2HB-300x200.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:200;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:36774;}s:5:\"large\";a:5:{s:4:\"file\";s:71:\"african-american-technician-with-digital-tablet-po-LB2L2HB-1024x683.jpg\";s:5:\"width\";i:1024;s:6:\"height\";i:683;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:117143;}s:9:\"thumbnail\";a:5:{s:4:\"file\";s:70:\"african-american-technician-with-digital-tablet-po-LB2L2HB-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:29559;}s:12:\"medium_large\";a:5:{s:4:\"file\";s:70:\"african-american-technician-with-digital-tablet-po-LB2L2HB-768x512.jpg\";s:5:\"width\";i:768;s:6:\"height\";i:512;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:82531;}s:9:\"1536x1536\";a:5:{s:4:\"file\";s:72:\"african-american-technician-with-digital-tablet-po-LB2L2HB-1536x1024.jpg\";s:5:\"width\";i:1536;s:6:\"height\";i:1024;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:197856;}s:9:\"2048x2048\";a:5:{s:4:\"file\";s:72:\"african-american-technician-with-digital-tablet-po-LB2L2HB-2048x1365.jpg\";s:5:\"width\";i:2048;s:6:\"height\";i:1365;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:292693;}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"4\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:10:\"NIKON D810\";s:7:\"caption\";s:100:\"african american technician with digital tablet pointing at switchboard while working in data center\";s:17:\"created_timestamp\";s:10:\"1631721759\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:2:\"50\";s:3:\"iso\";s:3:\"200\";s:13:\"shutter_speed\";s:7:\"0.00625\";s:5:\"title\";s:64:\"african american technician with digital tablet pointing at swit\";s:11:\"orientation\";s:1:\"1\";s:8:\"keywords\";a:1:{i:0;s:64:\"administrators,african american,black man,buttons,caucasian,coll\";}}}');
INSERT INTO `wp_79e54b1ec2_postmeta` VALUES ('105','38','_elementor_source_image_hash','65c086f15cbdfdf89c5b303d5b867f83c6c2fe30');
INSERT INTO `wp_79e54b1ec2_postmeta` VALUES ('106','39','_wp_attached_file','2025/10/multi-ethnic-people-having-meeting-at-solar-statio-EMGZT89.jpg');
INSERT INTO `wp_79e54b1ec2_postmeta` VALUES ('107','39','_wp_attachment_metadata','a:6:{s:5:\"width\";i:2100;s:6:\"height\";i:1400;s:4:\"file\";s:70:\"2025/10/multi-ethnic-people-having-meeting-at-solar-statio-EMGZT89.jpg\";s:8:\"filesize\";i:201206;s:5:\"sizes\";a:6:{s:6:\"medium\";a:5:{s:4:\"file\";s:70:\"multi-ethnic-people-having-meeting-at-solar-statio-EMGZT89-300x200.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:200;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:33412;}s:5:\"large\";a:5:{s:4:\"file\";s:71:\"multi-ethnic-people-having-meeting-at-solar-statio-EMGZT89-1024x683.jpg\";s:5:\"width\";i:1024;s:6:\"height\";i:683;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:113049;}s:9:\"thumbnail\";a:5:{s:4:\"file\";s:70:\"multi-ethnic-people-having-meeting-at-solar-statio-EMGZT89-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:25882;}s:12:\"medium_large\";a:5:{s:4:\"file\";s:70:\"multi-ethnic-people-having-meeting-at-solar-statio-EMGZT89-768x512.jpg\";s:5:\"width\";i:768;s:6:\"height\";i:512;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:78922;}s:9:\"1536x1536\";a:5:{s:4:\"file\";s:72:\"multi-ethnic-people-having-meeting-at-solar-statio-EMGZT89-1536x1024.jpg\";s:5:\"width\";i:1536;s:6:\"height\";i:1024;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:194530;}s:9:\"2048x2048\";a:5:{s:4:\"file\";s:72:\"multi-ethnic-people-having-meeting-at-solar-statio-EMGZT89-2048x1365.jpg\";s:5:\"width\";i:2048;s:6:\"height\";i:1365;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:292216;}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:3:\"2.5\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:11:\"Canon EOS R\";s:7:\"caption\";s:182:\"Muslim woman in hijab and indian man in suit using laptop and clipboard during discuss at solar station. African american technician working with cables in transformer on background.\";s:17:\"created_timestamp\";s:10:\"1624993931\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:2:\"50\";s:3:\"iso\";s:3:\"250\";s:13:\"shutter_speed\";s:5:\"0.008\";s:5:\"title\";s:51:\"Multi ethnic people having meeting at solar station\";s:11:\"orientation\";s:1:\"1\";s:8:\"keywords\";a:44:{i:0;s:11:\"solar panel\";i:1;s:6:\"people\";i:2;s:11:\"multiracial\";i:3;s:5:\"cable\";i:4;s:3:\"box\";i:5;s:6:\"laptop\";i:6;s:9:\"clipboard\";i:7;s:11:\"electrician\";i:8;s:11:\"transformer\";i:9;s:11:\"maintenance\";i:10;s:7:\"control\";i:11;s:8:\"checking\";i:12;s:10:\"technician\";i:13;s:5:\"tools\";i:14;s:12:\"photovoltaic\";i:15;s:5:\"cells\";i:16;s:9:\"renewable\";i:17;s:3:\"men\";i:18;s:5:\"solar\";i:19;s:5:\"panel\";i:20;s:8:\"engineer\";i:21;s:8:\"analysis\";i:22;s:13:\"multicultural\";i:23;s:11:\"electricity\";i:24;s:6:\"indian\";i:25;s:10:\"inspection\";i:26;s:4:\"scan\";i:27;s:6:\"helmet\";i:28;s:6:\"muslim\";i:29;s:5:\"hijab\";i:30;s:11:\"alternative\";i:31;s:16:\"african american\";i:32;s:6:\"worker\";i:33;s:5:\"power\";i:34;s:8:\"computer\";i:35;s:5:\"woman\";i:36;s:8:\"standing\";i:37;s:16:\"renewable energy\";i:38;s:18:\"alternative energy\";i:39;s:11:\"businessman\";i:40;s:7:\"ecology\";i:41;s:6:\"energy\";i:42;s:10:\"technology\";i:43;s:8:\"outdoors\";}}}');
INSERT INTO `wp_79e54b1ec2_postmeta` VALUES ('108','39','_elementor_source_image_hash','cf1ae4647a95160ad11ffc9c00dc384814a4f962');
INSERT INTO `wp_79e54b1ec2_postmeta` VALUES ('109','40','_wp_attached_file','2025/10/portrait-of-a-beautiful-black-woman-with-afro-hair-4UDCEMW.jpg');
INSERT INTO `wp_79e54b1ec2_postmeta` VALUES ('110','40','_wp_attachment_metadata','a:6:{s:5:\"width\";i:1000;s:6:\"height\";i:1000;s:4:\"file\";s:70:\"2025/10/portrait-of-a-beautiful-black-woman-with-afro-hair-4UDCEMW.jpg\";s:8:\"filesize\";i:108078;s:5:\"sizes\";a:3:{s:6:\"medium\";a:5:{s:4:\"file\";s:70:\"portrait-of-a-beautiful-black-woman-with-afro-hair-4UDCEMW-300x300.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:300;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:26642;}s:9:\"thumbnail\";a:5:{s:4:\"file\";s:70:\"portrait-of-a-beautiful-black-woman-with-afro-hair-4UDCEMW-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:17294;}s:12:\"medium_large\";a:5:{s:4:\"file\";s:70:\"portrait-of-a-beautiful-black-woman-with-afro-hair-4UDCEMW-768x768.jpg\";s:5:\"width\";i:768;s:6:\"height\";i:768;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:85967;}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"1\";s:8:\"keywords\";a:0:{}}}');
INSERT INTO `wp_79e54b1ec2_postmeta` VALUES ('111','40','_elementor_source_image_hash','7a2a6c20d4359470e26096f8108e8377ef083653');
INSERT INTO `wp_79e54b1ec2_postmeta` VALUES ('112','41','_wp_attached_file','2025/10/logo_2.png');
INSERT INTO `wp_79e54b1ec2_postmeta` VALUES ('113','41','_wp_attachment_metadata','a:6:{s:5:\"width\";i:1000;s:6:\"height\";i:600;s:4:\"file\";s:18:\"2025/10/logo_2.png\";s:8:\"filesize\";i:18427;s:5:\"sizes\";a:3:{s:6:\"medium\";a:5:{s:4:\"file\";s:18:\"logo_2-300x180.png\";s:5:\"width\";i:300;s:6:\"height\";i:180;s:9:\"mime-type\";s:9:\"image/png\";s:8:\"filesize\";i:3382;}s:9:\"thumbnail\";a:5:{s:4:\"file\";s:18:\"logo_2-150x150.png\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:9:\"image/png\";s:8:\"filesize\";i:1933;}s:12:\"medium_large\";a:5:{s:4:\"file\";s:18:\"logo_2-768x461.png\";s:5:\"width\";i:768;s:6:\"height\";i:461;s:9:\"mime-type\";s:9:\"image/png\";s:8:\"filesize\";i:8992;}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}');
INSERT INTO `wp_79e54b1ec2_postmeta` VALUES ('114','41','_elementor_source_image_hash','5c78e71af5fe678cfb37fd0cfbfa326abfabbf0b');
INSERT INTO `wp_79e54b1ec2_postmeta` VALUES ('115','42','_wp_attached_file','2025/10/portrait-young-man-redhead-bearded-jack-russel-3XYLST8.jpg');
INSERT INTO `wp_79e54b1ec2_postmeta` VALUES ('116','42','_wp_attachment_metadata','a:6:{s:5:\"width\";i:1000;s:6:\"height\";i:1000;s:4:\"file\";s:66:\"2025/10/portrait-young-man-redhead-bearded-jack-russel-3XYLST8.jpg\";s:8:\"filesize\";i:120893;s:5:\"sizes\";a:3:{s:6:\"medium\";a:5:{s:4:\"file\";s:66:\"portrait-young-man-redhead-bearded-jack-russel-3XYLST8-300x300.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:300;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:39009;}s:9:\"thumbnail\";a:5:{s:4:\"file\";s:66:\"portrait-young-man-redhead-bearded-jack-russel-3XYLST8-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:28324;}s:12:\"medium_large\";a:5:{s:4:\"file\";s:66:\"portrait-young-man-redhead-bearded-jack-russel-3XYLST8-768x768.jpg\";s:5:\"width\";i:768;s:6:\"height\";i:768;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:97512;}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:3:\"2.8\";s:6:\"credit\";s:19:\"© Eugenio Marongiu\";s:6:\"camera\";s:10:\"NIKON D810\";s:7:\"caption\";s:46:\"Portrait young man redhead bearded jack russel\";s:17:\"created_timestamp\";s:10:\"1475685541\";s:9:\"copyright\";s:19:\"© Eugenio Marongiu\";s:12:\"focal_length\";s:2:\"85\";s:3:\"iso\";s:3:\"400\";s:13:\"shutter_speed\";s:5:\"0.002\";s:5:\"title\";s:46:\"Portrait young man redhead bearded jack russel\";s:11:\"orientation\";s:1:\"1\";s:8:\"keywords\";a:23:{i:0;s:8:\"portrait\";i:1;s:5:\"young\";i:2;s:3:\"man\";i:3;s:7:\"redhead\";i:4;s:7:\"bearded\";i:5;s:7:\"holding\";i:6;s:3:\"dog\";i:7;s:3:\"pet\";i:8;s:11:\"jack russel\";i:9;s:5:\"puppy\";i:10;s:9:\"companion\";i:11;s:19:\"caucasian ethnicity\";i:12;s:10:\"millennial\";i:13;s:8:\"headshot\";i:14;s:14:\"looking camera\";i:15;s:5:\"beard\";i:16;s:11:\"ginger head\";i:17;s:4:\"male\";i:18;s:11:\"young adult\";i:19;s:8:\"customer\";i:20;s:9:\"real life\";i:21;s:9:\"lifestyle\";i:22;s:12:\"authenticity\";}}}');
INSERT INTO `wp_79e54b1ec2_postmeta` VALUES ('117','42','_elementor_source_image_hash','af5fdeaf88e313cecd4284fa6958f4d581dc6ddd');
INSERT INTO `wp_79e54b1ec2_postmeta` VALUES ('118','43','_wp_attached_file','2025/10/logo_3.png');
INSERT INTO `wp_79e54b1ec2_postmeta` VALUES ('119','43','_wp_attachment_metadata','a:6:{s:5:\"width\";i:1000;s:6:\"height\";i:600;s:4:\"file\";s:18:\"2025/10/logo_3.png\";s:8:\"filesize\";i:13190;s:5:\"sizes\";a:3:{s:6:\"medium\";a:5:{s:4:\"file\";s:18:\"logo_3-300x180.png\";s:5:\"width\";i:300;s:6:\"height\";i:180;s:9:\"mime-type\";s:9:\"image/png\";s:8:\"filesize\";i:2400;}s:9:\"thumbnail\";a:5:{s:4:\"file\";s:18:\"logo_3-150x150.png\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:9:\"image/png\";s:8:\"filesize\";i:1916;}s:12:\"medium_large\";a:5:{s:4:\"file\";s:18:\"logo_3-768x461.png\";s:5:\"width\";i:768;s:6:\"height\";i:461;s:9:\"mime-type\";s:9:\"image/png\";s:8:\"filesize\";i:7383;}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}');
INSERT INTO `wp_79e54b1ec2_postmeta` VALUES ('120','43','_elementor_source_image_hash','0c9399d814067aa3cfcdb63062208ff253206186');
INSERT INTO `wp_79e54b1ec2_postmeta` VALUES ('121','44','_wp_attached_file','2025/10/portrait-of-young-sportive-woman-resting-outdoor-a-JXRPM8C.jpg');
INSERT INTO `wp_79e54b1ec2_postmeta` VALUES ('122','44','_wp_attachment_metadata','a:6:{s:5:\"width\";i:1000;s:6:\"height\";i:1000;s:4:\"file\";s:70:\"2025/10/portrait-of-young-sportive-woman-resting-outdoor-a-JXRPM8C.jpg\";s:8:\"filesize\";i:87320;s:5:\"sizes\";a:3:{s:6:\"medium\";a:5:{s:4:\"file\";s:70:\"portrait-of-young-sportive-woman-resting-outdoor-a-JXRPM8C-300x300.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:300;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:30873;}s:9:\"thumbnail\";a:5:{s:4:\"file\";s:70:\"portrait-of-young-sportive-woman-resting-outdoor-a-JXRPM8C-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:22771;}s:12:\"medium_large\";a:5:{s:4:\"file\";s:70:\"portrait-of-young-sportive-woman-resting-outdoor-a-JXRPM8C-768x768.jpg\";s:5:\"width\";i:768;s:6:\"height\";i:768;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:73482;}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:3:\"1.8\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:8:\"NIKON D5\";s:7:\"caption\";s:73:\"Portrait of young sportive woman resting outdoor in a city after running.\";s:17:\"created_timestamp\";s:10:\"1662477122\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:2:\"35\";s:3:\"iso\";s:3:\"200\";s:13:\"shutter_speed\";s:6:\"0.0002\";s:5:\"title\";s:64:\"Portrait of young sportive woman resting outdoor after city run.\";s:11:\"orientation\";s:1:\"1\";s:8:\"keywords\";a:47:{i:0;s:5:\"young\";i:1;s:5:\"woman\";i:2;s:10:\"stretching\";i:3;s:7:\"resting\";i:4;s:7:\"outdoor\";i:5;s:5:\"watch\";i:6;s:9:\"beautiful\";i:7;s:7:\"pensive\";i:8;s:13:\"contemplation\";i:9;s:4:\"city\";i:10;s:6:\"bridge\";i:11;s:9:\"city life\";i:12;s:3:\"run\";i:13;s:5:\"break\";i:14;s:4:\"rest\";i:15;s:6:\"runing\";i:16;s:7:\"helathy\";i:17;s:5:\"sport\";i:18;s:16:\"active lifestlye\";i:19;s:6:\"person\";i:20;s:7:\"fitness\";i:21;s:6:\"runner\";i:22;s:6:\"female\";i:23;s:7:\"healthy\";i:24;s:9:\"lifestyle\";i:25;s:3:\"fit\";i:26;s:6:\"jogger\";i:27;s:8:\"training\";i:28;s:6:\"active\";i:29;s:5:\"adult\";i:30;s:6:\"summer\";i:31;s:17:\"physical exercise\";i:32;s:7:\"athlete\";i:33;s:7:\"jogging\";i:34;s:7:\"stretch\";i:35;s:6:\"health\";i:36;s:3:\"leg\";i:37;s:7:\"morning\";i:38;s:5:\"urban\";i:39;s:4:\"girl\";i:40;s:8:\"athletic\";i:41;s:7:\"balance\";i:42;s:6:\"effort\";i:43;s:7:\"outside\";i:44;s:4:\"pose\";i:45;s:8:\"practice\";i:46;s:5:\"relax\";}}}');
INSERT INTO `wp_79e54b1ec2_postmeta` VALUES ('123','44','_elementor_source_image_hash','95c60206e32e4a2540354037ae7df22954ed04a9');
INSERT INTO `wp_79e54b1ec2_postmeta` VALUES ('124','45','_wp_attached_file','2025/10/logo_5.png');
INSERT INTO `wp_79e54b1ec2_postmeta` VALUES ('125','45','_wp_attachment_metadata','a:6:{s:5:\"width\";i:1000;s:6:\"height\";i:600;s:4:\"file\";s:18:\"2025/10/logo_5.png\";s:8:\"filesize\";i:15730;s:5:\"sizes\";a:3:{s:6:\"medium\";a:5:{s:4:\"file\";s:18:\"logo_5-300x180.png\";s:5:\"width\";i:300;s:6:\"height\";i:180;s:9:\"mime-type\";s:9:\"image/png\";s:8:\"filesize\";i:2933;}s:9:\"thumbnail\";a:5:{s:4:\"file\";s:18:\"logo_5-150x150.png\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:9:\"image/png\";s:8:\"filesize\";i:1601;}s:12:\"medium_large\";a:5:{s:4:\"file\";s:18:\"logo_5-768x461.png\";s:5:\"width\";i:768;s:6:\"height\";i:461;s:9:\"mime-type\";s:9:\"image/png\";s:8:\"filesize\";i:7985;}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}');
INSERT INTO `wp_79e54b1ec2_postmeta` VALUES ('126','45','_elementor_source_image_hash','b89e4c1bbed499ed8b2faeac0b70b45a544036a3');
INSERT INTO `wp_79e54b1ec2_postmeta` VALUES ('127','46','_wp_attached_file','2025/10/portrait-of-happy-african-american-man-looking-at-KY33EHT.jpg');
INSERT INTO `wp_79e54b1ec2_postmeta` VALUES ('128','46','_wp_attachment_metadata','a:6:{s:5:\"width\";i:1000;s:6:\"height\";i:1000;s:4:\"file\";s:69:\"2025/10/portrait-of-happy-african-american-man-looking-at-KY33EHT.jpg\";s:8:\"filesize\";i:89409;s:5:\"sizes\";a:3:{s:6:\"medium\";a:5:{s:4:\"file\";s:69:\"portrait-of-happy-african-american-man-looking-at-KY33EHT-300x300.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:300;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:32622;}s:9:\"thumbnail\";a:5:{s:4:\"file\";s:69:\"portrait-of-happy-african-american-man-looking-at-KY33EHT-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:24628;}s:12:\"medium_large\";a:5:{s:4:\"file\";s:69:\"portrait-of-happy-african-american-man-looking-at-KY33EHT-768x768.jpg\";s:5:\"width\";i:768;s:6:\"height\";i:768;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:75551;}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:3:\"2.8\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:20:\"Canon EOS 5D Mark IV\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:10:\"1620809159\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:2:\"35\";s:3:\"iso\";s:3:\"640\";s:13:\"shutter_speed\";s:5:\"0.004\";s:5:\"title\";s:109:\"Portrait of happy african american man looking at camera and smiling in bedroom. spending time alone at home.\";s:11:\"orientation\";s:1:\"1\";s:8:\"keywords\";a:40:{i:0;s:10:\"One Person\";i:1;s:12:\"Mature Adult\";i:2;s:3:\"Man\";i:3;s:4:\"Male\";i:4;s:5:\"Black\";i:5;s:6:\"People\";i:6;s:8:\"Portrait\";i:7;s:5:\"Happy\";i:8;s:16:\"African American\";i:9;s:3:\"Man\";i:10;s:14:\"Looking Camera\";i:11;s:7:\"Smiling\";i:12;s:7:\"Bedroom\";i:13;s:13:\"Spending Time\";i:14;s:5:\"Alone\";i:15;s:4:\"Home\";i:16;s:5:\"Young\";i:17;s:6:\"Person\";i:18;s:8:\"Cheerful\";i:19;s:5:\"Adult\";i:20;s:9:\"Lifestyle\";i:21;s:10:\"Attractive\";i:22;s:5:\"Smile\";i:23;s:4:\"Cute\";i:24;s:9:\"Happiness\";i:25;s:3:\"Bed\";i:26;s:4:\"Face\";i:27;s:6:\"Pretty\";i:28;s:3:\"Fun\";i:29;s:7:\"Looking\";i:30;s:6:\"Casual\";i:31;s:9:\"Beautiful\";i:32;s:7:\"Indoors\";i:33;s:4:\"Room\";i:34;s:5:\"House\";i:35;s:7:\"African\";i:36;s:8:\"American\";i:37;s:6:\"Camera\";i:38;s:8:\"Spending\";i:39;s:4:\"Time\";}}}');
INSERT INTO `wp_79e54b1ec2_postmeta` VALUES ('129','46','_elementor_source_image_hash','27101e725d73268c2364786c53a59d01171b4211');
INSERT INTO `wp_79e54b1ec2_postmeta` VALUES ('130','47','_wp_attached_file','2025/10/logo_6.png');
INSERT INTO `wp_79e54b1ec2_postmeta` VALUES ('131','47','_wp_attachment_metadata','a:6:{s:5:\"width\";i:1000;s:6:\"height\";i:600;s:4:\"file\";s:18:\"2025/10/logo_6.png\";s:8:\"filesize\";i:8835;s:5:\"sizes\";a:3:{s:6:\"medium\";a:5:{s:4:\"file\";s:18:\"logo_6-300x180.png\";s:5:\"width\";i:300;s:6:\"height\";i:180;s:9:\"mime-type\";s:9:\"image/png\";s:8:\"filesize\";i:1770;}s:9:\"thumbnail\";a:5:{s:4:\"file\";s:18:\"logo_6-150x150.png\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:9:\"image/png\";s:8:\"filesize\";i:1543;}s:12:\"medium_large\";a:5:{s:4:\"file\";s:18:\"logo_6-768x461.png\";s:5:\"width\";i:768;s:6:\"height\";i:461;s:9:\"mime-type\";s:9:\"image/png\";s:8:\"filesize\";i:4015;}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}');
INSERT INTO `wp_79e54b1ec2_postmeta` VALUES ('132','47','_elementor_source_image_hash','847115d0df6d57e876e4f03fc40dec9376f8e51f');
INSERT INTO `wp_79e54b1ec2_postmeta` VALUES ('133','48','_wp_attached_file','2025/10/close-up-portrait-of-young-businesswoman-outdoors-5PRP7CF.jpg');
INSERT INTO `wp_79e54b1ec2_postmeta` VALUES ('134','48','_wp_attachment_metadata','a:6:{s:5:\"width\";i:1000;s:6:\"height\";i:1000;s:4:\"file\";s:69:\"2025/10/close-up-portrait-of-young-businesswoman-outdoors-5PRP7CF.jpg\";s:8:\"filesize\";i:98682;s:5:\"sizes\";a:3:{s:6:\"medium\";a:5:{s:4:\"file\";s:69:\"close-up-portrait-of-young-businesswoman-outdoors-5PRP7CF-300x300.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:300;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:34874;}s:9:\"thumbnail\";a:5:{s:4:\"file\";s:69:\"close-up-portrait-of-young-businesswoman-outdoors-5PRP7CF-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:26197;}s:12:\"medium_large\";a:5:{s:4:\"file\";s:69:\"close-up-portrait-of-young-businesswoman-outdoors-5PRP7CF-768x768.jpg\";s:5:\"width\";i:768;s:6:\"height\";i:768;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:81335;}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:56:\"Close up portrait of young blonde businesswoman outdoors\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:49:\"Close up portrait of young businesswoman outdoors\";s:11:\"orientation\";s:1:\"1\";s:8:\"keywords\";a:40:{i:0;s:5:\"woman\";i:1;s:9:\"lifestyle\";i:2;s:6:\"summer\";i:3;s:4:\"hair\";i:4;s:4:\"girl\";i:5;s:6:\"female\";i:6;s:4:\"face\";i:7;s:6:\"people\";i:8;s:6:\"beauty\";i:9;s:6:\"pretty\";i:10;s:10:\"attractive\";i:11;s:5:\"adult\";i:12;s:5:\"smile\";i:13;s:5:\"young\";i:14;s:8:\"portrait\";i:15;s:7:\"outdoor\";i:16;s:9:\"beautiful\";i:17;s:5:\"model\";i:18;s:6:\"modern\";i:19;s:6:\"nature\";i:20;s:7:\"natural\";i:21;s:6:\"street\";i:22;s:4:\"lady\";i:23;s:7:\"looking\";i:24;s:8:\"elegance\";i:25;s:6:\"casual\";i:26;s:5:\"happy\";i:27;s:5:\"white\";i:28;s:9:\"caucasian\";i:29;s:7:\"outside\";i:30;s:7:\"closeup\";i:31;s:4:\"cute\";i:32;s:5:\"urban\";i:33;s:6:\"person\";i:34;s:4:\"city\";i:35;s:6:\"makeup\";i:36;s:4:\"town\";i:37;s:5:\"close\";i:38;s:6:\"blonde\";i:39;s:8:\"european\";}}}');
INSERT INTO `wp_79e54b1ec2_postmeta` VALUES ('135','48','_elementor_source_image_hash','d206c8bc2cde70c29573367d185dba4da991fd9e');
INSERT INTO `wp_79e54b1ec2_postmeta` VALUES ('136','49','_wp_attached_file','2025/10/logo_8.png');
INSERT INTO `wp_79e54b1ec2_postmeta` VALUES ('137','49','_wp_attachment_metadata','a:6:{s:5:\"width\";i:1000;s:6:\"height\";i:600;s:4:\"file\";s:18:\"2025/10/logo_8.png\";s:8:\"filesize\";i:12825;s:5:\"sizes\";a:3:{s:6:\"medium\";a:5:{s:4:\"file\";s:18:\"logo_8-300x180.png\";s:5:\"width\";i:300;s:6:\"height\";i:180;s:9:\"mime-type\";s:9:\"image/png\";s:8:\"filesize\";i:2519;}s:9:\"thumbnail\";a:5:{s:4:\"file\";s:18:\"logo_8-150x150.png\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:9:\"image/png\";s:8:\"filesize\";i:1350;}s:12:\"medium_large\";a:5:{s:4:\"file\";s:18:\"logo_8-768x461.png\";s:5:\"width\";i:768;s:6:\"height\";i:461;s:9:\"mime-type\";s:9:\"image/png\";s:8:\"filesize\";i:6743;}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}');
INSERT INTO `wp_79e54b1ec2_postmeta` VALUES ('138','49','_elementor_source_image_hash','97e08da929446aa5335c3cf6486765968652c5f6');
INSERT INTO `wp_79e54b1ec2_postmeta` VALUES ('139','50','_wp_attached_file','2025/10/portrait-of-mature-man-with-grey-hair-and-stubble-N2FETGY.jpg');
INSERT INTO `wp_79e54b1ec2_postmeta` VALUES ('140','50','_wp_attachment_metadata','a:6:{s:5:\"width\";i:1000;s:6:\"height\";i:1000;s:4:\"file\";s:69:\"2025/10/portrait-of-mature-man-with-grey-hair-and-stubble-N2FETGY.jpg\";s:8:\"filesize\";i:103662;s:5:\"sizes\";a:3:{s:6:\"medium\";a:5:{s:4:\"file\";s:69:\"portrait-of-mature-man-with-grey-hair-and-stubble-N2FETGY-300x300.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:300;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:32343;}s:9:\"thumbnail\";a:5:{s:4:\"file\";s:69:\"portrait-of-mature-man-with-grey-hair-and-stubble-N2FETGY-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:22639;}s:12:\"medium_large\";a:5:{s:4:\"file\";s:69:\"portrait-of-mature-man-with-grey-hair-and-stubble-N2FETGY-768x768.jpg\";s:5:\"width\";i:768;s:6:\"height\";i:768;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:82317;}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:3:\"2.2\";s:6:\"credit\";s:10:\"Tom Chance\";s:6:\"camera\";s:20:\"Canon EOS 5D Mark II\";s:7:\"caption\";s:57:\"Portrait of mature man with grey hair and stubble at home\";s:17:\"created_timestamp\";s:10:\"1537181195\";s:9:\"copyright\";s:22:\"Westend61 / Tom Chance\";s:12:\"focal_length\";s:2:\"50\";s:3:\"iso\";s:3:\"200\";s:13:\"shutter_speed\";s:5:\"0.005\";s:5:\"title\";s:57:\"Portrait of mature man with grey hair and stubble at home\";s:11:\"orientation\";s:1:\"1\";s:8:\"keywords\";a:28:{i:0;s:7:\"stubble\";i:1;s:8:\"portrait\";i:2;s:4:\"home\";i:3;s:5:\"beard\";i:4;s:6:\"people\";i:5;s:5:\"shirt\";i:6;s:6:\"casual\";i:7;s:10:\"front view\";i:8;s:7:\"looking\";i:9;s:17:\"looking at camera\";i:10;s:9:\"door case\";i:11;s:8:\"standing\";i:12;s:8:\"waist up\";i:13;s:9:\"caucasian\";i:14;s:7:\"indoors\";i:15;s:10:\"mature men\";i:16;s:11:\"45-50 years\";i:17;s:4:\"flat\";i:18;s:10:\"one person\";i:19;s:9:\"grey hair\";i:20;s:3:\"man\";i:21;s:7:\"Germany\";i:22;s:10:\"copy space\";i:23;s:6:\"Adults\";i:24;s:11:\"40-50 years\";i:25;s:13:\"mature adults\";i:26;s:11:\"Photography\";i:27;s:11:\"Color Image\";}}}');
INSERT INTO `wp_79e54b1ec2_postmeta` VALUES ('141','50','_elementor_source_image_hash','5d158b429fd9a7df3dec0ac585bde82524238a25');
INSERT INTO `wp_79e54b1ec2_postmeta` VALUES ('142','51','_wp_attached_file','2025/10/logo_10.png');
INSERT INTO `wp_79e54b1ec2_postmeta` VALUES ('143','51','_wp_attachment_metadata','a:6:{s:5:\"width\";i:1000;s:6:\"height\";i:600;s:4:\"file\";s:19:\"2025/10/logo_10.png\";s:8:\"filesize\";i:16388;s:5:\"sizes\";a:3:{s:6:\"medium\";a:5:{s:4:\"file\";s:19:\"logo_10-300x180.png\";s:5:\"width\";i:300;s:6:\"height\";i:180;s:9:\"mime-type\";s:9:\"image/png\";s:8:\"filesize\";i:3011;}s:9:\"thumbnail\";a:5:{s:4:\"file\";s:19:\"logo_10-150x150.png\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:9:\"image/png\";s:8:\"filesize\";i:1962;}s:12:\"medium_large\";a:5:{s:4:\"file\";s:19:\"logo_10-768x461.png\";s:5:\"width\";i:768;s:6:\"height\";i:461;s:9:\"mime-type\";s:9:\"image/png\";s:8:\"filesize\";i:8073;}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}');
INSERT INTO `wp_79e54b1ec2_postmeta` VALUES ('144','51','_elementor_source_image_hash','9879bbcd36ea43ad117f32dd735bf2cacb06d2d5');
INSERT INTO `wp_79e54b1ec2_postmeta` VALUES ('145','52','_wp_attached_file','2025/10/logo_1.png');
INSERT INTO `wp_79e54b1ec2_postmeta` VALUES ('146','52','_wp_attachment_metadata','a:6:{s:5:\"width\";i:1000;s:6:\"height\";i:600;s:4:\"file\";s:18:\"2025/10/logo_1.png\";s:8:\"filesize\";i:16290;s:5:\"sizes\";a:3:{s:6:\"medium\";a:5:{s:4:\"file\";s:18:\"logo_1-300x180.png\";s:5:\"width\";i:300;s:6:\"height\";i:180;s:9:\"mime-type\";s:9:\"image/png\";s:8:\"filesize\";i:3254;}s:9:\"thumbnail\";a:5:{s:4:\"file\";s:18:\"logo_1-150x150.png\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:9:\"image/png\";s:8:\"filesize\";i:2207;}s:12:\"medium_large\";a:5:{s:4:\"file\";s:18:\"logo_1-768x461.png\";s:5:\"width\";i:768;s:6:\"height\";i:461;s:9:\"mime-type\";s:9:\"image/png\";s:8:\"filesize\";i:8770;}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}');
INSERT INTO `wp_79e54b1ec2_postmeta` VALUES ('147','52','_elementor_source_image_hash','ce918dee296918fa68fc1da1f42694964e4a03cf');
INSERT INTO `wp_79e54b1ec2_postmeta` VALUES ('148','53','_wp_attached_file','2025/10/logo_4.png');
INSERT INTO `wp_79e54b1ec2_postmeta` VALUES ('149','53','_wp_attachment_metadata','a:6:{s:5:\"width\";i:1000;s:6:\"height\";i:600;s:4:\"file\";s:18:\"2025/10/logo_4.png\";s:8:\"filesize\";i:11150;s:5:\"sizes\";a:3:{s:6:\"medium\";a:5:{s:4:\"file\";s:18:\"logo_4-300x180.png\";s:5:\"width\";i:300;s:6:\"height\";i:180;s:9:\"mime-type\";s:9:\"image/png\";s:8:\"filesize\";i:2224;}s:9:\"thumbnail\";a:5:{s:4:\"file\";s:18:\"logo_4-150x150.png\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:9:\"image/png\";s:8:\"filesize\";i:2054;}s:12:\"medium_large\";a:5:{s:4:\"file\";s:18:\"logo_4-768x461.png\";s:5:\"width\";i:768;s:6:\"height\";i:461;s:9:\"mime-type\";s:9:\"image/png\";s:8:\"filesize\";i:5828;}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}');
INSERT INTO `wp_79e54b1ec2_postmeta` VALUES ('150','53','_elementor_source_image_hash','a2348f21593efb9878db88f497dc392e42156b5d');
INSERT INTO `wp_79e54b1ec2_postmeta` VALUES ('151','54','_wp_attached_file','2025/10/bgoverlay_14.png');
INSERT INTO `wp_79e54b1ec2_postmeta` VALUES ('152','54','_wp_attachment_metadata','a:6:{s:5:\"width\";i:2001;s:6:\"height\";i:2000;s:4:\"file\";s:24:\"2025/10/bgoverlay_14.png\";s:8:\"filesize\";i:61753;s:5:\"sizes\";a:5:{s:6:\"medium\";a:5:{s:4:\"file\";s:24:\"bgoverlay_14-300x300.png\";s:5:\"width\";i:300;s:6:\"height\";i:300;s:9:\"mime-type\";s:9:\"image/png\";s:8:\"filesize\";i:3846;}s:5:\"large\";a:5:{s:4:\"file\";s:26:\"bgoverlay_14-1024x1024.png\";s:5:\"width\";i:1024;s:6:\"height\";i:1024;s:9:\"mime-type\";s:9:\"image/png\";s:8:\"filesize\";i:15387;}s:9:\"thumbnail\";a:5:{s:4:\"file\";s:24:\"bgoverlay_14-150x150.png\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:9:\"image/png\";s:8:\"filesize\";i:2102;}s:12:\"medium_large\";a:5:{s:4:\"file\";s:24:\"bgoverlay_14-768x768.png\";s:5:\"width\";i:768;s:6:\"height\";i:768;s:9:\"mime-type\";s:9:\"image/png\";s:8:\"filesize\";i:10687;}s:9:\"1536x1536\";a:5:{s:4:\"file\";s:26:\"bgoverlay_14-1536x1536.png\";s:5:\"width\";i:1536;s:6:\"height\";i:1536;s:9:\"mime-type\";s:9:\"image/png\";s:8:\"filesize\";i:27018;}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}');
INSERT INTO `wp_79e54b1ec2_postmeta` VALUES ('153','54','_elementor_source_image_hash','a5418dc54211c9c3740e5c0a417dfff6134658ac');
INSERT INTO `wp_79e54b1ec2_postmeta` VALUES ('154','55','_wp_attached_file','2025/10/placeholder.png');
INSERT INTO `wp_79e54b1ec2_postmeta` VALUES ('155','55','_wp_attachment_metadata','a:6:{s:5:\"width\";i:1200;s:6:\"height\";i:800;s:4:\"file\";s:23:\"2025/10/placeholder.png\";s:8:\"filesize\";i:6146;s:5:\"sizes\";a:4:{s:6:\"medium\";a:5:{s:4:\"file\";s:23:\"placeholder-300x200.png\";s:5:\"width\";i:300;s:6:\"height\";i:200;s:9:\"mime-type\";s:9:\"image/png\";s:8:\"filesize\";i:1860;}s:5:\"large\";a:5:{s:4:\"file\";s:24:\"placeholder-1024x683.png\";s:5:\"width\";i:1024;s:6:\"height\";i:683;s:9:\"mime-type\";s:9:\"image/png\";s:8:\"filesize\";i:6951;}s:9:\"thumbnail\";a:5:{s:4:\"file\";s:23:\"placeholder-150x150.png\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:9:\"image/png\";s:8:\"filesize\";i:1117;}s:12:\"medium_large\";a:5:{s:4:\"file\";s:23:\"placeholder-768x512.png\";s:5:\"width\";i:768;s:6:\"height\";i:512;s:9:\"mime-type\";s:9:\"image/png\";s:8:\"filesize\";i:4970;}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}');
INSERT INTO `wp_79e54b1ec2_postmeta` VALUES ('156','55','_elementor_source_image_hash','85c2c77a28fed4891af0c79411c6ceb624f9dfe8');
INSERT INTO `wp_79e54b1ec2_postmeta` VALUES ('228','66','_wp_trash_meta_status','publish');
INSERT INTO `wp_79e54b1ec2_postmeta` VALUES ('229','66','_wp_trash_meta_time','1761606377');
INSERT INTO `wp_79e54b1ec2_postmeta` VALUES ('230','67','_wp_attached_file','2025/10/logo_Asset-1-1.png');
INSERT INTO `wp_79e54b1ec2_postmeta` VALUES ('231','67','_wp_attachment_metadata','a:6:{s:5:\"width\";i:1001;s:6:\"height\";i:367;s:4:\"file\";s:26:\"2025/10/logo_Asset-1-1.png\";s:8:\"filesize\";i:14840;s:5:\"sizes\";a:3:{s:6:\"medium\";a:5:{s:4:\"file\";s:26:\"logo_Asset-1-1-300x110.png\";s:5:\"width\";i:300;s:6:\"height\";i:110;s:9:\"mime-type\";s:9:\"image/png\";s:8:\"filesize\";i:3508;}s:9:\"thumbnail\";a:5:{s:4:\"file\";s:26:\"logo_Asset-1-1-150x150.png\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:9:\"image/png\";s:8:\"filesize\";i:1623;}s:12:\"medium_large\";a:5:{s:4:\"file\";s:26:\"logo_Asset-1-1-768x282.png\";s:5:\"width\";i:768;s:6:\"height\";i:282;s:9:\"mime-type\";s:9:\"image/png\";s:8:\"filesize\";i:9081;}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}');
INSERT INTO `wp_79e54b1ec2_postmeta` VALUES ('232','67','_elementor_source_image_hash','9b7836e8b9856833e01fc542ad09896029612ca4');
INSERT INTO `wp_79e54b1ec2_postmeta` VALUES ('278','74','_wp_attached_file','2025/10/logo_Asset-2-1.png');
INSERT INTO `wp_79e54b1ec2_postmeta` VALUES ('279','74','_wp_attachment_metadata','a:6:{s:5:\"width\";i:1001;s:6:\"height\";i:367;s:4:\"file\";s:26:\"2025/10/logo_Asset-2-1.png\";s:8:\"filesize\";i:14888;s:5:\"sizes\";a:3:{s:6:\"medium\";a:5:{s:4:\"file\";s:26:\"logo_Asset-2-1-300x110.png\";s:5:\"width\";i:300;s:6:\"height\";i:110;s:9:\"mime-type\";s:9:\"image/png\";s:8:\"filesize\";i:3600;}s:9:\"thumbnail\";a:5:{s:4:\"file\";s:26:\"logo_Asset-2-1-150x150.png\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:9:\"image/png\";s:8:\"filesize\";i:1704;}s:12:\"medium_large\";a:5:{s:4:\"file\";s:26:\"logo_Asset-2-1-768x282.png\";s:5:\"width\";i:768;s:6:\"height\";i:282;s:9:\"mime-type\";s:9:\"image/png\";s:8:\"filesize\";i:9152;}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}');
INSERT INTO `wp_79e54b1ec2_postmeta` VALUES ('280','74','_elementor_source_image_hash','8db1542f10246b11f87cdee120a263aff5ed0402');
INSERT INTO `wp_79e54b1ec2_postmeta` VALUES ('320','81','_wp_attached_file','2025/10/517335251_122116215308912254_4030864418510199160_n-1.jpg');
INSERT INTO `wp_79e54b1ec2_postmeta` VALUES ('321','81','_wp_attachment_metadata','a:6:{s:5:\"width\";i:400;s:6:\"height\";i:400;s:4:\"file\";s:64:\"2025/10/517335251_122116215308912254_4030864418510199160_n-1.jpg\";s:8:\"filesize\";i:19557;s:5:\"sizes\";a:2:{s:6:\"medium\";a:5:{s:4:\"file\";s:64:\"517335251_122116215308912254_4030864418510199160_n-1-300x300.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:300;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:12701;}s:9:\"thumbnail\";a:5:{s:4:\"file\";s:64:\"517335251_122116215308912254_4030864418510199160_n-1-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:4678;}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}');
INSERT INTO `wp_79e54b1ec2_postmeta` VALUES ('322','82','_wp_attached_file','2025/10/517335251_122116215308912254_4030864418510199160_n-1-Photoroom.png');
INSERT INTO `wp_79e54b1ec2_postmeta` VALUES ('323','82','_wp_attachment_metadata','a:6:{s:5:\"width\";i:400;s:6:\"height\";i:400;s:4:\"file\";s:74:\"2025/10/517335251_122116215308912254_4030864418510199160_n-1-Photoroom.png\";s:8:\"filesize\";i:129554;s:5:\"sizes\";a:2:{s:6:\"medium\";a:5:{s:4:\"file\";s:74:\"517335251_122116215308912254_4030864418510199160_n-1-Photoroom-300x300.png\";s:5:\"width\";i:300;s:6:\"height\";i:300;s:9:\"mime-type\";s:9:\"image/png\";s:8:\"filesize\";i:21035;}s:9:\"thumbnail\";a:5:{s:4:\"file\";s:74:\"517335251_122116215308912254_4030864418510199160_n-1-Photoroom-150x150.png\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:9:\"image/png\";s:8:\"filesize\";i:6898;}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}');
INSERT INTO `wp_79e54b1ec2_postmeta` VALUES ('333','84','_menu_item_type','custom');
INSERT INTO `wp_79e54b1ec2_postmeta` VALUES ('334','84','_menu_item_menu_item_parent','0');
INSERT INTO `wp_79e54b1ec2_postmeta` VALUES ('335','84','_menu_item_object_id','84');
INSERT INTO `wp_79e54b1ec2_postmeta` VALUES ('336','84','_menu_item_object','custom');
INSERT INTO `wp_79e54b1ec2_postmeta` VALUES ('337','84','_menu_item_target','');
INSERT INTO `wp_79e54b1ec2_postmeta` VALUES ('338','84','_menu_item_classes','a:1:{i:0;s:0:\"\";}');
INSERT INTO `wp_79e54b1ec2_postmeta` VALUES ('339','84','_menu_item_xfn','');
INSERT INTO `wp_79e54b1ec2_postmeta` VALUES ('340','84','_menu_item_url','#about');
INSERT INTO `wp_79e54b1ec2_postmeta` VALUES ('342','85','_menu_item_type','custom');
INSERT INTO `wp_79e54b1ec2_postmeta` VALUES ('343','85','_menu_item_menu_item_parent','0');
INSERT INTO `wp_79e54b1ec2_postmeta` VALUES ('344','85','_menu_item_object_id','85');
INSERT INTO `wp_79e54b1ec2_postmeta` VALUES ('345','85','_menu_item_object','custom');
INSERT INTO `wp_79e54b1ec2_postmeta` VALUES ('346','85','_menu_item_target','');
INSERT INTO `wp_79e54b1ec2_postmeta` VALUES ('347','85','_menu_item_classes','a:1:{i:0;s:0:\"\";}');
INSERT INTO `wp_79e54b1ec2_postmeta` VALUES ('348','85','_menu_item_xfn','');
INSERT INTO `wp_79e54b1ec2_postmeta` VALUES ('349','85','_menu_item_url','#service');
INSERT INTO `wp_79e54b1ec2_postmeta` VALUES ('351','86','_menu_item_type','custom');
INSERT INTO `wp_79e54b1ec2_postmeta` VALUES ('352','86','_menu_item_menu_item_parent','0');
INSERT INTO `wp_79e54b1ec2_postmeta` VALUES ('353','86','_menu_item_object_id','86');
INSERT INTO `wp_79e54b1ec2_postmeta` VALUES ('354','86','_menu_item_object','custom');
INSERT INTO `wp_79e54b1ec2_postmeta` VALUES ('355','86','_menu_item_target','');
INSERT INTO `wp_79e54b1ec2_postmeta` VALUES ('356','86','_menu_item_classes','a:1:{i:0;s:0:\"\";}');
INSERT INTO `wp_79e54b1ec2_postmeta` VALUES ('357','86','_menu_item_xfn','');
INSERT INTO `wp_79e54b1ec2_postmeta` VALUES ('358','86','_menu_item_url','#projects');
INSERT INTO `wp_79e54b1ec2_postmeta` VALUES ('360','87','_menu_item_type','custom');
INSERT INTO `wp_79e54b1ec2_postmeta` VALUES ('361','87','_menu_item_menu_item_parent','0');
INSERT INTO `wp_79e54b1ec2_postmeta` VALUES ('362','87','_menu_item_object_id','87');
INSERT INTO `wp_79e54b1ec2_postmeta` VALUES ('363','87','_menu_item_object','custom');
INSERT INTO `wp_79e54b1ec2_postmeta` VALUES ('364','87','_menu_item_target','');
INSERT INTO `wp_79e54b1ec2_postmeta` VALUES ('365','87','_menu_item_classes','a:1:{i:0;s:0:\"\";}');
INSERT INTO `wp_79e54b1ec2_postmeta` VALUES ('366','87','_menu_item_xfn','');
INSERT INTO `wp_79e54b1ec2_postmeta` VALUES ('367','87','_menu_item_url','#review');
INSERT INTO `wp_79e54b1ec2_postmeta` VALUES ('418','11','_edit_lock','1761607869:2');
INSERT INTO `wp_79e54b1ec2_postmeta` VALUES ('419','95','_elementor_edit_mode','builder');
INSERT INTO `wp_79e54b1ec2_postmeta` VALUES ('420','95','_elementor_template_type','kit');
INSERT INTO `wp_79e54b1ec2_postmeta` VALUES ('421','95','_elementor_version','3.32.5');
INSERT INTO `wp_79e54b1ec2_postmeta` VALUES ('422','95','_wp_page_template','default');
INSERT INTO `wp_79e54b1ec2_postmeta` VALUES ('423','95','_elementor_page_settings','a:28:{s:32:\"colors_enable_styleguide_preview\";s:3:\"yes\";s:13:\"system_colors\";a:4:{i:0;a:3:{s:3:\"_id\";s:7:\"primary\";s:5:\"title\";s:7:\"Primary\";s:5:\"color\";s:7:\"#282C31\";}i:1;a:3:{s:3:\"_id\";s:9:\"secondary\";s:5:\"title\";s:9:\"Secondary\";s:5:\"color\";s:7:\"#F3F1E6\";}i:2;a:3:{s:3:\"_id\";s:4:\"text\";s:5:\"title\";s:4:\"Text\";s:5:\"color\";s:7:\"#7A7A7A\";}i:3;a:3:{s:3:\"_id\";s:6:\"accent\";s:5:\"title\";s:6:\"Accent\";s:5:\"color\";s:7:\"#F2CA4B\";}}s:13:\"custom_colors\";a:2:{i:0;a:3:{s:3:\"_id\";s:7:\"4e8747b\";s:5:\"title\";s:10:\"Background\";s:5:\"color\";s:7:\"#F5F5F5\";}i:1;a:3:{s:3:\"_id\";s:7:\"5ee12b7\";s:5:\"title\";s:13:\"Background #2\";s:5:\"color\";s:7:\"#F0EEEA\";}}s:17:\"system_typography\";a:4:{i:0;a:13:{s:3:\"_id\";s:7:\"primary\";s:5:\"title\";s:10:\"H1 Heading\";s:21:\"typography_typography\";s:6:\"custom\";s:22:\"typography_font_family\";s:7:\"Manrope\";s:22:\"typography_font_weight\";s:3:\"600\";s:20:\"typography_font_size\";a:3:{s:4:\"unit\";s:2:\"px\";s:4:\"size\";i:65;s:5:\"sizes\";a:0:{}}s:25:\"typography_text_transform\";s:4:\"none\";s:21:\"typography_font_style\";s:6:\"normal\";s:26:\"typography_text_decoration\";s:4:\"none\";s:22:\"typography_line_height\";a:3:{s:4:\"unit\";s:2:\"em\";s:4:\"size\";d:1.4;s:5:\"sizes\";a:0:{}}s:27:\"typography_font_size_tablet\";a:3:{s:4:\"unit\";s:2:\"px\";s:4:\"size\";i:55;s:5:\"sizes\";a:0:{}}s:27:\"typography_font_size_mobile\";a:3:{s:4:\"unit\";s:2:\"px\";s:4:\"size\";i:42;s:5:\"sizes\";a:0:{}}s:25:\"typography_letter_spacing\";a:3:{s:4:\"unit\";s:2:\"px\";s:4:\"size\";i:0;s:5:\"sizes\";a:0:{}}}i:1;a:13:{s:3:\"_id\";s:9:\"secondary\";s:5:\"title\";s:10:\"H2 Heading\";s:21:\"typography_typography\";s:6:\"custom\";s:22:\"typography_font_family\";s:7:\"Manrope\";s:22:\"typography_font_weight\";s:3:\"600\";s:20:\"typography_font_size\";a:3:{s:4:\"unit\";s:2:\"px\";s:4:\"size\";i:50;s:5:\"sizes\";a:0:{}}s:25:\"typography_text_transform\";s:4:\"none\";s:21:\"typography_font_style\";s:6:\"normal\";s:26:\"typography_text_decoration\";s:4:\"none\";s:22:\"typography_line_height\";a:3:{s:4:\"unit\";s:2:\"em\";s:4:\"size\";d:1.4;s:5:\"sizes\";a:0:{}}s:27:\"typography_font_size_tablet\";a:3:{s:4:\"unit\";s:2:\"px\";s:4:\"size\";i:42;s:5:\"sizes\";a:0:{}}s:27:\"typography_font_size_mobile\";a:3:{s:4:\"unit\";s:2:\"px\";s:4:\"size\";i:37;s:5:\"sizes\";a:0:{}}s:25:\"typography_letter_spacing\";a:3:{s:4:\"unit\";s:2:\"px\";s:4:\"size\";i:0;s:5:\"sizes\";a:0:{}}}i:2;a:13:{s:3:\"_id\";s:4:\"text\";s:5:\"title\";s:4:\"Text\";s:21:\"typography_typography\";s:6:\"custom\";s:22:\"typography_font_family\";s:7:\"Manrope\";s:22:\"typography_font_weight\";s:3:\"500\";s:20:\"typography_font_size\";a:3:{s:4:\"unit\";s:2:\"px\";s:4:\"size\";i:15;s:5:\"sizes\";a:0:{}}s:25:\"typography_text_transform\";s:4:\"none\";s:21:\"typography_font_style\";s:6:\"normal\";s:26:\"typography_text_decoration\";s:4:\"none\";s:22:\"typography_line_height\";a:3:{s:4:\"unit\";s:2:\"em\";s:4:\"size\";d:1.8;s:5:\"sizes\";a:0:{}}s:27:\"typography_font_size_tablet\";a:3:{s:4:\"unit\";s:2:\"px\";s:4:\"size\";i:14;s:5:\"sizes\";a:0:{}}s:27:\"typography_font_size_mobile\";a:3:{s:4:\"unit\";s:2:\"px\";s:4:\"size\";i:14;s:5:\"sizes\";a:0:{}}s:25:\"typography_letter_spacing\";a:3:{s:4:\"unit\";s:2:\"px\";s:4:\"size\";i:0;s:5:\"sizes\";a:0:{}}}i:3;a:12:{s:3:\"_id\";s:6:\"accent\";s:5:\"title\";s:6:\"Button\";s:21:\"typography_typography\";s:6:\"custom\";s:22:\"typography_font_family\";s:7:\"Manrope\";s:22:\"typography_font_weight\";s:3:\"600\";s:20:\"typography_font_size\";a:3:{s:4:\"unit\";s:2:\"px\";s:4:\"size\";i:13;s:5:\"sizes\";a:0:{}}s:25:\"typography_text_transform\";s:4:\"none\";s:21:\"typography_font_style\";s:6:\"normal\";s:26:\"typography_text_decoration\";s:4:\"none\";s:27:\"typography_font_size_tablet\";a:3:{s:4:\"unit\";s:2:\"px\";s:4:\"size\";i:12;s:5:\"sizes\";a:0:{}}s:27:\"typography_font_size_mobile\";a:3:{s:4:\"unit\";s:2:\"px\";s:4:\"size\";i:12;s:5:\"sizes\";a:0:{}}s:25:\"typography_letter_spacing\";a:3:{s:4:\"unit\";s:2:\"px\";s:4:\"size\";i:0;s:5:\"sizes\";a:0:{}}}}s:17:\"custom_typography\";a:7:{i:0;a:13:{s:21:\"typography_typography\";s:6:\"custom\";s:22:\"typography_font_family\";s:7:\"Manrope\";s:20:\"typography_font_size\";a:3:{s:4:\"unit\";s:2:\"px\";s:4:\"size\";i:32;s:5:\"sizes\";a:0:{}}s:27:\"typography_font_size_tablet\";a:3:{s:4:\"unit\";s:2:\"px\";s:4:\"size\";i:30;s:5:\"sizes\";a:0:{}}s:27:\"typography_font_size_mobile\";a:3:{s:4:\"unit\";s:2:\"px\";s:4:\"size\";i:28;s:5:\"sizes\";a:0:{}}s:22:\"typography_font_weight\";s:3:\"600\";s:25:\"typography_text_transform\";s:4:\"none\";s:21:\"typography_font_style\";s:6:\"normal\";s:26:\"typography_text_decoration\";s:4:\"none\";s:22:\"typography_line_height\";a:3:{s:4:\"unit\";s:2:\"em\";s:4:\"size\";d:1.4;s:5:\"sizes\";a:0:{}}s:25:\"typography_letter_spacing\";a:3:{s:4:\"unit\";s:2:\"px\";s:4:\"size\";i:0;s:5:\"sizes\";a:0:{}}s:3:\"_id\";s:7:\"9a7b7f5\";s:5:\"title\";s:10:\"H3 Heading\";}i:1;a:13:{s:21:\"typography_typography\";s:6:\"custom\";s:22:\"typography_font_family\";s:7:\"Manrope\";s:20:\"typography_font_size\";a:3:{s:4:\"unit\";s:2:\"px\";s:4:\"size\";i:26;s:5:\"sizes\";a:0:{}}s:27:\"typography_font_size_tablet\";a:3:{s:4:\"unit\";s:2:\"px\";s:4:\"size\";i:24;s:5:\"sizes\";a:0:{}}s:27:\"typography_font_size_mobile\";a:3:{s:4:\"unit\";s:2:\"px\";s:4:\"size\";i:22;s:5:\"sizes\";a:0:{}}s:22:\"typography_font_weight\";s:3:\"600\";s:25:\"typography_text_transform\";s:4:\"none\";s:21:\"typography_font_style\";s:6:\"normal\";s:26:\"typography_text_decoration\";s:4:\"none\";s:22:\"typography_line_height\";a:3:{s:4:\"unit\";s:2:\"em\";s:4:\"size\";d:1.4;s:5:\"sizes\";a:0:{}}s:25:\"typography_letter_spacing\";a:3:{s:4:\"unit\";s:2:\"px\";s:4:\"size\";i:0;s:5:\"sizes\";a:0:{}}s:3:\"_id\";s:7:\"553bab4\";s:5:\"title\";s:10:\"H4 Heading\";}i:2;a:15:{s:21:\"typography_typography\";s:6:\"custom\";s:22:\"typography_font_family\";s:7:\"Manrope\";s:20:\"typography_font_size\";a:3:{s:4:\"unit\";s:2:\"px\";s:4:\"size\";i:23;s:5:\"sizes\";a:0:{}}s:27:\"typography_font_size_tablet\";a:3:{s:4:\"unit\";s:2:\"px\";s:4:\"size\";i:21;s:5:\"sizes\";a:0:{}}s:27:\"typography_font_size_mobile\";a:3:{s:4:\"unit\";s:2:\"px\";s:4:\"size\";i:20;s:5:\"sizes\";a:0:{}}s:22:\"typography_font_weight\";s:3:\"600\";s:25:\"typography_text_transform\";s:4:\"none\";s:21:\"typography_font_style\";s:6:\"normal\";s:26:\"typography_text_decoration\";s:4:\"none\";s:22:\"typography_line_height\";a:3:{s:4:\"unit\";s:2:\"em\";s:4:\"size\";d:1.5;s:5:\"sizes\";a:0:{}}s:29:\"typography_line_height_tablet\";a:3:{s:4:\"unit\";s:2:\"px\";s:4:\"size\";s:0:\"\";s:5:\"sizes\";a:0:{}}s:29:\"typography_line_height_mobile\";a:3:{s:4:\"unit\";s:2:\"px\";s:4:\"size\";s:0:\"\";s:5:\"sizes\";a:0:{}}s:25:\"typography_letter_spacing\";a:3:{s:4:\"unit\";s:2:\"px\";s:4:\"size\";i:0;s:5:\"sizes\";a:0:{}}s:3:\"_id\";s:7:\"dd834d5\";s:5:\"title\";s:10:\"H5 Heading\";}i:3;a:13:{s:21:\"typography_typography\";s:6:\"custom\";s:22:\"typography_font_family\";s:7:\"Manrope\";s:20:\"typography_font_size\";a:3:{s:4:\"unit\";s:2:\"px\";s:4:\"size\";i:19;s:5:\"sizes\";a:0:{}}s:27:\"typography_font_size_tablet\";a:3:{s:4:\"unit\";s:2:\"px\";s:4:\"size\";i:18;s:5:\"sizes\";a:0:{}}s:27:\"typography_font_size_mobile\";a:3:{s:4:\"unit\";s:2:\"px\";s:4:\"size\";i:17;s:5:\"sizes\";a:0:{}}s:22:\"typography_font_weight\";s:3:\"600\";s:25:\"typography_text_transform\";s:4:\"none\";s:21:\"typography_font_style\";s:6:\"normal\";s:26:\"typography_text_decoration\";s:4:\"none\";s:22:\"typography_line_height\";a:3:{s:4:\"unit\";s:2:\"em\";s:4:\"size\";d:1.6;s:5:\"sizes\";a:0:{}}s:25:\"typography_letter_spacing\";a:3:{s:4:\"unit\";s:2:\"px\";s:4:\"size\";i:0;s:5:\"sizes\";a:0:{}}s:3:\"_id\";s:7:\"95d9cf0\";s:5:\"title\";s:10:\"H6 Heading\";}i:4;a:12:{s:21:\"typography_typography\";s:6:\"custom\";s:22:\"typography_font_family\";s:7:\"Manrope\";s:20:\"typography_font_size\";a:3:{s:4:\"unit\";s:2:\"px\";s:4:\"size\";i:12;s:5:\"sizes\";a:0:{}}s:27:\"typography_font_size_tablet\";a:3:{s:4:\"unit\";s:2:\"px\";s:4:\"size\";i:11;s:5:\"sizes\";a:0:{}}s:27:\"typography_font_size_mobile\";a:3:{s:4:\"unit\";s:2:\"px\";s:4:\"size\";i:10;s:5:\"sizes\";a:0:{}}s:22:\"typography_font_weight\";s:3:\"700\";s:25:\"typography_text_transform\";s:9:\"uppercase\";s:21:\"typography_font_style\";s:6:\"normal\";s:26:\"typography_text_decoration\";s:4:\"none\";s:25:\"typography_letter_spacing\";a:3:{s:4:\"unit\";s:2:\"px\";s:4:\"size\";i:2;s:5:\"sizes\";a:0:{}}s:3:\"_id\";s:7:\"df05d6e\";s:5:\"title\";s:11:\"Accent Text\";}i:5;a:10:{s:21:\"typography_typography\";s:6:\"custom\";s:22:\"typography_font_family\";s:7:\"Manrope\";s:20:\"typography_font_size\";a:3:{s:4:\"unit\";s:2:\"px\";s:4:\"size\";i:14;s:5:\"sizes\";a:0:{}}s:22:\"typography_font_weight\";s:3:\"600\";s:25:\"typography_text_transform\";s:4:\"none\";s:21:\"typography_font_style\";s:6:\"normal\";s:26:\"typography_text_decoration\";s:4:\"none\";s:3:\"_id\";s:7:\"f4096ca\";s:5:\"title\";s:16:\"Header Menu Item\";s:25:\"typography_letter_spacing\";a:3:{s:4:\"unit\";s:2:\"px\";s:4:\"size\";i:0;s:5:\"sizes\";a:0:{}}}i:6;a:10:{s:21:\"typography_typography\";s:6:\"custom\";s:22:\"typography_font_family\";s:7:\"Manrope\";s:20:\"typography_font_size\";a:3:{s:4:\"unit\";s:2:\"px\";s:4:\"size\";i:14;s:5:\"sizes\";a:0:{}}s:22:\"typography_font_weight\";s:3:\"500\";s:25:\"typography_text_transform\";s:4:\"none\";s:21:\"typography_font_style\";s:6:\"normal\";s:26:\"typography_text_decoration\";s:4:\"none\";s:3:\"_id\";s:7:\"c350ccf\";s:5:\"title\";s:19:\"Header Submenu Item\";s:25:\"typography_letter_spacing\";a:3:{s:4:\"unit\";s:2:\"px\";s:4:\"size\";i:0;s:5:\"sizes\";a:0:{}}}}s:21:\"default_generic_fonts\";s:10:\"Sans-serif\";s:19:\"page_title_selector\";s:14:\"h1.entry-title\";s:27:\"hello_footer_copyright_text\";s:19:\"All rights reserved\";s:15:\"activeItemIndex\";i:1;s:11:\"viewport_md\";i:768;s:11:\"viewport_lg\";i:1025;s:26:\"body_background_background\";s:7:\"classic\";s:21:\"body_background_color\";s:7:\"#F5F5F5\";s:25:\"mobile_browser_background\";s:7:\"#F5F5F5\";s:36:\"typography_enable_styleguide_preview\";s:3:\"yes\";s:20:\"button_border_radius\";a:6:{s:4:\"unit\";s:2:\"px\";s:3:\"top\";s:2:\"30\";s:5:\"right\";s:2:\"30\";s:6:\"bottom\";s:2:\"30\";s:4:\"left\";s:2:\"30\";s:8:\"isLinked\";b:1;}s:29:\"button_hover_background_color\";s:7:\"#E6BE42\";s:26:\"button_hover_border_radius\";a:6:{s:4:\"unit\";s:2:\"px\";s:3:\"top\";s:2:\"30\";s:5:\"right\";s:2:\"30\";s:6:\"bottom\";s:2:\"30\";s:4:\"left\";s:2:\"30\";s:8:\"isLinked\";b:1;}s:14:\"button_padding\";a:6:{s:4:\"unit\";s:2:\"px\";s:3:\"top\";s:2:\"14\";s:5:\"right\";s:2:\"30\";s:6:\"bottom\";s:2:\"14\";s:4:\"left\";s:2:\"30\";s:8:\"isLinked\";b:0;}s:27:\"form_field_background_color\";s:9:\"#02010100\";s:24:\"form_field_border_border\";s:5:\"solid\";s:23:\"form_field_border_width\";a:6:{s:4:\"unit\";s:2:\"px\";s:3:\"top\";s:1:\"1\";s:5:\"right\";s:1:\"1\";s:6:\"bottom\";s:1:\"1\";s:4:\"left\";s:1:\"1\";s:8:\"isLinked\";b:1;}s:23:\"form_field_border_color\";s:9:\"#282C3130\";s:24:\"form_field_border_radius\";a:6:{s:4:\"unit\";s:2:\"px\";s:3:\"top\";s:2:\"30\";s:5:\"right\";s:2:\"30\";s:6:\"bottom\";s:2:\"30\";s:4:\"left\";s:2:\"30\";s:8:\"isLinked\";b:1;}s:30:\"form_field_focus_border_border\";s:5:\"solid\";s:29:\"form_field_focus_border_color\";s:9:\"#282C3150\";s:11:\"__globals__\";a:24:{s:17:\"button_text_color\";s:25:\"globals/colors?id=primary\";s:23:\"button_background_color\";s:24:\"globals/colors?id=accent\";s:23:\"button_hover_text_color\";s:25:\"globals/colors?id=primary\";s:28:\"button_typography_typography\";s:28:\"globals/typography?id=accent\";s:10:\"body_color\";s:22:\"globals/colors?id=text\";s:26:\"body_typography_typography\";s:26:\"globals/typography?id=text\";s:17:\"link_normal_color\";s:22:\"globals/colors?id=text\";s:16:\"link_hover_color\";s:25:\"globals/colors?id=primary\";s:8:\"h1_color\";s:25:\"globals/colors?id=primary\";s:24:\"h1_typography_typography\";s:29:\"globals/typography?id=primary\";s:8:\"h2_color\";s:25:\"globals/colors?id=primary\";s:24:\"h2_typography_typography\";s:31:\"globals/typography?id=secondary\";s:8:\"h3_color\";s:25:\"globals/colors?id=primary\";s:24:\"h3_typography_typography\";s:29:\"globals/typography?id=9a7b7f5\";s:8:\"h4_color\";s:25:\"globals/colors?id=primary\";s:24:\"h4_typography_typography\";s:29:\"globals/typography?id=553bab4\";s:8:\"h5_color\";s:25:\"globals/colors?id=primary\";s:24:\"h5_typography_typography\";s:29:\"globals/typography?id=dd834d5\";s:8:\"h6_color\";s:25:\"globals/colors?id=primary\";s:24:\"h6_typography_typography\";s:29:\"globals/typography?id=95d9cf0\";s:16:\"form_label_color\";s:25:\"globals/colors?id=primary\";s:32:\"form_label_typography_typography\";s:28:\"globals/typography?id=accent\";s:32:\"form_field_typography_typography\";s:26:\"globals/typography?id=text\";s:21:\"form_field_text_color\";s:22:\"globals/colors?id=text\";}s:9:\"site_name\";s:0:\"\";}');
INSERT INTO `wp_79e54b1ec2_postmeta` VALUES ('424','95','_elementor_data','[]');
INSERT INTO `wp_79e54b1ec2_postmeta` VALUES ('427','96','_elementor_edit_mode','builder');
INSERT INTO `wp_79e54b1ec2_postmeta` VALUES ('428','96','_elementor_template_type','kit');
INSERT INTO `wp_79e54b1ec2_postmeta` VALUES ('429','96','_elementor_version','3.32.5');
INSERT INTO `wp_79e54b1ec2_postmeta` VALUES ('430','96','_wp_page_template','default');
INSERT INTO `wp_79e54b1ec2_postmeta` VALUES ('431','96','_elementor_page_settings','a:27:{s:32:\"colors_enable_styleguide_preview\";s:3:\"yes\";s:13:\"system_colors\";a:4:{i:0;a:3:{s:3:\"_id\";s:7:\"primary\";s:5:\"title\";s:7:\"Primary\";s:5:\"color\";s:7:\"#282C31\";}i:1;a:3:{s:3:\"_id\";s:9:\"secondary\";s:5:\"title\";s:9:\"Secondary\";s:5:\"color\";s:7:\"#ECEEA3\";}i:2;a:3:{s:3:\"_id\";s:4:\"text\";s:5:\"title\";s:4:\"Text\";s:5:\"color\";s:7:\"#7A7A7A\";}i:3;a:3:{s:3:\"_id\";s:6:\"accent\";s:5:\"title\";s:6:\"Accent\";s:5:\"color\";s:7:\"#FF6A00\";}}s:13:\"custom_colors\";a:2:{i:0;a:3:{s:3:\"_id\";s:7:\"4e8747b\";s:5:\"title\";s:10:\"Background\";s:5:\"color\";s:7:\"#F5F5F5\";}i:1;a:3:{s:3:\"_id\";s:7:\"5ee12b7\";s:5:\"title\";s:13:\"Background #2\";s:5:\"color\";s:7:\"#ECEEA5\";}}s:17:\"system_typography\";a:4:{i:0;a:13:{s:3:\"_id\";s:7:\"primary\";s:5:\"title\";s:10:\"H1 Heading\";s:21:\"typography_typography\";s:6:\"custom\";s:22:\"typography_font_family\";s:7:\"Manrope\";s:22:\"typography_font_weight\";s:3:\"600\";s:20:\"typography_font_size\";a:3:{s:4:\"unit\";s:2:\"px\";s:4:\"size\";i:65;s:5:\"sizes\";a:0:{}}s:25:\"typography_text_transform\";s:4:\"none\";s:21:\"typography_font_style\";s:6:\"normal\";s:26:\"typography_text_decoration\";s:4:\"none\";s:22:\"typography_line_height\";a:3:{s:4:\"unit\";s:2:\"em\";s:4:\"size\";d:1.4;s:5:\"sizes\";a:0:{}}s:27:\"typography_font_size_tablet\";a:3:{s:4:\"unit\";s:2:\"px\";s:4:\"size\";i:55;s:5:\"sizes\";a:0:{}}s:27:\"typography_font_size_mobile\";a:3:{s:4:\"unit\";s:2:\"px\";s:4:\"size\";i:42;s:5:\"sizes\";a:0:{}}s:25:\"typography_letter_spacing\";a:3:{s:4:\"unit\";s:2:\"px\";s:4:\"size\";i:0;s:5:\"sizes\";a:0:{}}}i:1;a:13:{s:3:\"_id\";s:9:\"secondary\";s:5:\"title\";s:10:\"H2 Heading\";s:21:\"typography_typography\";s:6:\"custom\";s:22:\"typography_font_family\";s:7:\"Manrope\";s:22:\"typography_font_weight\";s:3:\"600\";s:20:\"typography_font_size\";a:3:{s:4:\"unit\";s:2:\"px\";s:4:\"size\";i:50;s:5:\"sizes\";a:0:{}}s:25:\"typography_text_transform\";s:4:\"none\";s:21:\"typography_font_style\";s:6:\"normal\";s:26:\"typography_text_decoration\";s:4:\"none\";s:22:\"typography_line_height\";a:3:{s:4:\"unit\";s:2:\"em\";s:4:\"size\";d:1.4;s:5:\"sizes\";a:0:{}}s:27:\"typography_font_size_tablet\";a:3:{s:4:\"unit\";s:2:\"px\";s:4:\"size\";i:42;s:5:\"sizes\";a:0:{}}s:27:\"typography_font_size_mobile\";a:3:{s:4:\"unit\";s:2:\"px\";s:4:\"size\";i:37;s:5:\"sizes\";a:0:{}}s:25:\"typography_letter_spacing\";a:3:{s:4:\"unit\";s:2:\"px\";s:4:\"size\";i:0;s:5:\"sizes\";a:0:{}}}i:2;a:13:{s:3:\"_id\";s:4:\"text\";s:5:\"title\";s:4:\"Text\";s:21:\"typography_typography\";s:6:\"custom\";s:22:\"typography_font_family\";s:7:\"Manrope\";s:22:\"typography_font_weight\";s:3:\"500\";s:20:\"typography_font_size\";a:3:{s:4:\"unit\";s:2:\"px\";s:4:\"size\";i:15;s:5:\"sizes\";a:0:{}}s:25:\"typography_text_transform\";s:4:\"none\";s:21:\"typography_font_style\";s:6:\"normal\";s:26:\"typography_text_decoration\";s:4:\"none\";s:22:\"typography_line_height\";a:3:{s:4:\"unit\";s:2:\"em\";s:4:\"size\";d:1.8;s:5:\"sizes\";a:0:{}}s:27:\"typography_font_size_tablet\";a:3:{s:4:\"unit\";s:2:\"px\";s:4:\"size\";i:14;s:5:\"sizes\";a:0:{}}s:27:\"typography_font_size_mobile\";a:3:{s:4:\"unit\";s:2:\"px\";s:4:\"size\";i:14;s:5:\"sizes\";a:0:{}}s:25:\"typography_letter_spacing\";a:3:{s:4:\"unit\";s:2:\"px\";s:4:\"size\";i:0;s:5:\"sizes\";a:0:{}}}i:3;a:12:{s:3:\"_id\";s:6:\"accent\";s:5:\"title\";s:6:\"Button\";s:21:\"typography_typography\";s:6:\"custom\";s:22:\"typography_font_family\";s:7:\"Manrope\";s:22:\"typography_font_weight\";s:3:\"600\";s:20:\"typography_font_size\";a:3:{s:4:\"unit\";s:2:\"px\";s:4:\"size\";i:13;s:5:\"sizes\";a:0:{}}s:25:\"typography_text_transform\";s:4:\"none\";s:21:\"typography_font_style\";s:6:\"normal\";s:26:\"typography_text_decoration\";s:4:\"none\";s:27:\"typography_font_size_tablet\";a:3:{s:4:\"unit\";s:2:\"px\";s:4:\"size\";i:12;s:5:\"sizes\";a:0:{}}s:27:\"typography_font_size_mobile\";a:3:{s:4:\"unit\";s:2:\"px\";s:4:\"size\";i:12;s:5:\"sizes\";a:0:{}}s:25:\"typography_letter_spacing\";a:3:{s:4:\"unit\";s:2:\"px\";s:4:\"size\";i:0;s:5:\"sizes\";a:0:{}}}}s:17:\"custom_typography\";a:7:{i:0;a:13:{s:21:\"typography_typography\";s:6:\"custom\";s:22:\"typography_font_family\";s:7:\"Manrope\";s:20:\"typography_font_size\";a:3:{s:4:\"unit\";s:2:\"px\";s:4:\"size\";i:32;s:5:\"sizes\";a:0:{}}s:27:\"typography_font_size_tablet\";a:3:{s:4:\"unit\";s:2:\"px\";s:4:\"size\";i:30;s:5:\"sizes\";a:0:{}}s:27:\"typography_font_size_mobile\";a:3:{s:4:\"unit\";s:2:\"px\";s:4:\"size\";i:28;s:5:\"sizes\";a:0:{}}s:22:\"typography_font_weight\";s:3:\"600\";s:25:\"typography_text_transform\";s:4:\"none\";s:21:\"typography_font_style\";s:6:\"normal\";s:26:\"typography_text_decoration\";s:4:\"none\";s:22:\"typography_line_height\";a:3:{s:4:\"unit\";s:2:\"em\";s:4:\"size\";d:1.4;s:5:\"sizes\";a:0:{}}s:25:\"typography_letter_spacing\";a:3:{s:4:\"unit\";s:2:\"px\";s:4:\"size\";i:0;s:5:\"sizes\";a:0:{}}s:3:\"_id\";s:7:\"9a7b7f5\";s:5:\"title\";s:10:\"H3 Heading\";}i:1;a:13:{s:21:\"typography_typography\";s:6:\"custom\";s:22:\"typography_font_family\";s:7:\"Manrope\";s:20:\"typography_font_size\";a:3:{s:4:\"unit\";s:2:\"px\";s:4:\"size\";i:26;s:5:\"sizes\";a:0:{}}s:27:\"typography_font_size_tablet\";a:3:{s:4:\"unit\";s:2:\"px\";s:4:\"size\";i:24;s:5:\"sizes\";a:0:{}}s:27:\"typography_font_size_mobile\";a:3:{s:4:\"unit\";s:2:\"px\";s:4:\"size\";i:22;s:5:\"sizes\";a:0:{}}s:22:\"typography_font_weight\";s:3:\"600\";s:25:\"typography_text_transform\";s:4:\"none\";s:21:\"typography_font_style\";s:6:\"normal\";s:26:\"typography_text_decoration\";s:4:\"none\";s:22:\"typography_line_height\";a:3:{s:4:\"unit\";s:2:\"em\";s:4:\"size\";d:1.4;s:5:\"sizes\";a:0:{}}s:25:\"typography_letter_spacing\";a:3:{s:4:\"unit\";s:2:\"px\";s:4:\"size\";i:0;s:5:\"sizes\";a:0:{}}s:3:\"_id\";s:7:\"553bab4\";s:5:\"title\";s:10:\"H4 Heading\";}i:2;a:15:{s:21:\"typography_typography\";s:6:\"custom\";s:22:\"typography_font_family\";s:7:\"Manrope\";s:20:\"typography_font_size\";a:3:{s:4:\"unit\";s:2:\"px\";s:4:\"size\";i:23;s:5:\"sizes\";a:0:{}}s:27:\"typography_font_size_tablet\";a:3:{s:4:\"unit\";s:2:\"px\";s:4:\"size\";i:21;s:5:\"sizes\";a:0:{}}s:27:\"typography_font_size_mobile\";a:3:{s:4:\"unit\";s:2:\"px\";s:4:\"size\";i:20;s:5:\"sizes\";a:0:{}}s:22:\"typography_font_weight\";s:3:\"600\";s:25:\"typography_text_transform\";s:4:\"none\";s:21:\"typography_font_style\";s:6:\"normal\";s:26:\"typography_text_decoration\";s:4:\"none\";s:22:\"typography_line_height\";a:3:{s:4:\"unit\";s:2:\"em\";s:4:\"size\";d:1.5;s:5:\"sizes\";a:0:{}}s:29:\"typography_line_height_tablet\";a:3:{s:4:\"unit\";s:2:\"px\";s:4:\"size\";s:0:\"\";s:5:\"sizes\";a:0:{}}s:29:\"typography_line_height_mobile\";a:3:{s:4:\"unit\";s:2:\"px\";s:4:\"size\";s:0:\"\";s:5:\"sizes\";a:0:{}}s:25:\"typography_letter_spacing\";a:3:{s:4:\"unit\";s:2:\"px\";s:4:\"size\";i:0;s:5:\"sizes\";a:0:{}}s:3:\"_id\";s:7:\"dd834d5\";s:5:\"title\";s:10:\"H5 Heading\";}i:3;a:13:{s:21:\"typography_typography\";s:6:\"custom\";s:22:\"typography_font_family\";s:7:\"Manrope\";s:20:\"typography_font_size\";a:3:{s:4:\"unit\";s:2:\"px\";s:4:\"size\";i:19;s:5:\"sizes\";a:0:{}}s:27:\"typography_font_size_tablet\";a:3:{s:4:\"unit\";s:2:\"px\";s:4:\"size\";i:18;s:5:\"sizes\";a:0:{}}s:27:\"typography_font_size_mobile\";a:3:{s:4:\"unit\";s:2:\"px\";s:4:\"size\";i:17;s:5:\"sizes\";a:0:{}}s:22:\"typography_font_weight\";s:3:\"600\";s:25:\"typography_text_transform\";s:4:\"none\";s:21:\"typography_font_style\";s:6:\"normal\";s:26:\"typography_text_decoration\";s:4:\"none\";s:22:\"typography_line_height\";a:3:{s:4:\"unit\";s:2:\"em\";s:4:\"size\";d:1.6;s:5:\"sizes\";a:0:{}}s:25:\"typography_letter_spacing\";a:3:{s:4:\"unit\";s:2:\"px\";s:4:\"size\";i:0;s:5:\"sizes\";a:0:{}}s:3:\"_id\";s:7:\"95d9cf0\";s:5:\"title\";s:10:\"H6 Heading\";}i:4;a:12:{s:21:\"typography_typography\";s:6:\"custom\";s:22:\"typography_font_family\";s:7:\"Manrope\";s:20:\"typography_font_size\";a:3:{s:4:\"unit\";s:2:\"px\";s:4:\"size\";i:12;s:5:\"sizes\";a:0:{}}s:27:\"typography_font_size_tablet\";a:3:{s:4:\"unit\";s:2:\"px\";s:4:\"size\";i:11;s:5:\"sizes\";a:0:{}}s:27:\"typography_font_size_mobile\";a:3:{s:4:\"unit\";s:2:\"px\";s:4:\"size\";i:10;s:5:\"sizes\";a:0:{}}s:22:\"typography_font_weight\";s:3:\"700\";s:25:\"typography_text_transform\";s:9:\"uppercase\";s:21:\"typography_font_style\";s:6:\"normal\";s:26:\"typography_text_decoration\";s:4:\"none\";s:25:\"typography_letter_spacing\";a:3:{s:4:\"unit\";s:2:\"px\";s:4:\"size\";i:2;s:5:\"sizes\";a:0:{}}s:3:\"_id\";s:7:\"df05d6e\";s:5:\"title\";s:11:\"Accent Text\";}i:5;a:10:{s:21:\"typography_typography\";s:6:\"custom\";s:22:\"typography_font_family\";s:7:\"Manrope\";s:20:\"typography_font_size\";a:3:{s:4:\"unit\";s:2:\"px\";s:4:\"size\";i:14;s:5:\"sizes\";a:0:{}}s:22:\"typography_font_weight\";s:3:\"600\";s:25:\"typography_text_transform\";s:4:\"none\";s:21:\"typography_font_style\";s:6:\"normal\";s:26:\"typography_text_decoration\";s:4:\"none\";s:3:\"_id\";s:7:\"f4096ca\";s:5:\"title\";s:16:\"Header Menu Item\";s:25:\"typography_letter_spacing\";a:3:{s:4:\"unit\";s:2:\"px\";s:4:\"size\";i:0;s:5:\"sizes\";a:0:{}}}i:6;a:10:{s:21:\"typography_typography\";s:6:\"custom\";s:22:\"typography_font_family\";s:7:\"Manrope\";s:20:\"typography_font_size\";a:3:{s:4:\"unit\";s:2:\"px\";s:4:\"size\";i:14;s:5:\"sizes\";a:0:{}}s:22:\"typography_font_weight\";s:3:\"500\";s:25:\"typography_text_transform\";s:4:\"none\";s:21:\"typography_font_style\";s:6:\"normal\";s:26:\"typography_text_decoration\";s:4:\"none\";s:3:\"_id\";s:7:\"c350ccf\";s:5:\"title\";s:19:\"Header Submenu Item\";s:25:\"typography_letter_spacing\";a:3:{s:4:\"unit\";s:2:\"px\";s:4:\"size\";i:0;s:5:\"sizes\";a:0:{}}}}s:21:\"default_generic_fonts\";s:10:\"Sans-serif\";s:19:\"page_title_selector\";s:14:\"h1.entry-title\";s:27:\"hello_footer_copyright_text\";s:19:\"All rights reserved\";s:15:\"activeItemIndex\";i:1;s:11:\"viewport_md\";i:768;s:11:\"viewport_lg\";i:1025;s:26:\"body_background_background\";s:7:\"classic\";s:21:\"body_background_color\";s:7:\"#F5F5F5\";s:25:\"mobile_browser_background\";s:7:\"#F5F5F5\";s:36:\"typography_enable_styleguide_preview\";s:3:\"yes\";s:20:\"button_border_radius\";a:6:{s:4:\"unit\";s:2:\"px\";s:3:\"top\";s:2:\"30\";s:5:\"right\";s:2:\"30\";s:6:\"bottom\";s:2:\"30\";s:4:\"left\";s:2:\"30\";s:8:\"isLinked\";b:1;}s:29:\"button_hover_background_color\";s:7:\"#E6BE42\";s:26:\"button_hover_border_radius\";a:6:{s:4:\"unit\";s:2:\"px\";s:3:\"top\";s:2:\"30\";s:5:\"right\";s:2:\"30\";s:6:\"bottom\";s:2:\"30\";s:4:\"left\";s:2:\"30\";s:8:\"isLinked\";b:1;}s:14:\"button_padding\";a:6:{s:4:\"unit\";s:2:\"px\";s:3:\"top\";s:2:\"14\";s:5:\"right\";s:2:\"30\";s:6:\"bottom\";s:2:\"14\";s:4:\"left\";s:2:\"30\";s:8:\"isLinked\";b:0;}s:27:\"form_field_background_color\";s:9:\"#02010100\";s:24:\"form_field_border_border\";s:5:\"solid\";s:23:\"form_field_border_width\";a:6:{s:4:\"unit\";s:2:\"px\";s:3:\"top\";s:1:\"1\";s:5:\"right\";s:1:\"1\";s:6:\"bottom\";s:1:\"1\";s:4:\"left\";s:1:\"1\";s:8:\"isLinked\";b:1;}s:23:\"form_field_border_color\";s:9:\"#282C3130\";s:24:\"form_field_border_radius\";a:6:{s:4:\"unit\";s:2:\"px\";s:3:\"top\";s:2:\"30\";s:5:\"right\";s:2:\"30\";s:6:\"bottom\";s:2:\"30\";s:4:\"left\";s:2:\"30\";s:8:\"isLinked\";b:1;}s:30:\"form_field_focus_border_border\";s:5:\"solid\";s:29:\"form_field_focus_border_color\";s:9:\"#282C3150\";s:11:\"__globals__\";a:24:{s:17:\"button_text_color\";s:25:\"globals/colors?id=primary\";s:23:\"button_background_color\";s:24:\"globals/colors?id=accent\";s:23:\"button_hover_text_color\";s:25:\"globals/colors?id=primary\";s:28:\"button_typography_typography\";s:28:\"globals/typography?id=accent\";s:10:\"body_color\";s:22:\"globals/colors?id=text\";s:26:\"body_typography_typography\";s:26:\"globals/typography?id=text\";s:17:\"link_normal_color\";s:22:\"globals/colors?id=text\";s:16:\"link_hover_color\";s:25:\"globals/colors?id=primary\";s:8:\"h1_color\";s:25:\"globals/colors?id=primary\";s:24:\"h1_typography_typography\";s:29:\"globals/typography?id=primary\";s:8:\"h2_color\";s:25:\"globals/colors?id=primary\";s:24:\"h2_typography_typography\";s:31:\"globals/typography?id=secondary\";s:8:\"h3_color\";s:25:\"globals/colors?id=primary\";s:24:\"h3_typography_typography\";s:29:\"globals/typography?id=9a7b7f5\";s:8:\"h4_color\";s:25:\"globals/colors?id=primary\";s:24:\"h4_typography_typography\";s:29:\"globals/typography?id=553bab4\";s:8:\"h5_color\";s:25:\"globals/colors?id=primary\";s:24:\"h5_typography_typography\";s:29:\"globals/typography?id=dd834d5\";s:8:\"h6_color\";s:25:\"globals/colors?id=primary\";s:24:\"h6_typography_typography\";s:29:\"globals/typography?id=95d9cf0\";s:16:\"form_label_color\";s:25:\"globals/colors?id=primary\";s:32:\"form_label_typography_typography\";s:28:\"globals/typography?id=accent\";s:32:\"form_field_typography_typography\";s:26:\"globals/typography?id=text\";s:21:\"form_field_text_color\";s:22:\"globals/colors?id=text\";}}');
INSERT INTO `wp_79e54b1ec2_postmeta` VALUES ('432','96','_elementor_data','[]');
INSERT INTO `wp_79e54b1ec2_postmeta` VALUES ('507','106','_wp_page_template','elementor_canvas');
INSERT INTO `wp_79e54b1ec2_postmeta` VALUES ('508','106','metform_form__form_setting','a:137:{s:10:\"form_title\";s:21:\"New Form # 1761608650\";s:9:\"form_type\";s:12:\"general-form\";s:15:\"success_message\";s:39:\"Thank you! Form submitted successfully.\";s:12:\"quiz_summery\";s:0:\"\";s:13:\"store_entries\";s:1:\"1\";s:11:\"entry_title\";s:0:\"\";s:26:\"hide_form_after_submission\";s:0:\"\";s:11:\"redirect_to\";s:0:\"\";s:11:\"success_url\";s:0:\"\";s:17:\"failed_cancel_url\";s:0:\"\";s:13:\"require_login\";s:0:\"\";s:26:\"limit_total_entries_status\";s:0:\"\";s:19:\"limit_total_entries\";s:0:\"\";s:11:\"count_views\";s:0:\"\";s:26:\"mf_stop_vertical_scrolling\";s:0:\"\";s:19:\"multiple_submission\";s:0:\"\";s:16:\"enable_recaptcha\";s:0:\"\";s:25:\"capture_user_browser_data\";s:0:\"\";s:24:\"enable_user_notification\";s:0:\"\";s:18:\"user_email_subject\";s:0:\"\";s:15:\"user_email_from\";s:0:\"\";s:19:\"user_email_reply_to\";s:0:\"\";s:15:\"user_email_body\";s:0:\"\";s:33:\"user_email_attach_submission_copy\";s:0:\"\";s:25:\"enable_admin_notification\";s:0:\"\";s:19:\"admin_email_subject\";s:0:\"\";s:16:\"admin_email_from\";s:0:\"\";s:14:\"admin_email_to\";s:0:\"\";s:20:\"admin_email_reply_to\";s:0:\"\";s:16:\"admin_email_body\";s:0:\"\";s:34:\"admin_email_attach_submission_copy\";s:0:\"\";s:13:\"mf_mail_chimp\";s:0:\"\";s:15:\"mf_get_response\";s:0:\"\";s:22:\"mf_get_reponse_api_key\";s:0:\"\";s:23:\"mf_get_response_list_id\";s:0:\"\";s:11:\"mf_automizy\";s:0:\"\";s:21:\"mf_automizy_api_token\";s:0:\"\";s:19:\"mf_automizy_list_id\";s:0:\"\";s:11:\"mf_rest_api\";s:0:\"\";s:15:\"mf_rest_api_url\";s:0:\"\";s:18:\"mf_rest_api_method\";s:0:\"\";s:20:\"mf_mailchimp_api_key\";s:0:\"\";s:26:\"mf_active_campaign_api_key\";s:0:\"\";s:22:\"mf_active_campaign_url\";s:0:\"\";s:20:\"mf_mailchimp_list_id\";s:0:\"\";s:9:\"mf_zapier\";s:0:\"\";s:17:\"mf_zapier_webhook\";s:0:\"\";s:8:\"mf_slack\";s:0:\"\";s:16:\"mf_slack_webhook\";s:0:\"\";s:9:\"mf_fluent\";s:0:\"\";s:17:\"mf_fluent_webhook\";s:0:\"\";s:17:\"mf_thank_you_page\";s:0:\"\";s:14:\"mf_cancel_page\";s:0:\"\";s:9:\"mf_paypal\";s:0:\"\";s:19:\"mf_payment_currency\";s:0:\"\";s:15:\"mf_paypal_email\";s:0:\"\";s:15:\"mf_paypal_token\";s:0:\"\";s:17:\"mf_paypal_sandbox\";s:0:\"\";s:9:\"mf_stripe\";s:0:\"\";s:19:\"mf_stripe_image_url\";s:0:\"\";s:31:\"mf_stripe_live_publishiable_key\";s:0:\"\";s:25:\"mf_stripe_live_secret_key\";s:0:\"\";s:17:\"mf_stripe_sandbox\";s:0:\"\";s:31:\"mf_stripe_test_publishiable_key\";s:0:\"\";s:25:\"mf_stripe_test_secret_key\";s:0:\"\";s:21:\"mf_google_map_api_key\";s:0:\"\";s:16:\"mf_save_progress\";s:0:\"\";s:18:\"mf_field_name_show\";s:0:\"\";s:12:\"mf_recaptcha\";s:0:\"\";s:20:\"mf_recaptcha_version\";s:0:\"\";s:21:\"mf_recaptcha_site_key\";s:0:\"\";s:23:\"mf_recaptcha_secret_key\";s:0:\"\";s:24:\"mf_recaptcha_site_key_v3\";s:0:\"\";s:26:\"mf_recaptcha_secret_key_v3\";s:0:\"\";s:14:\"mf_convert_kit\";s:0:\"\";s:15:\"mf_ckit_list_id\";s:0:\"\";s:15:\"mf_ckit_api_key\";s:0:\"\";s:15:\"mf_ckit_sec_key\";s:0:\"\";s:21:\"mf_aweber_dev_api_key\";s:0:\"\";s:21:\"mf_aweber_dev_api_sec\";s:0:\"\";s:14:\"mf_mail_aweber\";s:0:\"\";s:17:\"mf_aweber_list_id\";s:0:\"\";s:18:\"mf_active_campaign\";s:0:\"\";s:26:\"mf_active_campaign_list_id\";s:0:\"\";s:25:\"mf_active_campaign_tag_id\";s:0:\"\";s:12:\"mf_mail_poet\";s:0:\"\";s:20:\"mf_mail_poet_list_id\";s:0:\"\";s:10:\"mf_hubspot\";s:0:\"\";s:16:\"mf_hubspot_forms\";s:0:\"\";s:16:\"mf_hubsopt_token\";s:0:\"\";s:24:\"mf_hubsopt_refresh_token\";s:0:\"\";s:21:\"mf_hubsopt_token_type\";s:0:\"\";s:21:\"mf_hubsopt_expires_in\";s:0:\"\";s:20:\"mf_hubspot_form_guid\";s:0:\"\";s:24:\"mf_hubspot_form_portalId\";s:0:\"\";s:7:\"mf_zoho\";s:0:\"\";s:13:\"mf_zoho_token\";s:0:\"\";s:15:\"mf_registration\";s:0:\"\";s:8:\"mf_login\";s:0:\"\";s:15:\"mf_form_to_post\";s:0:\"\";s:11:\"mf_mailster\";s:0:\"\";s:19:\"mf_mailster_list_id\";s:0:\"\";s:18:\"mf_mailster_fields\";s:0:\"\";s:28:\"mf_post_submission_post_type\";s:0:\"\";s:24:\"mf_post_submission_title\";s:0:\"\";s:26:\"mf_post_submission_content\";s:0:\"\";s:25:\"mf_post_submission_author\";s:0:\"\";s:33:\"mf_post_submission_featured_image\";s:0:\"\";s:12:\"mf_helpscout\";s:0:\"\";s:19:\"mf_helpscout_app_id\";s:0:\"\";s:23:\"mf_helpscout_app_secret\";s:0:\"\";s:18:\"mf_helpscout_token\";s:0:\"\";s:20:\"mf_helpscout_mailbox\";s:0:\"\";s:33:\"mf_helpscout_conversation_subject\";s:0:\"\";s:40:\"mf_helpscout_conversation_customer_email\";s:0:\"\";s:45:\"mf_helpscout_conversation_customer_first_name\";s:0:\"\";s:44:\"mf_helpscout_conversation_customer_last_name\";s:0:\"\";s:42:\"mf_helpscout_conversation_customer_message\";s:0:\"\";s:15:\"mf_google_sheet\";s:0:\"\";s:30:\"mf_google_spreadsheets_list_id\";s:0:\"\";s:24:\"mf_google_sheets_list_id\";s:0:\"\";s:25:\"mf_google_sheet_client_id\";s:0:\"\";s:29:\"mf_google_sheet_client_secret\";s:0:\"\";s:25:\"email_verification_enable\";s:0:\"\";s:32:\"email_verification_email_subject\";s:0:\"\";s:35:\"email_verification_confirm_redirect\";s:0:\"\";s:26:\"email_verification_heading\";s:0:\"\";s:28:\"email_verification_paragraph\";s:0:\"\";s:13:\"mf_sms_status\";s:0:\"\";s:11:\"mf_sms_from\";s:0:\"\";s:25:\"mf_sms_twilio_account_sid\";s:0:\"\";s:24:\"mf_sms_twilio_auth_token\";s:0:\"\";s:18:\"mf_sms_user_status\";s:0:\"\";s:16:\"mf_sms_user_body\";s:0:\"\";s:19:\"mf_sms_admin_status\";s:0:\"\";s:17:\"mf_sms_admin_body\";s:0:\"\";s:15:\"mf_sms_admin_to\";s:0:\"\";}');
INSERT INTO `wp_79e54b1ec2_postmeta` VALUES ('509','106','_elementor_edit_mode','builder');
INSERT INTO `wp_79e54b1ec2_postmeta` VALUES ('510','106','_metform_cloned_id','template-1');
INSERT INTO `wp_79e54b1ec2_postmeta` VALUES ('511','106','_elementor_data','[{\"id\":\"8772510\",\"elType\":\"container\",\"settings\":{\"background_color\":\"#ffffff\",\"box_shadow_box_shadow\":{\"horizontal\":0,\"vertical\":30,\"blur\":50,\"spread\":0,\"color\":\"rgba(3.0000000000000053, 12.000000000000005, 35, 0.08)\"},\"padding\":{\"unit\":\"px\",\"top\":\"20\",\"right\":\"20\",\"bottom\":\"20\",\"left\":\"20\",\"isLinked\":true},\"padding_tablet\":{\"unit\":\"px\",\"top\":\"45\",\"right\":\"15\",\"bottom\":\"45\",\"left\":\"15\",\"isLinked\":false},\"content_width\":\"full\",\"ekit_all_conditions_list\":[{\"_id\":\"2bde398\"}],\"ekit_section_parallax_multi_items\":[],\"flex_direction\":\"row\",\"flex_align_items\":\"stretch\",\"flex_gap\":{\"size\":20,\"column\":\"20\",\"row\":\"20\",\"unit\":\"px\",\"isLinked\":true},\"flex_wrap\":\"wrap\"},\"elements\":[{\"id\":\"6ccabde\",\"elType\":\"widget\",\"settings\":{\"title\":\"GET A FREE QUOTE \",\"header_size\":\"h3\",\"typography_typography\":\"custom\",\"typography_font_family\":\"IBM Plex Sans\",\"typography_font_size\":{\"unit\":\"px\",\"size\":26,\"sizes\":[]},\"typography_font_weight\":\"700\",\"typography_line_height\":{\"unit\":\"px\",\"size\":34,\"sizes\":[]},\"typography_line_height_tablet\":{\"unit\":\"px\",\"size\":\"\",\"sizes\":[]},\"typography_line_height_mobile\":{\"unit\":\"px\",\"size\":\"\",\"sizes\":[]},\"_padding\":{\"unit\":\"px\",\"top\":\"12\",\"right\":\"15\",\"bottom\":\"8\",\"left\":\"0\",\"isLinked\":false},\"ekit_all_conditions_list\":[{\"_id\":\"63c841d\"}],\"ekit_adv_tooltip_content\":\"Tooltip Content.\",\"align\":\"center\",\"_element_width\":\"inherit\",\"__globals__\":{\"title_color\":\"\"},\"title_color\":\"#000000\"},\"elements\":[],\"widgetType\":\"heading\"},{\"id\":\"e3f0881\",\"elType\":\"container\",\"settings\":{\"structure\":\"20\",\"content_width\":\"full\",\"ekit_all_conditions_list\":[{\"_id\":\"0fbbc40\"}],\"ekit_section_parallax_multi_items\":[],\"flex_direction\":\"row\",\"flex_align_items\":\"stretch\",\"flex_gap\":{\"size\":10,\"column\":\"10\",\"row\":\"10\",\"unit\":\"px\"},\"container_type\":\"grid\",\"grid_columns_grid\":{\"unit\":\"fr\",\"size\":2,\"sizes\":[]},\"grid_rows_grid\":{\"unit\":\"fr\",\"size\":1,\"sizes\":[]},\"grid_gaps\":{\"column\":\"30\",\"row\":\"20\",\"isLinked\":false,\"unit\":\"px\"},\"metform_multistep_settings_title\":\"\",\"metform_multistep_settings_icon\":{\"value\":\"\",\"library\":\"\"},\"padding\":{\"unit\":\"px\",\"top\":\"0\",\"right\":\"0\",\"bottom\":\"0\",\"left\":\"0\",\"isLinked\":false},\"presetTitle\":\"Grid\",\"presetIcon\":\"eicon-container-grid\"},\"elements\":[{\"id\":\"3c6bdf6\",\"elType\":\"widget\",\"settings\":{\"mf_input_label\":\"First Name\",\"mf_input_name\":\"mf-first-name\",\"mf_input_placeholder\":\"Name \",\"mf_input_label_typography_typography\":\"custom\",\"mf_input_label_typography_font_family\":\"IBM Plex Sans\",\"mf_input_label_typography_font_size\":{\"unit\":\"px\",\"size\":16,\"sizes\":[]},\"mf_input_label_typography_font_weight\":\"500\",\"mf_input_label_typography_line_height\":{\"unit\":\"px\",\"size\":21,\"sizes\":[]},\"mf_input_min_length\":1,\"mf_input_label_color\":\"#0D1427\",\"mf_input_label_margin\":{\"unit\":\"px\",\"top\":\"0\",\"right\":\"0\",\"bottom\":\"7\",\"left\":\"0\",\"isLinked\":false},\"mf_input_padding\":{\"unit\":\"px\",\"top\":\"15\",\"right\":\"24\",\"bottom\":\"17\",\"left\":\"24\",\"isLinked\":false},\"mf_input_border_border\":\"solid\",\"mf_input_border_width\":{\"unit\":\"px\",\"top\":\"1\",\"right\":\"1\",\"bottom\":\"1\",\"left\":\"1\",\"isLinked\":true},\"mf_input_border_color\":\"#EAECF1\",\"mf_input_typgraphy_typography\":\"custom\",\"mf_input_typgraphy_font_family\":\"IBM Plex Sans\",\"mf_input_typgraphy_font_size\":{\"unit\":\"px\",\"size\":14,\"sizes\":[]},\"mf_input_typgraphy_font_weight\":\"400\",\"mf_input_typgraphy_line_height\":{\"unit\":\"px\",\"size\":18,\"sizes\":[]},\"mf_input_border_radius\":{\"unit\":\"px\",\"size\":6,\"sizes\":[]},\"mf_input_place_holder_typography_typography\":\"custom\",\"mf_input_place_holder_typography_font_family\":\"IBM Plex Sans\",\"mf_input_place_holder_typography_font_weight\":\"400\",\"mf_input_placeholder_color\":\"#878991\",\"mf_input_required\":\"yes\",\"mf_input_validation_warning_message\":\"This field is required.\",\"mf_conditional_logic_form_list\":[],\"mf_input_label_typography_line_height_tablet\":{\"unit\":\"px\",\"size\":\"\",\"sizes\":[]},\"mf_input_label_typography_line_height_mobile\":{\"unit\":\"px\",\"size\":\"\",\"sizes\":[]},\"mf_input_background_background\":\"classic\",\"mf_input_background_color\":\"#F6F7FA\",\"mf_input_background_hover_color\":\"#FFFFFF\",\"mf_input_background_focus_background\":\"classic\",\"mf_input_background_focus_color\":\"#FFFFFF\",\"mf_input_typgraphy_line_height_tablet\":{\"unit\":\"px\",\"size\":\"\",\"sizes\":[]},\"mf_input_typgraphy_line_height_mobile\":{\"unit\":\"px\",\"size\":\"\",\"sizes\":[]},\"mf_input_typgraphy_word_spacing_tablet\":{\"unit\":\"px\",\"size\":\"\",\"sizes\":[]},\"mf_input_typgraphy_word_spacing_mobile\":{\"unit\":\"px\",\"size\":\"\",\"sizes\":[]},\"mf_input_place_holder_typography_font_size\":{\"unit\":\"px\",\"size\":14,\"sizes\":[]},\"mf_input_place_holder_typography_line_height\":{\"unit\":\"px\",\"size\":18,\"sizes\":[]},\"mf_input_place_holder_typography_line_height_tablet\":{\"unit\":\"px\",\"size\":\"\",\"sizes\":[]},\"mf_input_place_holder_typography_line_height_mobile\":{\"unit\":\"px\",\"size\":\"\",\"sizes\":[]},\"ekit_all_conditions_list\":[{\"_id\":\"30812ac\"}],\"ekit_adv_tooltip_content\":\"Tooltip Content.\",\"mf_input_color\":\"#0D1427\",\"mf_input_border_focus_border\":\"solid\",\"mf_input_border_focus_color\":\"#D6D8E0\",\"mf_input_help_text_typography_typography\":\"custom\",\"mf_input_help_text_typography_font_family\":\"IBM Plex Sans\",\"mf_input_help_text_typography_font_size\":{\"unit\":\"px\",\"size\":13,\"sizes\":[]},\"mf_input_help_text_typography_font_weight\":\"400\",\"mf_input_help_text_typography_line_height\":{\"unit\":\"px\",\"size\":17,\"sizes\":[]},\"mf_input_help_text_typography_line_height_tablet\":{\"unit\":\"px\",\"size\":\"\",\"sizes\":[]},\"mf_input_help_text_typography_line_height_mobile\":{\"unit\":\"px\",\"size\":\"\",\"sizes\":[]},\"mf_input_help_text_color\":\"#96989F\",\"__globals__\":{\"mf_input_required_indicator_color\":\"\",\"mf_input_warning_text_color\":\"\"},\"mf_input_warning_text_typography_typography\":\"custom\",\"mf_input_warning_text_typography_font_family\":\"Roboto\",\"mf_input_warning_text_typography_font_weight\":\"600\",\"mf_input_label_status\":\"\"},\"elements\":[],\"widgetType\":\"mf-text\"},{\"id\":\"e3cc527\",\"elType\":\"widget\",\"settings\":{\"mf_input_label\":\"Email Address\",\"mf_input_name\":\"mf-email\",\"mf_input_placeholder\":\"Email\",\"mf_input_required\":\"yes\",\"mf_input_label_color\":\"#0D1427\",\"mf_input_label_typography_typography\":\"custom\",\"mf_input_label_typography_font_family\":\"IBM Plex Sans\",\"mf_input_label_typography_font_size\":{\"unit\":\"px\",\"size\":16,\"sizes\":[]},\"mf_input_label_typography_font_weight\":\"500\",\"mf_input_label_typography_line_height\":{\"unit\":\"px\",\"size\":21,\"sizes\":[]},\"mf_input_label_margin\":{\"unit\":\"px\",\"top\":\"0\",\"right\":\"0\",\"bottom\":\"7\",\"left\":\"0\",\"isLinked\":false},\"mf_input_padding\":{\"unit\":\"px\",\"top\":\"15\",\"right\":\"24\",\"bottom\":\"17\",\"left\":\"24\",\"isLinked\":false},\"mf_input_border_border\":\"solid\",\"mf_input_border_width\":{\"unit\":\"px\",\"top\":\"1\",\"right\":\"1\",\"bottom\":\"1\",\"left\":\"1\",\"isLinked\":true},\"mf_input_border_color\":\"#EAECF1\",\"mf_input_typgraphy_typography\":\"custom\",\"mf_input_typgraphy_font_family\":\"IBM Plex Sans\",\"mf_input_typgraphy_font_size\":{\"unit\":\"px\",\"size\":14,\"sizes\":[]},\"mf_input_typgraphy_font_weight\":\"400\",\"mf_input_typgraphy_line_height\":{\"unit\":\"px\",\"size\":18,\"sizes\":[]},\"mf_input_border_radius\":{\"unit\":\"px\",\"size\":6,\"sizes\":[]},\"mf_input_place_holder_typography_typography\":\"custom\",\"mf_input_place_holder_typography_font_family\":\"IBM Plex Sans\",\"mf_input_place_holder_typography_font_weight\":\"400\",\"mf_input_placeholder_color\":\"#878991\",\"mf_input_validation_warning_message\":\"This field is required.\",\"mf_conditional_logic_form_list\":[],\"mf_input_label_typography_line_height_tablet\":{\"unit\":\"px\",\"size\":\"\",\"sizes\":[]},\"mf_input_label_typography_line_height_mobile\":{\"unit\":\"px\",\"size\":\"\",\"sizes\":[]},\"mf_input_background_background\":\"classic\",\"mf_input_background_color\":\"#F6F7FA\",\"mf_input_background_hover_color\":\"#FFFFFF\",\"mf_input_background_focus_background\":\"classic\",\"mf_input_background_focus_color\":\"#FFFFFF\",\"mf_input_typgraphy_line_height_tablet\":{\"unit\":\"px\",\"size\":\"\",\"sizes\":[]},\"mf_input_typgraphy_line_height_mobile\":{\"unit\":\"px\",\"size\":\"\",\"sizes\":[]},\"mf_input_typgraphy_word_spacing_tablet\":{\"unit\":\"px\",\"size\":\"\",\"sizes\":[]},\"mf_input_typgraphy_word_spacing_mobile\":{\"unit\":\"px\",\"size\":\"\",\"sizes\":[]},\"mf_input_place_holder_typography_font_size\":{\"unit\":\"px\",\"size\":14,\"sizes\":[]},\"mf_input_place_holder_typography_line_height\":{\"unit\":\"px\",\"size\":18,\"sizes\":[]},\"mf_input_place_holder_typography_line_height_tablet\":{\"unit\":\"px\",\"size\":\"\",\"sizes\":[]},\"mf_input_place_holder_typography_line_height_mobile\":{\"unit\":\"px\",\"size\":\"\",\"sizes\":[]},\"ekit_all_conditions_list\":[{\"_id\":\"30812ac\"}],\"ekit_adv_tooltip_content\":\"Tooltip Content.\",\"mf_input_color\":\"#0D1427\",\"mf_input_border_focus_border\":\"solid\",\"mf_input_border_focus_color\":\"#D6D8E0\",\"mf_input_help_text_typography_typography\":\"custom\",\"mf_input_help_text_typography_font_family\":\"IBM Plex Sans\",\"mf_input_help_text_typography_font_size\":{\"unit\":\"px\",\"size\":13,\"sizes\":[]},\"mf_input_help_text_typography_font_weight\":\"400\",\"mf_input_help_text_typography_line_height\":{\"unit\":\"px\",\"size\":17,\"sizes\":[]},\"mf_input_help_text_typography_line_height_tablet\":{\"unit\":\"px\",\"size\":\"\",\"sizes\":[]},\"mf_input_help_text_typography_line_height_mobile\":{\"unit\":\"px\",\"size\":\"\",\"sizes\":[]},\"mf_input_help_text_color\":\"#96989F\",\"__globals__\":{\"mf_input_required_indicator_color\":\"\",\"mf_input_warning_text_color\":\"\"},\"mf_input_label_status\":\"\"},\"elements\":[],\"widgetType\":\"mf-email\"},{\"id\":\"db2c920\",\"elType\":\"widget\",\"settings\":{\"mf_input_label_status\":\"\",\"mf_input_label\":\"Telephone\",\"mf_input_name\":\"mf-telephone\",\"mf_input_placeholder\":\"Phone Number\",\"mf_input_validation_warning_message\":\"This field is required.\",\"mf_input_label_color\":\"#0D1427\",\"mf_input_label_typography_typography\":\"custom\",\"mf_input_label_typography_font_family\":\"IBM Plex Sans\",\"mf_input_label_typography_font_size\":{\"unit\":\"px\",\"size\":16,\"sizes\":[]},\"mf_input_label_typography_font_weight\":\"500\",\"mf_input_label_typography_line_height\":{\"unit\":\"px\",\"size\":21,\"sizes\":[]},\"mf_input_label_typography_line_height_tablet\":{\"unit\":\"px\",\"size\":\"\",\"sizes\":[]},\"mf_input_label_typography_line_height_mobile\":{\"unit\":\"px\",\"size\":\"\",\"sizes\":[]},\"mf_input_label_margin\":{\"unit\":\"px\",\"top\":\"0\",\"right\":\"0\",\"bottom\":\"7\",\"left\":\"0\",\"isLinked\":false},\"mf_input_padding\":{\"unit\":\"px\",\"top\":\"16\",\"right\":\"16\",\"bottom\":\"16\",\"left\":\"16\",\"isLinked\":true},\"mf_input_color\":\"#0D1427\",\"mf_input_background_background\":\"classic\",\"mf_input_background_color\":\"#F6F7FA\",\"mf_input_border_border\":\"solid\",\"mf_input_border_width\":{\"unit\":\"px\",\"top\":\"1\",\"right\":\"1\",\"bottom\":\"1\",\"left\":\"1\",\"isLinked\":true},\"mf_input_border_color\":\"#EAECF1\",\"mf_input_background_hover_color\":\"#FFFFFF\",\"mf_input_background_focus_background\":\"classic\",\"mf_input_background_focus_color\":\"#FFFFFF\",\"mf_input_border_focus_border\":\"solid\",\"mf_input_border_focus_color\":\"#D6D8E0\",\"mf_input_typgraphy_typography\":\"custom\",\"mf_input_typgraphy_font_family\":\"IBM Plex Sans\",\"mf_input_typgraphy_font_size\":{\"unit\":\"px\",\"size\":14,\"sizes\":[]},\"mf_input_typgraphy_font_weight\":\"400\",\"mf_input_typgraphy_line_height\":{\"unit\":\"px\",\"size\":18,\"sizes\":[]},\"mf_input_typgraphy_line_height_tablet\":{\"unit\":\"px\",\"size\":\"\",\"sizes\":[]},\"mf_input_typgraphy_line_height_mobile\":{\"unit\":\"px\",\"size\":\"\",\"sizes\":[]},\"mf_input_typgraphy_word_spacing_tablet\":{\"unit\":\"px\",\"size\":\"\",\"sizes\":[]},\"mf_input_typgraphy_word_spacing_mobile\":{\"unit\":\"px\",\"size\":\"\",\"sizes\":[]},\"mf_input_border_radius\":{\"unit\":\"px\",\"size\":6,\"sizes\":[]},\"mf_input_place_holder_typography_typography\":\"custom\",\"mf_input_place_holder_typography_font_family\":\"IBM Plex Sans\",\"mf_input_place_holder_typography_font_size\":{\"unit\":\"px\",\"size\":14,\"sizes\":[]},\"mf_input_place_holder_typography_font_weight\":\"400\",\"mf_input_place_holder_typography_line_height\":{\"unit\":\"px\",\"size\":18,\"sizes\":[]},\"mf_input_place_holder_typography_line_height_tablet\":{\"unit\":\"px\",\"size\":\"\",\"sizes\":[]},\"mf_input_place_holder_typography_line_height_mobile\":{\"unit\":\"px\",\"size\":\"\",\"sizes\":[]},\"mf_input_placeholder_color\":\"#878991\",\"mf_input_help_text_typography_typography\":\"custom\",\"mf_input_help_text_typography_font_family\":\"IBM Plex Sans\",\"mf_input_help_text_typography_font_size\":{\"unit\":\"px\",\"size\":13,\"sizes\":[]},\"mf_input_help_text_typography_font_weight\":\"400\",\"mf_input_help_text_typography_line_height\":{\"unit\":\"px\",\"size\":17,\"sizes\":[]},\"mf_input_help_text_typography_line_height_tablet\":{\"unit\":\"px\",\"size\":\"\",\"sizes\":[]},\"mf_input_help_text_typography_line_height_mobile\":{\"unit\":\"px\",\"size\":\"\",\"sizes\":[]},\"mf_input_help_text_color\":\"#96989F\",\"__globals__\":{\"mf_input_required_indicator_color\":\"\",\"mf_input_warning_text_color\":\"\"}},\"elements\":[],\"widgetType\":\"mf-telephone\"},{\"id\":\"f85f598\",\"elType\":\"widget\",\"settings\":{\"mf_input_label_status\":\"\",\"mf_input_label\":\"Select\",\"mf_input_name\":\"mf-select\",\"mf_input_placeholder\":\"Services\",\"mf_input_list\":[{\"mf_input_option_text\":\"Switch & Outlet Installation \",\"mf_input_option_value\":\"Switch & Outlet Installation \",\"_id\":\"b9d987e\"},{\"mf_input_option_text\":\"EV Charger Installation\",\"mf_input_option_value\":\"EV Charger Installation\",\"_id\":\"5e73d87\"},{\"mf_input_option_text\":\"Electrical Panel Upgrades & Repairs\",\"mf_input_option_value\":\"Electrical Panel Upgrades & Repairs\",\"_id\":\"78cbf13\"},{\"mf_input_option_text\":\"Generator Installation\",\"mf_input_option_value\":\"Generator Installation\",\"_id\":\"a695b6b\"},{\"mf_input_option_text\":\"Lighting Installation\",\"mf_input_option_value\":\"Lighting Installation\",\"_id\":\"93979ab\"},{\"mf_input_option_text\":\"Electrical Wiring \",\"mf_input_option_value\":\"Electrical Wiring \",\"_id\":\"b4744d0\"},{\"mf_input_option_text\":\"Electrical Inspections\",\"mf_input_option_value\":\"Electrical Inspections\",\"_id\":\"68a1a09\"}],\"mf_input_validation_warning_message\":\"This field is required.\",\"mf_input_label_color\":\"#0D1427\",\"mf_input_label_typography_typography\":\"custom\",\"mf_input_label_typography_font_family\":\"IBM Plex Sans\",\"mf_input_label_typography_font_size\":{\"unit\":\"px\",\"size\":16,\"sizes\":[]},\"mf_input_label_typography_font_weight\":\"500\",\"mf_input_label_typography_line_height\":{\"unit\":\"px\",\"size\":21,\"sizes\":[]},\"mf_input_label_typography_line_height_tablet\":{\"unit\":\"px\",\"size\":\"\",\"sizes\":[]},\"mf_input_label_typography_line_height_mobile\":{\"unit\":\"px\",\"size\":\"\",\"sizes\":[]},\"mf_input_label_margin\":{\"unit\":\"px\",\"top\":\"0\",\"right\":\"0\",\"bottom\":\"7\",\"left\":\"0\",\"isLinked\":false},\"mf_input_padding\":{\"unit\":\"px\",\"top\":\"13\",\"right\":\"13\",\"bottom\":\"13\",\"left\":\"13\",\"isLinked\":true},\"mf_input_color\":\"#0D1427\",\"mf_input_background_background\":\"classic\",\"mf_input_background_color\":\"#F6F7FA\",\"mf_input_border_border\":\"solid\",\"mf_input_border_width\":{\"unit\":\"px\",\"top\":\"1\",\"right\":\"1\",\"bottom\":\"1\",\"left\":\"1\",\"isLinked\":true},\"mf_input_border_color\":\"#EAECF1\",\"mf_input_background_hover_color\":\"#FFFFFF\",\"mf_input_background_focus_background\":\"classic\",\"mf_input_background_focus_color\":\"#FFFFFF\",\"mf_input_border_focus_border\":\"solid\",\"mf_input_border_focus_color\":\"#D6D8E0\",\"mf_input_typgraphy_typography\":\"custom\",\"mf_input_typgraphy_font_family\":\"IBM Plex Sans\",\"mf_input_typgraphy_font_size\":{\"unit\":\"px\",\"size\":14,\"sizes\":[]},\"mf_input_typgraphy_font_weight\":\"400\",\"mf_input_typgraphy_line_height\":{\"unit\":\"px\",\"size\":18,\"sizes\":[]},\"mf_input_typgraphy_line_height_tablet\":{\"unit\":\"px\",\"size\":\"\",\"sizes\":[]},\"mf_input_typgraphy_line_height_mobile\":{\"unit\":\"px\",\"size\":\"\",\"sizes\":[]},\"mf_input_typgraphy_word_spacing_tablet\":{\"unit\":\"px\",\"size\":\"\",\"sizes\":[]},\"mf_input_typgraphy_word_spacing_mobile\":{\"unit\":\"px\",\"size\":\"\",\"sizes\":[]},\"mf_input_border_radius\":{\"unit\":\"px\",\"size\":6,\"sizes\":[]},\"mf_input_place_holder_typography_typography\":\"custom\",\"mf_input_place_holder_typography_font_family\":\"IBM Plex Sans\",\"mf_input_place_holder_typography_font_size\":{\"unit\":\"px\",\"size\":14,\"sizes\":[]},\"mf_input_place_holder_typography_font_weight\":\"400\",\"mf_input_place_holder_typography_line_height\":{\"unit\":\"px\",\"size\":18,\"sizes\":[]},\"mf_input_place_holder_typography_line_height_tablet\":{\"unit\":\"px\",\"size\":\"\",\"sizes\":[]},\"mf_input_place_holder_typography_line_height_mobile\":{\"unit\":\"px\",\"size\":\"\",\"sizes\":[]},\"mf_input_placeholder_color\":\"#878991\",\"mf_input_help_text_typography_typography\":\"custom\",\"mf_input_help_text_typography_font_family\":\"IBM Plex Sans\",\"mf_input_help_text_typography_font_size\":{\"unit\":\"px\",\"size\":13,\"sizes\":[]},\"mf_input_help_text_typography_font_weight\":\"400\",\"mf_input_help_text_typography_line_height\":{\"unit\":\"px\",\"size\":17,\"sizes\":[]},\"mf_input_help_text_typography_line_height_tablet\":{\"unit\":\"px\",\"size\":\"\",\"sizes\":[]},\"mf_input_help_text_typography_line_height_mobile\":{\"unit\":\"px\",\"size\":\"\",\"sizes\":[]},\"mf_input_help_text_color\":\"#96989F\",\"__globals__\":{\"mf_input_required_indicator_color\":\"\",\"mf_input_warning_text_color\":\"\"}},\"elements\":[],\"widgetType\":\"mf-select\"}],\"isInner\":true},{\"id\":\"ebf7479\",\"elType\":\"widget\",\"settings\":{\"mf_input_label\":\"Comments \\/ Questions\",\"mf_input_name\":\"mf-comment\",\"mf_input_placeholder\":\"Comments\",\"mf_input_required\":\"yes\",\"mf_input_label_color\":\"#0D1427\",\"mf_input_label_typography_typography\":\"custom\",\"mf_input_label_typography_font_family\":\"IBM Plex Sans\",\"mf_input_label_typography_font_size\":{\"unit\":\"px\",\"size\":16,\"sizes\":[]},\"mf_input_label_typography_font_weight\":\"500\",\"mf_input_label_typography_line_height\":{\"unit\":\"px\",\"size\":21,\"sizes\":[]},\"mf_input_label_margin\":{\"unit\":\"px\",\"top\":\"0\",\"right\":\"0\",\"bottom\":\"7\",\"left\":\"0\",\"isLinked\":false},\"mf_input_padding\":{\"unit\":\"px\",\"top\":\"15\",\"right\":\"24\",\"bottom\":\"15\",\"left\":\"24\",\"isLinked\":false},\"mf_input_border_border\":\"solid\",\"mf_input_border_width\":{\"unit\":\"px\",\"top\":\"1\",\"right\":\"1\",\"bottom\":\"1\",\"left\":\"1\",\"isLinked\":true},\"mf_input_border_color\":\"#EAECF1\",\"mf_input_typgraphy_typography\":\"custom\",\"mf_input_typgraphy_font_family\":\"IBM Plex Sans\",\"mf_input_typgraphy_font_size\":{\"unit\":\"px\",\"size\":14,\"sizes\":[]},\"mf_input_typgraphy_font_weight\":\"400\",\"mf_input_typgraphy_line_height\":{\"unit\":\"px\",\"size\":18,\"sizes\":[]},\"mf_input_border_radius\":{\"unit\":\"px\",\"size\":6,\"sizes\":[]},\"mf_input_place_holder_typography_typography\":\"custom\",\"mf_input_place_holder_typography_font_family\":\"IBM Plex Sans\",\"mf_input_place_holder_typography_font_weight\":\"500\",\"mf_input_placeholder_color\":\"#878991\",\"mf_textarea_field_height\":{\"unit\":\"px\",\"size\":130,\"sizes\":[]},\"mf_input_validation_warning_message\":\"This field is required.\",\"mf_conditional_logic_form_list\":[],\"mf_input_label_typography_line_height_tablet\":{\"unit\":\"px\",\"size\":\"\",\"sizes\":[]},\"mf_input_label_typography_line_height_mobile\":{\"unit\":\"px\",\"size\":\"\",\"sizes\":[]},\"mf_input_background_background\":\"classic\",\"mf_input_background_color\":\"#F6F7FA\",\"mf_input_background_hover_color\":\"#FFFFFF\",\"mf_input_background_focus_background\":\"classic\",\"mf_input_background_focus_color\":\"#FFFFFF\",\"mf_input_typgraphy_line_height_tablet\":{\"unit\":\"px\",\"size\":\"\",\"sizes\":[]},\"mf_input_typgraphy_line_height_mobile\":{\"unit\":\"px\",\"size\":\"\",\"sizes\":[]},\"mf_input_place_holder_typography_font_size\":{\"unit\":\"px\",\"size\":14,\"sizes\":[]},\"mf_input_place_holder_typography_line_height\":{\"unit\":\"px\",\"size\":18,\"sizes\":[]},\"mf_input_place_holder_typography_line_height_tablet\":{\"unit\":\"px\",\"size\":\"\",\"sizes\":[]},\"mf_input_place_holder_typography_line_height_mobile\":{\"unit\":\"px\",\"size\":\"\",\"sizes\":[]},\"_margin\":{\"unit\":\"px\",\"top\":\"0\",\"right\":\"0\",\"bottom\":\"0\",\"left\":\"0\",\"isLinked\":false},\"ekit_all_conditions_list\":[{\"_id\":\"6609fcf\"}],\"ekit_adv_tooltip_content\":\"Tooltip Content.\",\"mf_input_color\":\"#0D1427\",\"mf_input_border_focus_border\":\"solid\",\"mf_input_border_focus_color\":\"#D6D8E0\",\"mf_input_help_text_typography_typography\":\"custom\",\"mf_input_help_text_typography_font_family\":\"IBM Plex Sans\",\"mf_input_help_text_typography_font_size\":{\"unit\":\"px\",\"size\":13,\"sizes\":[]},\"mf_input_help_text_typography_font_weight\":\"400\",\"mf_input_help_text_typography_line_height\":{\"unit\":\"px\",\"size\":17,\"sizes\":[]},\"mf_input_help_text_typography_line_height_tablet\":{\"unit\":\"px\",\"size\":\"\",\"sizes\":[]},\"mf_input_help_text_typography_line_height_mobile\":{\"unit\":\"px\",\"size\":\"\",\"sizes\":[]},\"mf_input_help_text_color\":\"#96989F\",\"__globals__\":{\"mf_input_required_indicator_color\":\"\",\"mf_input_warning_text_color\":\"\"},\"_element_width\":\"inherit\",\"mf_input_label_status\":\"\"},\"elements\":[],\"widgetType\":\"mf-textarea\"},{\"id\":\"5187588\",\"elType\":\"widget\",\"settings\":{\"mf_btn_text\":\"Send Message\",\"mf_btn_align\":\"\",\"mf_btn_text_padding\":{\"unit\":\"px\",\"top\":\"17\",\"right\":\"28\",\"bottom\":\"16\",\"left\":\"28\",\"isLinked\":false},\"mf_btn_typography_typography\":\"custom\",\"mf_btn_typography_font_family\":\"Roboto\",\"mf_btn_typography_font_size\":{\"unit\":\"px\",\"size\":14,\"sizes\":[]},\"mf_btn_typography_font_weight\":\"500\",\"mf_btn_typography_line_height\":{\"unit\":\"px\",\"size\":11,\"sizes\":[]},\"mf_btn_bg_color_background\":\"classic\",\"mf_btn_box_shadow_group_box_shadow_type\":\"yes\",\"mf_btn_box_shadow_group_box_shadow\":{\"horizontal\":0,\"vertical\":0,\"blur\":0,\"spread\":0,\"color\":\"rgba(0,0,0,0.5)\"},\"mf_conditional_logic_form_list\":[],\"mf_hidden_input\":[],\"mf_btn_typography_line_height_tablet\":{\"unit\":\"px\",\"size\":\"\",\"sizes\":[]},\"mf_btn_typography_line_height_mobile\":{\"unit\":\"px\",\"size\":\"\",\"sizes\":[]},\"mf_btn_text_color\":\"#FFFFFF\",\"mf_btn_bg_hover_color_background\":\"classic\",\"mf_btn_border_radius\":{\"unit\":\"px\",\"top\":\"8\",\"right\":\"8\",\"bottom\":\"8\",\"left\":\"8\",\"isLinked\":true},\"ekit_all_conditions_list\":[{\"_id\":\"eed14b8\"}],\"ekit_adv_tooltip_content\":\"Tooltip Content.\",\"_box_shadow_hover_box_shadow\":{\"horizontal\":0,\"vertical\":2,\"blur\":4,\"spread\":0,\"color\":\"rgba(2.9999999999999996, 28.00000000000002, 90, 0.4)\"},\"mf_btn_hover_color\":\"\",\"_element_width\":\"auto\",\"_border_radius\":{\"unit\":\"px\",\"top\":\"8\",\"right\":\"8\",\"bottom\":\"8\",\"left\":\"8\",\"isLinked\":true},\"_box_shadow_hover_box_shadow_type\":\"yes\",\"_margin\":{\"unit\":\"px\",\"top\":\"0\",\"right\":\"0\",\"bottom\":\"0\",\"left\":\"0\",\"isLinked\":false},\"__globals__\":{\"mf_btn_bg_color_color\":\"globals\\/colors?id=d49ac81\"}},\"elements\":[],\"widgetType\":\"mf-button\"}],\"isInner\":false}]');
INSERT INTO `wp_79e54b1ec2_postmeta` VALUES ('512','106','_post_views_count','1');
INSERT INTO `wp_79e54b1ec2_postmeta` VALUES ('513','106','ekit_post_views_count','4');
INSERT INTO `wp_79e54b1ec2_postmeta` VALUES ('514','106','_edit_lock','1761774020:2');
INSERT INTO `wp_79e54b1ec2_postmeta` VALUES ('517','107','_wp_page_template','elementor_canvas');
INSERT INTO `wp_79e54b1ec2_postmeta` VALUES ('518','107','_elementor_edit_mode','builder');
INSERT INTO `wp_79e54b1ec2_postmeta` VALUES ('519','107','_elementor_data','[{\"id\":\"46a3f1bf\",\"settings\":{\"background_color\":\"#ffffff\",\"box_shadow_box_shadow\":{\"horizontal\":0,\"vertical\":30,\"blur\":50,\"spread\":0,\"color\":\"rgba(3.0000000000000053, 12.000000000000005, 35, 0.08)\"},\"padding\":{\"unit\":\"px\",\"top\":\"40\",\"right\":\"50\",\"bottom\":\"50\",\"left\":\"50\",\"isLinked\":false},\"padding_tablet\":{\"unit\":\"px\",\"top\":\"45\",\"right\":\"15\",\"bottom\":\"45\",\"left\":\"15\",\"isLinked\":false},\"content_width\":\"full\",\"ekit_all_conditions_list\":[{\"_id\":\"2bde398\"}],\"ekit_section_parallax_multi_items\":[],\"flex_direction\":\"row\",\"flex_align_items\":\"stretch\",\"flex_gap\":{\"size\":20,\"column\":\"20\",\"row\":\"20\",\"unit\":\"px\",\"isLinked\":true},\"flex_wrap\":\"wrap\"},\"elements\":[{\"id\":\"5356f21a\",\"settings\":{\"title\":\"Simple Contact Form\",\"header_size\":\"h3\",\"title_color\":\"#0D1427\",\"typography_typography\":\"custom\",\"typography_font_family\":\"IBM Plex Sans\",\"typography_font_size\":{\"unit\":\"px\",\"size\":26,\"sizes\":[]},\"typography_font_weight\":\"700\",\"typography_line_height\":{\"unit\":\"px\",\"size\":34,\"sizes\":[]},\"typography_line_height_tablet\":{\"unit\":\"px\",\"size\":\"\",\"sizes\":[]},\"typography_line_height_mobile\":{\"unit\":\"px\",\"size\":\"\",\"sizes\":[]},\"_padding\":{\"unit\":\"px\",\"top\":\"12\",\"right\":\"15\",\"bottom\":\"8\",\"left\":\"0\",\"isLinked\":false},\"ekit_all_conditions_list\":[{\"_id\":\"63c841d\"}],\"ekit_adv_tooltip_content\":\"Tooltip Content.\"},\"elements\":[],\"isInner\":false,\"widgetType\":\"heading\",\"elType\":\"widget\"},{\"id\":\"65b14f34\",\"settings\":{\"structure\":\"20\",\"content_width\":\"full\",\"ekit_all_conditions_list\":[{\"_id\":\"0fbbc40\"}],\"ekit_section_parallax_multi_items\":[],\"flex_direction\":\"row\",\"flex_align_items\":\"stretch\",\"flex_gap\":{\"size\":10,\"column\":\"10\",\"row\":\"10\",\"unit\":\"px\"},\"container_type\":\"grid\",\"grid_columns_grid\":{\"unit\":\"fr\",\"size\":2,\"sizes\":[]},\"grid_rows_grid\":{\"unit\":\"fr\",\"size\":1,\"sizes\":[]},\"grid_gaps\":{\"column\":\"30\",\"row\":\"20\",\"isLinked\":false,\"unit\":\"px\"},\"metform_multistep_settings_title\":\"\",\"metform_multistep_settings_icon\":{\"value\":\"\",\"library\":\"\"},\"padding\":{\"unit\":\"px\",\"top\":\"0\",\"right\":\"0\",\"bottom\":\"0\",\"left\":\"0\",\"isLinked\":false},\"presetTitle\":\"Grid\",\"presetIcon\":\"eicon-container-grid\"},\"elements\":[{\"id\":\"229b8a8\",\"settings\":{\"mf_input_label\":\"First Name\",\"mf_input_name\":\"mf-first-name\",\"mf_input_placeholder\":\"First name here\",\"mf_input_label_typography_typography\":\"custom\",\"mf_input_label_typography_font_family\":\"IBM Plex Sans\",\"mf_input_label_typography_font_size\":{\"unit\":\"px\",\"size\":16,\"sizes\":[]},\"mf_input_label_typography_font_weight\":\"500\",\"mf_input_label_typography_line_height\":{\"unit\":\"px\",\"size\":21,\"sizes\":[]},\"mf_input_min_length\":1,\"mf_input_label_color\":\"#0D1427\",\"mf_input_label_margin\":{\"unit\":\"px\",\"top\":\"0\",\"right\":\"0\",\"bottom\":\"7\",\"left\":\"0\",\"isLinked\":false},\"mf_input_padding\":{\"unit\":\"px\",\"top\":\"15\",\"right\":\"24\",\"bottom\":\"17\",\"left\":\"24\",\"isLinked\":false},\"mf_input_border_border\":\"solid\",\"mf_input_border_width\":{\"unit\":\"px\",\"top\":\"1\",\"right\":\"1\",\"bottom\":\"1\",\"left\":\"1\",\"isLinked\":true},\"mf_input_border_color\":\"#EAECF1\",\"mf_input_typgraphy_typography\":\"custom\",\"mf_input_typgraphy_font_family\":\"IBM Plex Sans\",\"mf_input_typgraphy_font_size\":{\"unit\":\"px\",\"size\":14,\"sizes\":[]},\"mf_input_typgraphy_font_weight\":\"400\",\"mf_input_typgraphy_line_height\":{\"unit\":\"px\",\"size\":18,\"sizes\":[]},\"mf_input_border_radius\":{\"unit\":\"px\",\"size\":6,\"sizes\":[]},\"mf_input_place_holder_typography_typography\":\"custom\",\"mf_input_place_holder_typography_font_family\":\"IBM Plex Sans\",\"mf_input_place_holder_typography_font_weight\":\"400\",\"mf_input_placeholder_color\":\"#878991\",\"mf_input_required\":\"yes\",\"mf_input_validation_warning_message\":\"This field is required.\",\"mf_conditional_logic_form_list\":[],\"mf_input_label_typography_line_height_tablet\":{\"unit\":\"px\",\"size\":\"\",\"sizes\":[]},\"mf_input_label_typography_line_height_mobile\":{\"unit\":\"px\",\"size\":\"\",\"sizes\":[]},\"mf_input_background_background\":\"classic\",\"mf_input_background_color\":\"#F6F7FA\",\"mf_input_background_hover_color\":\"#FFFFFF\",\"mf_input_background_focus_background\":\"classic\",\"mf_input_background_focus_color\":\"#FFFFFF\",\"mf_input_typgraphy_line_height_tablet\":{\"unit\":\"px\",\"size\":\"\",\"sizes\":[]},\"mf_input_typgraphy_line_height_mobile\":{\"unit\":\"px\",\"size\":\"\",\"sizes\":[]},\"mf_input_typgraphy_word_spacing_tablet\":{\"unit\":\"px\",\"size\":\"\",\"sizes\":[]},\"mf_input_typgraphy_word_spacing_mobile\":{\"unit\":\"px\",\"size\":\"\",\"sizes\":[]},\"mf_input_place_holder_typography_font_size\":{\"unit\":\"px\",\"size\":14,\"sizes\":[]},\"mf_input_place_holder_typography_line_height\":{\"unit\":\"px\",\"size\":18,\"sizes\":[]},\"mf_input_place_holder_typography_line_height_tablet\":{\"unit\":\"px\",\"size\":\"\",\"sizes\":[]},\"mf_input_place_holder_typography_line_height_mobile\":{\"unit\":\"px\",\"size\":\"\",\"sizes\":[]},\"ekit_all_conditions_list\":[{\"_id\":\"30812ac\"}],\"ekit_adv_tooltip_content\":\"Tooltip Content.\",\"mf_input_color\":\"#0D1427\",\"mf_input_border_focus_border\":\"solid\",\"mf_input_border_focus_color\":\"#D6D8E0\",\"mf_input_help_text_typography_typography\":\"custom\",\"mf_input_help_text_typography_font_family\":\"IBM Plex Sans\",\"mf_input_help_text_typography_font_size\":{\"unit\":\"px\",\"size\":13,\"sizes\":[]},\"mf_input_help_text_typography_font_weight\":\"400\",\"mf_input_help_text_typography_line_height\":{\"unit\":\"px\",\"size\":17,\"sizes\":[]},\"mf_input_help_text_typography_line_height_tablet\":{\"unit\":\"px\",\"size\":\"\",\"sizes\":[]},\"mf_input_help_text_typography_line_height_mobile\":{\"unit\":\"px\",\"size\":\"\",\"sizes\":[]},\"mf_input_help_text_color\":\"#96989F\",\"__globals__\":{\"mf_input_required_indicator_color\":\"\",\"mf_input_warning_text_color\":\"\"},\"mf_input_warning_text_typography_typography\":\"custom\",\"mf_input_warning_text_typography_font_family\":\"Roboto\",\"mf_input_warning_text_typography_font_weight\":\"600\"},\"elements\":[],\"isInner\":false,\"widgetType\":\"mf-text\",\"elType\":\"widget\"},{\"id\":\"1a922000\",\"settings\":{\"mf_input_label\":\"Last Name\",\"mf_input_name\":\"mf-last-name\",\"mf_input_placeholder\":\"Last name here\",\"mf_input_label_color\":\"#0D1427\",\"mf_input_label_typography_typography\":\"custom\",\"mf_input_label_typography_font_family\":\"IBM Plex Sans\",\"mf_input_label_typography_font_size\":{\"unit\":\"px\",\"size\":16,\"sizes\":[]},\"mf_input_label_typography_font_weight\":\"500\",\"mf_input_label_typography_line_height\":{\"unit\":\"px\",\"size\":21,\"sizes\":[]},\"mf_input_label_margin\":{\"unit\":\"px\",\"top\":\"0\",\"right\":\"0\",\"bottom\":\"7\",\"left\":\"0\",\"isLinked\":false},\"mf_input_padding\":{\"unit\":\"px\",\"top\":\"15\",\"right\":\"24\",\"bottom\":\"17\",\"left\":\"24\",\"isLinked\":false},\"mf_input_border_border\":\"solid\",\"mf_input_border_width\":{\"unit\":\"px\",\"top\":\"1\",\"right\":\"1\",\"bottom\":\"1\",\"left\":\"1\",\"isLinked\":true},\"mf_input_border_color\":\"#EAECF1\",\"mf_input_typgraphy_typography\":\"custom\",\"mf_input_typgraphy_font_family\":\"IBM Plex Sans\",\"mf_input_typgraphy_font_size\":{\"unit\":\"px\",\"size\":14,\"sizes\":[]},\"mf_input_typgraphy_font_weight\":\"400\",\"mf_input_typgraphy_line_height\":{\"unit\":\"px\",\"size\":18,\"sizes\":[]},\"mf_input_border_radius\":{\"unit\":\"px\",\"size\":6,\"sizes\":[]},\"mf_input_place_holder_typography_typography\":\"custom\",\"mf_input_place_holder_typography_font_family\":\"IBM Plex Sans\",\"mf_input_place_holder_typography_font_weight\":\"400\",\"mf_input_placeholder_color\":\"#878991\",\"mf_input_required\":\"yes\",\"mf_input_validation_warning_message\":\"This field is required.\",\"mf_conditional_logic_form_list\":[],\"mf_input_label_typography_line_height_tablet\":{\"unit\":\"px\",\"size\":\"\",\"sizes\":[]},\"mf_input_label_typography_line_height_mobile\":{\"unit\":\"px\",\"size\":\"\",\"sizes\":[]},\"mf_input_background_background\":\"classic\",\"mf_input_background_color\":\"#F6F7FA\",\"mf_input_background_hover_color\":\"#FFFFFF\",\"mf_input_background_focus_background\":\"classic\",\"mf_input_background_focus_color\":\"#FFFFFF\",\"mf_input_typgraphy_line_height_tablet\":{\"unit\":\"px\",\"size\":\"\",\"sizes\":[]},\"mf_input_typgraphy_line_height_mobile\":{\"unit\":\"px\",\"size\":\"\",\"sizes\":[]},\"mf_input_typgraphy_word_spacing_tablet\":{\"unit\":\"px\",\"size\":\"\",\"sizes\":[]},\"mf_input_typgraphy_word_spacing_mobile\":{\"unit\":\"px\",\"size\":\"\",\"sizes\":[]},\"mf_input_place_holder_typography_font_size\":{\"unit\":\"px\",\"size\":14,\"sizes\":[]},\"mf_input_place_holder_typography_line_height\":{\"unit\":\"px\",\"size\":18,\"sizes\":[]},\"mf_input_place_holder_typography_line_height_tablet\":{\"unit\":\"px\",\"size\":\"\",\"sizes\":[]},\"mf_input_place_holder_typography_line_height_mobile\":{\"unit\":\"px\",\"size\":\"\",\"sizes\":[]},\"ekit_all_conditions_list\":[{\"_id\":\"30812ac\"}],\"ekit_adv_tooltip_content\":\"Tooltip Content.\",\"mf_input_color\":\"#0D1427\",\"mf_input_border_focus_border\":\"solid\",\"mf_input_border_focus_color\":\"#D6D8E0\",\"mf_input_help_text_typography_typography\":\"custom\",\"mf_input_help_text_typography_font_family\":\"IBM Plex Sans\",\"mf_input_help_text_typography_font_size\":{\"unit\":\"px\",\"size\":13,\"sizes\":[]},\"mf_input_help_text_typography_font_weight\":\"400\",\"mf_input_help_text_typography_line_height\":{\"unit\":\"px\",\"size\":17,\"sizes\":[]},\"mf_input_help_text_typography_line_height_tablet\":{\"unit\":\"px\",\"size\":\"\",\"sizes\":[]},\"mf_input_help_text_typography_line_height_mobile\":{\"unit\":\"px\",\"size\":\"\",\"sizes\":[]},\"mf_input_help_text_color\":\"#96989F\",\"__globals__\":{\"mf_input_required_indicator_color\":\"\",\"mf_input_warning_text_color\":\"\"}},\"elements\":[],\"isInner\":false,\"widgetType\":\"mf-text\",\"elType\":\"widget\"},{\"id\":\"752b6f44\",\"settings\":{\"mf_input_label\":\"Email Address\",\"mf_input_name\":\"mf-email\",\"mf_input_placeholder\":\"Add email\",\"mf_input_required\":\"yes\",\"mf_input_label_color\":\"#0D1427\",\"mf_input_label_typography_typography\":\"custom\",\"mf_input_label_typography_font_family\":\"IBM Plex Sans\",\"mf_input_label_typography_font_size\":{\"unit\":\"px\",\"size\":16,\"sizes\":[]},\"mf_input_label_typography_font_weight\":\"500\",\"mf_input_label_typography_line_height\":{\"unit\":\"px\",\"size\":21,\"sizes\":[]},\"mf_input_label_margin\":{\"unit\":\"px\",\"top\":\"0\",\"right\":\"0\",\"bottom\":\"7\",\"left\":\"0\",\"isLinked\":false},\"mf_input_padding\":{\"unit\":\"px\",\"top\":\"15\",\"right\":\"24\",\"bottom\":\"17\",\"left\":\"24\",\"isLinked\":false},\"mf_input_border_border\":\"solid\",\"mf_input_border_width\":{\"unit\":\"px\",\"top\":\"1\",\"right\":\"1\",\"bottom\":\"1\",\"left\":\"1\",\"isLinked\":true},\"mf_input_border_color\":\"#EAECF1\",\"mf_input_typgraphy_typography\":\"custom\",\"mf_input_typgraphy_font_family\":\"IBM Plex Sans\",\"mf_input_typgraphy_font_size\":{\"unit\":\"px\",\"size\":14,\"sizes\":[]},\"mf_input_typgraphy_font_weight\":\"400\",\"mf_input_typgraphy_line_height\":{\"unit\":\"px\",\"size\":18,\"sizes\":[]},\"mf_input_border_radius\":{\"unit\":\"px\",\"size\":6,\"sizes\":[]},\"mf_input_place_holder_typography_typography\":\"custom\",\"mf_input_place_holder_typography_font_family\":\"IBM Plex Sans\",\"mf_input_place_holder_typography_font_weight\":\"400\",\"mf_input_placeholder_color\":\"#878991\",\"mf_input_validation_warning_message\":\"This field is required.\",\"mf_conditional_logic_form_list\":[],\"mf_input_label_typography_line_height_tablet\":{\"unit\":\"px\",\"size\":\"\",\"sizes\":[]},\"mf_input_label_typography_line_height_mobile\":{\"unit\":\"px\",\"size\":\"\",\"sizes\":[]},\"mf_input_background_background\":\"classic\",\"mf_input_background_color\":\"#F6F7FA\",\"mf_input_background_hover_color\":\"#FFFFFF\",\"mf_input_background_focus_background\":\"classic\",\"mf_input_background_focus_color\":\"#FFFFFF\",\"mf_input_typgraphy_line_height_tablet\":{\"unit\":\"px\",\"size\":\"\",\"sizes\":[]},\"mf_input_typgraphy_line_height_mobile\":{\"unit\":\"px\",\"size\":\"\",\"sizes\":[]},\"mf_input_typgraphy_word_spacing_tablet\":{\"unit\":\"px\",\"size\":\"\",\"sizes\":[]},\"mf_input_typgraphy_word_spacing_mobile\":{\"unit\":\"px\",\"size\":\"\",\"sizes\":[]},\"mf_input_place_holder_typography_font_size\":{\"unit\":\"px\",\"size\":14,\"sizes\":[]},\"mf_input_place_holder_typography_line_height\":{\"unit\":\"px\",\"size\":18,\"sizes\":[]},\"mf_input_place_holder_typography_line_height_tablet\":{\"unit\":\"px\",\"size\":\"\",\"sizes\":[]},\"mf_input_place_holder_typography_line_height_mobile\":{\"unit\":\"px\",\"size\":\"\",\"sizes\":[]},\"ekit_all_conditions_list\":[{\"_id\":\"30812ac\"}],\"ekit_adv_tooltip_content\":\"Tooltip Content.\",\"mf_input_color\":\"#0D1427\",\"mf_input_border_focus_border\":\"solid\",\"mf_input_border_focus_color\":\"#D6D8E0\",\"mf_input_help_text_typography_typography\":\"custom\",\"mf_input_help_text_typography_font_family\":\"IBM Plex Sans\",\"mf_input_help_text_typography_font_size\":{\"unit\":\"px\",\"size\":13,\"sizes\":[]},\"mf_input_help_text_typography_font_weight\":\"400\",\"mf_input_help_text_typography_line_height\":{\"unit\":\"px\",\"size\":17,\"sizes\":[]},\"mf_input_help_text_typography_line_height_tablet\":{\"unit\":\"px\",\"size\":\"\",\"sizes\":[]},\"mf_input_help_text_typography_line_height_mobile\":{\"unit\":\"px\",\"size\":\"\",\"sizes\":[]},\"mf_input_help_text_color\":\"#96989F\",\"__globals__\":{\"mf_input_required_indicator_color\":\"\",\"mf_input_warning_text_color\":\"\"}},\"elements\":[],\"isInner\":false,\"widgetType\":\"mf-email\",\"elType\":\"widget\"},{\"id\":\"452c321f\",\"settings\":{\"mf_input_label\":\"Subject\",\"mf_input_name\":\"mf-subject\",\"mf_input_placeholder\":\"How can we help you?\",\"mf_input_required\":\"yes\",\"mf_input_label_color\":\"#0D1427\",\"mf_input_label_typography_typography\":\"custom\",\"mf_input_label_typography_font_family\":\"IBM Plex Sans\",\"mf_input_label_typography_font_size\":{\"unit\":\"px\",\"size\":16,\"sizes\":[]},\"mf_input_label_typography_font_weight\":\"500\",\"mf_input_label_typography_line_height\":{\"unit\":\"px\",\"size\":21,\"sizes\":[]},\"mf_input_label_margin\":{\"unit\":\"px\",\"top\":\"0\",\"right\":\"0\",\"bottom\":\"7\",\"left\":\"0\",\"isLinked\":false},\"mf_input_padding\":{\"unit\":\"px\",\"top\":\"15\",\"right\":\"24\",\"bottom\":\"17\",\"left\":\"24\",\"isLinked\":false},\"mf_input_border_border\":\"solid\",\"mf_input_border_width\":{\"unit\":\"px\",\"top\":\"1\",\"right\":\"1\",\"bottom\":\"1\",\"left\":\"1\",\"isLinked\":true},\"mf_input_border_color\":\"#EAECF1\",\"mf_input_typgraphy_typography\":\"custom\",\"mf_input_typgraphy_font_family\":\"IBM Plex Sans\",\"mf_input_typgraphy_font_size\":{\"unit\":\"px\",\"size\":14,\"sizes\":[]},\"mf_input_typgraphy_font_weight\":\"400\",\"mf_input_typgraphy_line_height\":{\"unit\":\"px\",\"size\":18,\"sizes\":[]},\"mf_input_border_radius\":{\"unit\":\"px\",\"size\":6,\"sizes\":[]},\"mf_input_place_holder_typography_typography\":\"custom\",\"mf_input_place_holder_typography_font_family\":\"IBM Plex Sans\",\"mf_input_place_holder_typography_font_weight\":\"400\",\"mf_input_placeholder_color\":\"#878991\",\"mf_input_validation_warning_message\":\"This field is required.\",\"mf_conditional_logic_form_list\":[],\"mf_input_label_typography_line_height_tablet\":{\"unit\":\"px\",\"size\":\"\",\"sizes\":[]},\"mf_input_label_typography_line_height_mobile\":{\"unit\":\"px\",\"size\":\"\",\"sizes\":[]},\"mf_input_background_background\":\"classic\",\"mf_input_background_color\":\"#F6F7FA\",\"mf_input_background_hover_color\":\"#FFFFFF\",\"mf_input_background_focus_background\":\"classic\",\"mf_input_background_focus_color\":\"#FFFFFF\",\"mf_input_typgraphy_line_height_tablet\":{\"unit\":\"px\",\"size\":\"\",\"sizes\":[]},\"mf_input_typgraphy_line_height_mobile\":{\"unit\":\"px\",\"size\":\"\",\"sizes\":[]},\"mf_input_typgraphy_word_spacing_tablet\":{\"unit\":\"px\",\"size\":\"\",\"sizes\":[]},\"mf_input_typgraphy_word_spacing_mobile\":{\"unit\":\"px\",\"size\":\"\",\"sizes\":[]},\"mf_input_place_holder_typography_font_size\":{\"unit\":\"px\",\"size\":14,\"sizes\":[]},\"mf_input_place_holder_typography_line_height\":{\"unit\":\"px\",\"size\":18,\"sizes\":[]},\"mf_input_place_holder_typography_line_height_tablet\":{\"unit\":\"px\",\"size\":\"\",\"sizes\":[]},\"mf_input_place_holder_typography_line_height_mobile\":{\"unit\":\"px\",\"size\":\"\",\"sizes\":[]},\"ekit_all_conditions_list\":[{\"_id\":\"30812ac\"}],\"ekit_adv_tooltip_content\":\"Tooltip Content.\",\"mf_input_color\":\"#0D1427\",\"mf_input_border_focus_border\":\"solid\",\"mf_input_border_focus_color\":\"#D6D8E0\",\"mf_input_help_text_typography_typography\":\"custom\",\"mf_input_help_text_typography_font_family\":\"IBM Plex Sans\",\"mf_input_help_text_typography_font_size\":{\"unit\":\"px\",\"size\":13,\"sizes\":[]},\"mf_input_help_text_typography_font_weight\":\"400\",\"mf_input_help_text_typography_line_height\":{\"unit\":\"px\",\"size\":17,\"sizes\":[]},\"mf_input_help_text_typography_line_height_tablet\":{\"unit\":\"px\",\"size\":\"\",\"sizes\":[]},\"mf_input_help_text_typography_line_height_mobile\":{\"unit\":\"px\",\"size\":\"\",\"sizes\":[]},\"mf_input_help_text_color\":\"#96989F\",\"__globals__\":{\"mf_input_required_indicator_color\":\"\",\"mf_input_warning_text_color\":\"\"}},\"elements\":[],\"isInner\":false,\"widgetType\":\"mf-text\",\"elType\":\"widget\"}],\"isInner\":true,\"elType\":\"container\"},{\"id\":\"13f46608\",\"settings\":{\"mf_input_label\":\"Comments / Questions\",\"mf_input_name\":\"mf-comment\",\"mf_input_placeholder\":\"Comments\",\"mf_input_required\":\"yes\",\"mf_input_label_color\":\"#0D1427\",\"mf_input_label_typography_typography\":\"custom\",\"mf_input_label_typography_font_family\":\"IBM Plex Sans\",\"mf_input_label_typography_font_size\":{\"unit\":\"px\",\"size\":16,\"sizes\":[]},\"mf_input_label_typography_font_weight\":\"500\",\"mf_input_label_typography_line_height\":{\"unit\":\"px\",\"size\":21,\"sizes\":[]},\"mf_input_label_margin\":{\"unit\":\"px\",\"top\":\"0\",\"right\":\"0\",\"bottom\":\"7\",\"left\":\"0\",\"isLinked\":false},\"mf_input_padding\":{\"unit\":\"px\",\"top\":\"15\",\"right\":\"24\",\"bottom\":\"15\",\"left\":\"24\",\"isLinked\":false},\"mf_input_border_border\":\"solid\",\"mf_input_border_width\":{\"unit\":\"px\",\"top\":\"1\",\"right\":\"1\",\"bottom\":\"1\",\"left\":\"1\",\"isLinked\":true},\"mf_input_border_color\":\"#EAECF1\",\"mf_input_typgraphy_typography\":\"custom\",\"mf_input_typgraphy_font_family\":\"IBM Plex Sans\",\"mf_input_typgraphy_font_size\":{\"unit\":\"px\",\"size\":14,\"sizes\":[]},\"mf_input_typgraphy_font_weight\":\"400\",\"mf_input_typgraphy_line_height\":{\"unit\":\"px\",\"size\":18,\"sizes\":[]},\"mf_input_border_radius\":{\"unit\":\"px\",\"size\":6,\"sizes\":[]},\"mf_input_place_holder_typography_typography\":\"custom\",\"mf_input_place_holder_typography_font_family\":\"IBM Plex Sans\",\"mf_input_place_holder_typography_font_weight\":\"500\",\"mf_input_placeholder_color\":\"#878991\",\"mf_textarea_field_height\":{\"unit\":\"px\",\"size\":180,\"sizes\":[]},\"mf_input_validation_warning_message\":\"This field is required.\",\"mf_conditional_logic_form_list\":[],\"mf_input_label_typography_line_height_tablet\":{\"unit\":\"px\",\"size\":\"\",\"sizes\":[]},\"mf_input_label_typography_line_height_mobile\":{\"unit\":\"px\",\"size\":\"\",\"sizes\":[]},\"mf_input_background_background\":\"classic\",\"mf_input_background_color\":\"#F6F7FA\",\"mf_input_background_hover_color\":\"#FFFFFF\",\"mf_input_background_focus_background\":\"classic\",\"mf_input_background_focus_color\":\"#FFFFFF\",\"mf_input_typgraphy_line_height_tablet\":{\"unit\":\"px\",\"size\":\"\",\"sizes\":[]},\"mf_input_typgraphy_line_height_mobile\":{\"unit\":\"px\",\"size\":\"\",\"sizes\":[]},\"mf_input_place_holder_typography_font_size\":{\"unit\":\"px\",\"size\":14,\"sizes\":[]},\"mf_input_place_holder_typography_line_height\":{\"unit\":\"px\",\"size\":18,\"sizes\":[]},\"mf_input_place_holder_typography_line_height_tablet\":{\"unit\":\"px\",\"size\":\"\",\"sizes\":[]},\"mf_input_place_holder_typography_line_height_mobile\":{\"unit\":\"px\",\"size\":\"\",\"sizes\":[]},\"_margin\":{\"unit\":\"px\",\"top\":\"0\",\"right\":\"0\",\"bottom\":\"0\",\"left\":\"0\",\"isLinked\":false},\"ekit_all_conditions_list\":[{\"_id\":\"6609fcf\"}],\"ekit_adv_tooltip_content\":\"Tooltip Content.\",\"mf_input_color\":\"#0D1427\",\"mf_input_border_focus_border\":\"solid\",\"mf_input_border_focus_color\":\"#D6D8E0\",\"mf_input_help_text_typography_typography\":\"custom\",\"mf_input_help_text_typography_font_family\":\"IBM Plex Sans\",\"mf_input_help_text_typography_font_size\":{\"unit\":\"px\",\"size\":13,\"sizes\":[]},\"mf_input_help_text_typography_font_weight\":\"400\",\"mf_input_help_text_typography_line_height\":{\"unit\":\"px\",\"size\":17,\"sizes\":[]},\"mf_input_help_text_typography_line_height_tablet\":{\"unit\":\"px\",\"size\":\"\",\"sizes\":[]},\"mf_input_help_text_typography_line_height_mobile\":{\"unit\":\"px\",\"size\":\"\",\"sizes\":[]},\"mf_input_help_text_color\":\"#96989F\",\"__globals__\":{\"mf_input_required_indicator_color\":\"\",\"mf_input_warning_text_color\":\"\"},\"_element_width\":\"inherit\"},\"elements\":[],\"isInner\":false,\"widgetType\":\"mf-textarea\",\"elType\":\"widget\"},{\"id\":\"50e956bc\",\"settings\":{\"_margin\":{\"unit\":\"px\",\"top\":\"0\",\"right\":\"0\",\"bottom\":\"0\",\"left\":\"0\",\"isLinked\":false},\"mf_recaptcha_type\":\"recaptcha-v2\",\"mf_input_label\":\"reCAPTCHA\",\"mf_input_placeholder\":\"reCAPTCHA\",\"ekit_all_conditions_list\":[{\"_id\":\"ab08d5c\"}],\"ekit_adv_tooltip_content\":\"Tooltip Content.\",\"_element_width\":\"inherit\"},\"elements\":[],\"isInner\":false,\"widgetType\":\"mf-recaptcha\",\"elType\":\"widget\"},{\"id\":\"54379b03\",\"settings\":{\"mf_btn_text\":\"Send Message\",\"mf_btn_align\":\"\",\"mf_btn_text_padding\":{\"unit\":\"px\",\"top\":\"17\",\"right\":\"28\",\"bottom\":\"16\",\"left\":\"28\",\"isLinked\":false},\"mf_btn_typography_typography\":\"custom\",\"mf_btn_typography_font_family\":\"Roboto\",\"mf_btn_typography_font_size\":{\"unit\":\"px\",\"size\":14,\"sizes\":[]},\"mf_btn_typography_font_weight\":\"500\",\"mf_btn_typography_line_height\":{\"unit\":\"px\",\"size\":11,\"sizes\":[]},\"mf_btn_bg_color_background\":\"classic\",\"mf_btn_bg_color_color\":\"#3970FF\",\"mf_btn_box_shadow_group_box_shadow_type\":\"yes\",\"mf_btn_box_shadow_group_box_shadow\":{\"horizontal\":0,\"vertical\":0,\"blur\":0,\"spread\":0,\"color\":\"rgba(0,0,0,0.5)\"},\"mf_conditional_logic_form_list\":[],\"mf_hidden_input\":[],\"mf_btn_typography_line_height_tablet\":{\"unit\":\"px\",\"size\":\"\",\"sizes\":[]},\"mf_btn_typography_line_height_mobile\":{\"unit\":\"px\",\"size\":\"\",\"sizes\":[]},\"mf_btn_text_color\":\"#FFFFFF\",\"mf_btn_bg_hover_color_background\":\"classic\",\"mf_btn_border_radius\":{\"unit\":\"px\",\"top\":\"8\",\"right\":\"8\",\"bottom\":\"8\",\"left\":\"8\",\"isLinked\":true},\"ekit_all_conditions_list\":[{\"_id\":\"eed14b8\"}],\"ekit_adv_tooltip_content\":\"Tooltip Content.\",\"_box_shadow_hover_box_shadow\":{\"horizontal\":0,\"vertical\":2,\"blur\":4,\"spread\":0,\"color\":\"rgba(2.9999999999999996, 28.00000000000002, 90, 0.4)\"},\"mf_btn_hover_color\":\"\",\"_element_width\":\"auto\",\"_border_radius\":{\"unit\":\"px\",\"top\":\"8\",\"right\":\"8\",\"bottom\":\"8\",\"left\":\"8\",\"isLinked\":true},\"_box_shadow_hover_box_shadow_type\":\"yes\",\"_margin\":{\"unit\":\"px\",\"top\":\"0\",\"right\":\"0\",\"bottom\":\"0\",\"left\":\"0\",\"isLinked\":false}},\"elements\":[],\"isInner\":false,\"widgetType\":\"mf-button\",\"elType\":\"widget\"}],\"isInner\":false,\"elType\":\"container\"}]');
INSERT INTO `wp_79e54b1ec2_postmeta` VALUES ('522','108','_wp_page_template','elementor_canvas');
INSERT INTO `wp_79e54b1ec2_postmeta` VALUES ('523','108','_elementor_edit_mode','builder');
INSERT INTO `wp_79e54b1ec2_postmeta` VALUES ('524','108','_elementor_data','[{\"id\":\"46a3f1bf\",\"settings\":{\"background_color\":\"#ffffff\",\"box_shadow_box_shadow\":{\"horizontal\":0,\"vertical\":30,\"blur\":50,\"spread\":0,\"color\":\"rgba(3.0000000000000053, 12.000000000000005, 35, 0.08)\"},\"padding\":{\"unit\":\"px\",\"top\":\"40\",\"right\":\"50\",\"bottom\":\"50\",\"left\":\"50\",\"isLinked\":false},\"padding_tablet\":{\"unit\":\"px\",\"top\":\"45\",\"right\":\"15\",\"bottom\":\"45\",\"left\":\"15\",\"isLinked\":false},\"content_width\":\"full\",\"ekit_all_conditions_list\":[{\"_id\":\"2bde398\"}],\"ekit_section_parallax_multi_items\":[],\"flex_direction\":\"row\",\"flex_align_items\":\"stretch\",\"flex_gap\":{\"size\":20,\"column\":\"20\",\"row\":\"20\",\"unit\":\"px\",\"isLinked\":true},\"flex_wrap\":\"wrap\"},\"elements\":[{\"id\":\"5356f21a\",\"settings\":{\"title\":\"Simple Contact Form\",\"header_size\":\"h3\",\"title_color\":\"#0D1427\",\"typography_typography\":\"custom\",\"typography_font_family\":\"IBM Plex Sans\",\"typography_font_size\":{\"unit\":\"px\",\"size\":26,\"sizes\":[]},\"typography_font_weight\":\"700\",\"typography_line_height\":{\"unit\":\"px\",\"size\":34,\"sizes\":[]},\"typography_line_height_tablet\":{\"unit\":\"px\",\"size\":\"\",\"sizes\":[]},\"typography_line_height_mobile\":{\"unit\":\"px\",\"size\":\"\",\"sizes\":[]},\"_padding\":{\"unit\":\"px\",\"top\":\"12\",\"right\":\"15\",\"bottom\":\"8\",\"left\":\"0\",\"isLinked\":false},\"ekit_all_conditions_list\":[{\"_id\":\"63c841d\"}],\"ekit_adv_tooltip_content\":\"Tooltip Content.\"},\"elements\":[],\"isInner\":false,\"widgetType\":\"heading\",\"elType\":\"widget\"},{\"id\":\"65b14f34\",\"settings\":{\"structure\":\"20\",\"content_width\":\"full\",\"ekit_all_conditions_list\":[{\"_id\":\"0fbbc40\"}],\"ekit_section_parallax_multi_items\":[],\"flex_direction\":\"row\",\"flex_align_items\":\"stretch\",\"flex_gap\":{\"size\":10,\"column\":\"10\",\"row\":\"10\",\"unit\":\"px\"},\"container_type\":\"grid\",\"grid_columns_grid\":{\"unit\":\"fr\",\"size\":2,\"sizes\":[]},\"grid_rows_grid\":{\"unit\":\"fr\",\"size\":1,\"sizes\":[]},\"grid_gaps\":{\"column\":\"30\",\"row\":\"20\",\"isLinked\":false,\"unit\":\"px\"},\"metform_multistep_settings_title\":\"\",\"metform_multistep_settings_icon\":{\"value\":\"\",\"library\":\"\"},\"padding\":{\"unit\":\"px\",\"top\":\"0\",\"right\":\"0\",\"bottom\":\"0\",\"left\":\"0\",\"isLinked\":false},\"presetTitle\":\"Grid\",\"presetIcon\":\"eicon-container-grid\"},\"elements\":[{\"id\":\"229b8a8\",\"settings\":{\"mf_input_label\":\"First Name\",\"mf_input_name\":\"mf-first-name\",\"mf_input_placeholder\":\"First name here\",\"mf_input_label_typography_typography\":\"custom\",\"mf_input_label_typography_font_family\":\"IBM Plex Sans\",\"mf_input_label_typography_font_size\":{\"unit\":\"px\",\"size\":16,\"sizes\":[]},\"mf_input_label_typography_font_weight\":\"500\",\"mf_input_label_typography_line_height\":{\"unit\":\"px\",\"size\":21,\"sizes\":[]},\"mf_input_min_length\":1,\"mf_input_label_color\":\"#0D1427\",\"mf_input_label_margin\":{\"unit\":\"px\",\"top\":\"0\",\"right\":\"0\",\"bottom\":\"7\",\"left\":\"0\",\"isLinked\":false},\"mf_input_padding\":{\"unit\":\"px\",\"top\":\"15\",\"right\":\"24\",\"bottom\":\"17\",\"left\":\"24\",\"isLinked\":false},\"mf_input_border_border\":\"solid\",\"mf_input_border_width\":{\"unit\":\"px\",\"top\":\"1\",\"right\":\"1\",\"bottom\":\"1\",\"left\":\"1\",\"isLinked\":true},\"mf_input_border_color\":\"#EAECF1\",\"mf_input_typgraphy_typography\":\"custom\",\"mf_input_typgraphy_font_family\":\"IBM Plex Sans\",\"mf_input_typgraphy_font_size\":{\"unit\":\"px\",\"size\":14,\"sizes\":[]},\"mf_input_typgraphy_font_weight\":\"400\",\"mf_input_typgraphy_line_height\":{\"unit\":\"px\",\"size\":18,\"sizes\":[]},\"mf_input_border_radius\":{\"unit\":\"px\",\"size\":6,\"sizes\":[]},\"mf_input_place_holder_typography_typography\":\"custom\",\"mf_input_place_holder_typography_font_family\":\"IBM Plex Sans\",\"mf_input_place_holder_typography_font_weight\":\"400\",\"mf_input_placeholder_color\":\"#878991\",\"mf_input_required\":\"yes\",\"mf_input_validation_warning_message\":\"This field is required.\",\"mf_conditional_logic_form_list\":[],\"mf_input_label_typography_line_height_tablet\":{\"unit\":\"px\",\"size\":\"\",\"sizes\":[]},\"mf_input_label_typography_line_height_mobile\":{\"unit\":\"px\",\"size\":\"\",\"sizes\":[]},\"mf_input_background_background\":\"classic\",\"mf_input_background_color\":\"#F6F7FA\",\"mf_input_background_hover_color\":\"#FFFFFF\",\"mf_input_background_focus_background\":\"classic\",\"mf_input_background_focus_color\":\"#FFFFFF\",\"mf_input_typgraphy_line_height_tablet\":{\"unit\":\"px\",\"size\":\"\",\"sizes\":[]},\"mf_input_typgraphy_line_height_mobile\":{\"unit\":\"px\",\"size\":\"\",\"sizes\":[]},\"mf_input_typgraphy_word_spacing_tablet\":{\"unit\":\"px\",\"size\":\"\",\"sizes\":[]},\"mf_input_typgraphy_word_spacing_mobile\":{\"unit\":\"px\",\"size\":\"\",\"sizes\":[]},\"mf_input_place_holder_typography_font_size\":{\"unit\":\"px\",\"size\":14,\"sizes\":[]},\"mf_input_place_holder_typography_line_height\":{\"unit\":\"px\",\"size\":18,\"sizes\":[]},\"mf_input_place_holder_typography_line_height_tablet\":{\"unit\":\"px\",\"size\":\"\",\"sizes\":[]},\"mf_input_place_holder_typography_line_height_mobile\":{\"unit\":\"px\",\"size\":\"\",\"sizes\":[]},\"ekit_all_conditions_list\":[{\"_id\":\"30812ac\"}],\"ekit_adv_tooltip_content\":\"Tooltip Content.\",\"mf_input_color\":\"#0D1427\",\"mf_input_border_focus_border\":\"solid\",\"mf_input_border_focus_color\":\"#D6D8E0\",\"mf_input_help_text_typography_typography\":\"custom\",\"mf_input_help_text_typography_font_family\":\"IBM Plex Sans\",\"mf_input_help_text_typography_font_size\":{\"unit\":\"px\",\"size\":13,\"sizes\":[]},\"mf_input_help_text_typography_font_weight\":\"400\",\"mf_input_help_text_typography_line_height\":{\"unit\":\"px\",\"size\":17,\"sizes\":[]},\"mf_input_help_text_typography_line_height_tablet\":{\"unit\":\"px\",\"size\":\"\",\"sizes\":[]},\"mf_input_help_text_typography_line_height_mobile\":{\"unit\":\"px\",\"size\":\"\",\"sizes\":[]},\"mf_input_help_text_color\":\"#96989F\",\"__globals__\":{\"mf_input_required_indicator_color\":\"\",\"mf_input_warning_text_color\":\"\"},\"mf_input_warning_text_typography_typography\":\"custom\",\"mf_input_warning_text_typography_font_family\":\"Roboto\",\"mf_input_warning_text_typography_font_weight\":\"600\"},\"elements\":[],\"isInner\":false,\"widgetType\":\"mf-text\",\"elType\":\"widget\"},{\"id\":\"1a922000\",\"settings\":{\"mf_input_label\":\"Last Name\",\"mf_input_name\":\"mf-last-name\",\"mf_input_placeholder\":\"Last name here\",\"mf_input_label_color\":\"#0D1427\",\"mf_input_label_typography_typography\":\"custom\",\"mf_input_label_typography_font_family\":\"IBM Plex Sans\",\"mf_input_label_typography_font_size\":{\"unit\":\"px\",\"size\":16,\"sizes\":[]},\"mf_input_label_typography_font_weight\":\"500\",\"mf_input_label_typography_line_height\":{\"unit\":\"px\",\"size\":21,\"sizes\":[]},\"mf_input_label_margin\":{\"unit\":\"px\",\"top\":\"0\",\"right\":\"0\",\"bottom\":\"7\",\"left\":\"0\",\"isLinked\":false},\"mf_input_padding\":{\"unit\":\"px\",\"top\":\"15\",\"right\":\"24\",\"bottom\":\"17\",\"left\":\"24\",\"isLinked\":false},\"mf_input_border_border\":\"solid\",\"mf_input_border_width\":{\"unit\":\"px\",\"top\":\"1\",\"right\":\"1\",\"bottom\":\"1\",\"left\":\"1\",\"isLinked\":true},\"mf_input_border_color\":\"#EAECF1\",\"mf_input_typgraphy_typography\":\"custom\",\"mf_input_typgraphy_font_family\":\"IBM Plex Sans\",\"mf_input_typgraphy_font_size\":{\"unit\":\"px\",\"size\":14,\"sizes\":[]},\"mf_input_typgraphy_font_weight\":\"400\",\"mf_input_typgraphy_line_height\":{\"unit\":\"px\",\"size\":18,\"sizes\":[]},\"mf_input_border_radius\":{\"unit\":\"px\",\"size\":6,\"sizes\":[]},\"mf_input_place_holder_typography_typography\":\"custom\",\"mf_input_place_holder_typography_font_family\":\"IBM Plex Sans\",\"mf_input_place_holder_typography_font_weight\":\"400\",\"mf_input_placeholder_color\":\"#878991\",\"mf_input_required\":\"yes\",\"mf_input_validation_warning_message\":\"This field is required.\",\"mf_conditional_logic_form_list\":[],\"mf_input_label_typography_line_height_tablet\":{\"unit\":\"px\",\"size\":\"\",\"sizes\":[]},\"mf_input_label_typography_line_height_mobile\":{\"unit\":\"px\",\"size\":\"\",\"sizes\":[]},\"mf_input_background_background\":\"classic\",\"mf_input_background_color\":\"#F6F7FA\",\"mf_input_background_hover_color\":\"#FFFFFF\",\"mf_input_background_focus_background\":\"classic\",\"mf_input_background_focus_color\":\"#FFFFFF\",\"mf_input_typgraphy_line_height_tablet\":{\"unit\":\"px\",\"size\":\"\",\"sizes\":[]},\"mf_input_typgraphy_line_height_mobile\":{\"unit\":\"px\",\"size\":\"\",\"sizes\":[]},\"mf_input_typgraphy_word_spacing_tablet\":{\"unit\":\"px\",\"size\":\"\",\"sizes\":[]},\"mf_input_typgraphy_word_spacing_mobile\":{\"unit\":\"px\",\"size\":\"\",\"sizes\":[]},\"mf_input_place_holder_typography_font_size\":{\"unit\":\"px\",\"size\":14,\"sizes\":[]},\"mf_input_place_holder_typography_line_height\":{\"unit\":\"px\",\"size\":18,\"sizes\":[]},\"mf_input_place_holder_typography_line_height_tablet\":{\"unit\":\"px\",\"size\":\"\",\"sizes\":[]},\"mf_input_place_holder_typography_line_height_mobile\":{\"unit\":\"px\",\"size\":\"\",\"sizes\":[]},\"ekit_all_conditions_list\":[{\"_id\":\"30812ac\"}],\"ekit_adv_tooltip_content\":\"Tooltip Content.\",\"mf_input_color\":\"#0D1427\",\"mf_input_border_focus_border\":\"solid\",\"mf_input_border_focus_color\":\"#D6D8E0\",\"mf_input_help_text_typography_typography\":\"custom\",\"mf_input_help_text_typography_font_family\":\"IBM Plex Sans\",\"mf_input_help_text_typography_font_size\":{\"unit\":\"px\",\"size\":13,\"sizes\":[]},\"mf_input_help_text_typography_font_weight\":\"400\",\"mf_input_help_text_typography_line_height\":{\"unit\":\"px\",\"size\":17,\"sizes\":[]},\"mf_input_help_text_typography_line_height_tablet\":{\"unit\":\"px\",\"size\":\"\",\"sizes\":[]},\"mf_input_help_text_typography_line_height_mobile\":{\"unit\":\"px\",\"size\":\"\",\"sizes\":[]},\"mf_input_help_text_color\":\"#96989F\",\"__globals__\":{\"mf_input_required_indicator_color\":\"\",\"mf_input_warning_text_color\":\"\"}},\"elements\":[],\"isInner\":false,\"widgetType\":\"mf-text\",\"elType\":\"widget\"},{\"id\":\"752b6f44\",\"settings\":{\"mf_input_label\":\"Email Address\",\"mf_input_name\":\"mf-email\",\"mf_input_placeholder\":\"Add email\",\"mf_input_required\":\"yes\",\"mf_input_label_color\":\"#0D1427\",\"mf_input_label_typography_typography\":\"custom\",\"mf_input_label_typography_font_family\":\"IBM Plex Sans\",\"mf_input_label_typography_font_size\":{\"unit\":\"px\",\"size\":16,\"sizes\":[]},\"mf_input_label_typography_font_weight\":\"500\",\"mf_input_label_typography_line_height\":{\"unit\":\"px\",\"size\":21,\"sizes\":[]},\"mf_input_label_margin\":{\"unit\":\"px\",\"top\":\"0\",\"right\":\"0\",\"bottom\":\"7\",\"left\":\"0\",\"isLinked\":false},\"mf_input_padding\":{\"unit\":\"px\",\"top\":\"15\",\"right\":\"24\",\"bottom\":\"17\",\"left\":\"24\",\"isLinked\":false},\"mf_input_border_border\":\"solid\",\"mf_input_border_width\":{\"unit\":\"px\",\"top\":\"1\",\"right\":\"1\",\"bottom\":\"1\",\"left\":\"1\",\"isLinked\":true},\"mf_input_border_color\":\"#EAECF1\",\"mf_input_typgraphy_typography\":\"custom\",\"mf_input_typgraphy_font_family\":\"IBM Plex Sans\",\"mf_input_typgraphy_font_size\":{\"unit\":\"px\",\"size\":14,\"sizes\":[]},\"mf_input_typgraphy_font_weight\":\"400\",\"mf_input_typgraphy_line_height\":{\"unit\":\"px\",\"size\":18,\"sizes\":[]},\"mf_input_border_radius\":{\"unit\":\"px\",\"size\":6,\"sizes\":[]},\"mf_input_place_holder_typography_typography\":\"custom\",\"mf_input_place_holder_typography_font_family\":\"IBM Plex Sans\",\"mf_input_place_holder_typography_font_weight\":\"400\",\"mf_input_placeholder_color\":\"#878991\",\"mf_input_validation_warning_message\":\"This field is required.\",\"mf_conditional_logic_form_list\":[],\"mf_input_label_typography_line_height_tablet\":{\"unit\":\"px\",\"size\":\"\",\"sizes\":[]},\"mf_input_label_typography_line_height_mobile\":{\"unit\":\"px\",\"size\":\"\",\"sizes\":[]},\"mf_input_background_background\":\"classic\",\"mf_input_background_color\":\"#F6F7FA\",\"mf_input_background_hover_color\":\"#FFFFFF\",\"mf_input_background_focus_background\":\"classic\",\"mf_input_background_focus_color\":\"#FFFFFF\",\"mf_input_typgraphy_line_height_tablet\":{\"unit\":\"px\",\"size\":\"\",\"sizes\":[]},\"mf_input_typgraphy_line_height_mobile\":{\"unit\":\"px\",\"size\":\"\",\"sizes\":[]},\"mf_input_typgraphy_word_spacing_tablet\":{\"unit\":\"px\",\"size\":\"\",\"sizes\":[]},\"mf_input_typgraphy_word_spacing_mobile\":{\"unit\":\"px\",\"size\":\"\",\"sizes\":[]},\"mf_input_place_holder_typography_font_size\":{\"unit\":\"px\",\"size\":14,\"sizes\":[]},\"mf_input_place_holder_typography_line_height\":{\"unit\":\"px\",\"size\":18,\"sizes\":[]},\"mf_input_place_holder_typography_line_height_tablet\":{\"unit\":\"px\",\"size\":\"\",\"sizes\":[]},\"mf_input_place_holder_typography_line_height_mobile\":{\"unit\":\"px\",\"size\":\"\",\"sizes\":[]},\"ekit_all_conditions_list\":[{\"_id\":\"30812ac\"}],\"ekit_adv_tooltip_content\":\"Tooltip Content.\",\"mf_input_color\":\"#0D1427\",\"mf_input_border_focus_border\":\"solid\",\"mf_input_border_focus_color\":\"#D6D8E0\",\"mf_input_help_text_typography_typography\":\"custom\",\"mf_input_help_text_typography_font_family\":\"IBM Plex Sans\",\"mf_input_help_text_typography_font_size\":{\"unit\":\"px\",\"size\":13,\"sizes\":[]},\"mf_input_help_text_typography_font_weight\":\"400\",\"mf_input_help_text_typography_line_height\":{\"unit\":\"px\",\"size\":17,\"sizes\":[]},\"mf_input_help_text_typography_line_height_tablet\":{\"unit\":\"px\",\"size\":\"\",\"sizes\":[]},\"mf_input_help_text_typography_line_height_mobile\":{\"unit\":\"px\",\"size\":\"\",\"sizes\":[]},\"mf_input_help_text_color\":\"#96989F\",\"__globals__\":{\"mf_input_required_indicator_color\":\"\",\"mf_input_warning_text_color\":\"\"}},\"elements\":[],\"isInner\":false,\"widgetType\":\"mf-email\",\"elType\":\"widget\"},{\"id\":\"452c321f\",\"settings\":{\"mf_input_label\":\"Subject\",\"mf_input_name\":\"mf-subject\",\"mf_input_placeholder\":\"How can we help you?\",\"mf_input_required\":\"yes\",\"mf_input_label_color\":\"#0D1427\",\"mf_input_label_typography_typography\":\"custom\",\"mf_input_label_typography_font_family\":\"IBM Plex Sans\",\"mf_input_label_typography_font_size\":{\"unit\":\"px\",\"size\":16,\"sizes\":[]},\"mf_input_label_typography_font_weight\":\"500\",\"mf_input_label_typography_line_height\":{\"unit\":\"px\",\"size\":21,\"sizes\":[]},\"mf_input_label_margin\":{\"unit\":\"px\",\"top\":\"0\",\"right\":\"0\",\"bottom\":\"7\",\"left\":\"0\",\"isLinked\":false},\"mf_input_padding\":{\"unit\":\"px\",\"top\":\"15\",\"right\":\"24\",\"bottom\":\"17\",\"left\":\"24\",\"isLinked\":false},\"mf_input_border_border\":\"solid\",\"mf_input_border_width\":{\"unit\":\"px\",\"top\":\"1\",\"right\":\"1\",\"bottom\":\"1\",\"left\":\"1\",\"isLinked\":true},\"mf_input_border_color\":\"#EAECF1\",\"mf_input_typgraphy_typography\":\"custom\",\"mf_input_typgraphy_font_family\":\"IBM Plex Sans\",\"mf_input_typgraphy_font_size\":{\"unit\":\"px\",\"size\":14,\"sizes\":[]},\"mf_input_typgraphy_font_weight\":\"400\",\"mf_input_typgraphy_line_height\":{\"unit\":\"px\",\"size\":18,\"sizes\":[]},\"mf_input_border_radius\":{\"unit\":\"px\",\"size\":6,\"sizes\":[]},\"mf_input_place_holder_typography_typography\":\"custom\",\"mf_input_place_holder_typography_font_family\":\"IBM Plex Sans\",\"mf_input_place_holder_typography_font_weight\":\"400\",\"mf_input_placeholder_color\":\"#878991\",\"mf_input_validation_warning_message\":\"This field is required.\",\"mf_conditional_logic_form_list\":[],\"mf_input_label_typography_line_height_tablet\":{\"unit\":\"px\",\"size\":\"\",\"sizes\":[]},\"mf_input_label_typography_line_height_mobile\":{\"unit\":\"px\",\"size\":\"\",\"sizes\":[]},\"mf_input_background_background\":\"classic\",\"mf_input_background_color\":\"#F6F7FA\",\"mf_input_background_hover_color\":\"#FFFFFF\",\"mf_input_background_focus_background\":\"classic\",\"mf_input_background_focus_color\":\"#FFFFFF\",\"mf_input_typgraphy_line_height_tablet\":{\"unit\":\"px\",\"size\":\"\",\"sizes\":[]},\"mf_input_typgraphy_line_height_mobile\":{\"unit\":\"px\",\"size\":\"\",\"sizes\":[]},\"mf_input_typgraphy_word_spacing_tablet\":{\"unit\":\"px\",\"size\":\"\",\"sizes\":[]},\"mf_input_typgraphy_word_spacing_mobile\":{\"unit\":\"px\",\"size\":\"\",\"sizes\":[]},\"mf_input_place_holder_typography_font_size\":{\"unit\":\"px\",\"size\":14,\"sizes\":[]},\"mf_input_place_holder_typography_line_height\":{\"unit\":\"px\",\"size\":18,\"sizes\":[]},\"mf_input_place_holder_typography_line_height_tablet\":{\"unit\":\"px\",\"size\":\"\",\"sizes\":[]},\"mf_input_place_holder_typography_line_height_mobile\":{\"unit\":\"px\",\"size\":\"\",\"sizes\":[]},\"ekit_all_conditions_list\":[{\"_id\":\"30812ac\"}],\"ekit_adv_tooltip_content\":\"Tooltip Content.\",\"mf_input_color\":\"#0D1427\",\"mf_input_border_focus_border\":\"solid\",\"mf_input_border_focus_color\":\"#D6D8E0\",\"mf_input_help_text_typography_typography\":\"custom\",\"mf_input_help_text_typography_font_family\":\"IBM Plex Sans\",\"mf_input_help_text_typography_font_size\":{\"unit\":\"px\",\"size\":13,\"sizes\":[]},\"mf_input_help_text_typography_font_weight\":\"400\",\"mf_input_help_text_typography_line_height\":{\"unit\":\"px\",\"size\":17,\"sizes\":[]},\"mf_input_help_text_typography_line_height_tablet\":{\"unit\":\"px\",\"size\":\"\",\"sizes\":[]},\"mf_input_help_text_typography_line_height_mobile\":{\"unit\":\"px\",\"size\":\"\",\"sizes\":[]},\"mf_input_help_text_color\":\"#96989F\",\"__globals__\":{\"mf_input_required_indicator_color\":\"\",\"mf_input_warning_text_color\":\"\"}},\"elements\":[],\"isInner\":false,\"widgetType\":\"mf-text\",\"elType\":\"widget\"}],\"isInner\":true,\"elType\":\"container\"},{\"id\":\"13f46608\",\"settings\":{\"mf_input_label\":\"Comments / Questions\",\"mf_input_name\":\"mf-comment\",\"mf_input_placeholder\":\"Comments\",\"mf_input_required\":\"yes\",\"mf_input_label_color\":\"#0D1427\",\"mf_input_label_typography_typography\":\"custom\",\"mf_input_label_typography_font_family\":\"IBM Plex Sans\",\"mf_input_label_typography_font_size\":{\"unit\":\"px\",\"size\":16,\"sizes\":[]},\"mf_input_label_typography_font_weight\":\"500\",\"mf_input_label_typography_line_height\":{\"unit\":\"px\",\"size\":21,\"sizes\":[]},\"mf_input_label_margin\":{\"unit\":\"px\",\"top\":\"0\",\"right\":\"0\",\"bottom\":\"7\",\"left\":\"0\",\"isLinked\":false},\"mf_input_padding\":{\"unit\":\"px\",\"top\":\"15\",\"right\":\"24\",\"bottom\":\"15\",\"left\":\"24\",\"isLinked\":false},\"mf_input_border_border\":\"solid\",\"mf_input_border_width\":{\"unit\":\"px\",\"top\":\"1\",\"right\":\"1\",\"bottom\":\"1\",\"left\":\"1\",\"isLinked\":true},\"mf_input_border_color\":\"#EAECF1\",\"mf_input_typgraphy_typography\":\"custom\",\"mf_input_typgraphy_font_family\":\"IBM Plex Sans\",\"mf_input_typgraphy_font_size\":{\"unit\":\"px\",\"size\":14,\"sizes\":[]},\"mf_input_typgraphy_font_weight\":\"400\",\"mf_input_typgraphy_line_height\":{\"unit\":\"px\",\"size\":18,\"sizes\":[]},\"mf_input_border_radius\":{\"unit\":\"px\",\"size\":6,\"sizes\":[]},\"mf_input_place_holder_typography_typography\":\"custom\",\"mf_input_place_holder_typography_font_family\":\"IBM Plex Sans\",\"mf_input_place_holder_typography_font_weight\":\"500\",\"mf_input_placeholder_color\":\"#878991\",\"mf_textarea_field_height\":{\"unit\":\"px\",\"size\":180,\"sizes\":[]},\"mf_input_validation_warning_message\":\"This field is required.\",\"mf_conditional_logic_form_list\":[],\"mf_input_label_typography_line_height_tablet\":{\"unit\":\"px\",\"size\":\"\",\"sizes\":[]},\"mf_input_label_typography_line_height_mobile\":{\"unit\":\"px\",\"size\":\"\",\"sizes\":[]},\"mf_input_background_background\":\"classic\",\"mf_input_background_color\":\"#F6F7FA\",\"mf_input_background_hover_color\":\"#FFFFFF\",\"mf_input_background_focus_background\":\"classic\",\"mf_input_background_focus_color\":\"#FFFFFF\",\"mf_input_typgraphy_line_height_tablet\":{\"unit\":\"px\",\"size\":\"\",\"sizes\":[]},\"mf_input_typgraphy_line_height_mobile\":{\"unit\":\"px\",\"size\":\"\",\"sizes\":[]},\"mf_input_place_holder_typography_font_size\":{\"unit\":\"px\",\"size\":14,\"sizes\":[]},\"mf_input_place_holder_typography_line_height\":{\"unit\":\"px\",\"size\":18,\"sizes\":[]},\"mf_input_place_holder_typography_line_height_tablet\":{\"unit\":\"px\",\"size\":\"\",\"sizes\":[]},\"mf_input_place_holder_typography_line_height_mobile\":{\"unit\":\"px\",\"size\":\"\",\"sizes\":[]},\"_margin\":{\"unit\":\"px\",\"top\":\"0\",\"right\":\"0\",\"bottom\":\"0\",\"left\":\"0\",\"isLinked\":false},\"ekit_all_conditions_list\":[{\"_id\":\"6609fcf\"}],\"ekit_adv_tooltip_content\":\"Tooltip Content.\",\"mf_input_color\":\"#0D1427\",\"mf_input_border_focus_border\":\"solid\",\"mf_input_border_focus_color\":\"#D6D8E0\",\"mf_input_help_text_typography_typography\":\"custom\",\"mf_input_help_text_typography_font_family\":\"IBM Plex Sans\",\"mf_input_help_text_typography_font_size\":{\"unit\":\"px\",\"size\":13,\"sizes\":[]},\"mf_input_help_text_typography_font_weight\":\"400\",\"mf_input_help_text_typography_line_height\":{\"unit\":\"px\",\"size\":17,\"sizes\":[]},\"mf_input_help_text_typography_line_height_tablet\":{\"unit\":\"px\",\"size\":\"\",\"sizes\":[]},\"mf_input_help_text_typography_line_height_mobile\":{\"unit\":\"px\",\"size\":\"\",\"sizes\":[]},\"mf_input_help_text_color\":\"#96989F\",\"__globals__\":{\"mf_input_required_indicator_color\":\"\",\"mf_input_warning_text_color\":\"\"},\"_element_width\":\"inherit\"},\"elements\":[],\"isInner\":false,\"widgetType\":\"mf-textarea\",\"elType\":\"widget\"},{\"id\":\"50e956bc\",\"settings\":{\"_margin\":{\"unit\":\"px\",\"top\":\"0\",\"right\":\"0\",\"bottom\":\"0\",\"left\":\"0\",\"isLinked\":false},\"mf_recaptcha_type\":\"recaptcha-v2\",\"mf_input_label\":\"reCAPTCHA\",\"mf_input_placeholder\":\"reCAPTCHA\",\"ekit_all_conditions_list\":[{\"_id\":\"ab08d5c\"}],\"ekit_adv_tooltip_content\":\"Tooltip Content.\",\"_element_width\":\"inherit\"},\"elements\":[],\"isInner\":false,\"widgetType\":\"mf-recaptcha\",\"elType\":\"widget\"},{\"id\":\"54379b03\",\"settings\":{\"mf_btn_text\":\"Send Message\",\"mf_btn_align\":\"\",\"mf_btn_text_padding\":{\"unit\":\"px\",\"top\":\"17\",\"right\":\"28\",\"bottom\":\"16\",\"left\":\"28\",\"isLinked\":false},\"mf_btn_typography_typography\":\"custom\",\"mf_btn_typography_font_family\":\"Roboto\",\"mf_btn_typography_font_size\":{\"unit\":\"px\",\"size\":14,\"sizes\":[]},\"mf_btn_typography_font_weight\":\"500\",\"mf_btn_typography_line_height\":{\"unit\":\"px\",\"size\":11,\"sizes\":[]},\"mf_btn_bg_color_background\":\"classic\",\"mf_btn_bg_color_color\":\"#3970FF\",\"mf_btn_box_shadow_group_box_shadow_type\":\"yes\",\"mf_btn_box_shadow_group_box_shadow\":{\"horizontal\":0,\"vertical\":0,\"blur\":0,\"spread\":0,\"color\":\"rgba(0,0,0,0.5)\"},\"mf_conditional_logic_form_list\":[],\"mf_hidden_input\":[],\"mf_btn_typography_line_height_tablet\":{\"unit\":\"px\",\"size\":\"\",\"sizes\":[]},\"mf_btn_typography_line_height_mobile\":{\"unit\":\"px\",\"size\":\"\",\"sizes\":[]},\"mf_btn_text_color\":\"#FFFFFF\",\"mf_btn_bg_hover_color_background\":\"classic\",\"mf_btn_border_radius\":{\"unit\":\"px\",\"top\":\"8\",\"right\":\"8\",\"bottom\":\"8\",\"left\":\"8\",\"isLinked\":true},\"ekit_all_conditions_list\":[{\"_id\":\"eed14b8\"}],\"ekit_adv_tooltip_content\":\"Tooltip Content.\",\"_box_shadow_hover_box_shadow\":{\"horizontal\":0,\"vertical\":2,\"blur\":4,\"spread\":0,\"color\":\"rgba(2.9999999999999996, 28.00000000000002, 90, 0.4)\"},\"mf_btn_hover_color\":\"\",\"_element_width\":\"auto\",\"_border_radius\":{\"unit\":\"px\",\"top\":\"8\",\"right\":\"8\",\"bottom\":\"8\",\"left\":\"8\",\"isLinked\":true},\"_box_shadow_hover_box_shadow_type\":\"yes\",\"_margin\":{\"unit\":\"px\",\"top\":\"0\",\"right\":\"0\",\"bottom\":\"0\",\"left\":\"0\",\"isLinked\":false}},\"elements\":[],\"isInner\":false,\"widgetType\":\"mf-button\",\"elType\":\"widget\"}],\"isInner\":false,\"elType\":\"container\"}]');
INSERT INTO `wp_79e54b1ec2_postmeta` VALUES ('527','109','_wp_page_template','elementor_canvas');
INSERT INTO `wp_79e54b1ec2_postmeta` VALUES ('528','109','_elementor_edit_mode','builder');
INSERT INTO `wp_79e54b1ec2_postmeta` VALUES ('529','109','_elementor_data','[{\"id\":\"46a3f1bf\",\"elType\":\"container\",\"settings\":{\"background_color\":\"#ffffff\",\"box_shadow_box_shadow\":{\"horizontal\":0,\"vertical\":30,\"blur\":50,\"spread\":0,\"color\":\"rgba(3.0000000000000053, 12.000000000000005, 35, 0.08)\"},\"padding\":{\"unit\":\"px\",\"top\":\"40\",\"right\":\"50\",\"bottom\":\"50\",\"left\":\"50\",\"isLinked\":false},\"padding_tablet\":{\"unit\":\"px\",\"top\":\"45\",\"right\":\"15\",\"bottom\":\"45\",\"left\":\"15\",\"isLinked\":false},\"content_width\":\"full\",\"ekit_all_conditions_list\":[{\"_id\":\"2bde398\"}],\"ekit_section_parallax_multi_items\":[],\"flex_direction\":\"row\",\"flex_align_items\":\"stretch\",\"flex_gap\":{\"size\":20,\"column\":\"20\",\"row\":\"20\",\"unit\":\"px\",\"isLinked\":true},\"flex_wrap\":\"wrap\"},\"elements\":[{\"id\":\"5356f21a\",\"elType\":\"widget\",\"settings\":{\"title\":\"Simple Contact Form\",\"header_size\":\"h3\",\"title_color\":\"#0D1427\",\"typography_typography\":\"custom\",\"typography_font_family\":\"IBM Plex Sans\",\"typography_font_size\":{\"unit\":\"px\",\"size\":26,\"sizes\":[]},\"typography_font_weight\":\"700\",\"typography_line_height\":{\"unit\":\"px\",\"size\":34,\"sizes\":[]},\"typography_line_height_tablet\":{\"unit\":\"px\",\"size\":\"\",\"sizes\":[]},\"typography_line_height_mobile\":{\"unit\":\"px\",\"size\":\"\",\"sizes\":[]},\"_padding\":{\"unit\":\"px\",\"top\":\"12\",\"right\":\"15\",\"bottom\":\"8\",\"left\":\"0\",\"isLinked\":false},\"ekit_all_conditions_list\":[{\"_id\":\"63c841d\"}],\"ekit_adv_tooltip_content\":\"Tooltip Content.\"},\"elements\":[],\"widgetType\":\"heading\"},{\"id\":\"65b14f34\",\"elType\":\"container\",\"settings\":{\"structure\":\"20\",\"content_width\":\"full\",\"ekit_all_conditions_list\":[{\"_id\":\"0fbbc40\"}],\"ekit_section_parallax_multi_items\":[],\"flex_direction\":\"row\",\"flex_align_items\":\"stretch\",\"flex_gap\":{\"size\":10,\"column\":\"10\",\"row\":\"10\",\"unit\":\"px\"},\"container_type\":\"grid\",\"grid_columns_grid\":{\"unit\":\"fr\",\"size\":2,\"sizes\":[]},\"grid_rows_grid\":{\"unit\":\"fr\",\"size\":1,\"sizes\":[]},\"grid_gaps\":{\"column\":\"30\",\"row\":\"20\",\"isLinked\":false,\"unit\":\"px\"},\"metform_multistep_settings_title\":\"\",\"metform_multistep_settings_icon\":{\"value\":\"\",\"library\":\"\"},\"padding\":{\"unit\":\"px\",\"top\":\"0\",\"right\":\"0\",\"bottom\":\"0\",\"left\":\"0\",\"isLinked\":false},\"presetTitle\":\"Grid\",\"presetIcon\":\"eicon-container-grid\"},\"elements\":[{\"id\":\"229b8a8\",\"elType\":\"widget\",\"settings\":{\"mf_input_label\":\"First Name\",\"mf_input_name\":\"mf-first-name\",\"mf_input_placeholder\":\"First name here\",\"mf_input_label_typography_typography\":\"custom\",\"mf_input_label_typography_font_family\":\"IBM Plex Sans\",\"mf_input_label_typography_font_size\":{\"unit\":\"px\",\"size\":16,\"sizes\":[]},\"mf_input_label_typography_font_weight\":\"500\",\"mf_input_label_typography_line_height\":{\"unit\":\"px\",\"size\":21,\"sizes\":[]},\"mf_input_min_length\":1,\"mf_input_label_color\":\"#0D1427\",\"mf_input_label_margin\":{\"unit\":\"px\",\"top\":\"0\",\"right\":\"0\",\"bottom\":\"7\",\"left\":\"0\",\"isLinked\":false},\"mf_input_padding\":{\"unit\":\"px\",\"top\":\"15\",\"right\":\"24\",\"bottom\":\"17\",\"left\":\"24\",\"isLinked\":false},\"mf_input_border_border\":\"solid\",\"mf_input_border_width\":{\"unit\":\"px\",\"top\":\"1\",\"right\":\"1\",\"bottom\":\"1\",\"left\":\"1\",\"isLinked\":true},\"mf_input_border_color\":\"#EAECF1\",\"mf_input_typgraphy_typography\":\"custom\",\"mf_input_typgraphy_font_family\":\"IBM Plex Sans\",\"mf_input_typgraphy_font_size\":{\"unit\":\"px\",\"size\":14,\"sizes\":[]},\"mf_input_typgraphy_font_weight\":\"400\",\"mf_input_typgraphy_line_height\":{\"unit\":\"px\",\"size\":18,\"sizes\":[]},\"mf_input_border_radius\":{\"unit\":\"px\",\"size\":6,\"sizes\":[]},\"mf_input_place_holder_typography_typography\":\"custom\",\"mf_input_place_holder_typography_font_family\":\"IBM Plex Sans\",\"mf_input_place_holder_typography_font_weight\":\"400\",\"mf_input_placeholder_color\":\"#878991\",\"mf_input_required\":\"yes\",\"mf_input_validation_warning_message\":\"This field is required.\",\"mf_conditional_logic_form_list\":[],\"mf_input_label_typography_line_height_tablet\":{\"unit\":\"px\",\"size\":\"\",\"sizes\":[]},\"mf_input_label_typography_line_height_mobile\":{\"unit\":\"px\",\"size\":\"\",\"sizes\":[]},\"mf_input_background_background\":\"classic\",\"mf_input_background_color\":\"#F6F7FA\",\"mf_input_background_hover_color\":\"#FFFFFF\",\"mf_input_background_focus_background\":\"classic\",\"mf_input_background_focus_color\":\"#FFFFFF\",\"mf_input_typgraphy_line_height_tablet\":{\"unit\":\"px\",\"size\":\"\",\"sizes\":[]},\"mf_input_typgraphy_line_height_mobile\":{\"unit\":\"px\",\"size\":\"\",\"sizes\":[]},\"mf_input_typgraphy_word_spacing_tablet\":{\"unit\":\"px\",\"size\":\"\",\"sizes\":[]},\"mf_input_typgraphy_word_spacing_mobile\":{\"unit\":\"px\",\"size\":\"\",\"sizes\":[]},\"mf_input_place_holder_typography_font_size\":{\"unit\":\"px\",\"size\":14,\"sizes\":[]},\"mf_input_place_holder_typography_line_height\":{\"unit\":\"px\",\"size\":18,\"sizes\":[]},\"mf_input_place_holder_typography_line_height_tablet\":{\"unit\":\"px\",\"size\":\"\",\"sizes\":[]},\"mf_input_place_holder_typography_line_height_mobile\":{\"unit\":\"px\",\"size\":\"\",\"sizes\":[]},\"ekit_all_conditions_list\":[{\"_id\":\"30812ac\"}],\"ekit_adv_tooltip_content\":\"Tooltip Content.\",\"mf_input_color\":\"#0D1427\",\"mf_input_border_focus_border\":\"solid\",\"mf_input_border_focus_color\":\"#D6D8E0\",\"mf_input_help_text_typography_typography\":\"custom\",\"mf_input_help_text_typography_font_family\":\"IBM Plex Sans\",\"mf_input_help_text_typography_font_size\":{\"unit\":\"px\",\"size\":13,\"sizes\":[]},\"mf_input_help_text_typography_font_weight\":\"400\",\"mf_input_help_text_typography_line_height\":{\"unit\":\"px\",\"size\":17,\"sizes\":[]},\"mf_input_help_text_typography_line_height_tablet\":{\"unit\":\"px\",\"size\":\"\",\"sizes\":[]},\"mf_input_help_text_typography_line_height_mobile\":{\"unit\":\"px\",\"size\":\"\",\"sizes\":[]},\"mf_input_help_text_color\":\"#96989F\",\"__globals__\":{\"mf_input_required_indicator_color\":\"\",\"mf_input_warning_text_color\":\"\"},\"mf_input_warning_text_typography_typography\":\"custom\",\"mf_input_warning_text_typography_font_family\":\"Roboto\",\"mf_input_warning_text_typography_font_weight\":\"600\"},\"elements\":[],\"widgetType\":\"mf-text\"},{\"id\":\"1a922000\",\"elType\":\"widget\",\"settings\":{\"mf_input_label\":\"Last Name\",\"mf_input_name\":\"mf-last-name\",\"mf_input_placeholder\":\"Last name here\",\"mf_input_label_color\":\"#0D1427\",\"mf_input_label_typography_typography\":\"custom\",\"mf_input_label_typography_font_family\":\"IBM Plex Sans\",\"mf_input_label_typography_font_size\":{\"unit\":\"px\",\"size\":16,\"sizes\":[]},\"mf_input_label_typography_font_weight\":\"500\",\"mf_input_label_typography_line_height\":{\"unit\":\"px\",\"size\":21,\"sizes\":[]},\"mf_input_label_margin\":{\"unit\":\"px\",\"top\":\"0\",\"right\":\"0\",\"bottom\":\"7\",\"left\":\"0\",\"isLinked\":false},\"mf_input_padding\":{\"unit\":\"px\",\"top\":\"15\",\"right\":\"24\",\"bottom\":\"17\",\"left\":\"24\",\"isLinked\":false},\"mf_input_border_border\":\"solid\",\"mf_input_border_width\":{\"unit\":\"px\",\"top\":\"1\",\"right\":\"1\",\"bottom\":\"1\",\"left\":\"1\",\"isLinked\":true},\"mf_input_border_color\":\"#EAECF1\",\"mf_input_typgraphy_typography\":\"custom\",\"mf_input_typgraphy_font_family\":\"IBM Plex Sans\",\"mf_input_typgraphy_font_size\":{\"unit\":\"px\",\"size\":14,\"sizes\":[]},\"mf_input_typgraphy_font_weight\":\"400\",\"mf_input_typgraphy_line_height\":{\"unit\":\"px\",\"size\":18,\"sizes\":[]},\"mf_input_border_radius\":{\"unit\":\"px\",\"size\":6,\"sizes\":[]},\"mf_input_place_holder_typography_typography\":\"custom\",\"mf_input_place_holder_typography_font_family\":\"IBM Plex Sans\",\"mf_input_place_holder_typography_font_weight\":\"400\",\"mf_input_placeholder_color\":\"#878991\",\"mf_input_required\":\"yes\",\"mf_input_validation_warning_message\":\"This field is required.\",\"mf_conditional_logic_form_list\":[],\"mf_input_label_typography_line_height_tablet\":{\"unit\":\"px\",\"size\":\"\",\"sizes\":[]},\"mf_input_label_typography_line_height_mobile\":{\"unit\":\"px\",\"size\":\"\",\"sizes\":[]},\"mf_input_background_background\":\"classic\",\"mf_input_background_color\":\"#F6F7FA\",\"mf_input_background_hover_color\":\"#FFFFFF\",\"mf_input_background_focus_background\":\"classic\",\"mf_input_background_focus_color\":\"#FFFFFF\",\"mf_input_typgraphy_line_height_tablet\":{\"unit\":\"px\",\"size\":\"\",\"sizes\":[]},\"mf_input_typgraphy_line_height_mobile\":{\"unit\":\"px\",\"size\":\"\",\"sizes\":[]},\"mf_input_typgraphy_word_spacing_tablet\":{\"unit\":\"px\",\"size\":\"\",\"sizes\":[]},\"mf_input_typgraphy_word_spacing_mobile\":{\"unit\":\"px\",\"size\":\"\",\"sizes\":[]},\"mf_input_place_holder_typography_font_size\":{\"unit\":\"px\",\"size\":14,\"sizes\":[]},\"mf_input_place_holder_typography_line_height\":{\"unit\":\"px\",\"size\":18,\"sizes\":[]},\"mf_input_place_holder_typography_line_height_tablet\":{\"unit\":\"px\",\"size\":\"\",\"sizes\":[]},\"mf_input_place_holder_typography_line_height_mobile\":{\"unit\":\"px\",\"size\":\"\",\"sizes\":[]},\"ekit_all_conditions_list\":[{\"_id\":\"30812ac\"}],\"ekit_adv_tooltip_content\":\"Tooltip Content.\",\"mf_input_color\":\"#0D1427\",\"mf_input_border_focus_border\":\"solid\",\"mf_input_border_focus_color\":\"#D6D8E0\",\"mf_input_help_text_typography_typography\":\"custom\",\"mf_input_help_text_typography_font_family\":\"IBM Plex Sans\",\"mf_input_help_text_typography_font_size\":{\"unit\":\"px\",\"size\":13,\"sizes\":[]},\"mf_input_help_text_typography_font_weight\":\"400\",\"mf_input_help_text_typography_line_height\":{\"unit\":\"px\",\"size\":17,\"sizes\":[]},\"mf_input_help_text_typography_line_height_tablet\":{\"unit\":\"px\",\"size\":\"\",\"sizes\":[]},\"mf_input_help_text_typography_line_height_mobile\":{\"unit\":\"px\",\"size\":\"\",\"sizes\":[]},\"mf_input_help_text_color\":\"#96989F\",\"__globals__\":{\"mf_input_required_indicator_color\":\"\",\"mf_input_warning_text_color\":\"\"}},\"elements\":[],\"widgetType\":\"mf-text\"},{\"id\":\"752b6f44\",\"elType\":\"widget\",\"settings\":{\"mf_input_label\":\"Email Address\",\"mf_input_name\":\"mf-email\",\"mf_input_placeholder\":\"Add email\",\"mf_input_required\":\"yes\",\"mf_input_label_color\":\"#0D1427\",\"mf_input_label_typography_typography\":\"custom\",\"mf_input_label_typography_font_family\":\"IBM Plex Sans\",\"mf_input_label_typography_font_size\":{\"unit\":\"px\",\"size\":16,\"sizes\":[]},\"mf_input_label_typography_font_weight\":\"500\",\"mf_input_label_typography_line_height\":{\"unit\":\"px\",\"size\":21,\"sizes\":[]},\"mf_input_label_margin\":{\"unit\":\"px\",\"top\":\"0\",\"right\":\"0\",\"bottom\":\"7\",\"left\":\"0\",\"isLinked\":false},\"mf_input_padding\":{\"unit\":\"px\",\"top\":\"15\",\"right\":\"24\",\"bottom\":\"17\",\"left\":\"24\",\"isLinked\":false},\"mf_input_border_border\":\"solid\",\"mf_input_border_width\":{\"unit\":\"px\",\"top\":\"1\",\"right\":\"1\",\"bottom\":\"1\",\"left\":\"1\",\"isLinked\":true},\"mf_input_border_color\":\"#EAECF1\",\"mf_input_typgraphy_typography\":\"custom\",\"mf_input_typgraphy_font_family\":\"IBM Plex Sans\",\"mf_input_typgraphy_font_size\":{\"unit\":\"px\",\"size\":14,\"sizes\":[]},\"mf_input_typgraphy_font_weight\":\"400\",\"mf_input_typgraphy_line_height\":{\"unit\":\"px\",\"size\":18,\"sizes\":[]},\"mf_input_border_radius\":{\"unit\":\"px\",\"size\":6,\"sizes\":[]},\"mf_input_place_holder_typography_typography\":\"custom\",\"mf_input_place_holder_typography_font_family\":\"IBM Plex Sans\",\"mf_input_place_holder_typography_font_weight\":\"400\",\"mf_input_placeholder_color\":\"#878991\",\"mf_input_validation_warning_message\":\"This field is required.\",\"mf_conditional_logic_form_list\":[],\"mf_input_label_typography_line_height_tablet\":{\"unit\":\"px\",\"size\":\"\",\"sizes\":[]},\"mf_input_label_typography_line_height_mobile\":{\"unit\":\"px\",\"size\":\"\",\"sizes\":[]},\"mf_input_background_background\":\"classic\",\"mf_input_background_color\":\"#F6F7FA\",\"mf_input_background_hover_color\":\"#FFFFFF\",\"mf_input_background_focus_background\":\"classic\",\"mf_input_background_focus_color\":\"#FFFFFF\",\"mf_input_typgraphy_line_height_tablet\":{\"unit\":\"px\",\"size\":\"\",\"sizes\":[]},\"mf_input_typgraphy_line_height_mobile\":{\"unit\":\"px\",\"size\":\"\",\"sizes\":[]},\"mf_input_typgraphy_word_spacing_tablet\":{\"unit\":\"px\",\"size\":\"\",\"sizes\":[]},\"mf_input_typgraphy_word_spacing_mobile\":{\"unit\":\"px\",\"size\":\"\",\"sizes\":[]},\"mf_input_place_holder_typography_font_size\":{\"unit\":\"px\",\"size\":14,\"sizes\":[]},\"mf_input_place_holder_typography_line_height\":{\"unit\":\"px\",\"size\":18,\"sizes\":[]},\"mf_input_place_holder_typography_line_height_tablet\":{\"unit\":\"px\",\"size\":\"\",\"sizes\":[]},\"mf_input_place_holder_typography_line_height_mobile\":{\"unit\":\"px\",\"size\":\"\",\"sizes\":[]},\"ekit_all_conditions_list\":[{\"_id\":\"30812ac\"}],\"ekit_adv_tooltip_content\":\"Tooltip Content.\",\"mf_input_color\":\"#0D1427\",\"mf_input_border_focus_border\":\"solid\",\"mf_input_border_focus_color\":\"#D6D8E0\",\"mf_input_help_text_typography_typography\":\"custom\",\"mf_input_help_text_typography_font_family\":\"IBM Plex Sans\",\"mf_input_help_text_typography_font_size\":{\"unit\":\"px\",\"size\":13,\"sizes\":[]},\"mf_input_help_text_typography_font_weight\":\"400\",\"mf_input_help_text_typography_line_height\":{\"unit\":\"px\",\"size\":17,\"sizes\":[]},\"mf_input_help_text_typography_line_height_tablet\":{\"unit\":\"px\",\"size\":\"\",\"sizes\":[]},\"mf_input_help_text_typography_line_height_mobile\":{\"unit\":\"px\",\"size\":\"\",\"sizes\":[]},\"mf_input_help_text_color\":\"#96989F\",\"__globals__\":{\"mf_input_required_indicator_color\":\"\",\"mf_input_warning_text_color\":\"\"}},\"elements\":[],\"widgetType\":\"mf-email\"},{\"id\":\"452c321f\",\"elType\":\"widget\",\"settings\":{\"mf_input_label\":\"Subject\",\"mf_input_name\":\"mf-subject\",\"mf_input_placeholder\":\"How can we help you?\",\"mf_input_required\":\"yes\",\"mf_input_label_color\":\"#0D1427\",\"mf_input_label_typography_typography\":\"custom\",\"mf_input_label_typography_font_family\":\"IBM Plex Sans\",\"mf_input_label_typography_font_size\":{\"unit\":\"px\",\"size\":16,\"sizes\":[]},\"mf_input_label_typography_font_weight\":\"500\",\"mf_input_label_typography_line_height\":{\"unit\":\"px\",\"size\":21,\"sizes\":[]},\"mf_input_label_margin\":{\"unit\":\"px\",\"top\":\"0\",\"right\":\"0\",\"bottom\":\"7\",\"left\":\"0\",\"isLinked\":false},\"mf_input_padding\":{\"unit\":\"px\",\"top\":\"15\",\"right\":\"24\",\"bottom\":\"17\",\"left\":\"24\",\"isLinked\":false},\"mf_input_border_border\":\"solid\",\"mf_input_border_width\":{\"unit\":\"px\",\"top\":\"1\",\"right\":\"1\",\"bottom\":\"1\",\"left\":\"1\",\"isLinked\":true},\"mf_input_border_color\":\"#EAECF1\",\"mf_input_typgraphy_typography\":\"custom\",\"mf_input_typgraphy_font_family\":\"IBM Plex Sans\",\"mf_input_typgraphy_font_size\":{\"unit\":\"px\",\"size\":14,\"sizes\":[]},\"mf_input_typgraphy_font_weight\":\"400\",\"mf_input_typgraphy_line_height\":{\"unit\":\"px\",\"size\":18,\"sizes\":[]},\"mf_input_border_radius\":{\"unit\":\"px\",\"size\":6,\"sizes\":[]},\"mf_input_place_holder_typography_typography\":\"custom\",\"mf_input_place_holder_typography_font_family\":\"IBM Plex Sans\",\"mf_input_place_holder_typography_font_weight\":\"400\",\"mf_input_placeholder_color\":\"#878991\",\"mf_input_validation_warning_message\":\"This field is required.\",\"mf_conditional_logic_form_list\":[],\"mf_input_label_typography_line_height_tablet\":{\"unit\":\"px\",\"size\":\"\",\"sizes\":[]},\"mf_input_label_typography_line_height_mobile\":{\"unit\":\"px\",\"size\":\"\",\"sizes\":[]},\"mf_input_background_background\":\"classic\",\"mf_input_background_color\":\"#F6F7FA\",\"mf_input_background_hover_color\":\"#FFFFFF\",\"mf_input_background_focus_background\":\"classic\",\"mf_input_background_focus_color\":\"#FFFFFF\",\"mf_input_typgraphy_line_height_tablet\":{\"unit\":\"px\",\"size\":\"\",\"sizes\":[]},\"mf_input_typgraphy_line_height_mobile\":{\"unit\":\"px\",\"size\":\"\",\"sizes\":[]},\"mf_input_typgraphy_word_spacing_tablet\":{\"unit\":\"px\",\"size\":\"\",\"sizes\":[]},\"mf_input_typgraphy_word_spacing_mobile\":{\"unit\":\"px\",\"size\":\"\",\"sizes\":[]},\"mf_input_place_holder_typography_font_size\":{\"unit\":\"px\",\"size\":14,\"sizes\":[]},\"mf_input_place_holder_typography_line_height\":{\"unit\":\"px\",\"size\":18,\"sizes\":[]},\"mf_input_place_holder_typography_line_height_tablet\":{\"unit\":\"px\",\"size\":\"\",\"sizes\":[]},\"mf_input_place_holder_typography_line_height_mobile\":{\"unit\":\"px\",\"size\":\"\",\"sizes\":[]},\"ekit_all_conditions_list\":[{\"_id\":\"30812ac\"}],\"ekit_adv_tooltip_content\":\"Tooltip Content.\",\"mf_input_color\":\"#0D1427\",\"mf_input_border_focus_border\":\"solid\",\"mf_input_border_focus_color\":\"#D6D8E0\",\"mf_input_help_text_typography_typography\":\"custom\",\"mf_input_help_text_typography_font_family\":\"IBM Plex Sans\",\"mf_input_help_text_typography_font_size\":{\"unit\":\"px\",\"size\":13,\"sizes\":[]},\"mf_input_help_text_typography_font_weight\":\"400\",\"mf_input_help_text_typography_line_height\":{\"unit\":\"px\",\"size\":17,\"sizes\":[]},\"mf_input_help_text_typography_line_height_tablet\":{\"unit\":\"px\",\"size\":\"\",\"sizes\":[]},\"mf_input_help_text_typography_line_height_mobile\":{\"unit\":\"px\",\"size\":\"\",\"sizes\":[]},\"mf_input_help_text_color\":\"#96989F\",\"__globals__\":{\"mf_input_required_indicator_color\":\"\",\"mf_input_warning_text_color\":\"\"}},\"elements\":[],\"widgetType\":\"mf-text\"}],\"isInner\":true},{\"id\":\"13f46608\",\"elType\":\"widget\",\"settings\":{\"mf_input_label\":\"Comments \\/ Questions\",\"mf_input_name\":\"mf-comment\",\"mf_input_placeholder\":\"Comments\",\"mf_input_required\":\"yes\",\"mf_input_label_color\":\"#0D1427\",\"mf_input_label_typography_typography\":\"custom\",\"mf_input_label_typography_font_family\":\"IBM Plex Sans\",\"mf_input_label_typography_font_size\":{\"unit\":\"px\",\"size\":16,\"sizes\":[]},\"mf_input_label_typography_font_weight\":\"500\",\"mf_input_label_typography_line_height\":{\"unit\":\"px\",\"size\":21,\"sizes\":[]},\"mf_input_label_margin\":{\"unit\":\"px\",\"top\":\"0\",\"right\":\"0\",\"bottom\":\"7\",\"left\":\"0\",\"isLinked\":false},\"mf_input_padding\":{\"unit\":\"px\",\"top\":\"15\",\"right\":\"24\",\"bottom\":\"15\",\"left\":\"24\",\"isLinked\":false},\"mf_input_border_border\":\"solid\",\"mf_input_border_width\":{\"unit\":\"px\",\"top\":\"1\",\"right\":\"1\",\"bottom\":\"1\",\"left\":\"1\",\"isLinked\":true},\"mf_input_border_color\":\"#EAECF1\",\"mf_input_typgraphy_typography\":\"custom\",\"mf_input_typgraphy_font_family\":\"IBM Plex Sans\",\"mf_input_typgraphy_font_size\":{\"unit\":\"px\",\"size\":14,\"sizes\":[]},\"mf_input_typgraphy_font_weight\":\"400\",\"mf_input_typgraphy_line_height\":{\"unit\":\"px\",\"size\":18,\"sizes\":[]},\"mf_input_border_radius\":{\"unit\":\"px\",\"size\":6,\"sizes\":[]},\"mf_input_place_holder_typography_typography\":\"custom\",\"mf_input_place_holder_typography_font_family\":\"IBM Plex Sans\",\"mf_input_place_holder_typography_font_weight\":\"500\",\"mf_input_placeholder_color\":\"#878991\",\"mf_textarea_field_height\":{\"unit\":\"px\",\"size\":180,\"sizes\":[]},\"mf_input_validation_warning_message\":\"This field is required.\",\"mf_conditional_logic_form_list\":[],\"mf_input_label_typography_line_height_tablet\":{\"unit\":\"px\",\"size\":\"\",\"sizes\":[]},\"mf_input_label_typography_line_height_mobile\":{\"unit\":\"px\",\"size\":\"\",\"sizes\":[]},\"mf_input_background_background\":\"classic\",\"mf_input_background_color\":\"#F6F7FA\",\"mf_input_background_hover_color\":\"#FFFFFF\",\"mf_input_background_focus_background\":\"classic\",\"mf_input_background_focus_color\":\"#FFFFFF\",\"mf_input_typgraphy_line_height_tablet\":{\"unit\":\"px\",\"size\":\"\",\"sizes\":[]},\"mf_input_typgraphy_line_height_mobile\":{\"unit\":\"px\",\"size\":\"\",\"sizes\":[]},\"mf_input_place_holder_typography_font_size\":{\"unit\":\"px\",\"size\":14,\"sizes\":[]},\"mf_input_place_holder_typography_line_height\":{\"unit\":\"px\",\"size\":18,\"sizes\":[]},\"mf_input_place_holder_typography_line_height_tablet\":{\"unit\":\"px\",\"size\":\"\",\"sizes\":[]},\"mf_input_place_holder_typography_line_height_mobile\":{\"unit\":\"px\",\"size\":\"\",\"sizes\":[]},\"_margin\":{\"unit\":\"px\",\"top\":\"0\",\"right\":\"0\",\"bottom\":\"0\",\"left\":\"0\",\"isLinked\":false},\"ekit_all_conditions_list\":[{\"_id\":\"6609fcf\"}],\"ekit_adv_tooltip_content\":\"Tooltip Content.\",\"mf_input_color\":\"#0D1427\",\"mf_input_border_focus_border\":\"solid\",\"mf_input_border_focus_color\":\"#D6D8E0\",\"mf_input_help_text_typography_typography\":\"custom\",\"mf_input_help_text_typography_font_family\":\"IBM Plex Sans\",\"mf_input_help_text_typography_font_size\":{\"unit\":\"px\",\"size\":13,\"sizes\":[]},\"mf_input_help_text_typography_font_weight\":\"400\",\"mf_input_help_text_typography_line_height\":{\"unit\":\"px\",\"size\":17,\"sizes\":[]},\"mf_input_help_text_typography_line_height_tablet\":{\"unit\":\"px\",\"size\":\"\",\"sizes\":[]},\"mf_input_help_text_typography_line_height_mobile\":{\"unit\":\"px\",\"size\":\"\",\"sizes\":[]},\"mf_input_help_text_color\":\"#96989F\",\"__globals__\":{\"mf_input_required_indicator_color\":\"\",\"mf_input_warning_text_color\":\"\"},\"_element_width\":\"inherit\"},\"elements\":[],\"widgetType\":\"mf-textarea\"},{\"id\":\"50e956bc\",\"elType\":\"widget\",\"settings\":{\"_margin\":{\"unit\":\"px\",\"top\":\"0\",\"right\":\"0\",\"bottom\":\"0\",\"left\":\"0\",\"isLinked\":false},\"mf_recaptcha_type\":\"recaptcha-v2\",\"mf_input_label\":\"reCAPTCHA\",\"mf_input_placeholder\":\"reCAPTCHA\",\"ekit_all_conditions_list\":[{\"_id\":\"ab08d5c\"}],\"ekit_adv_tooltip_content\":\"Tooltip Content.\",\"_element_width\":\"inherit\"},\"elements\":[],\"widgetType\":\"mf-recaptcha\"},{\"id\":\"54379b03\",\"elType\":\"widget\",\"settings\":{\"mf_btn_text\":\"Send Message\",\"mf_btn_align\":\"\",\"mf_btn_text_padding\":{\"unit\":\"px\",\"top\":\"17\",\"right\":\"28\",\"bottom\":\"16\",\"left\":\"28\",\"isLinked\":false},\"mf_btn_typography_typography\":\"custom\",\"mf_btn_typography_font_family\":\"Roboto\",\"mf_btn_typography_font_size\":{\"unit\":\"px\",\"size\":14,\"sizes\":[]},\"mf_btn_typography_font_weight\":\"500\",\"mf_btn_typography_line_height\":{\"unit\":\"px\",\"size\":11,\"sizes\":[]},\"mf_btn_bg_color_background\":\"classic\",\"mf_btn_box_shadow_group_box_shadow_type\":\"yes\",\"mf_btn_box_shadow_group_box_shadow\":{\"horizontal\":0,\"vertical\":0,\"blur\":0,\"spread\":0,\"color\":\"rgba(0,0,0,0.5)\"},\"mf_conditional_logic_form_list\":[],\"mf_hidden_input\":[],\"mf_btn_typography_line_height_tablet\":{\"unit\":\"px\",\"size\":\"\",\"sizes\":[]},\"mf_btn_typography_line_height_mobile\":{\"unit\":\"px\",\"size\":\"\",\"sizes\":[]},\"mf_btn_text_color\":\"#FFFFFF\",\"mf_btn_bg_hover_color_background\":\"classic\",\"mf_btn_border_radius\":{\"unit\":\"px\",\"top\":\"8\",\"right\":\"8\",\"bottom\":\"8\",\"left\":\"8\",\"isLinked\":true},\"ekit_all_conditions_list\":[{\"_id\":\"eed14b8\"}],\"ekit_adv_tooltip_content\":\"Tooltip Content.\",\"_box_shadow_hover_box_shadow\":{\"horizontal\":0,\"vertical\":2,\"blur\":4,\"spread\":0,\"color\":\"rgba(2.9999999999999996, 28.00000000000002, 90, 0.4)\"},\"mf_btn_hover_color\":\"\",\"_element_width\":\"auto\",\"_border_radius\":{\"unit\":\"px\",\"top\":\"8\",\"right\":\"8\",\"bottom\":\"8\",\"left\":\"8\",\"isLinked\":true},\"_box_shadow_hover_box_shadow_type\":\"yes\",\"_margin\":{\"unit\":\"px\",\"top\":\"0\",\"right\":\"0\",\"bottom\":\"0\",\"left\":\"0\",\"isLinked\":false},\"__globals__\":{\"mf_btn_bg_color_color\":\"globals\\/colors?id=accent\"}},\"elements\":[],\"widgetType\":\"mf-button\"}],\"isInner\":false}]');
INSERT INTO `wp_79e54b1ec2_postmeta` VALUES ('532','106','_elementor_template_type','wp-post');
INSERT INTO `wp_79e54b1ec2_postmeta` VALUES ('533','106','_elementor_version','3.32.5');
INSERT INTO `wp_79e54b1ec2_postmeta` VALUES ('725','137','_elementor_edit_mode','builder');
INSERT INTO `wp_79e54b1ec2_postmeta` VALUES ('726','137','_elementor_template_type','kit');
INSERT INTO `wp_79e54b1ec2_postmeta` VALUES ('727','137','_elementor_version','3.32.5');
INSERT INTO `wp_79e54b1ec2_postmeta` VALUES ('728','137','_elementor_pro_version','3.11.2');
INSERT INTO `wp_79e54b1ec2_postmeta` VALUES ('729','138','_elementor_edit_mode','builder');
INSERT INTO `wp_79e54b1ec2_postmeta` VALUES ('730','138','_elementor_template_type','section');
INSERT INTO `wp_79e54b1ec2_postmeta` VALUES ('731','138','_elementor_version','3.32.5');
INSERT INTO `wp_79e54b1ec2_postmeta` VALUES ('732','138','_elementor_pro_version','3.11.2');
INSERT INTO `wp_79e54b1ec2_postmeta` VALUES ('733','137','_wp_page_template','default');
INSERT INTO `wp_79e54b1ec2_postmeta` VALUES ('734','137','_elementor_page_settings','a:157:{s:13:\"system_colors\";a:4:{i:0;a:3:{s:3:\"_id\";s:9:\"secondary\";s:5:\"title\";s:7:\"Heading\";s:5:\"color\";s:7:\"#F8F8F8\";}i:1;a:3:{s:3:\"_id\";s:7:\"primary\";s:5:\"title\";s:10:\"Basic Text\";s:5:\"color\";s:7:\"#AEB0B2\";}i:2;a:3:{s:3:\"_id\";s:4:\"text\";s:5:\"title\";s:6:\"Netral\";s:5:\"color\";s:7:\"#FFFFFF\";}i:3;a:3:{s:3:\"_id\";s:6:\"accent\";s:5:\"title\";s:15:\"Transparent 20%\";s:5:\"color\";s:9:\"#FFFFFF2B\";}}s:13:\"custom_colors\";a:12:{i:0;a:3:{s:3:\"_id\";s:7:\"d49ac81\";s:5:\"title\";s:6:\"Button\";s:5:\"color\";s:7:\"#004483\";}i:1;a:3:{s:3:\"_id\";s:7:\"332724a\";s:5:\"title\";s:12:\"Button Hover\";s:5:\"color\";s:7:\"#E69900\";}i:2;a:3:{s:3:\"_id\";s:7:\"4d462f5\";s:5:\"title\";s:10:\"Line Color\";s:5:\"color\";s:7:\"#414F62\";}i:3;a:3:{s:3:\"_id\";s:7:\"cfa1f76\";s:5:\"title\";s:16:\"Light Background\";s:5:\"color\";s:7:\"#001F3D\";}i:4;a:3:{s:3:\"_id\";s:7:\"7fbea4f\";s:5:\"title\";s:22:\"Extra Light Background\";s:5:\"color\";s:7:\"#002A52\";}i:5;a:3:{s:3:\"_id\";s:7:\"044b931\";s:5:\"title\";s:15:\"Dark Background\";s:5:\"color\";s:7:\"#001429\";}i:6;a:3:{s:3:\"_id\";s:7:\"638d055\";s:5:\"title\";s:21:\"Extra Dark Background\";s:5:\"color\";s:7:\"#000814\";}i:7;a:3:{s:3:\"_id\";s:7:\"ec3c7a7\";s:5:\"title\";s:8:\"Accent 1\";s:5:\"color\";s:7:\"#004483\";}i:8;a:3:{s:3:\"_id\";s:7:\"3ee16e7\";s:5:\"title\";s:8:\"Accent 2\";s:5:\"color\";s:7:\"#E69900\";}i:9;a:3:{s:3:\"_id\";s:7:\"c5a94f6\";s:5:\"title\";s:8:\"Accent 3\";s:5:\"color\";s:7:\"#FFAD0A\";}i:10;a:3:{s:3:\"_id\";s:7:\"e5616b2\";s:5:\"title\";s:8:\"Accent 4\";s:5:\"color\";s:7:\"#AD7505\";}i:11;a:3:{s:3:\"_id\";s:7:\"5c3d4b5\";s:5:\"title\";s:8:\"Accent 5\";s:5:\"color\";s:7:\"#231A05\";}}s:17:\"system_typography\";a:4:{i:0;a:9:{s:3:\"_id\";s:7:\"primary\";s:5:\"title\";s:7:\"Primary\";s:21:\"typography_typography\";s:6:\"custom\";s:22:\"typography_font_family\";s:5:\"Exo 2\";s:22:\"typography_font_weight\";s:3:\"600\";s:20:\"typography_font_size\";a:3:{s:4:\"unit\";s:2:\"px\";s:4:\"size\";i:48;s:5:\"sizes\";a:0:{}}s:22:\"typography_line_height\";a:3:{s:4:\"unit\";s:2:\"em\";s:4:\"size\";d:1.2;s:5:\"sizes\";a:0:{}}s:27:\"typography_font_size_tablet\";a:3:{s:4:\"unit\";s:2:\"px\";s:4:\"size\";i:37;s:5:\"sizes\";a:0:{}}s:27:\"typography_font_size_mobile\";a:3:{s:4:\"unit\";s:2:\"px\";s:4:\"size\";i:30;s:5:\"sizes\";a:0:{}}}i:1;a:10:{s:3:\"_id\";s:9:\"secondary\";s:5:\"title\";s:9:\"Secondary\";s:21:\"typography_typography\";s:6:\"custom\";s:22:\"typography_font_family\";s:5:\"Exo 2\";s:22:\"typography_font_weight\";s:3:\"600\";s:20:\"typography_font_size\";a:3:{s:4:\"unit\";s:2:\"px\";s:4:\"size\";i:39;s:5:\"sizes\";a:0:{}}s:22:\"typography_line_height\";a:3:{s:4:\"unit\";s:2:\"em\";s:4:\"size\";d:1.2;s:5:\"sizes\";a:0:{}}s:27:\"typography_font_size_tablet\";a:3:{s:4:\"unit\";s:2:\"px\";s:4:\"size\";i:31;s:5:\"sizes\";a:0:{}}s:27:\"typography_font_size_mobile\";a:3:{s:4:\"unit\";s:2:\"px\";s:4:\"size\";i:24;s:5:\"sizes\";a:0:{}}s:25:\"typography_letter_spacing\";a:3:{s:4:\"unit\";s:2:\"px\";s:4:\"size\";d:-0.5;s:5:\"sizes\";a:0:{}}}i:2;a:9:{s:3:\"_id\";s:4:\"text\";s:5:\"title\";s:4:\"Text\";s:21:\"typography_typography\";s:6:\"custom\";s:22:\"typography_font_family\";s:5:\"Inter\";s:22:\"typography_font_weight\";s:3:\"400\";s:20:\"typography_font_size\";a:3:{s:4:\"unit\";s:2:\"px\";s:4:\"size\";i:16;s:5:\"sizes\";a:0:{}}s:22:\"typography_line_height\";a:3:{s:4:\"unit\";s:2:\"em\";s:4:\"size\";d:1.4;s:5:\"sizes\";a:0:{}}s:27:\"typography_font_size_tablet\";a:3:{s:4:\"unit\";s:2:\"px\";s:4:\"size\";i:15;s:5:\"sizes\";a:0:{}}s:27:\"typography_font_size_mobile\";a:3:{s:4:\"unit\";s:2:\"px\";s:4:\"size\";i:14;s:5:\"sizes\";a:0:{}}}i:3;a:11:{s:3:\"_id\";s:6:\"accent\";s:5:\"title\";s:6:\"Accent\";s:21:\"typography_typography\";s:6:\"custom\";s:22:\"typography_font_family\";s:5:\"Exo 2\";s:22:\"typography_font_weight\";s:3:\"600\";s:20:\"typography_font_size\";a:3:{s:4:\"unit\";s:2:\"px\";s:4:\"size\";i:14;s:5:\"sizes\";a:0:{}}s:22:\"typography_line_height\";a:3:{s:4:\"unit\";s:2:\"em\";s:4:\"size\";i:1;s:5:\"sizes\";a:0:{}}s:27:\"typography_font_size_tablet\";a:3:{s:4:\"unit\";s:2:\"px\";s:4:\"size\";i:13;s:5:\"sizes\";a:0:{}}s:27:\"typography_font_size_mobile\";a:3:{s:4:\"unit\";s:2:\"px\";s:4:\"size\";i:12;s:5:\"sizes\";a:0:{}}s:25:\"typography_letter_spacing\";a:3:{s:4:\"unit\";s:2:\"px\";s:4:\"size\";i:0;s:5:\"sizes\";a:0:{}}s:25:\"typography_text_transform\";s:9:\"uppercase\";}}s:17:\"custom_typography\";a:11:{i:0;a:11:{s:3:\"_id\";s:7:\"b2ce6af\";s:5:\"title\";s:11:\"Global Font\";s:21:\"typography_typography\";s:6:\"custom\";s:22:\"typography_font_family\";s:5:\"Inter\";s:20:\"typography_font_size\";a:3:{s:4:\"unit\";s:2:\"px\";s:4:\"size\";i:16;s:5:\"sizes\";a:0:{}}s:22:\"typography_line_height\";a:3:{s:4:\"unit\";s:2:\"em\";s:4:\"size\";d:1.4;s:5:\"sizes\";a:0:{}}s:27:\"typography_font_size_tablet\";a:3:{s:4:\"unit\";s:2:\"px\";s:4:\"size\";i:15;s:5:\"sizes\";a:0:{}}s:27:\"typography_font_size_mobile\";a:3:{s:4:\"unit\";s:2:\"px\";s:4:\"size\";i:14;s:5:\"sizes\";a:0:{}}s:22:\"typography_font_weight\";s:3:\"400\";s:25:\"typography_text_transform\";s:4:\"none\";s:21:\"typography_font_style\";s:6:\"normal\";}i:1;a:9:{s:3:\"_id\";s:7:\"69c152f\";s:5:\"title\";s:10:\"Small Font\";s:21:\"typography_typography\";s:6:\"custom\";s:22:\"typography_font_family\";s:5:\"Inter\";s:20:\"typography_font_size\";a:3:{s:4:\"unit\";s:2:\"px\";s:4:\"size\";i:14;s:5:\"sizes\";a:0:{}}s:22:\"typography_line_height\";a:3:{s:4:\"unit\";s:2:\"em\";s:4:\"size\";d:1.4;s:5:\"sizes\";a:0:{}}s:27:\"typography_font_size_tablet\";a:3:{s:4:\"unit\";s:2:\"px\";s:4:\"size\";i:13;s:5:\"sizes\";a:0:{}}s:27:\"typography_font_size_mobile\";a:3:{s:4:\"unit\";s:2:\"px\";s:4:\"size\";i:12;s:5:\"sizes\";a:0:{}}s:22:\"typography_font_weight\";s:3:\"400\";}i:2;a:9:{s:3:\"_id\";s:7:\"520c191\";s:5:\"title\";s:6:\"Header\";s:21:\"typography_typography\";s:6:\"custom\";s:22:\"typography_font_family\";s:5:\"Exo 2\";s:20:\"typography_font_size\";a:3:{s:4:\"unit\";s:2:\"px\";s:4:\"size\";i:18;s:5:\"sizes\";a:0:{}}s:22:\"typography_font_weight\";s:3:\"600\";s:27:\"typography_font_size_mobile\";a:3:{s:4:\"unit\";s:2:\"px\";s:4:\"size\";i:16;s:5:\"sizes\";a:0:{}}s:27:\"typography_font_size_tablet\";a:3:{s:4:\"unit\";s:2:\"px\";s:4:\"size\";i:17;s:5:\"sizes\";a:0:{}}s:22:\"typography_line_height\";a:3:{s:4:\"unit\";s:2:\"em\";s:4:\"size\";d:1.5;s:5:\"sizes\";a:0:{}}}i:3;a:9:{s:3:\"_id\";s:7:\"583e54c\";s:5:\"title\";s:2:\"H1\";s:21:\"typography_typography\";s:6:\"custom\";s:22:\"typography_font_family\";s:5:\"Exo 2\";s:20:\"typography_font_size\";a:3:{s:4:\"unit\";s:2:\"px\";s:4:\"size\";i:48;s:5:\"sizes\";a:0:{}}s:22:\"typography_font_weight\";s:3:\"600\";s:22:\"typography_line_height\";a:3:{s:4:\"unit\";s:2:\"em\";s:4:\"size\";d:1.2;s:5:\"sizes\";a:0:{}}s:27:\"typography_font_size_tablet\";a:3:{s:4:\"unit\";s:2:\"px\";s:4:\"size\";i:37;s:5:\"sizes\";a:0:{}}s:27:\"typography_font_size_mobile\";a:3:{s:4:\"unit\";s:2:\"px\";s:4:\"size\";i:30;s:5:\"sizes\";a:0:{}}}i:4;a:9:{s:3:\"_id\";s:7:\"5d167aa\";s:5:\"title\";s:2:\"H2\";s:21:\"typography_typography\";s:6:\"custom\";s:22:\"typography_font_family\";s:5:\"Exo 2\";s:20:\"typography_font_size\";a:3:{s:4:\"unit\";s:2:\"px\";s:4:\"size\";i:39;s:5:\"sizes\";a:0:{}}s:22:\"typography_font_weight\";s:3:\"600\";s:22:\"typography_line_height\";a:3:{s:4:\"unit\";s:2:\"em\";s:4:\"size\";d:1.2;s:5:\"sizes\";a:0:{}}s:27:\"typography_font_size_tablet\";a:3:{s:4:\"unit\";s:2:\"px\";s:4:\"size\";i:31;s:5:\"sizes\";a:0:{}}s:27:\"typography_font_size_mobile\";a:3:{s:4:\"unit\";s:2:\"px\";s:4:\"size\";i:24;s:5:\"sizes\";a:0:{}}}i:5;a:10:{s:3:\"_id\";s:7:\"d3dae9a\";s:5:\"title\";s:2:\"H3\";s:21:\"typography_typography\";s:6:\"custom\";s:22:\"typography_font_family\";s:5:\"Exo 2\";s:20:\"typography_font_size\";a:3:{s:4:\"unit\";s:2:\"px\";s:4:\"size\";i:31;s:5:\"sizes\";a:0:{}}s:22:\"typography_font_weight\";s:3:\"600\";s:22:\"typography_line_height\";a:3:{s:4:\"unit\";s:2:\"em\";s:4:\"size\";d:1.3;s:5:\"sizes\";a:0:{}}s:27:\"typography_font_size_tablet\";a:3:{s:4:\"unit\";s:2:\"px\";s:4:\"size\";i:25;s:5:\"sizes\";a:0:{}}s:27:\"typography_font_size_mobile\";a:3:{s:4:\"unit\";s:2:\"px\";s:4:\"size\";i:20;s:5:\"sizes\";a:0:{}}s:21:\"typography_font_style\";s:6:\"normal\";}i:6;a:11:{s:3:\"_id\";s:7:\"83682a1\";s:5:\"title\";s:2:\"H4\";s:21:\"typography_typography\";s:6:\"custom\";s:22:\"typography_font_family\";s:5:\"Exo 2\";s:20:\"typography_font_size\";a:3:{s:4:\"unit\";s:2:\"px\";s:4:\"size\";i:25;s:5:\"sizes\";a:0:{}}s:22:\"typography_font_weight\";s:3:\"300\";s:22:\"typography_line_height\";a:3:{s:4:\"unit\";s:2:\"em\";s:4:\"size\";d:1.3;s:5:\"sizes\";a:0:{}}s:27:\"typography_font_size_tablet\";a:3:{s:4:\"unit\";s:2:\"px\";s:4:\"size\";i:21;s:5:\"sizes\";a:0:{}}s:27:\"typography_font_size_mobile\";a:3:{s:4:\"unit\";s:2:\"px\";s:4:\"size\";i:18;s:5:\"sizes\";a:0:{}}s:25:\"typography_text_transform\";s:4:\"none\";s:21:\"typography_font_style\";s:6:\"normal\";}i:7;a:9:{s:3:\"_id\";s:7:\"7044a64\";s:5:\"title\";s:2:\"H5\";s:21:\"typography_typography\";s:6:\"custom\";s:22:\"typography_font_family\";s:5:\"Exo 2\";s:20:\"typography_font_size\";a:3:{s:4:\"unit\";s:2:\"px\";s:4:\"size\";i:20;s:5:\"sizes\";a:0:{}}s:22:\"typography_font_weight\";s:3:\"600\";s:22:\"typography_line_height\";a:3:{s:4:\"unit\";s:2:\"em\";s:4:\"size\";d:1.4;s:5:\"sizes\";a:0:{}}s:27:\"typography_font_size_tablet\";a:3:{s:4:\"unit\";s:2:\"px\";s:4:\"size\";i:18;s:5:\"sizes\";a:0:{}}s:27:\"typography_font_size_mobile\";a:3:{s:4:\"unit\";s:2:\"px\";s:4:\"size\";i:16;s:5:\"sizes\";a:0:{}}}i:8;a:10:{s:3:\"_id\";s:7:\"84ca66e\";s:5:\"title\";s:2:\"H6\";s:21:\"typography_typography\";s:6:\"custom\";s:22:\"typography_font_family\";s:5:\"Exo 2\";s:20:\"typography_font_size\";a:3:{s:4:\"unit\";s:2:\"px\";s:4:\"size\";i:16;s:5:\"sizes\";a:0:{}}s:22:\"typography_font_weight\";s:3:\"400\";s:22:\"typography_line_height\";a:3:{s:4:\"unit\";s:2:\"em\";s:4:\"size\";s:0:\"\";s:5:\"sizes\";a:0:{}}s:27:\"typography_font_size_tablet\";a:3:{s:4:\"unit\";s:2:\"px\";s:4:\"size\";i:15;s:5:\"sizes\";a:0:{}}s:27:\"typography_font_size_mobile\";a:3:{s:4:\"unit\";s:2:\"px\";s:4:\"size\";i:14;s:5:\"sizes\";a:0:{}}s:25:\"typography_text_transform\";s:9:\"uppercase\";}i:9;a:9:{s:3:\"_id\";s:7:\"112b6c4\";s:5:\"title\";s:6:\"Footer\";s:21:\"typography_typography\";s:6:\"custom\";s:22:\"typography_font_family\";s:5:\"Inter\";s:20:\"typography_font_size\";a:3:{s:4:\"unit\";s:2:\"px\";s:4:\"size\";i:13;s:5:\"sizes\";a:0:{}}s:22:\"typography_font_weight\";s:3:\"500\";s:27:\"typography_font_size_tablet\";a:3:{s:4:\"unit\";s:2:\"px\";s:4:\"size\";i:12;s:5:\"sizes\";a:0:{}}s:27:\"typography_font_size_mobile\";a:3:{s:4:\"unit\";s:2:\"px\";s:4:\"size\";i:11;s:5:\"sizes\";a:0:{}}s:22:\"typography_line_height\";a:3:{s:4:\"unit\";s:2:\"em\";s:4:\"size\";d:1.5;s:5:\"sizes\";a:0:{}}}i:10;a:9:{s:3:\"_id\";s:7:\"a435f28\";s:5:\"title\";s:8:\"Big Hero\";s:21:\"typography_typography\";s:6:\"custom\";s:22:\"typography_font_family\";s:5:\"Exo 2\";s:20:\"typography_font_size\";a:3:{s:4:\"unit\";s:2:\"px\";s:4:\"size\";i:61;s:5:\"sizes\";a:0:{}}s:27:\"typography_font_size_tablet\";a:3:{s:4:\"unit\";s:2:\"px\";s:4:\"size\";i:44;s:5:\"sizes\";a:0:{}}s:27:\"typography_font_size_mobile\";a:3:{s:4:\"unit\";s:2:\"px\";s:4:\"size\";i:32;s:5:\"sizes\";a:0:{}}s:22:\"typography_font_weight\";s:3:\"700\";s:22:\"typography_line_height\";a:3:{s:4:\"unit\";s:2:\"em\";s:4:\"size\";i:1;s:5:\"sizes\";a:0:{}}}}s:21:\"default_generic_fonts\";s:10:\"Sans-serif\";s:20:\"button_border_border\";s:5:\"solid\";s:19:\"button_border_width\";a:6:{s:4:\"unit\";s:2:\"px\";s:3:\"top\";s:1:\"1\";s:5:\"right\";s:1:\"1\";s:6:\"bottom\";s:1:\"1\";s:4:\"left\";s:1:\"1\";s:8:\"isLinked\";b:1;}s:20:\"button_border_radius\";a:6:{s:4:\"unit\";s:2:\"px\";s:3:\"top\";s:2:\"14\";s:5:\"right\";s:2:\"14\";s:6:\"bottom\";s:2:\"14\";s:4:\"left\";s:2:\"14\";s:8:\"isLinked\";b:1;}s:26:\"button_hover_border_border\";s:5:\"solid\";s:25:\"button_hover_border_width\";a:6:{s:4:\"unit\";s:2:\"px\";s:3:\"top\";s:1:\"1\";s:5:\"right\";s:1:\"1\";s:6:\"bottom\";s:1:\"1\";s:4:\"left\";s:1:\"1\";s:8:\"isLinked\";b:1;}s:24:\"form_field_border_border\";s:5:\"solid\";s:23:\"form_field_border_width\";a:6:{s:4:\"unit\";s:2:\"px\";s:3:\"top\";s:1:\"1\";s:5:\"right\";s:1:\"1\";s:6:\"bottom\";s:1:\"1\";s:4:\"left\";s:1:\"1\";s:8:\"isLinked\";b:1;}s:24:\"form_field_border_radius\";a:6:{s:4:\"unit\";s:2:\"px\";s:3:\"top\";s:2:\"14\";s:5:\"right\";s:2:\"14\";s:6:\"bottom\";s:2:\"14\";s:4:\"left\";s:2:\"14\";s:8:\"isLinked\";b:1;}s:30:\"form_field_focus_border_border\";s:5:\"solid\";s:29:\"form_field_focus_border_width\";a:6:{s:4:\"unit\";s:2:\"px\";s:3:\"top\";s:1:\"1\";s:5:\"right\";s:1:\"1\";s:6:\"bottom\";s:1:\"1\";s:4:\"left\";s:1:\"1\";s:8:\"isLinked\";b:1;}s:19:\"page_title_selector\";s:14:\"h1.entry-title\";s:27:\"hello_footer_copyright_text\";s:19:\"All rights reserved\";s:15:\"activeItemIndex\";i:1;s:11:\"__globals__\";a:35:{s:27:\"form_field_background_color\";s:25:\"globals/colors?id=044b931\";s:23:\"form_field_border_color\";s:0:\"\";s:33:\"form_field_focus_background_color\";s:25:\"globals/colors?id=cfa1f76\";s:29:\"form_field_focus_border_color\";s:0:\"\";s:21:\"form_field_text_color\";s:27:\"globals/colors?id=secondary\";s:27:\"form_field_focus_text_color\";s:25:\"globals/colors?id=primary\";s:17:\"button_text_color\";s:22:\"globals/colors?id=text\";s:23:\"button_background_color\";s:25:\"globals/colors?id=d49ac81\";s:23:\"button_hover_text_color\";s:22:\"globals/colors?id=text\";s:29:\"button_hover_background_color\";s:25:\"globals/colors?id=332724a\";s:26:\"body_typography_typography\";s:29:\"globals/typography?id=b2ce6af\";s:10:\"body_color\";s:25:\"globals/colors?id=primary\";s:17:\"link_normal_color\";s:25:\"globals/colors?id=primary\";s:16:\"link_hover_color\";s:25:\"globals/colors?id=332724a\";s:24:\"h1_typography_typography\";s:29:\"globals/typography?id=583e54c\";s:24:\"h2_typography_typography\";s:29:\"globals/typography?id=5d167aa\";s:24:\"h3_typography_typography\";s:29:\"globals/typography?id=d3dae9a\";s:24:\"h4_typography_typography\";s:29:\"globals/typography?id=83682a1\";s:24:\"h5_typography_typography\";s:29:\"globals/typography?id=7044a64\";s:24:\"h6_typography_typography\";s:29:\"globals/typography?id=84ca66e\";s:8:\"h6_color\";s:25:\"globals/colors?id=c5a94f6\";s:19:\"button_border_color\";s:25:\"globals/colors?id=d49ac81\";s:25:\"button_hover_border_color\";s:25:\"globals/colors?id=332724a\";s:8:\"h1_color\";s:27:\"globals/colors?id=secondary\";s:8:\"h2_color\";s:27:\"globals/colors?id=secondary\";s:8:\"h3_color\";s:27:\"globals/colors?id=secondary\";s:8:\"h4_color\";s:27:\"globals/colors?id=secondary\";s:8:\"h5_color\";s:27:\"globals/colors?id=secondary\";s:16:\"form_label_color\";s:27:\"globals/colors?id=secondary\";s:25:\"button_background_color_b\";s:25:\"globals/colors?id=332724a\";s:31:\"button_hover_background_color_b\";s:25:\"globals/colors?id=d49ac81\";s:32:\"form_label_typography_typography\";s:29:\"globals/typography?id=520c191\";s:32:\"form_field_typography_typography\";s:29:\"globals/typography?id=b2ce6af\";s:28:\"button_typography_typography\";s:28:\"globals/typography?id=accent\";s:21:\"body_background_color\";s:25:\"globals/colors?id=638d055\";}s:11:\"viewport_md\";i:768;s:11:\"viewport_lg\";i:1025;s:15:\"container_width\";a:3:{s:4:\"unit\";s:2:\"px\";s:4:\"size\";i:1280;s:5:\"sizes\";a:0:{}}s:24:\"h1_typography_typography\";s:6:\"custom\";s:25:\"h1_typography_font_family\";s:5:\"Exo 2\";s:23:\"h1_typography_font_size\";a:3:{s:4:\"unit\";s:2:\"px\";s:4:\"size\";i:48;s:5:\"sizes\";a:0:{}}s:25:\"h1_typography_font_weight\";s:3:\"600\";s:25:\"h1_typography_line_height\";a:3:{s:4:\"unit\";s:2:\"em\";s:4:\"size\";d:1.2;s:5:\"sizes\";a:0:{}}s:24:\"h2_typography_typography\";s:6:\"custom\";s:25:\"h2_typography_font_family\";s:5:\"Exo 2\";s:23:\"h2_typography_font_size\";a:3:{s:4:\"unit\";s:2:\"px\";s:4:\"size\";i:39;s:5:\"sizes\";a:0:{}}s:25:\"h2_typography_font_weight\";s:3:\"600\";s:25:\"h2_typography_line_height\";a:3:{s:4:\"unit\";s:2:\"em\";s:4:\"size\";d:1.2;s:5:\"sizes\";a:0:{}}s:24:\"h3_typography_typography\";s:6:\"custom\";s:25:\"h3_typography_font_family\";s:5:\"Exo 2\";s:23:\"h3_typography_font_size\";a:3:{s:4:\"unit\";s:2:\"px\";s:4:\"size\";i:31;s:5:\"sizes\";a:0:{}}s:25:\"h3_typography_font_weight\";s:3:\"600\";s:25:\"h3_typography_line_height\";a:3:{s:4:\"unit\";s:2:\"em\";s:4:\"size\";d:1.3;s:5:\"sizes\";a:0:{}}s:24:\"h4_typography_typography\";s:6:\"custom\";s:25:\"h4_typography_font_family\";s:5:\"Exo 2\";s:23:\"h4_typography_font_size\";a:3:{s:4:\"unit\";s:2:\"px\";s:4:\"size\";i:25;s:5:\"sizes\";a:0:{}}s:25:\"h4_typography_font_weight\";s:3:\"300\";s:25:\"h4_typography_line_height\";a:3:{s:4:\"unit\";s:2:\"em\";s:4:\"size\";d:1.3;s:5:\"sizes\";a:0:{}}s:24:\"h5_typography_typography\";s:6:\"custom\";s:25:\"h5_typography_font_family\";s:5:\"Exo 2\";s:23:\"h5_typography_font_size\";a:3:{s:4:\"unit\";s:2:\"px\";s:4:\"size\";i:20;s:5:\"sizes\";a:0:{}}s:25:\"h5_typography_font_weight\";s:3:\"600\";s:25:\"h5_typography_line_height\";a:3:{s:4:\"unit\";s:2:\"em\";s:4:\"size\";d:1.4;s:5:\"sizes\";a:0:{}}s:24:\"h6_typography_typography\";s:6:\"custom\";s:25:\"h6_typography_font_family\";s:5:\"Exo 2\";s:23:\"h6_typography_font_size\";a:3:{s:4:\"unit\";s:2:\"px\";s:4:\"size\";i:16;s:5:\"sizes\";a:0:{}}s:25:\"h6_typography_font_weight\";s:3:\"400\";s:25:\"h6_typography_line_height\";a:3:{s:4:\"unit\";s:2:\"em\";s:4:\"size\";s:0:\"\";s:5:\"sizes\";a:0:{}}s:21:\"form_field_text_color\";s:7:\"#F8F8F8\";s:27:\"form_field_focus_text_color\";s:7:\"#AEB0B2\";s:30:\"h1_typography_font_size_tablet\";a:3:{s:4:\"unit\";s:2:\"px\";s:4:\"size\";i:37;s:5:\"sizes\";a:0:{}}s:30:\"h1_typography_font_size_mobile\";a:3:{s:4:\"unit\";s:2:\"px\";s:4:\"size\";i:30;s:5:\"sizes\";a:0:{}}s:30:\"h2_typography_font_size_tablet\";a:3:{s:4:\"unit\";s:2:\"px\";s:4:\"size\";i:31;s:5:\"sizes\";a:0:{}}s:30:\"h2_typography_font_size_mobile\";a:3:{s:4:\"unit\";s:2:\"px\";s:4:\"size\";i:24;s:5:\"sizes\";a:0:{}}s:30:\"h3_typography_font_size_tablet\";a:3:{s:4:\"unit\";s:2:\"px\";s:4:\"size\";i:25;s:5:\"sizes\";a:0:{}}s:30:\"h3_typography_font_size_mobile\";a:3:{s:4:\"unit\";s:2:\"px\";s:4:\"size\";i:20;s:5:\"sizes\";a:0:{}}s:30:\"h4_typography_font_size_tablet\";a:3:{s:4:\"unit\";s:2:\"px\";s:4:\"size\";i:21;s:5:\"sizes\";a:0:{}}s:30:\"h4_typography_font_size_mobile\";a:3:{s:4:\"unit\";s:2:\"px\";s:4:\"size\";i:18;s:5:\"sizes\";a:0:{}}s:30:\"h5_typography_font_size_tablet\";a:3:{s:4:\"unit\";s:2:\"px\";s:4:\"size\";i:18;s:5:\"sizes\";a:0:{}}s:30:\"h5_typography_font_size_mobile\";a:3:{s:4:\"unit\";s:2:\"px\";s:4:\"size\";i:16;s:5:\"sizes\";a:0:{}}s:30:\"h6_typography_font_size_tablet\";a:3:{s:4:\"unit\";s:2:\"px\";s:4:\"size\";i:15;s:5:\"sizes\";a:0:{}}s:30:\"h6_typography_font_size_mobile\";a:3:{s:4:\"unit\";s:2:\"px\";s:4:\"size\";i:14;s:5:\"sizes\";a:0:{}}s:32:\"form_field_box_shadow_box_shadow\";a:5:{s:10:\"horizontal\";i:0;s:8:\"vertical\";i:0;s:4:\"blur\";i:1;s:6:\"spread\";i:1;s:5:\"color\";s:18:\"rgba(0, 0, 0, 0.1)\";}s:29:\"woocommerce_myaccount_page_id\";i:9;s:24:\"woocommerce_cart_page_id\";i:7;s:28:\"woocommerce_checkout_page_id\";i:8;s:26:\"body_background_background\";s:7:\"classic\";s:10:\"body_color\";s:7:\"#AEB0B2\";s:17:\"link_normal_color\";s:7:\"#AEB0B2\";s:8:\"h1_color\";s:7:\"#F8F8F8\";s:8:\"h2_color\";s:7:\"#F8F8F8\";s:8:\"h3_color\";s:7:\"#F8F8F8\";s:24:\"h3_typography_font_style\";s:6:\"normal\";s:8:\"h4_color\";s:7:\"#F8F8F8\";s:28:\"h4_typography_text_transform\";s:4:\"none\";s:24:\"h4_typography_font_style\";s:6:\"normal\";s:8:\"h5_color\";s:7:\"#F8F8F8\";s:28:\"h6_typography_text_transform\";s:9:\"uppercase\";s:17:\"button_text_color\";s:7:\"#FFFFFF\";s:23:\"button_hover_text_color\";s:7:\"#FFFFFF\";s:16:\"form_label_color\";s:7:\"#F8F8F8\";s:21:\"body_background_image\";a:5:{s:3:\"url\";s:0:\"\";s:2:\"id\";s:0:\"\";s:4:\"size\";s:0:\"\";s:3:\"alt\";s:0:\"\";s:6:\"source\";s:7:\"library\";}s:24:\"body_background_position\";s:13:\"center center\";s:22:\"body_background_repeat\";s:8:\"repeat-y\";s:27:\"body_background_size_tablet\";s:7:\"initial\";s:31:\"body_background_bg_width_tablet\";a:3:{s:4:\"unit\";s:1:\"%\";s:4:\"size\";i:0;s:5:\"sizes\";a:0:{}}s:31:\"body_background_bg_width_mobile\";a:3:{s:4:\"unit\";s:1:\"%\";s:4:\"size\";i:0;s:5:\"sizes\";a:0:{}}s:27:\"body_background_size_mobile\";s:7:\"initial\";s:37:\"link_hover_typography_text_decoration\";s:9:\"underline\";s:18:\"form_field_padding\";a:6:{s:4:\"unit\";s:2:\"em\";s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";s:8:\"isLinked\";b:1;}s:28:\"button_box_shadow_box_shadow\";a:5:{s:10:\"horizontal\";i:-30;s:8:\"vertical\";i:0;s:4:\"blur\";i:25;s:6:\"spread\";i:-10;s:5:\"color\";s:7:\"#6B9FF5\";}s:28:\"h2_typography_letter_spacing\";a:3:{s:4:\"unit\";s:2:\"px\";s:4:\"size\";d:-0.5;s:5:\"sizes\";a:0:{}}s:19:\"button_border_color\";s:7:\"#004483\";s:31:\"button_hover_background_color_b\";s:7:\"#004483\";s:25:\"button_hover_border_color\";s:7:\"#E69900\";s:27:\"form_field_background_color\";s:7:\"#001429\";s:23:\"form_field_border_color\";s:9:\"#414F6280\";s:26:\"body_typography_typography\";s:6:\"custom\";s:27:\"body_typography_font_family\";s:5:\"Inter\";s:25:\"body_typography_font_size\";a:3:{s:4:\"unit\";s:2:\"px\";s:4:\"size\";i:16;s:5:\"sizes\";a:0:{}}s:27:\"body_typography_font_weight\";s:3:\"400\";s:30:\"body_typography_text_transform\";s:4:\"none\";s:26:\"body_typography_font_style\";s:6:\"normal\";s:27:\"body_typography_line_height\";a:3:{s:4:\"unit\";s:2:\"em\";s:4:\"size\";d:1.4;s:5:\"sizes\";a:0:{}}s:32:\"body_typography_font_size_tablet\";a:3:{s:4:\"unit\";s:2:\"px\";s:4:\"size\";i:15;s:5:\"sizes\";a:0:{}}s:32:\"body_typography_font_size_mobile\";a:3:{s:4:\"unit\";s:2:\"px\";s:4:\"size\";i:14;s:5:\"sizes\";a:0:{}}s:41:\"form_field_box_shadow_box_shadow_position\";s:5:\"inset\";s:38:\"form_field_focus_box_shadow_box_shadow\";a:5:{s:10:\"horizontal\";i:0;s:8:\"vertical\";i:-1;s:4:\"blur\";i:0;s:6:\"spread\";i:0;s:5:\"color\";s:7:\"#8DC741\";}s:47:\"form_field_focus_box_shadow_box_shadow_position\";s:5:\"inset\";s:28:\"button_typography_typography\";s:6:\"custom\";s:29:\"button_typography_font_family\";s:5:\"Exo 2\";s:27:\"button_typography_font_size\";a:3:{s:4:\"unit\";s:2:\"px\";s:4:\"size\";i:14;s:5:\"sizes\";a:0:{}}s:29:\"button_typography_font_weight\";s:3:\"600\";s:32:\"button_typography_text_transform\";s:9:\"uppercase\";s:29:\"button_typography_line_height\";a:3:{s:4:\"unit\";s:2:\"em\";s:4:\"size\";i:1;s:5:\"sizes\";a:0:{}}s:32:\"button_typography_letter_spacing\";a:3:{s:4:\"unit\";s:2:\"px\";s:4:\"size\";i:0;s:5:\"sizes\";a:0:{}}s:25:\"button_background_color_b\";s:7:\"#E69900\";s:29:\"form_field_focus_border_color\";s:9:\"#FFAD0A80\";s:34:\"button_typography_font_size_tablet\";a:3:{s:4:\"unit\";s:2:\"px\";s:4:\"size\";i:13;s:5:\"sizes\";a:0:{}}s:34:\"button_typography_font_size_mobile\";a:3:{s:4:\"unit\";s:2:\"px\";s:4:\"size\";i:12;s:5:\"sizes\";a:0:{}}s:32:\"button_background_gradient_angle\";a:3:{s:4:\"unit\";s:3:\"deg\";s:4:\"size\";i:120;s:5:\"sizes\";a:0:{}}s:38:\"button_hover_background_gradient_angle\";a:3:{s:4:\"unit\";s:3:\"deg\";s:4:\"size\";i:120;s:5:\"sizes\";a:0:{}}s:21:\"space_between_widgets\";a:6:{s:6:\"column\";s:2:\"20\";s:3:\"row\";s:2:\"20\";s:8:\"isLinked\";b:1;s:4:\"unit\";s:2:\"px\";s:4:\"size\";i:14;s:5:\"sizes\";a:0:{}}s:16:\"link_hover_color\";s:7:\"#E69900\";s:28:\"h1_typography_letter_spacing\";a:3:{s:4:\"unit\";s:2:\"px\";s:4:\"size\";i:-1;s:5:\"sizes\";a:0:{}}s:32:\"form_label_typography_typography\";s:6:\"custom\";s:33:\"form_label_typography_font_family\";s:5:\"Exo 2\";s:31:\"form_label_typography_font_size\";a:3:{s:4:\"unit\";s:2:\"px\";s:4:\"size\";i:18;s:5:\"sizes\";a:0:{}}s:33:\"form_label_typography_font_weight\";s:3:\"600\";s:36:\"form_label_typography_text_transform\";s:9:\"uppercase\";s:33:\"form_label_typography_line_height\";a:3:{s:4:\"unit\";s:2:\"em\";s:4:\"size\";d:1.5;s:5:\"sizes\";a:0:{}}s:32:\"form_field_typography_typography\";s:6:\"custom\";s:33:\"form_field_typography_font_family\";s:5:\"Inter\";s:31:\"form_field_typography_font_size\";a:3:{s:4:\"unit\";s:2:\"px\";s:4:\"size\";i:16;s:5:\"sizes\";a:0:{}}s:33:\"form_field_typography_font_weight\";s:3:\"400\";s:36:\"form_field_typography_text_transform\";s:4:\"none\";s:32:\"form_field_typography_font_style\";s:6:\"normal\";s:33:\"form_field_typography_line_height\";a:3:{s:4:\"unit\";s:2:\"em\";s:4:\"size\";d:1.4;s:5:\"sizes\";a:0:{}}s:38:\"form_label_typography_font_size_tablet\";a:3:{s:4:\"unit\";s:2:\"px\";s:4:\"size\";i:17;s:5:\"sizes\";a:0:{}}s:38:\"form_label_typography_font_size_mobile\";a:3:{s:4:\"unit\";s:2:\"px\";s:4:\"size\";i:16;s:5:\"sizes\";a:0:{}}s:38:\"form_field_typography_font_size_tablet\";a:3:{s:4:\"unit\";s:2:\"px\";s:4:\"size\";i:15;s:5:\"sizes\";a:0:{}}s:38:\"form_field_typography_font_size_mobile\";a:3:{s:4:\"unit\";s:2:\"px\";s:4:\"size\";i:14;s:5:\"sizes\";a:0:{}}s:30:\"button_background_color_b_stop\";a:3:{s:4:\"unit\";s:1:\"%\";s:4:\"size\";i:50;s:5:\"sizes\";a:0:{}}s:37:\"button_box_shadow_box_shadow_position\";s:5:\"inset\";s:34:\"button_hover_box_shadow_box_shadow\";a:5:{s:10:\"horizontal\";i:0;s:8:\"vertical\";i:5;s:4:\"blur\";i:30;s:6:\"spread\";i:0;s:5:\"color\";s:52:\"rgba(238.9999999999999, 255, 81.99999999999999, 0.2)\";}s:28:\"button_background_color_stop\";a:3:{s:4:\"unit\";s:1:\"%\";s:4:\"size\";i:10;s:5:\"sizes\";a:0:{}}s:8:\"h6_color\";s:7:\"#FFAD0A\";s:21:\"body_background_color\";s:7:\"#000814\";s:23:\"button_background_color\";s:7:\"#004483\";s:39:\"button_hover_box_shadow_box_shadow_type\";s:3:\"yes\";s:32:\"colors_enable_styleguide_preview\";s:3:\"yes\";s:29:\"button_hover_background_color\";s:7:\"#E69900\";s:33:\"form_field_focus_background_color\";s:7:\"#001F3D\";}');
INSERT INTO `wp_79e54b1ec2_postmeta` VALUES ('735','137','_elementor_data','[]');
INSERT INTO `wp_79e54b1ec2_postmeta` VALUES ('736','139','_elementor_edit_mode','builder');
INSERT INTO `wp_79e54b1ec2_postmeta` VALUES ('737','139','_elementor_template_type','section');
INSERT INTO `wp_79e54b1ec2_postmeta` VALUES ('738','139','_elementor_version','3.32.5');
INSERT INTO `wp_79e54b1ec2_postmeta` VALUES ('739','139','_elementor_pro_version','3.11.2');
INSERT INTO `wp_79e54b1ec2_postmeta` VALUES ('740','139','_wp_page_template','default');
INSERT INTO `wp_79e54b1ec2_postmeta` VALUES ('741','139','_elementor_page_settings','a:157:{s:13:\"system_colors\";a:4:{i:0;a:3:{s:3:\"_id\";s:9:\"secondary\";s:5:\"title\";s:7:\"Heading\";s:5:\"color\";s:7:\"#F8F8F8\";}i:1;a:3:{s:3:\"_id\";s:7:\"primary\";s:5:\"title\";s:10:\"Basic Text\";s:5:\"color\";s:7:\"#AEB0B2\";}i:2;a:3:{s:3:\"_id\";s:4:\"text\";s:5:\"title\";s:6:\"Netral\";s:5:\"color\";s:7:\"#FFFFFF\";}i:3;a:3:{s:3:\"_id\";s:6:\"accent\";s:5:\"title\";s:15:\"Transparent 20%\";s:5:\"color\";s:9:\"#FFFFFF2B\";}}s:13:\"custom_colors\";a:12:{i:0;a:3:{s:3:\"_id\";s:7:\"d49ac81\";s:5:\"title\";s:6:\"Button\";s:5:\"color\";s:7:\"#004483\";}i:1;a:3:{s:3:\"_id\";s:7:\"332724a\";s:5:\"title\";s:12:\"Button Hover\";s:5:\"color\";s:7:\"#E69900\";}i:2;a:3:{s:3:\"_id\";s:7:\"4d462f5\";s:5:\"title\";s:10:\"Line Color\";s:5:\"color\";s:7:\"#414F62\";}i:3;a:3:{s:3:\"_id\";s:7:\"cfa1f76\";s:5:\"title\";s:16:\"Light Background\";s:5:\"color\";s:7:\"#001F3D\";}i:4;a:3:{s:3:\"_id\";s:7:\"7fbea4f\";s:5:\"title\";s:22:\"Extra Light Background\";s:5:\"color\";s:7:\"#002A52\";}i:5;a:3:{s:3:\"_id\";s:7:\"044b931\";s:5:\"title\";s:15:\"Dark Background\";s:5:\"color\";s:7:\"#001429\";}i:6;a:3:{s:3:\"_id\";s:7:\"638d055\";s:5:\"title\";s:21:\"Extra Dark Background\";s:5:\"color\";s:7:\"#000814\";}i:7;a:3:{s:3:\"_id\";s:7:\"ec3c7a7\";s:5:\"title\";s:8:\"Accent 1\";s:5:\"color\";s:7:\"#004483\";}i:8;a:3:{s:3:\"_id\";s:7:\"3ee16e7\";s:5:\"title\";s:8:\"Accent 2\";s:5:\"color\";s:7:\"#E69900\";}i:9;a:3:{s:3:\"_id\";s:7:\"c5a94f6\";s:5:\"title\";s:8:\"Accent 3\";s:5:\"color\";s:7:\"#FFAD0A\";}i:10;a:3:{s:3:\"_id\";s:7:\"e5616b2\";s:5:\"title\";s:8:\"Accent 4\";s:5:\"color\";s:7:\"#AD7505\";}i:11;a:3:{s:3:\"_id\";s:7:\"5c3d4b5\";s:5:\"title\";s:8:\"Accent 5\";s:5:\"color\";s:7:\"#231A05\";}}s:17:\"system_typography\";a:4:{i:0;a:9:{s:3:\"_id\";s:7:\"primary\";s:5:\"title\";s:7:\"Primary\";s:21:\"typography_typography\";s:6:\"custom\";s:22:\"typography_font_family\";s:5:\"Exo 2\";s:22:\"typography_font_weight\";s:3:\"600\";s:20:\"typography_font_size\";a:3:{s:4:\"unit\";s:2:\"px\";s:4:\"size\";i:48;s:5:\"sizes\";a:0:{}}s:22:\"typography_line_height\";a:3:{s:4:\"unit\";s:2:\"em\";s:4:\"size\";d:1.2;s:5:\"sizes\";a:0:{}}s:27:\"typography_font_size_tablet\";a:3:{s:4:\"unit\";s:2:\"px\";s:4:\"size\";i:37;s:5:\"sizes\";a:0:{}}s:27:\"typography_font_size_mobile\";a:3:{s:4:\"unit\";s:2:\"px\";s:4:\"size\";i:30;s:5:\"sizes\";a:0:{}}}i:1;a:10:{s:3:\"_id\";s:9:\"secondary\";s:5:\"title\";s:9:\"Secondary\";s:21:\"typography_typography\";s:6:\"custom\";s:22:\"typography_font_family\";s:5:\"Exo 2\";s:22:\"typography_font_weight\";s:3:\"600\";s:20:\"typography_font_size\";a:3:{s:4:\"unit\";s:2:\"px\";s:4:\"size\";i:39;s:5:\"sizes\";a:0:{}}s:22:\"typography_line_height\";a:3:{s:4:\"unit\";s:2:\"em\";s:4:\"size\";d:1.2;s:5:\"sizes\";a:0:{}}s:27:\"typography_font_size_tablet\";a:3:{s:4:\"unit\";s:2:\"px\";s:4:\"size\";i:31;s:5:\"sizes\";a:0:{}}s:27:\"typography_font_size_mobile\";a:3:{s:4:\"unit\";s:2:\"px\";s:4:\"size\";i:24;s:5:\"sizes\";a:0:{}}s:25:\"typography_letter_spacing\";a:3:{s:4:\"unit\";s:2:\"px\";s:4:\"size\";d:-0.5;s:5:\"sizes\";a:0:{}}}i:2;a:9:{s:3:\"_id\";s:4:\"text\";s:5:\"title\";s:4:\"Text\";s:21:\"typography_typography\";s:6:\"custom\";s:22:\"typography_font_family\";s:5:\"Inter\";s:22:\"typography_font_weight\";s:3:\"400\";s:20:\"typography_font_size\";a:3:{s:4:\"unit\";s:2:\"px\";s:4:\"size\";i:16;s:5:\"sizes\";a:0:{}}s:22:\"typography_line_height\";a:3:{s:4:\"unit\";s:2:\"em\";s:4:\"size\";d:1.4;s:5:\"sizes\";a:0:{}}s:27:\"typography_font_size_tablet\";a:3:{s:4:\"unit\";s:2:\"px\";s:4:\"size\";i:15;s:5:\"sizes\";a:0:{}}s:27:\"typography_font_size_mobile\";a:3:{s:4:\"unit\";s:2:\"px\";s:4:\"size\";i:14;s:5:\"sizes\";a:0:{}}}i:3;a:11:{s:3:\"_id\";s:6:\"accent\";s:5:\"title\";s:6:\"Accent\";s:21:\"typography_typography\";s:6:\"custom\";s:22:\"typography_font_family\";s:5:\"Exo 2\";s:22:\"typography_font_weight\";s:3:\"600\";s:20:\"typography_font_size\";a:3:{s:4:\"unit\";s:2:\"px\";s:4:\"size\";i:14;s:5:\"sizes\";a:0:{}}s:22:\"typography_line_height\";a:3:{s:4:\"unit\";s:2:\"em\";s:4:\"size\";i:1;s:5:\"sizes\";a:0:{}}s:27:\"typography_font_size_tablet\";a:3:{s:4:\"unit\";s:2:\"px\";s:4:\"size\";i:13;s:5:\"sizes\";a:0:{}}s:27:\"typography_font_size_mobile\";a:3:{s:4:\"unit\";s:2:\"px\";s:4:\"size\";i:12;s:5:\"sizes\";a:0:{}}s:25:\"typography_letter_spacing\";a:3:{s:4:\"unit\";s:2:\"px\";s:4:\"size\";i:0;s:5:\"sizes\";a:0:{}}s:25:\"typography_text_transform\";s:9:\"uppercase\";}}s:17:\"custom_typography\";a:11:{i:0;a:11:{s:3:\"_id\";s:7:\"b2ce6af\";s:5:\"title\";s:11:\"Global Font\";s:21:\"typography_typography\";s:6:\"custom\";s:22:\"typography_font_family\";s:5:\"Inter\";s:20:\"typography_font_size\";a:3:{s:4:\"unit\";s:2:\"px\";s:4:\"size\";i:16;s:5:\"sizes\";a:0:{}}s:22:\"typography_line_height\";a:3:{s:4:\"unit\";s:2:\"em\";s:4:\"size\";d:1.4;s:5:\"sizes\";a:0:{}}s:27:\"typography_font_size_tablet\";a:3:{s:4:\"unit\";s:2:\"px\";s:4:\"size\";i:15;s:5:\"sizes\";a:0:{}}s:27:\"typography_font_size_mobile\";a:3:{s:4:\"unit\";s:2:\"px\";s:4:\"size\";i:14;s:5:\"sizes\";a:0:{}}s:22:\"typography_font_weight\";s:3:\"400\";s:25:\"typography_text_transform\";s:4:\"none\";s:21:\"typography_font_style\";s:6:\"normal\";}i:1;a:9:{s:3:\"_id\";s:7:\"69c152f\";s:5:\"title\";s:10:\"Small Font\";s:21:\"typography_typography\";s:6:\"custom\";s:22:\"typography_font_family\";s:5:\"Inter\";s:20:\"typography_font_size\";a:3:{s:4:\"unit\";s:2:\"px\";s:4:\"size\";i:14;s:5:\"sizes\";a:0:{}}s:22:\"typography_line_height\";a:3:{s:4:\"unit\";s:2:\"em\";s:4:\"size\";d:1.4;s:5:\"sizes\";a:0:{}}s:27:\"typography_font_size_tablet\";a:3:{s:4:\"unit\";s:2:\"px\";s:4:\"size\";i:13;s:5:\"sizes\";a:0:{}}s:27:\"typography_font_size_mobile\";a:3:{s:4:\"unit\";s:2:\"px\";s:4:\"size\";i:12;s:5:\"sizes\";a:0:{}}s:22:\"typography_font_weight\";s:3:\"400\";}i:2;a:9:{s:3:\"_id\";s:7:\"520c191\";s:5:\"title\";s:6:\"Header\";s:21:\"typography_typography\";s:6:\"custom\";s:22:\"typography_font_family\";s:5:\"Exo 2\";s:20:\"typography_font_size\";a:3:{s:4:\"unit\";s:2:\"px\";s:4:\"size\";i:18;s:5:\"sizes\";a:0:{}}s:22:\"typography_font_weight\";s:3:\"600\";s:27:\"typography_font_size_mobile\";a:3:{s:4:\"unit\";s:2:\"px\";s:4:\"size\";i:16;s:5:\"sizes\";a:0:{}}s:27:\"typography_font_size_tablet\";a:3:{s:4:\"unit\";s:2:\"px\";s:4:\"size\";i:17;s:5:\"sizes\";a:0:{}}s:22:\"typography_line_height\";a:3:{s:4:\"unit\";s:2:\"em\";s:4:\"size\";d:1.5;s:5:\"sizes\";a:0:{}}}i:3;a:9:{s:3:\"_id\";s:7:\"583e54c\";s:5:\"title\";s:2:\"H1\";s:21:\"typography_typography\";s:6:\"custom\";s:22:\"typography_font_family\";s:5:\"Exo 2\";s:20:\"typography_font_size\";a:3:{s:4:\"unit\";s:2:\"px\";s:4:\"size\";i:48;s:5:\"sizes\";a:0:{}}s:22:\"typography_font_weight\";s:3:\"600\";s:22:\"typography_line_height\";a:3:{s:4:\"unit\";s:2:\"em\";s:4:\"size\";d:1.2;s:5:\"sizes\";a:0:{}}s:27:\"typography_font_size_tablet\";a:3:{s:4:\"unit\";s:2:\"px\";s:4:\"size\";i:37;s:5:\"sizes\";a:0:{}}s:27:\"typography_font_size_mobile\";a:3:{s:4:\"unit\";s:2:\"px\";s:4:\"size\";i:30;s:5:\"sizes\";a:0:{}}}i:4;a:9:{s:3:\"_id\";s:7:\"5d167aa\";s:5:\"title\";s:2:\"H2\";s:21:\"typography_typography\";s:6:\"custom\";s:22:\"typography_font_family\";s:5:\"Exo 2\";s:20:\"typography_font_size\";a:3:{s:4:\"unit\";s:2:\"px\";s:4:\"size\";i:39;s:5:\"sizes\";a:0:{}}s:22:\"typography_font_weight\";s:3:\"600\";s:22:\"typography_line_height\";a:3:{s:4:\"unit\";s:2:\"em\";s:4:\"size\";d:1.2;s:5:\"sizes\";a:0:{}}s:27:\"typography_font_size_tablet\";a:3:{s:4:\"unit\";s:2:\"px\";s:4:\"size\";i:31;s:5:\"sizes\";a:0:{}}s:27:\"typography_font_size_mobile\";a:3:{s:4:\"unit\";s:2:\"px\";s:4:\"size\";i:24;s:5:\"sizes\";a:0:{}}}i:5;a:10:{s:3:\"_id\";s:7:\"d3dae9a\";s:5:\"title\";s:2:\"H3\";s:21:\"typography_typography\";s:6:\"custom\";s:22:\"typography_font_family\";s:5:\"Exo 2\";s:20:\"typography_font_size\";a:3:{s:4:\"unit\";s:2:\"px\";s:4:\"size\";i:31;s:5:\"sizes\";a:0:{}}s:22:\"typography_font_weight\";s:3:\"600\";s:22:\"typography_line_height\";a:3:{s:4:\"unit\";s:2:\"em\";s:4:\"size\";d:1.3;s:5:\"sizes\";a:0:{}}s:27:\"typography_font_size_tablet\";a:3:{s:4:\"unit\";s:2:\"px\";s:4:\"size\";i:25;s:5:\"sizes\";a:0:{}}s:27:\"typography_font_size_mobile\";a:3:{s:4:\"unit\";s:2:\"px\";s:4:\"size\";i:20;s:5:\"sizes\";a:0:{}}s:21:\"typography_font_style\";s:6:\"normal\";}i:6;a:11:{s:3:\"_id\";s:7:\"83682a1\";s:5:\"title\";s:2:\"H4\";s:21:\"typography_typography\";s:6:\"custom\";s:22:\"typography_font_family\";s:5:\"Exo 2\";s:20:\"typography_font_size\";a:3:{s:4:\"unit\";s:2:\"px\";s:4:\"size\";i:25;s:5:\"sizes\";a:0:{}}s:22:\"typography_font_weight\";s:3:\"300\";s:22:\"typography_line_height\";a:3:{s:4:\"unit\";s:2:\"em\";s:4:\"size\";d:1.3;s:5:\"sizes\";a:0:{}}s:27:\"typography_font_size_tablet\";a:3:{s:4:\"unit\";s:2:\"px\";s:4:\"size\";i:21;s:5:\"sizes\";a:0:{}}s:27:\"typography_font_size_mobile\";a:3:{s:4:\"unit\";s:2:\"px\";s:4:\"size\";i:18;s:5:\"sizes\";a:0:{}}s:25:\"typography_text_transform\";s:4:\"none\";s:21:\"typography_font_style\";s:6:\"normal\";}i:7;a:9:{s:3:\"_id\";s:7:\"7044a64\";s:5:\"title\";s:2:\"H5\";s:21:\"typography_typography\";s:6:\"custom\";s:22:\"typography_font_family\";s:5:\"Exo 2\";s:20:\"typography_font_size\";a:3:{s:4:\"unit\";s:2:\"px\";s:4:\"size\";i:20;s:5:\"sizes\";a:0:{}}s:22:\"typography_font_weight\";s:3:\"600\";s:22:\"typography_line_height\";a:3:{s:4:\"unit\";s:2:\"em\";s:4:\"size\";d:1.4;s:5:\"sizes\";a:0:{}}s:27:\"typography_font_size_tablet\";a:3:{s:4:\"unit\";s:2:\"px\";s:4:\"size\";i:18;s:5:\"sizes\";a:0:{}}s:27:\"typography_font_size_mobile\";a:3:{s:4:\"unit\";s:2:\"px\";s:4:\"size\";i:16;s:5:\"sizes\";a:0:{}}}i:8;a:10:{s:3:\"_id\";s:7:\"84ca66e\";s:5:\"title\";s:2:\"H6\";s:21:\"typography_typography\";s:6:\"custom\";s:22:\"typography_font_family\";s:5:\"Exo 2\";s:20:\"typography_font_size\";a:3:{s:4:\"unit\";s:2:\"px\";s:4:\"size\";i:16;s:5:\"sizes\";a:0:{}}s:22:\"typography_font_weight\";s:3:\"400\";s:22:\"typography_line_height\";a:3:{s:4:\"unit\";s:2:\"em\";s:4:\"size\";s:0:\"\";s:5:\"sizes\";a:0:{}}s:27:\"typography_font_size_tablet\";a:3:{s:4:\"unit\";s:2:\"px\";s:4:\"size\";i:15;s:5:\"sizes\";a:0:{}}s:27:\"typography_font_size_mobile\";a:3:{s:4:\"unit\";s:2:\"px\";s:4:\"size\";i:14;s:5:\"sizes\";a:0:{}}s:25:\"typography_text_transform\";s:9:\"uppercase\";}i:9;a:9:{s:3:\"_id\";s:7:\"112b6c4\";s:5:\"title\";s:6:\"Footer\";s:21:\"typography_typography\";s:6:\"custom\";s:22:\"typography_font_family\";s:5:\"Inter\";s:20:\"typography_font_size\";a:3:{s:4:\"unit\";s:2:\"px\";s:4:\"size\";i:13;s:5:\"sizes\";a:0:{}}s:22:\"typography_font_weight\";s:3:\"500\";s:27:\"typography_font_size_tablet\";a:3:{s:4:\"unit\";s:2:\"px\";s:4:\"size\";i:12;s:5:\"sizes\";a:0:{}}s:27:\"typography_font_size_mobile\";a:3:{s:4:\"unit\";s:2:\"px\";s:4:\"size\";i:11;s:5:\"sizes\";a:0:{}}s:22:\"typography_line_height\";a:3:{s:4:\"unit\";s:2:\"em\";s:4:\"size\";d:1.5;s:5:\"sizes\";a:0:{}}}i:10;a:9:{s:3:\"_id\";s:7:\"a435f28\";s:5:\"title\";s:8:\"Big Hero\";s:21:\"typography_typography\";s:6:\"custom\";s:22:\"typography_font_family\";s:5:\"Exo 2\";s:20:\"typography_font_size\";a:3:{s:4:\"unit\";s:2:\"px\";s:4:\"size\";i:61;s:5:\"sizes\";a:0:{}}s:27:\"typography_font_size_tablet\";a:3:{s:4:\"unit\";s:2:\"px\";s:4:\"size\";i:44;s:5:\"sizes\";a:0:{}}s:27:\"typography_font_size_mobile\";a:3:{s:4:\"unit\";s:2:\"px\";s:4:\"size\";i:32;s:5:\"sizes\";a:0:{}}s:22:\"typography_font_weight\";s:3:\"700\";s:22:\"typography_line_height\";a:3:{s:4:\"unit\";s:2:\"em\";s:4:\"size\";i:1;s:5:\"sizes\";a:0:{}}}}s:21:\"default_generic_fonts\";s:10:\"Sans-serif\";s:20:\"button_border_border\";s:5:\"solid\";s:19:\"button_border_width\";a:6:{s:4:\"unit\";s:2:\"px\";s:3:\"top\";s:1:\"1\";s:5:\"right\";s:1:\"1\";s:6:\"bottom\";s:1:\"1\";s:4:\"left\";s:1:\"1\";s:8:\"isLinked\";b:1;}s:20:\"button_border_radius\";a:6:{s:4:\"unit\";s:2:\"px\";s:3:\"top\";s:2:\"14\";s:5:\"right\";s:2:\"14\";s:6:\"bottom\";s:2:\"14\";s:4:\"left\";s:2:\"14\";s:8:\"isLinked\";b:1;}s:26:\"button_hover_border_border\";s:5:\"solid\";s:25:\"button_hover_border_width\";a:6:{s:4:\"unit\";s:2:\"px\";s:3:\"top\";s:1:\"1\";s:5:\"right\";s:1:\"1\";s:6:\"bottom\";s:1:\"1\";s:4:\"left\";s:1:\"1\";s:8:\"isLinked\";b:1;}s:24:\"form_field_border_border\";s:5:\"solid\";s:23:\"form_field_border_width\";a:6:{s:4:\"unit\";s:2:\"px\";s:3:\"top\";s:1:\"1\";s:5:\"right\";s:1:\"1\";s:6:\"bottom\";s:1:\"1\";s:4:\"left\";s:1:\"1\";s:8:\"isLinked\";b:1;}s:24:\"form_field_border_radius\";a:6:{s:4:\"unit\";s:2:\"px\";s:3:\"top\";s:2:\"14\";s:5:\"right\";s:2:\"14\";s:6:\"bottom\";s:2:\"14\";s:4:\"left\";s:2:\"14\";s:8:\"isLinked\";b:1;}s:30:\"form_field_focus_border_border\";s:5:\"solid\";s:29:\"form_field_focus_border_width\";a:6:{s:4:\"unit\";s:2:\"px\";s:3:\"top\";s:1:\"1\";s:5:\"right\";s:1:\"1\";s:6:\"bottom\";s:1:\"1\";s:4:\"left\";s:1:\"1\";s:8:\"isLinked\";b:1;}s:19:\"page_title_selector\";s:14:\"h1.entry-title\";s:27:\"hello_footer_copyright_text\";s:19:\"All rights reserved\";s:15:\"activeItemIndex\";i:1;s:11:\"__globals__\";a:35:{s:27:\"form_field_background_color\";s:25:\"globals/colors?id=044b931\";s:23:\"form_field_border_color\";s:0:\"\";s:33:\"form_field_focus_background_color\";s:25:\"globals/colors?id=cfa1f76\";s:29:\"form_field_focus_border_color\";s:0:\"\";s:21:\"form_field_text_color\";s:27:\"globals/colors?id=secondary\";s:27:\"form_field_focus_text_color\";s:25:\"globals/colors?id=primary\";s:17:\"button_text_color\";s:22:\"globals/colors?id=text\";s:23:\"button_background_color\";s:25:\"globals/colors?id=d49ac81\";s:23:\"button_hover_text_color\";s:22:\"globals/colors?id=text\";s:29:\"button_hover_background_color\";s:25:\"globals/colors?id=332724a\";s:26:\"body_typography_typography\";s:29:\"globals/typography?id=b2ce6af\";s:10:\"body_color\";s:25:\"globals/colors?id=primary\";s:17:\"link_normal_color\";s:25:\"globals/colors?id=primary\";s:16:\"link_hover_color\";s:25:\"globals/colors?id=332724a\";s:24:\"h1_typography_typography\";s:29:\"globals/typography?id=583e54c\";s:24:\"h2_typography_typography\";s:29:\"globals/typography?id=5d167aa\";s:24:\"h3_typography_typography\";s:29:\"globals/typography?id=d3dae9a\";s:24:\"h4_typography_typography\";s:29:\"globals/typography?id=83682a1\";s:24:\"h5_typography_typography\";s:29:\"globals/typography?id=7044a64\";s:24:\"h6_typography_typography\";s:29:\"globals/typography?id=84ca66e\";s:8:\"h6_color\";s:25:\"globals/colors?id=c5a94f6\";s:19:\"button_border_color\";s:25:\"globals/colors?id=d49ac81\";s:25:\"button_hover_border_color\";s:25:\"globals/colors?id=332724a\";s:8:\"h1_color\";s:27:\"globals/colors?id=secondary\";s:8:\"h2_color\";s:27:\"globals/colors?id=secondary\";s:8:\"h3_color\";s:27:\"globals/colors?id=secondary\";s:8:\"h4_color\";s:27:\"globals/colors?id=secondary\";s:8:\"h5_color\";s:27:\"globals/colors?id=secondary\";s:16:\"form_label_color\";s:27:\"globals/colors?id=secondary\";s:25:\"button_background_color_b\";s:25:\"globals/colors?id=332724a\";s:31:\"button_hover_background_color_b\";s:25:\"globals/colors?id=d49ac81\";s:32:\"form_label_typography_typography\";s:29:\"globals/typography?id=520c191\";s:32:\"form_field_typography_typography\";s:29:\"globals/typography?id=b2ce6af\";s:28:\"button_typography_typography\";s:28:\"globals/typography?id=accent\";s:21:\"body_background_color\";s:25:\"globals/colors?id=638d055\";}s:11:\"viewport_md\";i:768;s:11:\"viewport_lg\";i:1025;s:15:\"container_width\";a:3:{s:4:\"unit\";s:2:\"px\";s:4:\"size\";i:1280;s:5:\"sizes\";a:0:{}}s:24:\"h1_typography_typography\";s:6:\"custom\";s:25:\"h1_typography_font_family\";s:5:\"Exo 2\";s:23:\"h1_typography_font_size\";a:3:{s:4:\"unit\";s:2:\"px\";s:4:\"size\";i:48;s:5:\"sizes\";a:0:{}}s:25:\"h1_typography_font_weight\";s:3:\"600\";s:25:\"h1_typography_line_height\";a:3:{s:4:\"unit\";s:2:\"em\";s:4:\"size\";d:1.2;s:5:\"sizes\";a:0:{}}s:24:\"h2_typography_typography\";s:6:\"custom\";s:25:\"h2_typography_font_family\";s:5:\"Exo 2\";s:23:\"h2_typography_font_size\";a:3:{s:4:\"unit\";s:2:\"px\";s:4:\"size\";i:39;s:5:\"sizes\";a:0:{}}s:25:\"h2_typography_font_weight\";s:3:\"600\";s:25:\"h2_typography_line_height\";a:3:{s:4:\"unit\";s:2:\"em\";s:4:\"size\";d:1.2;s:5:\"sizes\";a:0:{}}s:24:\"h3_typography_typography\";s:6:\"custom\";s:25:\"h3_typography_font_family\";s:5:\"Exo 2\";s:23:\"h3_typography_font_size\";a:3:{s:4:\"unit\";s:2:\"px\";s:4:\"size\";i:31;s:5:\"sizes\";a:0:{}}s:25:\"h3_typography_font_weight\";s:3:\"600\";s:25:\"h3_typography_line_height\";a:3:{s:4:\"unit\";s:2:\"em\";s:4:\"size\";d:1.3;s:5:\"sizes\";a:0:{}}s:24:\"h4_typography_typography\";s:6:\"custom\";s:25:\"h4_typography_font_family\";s:5:\"Exo 2\";s:23:\"h4_typography_font_size\";a:3:{s:4:\"unit\";s:2:\"px\";s:4:\"size\";i:25;s:5:\"sizes\";a:0:{}}s:25:\"h4_typography_font_weight\";s:3:\"300\";s:25:\"h4_typography_line_height\";a:3:{s:4:\"unit\";s:2:\"em\";s:4:\"size\";d:1.3;s:5:\"sizes\";a:0:{}}s:24:\"h5_typography_typography\";s:6:\"custom\";s:25:\"h5_typography_font_family\";s:5:\"Exo 2\";s:23:\"h5_typography_font_size\";a:3:{s:4:\"unit\";s:2:\"px\";s:4:\"size\";i:20;s:5:\"sizes\";a:0:{}}s:25:\"h5_typography_font_weight\";s:3:\"600\";s:25:\"h5_typography_line_height\";a:3:{s:4:\"unit\";s:2:\"em\";s:4:\"size\";d:1.4;s:5:\"sizes\";a:0:{}}s:24:\"h6_typography_typography\";s:6:\"custom\";s:25:\"h6_typography_font_family\";s:5:\"Exo 2\";s:23:\"h6_typography_font_size\";a:3:{s:4:\"unit\";s:2:\"px\";s:4:\"size\";i:16;s:5:\"sizes\";a:0:{}}s:25:\"h6_typography_font_weight\";s:3:\"400\";s:25:\"h6_typography_line_height\";a:3:{s:4:\"unit\";s:2:\"em\";s:4:\"size\";s:0:\"\";s:5:\"sizes\";a:0:{}}s:21:\"form_field_text_color\";s:7:\"#F8F8F8\";s:27:\"form_field_focus_text_color\";s:7:\"#AEB0B2\";s:30:\"h1_typography_font_size_tablet\";a:3:{s:4:\"unit\";s:2:\"px\";s:4:\"size\";i:37;s:5:\"sizes\";a:0:{}}s:30:\"h1_typography_font_size_mobile\";a:3:{s:4:\"unit\";s:2:\"px\";s:4:\"size\";i:30;s:5:\"sizes\";a:0:{}}s:30:\"h2_typography_font_size_tablet\";a:3:{s:4:\"unit\";s:2:\"px\";s:4:\"size\";i:31;s:5:\"sizes\";a:0:{}}s:30:\"h2_typography_font_size_mobile\";a:3:{s:4:\"unit\";s:2:\"px\";s:4:\"size\";i:24;s:5:\"sizes\";a:0:{}}s:30:\"h3_typography_font_size_tablet\";a:3:{s:4:\"unit\";s:2:\"px\";s:4:\"size\";i:25;s:5:\"sizes\";a:0:{}}s:30:\"h3_typography_font_size_mobile\";a:3:{s:4:\"unit\";s:2:\"px\";s:4:\"size\";i:20;s:5:\"sizes\";a:0:{}}s:30:\"h4_typography_font_size_tablet\";a:3:{s:4:\"unit\";s:2:\"px\";s:4:\"size\";i:21;s:5:\"sizes\";a:0:{}}s:30:\"h4_typography_font_size_mobile\";a:3:{s:4:\"unit\";s:2:\"px\";s:4:\"size\";i:18;s:5:\"sizes\";a:0:{}}s:30:\"h5_typography_font_size_tablet\";a:3:{s:4:\"unit\";s:2:\"px\";s:4:\"size\";i:18;s:5:\"sizes\";a:0:{}}s:30:\"h5_typography_font_size_mobile\";a:3:{s:4:\"unit\";s:2:\"px\";s:4:\"size\";i:16;s:5:\"sizes\";a:0:{}}s:30:\"h6_typography_font_size_tablet\";a:3:{s:4:\"unit\";s:2:\"px\";s:4:\"size\";i:15;s:5:\"sizes\";a:0:{}}s:30:\"h6_typography_font_size_mobile\";a:3:{s:4:\"unit\";s:2:\"px\";s:4:\"size\";i:14;s:5:\"sizes\";a:0:{}}s:32:\"form_field_box_shadow_box_shadow\";a:5:{s:10:\"horizontal\";i:0;s:8:\"vertical\";i:0;s:4:\"blur\";i:1;s:6:\"spread\";i:1;s:5:\"color\";s:18:\"rgba(0, 0, 0, 0.1)\";}s:29:\"woocommerce_myaccount_page_id\";i:9;s:24:\"woocommerce_cart_page_id\";i:7;s:28:\"woocommerce_checkout_page_id\";i:8;s:26:\"body_background_background\";s:7:\"classic\";s:10:\"body_color\";s:7:\"#AEB0B2\";s:17:\"link_normal_color\";s:7:\"#AEB0B2\";s:8:\"h1_color\";s:7:\"#F8F8F8\";s:8:\"h2_color\";s:7:\"#F8F8F8\";s:8:\"h3_color\";s:7:\"#F8F8F8\";s:24:\"h3_typography_font_style\";s:6:\"normal\";s:8:\"h4_color\";s:7:\"#F8F8F8\";s:28:\"h4_typography_text_transform\";s:4:\"none\";s:24:\"h4_typography_font_style\";s:6:\"normal\";s:8:\"h5_color\";s:7:\"#F8F8F8\";s:28:\"h6_typography_text_transform\";s:9:\"uppercase\";s:17:\"button_text_color\";s:7:\"#FFFFFF\";s:23:\"button_hover_text_color\";s:7:\"#FFFFFF\";s:16:\"form_label_color\";s:7:\"#F8F8F8\";s:21:\"body_background_image\";a:5:{s:3:\"url\";s:0:\"\";s:2:\"id\";s:0:\"\";s:4:\"size\";s:0:\"\";s:3:\"alt\";s:0:\"\";s:6:\"source\";s:7:\"library\";}s:24:\"body_background_position\";s:13:\"center center\";s:22:\"body_background_repeat\";s:8:\"repeat-y\";s:27:\"body_background_size_tablet\";s:7:\"initial\";s:31:\"body_background_bg_width_tablet\";a:3:{s:4:\"unit\";s:1:\"%\";s:4:\"size\";i:0;s:5:\"sizes\";a:0:{}}s:31:\"body_background_bg_width_mobile\";a:3:{s:4:\"unit\";s:1:\"%\";s:4:\"size\";i:0;s:5:\"sizes\";a:0:{}}s:27:\"body_background_size_mobile\";s:7:\"initial\";s:37:\"link_hover_typography_text_decoration\";s:9:\"underline\";s:18:\"form_field_padding\";a:6:{s:4:\"unit\";s:2:\"em\";s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";s:8:\"isLinked\";b:1;}s:28:\"button_box_shadow_box_shadow\";a:5:{s:10:\"horizontal\";i:-30;s:8:\"vertical\";i:0;s:4:\"blur\";i:25;s:6:\"spread\";i:-10;s:5:\"color\";s:7:\"#6B9FF5\";}s:28:\"h2_typography_letter_spacing\";a:3:{s:4:\"unit\";s:2:\"px\";s:4:\"size\";d:-0.5;s:5:\"sizes\";a:0:{}}s:19:\"button_border_color\";s:7:\"#004483\";s:31:\"button_hover_background_color_b\";s:7:\"#004483\";s:25:\"button_hover_border_color\";s:7:\"#E69900\";s:27:\"form_field_background_color\";s:7:\"#001429\";s:23:\"form_field_border_color\";s:9:\"#414F6280\";s:26:\"body_typography_typography\";s:6:\"custom\";s:27:\"body_typography_font_family\";s:5:\"Inter\";s:25:\"body_typography_font_size\";a:3:{s:4:\"unit\";s:2:\"px\";s:4:\"size\";i:16;s:5:\"sizes\";a:0:{}}s:27:\"body_typography_font_weight\";s:3:\"400\";s:30:\"body_typography_text_transform\";s:4:\"none\";s:26:\"body_typography_font_style\";s:6:\"normal\";s:27:\"body_typography_line_height\";a:3:{s:4:\"unit\";s:2:\"em\";s:4:\"size\";d:1.4;s:5:\"sizes\";a:0:{}}s:32:\"body_typography_font_size_tablet\";a:3:{s:4:\"unit\";s:2:\"px\";s:4:\"size\";i:15;s:5:\"sizes\";a:0:{}}s:32:\"body_typography_font_size_mobile\";a:3:{s:4:\"unit\";s:2:\"px\";s:4:\"size\";i:14;s:5:\"sizes\";a:0:{}}s:41:\"form_field_box_shadow_box_shadow_position\";s:5:\"inset\";s:38:\"form_field_focus_box_shadow_box_shadow\";a:5:{s:10:\"horizontal\";i:0;s:8:\"vertical\";i:-1;s:4:\"blur\";i:0;s:6:\"spread\";i:0;s:5:\"color\";s:7:\"#8DC741\";}s:47:\"form_field_focus_box_shadow_box_shadow_position\";s:5:\"inset\";s:28:\"button_typography_typography\";s:6:\"custom\";s:29:\"button_typography_font_family\";s:5:\"Exo 2\";s:27:\"button_typography_font_size\";a:3:{s:4:\"unit\";s:2:\"px\";s:4:\"size\";i:14;s:5:\"sizes\";a:0:{}}s:29:\"button_typography_font_weight\";s:3:\"600\";s:32:\"button_typography_text_transform\";s:9:\"uppercase\";s:29:\"button_typography_line_height\";a:3:{s:4:\"unit\";s:2:\"em\";s:4:\"size\";i:1;s:5:\"sizes\";a:0:{}}s:32:\"button_typography_letter_spacing\";a:3:{s:4:\"unit\";s:2:\"px\";s:4:\"size\";i:0;s:5:\"sizes\";a:0:{}}s:25:\"button_background_color_b\";s:7:\"#E69900\";s:29:\"form_field_focus_border_color\";s:9:\"#FFAD0A80\";s:34:\"button_typography_font_size_tablet\";a:3:{s:4:\"unit\";s:2:\"px\";s:4:\"size\";i:13;s:5:\"sizes\";a:0:{}}s:34:\"button_typography_font_size_mobile\";a:3:{s:4:\"unit\";s:2:\"px\";s:4:\"size\";i:12;s:5:\"sizes\";a:0:{}}s:32:\"button_background_gradient_angle\";a:3:{s:4:\"unit\";s:3:\"deg\";s:4:\"size\";i:120;s:5:\"sizes\";a:0:{}}s:38:\"button_hover_background_gradient_angle\";a:3:{s:4:\"unit\";s:3:\"deg\";s:4:\"size\";i:120;s:5:\"sizes\";a:0:{}}s:21:\"space_between_widgets\";a:6:{s:6:\"column\";s:2:\"20\";s:3:\"row\";s:2:\"20\";s:8:\"isLinked\";b:1;s:4:\"unit\";s:2:\"px\";s:4:\"size\";i:14;s:5:\"sizes\";a:0:{}}s:16:\"link_hover_color\";s:7:\"#E69900\";s:28:\"h1_typography_letter_spacing\";a:3:{s:4:\"unit\";s:2:\"px\";s:4:\"size\";i:-1;s:5:\"sizes\";a:0:{}}s:32:\"form_label_typography_typography\";s:6:\"custom\";s:33:\"form_label_typography_font_family\";s:5:\"Exo 2\";s:31:\"form_label_typography_font_size\";a:3:{s:4:\"unit\";s:2:\"px\";s:4:\"size\";i:18;s:5:\"sizes\";a:0:{}}s:33:\"form_label_typography_font_weight\";s:3:\"600\";s:36:\"form_label_typography_text_transform\";s:9:\"uppercase\";s:33:\"form_label_typography_line_height\";a:3:{s:4:\"unit\";s:2:\"em\";s:4:\"size\";d:1.5;s:5:\"sizes\";a:0:{}}s:32:\"form_field_typography_typography\";s:6:\"custom\";s:33:\"form_field_typography_font_family\";s:5:\"Inter\";s:31:\"form_field_typography_font_size\";a:3:{s:4:\"unit\";s:2:\"px\";s:4:\"size\";i:16;s:5:\"sizes\";a:0:{}}s:33:\"form_field_typography_font_weight\";s:3:\"400\";s:36:\"form_field_typography_text_transform\";s:4:\"none\";s:32:\"form_field_typography_font_style\";s:6:\"normal\";s:33:\"form_field_typography_line_height\";a:3:{s:4:\"unit\";s:2:\"em\";s:4:\"size\";d:1.4;s:5:\"sizes\";a:0:{}}s:38:\"form_label_typography_font_size_tablet\";a:3:{s:4:\"unit\";s:2:\"px\";s:4:\"size\";i:17;s:5:\"sizes\";a:0:{}}s:38:\"form_label_typography_font_size_mobile\";a:3:{s:4:\"unit\";s:2:\"px\";s:4:\"size\";i:16;s:5:\"sizes\";a:0:{}}s:38:\"form_field_typography_font_size_tablet\";a:3:{s:4:\"unit\";s:2:\"px\";s:4:\"size\";i:15;s:5:\"sizes\";a:0:{}}s:38:\"form_field_typography_font_size_mobile\";a:3:{s:4:\"unit\";s:2:\"px\";s:4:\"size\";i:14;s:5:\"sizes\";a:0:{}}s:30:\"button_background_color_b_stop\";a:3:{s:4:\"unit\";s:1:\"%\";s:4:\"size\";i:50;s:5:\"sizes\";a:0:{}}s:37:\"button_box_shadow_box_shadow_position\";s:5:\"inset\";s:34:\"button_hover_box_shadow_box_shadow\";a:5:{s:10:\"horizontal\";i:0;s:8:\"vertical\";i:5;s:4:\"blur\";i:30;s:6:\"spread\";i:0;s:5:\"color\";s:52:\"rgba(238.9999999999999, 255, 81.99999999999999, 0.2)\";}s:28:\"button_background_color_stop\";a:3:{s:4:\"unit\";s:1:\"%\";s:4:\"size\";i:10;s:5:\"sizes\";a:0:{}}s:8:\"h6_color\";s:7:\"#FFAD0A\";s:21:\"body_background_color\";s:7:\"#000814\";s:23:\"button_background_color\";s:7:\"#004483\";s:39:\"button_hover_box_shadow_box_shadow_type\";s:3:\"yes\";s:32:\"colors_enable_styleguide_preview\";s:3:\"yes\";s:29:\"button_hover_background_color\";s:7:\"#E69900\";s:33:\"form_field_focus_background_color\";s:7:\"#001F3D\";}');
INSERT INTO `wp_79e54b1ec2_postmeta` VALUES ('742','139','_elementor_data','[]');
INSERT INTO `wp_79e54b1ec2_postmeta` VALUES ('744','137','envato_tk_source_kit','136');
INSERT INTO `wp_79e54b1ec2_postmeta` VALUES ('745','137','envato_tk_source_index','0');
INSERT INTO `wp_79e54b1ec2_postmeta` VALUES ('746','140','_elementor_edit_mode','builder');
INSERT INTO `wp_79e54b1ec2_postmeta` VALUES ('747','140','_elementor_template_type','kit');
INSERT INTO `wp_79e54b1ec2_postmeta` VALUES ('748','140','_elementor_version','3.32.5');
INSERT INTO `wp_79e54b1ec2_postmeta` VALUES ('749','140','_elementor_pro_version','3.11.2');
INSERT INTO `wp_79e54b1ec2_postmeta` VALUES ('750','140','_wp_page_template','default');
INSERT INTO `wp_79e54b1ec2_postmeta` VALUES ('751','140','_elementor_page_settings','a:157:{s:13:\"system_colors\";a:4:{i:0;a:3:{s:3:\"_id\";s:9:\"secondary\";s:5:\"title\";s:7:\"Heading\";s:5:\"color\";s:7:\"#F8F8F8\";}i:1;a:3:{s:3:\"_id\";s:7:\"primary\";s:5:\"title\";s:10:\"Basic Text\";s:5:\"color\";s:7:\"#AEB0B2\";}i:2;a:3:{s:3:\"_id\";s:4:\"text\";s:5:\"title\";s:6:\"Netral\";s:5:\"color\";s:7:\"#FFFFFF\";}i:3;a:3:{s:3:\"_id\";s:6:\"accent\";s:5:\"title\";s:15:\"Transparent 20%\";s:5:\"color\";s:9:\"#FFFFFF2B\";}}s:13:\"custom_colors\";a:12:{i:0;a:3:{s:3:\"_id\";s:7:\"d49ac81\";s:5:\"title\";s:6:\"Button\";s:5:\"color\";s:7:\"#004483\";}i:1;a:3:{s:3:\"_id\";s:7:\"332724a\";s:5:\"title\";s:12:\"Button Hover\";s:5:\"color\";s:7:\"#E69900\";}i:2;a:3:{s:3:\"_id\";s:7:\"4d462f5\";s:5:\"title\";s:10:\"Line Color\";s:5:\"color\";s:7:\"#414F62\";}i:3;a:3:{s:3:\"_id\";s:7:\"cfa1f76\";s:5:\"title\";s:16:\"Light Background\";s:5:\"color\";s:7:\"#001F3D\";}i:4;a:3:{s:3:\"_id\";s:7:\"7fbea4f\";s:5:\"title\";s:22:\"Extra Light Background\";s:5:\"color\";s:7:\"#002A52\";}i:5;a:3:{s:3:\"_id\";s:7:\"044b931\";s:5:\"title\";s:15:\"Dark Background\";s:5:\"color\";s:7:\"#001429\";}i:6;a:3:{s:3:\"_id\";s:7:\"638d055\";s:5:\"title\";s:21:\"Extra Dark Background\";s:5:\"color\";s:7:\"#000814\";}i:7;a:3:{s:3:\"_id\";s:7:\"ec3c7a7\";s:5:\"title\";s:8:\"Accent 1\";s:5:\"color\";s:7:\"#004483\";}i:8;a:3:{s:3:\"_id\";s:7:\"3ee16e7\";s:5:\"title\";s:8:\"Accent 2\";s:5:\"color\";s:7:\"#E69900\";}i:9;a:3:{s:3:\"_id\";s:7:\"c5a94f6\";s:5:\"title\";s:8:\"Accent 3\";s:5:\"color\";s:7:\"#FFAD0A\";}i:10;a:3:{s:3:\"_id\";s:7:\"e5616b2\";s:5:\"title\";s:8:\"Accent 4\";s:5:\"color\";s:7:\"#AD7505\";}i:11;a:3:{s:3:\"_id\";s:7:\"5c3d4b5\";s:5:\"title\";s:8:\"Accent 5\";s:5:\"color\";s:7:\"#231A05\";}}s:17:\"system_typography\";a:4:{i:0;a:9:{s:3:\"_id\";s:7:\"primary\";s:5:\"title\";s:7:\"Primary\";s:21:\"typography_typography\";s:6:\"custom\";s:22:\"typography_font_family\";s:5:\"Exo 2\";s:22:\"typography_font_weight\";s:3:\"600\";s:20:\"typography_font_size\";a:3:{s:4:\"unit\";s:2:\"px\";s:4:\"size\";i:48;s:5:\"sizes\";a:0:{}}s:22:\"typography_line_height\";a:3:{s:4:\"unit\";s:2:\"em\";s:4:\"size\";d:1.2;s:5:\"sizes\";a:0:{}}s:27:\"typography_font_size_tablet\";a:3:{s:4:\"unit\";s:2:\"px\";s:4:\"size\";i:37;s:5:\"sizes\";a:0:{}}s:27:\"typography_font_size_mobile\";a:3:{s:4:\"unit\";s:2:\"px\";s:4:\"size\";i:30;s:5:\"sizes\";a:0:{}}}i:1;a:10:{s:3:\"_id\";s:9:\"secondary\";s:5:\"title\";s:9:\"Secondary\";s:21:\"typography_typography\";s:6:\"custom\";s:22:\"typography_font_family\";s:5:\"Exo 2\";s:22:\"typography_font_weight\";s:3:\"600\";s:20:\"typography_font_size\";a:3:{s:4:\"unit\";s:2:\"px\";s:4:\"size\";i:39;s:5:\"sizes\";a:0:{}}s:22:\"typography_line_height\";a:3:{s:4:\"unit\";s:2:\"em\";s:4:\"size\";d:1.2;s:5:\"sizes\";a:0:{}}s:27:\"typography_font_size_tablet\";a:3:{s:4:\"unit\";s:2:\"px\";s:4:\"size\";i:31;s:5:\"sizes\";a:0:{}}s:27:\"typography_font_size_mobile\";a:3:{s:4:\"unit\";s:2:\"px\";s:4:\"size\";i:24;s:5:\"sizes\";a:0:{}}s:25:\"typography_letter_spacing\";a:3:{s:4:\"unit\";s:2:\"px\";s:4:\"size\";d:-0.5;s:5:\"sizes\";a:0:{}}}i:2;a:9:{s:3:\"_id\";s:4:\"text\";s:5:\"title\";s:4:\"Text\";s:21:\"typography_typography\";s:6:\"custom\";s:22:\"typography_font_family\";s:5:\"Inter\";s:22:\"typography_font_weight\";s:3:\"400\";s:20:\"typography_font_size\";a:3:{s:4:\"unit\";s:2:\"px\";s:4:\"size\";i:16;s:5:\"sizes\";a:0:{}}s:22:\"typography_line_height\";a:3:{s:4:\"unit\";s:2:\"em\";s:4:\"size\";d:1.4;s:5:\"sizes\";a:0:{}}s:27:\"typography_font_size_tablet\";a:3:{s:4:\"unit\";s:2:\"px\";s:4:\"size\";i:15;s:5:\"sizes\";a:0:{}}s:27:\"typography_font_size_mobile\";a:3:{s:4:\"unit\";s:2:\"px\";s:4:\"size\";i:14;s:5:\"sizes\";a:0:{}}}i:3;a:11:{s:3:\"_id\";s:6:\"accent\";s:5:\"title\";s:6:\"Accent\";s:21:\"typography_typography\";s:6:\"custom\";s:22:\"typography_font_family\";s:5:\"Exo 2\";s:22:\"typography_font_weight\";s:3:\"600\";s:20:\"typography_font_size\";a:3:{s:4:\"unit\";s:2:\"px\";s:4:\"size\";i:14;s:5:\"sizes\";a:0:{}}s:22:\"typography_line_height\";a:3:{s:4:\"unit\";s:2:\"em\";s:4:\"size\";i:1;s:5:\"sizes\";a:0:{}}s:27:\"typography_font_size_tablet\";a:3:{s:4:\"unit\";s:2:\"px\";s:4:\"size\";i:13;s:5:\"sizes\";a:0:{}}s:27:\"typography_font_size_mobile\";a:3:{s:4:\"unit\";s:2:\"px\";s:4:\"size\";i:12;s:5:\"sizes\";a:0:{}}s:25:\"typography_letter_spacing\";a:3:{s:4:\"unit\";s:2:\"px\";s:4:\"size\";i:0;s:5:\"sizes\";a:0:{}}s:25:\"typography_text_transform\";s:9:\"uppercase\";}}s:17:\"custom_typography\";a:11:{i:0;a:11:{s:3:\"_id\";s:7:\"b2ce6af\";s:5:\"title\";s:11:\"Global Font\";s:21:\"typography_typography\";s:6:\"custom\";s:22:\"typography_font_family\";s:5:\"Inter\";s:20:\"typography_font_size\";a:3:{s:4:\"unit\";s:2:\"px\";s:4:\"size\";i:16;s:5:\"sizes\";a:0:{}}s:22:\"typography_line_height\";a:3:{s:4:\"unit\";s:2:\"em\";s:4:\"size\";d:1.4;s:5:\"sizes\";a:0:{}}s:27:\"typography_font_size_tablet\";a:3:{s:4:\"unit\";s:2:\"px\";s:4:\"size\";i:15;s:5:\"sizes\";a:0:{}}s:27:\"typography_font_size_mobile\";a:3:{s:4:\"unit\";s:2:\"px\";s:4:\"size\";i:14;s:5:\"sizes\";a:0:{}}s:22:\"typography_font_weight\";s:3:\"400\";s:25:\"typography_text_transform\";s:4:\"none\";s:21:\"typography_font_style\";s:6:\"normal\";}i:1;a:9:{s:3:\"_id\";s:7:\"69c152f\";s:5:\"title\";s:10:\"Small Font\";s:21:\"typography_typography\";s:6:\"custom\";s:22:\"typography_font_family\";s:5:\"Inter\";s:20:\"typography_font_size\";a:3:{s:4:\"unit\";s:2:\"px\";s:4:\"size\";i:14;s:5:\"sizes\";a:0:{}}s:22:\"typography_line_height\";a:3:{s:4:\"unit\";s:2:\"em\";s:4:\"size\";d:1.4;s:5:\"sizes\";a:0:{}}s:27:\"typography_font_size_tablet\";a:3:{s:4:\"unit\";s:2:\"px\";s:4:\"size\";i:13;s:5:\"sizes\";a:0:{}}s:27:\"typography_font_size_mobile\";a:3:{s:4:\"unit\";s:2:\"px\";s:4:\"size\";i:12;s:5:\"sizes\";a:0:{}}s:22:\"typography_font_weight\";s:3:\"400\";}i:2;a:9:{s:3:\"_id\";s:7:\"520c191\";s:5:\"title\";s:6:\"Header\";s:21:\"typography_typography\";s:6:\"custom\";s:22:\"typography_font_family\";s:5:\"Exo 2\";s:20:\"typography_font_size\";a:3:{s:4:\"unit\";s:2:\"px\";s:4:\"size\";i:18;s:5:\"sizes\";a:0:{}}s:22:\"typography_font_weight\";s:3:\"600\";s:27:\"typography_font_size_mobile\";a:3:{s:4:\"unit\";s:2:\"px\";s:4:\"size\";i:16;s:5:\"sizes\";a:0:{}}s:27:\"typography_font_size_tablet\";a:3:{s:4:\"unit\";s:2:\"px\";s:4:\"size\";i:17;s:5:\"sizes\";a:0:{}}s:22:\"typography_line_height\";a:3:{s:4:\"unit\";s:2:\"em\";s:4:\"size\";d:1.5;s:5:\"sizes\";a:0:{}}}i:3;a:9:{s:3:\"_id\";s:7:\"583e54c\";s:5:\"title\";s:2:\"H1\";s:21:\"typography_typography\";s:6:\"custom\";s:22:\"typography_font_family\";s:5:\"Exo 2\";s:20:\"typography_font_size\";a:3:{s:4:\"unit\";s:2:\"px\";s:4:\"size\";i:48;s:5:\"sizes\";a:0:{}}s:22:\"typography_font_weight\";s:3:\"600\";s:22:\"typography_line_height\";a:3:{s:4:\"unit\";s:2:\"em\";s:4:\"size\";d:1.2;s:5:\"sizes\";a:0:{}}s:27:\"typography_font_size_tablet\";a:3:{s:4:\"unit\";s:2:\"px\";s:4:\"size\";i:37;s:5:\"sizes\";a:0:{}}s:27:\"typography_font_size_mobile\";a:3:{s:4:\"unit\";s:2:\"px\";s:4:\"size\";i:30;s:5:\"sizes\";a:0:{}}}i:4;a:9:{s:3:\"_id\";s:7:\"5d167aa\";s:5:\"title\";s:2:\"H2\";s:21:\"typography_typography\";s:6:\"custom\";s:22:\"typography_font_family\";s:5:\"Exo 2\";s:20:\"typography_font_size\";a:3:{s:4:\"unit\";s:2:\"px\";s:4:\"size\";i:39;s:5:\"sizes\";a:0:{}}s:22:\"typography_font_weight\";s:3:\"600\";s:22:\"typography_line_height\";a:3:{s:4:\"unit\";s:2:\"em\";s:4:\"size\";d:1.2;s:5:\"sizes\";a:0:{}}s:27:\"typography_font_size_tablet\";a:3:{s:4:\"unit\";s:2:\"px\";s:4:\"size\";i:31;s:5:\"sizes\";a:0:{}}s:27:\"typography_font_size_mobile\";a:3:{s:4:\"unit\";s:2:\"px\";s:4:\"size\";i:24;s:5:\"sizes\";a:0:{}}}i:5;a:10:{s:3:\"_id\";s:7:\"d3dae9a\";s:5:\"title\";s:2:\"H3\";s:21:\"typography_typography\";s:6:\"custom\";s:22:\"typography_font_family\";s:5:\"Exo 2\";s:20:\"typography_font_size\";a:3:{s:4:\"unit\";s:2:\"px\";s:4:\"size\";i:31;s:5:\"sizes\";a:0:{}}s:22:\"typography_font_weight\";s:3:\"600\";s:22:\"typography_line_height\";a:3:{s:4:\"unit\";s:2:\"em\";s:4:\"size\";d:1.3;s:5:\"sizes\";a:0:{}}s:27:\"typography_font_size_tablet\";a:3:{s:4:\"unit\";s:2:\"px\";s:4:\"size\";i:25;s:5:\"sizes\";a:0:{}}s:27:\"typography_font_size_mobile\";a:3:{s:4:\"unit\";s:2:\"px\";s:4:\"size\";i:20;s:5:\"sizes\";a:0:{}}s:21:\"typography_font_style\";s:6:\"normal\";}i:6;a:11:{s:3:\"_id\";s:7:\"83682a1\";s:5:\"title\";s:2:\"H4\";s:21:\"typography_typography\";s:6:\"custom\";s:22:\"typography_font_family\";s:5:\"Exo 2\";s:20:\"typography_font_size\";a:3:{s:4:\"unit\";s:2:\"px\";s:4:\"size\";i:25;s:5:\"sizes\";a:0:{}}s:22:\"typography_font_weight\";s:3:\"300\";s:22:\"typography_line_height\";a:3:{s:4:\"unit\";s:2:\"em\";s:4:\"size\";d:1.3;s:5:\"sizes\";a:0:{}}s:27:\"typography_font_size_tablet\";a:3:{s:4:\"unit\";s:2:\"px\";s:4:\"size\";i:21;s:5:\"sizes\";a:0:{}}s:27:\"typography_font_size_mobile\";a:3:{s:4:\"unit\";s:2:\"px\";s:4:\"size\";i:18;s:5:\"sizes\";a:0:{}}s:25:\"typography_text_transform\";s:4:\"none\";s:21:\"typography_font_style\";s:6:\"normal\";}i:7;a:9:{s:3:\"_id\";s:7:\"7044a64\";s:5:\"title\";s:2:\"H5\";s:21:\"typography_typography\";s:6:\"custom\";s:22:\"typography_font_family\";s:5:\"Exo 2\";s:20:\"typography_font_size\";a:3:{s:4:\"unit\";s:2:\"px\";s:4:\"size\";i:20;s:5:\"sizes\";a:0:{}}s:22:\"typography_font_weight\";s:3:\"600\";s:22:\"typography_line_height\";a:3:{s:4:\"unit\";s:2:\"em\";s:4:\"size\";d:1.4;s:5:\"sizes\";a:0:{}}s:27:\"typography_font_size_tablet\";a:3:{s:4:\"unit\";s:2:\"px\";s:4:\"size\";i:18;s:5:\"sizes\";a:0:{}}s:27:\"typography_font_size_mobile\";a:3:{s:4:\"unit\";s:2:\"px\";s:4:\"size\";i:16;s:5:\"sizes\";a:0:{}}}i:8;a:10:{s:3:\"_id\";s:7:\"84ca66e\";s:5:\"title\";s:2:\"H6\";s:21:\"typography_typography\";s:6:\"custom\";s:22:\"typography_font_family\";s:5:\"Exo 2\";s:20:\"typography_font_size\";a:3:{s:4:\"unit\";s:2:\"px\";s:4:\"size\";i:16;s:5:\"sizes\";a:0:{}}s:22:\"typography_font_weight\";s:3:\"400\";s:22:\"typography_line_height\";a:3:{s:4:\"unit\";s:2:\"em\";s:4:\"size\";s:0:\"\";s:5:\"sizes\";a:0:{}}s:27:\"typography_font_size_tablet\";a:3:{s:4:\"unit\";s:2:\"px\";s:4:\"size\";i:15;s:5:\"sizes\";a:0:{}}s:27:\"typography_font_size_mobile\";a:3:{s:4:\"unit\";s:2:\"px\";s:4:\"size\";i:14;s:5:\"sizes\";a:0:{}}s:25:\"typography_text_transform\";s:9:\"uppercase\";}i:9;a:9:{s:3:\"_id\";s:7:\"112b6c4\";s:5:\"title\";s:6:\"Footer\";s:21:\"typography_typography\";s:6:\"custom\";s:22:\"typography_font_family\";s:5:\"Inter\";s:20:\"typography_font_size\";a:3:{s:4:\"unit\";s:2:\"px\";s:4:\"size\";i:13;s:5:\"sizes\";a:0:{}}s:22:\"typography_font_weight\";s:3:\"500\";s:27:\"typography_font_size_tablet\";a:3:{s:4:\"unit\";s:2:\"px\";s:4:\"size\";i:12;s:5:\"sizes\";a:0:{}}s:27:\"typography_font_size_mobile\";a:3:{s:4:\"unit\";s:2:\"px\";s:4:\"size\";i:11;s:5:\"sizes\";a:0:{}}s:22:\"typography_line_height\";a:3:{s:4:\"unit\";s:2:\"em\";s:4:\"size\";d:1.5;s:5:\"sizes\";a:0:{}}}i:10;a:9:{s:3:\"_id\";s:7:\"a435f28\";s:5:\"title\";s:8:\"Big Hero\";s:21:\"typography_typography\";s:6:\"custom\";s:22:\"typography_font_family\";s:5:\"Exo 2\";s:20:\"typography_font_size\";a:3:{s:4:\"unit\";s:2:\"px\";s:4:\"size\";i:61;s:5:\"sizes\";a:0:{}}s:27:\"typography_font_size_tablet\";a:3:{s:4:\"unit\";s:2:\"px\";s:4:\"size\";i:44;s:5:\"sizes\";a:0:{}}s:27:\"typography_font_size_mobile\";a:3:{s:4:\"unit\";s:2:\"px\";s:4:\"size\";i:32;s:5:\"sizes\";a:0:{}}s:22:\"typography_font_weight\";s:3:\"700\";s:22:\"typography_line_height\";a:3:{s:4:\"unit\";s:2:\"em\";s:4:\"size\";i:1;s:5:\"sizes\";a:0:{}}}}s:21:\"default_generic_fonts\";s:10:\"Sans-serif\";s:20:\"button_border_border\";s:5:\"solid\";s:19:\"button_border_width\";a:6:{s:4:\"unit\";s:2:\"px\";s:3:\"top\";s:1:\"1\";s:5:\"right\";s:1:\"1\";s:6:\"bottom\";s:1:\"1\";s:4:\"left\";s:1:\"1\";s:8:\"isLinked\";b:1;}s:20:\"button_border_radius\";a:6:{s:4:\"unit\";s:2:\"px\";s:3:\"top\";s:2:\"14\";s:5:\"right\";s:2:\"14\";s:6:\"bottom\";s:2:\"14\";s:4:\"left\";s:2:\"14\";s:8:\"isLinked\";b:1;}s:26:\"button_hover_border_border\";s:5:\"solid\";s:25:\"button_hover_border_width\";a:6:{s:4:\"unit\";s:2:\"px\";s:3:\"top\";s:1:\"1\";s:5:\"right\";s:1:\"1\";s:6:\"bottom\";s:1:\"1\";s:4:\"left\";s:1:\"1\";s:8:\"isLinked\";b:1;}s:24:\"form_field_border_border\";s:5:\"solid\";s:23:\"form_field_border_width\";a:6:{s:4:\"unit\";s:2:\"px\";s:3:\"top\";s:1:\"1\";s:5:\"right\";s:1:\"1\";s:6:\"bottom\";s:1:\"1\";s:4:\"left\";s:1:\"1\";s:8:\"isLinked\";b:1;}s:24:\"form_field_border_radius\";a:6:{s:4:\"unit\";s:2:\"px\";s:3:\"top\";s:2:\"14\";s:5:\"right\";s:2:\"14\";s:6:\"bottom\";s:2:\"14\";s:4:\"left\";s:2:\"14\";s:8:\"isLinked\";b:1;}s:30:\"form_field_focus_border_border\";s:5:\"solid\";s:29:\"form_field_focus_border_width\";a:6:{s:4:\"unit\";s:2:\"px\";s:3:\"top\";s:1:\"1\";s:5:\"right\";s:1:\"1\";s:6:\"bottom\";s:1:\"1\";s:4:\"left\";s:1:\"1\";s:8:\"isLinked\";b:1;}s:19:\"page_title_selector\";s:14:\"h1.entry-title\";s:27:\"hello_footer_copyright_text\";s:19:\"All rights reserved\";s:15:\"activeItemIndex\";i:1;s:11:\"__globals__\";a:35:{s:27:\"form_field_background_color\";s:25:\"globals/colors?id=044b931\";s:23:\"form_field_border_color\";s:0:\"\";s:33:\"form_field_focus_background_color\";s:25:\"globals/colors?id=cfa1f76\";s:29:\"form_field_focus_border_color\";s:0:\"\";s:21:\"form_field_text_color\";s:27:\"globals/colors?id=secondary\";s:27:\"form_field_focus_text_color\";s:25:\"globals/colors?id=primary\";s:17:\"button_text_color\";s:22:\"globals/colors?id=text\";s:23:\"button_background_color\";s:25:\"globals/colors?id=d49ac81\";s:23:\"button_hover_text_color\";s:22:\"globals/colors?id=text\";s:29:\"button_hover_background_color\";s:25:\"globals/colors?id=332724a\";s:26:\"body_typography_typography\";s:29:\"globals/typography?id=b2ce6af\";s:10:\"body_color\";s:25:\"globals/colors?id=primary\";s:17:\"link_normal_color\";s:25:\"globals/colors?id=primary\";s:16:\"link_hover_color\";s:25:\"globals/colors?id=332724a\";s:24:\"h1_typography_typography\";s:29:\"globals/typography?id=583e54c\";s:24:\"h2_typography_typography\";s:29:\"globals/typography?id=5d167aa\";s:24:\"h3_typography_typography\";s:29:\"globals/typography?id=d3dae9a\";s:24:\"h4_typography_typography\";s:29:\"globals/typography?id=83682a1\";s:24:\"h5_typography_typography\";s:29:\"globals/typography?id=7044a64\";s:24:\"h6_typography_typography\";s:29:\"globals/typography?id=84ca66e\";s:8:\"h6_color\";s:25:\"globals/colors?id=c5a94f6\";s:19:\"button_border_color\";s:25:\"globals/colors?id=d49ac81\";s:25:\"button_hover_border_color\";s:25:\"globals/colors?id=332724a\";s:8:\"h1_color\";s:27:\"globals/colors?id=secondary\";s:8:\"h2_color\";s:27:\"globals/colors?id=secondary\";s:8:\"h3_color\";s:27:\"globals/colors?id=secondary\";s:8:\"h4_color\";s:27:\"globals/colors?id=secondary\";s:8:\"h5_color\";s:27:\"globals/colors?id=secondary\";s:16:\"form_label_color\";s:27:\"globals/colors?id=secondary\";s:25:\"button_background_color_b\";s:25:\"globals/colors?id=332724a\";s:31:\"button_hover_background_color_b\";s:25:\"globals/colors?id=d49ac81\";s:32:\"form_label_typography_typography\";s:29:\"globals/typography?id=520c191\";s:32:\"form_field_typography_typography\";s:29:\"globals/typography?id=b2ce6af\";s:28:\"button_typography_typography\";s:28:\"globals/typography?id=accent\";s:21:\"body_background_color\";s:25:\"globals/colors?id=638d055\";}s:11:\"viewport_md\";i:768;s:11:\"viewport_lg\";i:1025;s:15:\"container_width\";a:3:{s:4:\"unit\";s:2:\"px\";s:4:\"size\";i:1280;s:5:\"sizes\";a:0:{}}s:24:\"h1_typography_typography\";s:6:\"custom\";s:25:\"h1_typography_font_family\";s:5:\"Exo 2\";s:23:\"h1_typography_font_size\";a:3:{s:4:\"unit\";s:2:\"px\";s:4:\"size\";i:48;s:5:\"sizes\";a:0:{}}s:25:\"h1_typography_font_weight\";s:3:\"600\";s:25:\"h1_typography_line_height\";a:3:{s:4:\"unit\";s:2:\"em\";s:4:\"size\";d:1.2;s:5:\"sizes\";a:0:{}}s:24:\"h2_typography_typography\";s:6:\"custom\";s:25:\"h2_typography_font_family\";s:5:\"Exo 2\";s:23:\"h2_typography_font_size\";a:3:{s:4:\"unit\";s:2:\"px\";s:4:\"size\";i:39;s:5:\"sizes\";a:0:{}}s:25:\"h2_typography_font_weight\";s:3:\"600\";s:25:\"h2_typography_line_height\";a:3:{s:4:\"unit\";s:2:\"em\";s:4:\"size\";d:1.2;s:5:\"sizes\";a:0:{}}s:24:\"h3_typography_typography\";s:6:\"custom\";s:25:\"h3_typography_font_family\";s:5:\"Exo 2\";s:23:\"h3_typography_font_size\";a:3:{s:4:\"unit\";s:2:\"px\";s:4:\"size\";i:31;s:5:\"sizes\";a:0:{}}s:25:\"h3_typography_font_weight\";s:3:\"600\";s:25:\"h3_typography_line_height\";a:3:{s:4:\"unit\";s:2:\"em\";s:4:\"size\";d:1.3;s:5:\"sizes\";a:0:{}}s:24:\"h4_typography_typography\";s:6:\"custom\";s:25:\"h4_typography_font_family\";s:5:\"Exo 2\";s:23:\"h4_typography_font_size\";a:3:{s:4:\"unit\";s:2:\"px\";s:4:\"size\";i:25;s:5:\"sizes\";a:0:{}}s:25:\"h4_typography_font_weight\";s:3:\"300\";s:25:\"h4_typography_line_height\";a:3:{s:4:\"unit\";s:2:\"em\";s:4:\"size\";d:1.3;s:5:\"sizes\";a:0:{}}s:24:\"h5_typography_typography\";s:6:\"custom\";s:25:\"h5_typography_font_family\";s:5:\"Exo 2\";s:23:\"h5_typography_font_size\";a:3:{s:4:\"unit\";s:2:\"px\";s:4:\"size\";i:20;s:5:\"sizes\";a:0:{}}s:25:\"h5_typography_font_weight\";s:3:\"600\";s:25:\"h5_typography_line_height\";a:3:{s:4:\"unit\";s:2:\"em\";s:4:\"size\";d:1.4;s:5:\"sizes\";a:0:{}}s:24:\"h6_typography_typography\";s:6:\"custom\";s:25:\"h6_typography_font_family\";s:5:\"Exo 2\";s:23:\"h6_typography_font_size\";a:3:{s:4:\"unit\";s:2:\"px\";s:4:\"size\";i:16;s:5:\"sizes\";a:0:{}}s:25:\"h6_typography_font_weight\";s:3:\"400\";s:25:\"h6_typography_line_height\";a:3:{s:4:\"unit\";s:2:\"em\";s:4:\"size\";s:0:\"\";s:5:\"sizes\";a:0:{}}s:21:\"form_field_text_color\";s:7:\"#F8F8F8\";s:27:\"form_field_focus_text_color\";s:7:\"#AEB0B2\";s:30:\"h1_typography_font_size_tablet\";a:3:{s:4:\"unit\";s:2:\"px\";s:4:\"size\";i:37;s:5:\"sizes\";a:0:{}}s:30:\"h1_typography_font_size_mobile\";a:3:{s:4:\"unit\";s:2:\"px\";s:4:\"size\";i:30;s:5:\"sizes\";a:0:{}}s:30:\"h2_typography_font_size_tablet\";a:3:{s:4:\"unit\";s:2:\"px\";s:4:\"size\";i:31;s:5:\"sizes\";a:0:{}}s:30:\"h2_typography_font_size_mobile\";a:3:{s:4:\"unit\";s:2:\"px\";s:4:\"size\";i:24;s:5:\"sizes\";a:0:{}}s:30:\"h3_typography_font_size_tablet\";a:3:{s:4:\"unit\";s:2:\"px\";s:4:\"size\";i:25;s:5:\"sizes\";a:0:{}}s:30:\"h3_typography_font_size_mobile\";a:3:{s:4:\"unit\";s:2:\"px\";s:4:\"size\";i:20;s:5:\"sizes\";a:0:{}}s:30:\"h4_typography_font_size_tablet\";a:3:{s:4:\"unit\";s:2:\"px\";s:4:\"size\";i:21;s:5:\"sizes\";a:0:{}}s:30:\"h4_typography_font_size_mobile\";a:3:{s:4:\"unit\";s:2:\"px\";s:4:\"size\";i:18;s:5:\"sizes\";a:0:{}}s:30:\"h5_typography_font_size_tablet\";a:3:{s:4:\"unit\";s:2:\"px\";s:4:\"size\";i:18;s:5:\"sizes\";a:0:{}}s:30:\"h5_typography_font_size_mobile\";a:3:{s:4:\"unit\";s:2:\"px\";s:4:\"size\";i:16;s:5:\"sizes\";a:0:{}}s:30:\"h6_typography_font_size_tablet\";a:3:{s:4:\"unit\";s:2:\"px\";s:4:\"size\";i:15;s:5:\"sizes\";a:0:{}}s:30:\"h6_typography_font_size_mobile\";a:3:{s:4:\"unit\";s:2:\"px\";s:4:\"size\";i:14;s:5:\"sizes\";a:0:{}}s:32:\"form_field_box_shadow_box_shadow\";a:5:{s:10:\"horizontal\";i:0;s:8:\"vertical\";i:0;s:4:\"blur\";i:1;s:6:\"spread\";i:1;s:5:\"color\";s:18:\"rgba(0, 0, 0, 0.1)\";}s:29:\"woocommerce_myaccount_page_id\";i:9;s:24:\"woocommerce_cart_page_id\";i:7;s:28:\"woocommerce_checkout_page_id\";i:8;s:26:\"body_background_background\";s:7:\"classic\";s:10:\"body_color\";s:7:\"#AEB0B2\";s:17:\"link_normal_color\";s:7:\"#AEB0B2\";s:8:\"h1_color\";s:7:\"#F8F8F8\";s:8:\"h2_color\";s:7:\"#F8F8F8\";s:8:\"h3_color\";s:7:\"#F8F8F8\";s:24:\"h3_typography_font_style\";s:6:\"normal\";s:8:\"h4_color\";s:7:\"#F8F8F8\";s:28:\"h4_typography_text_transform\";s:4:\"none\";s:24:\"h4_typography_font_style\";s:6:\"normal\";s:8:\"h5_color\";s:7:\"#F8F8F8\";s:28:\"h6_typography_text_transform\";s:9:\"uppercase\";s:17:\"button_text_color\";s:7:\"#FFFFFF\";s:23:\"button_hover_text_color\";s:7:\"#FFFFFF\";s:16:\"form_label_color\";s:7:\"#F8F8F8\";s:21:\"body_background_image\";a:5:{s:3:\"url\";s:0:\"\";s:2:\"id\";s:0:\"\";s:4:\"size\";s:0:\"\";s:3:\"alt\";s:0:\"\";s:6:\"source\";s:7:\"library\";}s:24:\"body_background_position\";s:13:\"center center\";s:22:\"body_background_repeat\";s:8:\"repeat-y\";s:27:\"body_background_size_tablet\";s:7:\"initial\";s:31:\"body_background_bg_width_tablet\";a:3:{s:4:\"unit\";s:1:\"%\";s:4:\"size\";i:0;s:5:\"sizes\";a:0:{}}s:31:\"body_background_bg_width_mobile\";a:3:{s:4:\"unit\";s:1:\"%\";s:4:\"size\";i:0;s:5:\"sizes\";a:0:{}}s:27:\"body_background_size_mobile\";s:7:\"initial\";s:37:\"link_hover_typography_text_decoration\";s:9:\"underline\";s:18:\"form_field_padding\";a:6:{s:4:\"unit\";s:2:\"em\";s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";s:8:\"isLinked\";b:1;}s:28:\"button_box_shadow_box_shadow\";a:5:{s:10:\"horizontal\";i:-30;s:8:\"vertical\";i:0;s:4:\"blur\";i:25;s:6:\"spread\";i:-10;s:5:\"color\";s:7:\"#6B9FF5\";}s:28:\"h2_typography_letter_spacing\";a:3:{s:4:\"unit\";s:2:\"px\";s:4:\"size\";d:-0.5;s:5:\"sizes\";a:0:{}}s:19:\"button_border_color\";s:7:\"#004483\";s:31:\"button_hover_background_color_b\";s:7:\"#004483\";s:25:\"button_hover_border_color\";s:7:\"#E69900\";s:27:\"form_field_background_color\";s:7:\"#001429\";s:23:\"form_field_border_color\";s:9:\"#414F6280\";s:26:\"body_typography_typography\";s:6:\"custom\";s:27:\"body_typography_font_family\";s:5:\"Inter\";s:25:\"body_typography_font_size\";a:3:{s:4:\"unit\";s:2:\"px\";s:4:\"size\";i:16;s:5:\"sizes\";a:0:{}}s:27:\"body_typography_font_weight\";s:3:\"400\";s:30:\"body_typography_text_transform\";s:4:\"none\";s:26:\"body_typography_font_style\";s:6:\"normal\";s:27:\"body_typography_line_height\";a:3:{s:4:\"unit\";s:2:\"em\";s:4:\"size\";d:1.4;s:5:\"sizes\";a:0:{}}s:32:\"body_typography_font_size_tablet\";a:3:{s:4:\"unit\";s:2:\"px\";s:4:\"size\";i:15;s:5:\"sizes\";a:0:{}}s:32:\"body_typography_font_size_mobile\";a:3:{s:4:\"unit\";s:2:\"px\";s:4:\"size\";i:14;s:5:\"sizes\";a:0:{}}s:41:\"form_field_box_shadow_box_shadow_position\";s:5:\"inset\";s:38:\"form_field_focus_box_shadow_box_shadow\";a:5:{s:10:\"horizontal\";i:0;s:8:\"vertical\";i:-1;s:4:\"blur\";i:0;s:6:\"spread\";i:0;s:5:\"color\";s:7:\"#8DC741\";}s:47:\"form_field_focus_box_shadow_box_shadow_position\";s:5:\"inset\";s:28:\"button_typography_typography\";s:6:\"custom\";s:29:\"button_typography_font_family\";s:5:\"Exo 2\";s:27:\"button_typography_font_size\";a:3:{s:4:\"unit\";s:2:\"px\";s:4:\"size\";i:14;s:5:\"sizes\";a:0:{}}s:29:\"button_typography_font_weight\";s:3:\"600\";s:32:\"button_typography_text_transform\";s:9:\"uppercase\";s:29:\"button_typography_line_height\";a:3:{s:4:\"unit\";s:2:\"em\";s:4:\"size\";i:1;s:5:\"sizes\";a:0:{}}s:32:\"button_typography_letter_spacing\";a:3:{s:4:\"unit\";s:2:\"px\";s:4:\"size\";i:0;s:5:\"sizes\";a:0:{}}s:25:\"button_background_color_b\";s:7:\"#E69900\";s:29:\"form_field_focus_border_color\";s:9:\"#FFAD0A80\";s:34:\"button_typography_font_size_tablet\";a:3:{s:4:\"unit\";s:2:\"px\";s:4:\"size\";i:13;s:5:\"sizes\";a:0:{}}s:34:\"button_typography_font_size_mobile\";a:3:{s:4:\"unit\";s:2:\"px\";s:4:\"size\";i:12;s:5:\"sizes\";a:0:{}}s:32:\"button_background_gradient_angle\";a:3:{s:4:\"unit\";s:3:\"deg\";s:4:\"size\";i:120;s:5:\"sizes\";a:0:{}}s:38:\"button_hover_background_gradient_angle\";a:3:{s:4:\"unit\";s:3:\"deg\";s:4:\"size\";i:120;s:5:\"sizes\";a:0:{}}s:21:\"space_between_widgets\";a:6:{s:6:\"column\";s:2:\"20\";s:3:\"row\";s:2:\"20\";s:8:\"isLinked\";b:1;s:4:\"unit\";s:2:\"px\";s:4:\"size\";i:14;s:5:\"sizes\";a:0:{}}s:16:\"link_hover_color\";s:7:\"#E69900\";s:28:\"h1_typography_letter_spacing\";a:3:{s:4:\"unit\";s:2:\"px\";s:4:\"size\";i:-1;s:5:\"sizes\";a:0:{}}s:32:\"form_label_typography_typography\";s:6:\"custom\";s:33:\"form_label_typography_font_family\";s:5:\"Exo 2\";s:31:\"form_label_typography_font_size\";a:3:{s:4:\"unit\";s:2:\"px\";s:4:\"size\";i:18;s:5:\"sizes\";a:0:{}}s:33:\"form_label_typography_font_weight\";s:3:\"600\";s:36:\"form_label_typography_text_transform\";s:9:\"uppercase\";s:33:\"form_label_typography_line_height\";a:3:{s:4:\"unit\";s:2:\"em\";s:4:\"size\";d:1.5;s:5:\"sizes\";a:0:{}}s:32:\"form_field_typography_typography\";s:6:\"custom\";s:33:\"form_field_typography_font_family\";s:5:\"Inter\";s:31:\"form_field_typography_font_size\";a:3:{s:4:\"unit\";s:2:\"px\";s:4:\"size\";i:16;s:5:\"sizes\";a:0:{}}s:33:\"form_field_typography_font_weight\";s:3:\"400\";s:36:\"form_field_typography_text_transform\";s:4:\"none\";s:32:\"form_field_typography_font_style\";s:6:\"normal\";s:33:\"form_field_typography_line_height\";a:3:{s:4:\"unit\";s:2:\"em\";s:4:\"size\";d:1.4;s:5:\"sizes\";a:0:{}}s:38:\"form_label_typography_font_size_tablet\";a:3:{s:4:\"unit\";s:2:\"px\";s:4:\"size\";i:17;s:5:\"sizes\";a:0:{}}s:38:\"form_label_typography_font_size_mobile\";a:3:{s:4:\"unit\";s:2:\"px\";s:4:\"size\";i:16;s:5:\"sizes\";a:0:{}}s:38:\"form_field_typography_font_size_tablet\";a:3:{s:4:\"unit\";s:2:\"px\";s:4:\"size\";i:15;s:5:\"sizes\";a:0:{}}s:38:\"form_field_typography_font_size_mobile\";a:3:{s:4:\"unit\";s:2:\"px\";s:4:\"size\";i:14;s:5:\"sizes\";a:0:{}}s:30:\"button_background_color_b_stop\";a:3:{s:4:\"unit\";s:1:\"%\";s:4:\"size\";i:50;s:5:\"sizes\";a:0:{}}s:37:\"button_box_shadow_box_shadow_position\";s:5:\"inset\";s:34:\"button_hover_box_shadow_box_shadow\";a:5:{s:10:\"horizontal\";i:0;s:8:\"vertical\";i:5;s:4:\"blur\";i:30;s:6:\"spread\";i:0;s:5:\"color\";s:52:\"rgba(238.9999999999999, 255, 81.99999999999999, 0.2)\";}s:28:\"button_background_color_stop\";a:3:{s:4:\"unit\";s:1:\"%\";s:4:\"size\";i:10;s:5:\"sizes\";a:0:{}}s:8:\"h6_color\";s:7:\"#FFAD0A\";s:21:\"body_background_color\";s:7:\"#000814\";s:23:\"button_background_color\";s:7:\"#004483\";s:39:\"button_hover_box_shadow_box_shadow_type\";s:3:\"yes\";s:32:\"colors_enable_styleguide_preview\";s:3:\"yes\";s:29:\"button_hover_background_color\";s:7:\"#E69900\";s:33:\"form_field_focus_background_color\";s:7:\"#001F3D\";}');
INSERT INTO `wp_79e54b1ec2_postmeta` VALUES ('752','140','_elementor_data','[]');
INSERT INTO `wp_79e54b1ec2_postmeta` VALUES ('763','143','_wp_attached_file','2025/10/man-an-electrical-technician-working-in-a-switchboard-with-fuses-1-2.jpg');
INSERT INTO `wp_79e54b1ec2_postmeta` VALUES ('764','143','_wp_attachment_metadata','a:6:{s:5:\"width\";i:1280;s:6:\"height\";i:853;s:4:\"file\";s:80:\"2025/10/man-an-electrical-technician-working-in-a-switchboard-with-fuses-1-2.jpg\";s:8:\"filesize\";i:141942;s:5:\"sizes\";a:4:{s:6:\"medium\";a:5:{s:4:\"file\";s:80:\"man-an-electrical-technician-working-in-a-switchboard-with-fuses-1-2-300x200.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:200;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:14329;}s:5:\"large\";a:5:{s:4:\"file\";s:81:\"man-an-electrical-technician-working-in-a-switchboard-with-fuses-1-2-1024x682.jpg\";s:5:\"width\";i:1024;s:6:\"height\";i:682;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:95274;}s:9:\"thumbnail\";a:5:{s:4:\"file\";s:80:\"man-an-electrical-technician-working-in-a-switchboard-with-fuses-1-2-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:6685;}s:12:\"medium_large\";a:5:{s:4:\"file\";s:80:\"man-an-electrical-technician-working-in-a-switchboard-with-fuses-1-2-768x512.jpg\";s:5:\"width\";i:768;s:6:\"height\";i:512;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:61542;}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}');
INSERT INTO `wp_79e54b1ec2_postmeta` VALUES ('765','143','_elementor_source_image_hash','d53e4559cdd566f5b3e4a331cbdc8a2ed7b85d10');
INSERT INTO `wp_79e54b1ec2_postmeta` VALUES ('766','144','_wp_attached_file','2025/10/happy-business-people-work-on-sustainable-renewable-energy-project-inside-office-eco-electricity.jpg');
INSERT INTO `wp_79e54b1ec2_postmeta` VALUES ('767','144','_wp_attachment_metadata','a:6:{s:5:\"width\";i:1280;s:6:\"height\";i:853;s:4:\"file\";s:108:\"2025/10/happy-business-people-work-on-sustainable-renewable-energy-project-inside-office-eco-electricity.jpg\";s:8:\"filesize\";i:152954;s:5:\"sizes\";a:4:{s:6:\"medium\";a:5:{s:4:\"file\";s:108:\"happy-business-people-work-on-sustainable-renewable-energy-project-inside-office-eco-electricity-300x200.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:200;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:16151;}s:5:\"large\";a:5:{s:4:\"file\";s:109:\"happy-business-people-work-on-sustainable-renewable-energy-project-inside-office-eco-electricity-1024x682.jpg\";s:5:\"width\";i:1024;s:6:\"height\";i:682;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:101346;}s:9:\"thumbnail\";a:5:{s:4:\"file\";s:108:\"happy-business-people-work-on-sustainable-renewable-energy-project-inside-office-eco-electricity-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:7566;}s:12:\"medium_large\";a:5:{s:4:\"file\";s:108:\"happy-business-people-work-on-sustainable-renewable-energy-project-inside-office-eco-electricity-768x512.jpg\";s:5:\"width\";i:768;s:6:\"height\";i:512;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:65779;}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}');
INSERT INTO `wp_79e54b1ec2_postmeta` VALUES ('768','144','_elementor_source_image_hash','a7df73455b353a21a65b6fd25ea1f97947813104');
INSERT INTO `wp_79e54b1ec2_postmeta` VALUES ('769','145','_wp_attached_file','2025/10/placeholder-1.png');
INSERT INTO `wp_79e54b1ec2_postmeta` VALUES ('770','145','_wp_attachment_metadata','a:6:{s:5:\"width\";i:1200;s:6:\"height\";i:800;s:4:\"file\";s:25:\"2025/10/placeholder-1.png\";s:8:\"filesize\";i:6146;s:5:\"sizes\";a:4:{s:6:\"medium\";a:5:{s:4:\"file\";s:25:\"placeholder-1-300x200.png\";s:5:\"width\";i:300;s:6:\"height\";i:200;s:9:\"mime-type\";s:9:\"image/png\";s:8:\"filesize\";i:1860;}s:5:\"large\";a:5:{s:4:\"file\";s:26:\"placeholder-1-1024x683.png\";s:5:\"width\";i:1024;s:6:\"height\";i:683;s:9:\"mime-type\";s:9:\"image/png\";s:8:\"filesize\";i:6951;}s:9:\"thumbnail\";a:5:{s:4:\"file\";s:25:\"placeholder-1-150x150.png\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:9:\"image/png\";s:8:\"filesize\";i:1117;}s:12:\"medium_large\";a:5:{s:4:\"file\";s:25:\"placeholder-1-768x512.png\";s:5:\"width\";i:768;s:6:\"height\";i:512;s:9:\"mime-type\";s:9:\"image/png\";s:8:\"filesize\";i:4970;}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}');
INSERT INTO `wp_79e54b1ec2_postmeta` VALUES ('771','145','_elementor_source_image_hash','85c2c77a28fed4891af0c79411c6ceb624f9dfe8');
INSERT INTO `wp_79e54b1ec2_postmeta` VALUES ('772','146','_wp_attached_file','2025/10/architect-tablet-or-happy-people-warehouse-group-or-teamwork-on-online-design-maintenance-report.jpg');
INSERT INTO `wp_79e54b1ec2_postmeta` VALUES ('773','146','_wp_attachment_metadata','a:6:{s:5:\"width\";i:1280;s:6:\"height\";i:675;s:4:\"file\";s:108:\"2025/10/architect-tablet-or-happy-people-warehouse-group-or-teamwork-on-online-design-maintenance-report.jpg\";s:8:\"filesize\";i:100846;s:5:\"sizes\";a:4:{s:6:\"medium\";a:5:{s:4:\"file\";s:108:\"architect-tablet-or-happy-people-warehouse-group-or-teamwork-on-online-design-maintenance-report-300x158.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:158;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:11828;}s:5:\"large\";a:5:{s:4:\"file\";s:109:\"architect-tablet-or-happy-people-warehouse-group-or-teamwork-on-online-design-maintenance-report-1024x540.jpg\";s:5:\"width\";i:1024;s:6:\"height\";i:540;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:68799;}s:9:\"thumbnail\";a:5:{s:4:\"file\";s:108:\"architect-tablet-or-happy-people-warehouse-group-or-teamwork-on-online-design-maintenance-report-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:6781;}s:12:\"medium_large\";a:5:{s:4:\"file\";s:108:\"architect-tablet-or-happy-people-warehouse-group-or-teamwork-on-online-design-maintenance-report-768x405.jpg\";s:5:\"width\";i:768;s:6:\"height\";i:405;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:45776;}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}');
INSERT INTO `wp_79e54b1ec2_postmeta` VALUES ('774','146','_elementor_source_image_hash','d91844ebb67b508cb4f9e2318886be1949d6bd94');
INSERT INTO `wp_79e54b1ec2_postmeta` VALUES ('775','147','_wp_attached_file','2025/10/placeholder-2.png');
INSERT INTO `wp_79e54b1ec2_postmeta` VALUES ('776','147','_wp_attachment_metadata','a:6:{s:5:\"width\";i:1200;s:6:\"height\";i:800;s:4:\"file\";s:25:\"2025/10/placeholder-2.png\";s:8:\"filesize\";i:4425;s:5:\"sizes\";a:4:{s:6:\"medium\";a:5:{s:4:\"file\";s:25:\"placeholder-2-300x200.png\";s:5:\"width\";i:300;s:6:\"height\";i:200;s:9:\"mime-type\";s:9:\"image/png\";s:8:\"filesize\";i:1860;}s:5:\"large\";a:5:{s:4:\"file\";s:26:\"placeholder-2-1024x683.png\";s:5:\"width\";i:1024;s:6:\"height\";i:683;s:9:\"mime-type\";s:9:\"image/png\";s:8:\"filesize\";i:6951;}s:9:\"thumbnail\";a:5:{s:4:\"file\";s:25:\"placeholder-2-150x150.png\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:9:\"image/png\";s:8:\"filesize\";i:1117;}s:12:\"medium_large\";a:5:{s:4:\"file\";s:25:\"placeholder-2-768x512.png\";s:5:\"width\";i:768;s:6:\"height\";i:512;s:9:\"mime-type\";s:9:\"image/png\";s:8:\"filesize\";i:4970;}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}');
INSERT INTO `wp_79e54b1ec2_postmeta` VALUES ('777','147','_elementor_source_image_hash','85c2c77a28fed4891af0c79411c6ceb624f9dfe8');
INSERT INTO `wp_79e54b1ec2_postmeta` VALUES ('778','148','_wp_attached_file','2025/10/smart-home-wall-system-phone-and-woman-with-digital-monitor-for-house-automation-air-conditioning.jpg');
INSERT INTO `wp_79e54b1ec2_postmeta` VALUES ('779','148','_wp_attachment_metadata','a:6:{s:5:\"width\";i:1280;s:6:\"height\";i:910;s:4:\"file\";s:109:\"2025/10/smart-home-wall-system-phone-and-woman-with-digital-monitor-for-house-automation-air-conditioning.jpg\";s:8:\"filesize\";i:110099;s:5:\"sizes\";a:4:{s:6:\"medium\";a:5:{s:4:\"file\";s:109:\"smart-home-wall-system-phone-and-woman-with-digital-monitor-for-house-automation-air-conditioning-300x213.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:213;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:11544;}s:5:\"large\";a:5:{s:4:\"file\";s:110:\"smart-home-wall-system-phone-and-woman-with-digital-monitor-for-house-automation-air-conditioning-1024x728.jpg\";s:5:\"width\";i:1024;s:6:\"height\";i:728;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:73493;}s:9:\"thumbnail\";a:5:{s:4:\"file\";s:109:\"smart-home-wall-system-phone-and-woman-with-digital-monitor-for-house-automation-air-conditioning-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:5306;}s:12:\"medium_large\";a:5:{s:4:\"file\";s:109:\"smart-home-wall-system-phone-and-woman-with-digital-monitor-for-house-automation-air-conditioning-768x546.jpg\";s:5:\"width\";i:768;s:6:\"height\";i:546;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:47911;}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}');
INSERT INTO `wp_79e54b1ec2_postmeta` VALUES ('780','148','_elementor_source_image_hash','699237cbc62ac8fcb49d8983ed3ab309ffa58a41');
INSERT INTO `wp_79e54b1ec2_postmeta` VALUES ('781','149','_wp_attached_file','2025/10/placeholder-3.png');
INSERT INTO `wp_79e54b1ec2_postmeta` VALUES ('782','149','_wp_attachment_metadata','a:6:{s:5:\"width\";i:1200;s:6:\"height\";i:800;s:4:\"file\";s:25:\"2025/10/placeholder-3.png\";s:8:\"filesize\";i:4425;s:5:\"sizes\";a:4:{s:6:\"medium\";a:5:{s:4:\"file\";s:25:\"placeholder-3-300x200.png\";s:5:\"width\";i:300;s:6:\"height\";i:200;s:9:\"mime-type\";s:9:\"image/png\";s:8:\"filesize\";i:1860;}s:5:\"large\";a:5:{s:4:\"file\";s:26:\"placeholder-3-1024x683.png\";s:5:\"width\";i:1024;s:6:\"height\";i:683;s:9:\"mime-type\";s:9:\"image/png\";s:8:\"filesize\";i:6951;}s:9:\"thumbnail\";a:5:{s:4:\"file\";s:25:\"placeholder-3-150x150.png\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:9:\"image/png\";s:8:\"filesize\";i:1117;}s:12:\"medium_large\";a:5:{s:4:\"file\";s:25:\"placeholder-3-768x512.png\";s:5:\"width\";i:768;s:6:\"height\";i:512;s:9:\"mime-type\";s:9:\"image/png\";s:8:\"filesize\";i:4970;}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}');
INSERT INTO `wp_79e54b1ec2_postmeta` VALUES ('783','149','_elementor_source_image_hash','85c2c77a28fed4891af0c79411c6ceb624f9dfe8');
INSERT INTO `wp_79e54b1ec2_postmeta` VALUES ('784','150','_wp_attached_file','2025/10/team-of-experts-checked-at-the-electrical-and-check-the-integrity-of-the-system-in-the-control-room.jpg');
INSERT INTO `wp_79e54b1ec2_postmeta` VALUES ('785','150','_wp_attachment_metadata','a:6:{s:5:\"width\";i:1280;s:6:\"height\";i:853;s:4:\"file\";s:111:\"2025/10/team-of-experts-checked-at-the-electrical-and-check-the-integrity-of-the-system-in-the-control-room.jpg\";s:8:\"filesize\";i:124357;s:5:\"sizes\";a:4:{s:6:\"medium\";a:5:{s:4:\"file\";s:111:\"team-of-experts-checked-at-the-electrical-and-check-the-integrity-of-the-system-in-the-control-room-300x200.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:200;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:14330;}s:5:\"large\";a:5:{s:4:\"file\";s:112:\"team-of-experts-checked-at-the-electrical-and-check-the-integrity-of-the-system-in-the-control-room-1024x682.jpg\";s:5:\"width\";i:1024;s:6:\"height\";i:682;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:84512;}s:9:\"thumbnail\";a:5:{s:4:\"file\";s:111:\"team-of-experts-checked-at-the-electrical-and-check-the-integrity-of-the-system-in-the-control-room-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:6846;}s:12:\"medium_large\";a:5:{s:4:\"file\";s:111:\"team-of-experts-checked-at-the-electrical-and-check-the-integrity-of-the-system-in-the-control-room-768x512.jpg\";s:5:\"width\";i:768;s:6:\"height\";i:512;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:55580;}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}');
INSERT INTO `wp_79e54b1ec2_postmeta` VALUES ('786','150','_elementor_source_image_hash','baed45fba2c535f44ceeb65aa40a920988ce7913');
INSERT INTO `wp_79e54b1ec2_postmeta` VALUES ('787','151','_wp_attached_file','2025/10/placeholder-4.png');
INSERT INTO `wp_79e54b1ec2_postmeta` VALUES ('788','151','_wp_attachment_metadata','a:6:{s:5:\"width\";i:1200;s:6:\"height\";i:800;s:4:\"file\";s:25:\"2025/10/placeholder-4.png\";s:8:\"filesize\";i:4425;s:5:\"sizes\";a:4:{s:6:\"medium\";a:5:{s:4:\"file\";s:25:\"placeholder-4-300x200.png\";s:5:\"width\";i:300;s:6:\"height\";i:200;s:9:\"mime-type\";s:9:\"image/png\";s:8:\"filesize\";i:1860;}s:5:\"large\";a:5:{s:4:\"file\";s:26:\"placeholder-4-1024x683.png\";s:5:\"width\";i:1024;s:6:\"height\";i:683;s:9:\"mime-type\";s:9:\"image/png\";s:8:\"filesize\";i:6951;}s:9:\"thumbnail\";a:5:{s:4:\"file\";s:25:\"placeholder-4-150x150.png\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:9:\"image/png\";s:8:\"filesize\";i:1117;}s:12:\"medium_large\";a:5:{s:4:\"file\";s:25:\"placeholder-4-768x512.png\";s:5:\"width\";i:768;s:6:\"height\";i:512;s:9:\"mime-type\";s:9:\"image/png\";s:8:\"filesize\";i:4970;}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}');
INSERT INTO `wp_79e54b1ec2_postmeta` VALUES ('789','151','_elementor_source_image_hash','85c2c77a28fed4891af0c79411c6ceb624f9dfe8');
INSERT INTO `wp_79e54b1ec2_postmeta` VALUES ('790','152','_wp_attached_file','2025/10/wind-turbine-service-engineer-plan-for-inspection-and-maintenance-renewable-electricity-generator.jpg');
INSERT INTO `wp_79e54b1ec2_postmeta` VALUES ('791','152','_wp_attachment_metadata','a:6:{s:5:\"width\";i:1280;s:6:\"height\";i:853;s:4:\"file\";s:109:\"2025/10/wind-turbine-service-engineer-plan-for-inspection-and-maintenance-renewable-electricity-generator.jpg\";s:8:\"filesize\";i:133445;s:5:\"sizes\";a:4:{s:6:\"medium\";a:5:{s:4:\"file\";s:109:\"wind-turbine-service-engineer-plan-for-inspection-and-maintenance-renewable-electricity-generator-300x200.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:200;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:13901;}s:5:\"large\";a:5:{s:4:\"file\";s:110:\"wind-turbine-service-engineer-plan-for-inspection-and-maintenance-renewable-electricity-generator-1024x682.jpg\";s:5:\"width\";i:1024;s:6:\"height\";i:682;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:89029;}s:9:\"thumbnail\";a:5:{s:4:\"file\";s:109:\"wind-turbine-service-engineer-plan-for-inspection-and-maintenance-renewable-electricity-generator-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:6934;}s:12:\"medium_large\";a:5:{s:4:\"file\";s:109:\"wind-turbine-service-engineer-plan-for-inspection-and-maintenance-renewable-electricity-generator-768x512.jpg\";s:5:\"width\";i:768;s:6:\"height\";i:512;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:57962;}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}');
INSERT INTO `wp_79e54b1ec2_postmeta` VALUES ('792','152','_elementor_source_image_hash','b4ee3cea4c29c36f374eeb7d1dc1a2fb37e30871');
INSERT INTO `wp_79e54b1ec2_postmeta` VALUES ('793','153','_wp_attached_file','2025/10/electrical-engineer-holding-energy-saving-light-bulb-on-unfocused-background-of-windmill-.jpg');
INSERT INTO `wp_79e54b1ec2_postmeta` VALUES ('794','153','_wp_attachment_metadata','a:6:{s:5:\"width\";i:1280;s:6:\"height\";i:853;s:4:\"file\";s:101:\"2025/10/electrical-engineer-holding-energy-saving-light-bulb-on-unfocused-background-of-windmill-.jpg\";s:8:\"filesize\";i:88876;s:5:\"sizes\";a:4:{s:6:\"medium\";a:5:{s:4:\"file\";s:101:\"electrical-engineer-holding-energy-saving-light-bulb-on-unfocused-background-of-windmill--300x200.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:200;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:10030;}s:5:\"large\";a:5:{s:4:\"file\";s:102:\"electrical-engineer-holding-energy-saving-light-bulb-on-unfocused-background-of-windmill--1024x682.jpg\";s:5:\"width\";i:1024;s:6:\"height\";i:682;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:61322;}s:9:\"thumbnail\";a:5:{s:4:\"file\";s:101:\"electrical-engineer-holding-energy-saving-light-bulb-on-unfocused-background-of-windmill--150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:5042;}s:12:\"medium_large\";a:5:{s:4:\"file\";s:101:\"electrical-engineer-holding-energy-saving-light-bulb-on-unfocused-background-of-windmill--768x512.jpg\";s:5:\"width\";i:768;s:6:\"height\";i:512;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:40173;}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}');
INSERT INTO `wp_79e54b1ec2_postmeta` VALUES ('795','153','_elementor_source_image_hash','3ade2cac256e07f922afe8fc38b5e8ea2ff0a7ee');
INSERT INTO `wp_79e54b1ec2_postmeta` VALUES ('796','154','_wp_attached_file','2025/10/background_3.png');
INSERT INTO `wp_79e54b1ec2_postmeta` VALUES ('797','154','_wp_attachment_metadata','a:6:{s:5:\"width\";i:686;s:6:\"height\";i:522;s:4:\"file\";s:24:\"2025/10/background_3.png\";s:8:\"filesize\";i:10591;s:5:\"sizes\";a:2:{s:6:\"medium\";a:5:{s:4:\"file\";s:24:\"background_3-300x228.png\";s:5:\"width\";i:300;s:6:\"height\";i:228;s:9:\"mime-type\";s:9:\"image/png\";s:8:\"filesize\";i:2645;}s:9:\"thumbnail\";a:5:{s:4:\"file\";s:24:\"background_3-150x150.png\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:9:\"image/png\";s:8:\"filesize\";i:1372;}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}');
INSERT INTO `wp_79e54b1ec2_postmeta` VALUES ('798','154','_elementor_source_image_hash','04742b3af79fdcd9b43219e1f75c1370ee671934');
INSERT INTO `wp_79e54b1ec2_postmeta` VALUES ('799','155','_wp_attached_file','2025/10/Ornament-1.png');
INSERT INTO `wp_79e54b1ec2_postmeta` VALUES ('800','155','_wp_attachment_metadata','a:6:{s:5:\"width\";i:300;s:6:\"height\";i:300;s:4:\"file\";s:22:\"2025/10/Ornament-1.png\";s:8:\"filesize\";i:9973;s:5:\"sizes\";a:1:{s:9:\"thumbnail\";a:5:{s:4:\"file\";s:22:\"Ornament-1-150x150.png\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:9:\"image/png\";s:8:\"filesize\";i:2147;}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}');
INSERT INTO `wp_79e54b1ec2_postmeta` VALUES ('801','155','_elementor_source_image_hash','82a1886405ad0226fb2b6cc1f7d88aeb1fef1eb7');
INSERT INTO `wp_79e54b1ec2_postmeta` VALUES ('802','156','_wp_attached_file','2025/10/engineers-are-checking-electronic-system-at-basement-.jpg');
INSERT INTO `wp_79e54b1ec2_postmeta` VALUES ('803','156','_wp_attachment_metadata','a:6:{s:5:\"width\";i:1280;s:6:\"height\";i:853;s:4:\"file\";s:65:\"2025/10/engineers-are-checking-electronic-system-at-basement-.jpg\";s:8:\"filesize\";i:111518;s:5:\"sizes\";a:4:{s:6:\"medium\";a:5:{s:4:\"file\";s:65:\"engineers-are-checking-electronic-system-at-basement--300x200.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:200;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:11678;}s:5:\"large\";a:5:{s:4:\"file\";s:66:\"engineers-are-checking-electronic-system-at-basement--1024x682.jpg\";s:5:\"width\";i:1024;s:6:\"height\";i:682;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:73773;}s:9:\"thumbnail\";a:5:{s:4:\"file\";s:65:\"engineers-are-checking-electronic-system-at-basement--150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:5898;}s:12:\"medium_large\";a:5:{s:4:\"file\";s:65:\"engineers-are-checking-electronic-system-at-basement--768x512.jpg\";s:5:\"width\";i:768;s:6:\"height\";i:512;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:47317;}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}');
INSERT INTO `wp_79e54b1ec2_postmeta` VALUES ('804','156','_elementor_source_image_hash','53bd1a6248751de8e8a4a929b9116b4a2625edb0');
INSERT INTO `wp_79e54b1ec2_postmeta` VALUES ('805','157','_wp_attached_file','2025/10/background_1.png');
INSERT INTO `wp_79e54b1ec2_postmeta` VALUES ('806','157','_wp_attachment_metadata','a:6:{s:5:\"width\";i:696;s:6:\"height\";i:508;s:4:\"file\";s:24:\"2025/10/background_1.png\";s:8:\"filesize\";i:10389;s:5:\"sizes\";a:2:{s:6:\"medium\";a:5:{s:4:\"file\";s:24:\"background_1-300x219.png\";s:5:\"width\";i:300;s:6:\"height\";i:219;s:9:\"mime-type\";s:9:\"image/png\";s:8:\"filesize\";i:2591;}s:9:\"thumbnail\";a:5:{s:4:\"file\";s:24:\"background_1-150x150.png\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:9:\"image/png\";s:8:\"filesize\";i:1358;}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}');
INSERT INTO `wp_79e54b1ec2_postmeta` VALUES ('807','157','_elementor_source_image_hash','89efd771193318c8014f32003ecde434a4e0ab11');
INSERT INTO `wp_79e54b1ec2_postmeta` VALUES ('808','158','_wp_attached_file','2025/10/point-1.png');
INSERT INTO `wp_79e54b1ec2_postmeta` VALUES ('809','158','_wp_attachment_metadata','a:6:{s:5:\"width\";i:1041;s:6:\"height\";i:125;s:4:\"file\";s:19:\"2025/10/point-1.png\";s:8:\"filesize\";i:12028;s:5:\"sizes\";a:4:{s:6:\"medium\";a:5:{s:4:\"file\";s:18:\"point-1-300x36.png\";s:5:\"width\";i:300;s:6:\"height\";i:36;s:9:\"mime-type\";s:9:\"image/png\";s:8:\"filesize\";i:2269;}s:5:\"large\";a:5:{s:4:\"file\";s:20:\"point-1-1024x123.png\";s:5:\"width\";i:1024;s:6:\"height\";i:123;s:9:\"mime-type\";s:9:\"image/png\";s:8:\"filesize\";i:7846;}s:9:\"thumbnail\";a:5:{s:4:\"file\";s:19:\"point-1-150x125.png\";s:5:\"width\";i:150;s:6:\"height\";i:125;s:9:\"mime-type\";s:9:\"image/png\";s:8:\"filesize\";i:1196;}s:12:\"medium_large\";a:5:{s:4:\"file\";s:18:\"point-1-768x92.png\";s:5:\"width\";i:768;s:6:\"height\";i:92;s:9:\"mime-type\";s:9:\"image/png\";s:8:\"filesize\";i:5863;}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}');
INSERT INTO `wp_79e54b1ec2_postmeta` VALUES ('810','158','_elementor_source_image_hash','7b25e5f566f827589b726b999ce161bd73d5ae79');
INSERT INTO `wp_79e54b1ec2_postmeta` VALUES ('811','159','_wp_attached_file','2025/10/point-2.png');
INSERT INTO `wp_79e54b1ec2_postmeta` VALUES ('812','159','_wp_attachment_metadata','a:6:{s:5:\"width\";i:956;s:6:\"height\";i:125;s:4:\"file\";s:19:\"2025/10/point-2.png\";s:8:\"filesize\";i:12698;s:5:\"sizes\";a:3:{s:6:\"medium\";a:5:{s:4:\"file\";s:18:\"point-2-300x39.png\";s:5:\"width\";i:300;s:6:\"height\";i:39;s:9:\"mime-type\";s:9:\"image/png\";s:8:\"filesize\";i:2504;}s:9:\"thumbnail\";a:5:{s:4:\"file\";s:19:\"point-2-150x125.png\";s:5:\"width\";i:150;s:6:\"height\";i:125;s:9:\"mime-type\";s:9:\"image/png\";s:8:\"filesize\";i:1336;}s:12:\"medium_large\";a:5:{s:4:\"file\";s:19:\"point-2-768x100.png\";s:5:\"width\";i:768;s:6:\"height\";i:100;s:9:\"mime-type\";s:9:\"image/png\";s:8:\"filesize\";i:6788;}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}');
INSERT INTO `wp_79e54b1ec2_postmeta` VALUES ('813','159','_elementor_source_image_hash','dbd554b9afa714935bbff770f7ff14aba59f0dab');
INSERT INTO `wp_79e54b1ec2_postmeta` VALUES ('814','160','_wp_attached_file','2025/10/point-3.png');
INSERT INTO `wp_79e54b1ec2_postmeta` VALUES ('815','160','_wp_attachment_metadata','a:6:{s:5:\"width\";i:907;s:6:\"height\";i:125;s:4:\"file\";s:19:\"2025/10/point-3.png\";s:8:\"filesize\";i:10871;s:5:\"sizes\";a:3:{s:6:\"medium\";a:5:{s:4:\"file\";s:18:\"point-3-300x41.png\";s:5:\"width\";i:300;s:6:\"height\";i:41;s:9:\"mime-type\";s:9:\"image/png\";s:8:\"filesize\";i:2333;}s:9:\"thumbnail\";a:5:{s:4:\"file\";s:19:\"point-3-150x125.png\";s:5:\"width\";i:150;s:6:\"height\";i:125;s:9:\"mime-type\";s:9:\"image/png\";s:8:\"filesize\";i:1121;}s:12:\"medium_large\";a:5:{s:4:\"file\";s:19:\"point-3-768x106.png\";s:5:\"width\";i:768;s:6:\"height\";i:106;s:9:\"mime-type\";s:9:\"image/png\";s:8:\"filesize\";i:6173;}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}');
INSERT INTO `wp_79e54b1ec2_postmeta` VALUES ('816','160','_elementor_source_image_hash','62f5fa43033b15e95fb791d270d85124b0ffa74a');
INSERT INTO `wp_79e54b1ec2_postmeta` VALUES ('817','161','_wp_attached_file','2025/10/point-4.png');
INSERT INTO `wp_79e54b1ec2_postmeta` VALUES ('818','161','_wp_attachment_metadata','a:6:{s:5:\"width\";i:1061;s:6:\"height\";i:125;s:4:\"file\";s:19:\"2025/10/point-4.png\";s:8:\"filesize\";i:12836;s:5:\"sizes\";a:4:{s:6:\"medium\";a:5:{s:4:\"file\";s:18:\"point-4-300x35.png\";s:5:\"width\";i:300;s:6:\"height\";i:35;s:9:\"mime-type\";s:9:\"image/png\";s:8:\"filesize\";i:2338;}s:5:\"large\";a:5:{s:4:\"file\";s:20:\"point-4-1024x121.png\";s:5:\"width\";i:1024;s:6:\"height\";i:121;s:9:\"mime-type\";s:9:\"image/png\";s:8:\"filesize\";i:8443;}s:9:\"thumbnail\";a:5:{s:4:\"file\";s:19:\"point-4-150x125.png\";s:5:\"width\";i:150;s:6:\"height\";i:125;s:9:\"mime-type\";s:9:\"image/png\";s:8:\"filesize\";i:1237;}s:12:\"medium_large\";a:5:{s:4:\"file\";s:18:\"point-4-768x90.png\";s:5:\"width\";i:768;s:6:\"height\";i:90;s:9:\"mime-type\";s:9:\"image/png\";s:8:\"filesize\";i:6211;}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}');
INSERT INTO `wp_79e54b1ec2_postmeta` VALUES ('819','161','_elementor_source_image_hash','97466c33aca359e2da6355d99075794d27abf05f');
INSERT INTO `wp_79e54b1ec2_postmeta` VALUES ('820','162','_wp_attached_file','2025/10/point-5.png');
INSERT INTO `wp_79e54b1ec2_postmeta` VALUES ('821','162','_wp_attachment_metadata','a:6:{s:5:\"width\";i:1010;s:6:\"height\";i:125;s:4:\"file\";s:19:\"2025/10/point-5.png\";s:8:\"filesize\";i:11655;s:5:\"sizes\";a:3:{s:6:\"medium\";a:5:{s:4:\"file\";s:18:\"point-5-300x37.png\";s:5:\"width\";i:300;s:6:\"height\";i:37;s:9:\"mime-type\";s:9:\"image/png\";s:8:\"filesize\";i:2297;}s:9:\"thumbnail\";a:5:{s:4:\"file\";s:19:\"point-5-150x125.png\";s:5:\"width\";i:150;s:6:\"height\";i:125;s:9:\"mime-type\";s:9:\"image/png\";s:8:\"filesize\";i:1166;}s:12:\"medium_large\";a:5:{s:4:\"file\";s:18:\"point-5-768x95.png\";s:5:\"width\";i:768;s:6:\"height\";i:95;s:9:\"mime-type\";s:9:\"image/png\";s:8:\"filesize\";i:5984;}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}');
INSERT INTO `wp_79e54b1ec2_postmeta` VALUES ('822','162','_elementor_source_image_hash','d2d6d5aadfd3a317f27bb6338cee73c8c83658d0');
INSERT INTO `wp_79e54b1ec2_postmeta` VALUES ('823','163','_wp_attached_file','2025/10/engineer-use-tablet-working-inspection-installatio-2024-12-20-11-19-08-utc.png');
INSERT INTO `wp_79e54b1ec2_postmeta` VALUES ('824','163','_wp_attachment_metadata','a:6:{s:5:\"width\";i:640;s:6:\"height\";i:879;s:4:\"file\";s:86:\"2025/10/engineer-use-tablet-working-inspection-installatio-2024-12-20-11-19-08-utc.png\";s:8:\"filesize\";i:131865;s:5:\"sizes\";a:2:{s:6:\"medium\";a:5:{s:4:\"file\";s:86:\"engineer-use-tablet-working-inspection-installatio-2024-12-20-11-19-08-utc-218x300.png\";s:5:\"width\";i:218;s:6:\"height\";i:300;s:9:\"mime-type\";s:9:\"image/png\";s:8:\"filesize\";i:27065;}s:9:\"thumbnail\";a:5:{s:4:\"file\";s:86:\"engineer-use-tablet-working-inspection-installatio-2024-12-20-11-19-08-utc-150x150.png\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:9:\"image/png\";s:8:\"filesize\";i:12436;}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}');
INSERT INTO `wp_79e54b1ec2_postmeta` VALUES ('825','163','_elementor_source_image_hash','cff6b58129889a3cd35d00991702c7afe58df9d6');
INSERT INTO `wp_79e54b1ec2_postmeta` VALUES ('826','164','_wp_attached_file','2025/10/img__15.jpg');
INSERT INTO `wp_79e54b1ec2_postmeta` VALUES ('827','164','_wp_attachment_metadata','a:6:{s:5:\"width\";i:500;s:6:\"height\";i:500;s:4:\"file\";s:19:\"2025/10/img__15.jpg\";s:8:\"filesize\";i:43289;s:5:\"sizes\";a:2:{s:6:\"medium\";a:5:{s:4:\"file\";s:19:\"img__15-300x300.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:300;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:17965;}s:9:\"thumbnail\";a:5:{s:4:\"file\";s:19:\"img__15-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:6854;}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}');
INSERT INTO `wp_79e54b1ec2_postmeta` VALUES ('828','164','_elementor_source_image_hash','87c3c65bbdb81ae8ea100b31cc91d1d012572ae2');
INSERT INTO `wp_79e54b1ec2_postmeta` VALUES ('829','165','_wp_attached_file','2025/10/img__06.jpg');
INSERT INTO `wp_79e54b1ec2_postmeta` VALUES ('830','165','_wp_attachment_metadata','a:6:{s:5:\"width\";i:500;s:6:\"height\";i:500;s:4:\"file\";s:19:\"2025/10/img__06.jpg\";s:8:\"filesize\";i:37406;s:5:\"sizes\";a:2:{s:6:\"medium\";a:5:{s:4:\"file\";s:19:\"img__06-300x300.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:300;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:14775;}s:9:\"thumbnail\";a:5:{s:4:\"file\";s:19:\"img__06-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:5444;}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}');
INSERT INTO `wp_79e54b1ec2_postmeta` VALUES ('831','165','_elementor_source_image_hash','a6651097da386b31af3c9f2bd0e1dfca864b38ef');
INSERT INTO `wp_79e54b1ec2_postmeta` VALUES ('832','166','_wp_attached_file','2025/10/img__16.jpg');
INSERT INTO `wp_79e54b1ec2_postmeta` VALUES ('833','166','_wp_attachment_metadata','a:6:{s:5:\"width\";i:500;s:6:\"height\";i:500;s:4:\"file\";s:19:\"2025/10/img__16.jpg\";s:8:\"filesize\";i:50944;s:5:\"sizes\";a:2:{s:6:\"medium\";a:5:{s:4:\"file\";s:19:\"img__16-300x300.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:300;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:21317;}s:9:\"thumbnail\";a:5:{s:4:\"file\";s:19:\"img__16-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:7830;}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}');
INSERT INTO `wp_79e54b1ec2_postmeta` VALUES ('834','166','_elementor_source_image_hash','4262cfd38169643e51d663348a69d26c743ca48e');
INSERT INTO `wp_79e54b1ec2_postmeta` VALUES ('835','167','_wp_attached_file','2025/10/Frame-7.png');
INSERT INTO `wp_79e54b1ec2_postmeta` VALUES ('836','167','_wp_attachment_metadata','a:6:{s:5:\"width\";i:792;s:6:\"height\";i:200;s:4:\"file\";s:19:\"2025/10/Frame-7.png\";s:8:\"filesize\";i:44684;s:5:\"sizes\";a:4:{s:6:\"medium\";a:5:{s:4:\"file\";s:18:\"Frame-7-300x76.png\";s:5:\"width\";i:300;s:6:\"height\";i:76;s:9:\"mime-type\";s:9:\"image/png\";s:8:\"filesize\";i:4168;}s:9:\"thumbnail\";a:5:{s:4:\"file\";s:19:\"Frame-7-150x150.png\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:9:\"image/png\";s:8:\"filesize\";i:819;}s:12:\"medium_large\";a:5:{s:4:\"file\";s:19:\"Frame-7-768x194.png\";s:5:\"width\";i:768;s:6:\"height\";i:194;s:9:\"mime-type\";s:9:\"image/png\";s:8:\"filesize\";i:13019;}s:20:\"elementor_custom_x42\";a:4:{s:4:\"file\";s:71:\"elementor/thumbs/Frame-7-rdvo3ziii4mxcen2uidzg2yx250iezzrmt5q2vhce8.png\";s:5:\"width\";i:0;s:6:\"height\";i:42;s:9:\"mime-type\";s:9:\"image/png\";}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}');
INSERT INTO `wp_79e54b1ec2_postmeta` VALUES ('837','167','_elementor_source_image_hash','36672f1f5cfda5d9aafbfb0366922fca6bcbb039');
INSERT INTO `wp_79e54b1ec2_postmeta` VALUES ('838','168','_wp_attached_file','2025/10/Frame-6.png');
INSERT INTO `wp_79e54b1ec2_postmeta` VALUES ('839','168','_wp_attachment_metadata','a:6:{s:5:\"width\";i:787;s:6:\"height\";i:200;s:4:\"file\";s:19:\"2025/10/Frame-6.png\";s:8:\"filesize\";i:26346;s:5:\"sizes\";a:4:{s:6:\"medium\";a:5:{s:4:\"file\";s:18:\"Frame-6-300x76.png\";s:5:\"width\";i:300;s:6:\"height\";i:76;s:9:\"mime-type\";s:9:\"image/png\";s:8:\"filesize\";i:4038;}s:9:\"thumbnail\";a:5:{s:4:\"file\";s:19:\"Frame-6-150x150.png\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:9:\"image/png\";s:8:\"filesize\";i:743;}s:12:\"medium_large\";a:5:{s:4:\"file\";s:19:\"Frame-6-768x195.png\";s:5:\"width\";i:768;s:6:\"height\";i:195;s:9:\"mime-type\";s:9:\"image/png\";s:8:\"filesize\";i:10506;}s:20:\"elementor_custom_x42\";a:4:{s:4:\"file\";s:71:\"elementor/thumbs/Frame-6-rdvo40gcoyo7o0lpp0sm0kqdnivvmp3hyxt7k5fy80.png\";s:5:\"width\";i:0;s:6:\"height\";i:42;s:9:\"mime-type\";s:9:\"image/png\";}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}');
INSERT INTO `wp_79e54b1ec2_postmeta` VALUES ('840','168','_elementor_source_image_hash','224ecb69c18338a63685b1928c81fd239c4aeffc');
INSERT INTO `wp_79e54b1ec2_postmeta` VALUES ('841','169','_wp_attached_file','2025/10/Frame-5.png');
INSERT INTO `wp_79e54b1ec2_postmeta` VALUES ('842','169','_wp_attachment_metadata','a:6:{s:5:\"width\";i:780;s:6:\"height\";i:200;s:4:\"file\";s:19:\"2025/10/Frame-5.png\";s:8:\"filesize\";i:48683;s:5:\"sizes\";a:4:{s:6:\"medium\";a:5:{s:4:\"file\";s:18:\"Frame-5-300x77.png\";s:5:\"width\";i:300;s:6:\"height\";i:77;s:9:\"mime-type\";s:9:\"image/png\";s:8:\"filesize\";i:4176;}s:9:\"thumbnail\";a:5:{s:4:\"file\";s:19:\"Frame-5-150x150.png\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:9:\"image/png\";s:8:\"filesize\";i:889;}s:12:\"medium_large\";a:5:{s:4:\"file\";s:19:\"Frame-5-768x197.png\";s:5:\"width\";i:768;s:6:\"height\";i:197;s:9:\"mime-type\";s:9:\"image/png\";s:8:\"filesize\";i:12579;}s:20:\"elementor_custom_x42\";a:4:{s:4:\"file\";s:71:\"elementor/thumbs/Frame-5-rdvo40gcoyo7o0lpp0sm0kqdnivvmp3hyxt7k5fy80.png\";s:5:\"width\";i:0;s:6:\"height\";i:42;s:9:\"mime-type\";s:9:\"image/png\";}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}');
INSERT INTO `wp_79e54b1ec2_postmeta` VALUES ('843','169','_elementor_source_image_hash','87d9a09f7ee89bcab735e29bc571f5b2ab858d0c');
INSERT INTO `wp_79e54b1ec2_postmeta` VALUES ('844','170','_wp_attached_file','2025/10/Frame-4.png');
INSERT INTO `wp_79e54b1ec2_postmeta` VALUES ('845','170','_wp_attachment_metadata','a:6:{s:5:\"width\";i:843;s:6:\"height\";i:200;s:4:\"file\";s:19:\"2025/10/Frame-4.png\";s:8:\"filesize\";i:28136;s:5:\"sizes\";a:4:{s:6:\"medium\";a:5:{s:4:\"file\";s:18:\"Frame-4-300x71.png\";s:5:\"width\";i:300;s:6:\"height\";i:71;s:9:\"mime-type\";s:9:\"image/png\";s:8:\"filesize\";i:3805;}s:9:\"thumbnail\";a:5:{s:4:\"file\";s:19:\"Frame-4-150x150.png\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:9:\"image/png\";s:8:\"filesize\";i:648;}s:12:\"medium_large\";a:5:{s:4:\"file\";s:19:\"Frame-4-768x182.png\";s:5:\"width\";i:768;s:6:\"height\";i:182;s:9:\"mime-type\";s:9:\"image/png\";s:8:\"filesize\";i:10221;}s:20:\"elementor_custom_x42\";a:4:{s:4:\"file\";s:71:\"elementor/thumbs/Frame-4-rdvo41e6vsphzmkcjj78l2hu8wr8ue78b2gp1fek1s.png\";s:5:\"width\";i:0;s:6:\"height\";i:42;s:9:\"mime-type\";s:9:\"image/png\";}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}');
INSERT INTO `wp_79e54b1ec2_postmeta` VALUES ('846','170','_elementor_source_image_hash','741b7b8d5b902abe120e289aa893d50cae7e30ca');
INSERT INTO `wp_79e54b1ec2_postmeta` VALUES ('847','171','_wp_attached_file','2025/10/Frame-3.png');
INSERT INTO `wp_79e54b1ec2_postmeta` VALUES ('848','171','_wp_attachment_metadata','a:6:{s:5:\"width\";i:855;s:6:\"height\";i:200;s:4:\"file\";s:19:\"2025/10/Frame-3.png\";s:8:\"filesize\";i:8903;s:5:\"sizes\";a:4:{s:6:\"medium\";a:5:{s:4:\"file\";s:18:\"Frame-3-300x70.png\";s:5:\"width\";i:300;s:6:\"height\";i:70;s:9:\"mime-type\";s:9:\"image/png\";s:8:\"filesize\";i:2249;}s:9:\"thumbnail\";a:5:{s:4:\"file\";s:19:\"Frame-3-150x150.png\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:9:\"image/png\";s:8:\"filesize\";i:1516;}s:12:\"medium_large\";a:5:{s:4:\"file\";s:19:\"Frame-3-768x180.png\";s:5:\"width\";i:768;s:6:\"height\";i:180;s:9:\"mime-type\";s:9:\"image/png\";s:8:\"filesize\";i:6116;}s:20:\"elementor_custom_x42\";a:4:{s:4:\"file\";s:71:\"elementor/thumbs/Frame-3-rdvo42c12mqsb8ize1lv5k9auamm23ayn746ipd5vk.png\";s:5:\"width\";i:0;s:6:\"height\";i:42;s:9:\"mime-type\";s:9:\"image/png\";}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}');
INSERT INTO `wp_79e54b1ec2_postmeta` VALUES ('849','171','_elementor_source_image_hash','060381254c27aeb02fb6d8ad8ae9ac8b2eb5a290');
INSERT INTO `wp_79e54b1ec2_postmeta` VALUES ('850','172','_wp_attached_file','2025/10/Frame-2.png');
INSERT INTO `wp_79e54b1ec2_postmeta` VALUES ('851','172','_wp_attachment_metadata','a:6:{s:5:\"width\";i:848;s:6:\"height\";i:200;s:4:\"file\";s:19:\"2025/10/Frame-2.png\";s:8:\"filesize\";i:13710;s:5:\"sizes\";a:4:{s:6:\"medium\";a:5:{s:4:\"file\";s:18:\"Frame-2-300x71.png\";s:5:\"width\";i:300;s:6:\"height\";i:71;s:9:\"mime-type\";s:9:\"image/png\";s:8:\"filesize\";i:3120;}s:9:\"thumbnail\";a:5:{s:4:\"file\";s:19:\"Frame-2-150x150.png\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:9:\"image/png\";s:8:\"filesize\";i:722;}s:12:\"medium_large\";a:5:{s:4:\"file\";s:19:\"Frame-2-768x181.png\";s:5:\"width\";i:768;s:6:\"height\";i:181;s:9:\"mime-type\";s:9:\"image/png\";s:8:\"filesize\";i:7947;}s:20:\"elementor_custom_x42\";a:4:{s:4:\"file\";s:71:\"elementor/thumbs/Frame-2-rdvo439v9gs2muhm8k0hq20rfohz9seozbrnzzbrpc.png\";s:5:\"width\";i:0;s:6:\"height\";i:42;s:9:\"mime-type\";s:9:\"image/png\";}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}');
INSERT INTO `wp_79e54b1ec2_postmeta` VALUES ('852','172','_elementor_source_image_hash','770a0a1c15d95d0f393d2b5eb909afb168c8142b');
INSERT INTO `wp_79e54b1ec2_postmeta` VALUES ('853','173','_wp_attached_file','2025/10/Frame-1.png');
INSERT INTO `wp_79e54b1ec2_postmeta` VALUES ('854','173','_wp_attachment_metadata','a:6:{s:5:\"width\";i:760;s:6:\"height\";i:200;s:4:\"file\";s:19:\"2025/10/Frame-1.png\";s:8:\"filesize\";i:13096;s:5:\"sizes\";a:3:{s:6:\"medium\";a:5:{s:4:\"file\";s:18:\"Frame-1-300x79.png\";s:5:\"width\";i:300;s:6:\"height\";i:79;s:9:\"mime-type\";s:9:\"image/png\";s:8:\"filesize\";i:2930;}s:9:\"thumbnail\";a:5:{s:4:\"file\";s:19:\"Frame-1-150x150.png\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:9:\"image/png\";s:8:\"filesize\";i:688;}s:20:\"elementor_custom_x42\";a:4:{s:4:\"file\";s:71:\"elementor/thumbs/Frame-1-rdvo447pgatcygg932f4ajs812dchhifbgf5h9adj4.png\";s:5:\"width\";i:0;s:6:\"height\";i:42;s:9:\"mime-type\";s:9:\"image/png\";}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}');
INSERT INTO `wp_79e54b1ec2_postmeta` VALUES ('855','173','_elementor_source_image_hash','df8b05c3fc5545e1d21b6a05d67f671c7f66056e');
INSERT INTO `wp_79e54b1ec2_postmeta` VALUES ('856','174','_wp_attached_file','2025/10/Frame.png');
INSERT INTO `wp_79e54b1ec2_postmeta` VALUES ('857','174','_wp_attachment_metadata','a:6:{s:5:\"width\";i:799;s:6:\"height\";i:200;s:4:\"file\";s:17:\"2025/10/Frame.png\";s:8:\"filesize\";i:24682;s:5:\"sizes\";a:4:{s:6:\"medium\";a:5:{s:4:\"file\";s:16:\"Frame-300x75.png\";s:5:\"width\";i:300;s:6:\"height\";i:75;s:9:\"mime-type\";s:9:\"image/png\";s:8:\"filesize\";i:3980;}s:9:\"thumbnail\";a:5:{s:4:\"file\";s:17:\"Frame-150x150.png\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:9:\"image/png\";s:8:\"filesize\";i:725;}s:12:\"medium_large\";a:5:{s:4:\"file\";s:17:\"Frame-768x192.png\";s:5:\"width\";i:768;s:6:\"height\";i:192;s:9:\"mime-type\";s:9:\"image/png\";s:8:\"filesize\";i:11066;}s:20:\"elementor_custom_x42\";a:4:{s:4:\"file\";s:69:\"elementor/thumbs/Frame-rdvo455jn4una2evxktqv1jomg8pp6m5nl2myj8zcw.png\";s:5:\"width\";i:0;s:6:\"height\";i:42;s:9:\"mime-type\";s:9:\"image/png\";}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}');
INSERT INTO `wp_79e54b1ec2_postmeta` VALUES ('858','174','_elementor_source_image_hash','df46142a00ab033c97436ffc3155bb331dd4fb71');
INSERT INTO `wp_79e54b1ec2_postmeta` VALUES ('873','177','_wp_attached_file','2025/10/placeholder-5.png');
INSERT INTO `wp_79e54b1ec2_postmeta` VALUES ('874','177','_wp_attachment_metadata','a:6:{s:5:\"width\";i:1200;s:6:\"height\";i:800;s:4:\"file\";s:25:\"2025/10/placeholder-5.png\";s:8:\"filesize\";i:6146;s:5:\"sizes\";a:4:{s:6:\"medium\";a:5:{s:4:\"file\";s:25:\"placeholder-5-300x200.png\";s:5:\"width\";i:300;s:6:\"height\";i:200;s:9:\"mime-type\";s:9:\"image/png\";s:8:\"filesize\";i:1860;}s:5:\"large\";a:5:{s:4:\"file\";s:26:\"placeholder-5-1024x683.png\";s:5:\"width\";i:1024;s:6:\"height\";i:683;s:9:\"mime-type\";s:9:\"image/png\";s:8:\"filesize\";i:6951;}s:9:\"thumbnail\";a:5:{s:4:\"file\";s:25:\"placeholder-5-150x150.png\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:9:\"image/png\";s:8:\"filesize\";i:1117;}s:12:\"medium_large\";a:5:{s:4:\"file\";s:25:\"placeholder-5-768x512.png\";s:5:\"width\";i:768;s:6:\"height\";i:512;s:9:\"mime-type\";s:9:\"image/png\";s:8:\"filesize\";i:4970;}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}');
INSERT INTO `wp_79e54b1ec2_postmeta` VALUES ('875','177','_elementor_source_image_hash','85c2c77a28fed4891af0c79411c6ceb624f9dfe8');
INSERT INTO `wp_79e54b1ec2_postmeta` VALUES ('876','178','_wp_attached_file','2025/10/placeholder-6.png');
INSERT INTO `wp_79e54b1ec2_postmeta` VALUES ('877','178','_wp_attachment_metadata','a:6:{s:5:\"width\";i:1200;s:6:\"height\";i:800;s:4:\"file\";s:25:\"2025/10/placeholder-6.png\";s:8:\"filesize\";i:4425;s:5:\"sizes\";a:4:{s:6:\"medium\";a:5:{s:4:\"file\";s:25:\"placeholder-6-300x200.png\";s:5:\"width\";i:300;s:6:\"height\";i:200;s:9:\"mime-type\";s:9:\"image/png\";s:8:\"filesize\";i:1860;}s:5:\"large\";a:5:{s:4:\"file\";s:26:\"placeholder-6-1024x683.png\";s:5:\"width\";i:1024;s:6:\"height\";i:683;s:9:\"mime-type\";s:9:\"image/png\";s:8:\"filesize\";i:6951;}s:9:\"thumbnail\";a:5:{s:4:\"file\";s:25:\"placeholder-6-150x150.png\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:9:\"image/png\";s:8:\"filesize\";i:1117;}s:12:\"medium_large\";a:5:{s:4:\"file\";s:25:\"placeholder-6-768x512.png\";s:5:\"width\";i:768;s:6:\"height\";i:512;s:9:\"mime-type\";s:9:\"image/png\";s:8:\"filesize\";i:4970;}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}');
INSERT INTO `wp_79e54b1ec2_postmeta` VALUES ('878','178','_elementor_source_image_hash','85c2c77a28fed4891af0c79411c6ceb624f9dfe8');
INSERT INTO `wp_79e54b1ec2_postmeta` VALUES ('879','179','_wp_attached_file','2025/10/placeholder-7.png');
INSERT INTO `wp_79e54b1ec2_postmeta` VALUES ('880','179','_wp_attachment_metadata','a:6:{s:5:\"width\";i:1200;s:6:\"height\";i:800;s:4:\"file\";s:25:\"2025/10/placeholder-7.png\";s:8:\"filesize\";i:4425;s:5:\"sizes\";a:4:{s:6:\"medium\";a:5:{s:4:\"file\";s:25:\"placeholder-7-300x200.png\";s:5:\"width\";i:300;s:6:\"height\";i:200;s:9:\"mime-type\";s:9:\"image/png\";s:8:\"filesize\";i:1860;}s:5:\"large\";a:5:{s:4:\"file\";s:26:\"placeholder-7-1024x683.png\";s:5:\"width\";i:1024;s:6:\"height\";i:683;s:9:\"mime-type\";s:9:\"image/png\";s:8:\"filesize\";i:6951;}s:9:\"thumbnail\";a:5:{s:4:\"file\";s:25:\"placeholder-7-150x150.png\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:9:\"image/png\";s:8:\"filesize\";i:1117;}s:12:\"medium_large\";a:5:{s:4:\"file\";s:25:\"placeholder-7-768x512.png\";s:5:\"width\";i:768;s:6:\"height\";i:512;s:9:\"mime-type\";s:9:\"image/png\";s:8:\"filesize\";i:4970;}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}');
INSERT INTO `wp_79e54b1ec2_postmeta` VALUES ('881','179','_elementor_source_image_hash','85c2c77a28fed4891af0c79411c6ceb624f9dfe8');
INSERT INTO `wp_79e54b1ec2_postmeta` VALUES ('882','180','_wp_attached_file','2025/10/placeholder-8.png');
INSERT INTO `wp_79e54b1ec2_postmeta` VALUES ('883','180','_wp_attachment_metadata','a:6:{s:5:\"width\";i:1200;s:6:\"height\";i:800;s:4:\"file\";s:25:\"2025/10/placeholder-8.png\";s:8:\"filesize\";i:4425;s:5:\"sizes\";a:4:{s:6:\"medium\";a:5:{s:4:\"file\";s:25:\"placeholder-8-300x200.png\";s:5:\"width\";i:300;s:6:\"height\";i:200;s:9:\"mime-type\";s:9:\"image/png\";s:8:\"filesize\";i:1860;}s:5:\"large\";a:5:{s:4:\"file\";s:26:\"placeholder-8-1024x683.png\";s:5:\"width\";i:1024;s:6:\"height\";i:683;s:9:\"mime-type\";s:9:\"image/png\";s:8:\"filesize\";i:6951;}s:9:\"thumbnail\";a:5:{s:4:\"file\";s:25:\"placeholder-8-150x150.png\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:9:\"image/png\";s:8:\"filesize\";i:1117;}s:12:\"medium_large\";a:5:{s:4:\"file\";s:25:\"placeholder-8-768x512.png\";s:5:\"width\";i:768;s:6:\"height\";i:512;s:9:\"mime-type\";s:9:\"image/png\";s:8:\"filesize\";i:4970;}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}');
INSERT INTO `wp_79e54b1ec2_postmeta` VALUES ('884','180','_elementor_source_image_hash','85c2c77a28fed4891af0c79411c6ceb624f9dfe8');
INSERT INTO `wp_79e54b1ec2_postmeta` VALUES ('918','185','_wp_attached_file','2025/10/placeholder-9.png');
INSERT INTO `wp_79e54b1ec2_postmeta` VALUES ('919','185','_wp_attachment_metadata','a:6:{s:5:\"width\";i:1200;s:6:\"height\";i:800;s:4:\"file\";s:25:\"2025/10/placeholder-9.png\";s:8:\"filesize\";i:6146;s:5:\"sizes\";a:4:{s:6:\"medium\";a:5:{s:4:\"file\";s:25:\"placeholder-9-300x200.png\";s:5:\"width\";i:300;s:6:\"height\";i:200;s:9:\"mime-type\";s:9:\"image/png\";s:8:\"filesize\";i:1860;}s:5:\"large\";a:5:{s:4:\"file\";s:26:\"placeholder-9-1024x683.png\";s:5:\"width\";i:1024;s:6:\"height\";i:683;s:9:\"mime-type\";s:9:\"image/png\";s:8:\"filesize\";i:6951;}s:9:\"thumbnail\";a:5:{s:4:\"file\";s:25:\"placeholder-9-150x150.png\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:9:\"image/png\";s:8:\"filesize\";i:1117;}s:12:\"medium_large\";a:5:{s:4:\"file\";s:25:\"placeholder-9-768x512.png\";s:5:\"width\";i:768;s:6:\"height\";i:512;s:9:\"mime-type\";s:9:\"image/png\";s:8:\"filesize\";i:4970;}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}');
INSERT INTO `wp_79e54b1ec2_postmeta` VALUES ('920','185','_elementor_source_image_hash','85c2c77a28fed4891af0c79411c6ceb624f9dfe8');
INSERT INTO `wp_79e54b1ec2_postmeta` VALUES ('921','186','_wp_attached_file','2025/10/placeholder-10.png');
INSERT INTO `wp_79e54b1ec2_postmeta` VALUES ('922','186','_wp_attachment_metadata','a:6:{s:5:\"width\";i:1200;s:6:\"height\";i:800;s:4:\"file\";s:26:\"2025/10/placeholder-10.png\";s:8:\"filesize\";i:4425;s:5:\"sizes\";a:4:{s:6:\"medium\";a:5:{s:4:\"file\";s:26:\"placeholder-10-300x200.png\";s:5:\"width\";i:300;s:6:\"height\";i:200;s:9:\"mime-type\";s:9:\"image/png\";s:8:\"filesize\";i:1860;}s:5:\"large\";a:5:{s:4:\"file\";s:27:\"placeholder-10-1024x683.png\";s:5:\"width\";i:1024;s:6:\"height\";i:683;s:9:\"mime-type\";s:9:\"image/png\";s:8:\"filesize\";i:6951;}s:9:\"thumbnail\";a:5:{s:4:\"file\";s:26:\"placeholder-10-150x150.png\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:9:\"image/png\";s:8:\"filesize\";i:1117;}s:12:\"medium_large\";a:5:{s:4:\"file\";s:26:\"placeholder-10-768x512.png\";s:5:\"width\";i:768;s:6:\"height\";i:512;s:9:\"mime-type\";s:9:\"image/png\";s:8:\"filesize\";i:4970;}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}');
INSERT INTO `wp_79e54b1ec2_postmeta` VALUES ('923','186','_elementor_source_image_hash','85c2c77a28fed4891af0c79411c6ceb624f9dfe8');
INSERT INTO `wp_79e54b1ec2_postmeta` VALUES ('924','187','_wp_attached_file','2025/10/placeholder-11.png');
INSERT INTO `wp_79e54b1ec2_postmeta` VALUES ('925','187','_wp_attachment_metadata','a:6:{s:5:\"width\";i:1200;s:6:\"height\";i:800;s:4:\"file\";s:26:\"2025/10/placeholder-11.png\";s:8:\"filesize\";i:4425;s:5:\"sizes\";a:4:{s:6:\"medium\";a:5:{s:4:\"file\";s:26:\"placeholder-11-300x200.png\";s:5:\"width\";i:300;s:6:\"height\";i:200;s:9:\"mime-type\";s:9:\"image/png\";s:8:\"filesize\";i:1860;}s:5:\"large\";a:5:{s:4:\"file\";s:27:\"placeholder-11-1024x683.png\";s:5:\"width\";i:1024;s:6:\"height\";i:683;s:9:\"mime-type\";s:9:\"image/png\";s:8:\"filesize\";i:6951;}s:9:\"thumbnail\";a:5:{s:4:\"file\";s:26:\"placeholder-11-150x150.png\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:9:\"image/png\";s:8:\"filesize\";i:1117;}s:12:\"medium_large\";a:5:{s:4:\"file\";s:26:\"placeholder-11-768x512.png\";s:5:\"width\";i:768;s:6:\"height\";i:512;s:9:\"mime-type\";s:9:\"image/png\";s:8:\"filesize\";i:4970;}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}');
INSERT INTO `wp_79e54b1ec2_postmeta` VALUES ('926','187','_elementor_source_image_hash','85c2c77a28fed4891af0c79411c6ceb624f9dfe8');
INSERT INTO `wp_79e54b1ec2_postmeta` VALUES ('927','188','_wp_attached_file','2025/10/placeholder-12.png');
INSERT INTO `wp_79e54b1ec2_postmeta` VALUES ('928','188','_wp_attachment_metadata','a:6:{s:5:\"width\";i:1200;s:6:\"height\";i:800;s:4:\"file\";s:26:\"2025/10/placeholder-12.png\";s:8:\"filesize\";i:4425;s:5:\"sizes\";a:4:{s:6:\"medium\";a:5:{s:4:\"file\";s:26:\"placeholder-12-300x200.png\";s:5:\"width\";i:300;s:6:\"height\";i:200;s:9:\"mime-type\";s:9:\"image/png\";s:8:\"filesize\";i:1860;}s:5:\"large\";a:5:{s:4:\"file\";s:27:\"placeholder-12-1024x683.png\";s:5:\"width\";i:1024;s:6:\"height\";i:683;s:9:\"mime-type\";s:9:\"image/png\";s:8:\"filesize\";i:6951;}s:9:\"thumbnail\";a:5:{s:4:\"file\";s:26:\"placeholder-12-150x150.png\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:9:\"image/png\";s:8:\"filesize\";i:1117;}s:12:\"medium_large\";a:5:{s:4:\"file\";s:26:\"placeholder-12-768x512.png\";s:5:\"width\";i:768;s:6:\"height\";i:512;s:9:\"mime-type\";s:9:\"image/png\";s:8:\"filesize\";i:4970;}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}');
INSERT INTO `wp_79e54b1ec2_postmeta` VALUES ('929','188','_elementor_source_image_hash','85c2c77a28fed4891af0c79411c6ceb624f9dfe8');
INSERT INTO `wp_79e54b1ec2_postmeta` VALUES ('958','193','_elementor_edit_mode','builder');
INSERT INTO `wp_79e54b1ec2_postmeta` VALUES ('959','193','_elementor_template_type','kit');
INSERT INTO `wp_79e54b1ec2_postmeta` VALUES ('960','193','_elementor_version','3.32.5');
INSERT INTO `wp_79e54b1ec2_postmeta` VALUES ('961','193','_elementor_pro_version','3.11.2');
INSERT INTO `wp_79e54b1ec2_postmeta` VALUES ('962','194','_elementor_edit_mode','builder');
INSERT INTO `wp_79e54b1ec2_postmeta` VALUES ('963','194','_elementor_template_type','kit');
INSERT INTO `wp_79e54b1ec2_postmeta` VALUES ('964','194','_elementor_version','3.32.5');
INSERT INTO `wp_79e54b1ec2_postmeta` VALUES ('965','194','_elementor_pro_version','3.11.2');
INSERT INTO `wp_79e54b1ec2_postmeta` VALUES ('966','193','_wp_page_template','default');
INSERT INTO `wp_79e54b1ec2_postmeta` VALUES ('967','193','_elementor_page_settings','a:157:{s:13:\"system_colors\";a:4:{i:0;a:3:{s:3:\"_id\";s:9:\"secondary\";s:5:\"title\";s:7:\"Heading\";s:5:\"color\";s:7:\"#F8F8F8\";}i:1;a:3:{s:3:\"_id\";s:7:\"primary\";s:5:\"title\";s:10:\"Basic Text\";s:5:\"color\";s:7:\"#AEB0B2\";}i:2;a:3:{s:3:\"_id\";s:4:\"text\";s:5:\"title\";s:6:\"Netral\";s:5:\"color\";s:7:\"#FFFFFF\";}i:3;a:3:{s:3:\"_id\";s:6:\"accent\";s:5:\"title\";s:15:\"Transparent 20%\";s:5:\"color\";s:9:\"#FFFFFF2B\";}}s:13:\"custom_colors\";a:12:{i:0;a:3:{s:3:\"_id\";s:7:\"d49ac81\";s:5:\"title\";s:6:\"Button\";s:5:\"color\";s:7:\"#004483\";}i:1;a:3:{s:3:\"_id\";s:7:\"332724a\";s:5:\"title\";s:12:\"Button Hover\";s:5:\"color\";s:7:\"#E69900\";}i:2;a:3:{s:3:\"_id\";s:7:\"4d462f5\";s:5:\"title\";s:10:\"Line Color\";s:5:\"color\";s:7:\"#414F62\";}i:3;a:3:{s:3:\"_id\";s:7:\"cfa1f76\";s:5:\"title\";s:16:\"Light Background\";s:5:\"color\";s:7:\"#001F3D\";}i:4;a:3:{s:3:\"_id\";s:7:\"7fbea4f\";s:5:\"title\";s:22:\"Extra Light Background\";s:5:\"color\";s:7:\"#002A52\";}i:5;a:3:{s:3:\"_id\";s:7:\"044b931\";s:5:\"title\";s:15:\"Dark Background\";s:5:\"color\";s:7:\"#001429\";}i:6;a:3:{s:3:\"_id\";s:7:\"638d055\";s:5:\"title\";s:21:\"Extra Dark Background\";s:5:\"color\";s:7:\"#000814\";}i:7;a:3:{s:3:\"_id\";s:7:\"ec3c7a7\";s:5:\"title\";s:8:\"Accent 1\";s:5:\"color\";s:7:\"#004483\";}i:8;a:3:{s:3:\"_id\";s:7:\"3ee16e7\";s:5:\"title\";s:8:\"Accent 2\";s:5:\"color\";s:7:\"#E69900\";}i:9;a:3:{s:3:\"_id\";s:7:\"c5a94f6\";s:5:\"title\";s:8:\"Accent 3\";s:5:\"color\";s:7:\"#FFAD0A\";}i:10;a:3:{s:3:\"_id\";s:7:\"e5616b2\";s:5:\"title\";s:8:\"Accent 4\";s:5:\"color\";s:7:\"#AD7505\";}i:11;a:3:{s:3:\"_id\";s:7:\"5c3d4b5\";s:5:\"title\";s:8:\"Accent 5\";s:5:\"color\";s:7:\"#231A05\";}}s:17:\"system_typography\";a:4:{i:0;a:9:{s:3:\"_id\";s:7:\"primary\";s:5:\"title\";s:7:\"Primary\";s:21:\"typography_typography\";s:6:\"custom\";s:22:\"typography_font_family\";s:5:\"Exo 2\";s:22:\"typography_font_weight\";s:3:\"600\";s:20:\"typography_font_size\";a:3:{s:4:\"unit\";s:2:\"px\";s:4:\"size\";i:48;s:5:\"sizes\";a:0:{}}s:22:\"typography_line_height\";a:3:{s:4:\"unit\";s:2:\"em\";s:4:\"size\";d:1.2;s:5:\"sizes\";a:0:{}}s:27:\"typography_font_size_tablet\";a:3:{s:4:\"unit\";s:2:\"px\";s:4:\"size\";i:37;s:5:\"sizes\";a:0:{}}s:27:\"typography_font_size_mobile\";a:3:{s:4:\"unit\";s:2:\"px\";s:4:\"size\";i:30;s:5:\"sizes\";a:0:{}}}i:1;a:10:{s:3:\"_id\";s:9:\"secondary\";s:5:\"title\";s:9:\"Secondary\";s:21:\"typography_typography\";s:6:\"custom\";s:22:\"typography_font_family\";s:5:\"Exo 2\";s:22:\"typography_font_weight\";s:3:\"600\";s:20:\"typography_font_size\";a:3:{s:4:\"unit\";s:2:\"px\";s:4:\"size\";i:39;s:5:\"sizes\";a:0:{}}s:22:\"typography_line_height\";a:3:{s:4:\"unit\";s:2:\"em\";s:4:\"size\";d:1.2;s:5:\"sizes\";a:0:{}}s:27:\"typography_font_size_tablet\";a:3:{s:4:\"unit\";s:2:\"px\";s:4:\"size\";i:31;s:5:\"sizes\";a:0:{}}s:27:\"typography_font_size_mobile\";a:3:{s:4:\"unit\";s:2:\"px\";s:4:\"size\";i:24;s:5:\"sizes\";a:0:{}}s:25:\"typography_letter_spacing\";a:3:{s:4:\"unit\";s:2:\"px\";s:4:\"size\";d:-0.5;s:5:\"sizes\";a:0:{}}}i:2;a:9:{s:3:\"_id\";s:4:\"text\";s:5:\"title\";s:4:\"Text\";s:21:\"typography_typography\";s:6:\"custom\";s:22:\"typography_font_family\";s:5:\"Inter\";s:22:\"typography_font_weight\";s:3:\"400\";s:20:\"typography_font_size\";a:3:{s:4:\"unit\";s:2:\"px\";s:4:\"size\";i:16;s:5:\"sizes\";a:0:{}}s:22:\"typography_line_height\";a:3:{s:4:\"unit\";s:2:\"em\";s:4:\"size\";d:1.4;s:5:\"sizes\";a:0:{}}s:27:\"typography_font_size_tablet\";a:3:{s:4:\"unit\";s:2:\"px\";s:4:\"size\";i:15;s:5:\"sizes\";a:0:{}}s:27:\"typography_font_size_mobile\";a:3:{s:4:\"unit\";s:2:\"px\";s:4:\"size\";i:14;s:5:\"sizes\";a:0:{}}}i:3;a:11:{s:3:\"_id\";s:6:\"accent\";s:5:\"title\";s:6:\"Accent\";s:21:\"typography_typography\";s:6:\"custom\";s:22:\"typography_font_family\";s:5:\"Exo 2\";s:22:\"typography_font_weight\";s:3:\"600\";s:20:\"typography_font_size\";a:3:{s:4:\"unit\";s:2:\"px\";s:4:\"size\";i:14;s:5:\"sizes\";a:0:{}}s:22:\"typography_line_height\";a:3:{s:4:\"unit\";s:2:\"em\";s:4:\"size\";i:1;s:5:\"sizes\";a:0:{}}s:27:\"typography_font_size_tablet\";a:3:{s:4:\"unit\";s:2:\"px\";s:4:\"size\";i:13;s:5:\"sizes\";a:0:{}}s:27:\"typography_font_size_mobile\";a:3:{s:4:\"unit\";s:2:\"px\";s:4:\"size\";i:12;s:5:\"sizes\";a:0:{}}s:25:\"typography_letter_spacing\";a:3:{s:4:\"unit\";s:2:\"px\";s:4:\"size\";i:0;s:5:\"sizes\";a:0:{}}s:25:\"typography_text_transform\";s:9:\"uppercase\";}}s:17:\"custom_typography\";a:11:{i:0;a:11:{s:3:\"_id\";s:7:\"b2ce6af\";s:5:\"title\";s:11:\"Global Font\";s:21:\"typography_typography\";s:6:\"custom\";s:22:\"typography_font_family\";s:5:\"Inter\";s:20:\"typography_font_size\";a:3:{s:4:\"unit\";s:2:\"px\";s:4:\"size\";i:16;s:5:\"sizes\";a:0:{}}s:22:\"typography_line_height\";a:3:{s:4:\"unit\";s:2:\"em\";s:4:\"size\";d:1.4;s:5:\"sizes\";a:0:{}}s:27:\"typography_font_size_tablet\";a:3:{s:4:\"unit\";s:2:\"px\";s:4:\"size\";i:15;s:5:\"sizes\";a:0:{}}s:27:\"typography_font_size_mobile\";a:3:{s:4:\"unit\";s:2:\"px\";s:4:\"size\";i:14;s:5:\"sizes\";a:0:{}}s:22:\"typography_font_weight\";s:3:\"400\";s:25:\"typography_text_transform\";s:4:\"none\";s:21:\"typography_font_style\";s:6:\"normal\";}i:1;a:9:{s:3:\"_id\";s:7:\"69c152f\";s:5:\"title\";s:10:\"Small Font\";s:21:\"typography_typography\";s:6:\"custom\";s:22:\"typography_font_family\";s:5:\"Inter\";s:20:\"typography_font_size\";a:3:{s:4:\"unit\";s:2:\"px\";s:4:\"size\";i:14;s:5:\"sizes\";a:0:{}}s:22:\"typography_line_height\";a:3:{s:4:\"unit\";s:2:\"em\";s:4:\"size\";d:1.4;s:5:\"sizes\";a:0:{}}s:27:\"typography_font_size_tablet\";a:3:{s:4:\"unit\";s:2:\"px\";s:4:\"size\";i:13;s:5:\"sizes\";a:0:{}}s:27:\"typography_font_size_mobile\";a:3:{s:4:\"unit\";s:2:\"px\";s:4:\"size\";i:12;s:5:\"sizes\";a:0:{}}s:22:\"typography_font_weight\";s:3:\"400\";}i:2;a:9:{s:3:\"_id\";s:7:\"520c191\";s:5:\"title\";s:6:\"Header\";s:21:\"typography_typography\";s:6:\"custom\";s:22:\"typography_font_family\";s:5:\"Exo 2\";s:20:\"typography_font_size\";a:3:{s:4:\"unit\";s:2:\"px\";s:4:\"size\";i:18;s:5:\"sizes\";a:0:{}}s:22:\"typography_font_weight\";s:3:\"600\";s:27:\"typography_font_size_mobile\";a:3:{s:4:\"unit\";s:2:\"px\";s:4:\"size\";i:16;s:5:\"sizes\";a:0:{}}s:27:\"typography_font_size_tablet\";a:3:{s:4:\"unit\";s:2:\"px\";s:4:\"size\";i:17;s:5:\"sizes\";a:0:{}}s:22:\"typography_line_height\";a:3:{s:4:\"unit\";s:2:\"em\";s:4:\"size\";d:1.5;s:5:\"sizes\";a:0:{}}}i:3;a:9:{s:3:\"_id\";s:7:\"583e54c\";s:5:\"title\";s:2:\"H1\";s:21:\"typography_typography\";s:6:\"custom\";s:22:\"typography_font_family\";s:5:\"Exo 2\";s:20:\"typography_font_size\";a:3:{s:4:\"unit\";s:2:\"px\";s:4:\"size\";i:48;s:5:\"sizes\";a:0:{}}s:22:\"typography_font_weight\";s:3:\"600\";s:22:\"typography_line_height\";a:3:{s:4:\"unit\";s:2:\"em\";s:4:\"size\";d:1.2;s:5:\"sizes\";a:0:{}}s:27:\"typography_font_size_tablet\";a:3:{s:4:\"unit\";s:2:\"px\";s:4:\"size\";i:37;s:5:\"sizes\";a:0:{}}s:27:\"typography_font_size_mobile\";a:3:{s:4:\"unit\";s:2:\"px\";s:4:\"size\";i:30;s:5:\"sizes\";a:0:{}}}i:4;a:9:{s:3:\"_id\";s:7:\"5d167aa\";s:5:\"title\";s:2:\"H2\";s:21:\"typography_typography\";s:6:\"custom\";s:22:\"typography_font_family\";s:5:\"Exo 2\";s:20:\"typography_font_size\";a:3:{s:4:\"unit\";s:2:\"px\";s:4:\"size\";i:39;s:5:\"sizes\";a:0:{}}s:22:\"typography_font_weight\";s:3:\"600\";s:22:\"typography_line_height\";a:3:{s:4:\"unit\";s:2:\"em\";s:4:\"size\";d:1.2;s:5:\"sizes\";a:0:{}}s:27:\"typography_font_size_tablet\";a:3:{s:4:\"unit\";s:2:\"px\";s:4:\"size\";i:31;s:5:\"sizes\";a:0:{}}s:27:\"typography_font_size_mobile\";a:3:{s:4:\"unit\";s:2:\"px\";s:4:\"size\";i:24;s:5:\"sizes\";a:0:{}}}i:5;a:10:{s:3:\"_id\";s:7:\"d3dae9a\";s:5:\"title\";s:2:\"H3\";s:21:\"typography_typography\";s:6:\"custom\";s:22:\"typography_font_family\";s:5:\"Exo 2\";s:20:\"typography_font_size\";a:3:{s:4:\"unit\";s:2:\"px\";s:4:\"size\";i:31;s:5:\"sizes\";a:0:{}}s:22:\"typography_font_weight\";s:3:\"600\";s:22:\"typography_line_height\";a:3:{s:4:\"unit\";s:2:\"em\";s:4:\"size\";d:1.3;s:5:\"sizes\";a:0:{}}s:27:\"typography_font_size_tablet\";a:3:{s:4:\"unit\";s:2:\"px\";s:4:\"size\";i:25;s:5:\"sizes\";a:0:{}}s:27:\"typography_font_size_mobile\";a:3:{s:4:\"unit\";s:2:\"px\";s:4:\"size\";i:20;s:5:\"sizes\";a:0:{}}s:21:\"typography_font_style\";s:6:\"normal\";}i:6;a:11:{s:3:\"_id\";s:7:\"83682a1\";s:5:\"title\";s:2:\"H4\";s:21:\"typography_typography\";s:6:\"custom\";s:22:\"typography_font_family\";s:5:\"Exo 2\";s:20:\"typography_font_size\";a:3:{s:4:\"unit\";s:2:\"px\";s:4:\"size\";i:25;s:5:\"sizes\";a:0:{}}s:22:\"typography_font_weight\";s:3:\"300\";s:22:\"typography_line_height\";a:3:{s:4:\"unit\";s:2:\"em\";s:4:\"size\";d:1.3;s:5:\"sizes\";a:0:{}}s:27:\"typography_font_size_tablet\";a:3:{s:4:\"unit\";s:2:\"px\";s:4:\"size\";i:21;s:5:\"sizes\";a:0:{}}s:27:\"typography_font_size_mobile\";a:3:{s:4:\"unit\";s:2:\"px\";s:4:\"size\";i:18;s:5:\"sizes\";a:0:{}}s:25:\"typography_text_transform\";s:4:\"none\";s:21:\"typography_font_style\";s:6:\"normal\";}i:7;a:9:{s:3:\"_id\";s:7:\"7044a64\";s:5:\"title\";s:2:\"H5\";s:21:\"typography_typography\";s:6:\"custom\";s:22:\"typography_font_family\";s:5:\"Exo 2\";s:20:\"typography_font_size\";a:3:{s:4:\"unit\";s:2:\"px\";s:4:\"size\";i:20;s:5:\"sizes\";a:0:{}}s:22:\"typography_font_weight\";s:3:\"600\";s:22:\"typography_line_height\";a:3:{s:4:\"unit\";s:2:\"em\";s:4:\"size\";d:1.4;s:5:\"sizes\";a:0:{}}s:27:\"typography_font_size_tablet\";a:3:{s:4:\"unit\";s:2:\"px\";s:4:\"size\";i:18;s:5:\"sizes\";a:0:{}}s:27:\"typography_font_size_mobile\";a:3:{s:4:\"unit\";s:2:\"px\";s:4:\"size\";i:16;s:5:\"sizes\";a:0:{}}}i:8;a:10:{s:3:\"_id\";s:7:\"84ca66e\";s:5:\"title\";s:2:\"H6\";s:21:\"typography_typography\";s:6:\"custom\";s:22:\"typography_font_family\";s:5:\"Exo 2\";s:20:\"typography_font_size\";a:3:{s:4:\"unit\";s:2:\"px\";s:4:\"size\";i:16;s:5:\"sizes\";a:0:{}}s:22:\"typography_font_weight\";s:3:\"400\";s:22:\"typography_line_height\";a:3:{s:4:\"unit\";s:2:\"em\";s:4:\"size\";s:0:\"\";s:5:\"sizes\";a:0:{}}s:27:\"typography_font_size_tablet\";a:3:{s:4:\"unit\";s:2:\"px\";s:4:\"size\";i:15;s:5:\"sizes\";a:0:{}}s:27:\"typography_font_size_mobile\";a:3:{s:4:\"unit\";s:2:\"px\";s:4:\"size\";i:14;s:5:\"sizes\";a:0:{}}s:25:\"typography_text_transform\";s:9:\"uppercase\";}i:9;a:9:{s:3:\"_id\";s:7:\"112b6c4\";s:5:\"title\";s:6:\"Footer\";s:21:\"typography_typography\";s:6:\"custom\";s:22:\"typography_font_family\";s:5:\"Inter\";s:20:\"typography_font_size\";a:3:{s:4:\"unit\";s:2:\"px\";s:4:\"size\";i:13;s:5:\"sizes\";a:0:{}}s:22:\"typography_font_weight\";s:3:\"500\";s:27:\"typography_font_size_tablet\";a:3:{s:4:\"unit\";s:2:\"px\";s:4:\"size\";i:12;s:5:\"sizes\";a:0:{}}s:27:\"typography_font_size_mobile\";a:3:{s:4:\"unit\";s:2:\"px\";s:4:\"size\";i:11;s:5:\"sizes\";a:0:{}}s:22:\"typography_line_height\";a:3:{s:4:\"unit\";s:2:\"em\";s:4:\"size\";d:1.5;s:5:\"sizes\";a:0:{}}}i:10;a:9:{s:3:\"_id\";s:7:\"a435f28\";s:5:\"title\";s:8:\"Big Hero\";s:21:\"typography_typography\";s:6:\"custom\";s:22:\"typography_font_family\";s:5:\"Exo 2\";s:20:\"typography_font_size\";a:3:{s:4:\"unit\";s:2:\"px\";s:4:\"size\";i:61;s:5:\"sizes\";a:0:{}}s:27:\"typography_font_size_tablet\";a:3:{s:4:\"unit\";s:2:\"px\";s:4:\"size\";i:44;s:5:\"sizes\";a:0:{}}s:27:\"typography_font_size_mobile\";a:3:{s:4:\"unit\";s:2:\"px\";s:4:\"size\";i:32;s:5:\"sizes\";a:0:{}}s:22:\"typography_font_weight\";s:3:\"700\";s:22:\"typography_line_height\";a:3:{s:4:\"unit\";s:2:\"em\";s:4:\"size\";i:1;s:5:\"sizes\";a:0:{}}}}s:21:\"default_generic_fonts\";s:10:\"Sans-serif\";s:20:\"button_border_border\";s:5:\"solid\";s:19:\"button_border_width\";a:6:{s:4:\"unit\";s:2:\"px\";s:3:\"top\";s:1:\"1\";s:5:\"right\";s:1:\"1\";s:6:\"bottom\";s:1:\"1\";s:4:\"left\";s:1:\"1\";s:8:\"isLinked\";b:1;}s:20:\"button_border_radius\";a:6:{s:4:\"unit\";s:2:\"px\";s:3:\"top\";s:2:\"14\";s:5:\"right\";s:2:\"14\";s:6:\"bottom\";s:2:\"14\";s:4:\"left\";s:2:\"14\";s:8:\"isLinked\";b:1;}s:26:\"button_hover_border_border\";s:5:\"solid\";s:25:\"button_hover_border_width\";a:6:{s:4:\"unit\";s:2:\"px\";s:3:\"top\";s:1:\"1\";s:5:\"right\";s:1:\"1\";s:6:\"bottom\";s:1:\"1\";s:4:\"left\";s:1:\"1\";s:8:\"isLinked\";b:1;}s:24:\"form_field_border_border\";s:5:\"solid\";s:23:\"form_field_border_width\";a:6:{s:4:\"unit\";s:2:\"px\";s:3:\"top\";s:1:\"1\";s:5:\"right\";s:1:\"1\";s:6:\"bottom\";s:1:\"1\";s:4:\"left\";s:1:\"1\";s:8:\"isLinked\";b:1;}s:24:\"form_field_border_radius\";a:6:{s:4:\"unit\";s:2:\"px\";s:3:\"top\";s:2:\"14\";s:5:\"right\";s:2:\"14\";s:6:\"bottom\";s:2:\"14\";s:4:\"left\";s:2:\"14\";s:8:\"isLinked\";b:1;}s:30:\"form_field_focus_border_border\";s:5:\"solid\";s:29:\"form_field_focus_border_width\";a:6:{s:4:\"unit\";s:2:\"px\";s:3:\"top\";s:1:\"1\";s:5:\"right\";s:1:\"1\";s:6:\"bottom\";s:1:\"1\";s:4:\"left\";s:1:\"1\";s:8:\"isLinked\";b:1;}s:19:\"page_title_selector\";s:14:\"h1.entry-title\";s:27:\"hello_footer_copyright_text\";s:19:\"All rights reserved\";s:15:\"activeItemIndex\";i:1;s:11:\"__globals__\";a:35:{s:27:\"form_field_background_color\";s:25:\"globals/colors?id=044b931\";s:23:\"form_field_border_color\";s:0:\"\";s:33:\"form_field_focus_background_color\";s:25:\"globals/colors?id=cfa1f76\";s:29:\"form_field_focus_border_color\";s:0:\"\";s:21:\"form_field_text_color\";s:27:\"globals/colors?id=secondary\";s:27:\"form_field_focus_text_color\";s:25:\"globals/colors?id=primary\";s:17:\"button_text_color\";s:22:\"globals/colors?id=text\";s:23:\"button_background_color\";s:25:\"globals/colors?id=d49ac81\";s:23:\"button_hover_text_color\";s:22:\"globals/colors?id=text\";s:29:\"button_hover_background_color\";s:25:\"globals/colors?id=332724a\";s:26:\"body_typography_typography\";s:29:\"globals/typography?id=b2ce6af\";s:10:\"body_color\";s:25:\"globals/colors?id=primary\";s:17:\"link_normal_color\";s:25:\"globals/colors?id=primary\";s:16:\"link_hover_color\";s:25:\"globals/colors?id=332724a\";s:24:\"h1_typography_typography\";s:29:\"globals/typography?id=583e54c\";s:24:\"h2_typography_typography\";s:29:\"globals/typography?id=5d167aa\";s:24:\"h3_typography_typography\";s:29:\"globals/typography?id=d3dae9a\";s:24:\"h4_typography_typography\";s:29:\"globals/typography?id=83682a1\";s:24:\"h5_typography_typography\";s:29:\"globals/typography?id=7044a64\";s:24:\"h6_typography_typography\";s:29:\"globals/typography?id=84ca66e\";s:8:\"h6_color\";s:25:\"globals/colors?id=c5a94f6\";s:19:\"button_border_color\";s:25:\"globals/colors?id=d49ac81\";s:25:\"button_hover_border_color\";s:25:\"globals/colors?id=332724a\";s:8:\"h1_color\";s:27:\"globals/colors?id=secondary\";s:8:\"h2_color\";s:27:\"globals/colors?id=secondary\";s:8:\"h3_color\";s:27:\"globals/colors?id=secondary\";s:8:\"h4_color\";s:27:\"globals/colors?id=secondary\";s:8:\"h5_color\";s:27:\"globals/colors?id=secondary\";s:16:\"form_label_color\";s:27:\"globals/colors?id=secondary\";s:25:\"button_background_color_b\";s:25:\"globals/colors?id=332724a\";s:31:\"button_hover_background_color_b\";s:25:\"globals/colors?id=d49ac81\";s:32:\"form_label_typography_typography\";s:29:\"globals/typography?id=520c191\";s:32:\"form_field_typography_typography\";s:29:\"globals/typography?id=b2ce6af\";s:28:\"button_typography_typography\";s:28:\"globals/typography?id=accent\";s:21:\"body_background_color\";s:25:\"globals/colors?id=638d055\";}s:11:\"viewport_md\";i:768;s:11:\"viewport_lg\";i:1025;s:15:\"container_width\";a:3:{s:4:\"unit\";s:2:\"px\";s:4:\"size\";i:1280;s:5:\"sizes\";a:0:{}}s:24:\"h1_typography_typography\";s:6:\"custom\";s:25:\"h1_typography_font_family\";s:5:\"Exo 2\";s:23:\"h1_typography_font_size\";a:3:{s:4:\"unit\";s:2:\"px\";s:4:\"size\";i:48;s:5:\"sizes\";a:0:{}}s:25:\"h1_typography_font_weight\";s:3:\"600\";s:25:\"h1_typography_line_height\";a:3:{s:4:\"unit\";s:2:\"em\";s:4:\"size\";d:1.2;s:5:\"sizes\";a:0:{}}s:24:\"h2_typography_typography\";s:6:\"custom\";s:25:\"h2_typography_font_family\";s:5:\"Exo 2\";s:23:\"h2_typography_font_size\";a:3:{s:4:\"unit\";s:2:\"px\";s:4:\"size\";i:39;s:5:\"sizes\";a:0:{}}s:25:\"h2_typography_font_weight\";s:3:\"600\";s:25:\"h2_typography_line_height\";a:3:{s:4:\"unit\";s:2:\"em\";s:4:\"size\";d:1.2;s:5:\"sizes\";a:0:{}}s:24:\"h3_typography_typography\";s:6:\"custom\";s:25:\"h3_typography_font_family\";s:5:\"Exo 2\";s:23:\"h3_typography_font_size\";a:3:{s:4:\"unit\";s:2:\"px\";s:4:\"size\";i:31;s:5:\"sizes\";a:0:{}}s:25:\"h3_typography_font_weight\";s:3:\"600\";s:25:\"h3_typography_line_height\";a:3:{s:4:\"unit\";s:2:\"em\";s:4:\"size\";d:1.3;s:5:\"sizes\";a:0:{}}s:24:\"h4_typography_typography\";s:6:\"custom\";s:25:\"h4_typography_font_family\";s:5:\"Exo 2\";s:23:\"h4_typography_font_size\";a:3:{s:4:\"unit\";s:2:\"px\";s:4:\"size\";i:25;s:5:\"sizes\";a:0:{}}s:25:\"h4_typography_font_weight\";s:3:\"300\";s:25:\"h4_typography_line_height\";a:3:{s:4:\"unit\";s:2:\"em\";s:4:\"size\";d:1.3;s:5:\"sizes\";a:0:{}}s:24:\"h5_typography_typography\";s:6:\"custom\";s:25:\"h5_typography_font_family\";s:5:\"Exo 2\";s:23:\"h5_typography_font_size\";a:3:{s:4:\"unit\";s:2:\"px\";s:4:\"size\";i:20;s:5:\"sizes\";a:0:{}}s:25:\"h5_typography_font_weight\";s:3:\"600\";s:25:\"h5_typography_line_height\";a:3:{s:4:\"unit\";s:2:\"em\";s:4:\"size\";d:1.4;s:5:\"sizes\";a:0:{}}s:24:\"h6_typography_typography\";s:6:\"custom\";s:25:\"h6_typography_font_family\";s:5:\"Exo 2\";s:23:\"h6_typography_font_size\";a:3:{s:4:\"unit\";s:2:\"px\";s:4:\"size\";i:16;s:5:\"sizes\";a:0:{}}s:25:\"h6_typography_font_weight\";s:3:\"400\";s:25:\"h6_typography_line_height\";a:3:{s:4:\"unit\";s:2:\"em\";s:4:\"size\";s:0:\"\";s:5:\"sizes\";a:0:{}}s:21:\"form_field_text_color\";s:7:\"#F8F8F8\";s:27:\"form_field_focus_text_color\";s:7:\"#AEB0B2\";s:30:\"h1_typography_font_size_tablet\";a:3:{s:4:\"unit\";s:2:\"px\";s:4:\"size\";i:37;s:5:\"sizes\";a:0:{}}s:30:\"h1_typography_font_size_mobile\";a:3:{s:4:\"unit\";s:2:\"px\";s:4:\"size\";i:30;s:5:\"sizes\";a:0:{}}s:30:\"h2_typography_font_size_tablet\";a:3:{s:4:\"unit\";s:2:\"px\";s:4:\"size\";i:31;s:5:\"sizes\";a:0:{}}s:30:\"h2_typography_font_size_mobile\";a:3:{s:4:\"unit\";s:2:\"px\";s:4:\"size\";i:24;s:5:\"sizes\";a:0:{}}s:30:\"h3_typography_font_size_tablet\";a:3:{s:4:\"unit\";s:2:\"px\";s:4:\"size\";i:25;s:5:\"sizes\";a:0:{}}s:30:\"h3_typography_font_size_mobile\";a:3:{s:4:\"unit\";s:2:\"px\";s:4:\"size\";i:20;s:5:\"sizes\";a:0:{}}s:30:\"h4_typography_font_size_tablet\";a:3:{s:4:\"unit\";s:2:\"px\";s:4:\"size\";i:21;s:5:\"sizes\";a:0:{}}s:30:\"h4_typography_font_size_mobile\";a:3:{s:4:\"unit\";s:2:\"px\";s:4:\"size\";i:18;s:5:\"sizes\";a:0:{}}s:30:\"h5_typography_font_size_tablet\";a:3:{s:4:\"unit\";s:2:\"px\";s:4:\"size\";i:18;s:5:\"sizes\";a:0:{}}s:30:\"h5_typography_font_size_mobile\";a:3:{s:4:\"unit\";s:2:\"px\";s:4:\"size\";i:16;s:5:\"sizes\";a:0:{}}s:30:\"h6_typography_font_size_tablet\";a:3:{s:4:\"unit\";s:2:\"px\";s:4:\"size\";i:15;s:5:\"sizes\";a:0:{}}s:30:\"h6_typography_font_size_mobile\";a:3:{s:4:\"unit\";s:2:\"px\";s:4:\"size\";i:14;s:5:\"sizes\";a:0:{}}s:32:\"form_field_box_shadow_box_shadow\";a:5:{s:10:\"horizontal\";i:0;s:8:\"vertical\";i:0;s:4:\"blur\";i:1;s:6:\"spread\";i:1;s:5:\"color\";s:18:\"rgba(0, 0, 0, 0.1)\";}s:29:\"woocommerce_myaccount_page_id\";i:9;s:24:\"woocommerce_cart_page_id\";i:7;s:28:\"woocommerce_checkout_page_id\";i:8;s:26:\"body_background_background\";s:7:\"classic\";s:10:\"body_color\";s:7:\"#AEB0B2\";s:17:\"link_normal_color\";s:7:\"#AEB0B2\";s:8:\"h1_color\";s:7:\"#F8F8F8\";s:8:\"h2_color\";s:7:\"#F8F8F8\";s:8:\"h3_color\";s:7:\"#F8F8F8\";s:24:\"h3_typography_font_style\";s:6:\"normal\";s:8:\"h4_color\";s:7:\"#F8F8F8\";s:28:\"h4_typography_text_transform\";s:4:\"none\";s:24:\"h4_typography_font_style\";s:6:\"normal\";s:8:\"h5_color\";s:7:\"#F8F8F8\";s:28:\"h6_typography_text_transform\";s:9:\"uppercase\";s:17:\"button_text_color\";s:7:\"#FFFFFF\";s:23:\"button_hover_text_color\";s:7:\"#FFFFFF\";s:16:\"form_label_color\";s:7:\"#F8F8F8\";s:21:\"body_background_image\";a:5:{s:3:\"url\";s:0:\"\";s:2:\"id\";s:0:\"\";s:4:\"size\";s:0:\"\";s:3:\"alt\";s:0:\"\";s:6:\"source\";s:7:\"library\";}s:24:\"body_background_position\";s:13:\"center center\";s:22:\"body_background_repeat\";s:8:\"repeat-y\";s:27:\"body_background_size_tablet\";s:7:\"initial\";s:31:\"body_background_bg_width_tablet\";a:3:{s:4:\"unit\";s:1:\"%\";s:4:\"size\";i:0;s:5:\"sizes\";a:0:{}}s:31:\"body_background_bg_width_mobile\";a:3:{s:4:\"unit\";s:1:\"%\";s:4:\"size\";i:0;s:5:\"sizes\";a:0:{}}s:27:\"body_background_size_mobile\";s:7:\"initial\";s:37:\"link_hover_typography_text_decoration\";s:9:\"underline\";s:18:\"form_field_padding\";a:6:{s:4:\"unit\";s:2:\"em\";s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";s:8:\"isLinked\";b:1;}s:28:\"button_box_shadow_box_shadow\";a:5:{s:10:\"horizontal\";i:-30;s:8:\"vertical\";i:0;s:4:\"blur\";i:25;s:6:\"spread\";i:-10;s:5:\"color\";s:7:\"#6B9FF5\";}s:28:\"h2_typography_letter_spacing\";a:3:{s:4:\"unit\";s:2:\"px\";s:4:\"size\";d:-0.5;s:5:\"sizes\";a:0:{}}s:19:\"button_border_color\";s:7:\"#004483\";s:31:\"button_hover_background_color_b\";s:7:\"#004483\";s:25:\"button_hover_border_color\";s:7:\"#E69900\";s:27:\"form_field_background_color\";s:7:\"#001429\";s:23:\"form_field_border_color\";s:9:\"#414F6280\";s:26:\"body_typography_typography\";s:6:\"custom\";s:27:\"body_typography_font_family\";s:5:\"Inter\";s:25:\"body_typography_font_size\";a:3:{s:4:\"unit\";s:2:\"px\";s:4:\"size\";i:16;s:5:\"sizes\";a:0:{}}s:27:\"body_typography_font_weight\";s:3:\"400\";s:30:\"body_typography_text_transform\";s:4:\"none\";s:26:\"body_typography_font_style\";s:6:\"normal\";s:27:\"body_typography_line_height\";a:3:{s:4:\"unit\";s:2:\"em\";s:4:\"size\";d:1.4;s:5:\"sizes\";a:0:{}}s:32:\"body_typography_font_size_tablet\";a:3:{s:4:\"unit\";s:2:\"px\";s:4:\"size\";i:15;s:5:\"sizes\";a:0:{}}s:32:\"body_typography_font_size_mobile\";a:3:{s:4:\"unit\";s:2:\"px\";s:4:\"size\";i:14;s:5:\"sizes\";a:0:{}}s:41:\"form_field_box_shadow_box_shadow_position\";s:5:\"inset\";s:38:\"form_field_focus_box_shadow_box_shadow\";a:5:{s:10:\"horizontal\";i:0;s:8:\"vertical\";i:-1;s:4:\"blur\";i:0;s:6:\"spread\";i:0;s:5:\"color\";s:7:\"#8DC741\";}s:47:\"form_field_focus_box_shadow_box_shadow_position\";s:5:\"inset\";s:28:\"button_typography_typography\";s:6:\"custom\";s:29:\"button_typography_font_family\";s:5:\"Exo 2\";s:27:\"button_typography_font_size\";a:3:{s:4:\"unit\";s:2:\"px\";s:4:\"size\";i:14;s:5:\"sizes\";a:0:{}}s:29:\"button_typography_font_weight\";s:3:\"600\";s:32:\"button_typography_text_transform\";s:9:\"uppercase\";s:29:\"button_typography_line_height\";a:3:{s:4:\"unit\";s:2:\"em\";s:4:\"size\";i:1;s:5:\"sizes\";a:0:{}}s:32:\"button_typography_letter_spacing\";a:3:{s:4:\"unit\";s:2:\"px\";s:4:\"size\";i:0;s:5:\"sizes\";a:0:{}}s:25:\"button_background_color_b\";s:7:\"#E69900\";s:29:\"form_field_focus_border_color\";s:9:\"#FFAD0A80\";s:34:\"button_typography_font_size_tablet\";a:3:{s:4:\"unit\";s:2:\"px\";s:4:\"size\";i:13;s:5:\"sizes\";a:0:{}}s:34:\"button_typography_font_size_mobile\";a:3:{s:4:\"unit\";s:2:\"px\";s:4:\"size\";i:12;s:5:\"sizes\";a:0:{}}s:32:\"button_background_gradient_angle\";a:3:{s:4:\"unit\";s:3:\"deg\";s:4:\"size\";i:120;s:5:\"sizes\";a:0:{}}s:38:\"button_hover_background_gradient_angle\";a:3:{s:4:\"unit\";s:3:\"deg\";s:4:\"size\";i:120;s:5:\"sizes\";a:0:{}}s:21:\"space_between_widgets\";a:6:{s:6:\"column\";s:2:\"20\";s:3:\"row\";s:2:\"20\";s:8:\"isLinked\";b:1;s:4:\"unit\";s:2:\"px\";s:4:\"size\";i:14;s:5:\"sizes\";a:0:{}}s:16:\"link_hover_color\";s:7:\"#E69900\";s:28:\"h1_typography_letter_spacing\";a:3:{s:4:\"unit\";s:2:\"px\";s:4:\"size\";i:-1;s:5:\"sizes\";a:0:{}}s:32:\"form_label_typography_typography\";s:6:\"custom\";s:33:\"form_label_typography_font_family\";s:5:\"Exo 2\";s:31:\"form_label_typography_font_size\";a:3:{s:4:\"unit\";s:2:\"px\";s:4:\"size\";i:18;s:5:\"sizes\";a:0:{}}s:33:\"form_label_typography_font_weight\";s:3:\"600\";s:36:\"form_label_typography_text_transform\";s:9:\"uppercase\";s:33:\"form_label_typography_line_height\";a:3:{s:4:\"unit\";s:2:\"em\";s:4:\"size\";d:1.5;s:5:\"sizes\";a:0:{}}s:32:\"form_field_typography_typography\";s:6:\"custom\";s:33:\"form_field_typography_font_family\";s:5:\"Inter\";s:31:\"form_field_typography_font_size\";a:3:{s:4:\"unit\";s:2:\"px\";s:4:\"size\";i:16;s:5:\"sizes\";a:0:{}}s:33:\"form_field_typography_font_weight\";s:3:\"400\";s:36:\"form_field_typography_text_transform\";s:4:\"none\";s:32:\"form_field_typography_font_style\";s:6:\"normal\";s:33:\"form_field_typography_line_height\";a:3:{s:4:\"unit\";s:2:\"em\";s:4:\"size\";d:1.4;s:5:\"sizes\";a:0:{}}s:38:\"form_label_typography_font_size_tablet\";a:3:{s:4:\"unit\";s:2:\"px\";s:4:\"size\";i:17;s:5:\"sizes\";a:0:{}}s:38:\"form_label_typography_font_size_mobile\";a:3:{s:4:\"unit\";s:2:\"px\";s:4:\"size\";i:16;s:5:\"sizes\";a:0:{}}s:38:\"form_field_typography_font_size_tablet\";a:3:{s:4:\"unit\";s:2:\"px\";s:4:\"size\";i:15;s:5:\"sizes\";a:0:{}}s:38:\"form_field_typography_font_size_mobile\";a:3:{s:4:\"unit\";s:2:\"px\";s:4:\"size\";i:14;s:5:\"sizes\";a:0:{}}s:30:\"button_background_color_b_stop\";a:3:{s:4:\"unit\";s:1:\"%\";s:4:\"size\";i:50;s:5:\"sizes\";a:0:{}}s:37:\"button_box_shadow_box_shadow_position\";s:5:\"inset\";s:34:\"button_hover_box_shadow_box_shadow\";a:5:{s:10:\"horizontal\";i:0;s:8:\"vertical\";i:5;s:4:\"blur\";i:30;s:6:\"spread\";i:0;s:5:\"color\";s:52:\"rgba(238.9999999999999, 255, 81.99999999999999, 0.2)\";}s:28:\"button_background_color_stop\";a:3:{s:4:\"unit\";s:1:\"%\";s:4:\"size\";i:10;s:5:\"sizes\";a:0:{}}s:8:\"h6_color\";s:7:\"#FFAD0A\";s:21:\"body_background_color\";s:7:\"#000814\";s:23:\"button_background_color\";s:7:\"#004483\";s:39:\"button_hover_box_shadow_box_shadow_type\";s:3:\"yes\";s:32:\"colors_enable_styleguide_preview\";s:3:\"yes\";s:29:\"button_hover_background_color\";s:7:\"#E69900\";s:33:\"form_field_focus_background_color\";s:7:\"#001F3D\";}');
INSERT INTO `wp_79e54b1ec2_postmeta` VALUES ('1026','202','_wp_attached_file','2025/10/Group-65-1.png');
INSERT INTO `wp_79e54b1ec2_postmeta` VALUES ('1027','202','_elementor_import_session_id','6900f0e9a0d1d');
INSERT INTO `wp_79e54b1ec2_postmeta` VALUES ('1028','202','_wp_attachment_metadata','a:6:{s:5:\"width\";i:500;s:6:\"height\";i:500;s:4:\"file\";s:22:\"2025/10/Group-65-1.png\";s:8:\"filesize\";i:115769;s:5:\"sizes\";a:2:{s:6:\"medium\";a:5:{s:4:\"file\";s:22:\"Group-65-1-300x300.png\";s:5:\"width\";i:300;s:6:\"height\";i:300;s:9:\"mime-type\";s:9:\"image/png\";s:8:\"filesize\";i:37780;}s:9:\"thumbnail\";a:5:{s:4:\"file\";s:22:\"Group-65-1-150x150.png\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:9:\"image/png\";s:8:\"filesize\";i:11050;}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}');
INSERT INTO `wp_79e54b1ec2_postmeta` VALUES ('1029','202','_elementor_source_image_hash','04fccf529ea5de4b8d1fdda2a69216468708990e');
INSERT INTO `wp_79e54b1ec2_postmeta` VALUES ('1030','203','_wp_attached_file','2025/10/Group-66.png');
INSERT INTO `wp_79e54b1ec2_postmeta` VALUES ('1031','203','_elementor_import_session_id','6900f0e9a0d1d');
INSERT INTO `wp_79e54b1ec2_postmeta` VALUES ('1032','203','_wp_attachment_metadata','a:6:{s:5:\"width\";i:500;s:6:\"height\";i:500;s:4:\"file\";s:20:\"2025/10/Group-66.png\";s:8:\"filesize\";i:142314;s:5:\"sizes\";a:2:{s:6:\"medium\";a:5